# ARVO - AGI Reusable Variable Organiser, XML version
# Generates "defines.txt" from a source file in XML.
# John Nickerson, May 2002

from HTMLParser import HTMLParser
from sys import argv,exit

class ARVOParser(HTMLParser):
    def __init__(self,newline):
        self.vars,self.flags = [0],[0]
        self.newline = newline
        HTMLParser.__init__(self)

    def handle_startendtag(self,tag,attrs):
        item,value = None,None
        if tag == 'var':
            if len(attrs) == 1:
                self.outfile.write("#define %s v%s%s" % (attrs[0][1],str(self.vars[-1]),self.newline))
                self.vars[-1] += 1
            else:
                print "'var' requires one attribute"
        elif tag == 'flag':
            if len(attrs) == 1:
                self.outfile.write("#define %s f%s%s" % (attrs[0][1],str(self.flags[-1]),self.newline))
                self.flags[-1] += 1
            else:
                print "'flag' requires one attribute"
        elif tag == 'const':
            if len(attrs) == 2:
                for y in attrs:
                    if y[0] == 'name':
                        name = y[1]
                    elif y[0] == 'value':
                        value = y[1]
                    else:
                        print "Unrecognised attribute for 'const': %s" % y[0]
                outfile.write("#define %s %s%s" % (name,value,self.newline))
            else:
                print "'const' requires two attributes"
        elif tag == 'setvar':
            if len(attrs) == 1:
                self.vars[-1] = int(attrs[0][1])
            else:
                print "'setvar' requires one attribute"
        elif tag == 'setflag':
            if len(attrs) == 1:
                self.flags[-1] = int(attrs[0][1])
            else:
                print "'setflag' requires one attribute"
        else:
            pass

    def handle_starttag(self,tag,attrs):
        if tag == 'scope':
            self.vars += [self.vars[-1]]
            self.flags += [self.flags[-1]]
        else:
            pass

    def handle_endtag(self,tag):
        if tag == 'scope':
            self.vars = self.vars[:-1]
            self.flags = self.flags[:-1]
        else:
            pass

    def handle_data(self,data):
        self.outfile.write(data.lstrip())

    def process(self,infile,outfile="defines.txt"):
        self.infile = open(infile,"rb")
        self.outfile = open(outfile,"wb")
        for x in infile.readlines():
            self.feed(x)
        self.close()
        self.infile.close()
        self.outfile.close()

if __name__ == "__main__":
    import sys
    infile,outfile = "","defines.txt"
    newline = "\r\n"
    if len(sys.argv) > 1:
        for x in sys.argv[1:]:
            if x[0:2] == "-i":
                if len(x) != 2:
                    infile = x[2:]
            elif x[0:2] == "-o":
                if len(x) != 2:
                    outfile = x[2:]
            elif x[0:2] in ["-w","-d"]:
                newline = "\r\n"
            elif x[0:2] in ["-u","-l"]:
                newline = "\n"
        if infile == "":
            infile = raw_input("ARVO-XML source file name:")
        if outfile == "":
            outfile = raw_input("Output file name:")
        converter = ARVOParser(infile,outfile,newline)
        converter.process()
    else:
        help = """
ARVO-XML - AGI defines.txt Preprocessor

Usage:
arvoxml [options]

Valid options:
-i[filename]\tSet input file to 'filename'. Prompt if no filename given on
\t\tcommand line. Note: no spaces between '-i' and filename
\t\targument.
-o[filename]\tSet output file to 'filename'. Same behaviour as '-i' if no
\t\targument given. Defaults to "defines.txt".
-w or -d\tUse Windows/DOS-friendly newlines (CR-LF). (default)
-u or -l\tUse Unix/Linux newlines (LF).
"""
        print help
        a = raw_input("Press ENTER to quit.")

