# ARVO - AGI Reusable Variable Organiser
# John Nickerson (Mokalus of Borg), May 2002
# Produces "defines.txt" for an AGI game, from a script-like source.

import sys
from string import *

if len(sys.argv) < 2:
	filename = raw_input("ARVO source file name:")
else:
	filename = sys.argv[1]
try:
	arvofile = open(filename,"r")
except EnvironmentError:
	print "File not found:" + filename
	print "Check that the file exists, and that the name is correct."
	sys.exit(1)
if len(sys.argv) < 3:
	print "No output filename found: defaulting to 'defines.txt'."
	filename = "defines.txt"
else:
	filename = sys.argv[2]
try:
	definesfile = open(filename,"w")
except EnvironmentError:
	print "File not found:" + filename
	print "Check that the file exists, and that the name is correct."
	sys.exit(1)
del filename

scope = 0
mode = 'make'
nextvar = [0]
nextflag = [0]
for line in arvofile.readlines():
    line = line.strip()
    if line == "{%":
        mode = 'copy'
    elif line == "%}":
        mode = 'make'
    if mode == 'copy' and line not in ['{%','%}']:
        definesfile.write(line + "\n")
    else:
        line = split(line)
        if line == [] or line[0] == "%}":
            pass
        elif line[0] == "{":
            nextvar += [nextvar[scope]]
            nextflag += [nextflag[scope]]
            scope += 1
        elif line[0] == "}":
            nextvar = nextvar[:scope]
            nextflag = nextflag[:scope]
            scope -= 1
        elif line[0] == "var":
            if nextvar[scope] > 255:
                print "Out of space for variables."
            else:
                definesfile.write("#define " + line[1] + " v" + str(nextvar[scope]) + "\n")
                nextvar[scope] += 1
        elif line[0] == "flag":
            if nextflag[scope] > 255:
                print "Out of space for flags."
            else:
                definesfile.write("#define " + line[1] + " f" + str(nextflag[scope]) + "\n")
                nextflag[scope] += 1
        elif line[0] == "const":
            definesfile.write("#define " + line[1] + " " + line[2] + "\n")
        elif line[0] == "set":
            if line[1] == "var":
                nextvar[scope] = int(line[2])
            elif line[1] == "flag":
                nextflag[scope] = int(line[2])
        else:
            if mode != 'copy':
                print "Syntax error:" + join(line) + "\nContinuing."
#    print nextvar,nextflag
arvofile.close()
definesfile.close()
print "Done."
