#Converts AGI "view" resources to SCI format. Views must first be extracted from VOL files.

import sys

##def charlene(v,l):
##	"Return a string l chars long of chr(v)"
##	s = ""
##	for y in range(0,l):
##		s += chr(v)
##	return s

viewheader = {}
loopindex = []
loopheaders = []

agi = ' '
Totalcels = 0
if len(sys.argv) < 2:
	filename = raw_input("AGI view file name:")
	if filename == "":
		filename = "\\john\\games\\spaceq~1\\sq2agi~1\\src\\view\\view.1"
else:
	filename = sys.argv[1]
try:
	agiview = open(filename,"rb")
except EnvironmentError:
	print "File not found:" + filename
	print "Check that the file exists, and that the name is correct."
	sys.exit(1)
if len(sys.argv) < 3:
	filename = raw_input("SCI view file name:")
	if filename == "":
		filename = "\\john\\games\\spaceq~1\\sq2sci\\view\\view.001"
else:
	filename = sys.argv[2]
try:
	sciview = open(filename,"wb")
except EnvironmentError:
	print "File not found:" + filename
	print "Check that the file exists, and that the name is correct."
	sys.exit(1)
del filename

#Read the main header
agi = agiview.read(2) #Throwaway - unknown meaning (See AGI documentation)
viewheader['numloops'] = ord(agiview.read(1)) #Number of loops
print "Number of loops:", viewheader['numloops']
agi = agiview.read(2) #Description position (ls,ms)
viewheader['DescPos'] = ord(agi[0]) + 256 * ord(agi[1])
if viewheader['DescPos'] == 0:
	print "No description"
else:
	print "Description location:", viewheader['DescPos']

#Read each loop header
for x in range(0,viewheader['numloops']):
	agiview.seek(3+2*(x+1))
	agi = agiview.read(2)
	loopindex = loopindex + [ord(agi[0]) + 256*ord(agi[1])]
print loopindex

#Get cel data about each loop
for x in range(0,viewheader['numloops']):
	loopheaders = loopheaders + [{}]
	agiview.seek(loopindex[x])
	agi = agiview.read(1)
	loopheaders[x]['numcels'] = ord(agi)
	Totalcels = Totalcels + loopheaders[x]['numcels']
print "Total number of cels:", Totalcels
print loopheaders

#Read individual cel headers, and collect addresses
print "Cel offsets:"
cels=[]
for x in range(0,viewheader['numloops']):
	for y in range(1,loopheaders[x]['numcels']+1):
		cels = cels + [{}]
		cels[-1]['loopnum'] = x
		cels[-1]['celnum'] = y
		cels[-1]['celpos'] = loopindex[x]
		agiview.seek(loopindex[x] + 2*y - 1)
		agi = agiview.read(2)
		cels[-1]['celpos'] = cels[-1]['celpos'] + ord(agi[0]) + 256 * ord(agi[1])
		print cels[-1]['celpos'],
##print cels
#Read more cel header information
for x in range(0,Totalcels):
	agiview.seek(cels[x]['celpos'])
	cels[x]['x'] = ord(agiview.read(1)) # Width of the cel
	cels[x]['y'] = ord(agiview.read(1)) # Height of the cel
	agi = agiview.read(1) # Clear colour and mirroring
	cels[x]['clarity'] = ord(agi) & 15
	cels[x]['mirror'] = (ord(agi) & 240) / 16

#Read and translate the actual pictures
#### File header ####
writeviewresource = "\x80\x00" # SCI file type marker
writeviewresource += chr(viewheader['numloops'] % 256) + chr(viewheader['numloops'] / 256) # Number of loops in view
# Mirror info (gather from cels)
m = 0
cel = 0
for x in range(0,viewheader['numloops']):
	if ((cels[cel]['mirror'] & 8) == 8) and ((cels[cel]['mirror'] & x) != x):
		m = m | (2**x)
	cel += loopheaders[x]['numcels']
writeviewresource += chr(m % 256) + chr(m / 256)
del m, cel
writeviewresource += "\x00\x00\x00\x00" # Unknown bytes (possibly extra space for mirror flags)
# Loop indices
numcelspassed = 0
for x in range(0,viewheader['numloops']):
	# Index is 8 + 2*numloops + x*4 + 2*[number of cels so far]
	index = 8 + x*4 + 2*(viewheader['numloops'] + numcelspassed)
	writeviewresource += chr(index % 256) + chr(index / 256)
	numcelspassed += loopheaders[x]['numcels']
del numcelspassed
sciview.write(writeviewresource)
del writeviewresource

writecellist = []
for x in range(0,viewheader['numloops']):
	# [Number of cels in loop] then [unknown]
	writecellist += [chr(loopheaders[x]['numcels'] % 256) + chr(loopheaders[x]['numcels'] / 256) + "\x00\x00"]

writeimagecels = ""
newlocs = {}
for x in range(0,Totalcels):
	xPos = 0
	YPos = 0
	FileIndex = cels[x]['celpos'] + 3
	if (cels[x]['celpos'] in newlocs.keys()):
		writecellist[cels[x]['loopnum']] += newlocs[cels[x]['celpos']]
	else: # (not mirrored)
		index = 8 + 6*viewheader['numloops'] + 2*Totalcels + len(writeimagecels)
		codedindex = chr(index % 256) + chr(index / 256)
		writecellist[cels[x]['loopnum']] += codedindex
		# record codedindex for later use
		newlocs[cels[x]['celpos']] = codedindex
		del codedindex

		writeimagecels += chr((cels[x]['x'] * 2) % 256) + chr((cels[x]['x'] * 2) / 256)
		writeimagecels += chr(cels[x]['y'] % 256) + chr(cels[x]['y'] / 256)
		writeimagecels += "\x00\x00"  #(x,y)-placement modifier. Unused in AGI.
		writeimagecels += chr(cels[x]['clarity']) + "\x00" #Clear colour for this cel.
##		printbuf = ""
		while YPos != cels[x]['y'] or xPos != 0:
			agiview.seek(FileIndex)
			agi = agiview.read(1)
			FileIndex = FileIndex + 1
			if ord(agi) == 0:
				Length = (2*cels[x]['x'] - xPos)
##				printbuf += charlene(cels[x]['clarity'] + 96,Length/16) + "\n"
				while Length >= 16:
					writeimagecels += chr(cels[x]['clarity'] | 240)
					Length -= 15
				if Length > 0:
					writeimagecels += chr(cels[x]['clarity'] | 16*Length)
				writeimagecels += "\x00"
				xPos = 0
				YPos = YPos + 1
			else:
				Length = (ord(agi) & 15) * 2
				Colour = (ord(agi) & 240) / 16
##				printbuf += charlene(Colour + 96, Length)
				xPos = xPos + Length
				while Length >= 16:
					writeimagecels += chr(Colour | 240)
					Length -= 15
				if Length > 0:
					writeimagecels += chr(Colour | 16*Length)
##		print printbuf
##		agi = raw_input("")
	#print int((x/Totalcels)*100)"%"

for x in writecellist:
	sciview.write(x)
del writecellist

sciview.write(writeimagecels)
del writeimagecels

if len(sys.argv) < 3:
	agi = raw_input("\nDone. Press ENTER to finish.")
del agiview, sciview
