class FileStreamer:
    def __init__(self,filename):
        self.file = open(filename,"rb")
        self.bookmark = 0

    def get(self,n):
        return self.file.read(n)

    def step(self,n):
        self.file.seek(n,1)

    def setbook(self):
        self.bookmark = self.file.tell()

    def gobook(self):
        self.file.seek(self.bookmark)

    def close(self):
        self.file.close()

class FileBuffer:
    def __init__(self,filename):
        self.file = open(filename,"wb")

    def put(self,s):
        self.file.write(s)

    def close(self):
        self.file.close()

def abscoords(x,y):
    "Create sci 3-byte absolute coordinates from two numbers."
    xbyte = x % 256
    ybyte = y % 256
    prebyte = (y/256)+(x/256)*16
    return chr(prebyte)+chr(xbyte)+chr(ybyte)

def sign(aNumber):
    "Returns -1 for numbers <0, 0 for 0 and 1 for >0."
    if aNumber == 0:
        return 0
    elif aNumber > 0:
        return 1
    elif aNumber < 0:
        return -1

def ceil(aNumber):
    if int(aNumber) == aNumber:
        return aNumber
    else:
        return int(aNumber)+1

def agiround(aNumber, dirn):
    if (dirn < 0):
        if (aNumber - int(aNumber)) <= 0.501:
            return int(aNumber)
        else:
            return ceil(aNumber)
    else:
        if (aNumber - int(aNumber)) < 0.499:
            return int(aNumber)
        else:
            return ceil(aNumber)

def agi_line(x1,y1,x2,y2):
    """Returns a sequence of coordinates that make up an AGI line.

    Designed to be called with the upper-left corner first. """
    line = []
    height = (y2 - y1)
    width = (x2 - x1)
    if height == 0:
        addX = height
    else:
        addX = float(width)/abs(height)
    if width == 0:
        addY = width
    else:
        addY = float(height)/abs(width)
    if (abs(width) > abs(height)):
        y = y1
        addX = sign(width)
        x = x1
        while x < x2:
            xcoord = agiround(x,addX)*2
            ycoord = agiround(y,addY)
            if x1 < x2:
                line += [(xcoord,ycoord),(xcoord+1,ycoord)]
            else:
                line += [(xcoord+1,ycoord),(xcoord,ycoord)]
            y += addY
            x += addX
        if x1 < x2:
            line += [(x2*2,y2),(x2*2+1,y2)]
        else:
            line += [(x2*2+1,y2),(x2*2,y2)]
    else:
        x = x1
        addY = sign(height)
        y = y1
        while y < y2:
            xcoord = agiround(x,addX)*2
            ycoord = agiround(y,addY)
            if x1 < x2:
                line += [(xcoord,ycoord),(xcoord+1,ycoord)]
            else:
                line += [(xcoord+1,ycoord),(xcoord,ycoord)]
            x += addX
            y += addY
        if x1 < x2:
            line += [(x2*2,y2),(x2*2+1,y2)]
        else:
            line += [(x2*2+1,y2),(x2*2,y2)]
    return line

def dist(a,b,n):
    if a[0] == b[0]:
        return abs(a[1] - b[1])
    if a[1] == b[1]:
        return abs(a[0] - b[0])
    if abs(a[0] - b[0]) == abs(a[1] - b[1]):
        return abs(a[0] - b[0])
    return n+1

def compress(list,n):
    newlist = [list[0]]
    oldpoint = list[0]
    for point in list:
        if dist(newlist[-1],point,n) > n:
            newlist += [oldpoint]
        oldpoint = point
    newlist += [oldpoint]
    return newlist

def step(line):
    "Converts a sequence of absolute points to a sequence of relative points."
    newline = [line[0]]
    lastpoint = line[0]
    for point in line[1:]:
        relpoint = (point[0] - lastpoint[0],point[1] - lastpoint[1])
        lastpoint = point
        newline += [relpoint]
    return newline
    
def short_coords(xd,yd):
    "Returns an SCI encoding of a very short line."
    if xd < 0:
        xd = abs(xd)+8
    if yd < 0:
        yd = abs(yd)+8
    return chr(xd*16 + yd)

def mid_coords(xd,yd):
    "Returns an SCI encoding of a medium line."
    return "\x00"*2

def sci_short_line(x1,y1,x2,y2):
    "Returns an SCI picture tiny-lines sequence for a straight line."
#    points = step(compress(agi_line(x1,y1,x2,y2),7))
    if abs(x2-x1) > abs(y2-y1):
        if x1 < x2:
            points = step(agi_line(x1,y1,x2,y2))
        else:
            points = step(agi_line(x2,y2,x1,y1))
    else:
        if y1 < y2:
            points = step(agi_line(x1,y1,x2,y2))
        else:
            points = step(agi_line(x2,y2,x1,y1))
    line = "\xF7%s" % apply(abscoords,points[0])
    for point in points[1:]:
        line += apply(short_coords,point)
    return line

def sci_mid_line(x1,y1,x2,y2):
    "Returns an SCI picture medium-lines sequence for a straight line."
#    points = step(compress(agi_line(x1,y1,x2,y2),255))
    points = step(agi_line(x1,y1,x2,y2))
    line = "\xF5%s" % apply(abscoords,points[0])
    for point in points[1:]:
        line += apply(mid_coords,point)
    return line

def sci_long_line(x1,y1,x2,y2):
    "Returns an SCI picture long-lines sequence for a straight line."
#    points = step(compress(agi_line(x1,y1,x2,y2),4095))
    if abs(x2-x1) > abs(y2-y1):
        if x1 < x2:
            points = agi_line(x1,y1,x2,y2)
        else:
            points = agi_line(x2,y2,x1,y1)
    else:
        if y1 < y2:
            points = agi_line(x1,y1,x2,y2)
        else:
            points = agi_line(x2,y2,x1,y1)
    line = "\xF6"
    for point in points:
        line += apply(abscoords,point)
    return line

if __name__ == "__main__":
    print agi_line(42,100,0,0)
