import support
import operator

class Pic2Pic:
    def __init__(self,infile,outfile,clone,fill):
        self.agifile = support.FileStreamer(infile)
        self.scifile = support.FileBuffer(outfile)
        self.control = [0,31,4,2,0,0,0,0,0,0,0,0,0,0,0,0]
        self.priority = [0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,31]
        self.visual = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,31]
        self.splatter = 0
        self.penstyle = 0
##        if clone == 2: print "Advanced cloning"
##        elif clone == 1: print "Basic cloning"
##        else: print "No cloning"
        self.clone = clone
        self.dofill = fill

    def process(self):
	self.scifile.put(reduce(operator.add,map(chr,[129,0,240,0,242,15,251,15,246,0,0,168,16,64,168,248,0,1,169,241,243,252])))
        while 1:
            func = self.agifile.get(1)
            if func == "\xF0":
                self.chvis()
            elif func == "\xF1":
                self.disvis()
            elif func == "\xF2":
                self.chpri()
            elif func == "\xF3":
                self.dispri()
            elif func in ["\xF4","\xF5"]:
                if self.clone == 2:
                    self.clonecorner(func == "\xF4")
                elif self.clone == 1:
                    self.agifile.setbook()
                    self.corner(func == "\xF4",0)
                    self.agifile.gobook()
                    self.corner(func == "\xF4",1)
                else:
                    self.corner(func == "\xF4",0)
            elif func == "\xF6":
                if self.clone == 2:
                    self.cloneabs()
                elif self.clone == 1:
                    self.agifile.setbook()
                    self.absline(0)
                    self.agifile.gobook()
                    self.absline(1)
                else:
                    self.absline(0)
            elif func == "\xF7":
                if self.clone == 2:
                    self.clonerel()
                elif self.clone == 1:
                    self.agifile.setbook()
                    self.relline(0)
                    self.agifile.gobook()
                    self.relline(1)
                else:
                    self.relline(0)
            elif func == "\xF8":
                if self.dofill:
                    self.fill()
            elif func == "\xF9":
                self.chpen()
            elif func == "\xFA":
                self.agifile.setbook()
                self.plot(0)
                if self.clone != 0:
                    self.agifile.gobook()
                    self.plot(1)
            elif func == "\xFF":
                self.eof()
                break
        self.agifile.close()
        self.scifile.close()
        
    def chvis(self):
        self.scifile.put("\xF0")
        args = self.agifile.get(1)
        self.scifile.put(chr(self.visual[ord(args)]))

    def disvis(self):
        self.scifile.put("\xF1")

    def chpri(self):
        self.scifile.put("\xF3\xFC")
        args = self.agifile.get(1)
        if ord(args) <= 3:
            self.scifile.put("\xFB")
            self.scifile.put(chr(self.control[ord(args)]))
        else:
            self.scifile.put("\xF2")
            self.scifile.put(chr(self.priority[ord(args)]))

    def dispri(self):
        self.scifile.put("\xF3\xFC")

    def corner(self,isycorn,xoff):
        self.scifile.put("\xF6")
        if isycorn: flipflop = 0
        else: flipflop = 1
        args = self.agifile.get(2)
        xcoord,ycoord = ord(args[0])*2+xoff,ord(args[1])
        self.scifile.put(support.abscoords(xcoord,ycoord))
        while 1:
            args = self.agifile.get(1)
            if ord(args) >= 240:
                self.agifile.step(-1)
                break
            if flipflop == 0:
                ycoord = ord(args)
            else:
                xcoord = ord(args)*2+xoff
            flipflop = 1-flipflop
            self.scifile.put(support.abscoords(xcoord,ycoord))

    def clonecorner(self,isycorn):
        if isycorn: flipflop = 0
        else: flipflop = 1
        args = self.agifile.get(2)
        xcoord,ycoord = ord(args[0]),ord(args[1])
        newx,newy = xcoord,ycoord
        while 1:
            args = self.agifile.get(1)
            if ord(args) >= 240:
                self.agifile.step(-1)
                break
            if flipflop == 0:
                newy = ord(args)
            else:
                newx = ord(args)
            flipflop = 1-flipflop
            self.scifile.put(support.sci_short_line(xcoord,ycoord,newx,newy))
            xcoord,ycoord = newx,newy

    def absline(self,xoff):
        self.scifile.put("\xF6")
        while 1:
            args = self.agifile.get(2)
            if ord(args[0]) >= 240:
                self.agifile.step(-2)
                break
            xcoord = ord(args[0])*2+xoff
            ycoord = ord(args[1])
            self.scifile.put(support.abscoords(xcoord,ycoord))

    def cloneabs(self):
        xcoord,ycoord = -1,-1
        while 1:
            args = self.agifile.get(2)
            if ord(args[0]) >= 240:
                self.agifile.step(-2)
                break
            newx = ord(args[0])
            newy = ord(args[1])
            if xcoord >= 0 and ycoord >= 0:
                self.scifile.put(support.sci_short_line(xcoord,ycoord,newx,newy))
            xcoord,ycoord = newx,newy

    def relline(self,xoff):
        self.scifile.put("\xF5")
        args = self.agifile.get(2)
        xcoord = ord(args[0])*2+xoff
        ycoord = ord(args[1])
        self.scifile.put(support.abscoords(xcoord,ycoord))
        while 1:
            args = self.agifile.get(1)
            if ord(args) >= 240:
                self.agifile.step(-1)
                break
            xval = 2*((ord(args) & 112) / 16)
            xchr = chr(xval)
            if ord(args) > 128:
                xval = -xval
                xchr = chr(xval & 255)
            yval = ord(args) & 7
            ychr = chr(yval)
            if ord(args) & 8 > 0:
                ychr = chr(yval | 128)
                yval = -yval
            if ord(ychr) >= 240:
                self.scifile.put("\xF5%s" % support.abscoords(xcoord,ycoord))
            xcoord += xval
            ycoord += yval
            self.scifile.put("%s%s" % (ychr,xchr))
            
    def clonerel(self):
        args = self.agifile.get(2)
        xcoord = ord(args[0])
        ycoord = ord(args[1])
        while 1:
            args = self.agifile.get(1)
            if ord(args) >= 240:
                self.agifile.step(-1)
                break
            xval = ((ord(args) & 112) / 16)
            if ord(args) > 128:
                xval = -xval
            yval = ord(args) & 7
            if ord(args) & 8 > 0:
                yval = -yval
            newx = xcoord + xval
            newy = ycoord + yval
            self.scifile.put(support.sci_short_line(xcoord,ycoord,newx,newy))
            xcoord,ycoord = newx,newy
            
    def fill(self):
        self.scifile.put("\xF8")
        while 1:
            args = self.agifile.get(2)
            if ord(args[0]) >= 240:
                self.agifile.step(-2)
                break                
            xcoord = ord(args[0]) * 2
            ycoord = ord(args[1])
            self.scifile.put(support.abscoords(xcoord,ycoord))

    def chpen(self):
        self.scifile.put("\xF9")
        args = self.agifile.get(1)
        self.splatter = (ord(args) & 2**5)
        self.scifile.put(args)

    def plot(self,xoff):
        self.scifile.put("\xFA")
        if self.splatter: # args in threes
            while 1:
                args = self.agifile.get(3)
                if ord(args[0]) >= 240:
                    self.agifile.step(-3)
                    break
                self.scifile.put(args[0])
                xcoord = ord(args[1])*2+xoff
                ycoord = ord(args[2])
                self.scifile.put(support.abscoords(xcoord,ycoord))
        else: #args in twos
            while 1:
                args = self.agifile.get(2)
                if ord(args[0]) >= 240:
                    self.agifile.step(-2)
                    break
                xcoord = ord(args[0])*2+xoff
                ycoord = ord(args[1])
                self.scifile.put(support.abscoords(xcoord,ycoord))

    def eof(self):
        self.scifile.put("\xFF")

if __name__ == "__main__":
    from sys import argv
    clone,fill = 0,0
    infile,outfile = "",""
    if len(argv) > 1:
        for x in argv[1:]:
            if x[0:2] == "-i":
                if len(x) != 2:
                    infile = x[2:]
            elif x[0:2] == "-o":
                if len(x) != 2:
                    outfile = x[2:]
            elif x[0:2] == "-c":
                if x[-1] in map(str,range(0,10)):
                    clone = int(x[-1])
                else:
                    clone = 1
            elif x[0:2] == "-f":
                fill = -1
        if infile == "":
            infile = raw_input("Input picture file name:")
        if outfile == "":
            outfile = raw_input("Output picture file name:")
        converter = Pic2Pic(infile,outfile,clone,fill)
        converter.process()
    else:
        help = """
PIC2PIC - AGI to SCI picture resource converter

Usage:
pic2pic [options]

Valid options:
-i[filename]\tSet input file to 'filename'. Prompt if no filename given on
\t\tcommand line. Note: no spaces between '-i' and filename argument.
-o[filename]\tSet output file to 'filename'. Same behaviour as '-i' if no
\t\targument given.
-c[n]\t\t'Clone mode', where 'n' is one of the following:
\t\t0: No cloning
\t\t1: Simple cloning (default when no argument given)
\t\t2: Advanced cloning
\t\tSets the level of accuracy for rendering the AGI picture in SCI.
-f\t\tEnable fill: turns on translating of 'fill area' commands.
\t\tFills are off by default because fills in non-clone mode will\n\t\toverflow.
"""
        print help
        a = raw_input("Press ENTER to quit.")
