import sys

def makeabscoords(x,y):
	"Create sci 3-byte absolute coordinates from two numbers."
	xbyte = x % 256
	ybyte = y % 256
	prebyte = (y/256)+(x/256)*16
	return chr(prebyte)+chr(xbyte)+chr(ybyte)

def bruce(numlist):
	"Returns a string built from decimal ASCII codes."
	s = ""
	for n in numlist:
		s = s + chr(n)
	return s

if len(sys.argv) < 2:
	filename = raw_input("AGI picture file name:")
else:
	filename = sys.argv[1]
try:
	agipic = open(filename,"rb")
except EnvironmentError:
	print "File not found:" + filename
	print "Check that the file exists, and that the name is correct."
	sys.exit(1)
if len(sys.argv) < 3:
	filename = raw_input("SCI picture file name:")
else:
	filename = sys.argv[2]
try:
	scipic = open(filename,"wb")
except EnvironmentError:
	print "File not found:" + filename
	print "Check that the file exists, and that the name is correct."
	sys.exit(1)
del filename

ControlColours = [0,31,4,2]
UnknownCodes = []
splatter = 0
penstyle = 0
writebuf = ""
readbuf = ""
maxbuflen = 1000

# Print a standard lower margin command sequence.
margin = [129,0,240,0,242,15,251,15,246,0,0,168,16,64,168,248,0,1,169,241,243,252]
writebuf = writebuf + bruce(margin)
del margin

readbuf = readbuf + agipic.read(maxbuflen)
while ord(readbuf[0]) < 255:
	if readbuf[0] == "\xF0": # Change visual colour
		print " CVEVD",
		if len(readbuf) < 2:
			readbuf = readbuf + agipic.read(maxbuflen)
		writebuf = writebuf + readbuf[0]
		print "(" + str(ord(readbuf[1])) + ") "
		if ord(readbuf[1]) == 15:
			writebuf = writebuf + chr(31) # White is not colour 15
		else:
			writebuf = writebuf + readbuf[1]
		readbuf = readbuf[2:]
	elif readbuf[0] == "\xF1": # Disable visual draw
		print " DISVD "
		writebuf = writebuf + readbuf[0]
		readbuf = readbuf[1:]
	elif readbuf[0] == "\xF2": # Change priority colour
		print " CPEPD",
		if len(readbuf) < 2:
			readbuf = readbuf + agipic.read(maxbuflen)
		# First, disable both priority and control drawing
		writebuf = writebuf + "\xF3\xFC"
		print "(" + str(ord(readbuf[1])) + ")"
		if ord(readbuf[1]) <= 3:
			writebuf = writebuf + "\xFB" # Enable Control draw
			sci = chr(ControlColours[ord(readbuf[1])])
		else:
			writebuf = writebuf + "\xF2" # Enable Priority draw
			if ord(readbuf[1]) == 15:
				sci = chr(31) # White is not colour 15
			else:
				sci = chr(ord(readbuf[1])-3) # SCI priority bands are different
		writebuf = writebuf + sci
		readbuf = readbuf[2:]
	elif readbuf[0] == "\xF3": # Disable Priority Draw
		print " DISPD "
		writebuf = writebuf + "\xF3\xFC" # Disable Control draw too, just in case
		readbuf = readbuf[1:]
	elif (readbuf[0] == "\xF4") or (readbuf[0] == "\xF5"):
		if readbuf[0] == "\xF4":
			print " YCORN",
			flipflop = 0
		if readbuf[0] == "\xF5":
			print " XCORN",
			flipflop = 1
		writebuf = writebuf + "\xF6" # Long lines
		holdbuf = "\xF6" # For doubling
		readbuf = readbuf[1:]
		if len(readbuf) < 2:
			readbuf = readbuf + agipic.read(maxbuflen)
		xcoord = ord(readbuf[0])*2
		print "(" + str(ord(readbuf[0])) + ",",
		ycoord = ord(readbuf[1])
		print str(ord(readbuf[1])) + ")",
		writebuf = writebuf + makeabscoords(xcoord,ycoord)
		holdbuf = holdbuf + makeabscoords(xcoord+1,ycoord)
		readbuf = readbuf[2:]
		print "(",
		while 1:
			if len(readbuf) < 1:
				readbuf = readbuf + agipic.read(maxbuflen)
			if ord(readbuf[0]) >= 240:
				break
			if flipflop == 0:
				ycoord = ord(readbuf[0])
			else:
				xcoord = ord(readbuf[0])*2
			flipflop = 1-flipflop
			writebuf = writebuf + makeabscoords(xcoord,ycoord)
			holdbuf = holdbuf + makeabscoords(xcoord+1,ycoord)
			print str(ord(readbuf[0])) + " ",
			readbuf = readbuf[1:]
		print ")"
		writebuf = writebuf + holdbuf
	elif readbuf[0] == "\xF6": # Draw Long (absolute) Lines
		print " ABSLN",
		writebuf = writebuf + "\xF6"
		holdbuf = ""
		printbuf = ""
		readbuf = readbuf[1:]
		while 1:
			if len(readbuf) < 3:
				readbuf = readbuf + agipic.read(maxbuflen)
			if ord(readbuf[0]) >= 240:
				break
			holdbuf = holdbuf + readbuf[0]
			printbuf = printbuf + "(" + str(ord(readbuf[0])) + ","
			xcoord = ord(readbuf[0])*2
			holdbuf = holdbuf + readbuf[1]
			ycoord = ord(readbuf[1])
			writebuf = writebuf + makeabscoords(xcoord,ycoord)
			printbuf = printbuf + str(ord(readbuf[1]))+")"
			readbuf = readbuf[2:]
		writebuf = writebuf + "\xF6"
		while len(holdbuf) > 0:
			xcoord = (ord(holdbuf[0])*2)+1
			ycoord = ord(holdbuf[1])
			writebuf = writebuf + makeabscoords(xcoord,ycoord)
			holdbuf = holdbuf[2:]
		print printbuf
	elif readbuf[0] == "\xF7": # Draw Short (relative) Lines
		print " RELLN",
		writebuf = writebuf + "\xF5" # Medium relative lines - the easiest way to make sure the x-doubling doesn't overflow.
		holdbuf = ""
		readbuf = readbuf[1:]
		if len(readbuf) < 2:
			readbuf = readbuf + agipic.read(maxbuflen)
		holdbuf = holdbuf + readbuf[0]
		print "(" + str(ord(readbuf[0])) + ",",
		xcoord = ord(readbuf[0])*2
		holdbuf = holdbuf + readbuf[1]
		print str(ord(readbuf[1])) + ")",
		ycoord = ord(readbuf[1])
		writebuf = writebuf + makeabscoords(xcoord,ycoord)
		printbuf = ""
		readbuf = readbuf[2:]
		while 1:
			if len(readbuf) < 2:
				readbuf = readbuf + agipic.read(maxbuflen)
			if ord(readbuf[0]) >= 240:
				break
			holdbuf = holdbuf + readbuf[0]
			xval = 2 * ((ord(readbuf[0]) & 112) / 16)
			xchr = chr(xval)
			if ord(readbuf[0]) > 128:
				printbuf = printbuf + "(-"
				xval = -xval
				xchr = chr(xval & 255)
			else:
				printbuf = printbuf + "(+"
			printbuf = printbuf + str((ord(readbuf[0]) & 112) / 16)
			yval = ord(readbuf[0]) & 7
			ychr = chr(yval)
			if ord(readbuf[0]) & 8 > 0:
				printbuf = printbuf + ",-"
				ychr = chr(yval | 128)
				yval = -yval
			else:
				printbuf = printbuf + ",+"
			if ord(ychr) >= 240:
				writebuf = writebuf + "\xF5" + makeabscoords(xcoord,ycoord)
			xcoord = xcoord + xval
			ycoord = ycoord + yval
			writebuf = writebuf + ychr + xchr
			printbuf = printbuf + str(ord(readbuf[0]) & 7) + ")"
			readbuf = readbuf[1:]
		print printbuf
		holdbuf = holdbuf + "\xFF\xFF"
		writebuf = writebuf + "\xF5"
		xcoord = ord(holdbuf[0])*2+1
		ycoord = ord(holdbuf[1])
		writebuf = writebuf + makeabscoords(xcoord,ycoord)
		holdbuf = holdbuf[2:]
		while len(holdbuf) > 0:
			if ord(holdbuf[0]) >= 240:
				break
			xval = 2 * ((ord(holdbuf[0]) & 112) / 16)
			xchr = chr(xval)
			if ord(holdbuf[0]) > 128:
				xval = -xval
				xchr = chr(xval & 255)
			yval = ord(holdbuf[0]) & 7
			ychr = chr(yval)
			if ord(holdbuf[0]) & 8 > 0:
				ychr = chr(yval | 128)
				yval = -yval
			if ord(ychr) >= 240:
				writebuf = writebuf + "\xF5" + makeabscoords(xcoord,ycoord)
			xcoord = xcoord + xval
			ycoord = ycoord + yval
			writebuf = writebuf + ychr + xchr
			holdbuf = holdbuf[1:]
	elif readbuf[0] == "\xF8": # Fill Area
		print " FILLP",
		writebuf = writebuf + readbuf[0]
		printbuf = ""
		readbuf = readbuf[1:]
		while 1:
			if len(readbuf) < 2:
				readbuf = readbuf + agipic.read(maxbuflen)
			if ord(readbuf[0]) >= 240:
				break
			printbuf = printbuf + "("+str(ord(readbuf[0]))+","
			xcoord = ord(readbuf[0])*2
			printbuf = printbuf + str(ord(readbuf[1]))+")"
			ycoord = ord(readbuf[1])
			writebuf = writebuf + makeabscoords(xcoord,ycoord)
			readbuf = readbuf[2:]
		print printbuf
	elif readbuf[0] == "\xF9": # Change Plotting Pen
		printbuf = " CHPEN ("
		if len(readbuf) < 1:
			readbuf = readbuf + agipic.read(maxbuflen)
		splatter = (ord(readbuf[1]) & 2**5)
		if (ord(readbuf[1]) & 32):
			printbuf = printbuf + "pattern "
		else:
			printbuf = printbuf + "solid "
		printbuf = printbuf + str(ord(readbuf[1]) & 7)
		writebuf = writebuf + readbuf[0:2]
		readbuf = readbuf[2:]
		print printbuf
	elif readbuf[0] == "\xFA": # Plot With Pen
		print " PLOTP",
		if len(readbuf) < 2:
			readbuf = readbuf + agipic.read(maxbuflen)
		writebuf = writebuf + "\xFA"
		printbuf = ""
		readbuf = readbuf[1:]
		if len(readbuf) < 2:
			readbuf = readbuf + agipic.read(maxbuflen)
		if splatter: # Get arguments in threes.
			while ord(readbuf[0]) < 240:
				if len(readbuf) < 4:
					readbuf = readbuf + agipic.read(maxbuflen)
				writebuf = writebuf + readbuf[0]
				printbuf += "(" + str(ord(readbuf[0])) + ","
				printbuf += str(ord(readbuf[1])) + ","
				xcoord = ord(readbuf[1])*2
				printbuf += str(ord(readbuf[2])) + ")"
				ycoord = ord(readbuf[2])
				writebuf = writebuf + makeabscoords(xcoord,ycoord) + readbuf[0] + makeabscoords(xcoord+1,ycoord)
				readbuf = readbuf[3:]
		else: # Get arguments in twos
			while ord(readbuf[0]) < 240:
				if len(readbuf) < 3:
					readbuf = readbuf + agipic.read(maxbuflen)
				printbuf += "(" + str(ord(readbuf[0])) + ","
				xcoord = ord(readbuf[0])*2
				printbuf += str(ord(readbuf[1])) + ")"
				ycoord = ord(readbuf[1])
				writebuf = writebuf + makeabscoords(xcoord,ycoord) + makeabscoords(xcoord+1,ycoord)
				readbuf = readbuf[2:]
		print printbuf
	elif readbuf[0] == "\xFF":
		print " EOF "
		writebuf = writebuf + readbuf[0]
		break
	else:
		print "(unknown " + str(ord(readbuf[0]) - 240) + ")"
		if len(filter(lambda x: x == hex(ord(readbuf[0])), UnknownCodes)) == 0:
			UnknownCodes = UnknownCodes + [hex(ord(readbuf[0]))]
		if len(readbuf) < 2:
			readbuf = readbuf + agipic.read(maxbuflen)
		readbuf = readbuf[1:]
		while ord(readbuf[0]) < 240:
			readbuf = readbuf[1:]
			if len(readbuf) < 2:
				readbuf = readbuf + agipic.read(maxbuflen)
	while len(writebuf) > maxbuflen:
		scipic.write(writebuf[:maxbuflen])
		writebuf = writebuf[maxbuflen:]
	if len(readbuf) < 1:
		readbuf = readbuf + agipic.read(maxbuflen)
else:
	writebuf = writebuf + "\xFF"
	print " EOF "
scipic.write(writebuf)
del agipic
del scipic
if len(UnknownCodes) > 0:
	print "Encountered unknown codes:" + str(UnknownCodes)
else:
	print "Done."
if len(sys.argv) < 2:
	printbuf = raw_input('Press ENTER key to exit.')
