$NewInterfaceVersion = "2.5";
// by |HH|BigBunny
// ==================================
// www.planetstarsiege.com/bigbunny
// ==================================
// Mail me at: bigbunny@planetstarsiege.com

function NewInterface::init()
{
	if ($Presto::version == "") // no pp installed
	{
		echo("========= PRESTO PACK REQUIRED FOR NEWINTERFACE ==========");
		return;
	}

	//File::findFirst("NewInterface.vol") must be true, that was a condition for calling init
	newObject("NewInterface", SimVolume, File::findFirst("*NewInterface.vol"));

	//newopts
	if ($NewOpts::version != "") NewOpts::register("NewInterface", "gui\\NewInterface.gui", "", "", TRUE);
	
	// load scripts
	for (%file = File::FindFirst("NewInterface\\*.cs"); %file != ""; %file = File::FindNext("NewInterface\\*.cs")) if (File::getBase(%file) != "Schedule") exec(%file);
	if (isFile("config\\writer\\schedule.cs")) include("writer\\Schedule.cs");
	else if (isFile("config\\presto\\schedule.cs")) include("Presto\\Schedule.cs");
	else exec("Newinterface\\schedule.cs");

	if (isFile("config\\Passwords.cs")) exec("Passwords.cs");
	
	// oops :)
	if ($pref::StartAllwaysFullScreen == true) $pref::StartAlwaysFullScreen = true;
	deleteVariables("*StartAllwaysFullScr*");

	// variable setup:
	if ($pref::DefaultRecordDemo != false && $pref::DefaultRecordDemo != true) $pref::DefaultRecordDemo = false;
	if ($pref::PlayGuiStoring != false && $pref::PlayGuiStoring != true) $pref::PlayGuiStoring = true;
	if ($pref::StartAlwaysFullScreen != false && $pref::StartAlwaysFullScreen != true) $pref::StartAlwaysFullScreen = false;
	if ($pref::NewDemoMissionChange != false && $pref::NewDemoMissionChange != true) $pref::NewDemoMissionChange = false;
	if ($pref::ConfirmQuit != false && $pref::ConfirmQuit != true) $pref::ConfirmQuit = true;
	if ($pref::MainMenuCdOverride != false && $pref::MainMenuCdOverride != true) $pref::MainMenuCdOverride = true;
	if ($pref::ConsoleEnabled != false && $pref::ConsoleEnabled != true) $pref::ConsoleEnabled = true;
	if ($pref::startMapMusicOnLoad != false && $pref::startMapMusicOnLoad != true) $pref::startMapMusicOnLoad = true;
	if ($pref::consoleColor == "") $pref::consoleColor = 0;

	// Play with these, I didnt have time to go into this too much:
	addConsoleColor("White", "0 0 0");
	addConsoleColor("Yellow", "0 0 1");
	addConsoleColor("Purple", "0 1 0");
	addConsoleColor("Red", "0 1 1");
	addConsoleColor("Cyan", "1 0 0");
	addConsoleColor("Green", "100 200 25");
	addConsoleColor("Grape Pink", "0 155 155");
	addConsoleColor("Green (Light)", "155 0 155");
	addConsoleColor("Blue (Dark)", "1 19 200");
	addConsoleColor("Orange", "0 125 1 ");
	addConsoleColor("Blue (Light)", "155 155 0");
	addConsoleColor("Grey", "200 180 160");


	if (!$pref::ConsoleEnabled) Console::Enable(false);
	$LastRecRoot = "";
	$NewInterface::installed = true;
	$HostingGame = false;
	$Console::Prompt = "> ";
	$ForceNoPlayGuiSave = false;
	$InstallChat800 = false;
	$FirstTimeMainMenuLoaded = true;
	$InstallChat1024 = false;
	$SmartCon::status = false;
	$Console::ForeRGB = $ConsoleColor[$pref::consoleColor]; // need to be after the adding process

	// attaching events:
	if ($connectAddress == "") Event::Attach(eventConnectionRejected, SmartCon::failedProcedure);
	else Event::Attach(eventConnectionRejected, NewInterface::checkRejoin);
	Event::Attach(eventConnectionRejected, resetRecordingData);
	Event::Attach(eventConnectionAccepted, NewInterface::savePassForServer);
	Event::Attach(eventConnectionAccepted, SmartCon::cancelRetry);
	Event::Attach(eventConnectionAccepted, "$LastDemoFileName = $recorderFileName;");
	Event::Attach(eventDisconnectFromServer, resetRecordingData);
	Event::Attach(eventJoinGameGuiOpened, RecordLabelMatcher);
	Event::Attach(eventChangeMission, checkNewRecording);
	Event::Attach(eventPlayerSetupGuiOpened, "NewInterface::PlayerSetupDiscoBoogie();");
	Event::Attach(eventExportPrefs, "NewInterface::onExportPrefs();");
	Event::Attach(eventSavePlayGui, "NewInterface::onSavePlayGui();");
	Event::Attach(eventStopTribesMusic, "NewInterface::checkCdChange();");
	Event::Attach(eventChangeTribesMusic, "NewInterface::checkCdChange();");

	// banner
	Presto::AddScriptBanner(NewInterface, " \n" @ " <f2><jc>NewInterface\n" @
		" \n" @ "<f1><jc>version " @ $NewInterfaceVersion @ "\n" @ " \n" @ " <f0>Done by:\n"@ " \n" @ "<f1>|HH|BigBunny");
}

//password remembering
function NewInterface::savePassForServer()
{
	$NewInterface::pass[String::replaceChar($Server::Address, ".", "_")] = $Server::JoinPassword;
}

function JoinGame::setPass()
{
	if ($NewInterface::pass[String::replaceChar($Server::Address, ".", "_")] != "")
		$Server::JoinPassword = $NewInterface::pass[String::replaceChar($Server::Address, ".", "_")];
}

//prefs saving:
function NewInterface::onSavePlayGui()
{
	if($ForceNoPlayGuiSave)
		return nosave;

	if(!$pref::PlayGuiStoring)
		return nosave;

	return;
}

function NewInterface::onExportPrefs()
{
	export("NewInterface::pass*", "config\\Passwords.cs", false);
	return;
}

//connect gui buttons
function NewInterface::gotoTrain()
{
	$pref::PlayGameMode = "TRAIN";
	resetRecordingData();
	GuiLoadContentCtrl(MainWindow, "gui\\training.gui");
}

function NewInterface::gotoHost()
{
	$pref::PlayGameMode = "HOST";
	resetRecordingData();
	GuiLoadContentCtrl(MainWindow, "gui\\createServer.gui");
	RecordLabelMatcher();
}

function NewInterface::gotoJoin()
{
	$pref::PlayGameMode = "JOIN";
	resetRecordingData();
	GuiLoadContentCtrl(MainWindow, "gui\\joingame.gui");
	Event::Trigger(eventJoinGameGuiOpened);
}

// together with overwriting: discoboogie
function NewInterface::PlayerSetupDiscoBoogie()
{
	if (nameToID(PlayerSetupGui) == -1)
		return;

	if ($FgSkin::DiscoBoogie)
	{
		// To keep the same armor, but still change move
		FGSkin::cycleArmor(JustForFUN);
		FGSkin::cycleArmor(JustForFUN);
		FGSkin::cycleArmor(JustForFUN);
		schedule("NewInterface::PlayerSetupDiscoBoogie();", 3);
	}
	else
	{
		FGSkin::set(JustForFun, 0, $PCFG::Gender[$PCFG::CurrentPlayer]);
		// To keep the same armor, but still change move
		FGSkin::cycleArmor(JustForFUN);
		FGSkin::cycleArmor(JustForFUN);
		FGSkin::cycleArmor(JustForFUN);
	}
}

// Dialogs and other functions
function deleteBuddy()
{
	if ($pref::buddyList != "")
	{
		$pref::buddyList = $pref::buddyList[1];
		Control::setValue(JoinGameBuddyList, $pref::buddyList[1]);
	
		for (%i = 0; %i < getBuddyCount() - 1; %i++)
			$pref::buddyList[%i] = $pref::buddyList[%i + 1];
	
		$pref::buddyList[getBuddyCount() - 1] = "";
	
		//now recreate the combo
		JoinGameGui::onOpen();
		Server::ResortList(IDCTG_SERVER_SELECT_LIST);
	}
}

function getCdStatus()
//originally for CdControl, but very usefull!
{
	if ($pref::CDMusic && !$pref::userCDOverride) return "GameMusic";
	if (!$pref::CDMusic && $pref::userCDOverride) return "UserCD";
	if (!$pref::CDMusic && !$pref::userCDOverride) return "NoMusic";
	if ($pref::CDMusic && $pref::userCDOverride) return "Error";
}

function NewInterface::checkCdChange()
{
	if (!$pref::startMapMusicOnLoad) return mute;
	return;
}

function getBuddyCount()
{
	for (%i = 0; $pref::buddyList[%i] != ""; %i++) {}
	return %i;
}

function NewInterface::serverValidate()
{
	if (Control::getValue(NewInterface::ipfield) != "" && Control::getValue(NewInterface::portField) != "")
	Control::setActive(NewInterface::manconBut, true);
	else Control::setActive(NewInterface::manconBut, false);
}

function NewInterface::manualConnect()
{
	GuiPushDialog(MainWindow, "Gui\\ConnectToServer.gui");
	Control::setText(NewInterface::ipField, Pass:get(IP, $NewInterface::ManualAddress));
	Control::setText(NewInterface::portField, Pass:get(Port, $NewInterface::ManualAddress));
	Control::setValue(NewInterface::passField, "If needed...");
}

function Pass:get(%data, %address)
{
	if (%address == "") return "";

	%ip = String::getSubStr(%address, 3, String::findSubStr(String::getSubStr(%address, 3, 255), ":"));
	if (%data == IP) return %ip;

	%port = String::getSubStr(%address, String::len(%ip) + 4, 255);
	if (%data == Port) return %port;
}

function NewInterface::connectManualResult(%res)
{
	if (%res == DONE)
	{
		%ip = Control::getText(NewInterface::ipField);
		%port = Control::getText(NewInterface::portField);
		$NewInterface::ManualAddress = "IP:" @ %ip @ ":" @ %port;
		if (Control::getValue(NewInterface::passField) != "")
			$Server::JoinPassword = Control::getValue(NewInterface::passField);
		connect($NewInterface::ManualAddress);
	}
	else
	{
		%ip = Control::getText(NewInterface::ipField);
		%port = Control::getText(NewInterface::portField);
		$NewInterface::ManualAddress = "IP:" @ %ip @ ":" @ %port;
	}
	GuiPopDialog(MainWindow, 0);
}

function NewInterface::setRecordFile()
{
	if ($recordDemo && $recorderFileName != "")
	{
		GuiPushDialog(MainWindow, "Gui\\SetRecordFile.gui");
		%name = recordFileStripToName($recorderFileName);
		Control::setText(NewInterface::demoFileField, %name);
	}
}

function NewInterface::closeRecordDlg(%result)
{
	if(%result == DONE)
	{
		%name = Control::getText(NewInterface::demoFileField);
		if (String::findSubStr(%name, ".rec") == -1) %ext = ".rec";
		else %ext = "";
		if (validFileName(%name))
		{
			$recorderFileName = "Recordings\\" @ Control::getText(NewInterface::demoFileField) @ %ext;
			$LastDemoFileName = $recorderFileName;
			GuiPopDialog(MainWindow, 0);
		}
		else
		{
			GuiPopDialog(MainWindow, 0);
			GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
			Control::setValue(MessageDialogTextFormat, "<jc><f2>Invalid recordings name.\n\n<f1>Not allowed characters are:\n\n\\ / : ? * \" < > |\n\nMake sure you do not use them.");
		}
	}
	else GuiPopDialog(MainWindow, 0);
	RecordLabelMatcher();
}

function MessageRetryReturnHandling()
{
	if ($MessageRetryDialogUse == "SmartConnect") SmartCon::cancelRetry();
	if ($MessageRetryDialogUse == "NewDemoStart") Schedule::Cancel("startNewDemo();");
}

// Install!
if ($NewInterface::installed == "")
	if(File::findFirst("*NewInterface.vol") != "")
		NewInterface::init();
	else echo("NewInterface.vol not found!");
else echo("Second attempt to execute NewInterface detected and ignored...");