
/*
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */



#include <stdio.h>

#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"


typedef struct {
	u_char	playback_type	: 8;
	u_char	num_angles	: 8;
        u_short	num_ptt		: 16;
	u_short	parental_control: 16;
	u_char	title_set_num	: 8;
	u_char	vts_ttn		: 8;	
        u_int	offset		: 32;
} ifo_toast_t;

/**
 *
 */

void ifoPrintToast (u_char *ptr)
{
	ifo_hdr_t *hdr = (ifo_hdr_t *) ptr;
	ifo_toast_t *toast;
	int i;

	if (!ptr)
		return;

	printf ("\nTOAST TABLE\n");
	printf ("---\n");
	printf ("number of maps: %d\n", bswap_16 (hdr->num));	
	printf ("length of table: %d\n", bswap_32 (hdr->len));	

	ptr = (unsigned char *)hdr + 1;
	toast = (ifo_toast_t *) ptr;

	for (i=0; i<bswap_16 (hdr->num); i++) {
		printf ("%d:\n", i);
		printf ("\tplayback_type:    0x%x\n", toast->playback_type);
		printf ("\tnum_angles:       0x%x\n", toast->num_angles);
		printf ("\tnum_ptt:          0x%x\n", bswap_16 (toast->num_ptt));

		printf ("\tparental_control: 0x%x\n", bswap_16 (toast->parental_control));
		printf ("\ttitle_set_num:    0x%x\n", toast->title_set_num);
		printf ("\tvts_ttn:          0x%x\n", toast->vts_ttn);

		printf ("\toffset:           0x%x\n", bswap_32 (toast->offset));

		toast++;
	}
}	
