
/*
 * VIDEO OBJECT UNiT ADDRESS MAP
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 * $log$
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define VOBU_ADMAP_HDR_LEN 4

typedef struct {
	u_int	len		: 32;	// length of table
} vobu_addr_map_hdr_t;

static void _ifoPrint_vobu_addr_map (u_char *ptr);


#ifdef PARSER
/**
 *
 */

void ifoPrint_vts_vobu_addr_map (ifo_t *ifo)
{
	printf ("\nTITLE SET ");

	if (ifo->data[ID_TITLE_VOBU_ADDR_MAP])
		_ifoPrint_vobu_addr_map (ifo->data[ID_TITLE_VOBU_ADDR_MAP]);
}


/**
 *
 */

void ifoPrint_vtsm_vobu_addr_map (ifo_t *ifo)
{
	printf ("\nMENU ");

	if (ifo->data[ID_MENU_VOBU_ADDR_MAP])
		_ifoPrint_vobu_addr_map (ifo->data[ID_MENU_VOBU_ADDR_MAP]);
}


/**
 *
 */

void _ifoPrint_vobu_addr_map (u_char *ptr)
{
	vobu_addr_map_hdr_t *vobu_addr_map_hdr = (vobu_addr_map_hdr_t *) ptr;
	int i;
	u_int num;

	printf ("VIDEO OBJECT ADDRESS MAP\n");
	printf ("---\n");

	num = bswap_32 (vobu_addr_map_hdr->len)  / 4;
	printf ("number of units: %d\n\n", num);	
	printf ("len of units: %d\n\n", bswap_32 (vobu_addr_map_hdr->len));	

	ptr += VOBU_ADMAP_HDR_LEN;

	for (i=0; i<num; i++) {
		printf ("0x%07x ", get4bytes (ptr));

		ptr += 4;
	}

	printf ("\n\n\n");
}	
#endif
