
/*
 * PART OF TITLE
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <stdlib.h>
//#include <unistd.h>
#include <sys/types.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"


/**
 *
 */

void ifoPrint_ptt (ifo_ptt_t *ptt)
{
	int i, s;

	if (!ptt)
		return;

	printf ("\nPART OF TITLE\n");
	printf ("---\n");
	printf ("number of titles: %d\n", ptt->num);	

	for (i=0; i<ptt->num; i++) {
		ifo_ptt_sub_t *title = ptt->title+i;

		printf ("\n\tTitle: 0x%x\tnumber of chapters: %d\n", i+1, title->num);

		for (s=0; s<title->num; s++) {
			printf ("\t\t Chapter: 0x%02x", s+1);
			printf ("\t PGC: 0x%02x", title->data[s].pgc);
			printf ("\t PG: 0x%02x\n",title->data[s].pg);
		}
	}
}	
