
/*
 * PGROGRAM CHAIN INFORMATION
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#include "IFOparser.h"
extern CIFOParser *IFOGlobal;
#include <malloc.h>

#include <stdio.h>


#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define PGCI_SUB_LEN 8

typedef struct {
	u_short id		: 16;	// Language
	u_short			: 16;	// don't know
	u_int	start		: 32;	// Start of unit
} pgci_sub_t;


#define MLU_SUB_LEN 8

typedef struct {
        u_short lang            : 16;   // Language
        u_short foo             : 16;   // don't know
        u_int   start           : 32;   // Start of unit
} mlu_sub_t;

#define LU_SUB_LEN 8

typedef struct {
	u_char	menu_id		: 4;	// 0=off, 3=root, 4=spu,
					// 5=audio, 6=angle, 7=ptt
        u_short foo1		: 4;	// don't know
        u_short foo2		: 8;	// don't know
        u_short bar		: 16;	// don't know
        u_int   start           : 32;	// Start of unit
} lu_sub_t;

static void _ifoPrint_mlu (u_char *ptr);

/**
 *
 */

void ifoPrint_title_pgci (ifo_t *ifo)
{
	ifo_hdr_t *hdr = (ifo_hdr_t *) ifo->data[ID_TITLE_PGCI];
	int i;

	if (!hdr)
		return;

	printf ("\nTITLE PROGAM CHAIN INFORMATION\n");
	printf ("---\n");
	printf ("number of units: %d\n", bswap_16 (hdr->num));

		
	if(bswap_16 (hdr->num)<=0)
	{
		IFOGlobal->fatal_error_flag = 1;
		return;
	}
	IFOGlobal->pgcs.SetArraySize( bswap_16 (hdr->num) );
	
	for (i=0; i<bswap_16(hdr->num); i++) {
		char *ptr;
		IFOGlobal->PGCptr = i;
		if (ifoGetPGCI (hdr, i, &ptr) >= 0)
			ifoPrint_pgc ((unsigned char *)ptr);
	}
}	


/**
 *
 */

void ifoPrint_menu_pgci (ifo_t *ifo)
{
	ifo_hdr_t *hdr = (ifo_hdr_t *) ifo->data[ID_MENU_PGCI];
	int i;

	if (!hdr)
		return;

	printf ("\nMENU PROGRAM CHAIN INFORMATION\n");
	printf ("---\n");
	printf ("number of units: %x\n", bswap_16 (hdr->num));	

	for (i=0; i<bswap_16(hdr->num); i++) {
		char *ptr;

		if (ifoGetPGCI (hdr, i, &ptr) >= 0)
			_ifoPrint_mlu ((unsigned char *)ptr);
	}
}	


/**
 *
 */

static void _ifoPrint_mlu (u_char *ptr)
{
	ifo_hdr_t *hdr = (ifo_hdr_t *) ptr;
	int i;

	printf ("\n\tLANGUAGE UNIT\n");

	ptr += IFO_HDR_LEN;

	for (i=1; i<=bswap_16(hdr->num); i++) {
		lu_sub_t *lu_sub = (lu_sub_t *) ptr;

		if (lu_sub->foo1) {
			printf ("\t\t%x: menu_id: %s\tmenu: %x parental: %x\n",
				i,
				decode_menuname (lu_sub->menu_id),
				lu_sub->foo2,
                        	bswap_16 (lu_sub->bar));
		} else {
			printf ("\t\t%x:\t\t\t\tmenu: %x parental: %x\n",
				i,
				lu_sub->foo2,
                        	bswap_16 (lu_sub->bar));
		}

		ptr += LU_SUB_LEN;
	}

	for (i=0; i<bswap_16(hdr->num); i++) {
		char *ptr;

		if (ifoGetPGCI (hdr, i, &ptr) >= 0)
			ifoPrint_pgc ((unsigned char *)ptr);
	}
}
