
/*
 * SUBPICTURE TABLE
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"


typedef struct {
	u_int   zero	: 32;		// 0x00000000 ?
	u_char  zero1	: 8;		// 0x00 ?
	u_char  num	: 8;		// number of SPUs
} spu_hdr_t;

#define SPU_HDR_LEN    6

/**
 * Sub Picture Unit
 */

int ifoGetSPU (char *_hdr, char **ptr)
{
	spu_hdr_t *hdr = (spu_hdr_t *) _hdr;

	if (!_hdr)
		return -1;

	*ptr = _hdr + SPU_HDR_LEN;
	
	return hdr->num;
}	
