
/*
 * PGROGRAM CHAIN INFORMATION
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define PGCI_SUB_LEN 8

typedef struct {
	u_short id		: 16;	// Language
	u_short			: 16;	// don't know
	u_int	start		: 32;	// Start of unit
} pgci_sub_t;


/**
 *
 */

int ifoGetPGCI (ifo_hdr_t *hdr, int title, char **ptr)
{
	pgci_sub_t *pgci_sub;

	*ptr = (char *) hdr;

	if (!*ptr)
		return -1;

	if (title > hdr->num)
		return -1;

	*ptr += IFO_HDR_LEN;

	pgci_sub = (pgci_sub_t *) *ptr + title;

	*ptr = (char *) hdr + bswap_32 (pgci_sub->start);

	return 0;
}
