/* 
 *  DVDselector.h
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef DVD_SELECTOR_H
#define DVD_SELECTOR_H

#include "./ifoparser/ifoparser.h"
// DVD STREAM SELECTOR string definitions
#define DVS_TITLE               420
#define DVS_LATERAL             421
#define DVS_BUTTON              422
#define DVS_PGCSFOUND           423
#define DVS_AUDIOFOUND          424
#define DVS_DURATION            425
#define DVS_SUBPICFOUND         426
#define DVS_ANGLE               427


#include "selectordialog.h"
#define MAX_AUDIO 16

struct TAudioInfo
{
  int  type;
  char name[256];
};

struct TDVDSelector
{
	int selected_pgc;
	int selected_angle;

  TAudioInfo audio[MAX_AUDIO];
  int audio_count;
	int selected_audio;
	int has_audio;

	int selected_subpic;
	int has_subpic;
};

OpenDVDSelector(HWND hWnd, HINSTANCE hInst,CIFOParser *ifo, TDVDSelector *sel_info);



#endif DVD_SELECTOR_H