/* 
 *  inputStream.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef INPUTSTREAM_H
#define INPUTSTREAM_H
#include "flasktypes.h"
#include ".\IFOParser\IFOParser.h"
#include <stdio.h>

#define BtoMB(A) ((double)A/1048576)

//Open MODES
#define DVD_MODE		1
#define VERBOSE_MODE    2


// Working MODES
#define NORMAL_MODE          1
#define PLAYSEQ_MODE    2

struct TPlaySequenceSpan
{
	i64 start;
	i64 end;
};

struct TPlaySequence
{
	int                  spanptr;
	TPlaySequenceSpan    *sp;
	int                  span_count;
	i64                  total_size;
  i64                  start;
  i64                  end;
};

struct TFile
{
	char		name[MAX_PATH+256];
	__int64		position;
	__int64		size;
	__int64		firstSCR;
	__int64     lastSCR;
	FILE 		*handle;
};

struct TInputStream
{
	TFile		file[100];
	int			nFiles;
	int			actualFile;
	__int64		totalSize;
	__int64     globalPos;
	bool		multipleFileMode;
};

class CinputStream
{
	public:
		int SetWorkingMode(int mode);
		int ValidatePlaySequence();

		//File access functions
		int OpenStream(char *, int mode);
		int CloseStream();		

		int Read( ui8 *buffer, int size);


    ui64 GetStreamPosExt();
    int	SetStreamPosExt( ui64 pos );
    

		i64 GetStreamSize();


		int SeekStream( i64 pos);
		int SetOneFileMode(int n_file);
		int SetMulFileMode();
		
		char *GetFileName();
		
		int AddSpan(TPlaySequenceSpan *span);

		CinputStream();
		~CinputStream();

	private:
    i64 GetStreamPos();
    int	SetStreamPos( i64 pos );
    
		int AlignStreamToSpan();
		int workingMode;
		int __read( ui8 *buffer, int size);
		// _read locals
		__int64 remainingBytes;
    int remaining_bytes;
    int partial,bytes_read;

    // Use this variable for fast access
    // to frequently used info
    ui64 m_nCurrentFilePos;
    ui64 m_nCurrentFileSize;
    FILE *m_pCurrentFile;
    
		int ret;

		TPlaySequence   ps;
	TInputStream    iStream;
};
#endif