
/*
 * SUBPICTURE TABLE
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */

#include "IFOparser.h"
extern CIFOParser *IFOGlobal;

#ifdef PARSER
#include <stdio.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"
#include <string.h>

#include "misc.h"
#include "decode.h"


/**
 *
 */

void ifoPrintSPU (ifo_spu_t *spu, u_int num)
{
	int i;

	if (!spu) 
		return;

	printf ("\nSUBPICTURE\n");
	printf ("---\n");

	printf ("number of streams:\t%d\n", num);
	IFOGlobal->SubpicCount = num;
	if(IFOGlobal->SubpicCount>32)
		IFOGlobal->fatal_error_flag = 1;

	for (i=0; i<num; i++) {
		char *caption;

		printf ("\tlang_code:\t%s\n",   ifoDecodeLang (spu->lang_code));
		strcpy(  IFOGlobal->SubpidID[i], ifoDecodeLang (spu->lang_code));
		if ((caption = decode_caption (spu->caption))){
			printf ("\tcaption:\t%s\n", caption);
			strcat(IFOGlobal->SubpidID[i], " (");
			strcat(IFOGlobal->SubpidID[i], decode_caption (spu->caption));
			strcat(IFOGlobal->SubpidID[i], ")");
		}

		printf ("\n");

		spu++;
	}
}
