
/*
 * GET AUDIO INFORMATION
 *
 * Copyright (C) 1998,1999,2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */
#include "IFOparser.h"
extern CIFOParser *IFOGlobal;

#include <stdio.h>
#include <string.h>

#include <stdlib.h>
#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"


/**
 *
 */

void ifoPrintAudio (ifo_audio_t *audio, u_int num)
{
	int i;

	if (!audio)
		return;

	printf ("\nAUDIO\n");
	printf ("---\n");

	printf ("number of streams:\t%d\n", num);
	IFOGlobal->AudioCount = num;
	if(IFOGlobal->AudioCount>8)
		IFOGlobal->fatal_error_flag = 1;

	for (i=0; i<num; i++) {
		char *appl_mode;
		char *caption;
{ 
  int i;
  u_char *ptr = (u_char *) audio;

  for (i=0; i<IFO_AUDIO_LEN; i++)
	printf ("%02x ", *ptr++);
}


  printf ("\tlang_code:\t%s\n",   ifoDecodeLang (audio->lang_code));
  strcpy(IFOGlobal->AudioID[i], ifoDecodeLang (audio->lang_code));

  IFOGlobal->AudioMode[i]  = audio->coding_mode;
  IFOGlobal->AudioLfe[i]      = audio->multichannel_extension;
  IFOGlobal->AudioChannels[i] = audio->num_channels;

  printf ("\tmode:\t\t%s(%dCh)%s\n",
        decode_audiomode (audio->coding_mode),
        audio->num_channels+1,
        audio->multichannel_extension ? "+multichannel" : ""
        );

		printf ("\tsampling:\t%dkHz\n", audio->sample_freq ? 96 : 48);

		if ((appl_mode = decode_audiomodeappl (audio->appl_mode)))
			printf ("\tappl_mode:\t%s\n", appl_mode);
		if ((caption = decode_caption (audio->caption))){
			printf ("\tcaption:\t%s\n", caption);
			strcat(IFOGlobal->AudioID[i], " (");
			strcat(IFOGlobal->AudioID[i], decode_caption (audio->caption));
			strcat(IFOGlobal->AudioID[i], ")");
		}

		printf ("\tquant:\t\t");
		switch (audio->quantization) {
			case 0x00:
				printf ("16bit");
				break;
			case 0x01:
				printf ("20bit");
				break;
			case 0x02:
				printf ("24bit");
				break;
			case 0x03:
				printf ("DRC");
				break;
		}
		printf ("\n");

		audio++;	
	}
}
