/* 
 *  IFOParser.h 
 *
 *	Copyright (C) Alberto Vigata - January 2000  ultraflask@yahoo.com
 *                 
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_IFOPARSER_H__0B7FA440_0FEC_11D4_93EA_00000100CF13__INCLUDED_)
#define AFX_IFOPARSER_H__0B7FA440_0FEC_11D4_93EA_00000100CF13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ifo.h"

#include "..\..\Misc\CArray.h"

struct TSpan
{
	__int64  start;
	__int64  end;
};

class TCellAdressInfo
{
public:
	int             vobid;
	int            cellid;
	CArr<TSpan>       pos;
	TCellAdressInfo& operator =(TCellAdressInfo& right);
};



struct TCellPlayInfo
{
	int        parsed;
	int        vobid;
	int        cellid;
	__int64    start;
	__int64    end;
};

class TPGC
{
	public: 
	unsigned char        clut[16][4];
	CArr<TCellPlayInfo>  chain_cells;
	unsigned int          chain_time;
	TPGC& operator =(TPGC& right);
};

// This class stores a PGC angle and its
// playing info as a series of spans
class CBuiltPGC
{
	public: 
	int           chain_time;
	CArr<TSpan>   playinfo;
};

// This class stores a PGC chain with its
// angled variants
class CBuiltAPGC
{
	public: 
	CArr<CBuiltPGC>   BuiltPGC;
};

// Audio types
enum {Ac3Audio=0, MpegAudio, LPCMAudio, DTSAudio, SDDSAudio};

class CIFOParser  
{
public:
//	int           SetInputStream(CinputStream *input);
	char         *GetSubpicID(int id);
	unsigned int  GetPGCTime(TPGC *pgc);
	TPGC         *GetPGC(int id);
	int           GetPGCCount();
	int           GetSubpicCLUT( TPGC *pgc , char *clut);
	int           GetSubpicCount();
	char         *GetAudioID(int id);
	int           GetAudioCount();
	int           Load( char *file );
	int           UnLoad();
	         CIFOParser();
	virtual ~CIFOParser();
		
	//Should be private
	int    AudioCount;
	int    SubpicCount;
	char   AudioID[8][256];
	int    AudioMode[8];
  int    AudioChannels[8];
  int    AudioLfe[8];

	char   SubpidID[32][256];
	
	int    PGCptr; //this pointer is used to know what pgc we're working on
					// while parsing the data
	int    fatal_error_flag;  // flag indicating fatal error
	// PGCs info
	CArr<TPGC>                      pgcs;
	CArr<TCellAdressInfo>   cell_address;

	// Thiss member stores the whole PGCs playing
	// info inside the IFO file
	CArr<CBuiltAPGC>  PGCs;

	ifo_t *ifo;
	int   fd;
private:
	int RenderCell(int pgc_number, int angle, int cell_to_render);
	int GetCellSpans(CArr<TSpan>& cell_spans, int vobid, int cellid);

};

#endif // !defined(AFX_IFOPARSER_H__0B7FA440_0FEC_11D4_93EA_00000100CF13__INCLUDED_)
