/* 
 *  SelectorDialog.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <windows.h>
#include <stdio.h>
#include "selectordialog.h"
#include ".\IFOParser\ifoparser.h"
#include "flaskmpegmism.h"
#include "DVDSelector.h"
#include <string>

using namespace std;


extern FMMismStdParms params;
#define GS(x) (params.GetString(x))

//global
struct TPGCnumberToListBox
{
	int pgc;
	int angle;

};

void FormatTimeString( char *str, DWORD time)
{
  // Time passed is in milliseconds.  
  if(!str)
    return;

  int hr,min,sec;
  sec = time / 1000;
  min = sec / 60;
  hr  = min / 60;

  sec = sec % 60;
  min = min % 60;
  hr  = hr % 24;

  sprintf(str, "%d:%02d:%02d", hr, min, sec);
}
char *pAudioTypes []={"AC3", "MPEG audio", "LPCM audio", "DTS Audio", "SDDS audio"};

OpenDVDSelector(HWND hWnd, HINSTANCE hInst, CIFOParser *ifo, TDVDSelector *sel_info)
{
	int i,j, titles_count;
	CArr<char *> str;
	CArr<TPGCnumberToListBox>  pgc_rel;
	TPGCnumberToListBox        spgc_rel;
	char szTemp[256];
	int audio_section_number  = 0;
	int subpic_section_number = 0;
  string tempString[8];

	TSelectorDialog set;
	set.tittle      =   GS(DVS_TITLE);
	set.button_text =   GS(DVS_BUTTON);
	set.lateral_text =  GS(DVS_LATERAL);

	set.section_count = 0;

	set.sections_titles[0] = GS(DVS_PGCSFOUND);
	set.sections_titles[1] = GS(DVS_AUDIOFOUND);
	set.sections_titles[2] = GS(DVS_SUBPICFOUND);

	set.section_mode[0]   =SINGLE_SELECT | MUST_SELECT;
	set.section_mode[1]   =SINGLE_SELECT | MUST_SELECT;
	set.section_mode[2]   =SINGLE_SELECT;

	titles_count = 0;
	for(i=0; i<ifo->PGCs.GetCount(); i++)
	{
		for(j=0; j < ifo->PGCs[i].BuiltPGC.GetCount(); j++)
		{	
			spgc_rel.pgc   = i;
			spgc_rel.angle = j;
			pgc_rel.AddItem(&spgc_rel);

			titles_count++;
			           str.SetArraySize(titles_count);
			set.strings[0].SetArraySize(titles_count);
			str[titles_count-1] = new char[256];

			FormatTimeString(szTemp, ifo->PGCs[i].BuiltPGC[j].chain_time );

			if(ifo->PGCs[i].BuiltPGC.GetCount()>1)
				sprintf(str[titles_count-1] , "%d.-  %s: %s - (%s %d)", i,GS(DVS_DURATION) ,szTemp,GS(DVS_ANGLE), j);
			else
				sprintf(str[titles_count-1] , "%d.-  %s: %s", i,GS(DVS_DURATION) ,szTemp);

			set.strings[0][titles_count-1] = (char *)str[titles_count-1];
		}
	}
	// A pgc must be inside the stream
	set.section_count++;

	if( ifo->GetAudioCount() ){
		audio_section_number = set.section_count;
		set.section_count++;
		set.strings[audio_section_number].SetArraySize( ifo->GetAudioCount() );
		for(i=0; i<ifo->AudioCount; i++)
    {
      tempString[i] += ifo->AudioID[i];
      tempString[i] += string(" - ") + pAudioTypes[ifo->AudioMode[i]];

			set.strings[audio_section_number][i]=  (char *)tempString[i].c_str();

      strcpy( sel_info->audio[i].name, tempString[i].c_str() );
      sel_info->audio_count = ifo->AudioCount;
      sel_info->audio[i].type = ifo->AudioMode[i];
      
    }
	}

	if( ifo->GetSubpicCount() ){
		subpic_section_number = set.section_count;
		set.section_count++;
		set.strings[subpic_section_number].SetArraySize( ifo->GetSubpicCount() );
		for(i=0; i<ifo->SubpicCount; i++)
			set.strings[subpic_section_number][i] = ifo->SubpidID[i];
	}


	// ResetSelections MUST be called before OpenSelectorDialog or setting default selections
	//      in order to initialize selections.
	ResetSelections(&set);

	sel_info->has_audio  = 0;
	sel_info->has_subpic = 0;

	set.selected[0][0] = 1;
	if( ifo->GetAudioCount() )
		set.selected[audio_section_number][0] = 1;

	if( ifo->GetSubpicCount() )
		set.selected[subpic_section_number][0] = 0;

	OpenSelectorDialog(hWnd, hInst, &set);

	// Get PGC and angle
	int selected = GetFirstSelected( &set, 0 );

	sel_info->selected_pgc   = pgc_rel[selected].pgc;
	sel_info->selected_angle = pgc_rel[selected].angle;

	// Get audios
	if(sel_info->has_audio      = audio_section_number){
		// FIXME: When multiaudio is available check this one
		sel_info->selected_audio = GetFirstSelected( &set, audio_section_number );
	}

	// Get subpics
	if(sel_info->has_subpic      = subpic_section_number){

		if( !IsAnySelected(&set, subpic_section_number) )
			sel_info->has_subpic = 0;
		else
			sel_info->selected_subpic = GetFirstSelected( &set, subpic_section_number );
	}

	
	// Delete temporary strings used for the dialog
	for(i=0; i<str.GetCount(); i++)
		delete [] str[i];
	return 1;

}