/*
	MERVBot Spawn-callback by Catid@pacbell.net
*/

#include "football.h"

#ifndef SPAWN_H
#define SPAWN_H

#define TAG_BANNEDTIME		100
#define TAG_LASTX			101
#define TAG_LASTY			102

#define BEFORE_PICKING		0
#define PICKING				1
#define COIN_TOSS			2
#define PLAYING				3

#define TEAM_ONE_NAME		0
#define TEAM_TWO_NAME		1


#define FIRST_DOWN_LINE		0
#define LINE_OF_SCRIMMAGE	1
#define TEAM_ONE_SCORE		2
#define TEAM_TWO_SCORE		3
#define PLAY_CLOCK			4
#define TIMER				5
#define DOWN				6
#define TOGO				7
#define HALF				8
#define	POSSESION			9
#define TEAM_ONE_TIMEOUT	10
#define TEAM_TWO_TIMEOUT	11
	

#define STRING_CAST_CHAR
#include "..\dllcore.h"
#include "time.h"

#include <string>
#include <vector>
#include <set>
#include <list>
using namespace std;

union itemInfo
{
	struct
	{
		unsigned shields	: 1;	// Has it or not
		unsigned supers		: 1;
		unsigned burst		: 4;	// Item counts
		unsigned repel		: 4;
		unsigned thor		: 4;
		unsigned brick		: 4;
		unsigned decoy		: 4;
		unsigned rocket		: 4;
		unsigned portal		: 4;
		unsigned pack		: 2;	// Probably used somehow
	};

	Uint32 n;
};

union weaponInfo
{
	struct
	{
		unsigned type		: 5;	// enum Projectile_Types
		unsigned level		: 2;	// Only for bombs/bullets
		unsigned bouncing	: 1;	// Only for bombs
		unsigned emp		: 1;	// Only for bombs
		unsigned isBomb		: 1;	// ? This is a bomb
		unsigned shrapCount	: 5;	// 0-31
		unsigned fireType	: 1;	// Bombs -> Mines, Bullets -> Multifire
	};

	Uint16 n;
};

enum Projectile_Types
{
	// Seen "in the wild"
	PROJ_None,
	PROJ_Bullet,
	PROJ_BBullet,
	PROJ_Bomb,
	PROJ_PBomb,
	PROJ_Repel,
	PROJ_Decoy,
	PROJ_Burst,
	PROJ_Thor,

	// Internal to the bot
	PROJ_InactiveBullet,
	PROJ_Shrapnel
};

enum Weapon_Levels
{
	LVL_One,
	LVL_Two,
	LVL_Three,
	LVL_Four
};

enum Ship_Types
{
	SHIP_Warbird,		// 0
	SHIP_Javelin,
	SHIP_Spider,
	SHIP_Leviathan,
	SHIP_Terrier,
	SHIP_Weasel,
	SHIP_Lancaster,
	SHIP_Shark,
	SHIP_Spectator		// 8
};

enum Prize_Types
{
	PRIZE_Unknown,		// 0
	PRIZE_Recharge,
	PRIZE_Energy,
	PRIZE_Rotation,
	PRIZE_Stealth,
	PRIZE_Cloak,
	PRIZE_XRadar,
	PRIZE_Warp,
	PRIZE_Guns,
	PRIZE_Bombs,
	PRIZE_BBullets,
	PRIZE_Thruster,
	PRIZE_TopSpeed,
	PRIZE_FullCharge,
	PRIZE_EngineShutdown,
	PRIZE_Multifire,
	PRIZE_Proximity,
	PRIZE_Super,
	PRIZE_Shields,
	PRIZE_Antiwarp,
	PRIZE_Repel,
	PRIZE_Burst,
	PRIZE_Decoy,
	PRIZE_Thor,
	PRIZE_Multiprize,
	PRIZE_Brick,
	PRIZE_Rocket,
	PRIZE_Portal,		// 28
};

enum Chat_SoundBytes
{							// Soundcodes courtesy of MGB
	SND_None,				// 0  = Silence
	SND_BassBeep,			// 1  = BEEP!
	SND_TrebleBeep,			// 2  = BEEP!
	SND_ATT,				// 3  = You're not dealing with AT&T
	SND_Discretion,			// 4  = Due to some violent content, parental discretion is advised
	SND_Hallellula,			// 5  = Hallellula
	SND_Reagan,				// 6  = Ronald Reagan
	SND_Inconceivable,		// 7  = Inconceivable
	SND_Churchill,			// 8  = Winston Churchill
	SND_SnotLicker,			// 9  = Listen to me, you pebble farting snot licker
	SND_Crying,				// 10 = Crying
	SND_Burp,				// 11 = Burp
	SND_Girl,				// 12 = Girl
	SND_Scream,				// 13 = Scream
	SND_Fart,				// 14 = Fart1
	SND_Fart2,				// 15 = Fart2
	SND_Phone,				// 16 = Phone ring
	SND_WorldUnderAttack,	// 17 = The world is under attack at this very moment
	SND_Gibberish,			// 18 = Gibberish
	SND_Ooooo,				// 19 = Ooooo
	SND_Geeee,				// 20 = Geeee
	SND_Ohhhh,				// 21 = Ohhhh
	SND_Ahhhh,				// 22 = Awwww
	SND_ThisGameSucks,		// 23 = This game sucks
	SND_Sheep,				// 24 = Sheep
	SND_CantLogIn,			// 25 = I can't log in!
	SND_MessageAlarm,		// 26 = Beep
	SND_StartMusic = 100,	// 100= Start music playing
	SND_StopMusic,			// 101= Stop music
	SND_PlayOnce,			// 102= Play music for 1 iteration then stop
	SND_VictoryBell,		// 103= Victory bell
	SND_Goal				// 104= Goal!
};

enum Chat_Modes
{
    MSG_Arena,			// 00 Same for *arena, *zone, *szone, **
    MSG_PublicMacro,	// 01 Macro calcs are done client-side
    MSG_Public,			// 02 Public chat
    MSG_Team,			// 03 (//) or (')
    MSG_TeamPrivate,	// 04 Player to all members of another team (")
    MSG_Private,		// 05 Only shows messages addressed to the bot
    MSG_PlayerWarning,	// 06 Red message, with a name tag
    MSG_RemotePrivate,	// 07 Do not trust the sender with any private information.
    MSG_ServerError,	// 08 Red server errors, without a name tag
    MSG_Channel			// 09 Arrives in the same format SubSpace displays
};

union objectInfo
{
	struct
	{
		unsigned id				: 15;	// Object ident
		unsigned disabled		: 1;	// 1=off, 0=on
	};

	Uint16 n;
};

enum _ObjectLayers
{
	LAYER_BelowAll,
	LAYER_AfterBackground,
	LAYER_AfterTiles,
	LAYER_AfterWeapons,
	LAYER_AfterShips,
	LAYER_AfterGauges,
	LAYER_AfterChat,
	LAYER_TopMost,
};

enum _ObjectModes
{
	MODE_ShowAlways,
	MODE_EnterZone,
	MODE_EnterArena,
	MODE_Kill,
	MODE_Death,
	MODE_ServerControlled,
};

typedef unsigned short WORD;

typedef struct	/* 11 by */
{
	BYTE  change_xy    :  1;  // what properties to change for this object
	BYTE  change_image :  1;
	BYTE  change_layer :  1;
	BYTE  change_time  :  1;
	BYTE  change_mode  :  1;
	BYTE  reserved     :  3;

	WORD  mapobj       :  1;
	WORD  id           : 15;
	WORD  x, y;  // for screen objects, upper 12 bits are value, lower 4 are relative to what corner
	BYTE  image;
	BYTE  layer;
	WORD  time         : 12;  // 1/10th seconds
	WORD  mode         :  4;  // 0=AlwaysOn 5=ServerControlled
} lvzObject;

struct PlayerTag
{
	Player *p;
	int index;
	int data;
};

class Rect
{

public:
   Rect();
   Rect(int newx, int newy, int newwidth, int newheight);
   Rect(int newx, int newy, int newwidth);
   int getX();
   int getY();
   int getWidth();
   int getHeight();
   void flip();
   void setWidth(int newwidth);
   void setHeight(int newheight);
   bool contains(int xToCheck, int yToCheck);
   void set(Rect *anotherRect);
   void operator=(Rect *anotherRect);
   String toString();

private:
   int positiveorzero(int value);
   int x;
   int y;
   int width;
   int height;
};

struct Point
{
	Point(int nx = -1,int ny = -1)
	{
		x=nx;
		y=ny;
	}

	bool operator==(const Point &rhs) const
	{
		return (rhs.x == x && rhs.y == y);
	}

	int distSq(Point other)
	{
		return (x - other.x) * (x - other.x) + (y - other.y) * (y - other.y);
	}

	bool operator<(const Point &rhs) const
	{ // for the map
		bool rv = true;
		if (rhs.x < x)
		{
			rv = false;
		}
		else if (rhs.x == x)
		{
			rv = (y < rhs.y);
		}

		return rv;
	}

	int x;
	int y;
};

// each region consists of a bunch of rectangles combined with a bunch of points
struct Region
{
	set<Point> pts;
	vector<Rect> rects;
	bool containsPlayer(Player *pl); // does this region contain this player?
	bool containsPlayerExactly(Player *pl); // does this region contain the center of this player's ship?
};

#define MAX_OBJECTS 20

class botInfo
{
	bool CONNECTION_DENIED;

	_linkedlist <PlayerTag> taglist;
	int get_tag(Player *p, int index);
	void set_tag(Player *p, int index, int data);
	void killTags(Player *p);
	void killTags();

	CALL_HANDLE handle;
	CALL_COMMAND callback;
	CALL_PLIST playerlist;
	CALL_FLIST flaglist;
	CALL_MAP map;
	CALL_BLIST bricklist;
	char *arena;
	arenaSettings *settings;
	Player *me;
	bool biller_online;

	objectInfo object_array[MAX_OBJECTS];
	int num_objects;
	Player *object_dest;

	// Put bot data here

public:
	String getTimeString(int seconds);
	void addToRegion(Region *r, Point *start,set<int> *endTiles);
	void placeBall(int xCoord, int yCoord);
	void makeRegions();
	void nextCapt(Player *p);
	Player* findPlayerWithExactName(const char* name);
	void setTeamNames(const char *final);
	void turnOnObject(String name, short type);
	void turnOnObject(short number, short type);
	void turnOnObject(short objectNumber);
	void makeBlank(Uint32 letter);
	void turnOffDown();
	void sendPlayerObjects(Player *p);
	void flushLvzBuffer();
	void flushLvzBuffer(Player *p);
	void addToLvzBuffer(int id, bool on);
	Player* findPlayerWithName(const char* name);
	int getNumPlayersInGameOnTeam(int freq);
	int numSpeccers();
	void refreshAllLvz();
	String toCapNameString(String s); // cap name -> cap string
	Player* findPlayerWithID(int id);
	int getOobTile();
	void doKickoffOffsides(int losTile, int kickerTile, int kickingTeam);

	Region spawnArea;
	vector < pair<bool, int> > lvzBuffer;
	String teamOneName;
	String teamTwoName;
	FootballGame fg;
	String cap[2];
	int mode; // before picking, playing, ect.
	bool objects[1000];
	int playersPerTeam;
	int pickingCaptain; // for the coin toss
	bool coinTossed; // has the coin been tossed
	PBall* ball;
	bool justScoredAGoal;

	Player *lastBallCarrier; // the carrier during the last ballmove event

	bool shouldBeLocked;

	botInfo(CALL_HANDLE given)
	{
		justScoredAGoal = false;
		shouldBeLocked = true;
		makeRegions();
		lastBallCarrier = NULL;
		srand(time(0));
		ball = NULL;

		pickingCaptain = -1;
		playersPerTeam = 7;
		teamOneName = "team";
		teamTwoName = "team";
		fg.setBi(this);
		mode = BEFORE_PICKING;

		for (int i = 0; i < 1000;++i)
			objects[i] = false;

		handle = given;
		callback = 0;
		playerlist = 0;
		flaglist = 0;
		map = 0;
		CONNECTION_DENIED = false;
		me = 0;
		biller_online = true;
		num_objects = 0;
		object_dest = NULL;

		// Put initial values here
	}

	void clear_objects();
	void object_target(Player *p);
	void toggle_objects();
	void queue_enable(int id);
	void queue_disable(int id);

	void gotEvent(BotEvent &event);

	void tell(BotEvent &event);

	bool validate(CALL_HANDLE given) { return given == handle; }

	void sendPrivate(Player *player, char *msg);
	void sendPrivate(Player *player, BYTE snd, char *msg);

	void sendTeam(char *msg);
	void sendTeam(BYTE snd, char *msg);

	void sendTeamPrivate(Uint16 team, char *msg);
	void sendTeamPrivate(Uint16 team, BYTE snd, char *msg);

	void sendPublic(char *msg);
	void sendPublic(BYTE snd, char *msg);

	void sendPublicMacro(char *msg);
	void sendPublicMacro(BYTE snd, char *msg);

	void sendChannel(char *msg);			// #;Message
	void sendRemotePrivate(char *msg);		// :Name:Messsage
	void sendRemotePrivate(char *name, char *msg);

	void gotHelp(Player *p, Command *c);
	void gotCommand(Player *p, Command *c);
	void gotRemoteHelp(char *p, Command *c, Operator_Level l);
	void gotRemote(char *p, Command *c, Operator_Level l);
};


// The botlist contains every bot to ever be spawned of this type,
// some entries may no longer exist.

extern _linkedlist <botInfo> botlist;

botInfo *findBot(CALL_HANDLE handle);


#endif	// SPAWN_H
