#include "spawn.h"

#include "..\algorithms.h"

#include "..\dllcore.cpp"
#include "..\datatypes.cpp"
#include "..\algorithms.cpp"
#include "..\player.cpp"
#include "..\commtypes.cpp"

#define UNASSIGNED 0xffff

#define FOR_EACH_PLAYER(x) for(_listnode <Player> *parse = playerlist->head;parse && (x = parse->item);parse = parse->next)

int botInfo::getOobTile() // get the tile the ball will go oob on
{
	if (!ball)
		return -2;

	// coords of field
	// top = 7056
	// bottom = 9312
	// left = 5808
	// right = 10592

	int firedX = ball->x;
	int firedY = ball->y;

	int xVel = ball->xvel;
	int yVel = ball->yvel;
	int rv = -1;

	if (yVel == 0)
	{
		if (xVel < 0)
			rv = 16 * (OOB_LEFT - 1); // left endzone
		if (xVel > 0)
			rv = 16 * (OOB_RIGHT + 1); // right endzone
	}
	else if (yVel < 0)
	{ // up
		int distanceInY = firedY - OOB_TOP * 16;
		double groupsOfY = (double)distanceInY / (double)(-yVel);
		int distanceInX = (int)(xVel * groupsOfY);

		int xPixel = firedX + distanceInX;

		if (xPixel < 0) // way to the right
			xPixel = 0; // to prevent confusion with error values

		rv = xPixel;
	}
	else
	{
		int distanceInY = (OOB_BOTTOM - 1) * 16 - firedY;
		double groupsOfY = (double)distanceInY / (double)(yVel);
		int distanceInX = (int)(xVel * groupsOfY);

		int xPixel = firedX + distanceInX;

		if (xPixel < 0) // way to the right
			xPixel = 0; // to prevent confusion with error values

		rv = xPixel;
	}

	return rv / 16;
}


Player* botInfo::findPlayerWithID(int id)
{
	Player *p;
	Player *rv = NULL;

	FOR_EACH_PLAYER(p)
	{
		if (p->ident == id)
		{
			rv = p;
			break;
		}
	}

	return rv;
}

String botInfo::toCapNameString(String s) // cap name -> cap string
{
	String name = "none";

	if (s.len > 0)
		name = s;

	return name;
}

void botInfo::refreshAllLvz()
{
	Player *p;
	FOR_EACH_PLAYER(p)
	{
		if (p->ship == SHIP_Spectator)
			addToLvzBuffer(337,true);
		else
			addToLvzBuffer(338,true);
	}

	for (int counter = 1; counter < 600;counter++)
	{
		if (counter == 337 || counter == 338)
			continue;

		if (objects[counter] == true)
		{
			addToLvzBuffer(counter,true);
		}
		else
			addToLvzBuffer(counter,false);
	}

	flushLvzBuffer();
}

int botInfo::numSpeccers() // get number of player(non-bot) spectators
{
	Player *p;
	int count = 0;

	FOR_EACH_PLAYER(p)
	{
		if (p != me && p->ship == SHIP_Spectator)
		{
			++count;
		}
	}

	return count;
}

int botInfo::getNumPlayersInGameOnTeam(int freq)
{
	Player *p;
	int count = 0;

	FOR_EACH_PLAYER(p)
	{
		if (p->team == freq && p->ship != SHIP_Spectator)
		{
			++count;
		}
	}

	return count;
}

Player* botInfo::findPlayerWithName(const char* name)
{
	short playerCounter = 0;
	Player *thePlayer = NULL;
	unsigned short nameLength;
	String fullName;
	//short c;
	String searchName = name;

	for (nameLength = 0; nameLength < 50; nameLength++)
	{
		if (name[nameLength] == '\0')
			break;
	}

	if (nameLength == 0 || nameLength == 50)
		return NULL;

	_listnode <Player> *parse = playerlist->head;

	while (parse)
	{
		fullName = (String)(parse->item->name);

		if (fullName.left(nameLength) == searchName)
		{
			thePlayer = parse->item;
			if (fullName.len == nameLength)
				return thePlayer; // if it exactly matches
			playerCounter++;
		}

		parse = parse->next;
		if (parse == playerlist->head) break;
	}

	if (playerCounter > 1)
		return me; // more than one match

	return thePlayer;
}

void botInfo::addToLvzBuffer(int id, bool on)
{
	lvzBuffer.push_back(pair<bool,int>(on,id));
}

void botInfo::flushLvzBuffer()
{// *objset +1,-2,+3,+4,+5,

	string announce = "";
	for (unsigned int x = 0; x < lvzBuffer.size();++x)
	{
		if (lvzBuffer[x].first == true)
			announce += "+";
		else
			announce += "-";

		String temp(lvzBuffer[x].second);

		announce += temp;
		announce += ",";

		if (announce.length() > 200)
		{
			sendPublic("*objset " + (String)announce.c_str());
			announce = "";
		}
	}

	if (announce.length() > 0)
	{
		sendPublic("*objset " + (String)announce.c_str());
	}

	lvzBuffer.clear();
}

void botInfo::flushLvzBuffer(Player *p)
{// *objset +1,-2,+3,+4,+5,

	string announce = "";
	for (unsigned int x = 0; x < lvzBuffer.size();++x)
	{
		if (lvzBuffer[x].first == true)
			announce += "+";
		else
			announce += "-";

		String temp(lvzBuffer[x].second);

		announce += temp;
		announce += ",";

		if (announce.length() > 200)
		{
			sendPrivate(p,"*objset " + (String)announce.c_str());
			announce = "";
		}
	}

	if (announce.length() > 0)
	{
		sendPrivate(p,"*objset " + (String)announce.c_str());
	}

	lvzBuffer.clear();
}

void botInfo::sendPlayerObjects(Player *p)
{
	if (p->ship == SHIP_Spectator)
		addToLvzBuffer(337,true);
	else
		addToLvzBuffer(338,true);

	for (int counter = 1; counter < 600;counter++)
	{
		if (counter == 337 || counter == 338)
			continue;

		if (objects[counter] == true)
		{
			addToLvzBuffer(counter,true);
		}
	}

	flushLvzBuffer(p);
}

void botInfo::nextCapt(Player *p)
{
	Player *cap0 = findPlayerWithExactName(cap[0]);
	Player *cap1 = findPlayerWithExactName(cap[1]);

	if (mode == BEFORE_PICKING)
	{
		if (CMPSTR(p->name, cap[0].msg) || CMPSTR(p->name, cap[1].msg))
		{
			sendPrivate(p,"You are already a captain.");
		}
		else if (!findPlayerWithExactName(cap[0].msg))
		{
			cap[0] = p->name;
			cap0 = p;
			sendPublic("*arena New Captains: " + toCapNameString(cap[0]) + " and " + toCapNameString(cap[1]) + "!");
			setTeamNames(cap[0] + (String)":" + cap[1]);
		}
		else if (!findPlayerWithExactName(cap[1].msg))
		{
			cap[1] = p->name;
			cap1 = p;
			sendPublic("*arena New Captains: " + toCapNameString(cap[0]) + " and " + toCapNameString(cap[1]) + "!");
			setTeamNames(cap[0] + (String)":" + cap[1]);
		}
		else
		{
			sendPrivate(p,"Both teams already have a captain.");
		}

		if (cap0 && cap1 && mode == BEFORE_PICKING)
		{
			mode = PICKING;

			sendPrivate(cap0, "Use !add *name* to add a player");
			sendPrivate(cap0, "Use !remove *name* to remove a player");

			sendPrivate(cap1, "Use !add *name* to add a player");
			sendPrivate(cap1, "Use !remove *name* to remove a player");
		}
		
	}
	else // if we're in the game
	{
		if (p->ship == SHIP_Spectator)
		{
			sendPrivate(p, "You must be on a team to be a captain.");
		}
		else
		{
			if (p->team == 0)
			{
				if (!cap0 || cap0->ship == SHIP_Spectator)
				{ // no active cap1
					cap[0] = p->name;

					setTeamNames(cap[0] + (String)":" + cap[1]);

					sendPublic("*arena New Captains: " + toCapNameString(cap[0]) + " and " + toCapNameString(cap[1]) + "!");
				}
				else
				{
					sendPrivate(p,"Your team already has a captain.");
				}
			}
			else if (p->team == 1)
			{
				if (!cap1 || cap1->ship == SHIP_Spectator)
				{
					cap[1] = p->name;

					setTeamNames(cap[0] + (String)":" + cap[1]);
					sendPublic("*arena New Captains: " + toCapNameString(cap[0]) + " and " + toCapNameString(cap[1]) + "!");
				}
				else
				{
					sendPrivate(p,"Your team already has a captain.");
				}
			}		
		}
	}
}

void botInfo::setTeamNames(const char *final)
{
	String team1 = "";
	String team2 = "";
	bool firstTeam = true;
	char temp[2] = " ";

	for (int counter = 0; final[counter] != '\0';counter++)
	{
		if (final[counter] == ':')
			firstTeam = false;
		else if (firstTeam)
		{
			temp[0] = final[counter];
			if (temp[0] == ' ')
				team1+= " ";
			else
				team1+=temp;

		}
		else
		{
			temp[0] = final[counter];
			if (temp[0] == ' ')
				team2+=" ";
			else
				team2+=temp;
		}
	}

	turnOnObject(team1,TEAM_ONE_NAME);
	turnOnObject(team2,TEAM_TWO_NAME);
}

void botInfo::makeBlank(Uint32 letter)
{
	// letters are 1-4 for team 1 and 5-8 for team 2
	for (short counter = 0; counter < 26; counter++)
	{
		if (objects[381 + (letter - 1) * 26 + counter] == true)
		{
			objects[381 + (letter - 1) * 26 + counter] = false;
			sendPublic("*objoff " + (String)(381 + (letter - 1) * 26 + counter));
		}
	}
	//sendPublic("Letter " + (String)letter + " turned off.");
}

void botInfo::turnOnObject(String name, short type)
{
	name.lcase();
	name = name.left(4);

	//sendPublic("name1 -> " + name);

	Uint32 counter;

	for (counter = 0; counter < name.len;counter++)
	{
		if (name.msg[counter] < 'a' || name.msg[counter] > 'z')
			name.msg[counter] = ' ';
	}

	for (counter = name.len; counter < 4;counter++)
	{
		name+= " ";
	}

	//sendPublic("name -> " + name);
	//sendPublic("skit skat");

	if (name == "    ")
		name = "team";

	if (type == TEAM_ONE_NAME)
	{
		teamOneName = name;
		if (name == "team")
		{ // default graphic
			turnOnObject(379);
		}
		else
		{
			for (counter = 0; counter < 4; counter++)
			{
				if (name.msg[counter] == ' ')
				{
					makeBlank(1 + counter);
				}
				else
				{
					turnOnObject((short)(26 * counter + 381 + (name.msg[counter] - 'a')));
				}
			}
		}

		return;
	}

	if (type == TEAM_TWO_NAME)
	{
		teamTwoName = name;
		if (name == "team")
		{ // default graphic
			turnOnObject(380);
		}
		else
		{
			for (counter = 0; counter < 4; counter++)
			{
				if (name.msg[counter] == ' ')
				{
					makeBlank(5 + counter);
				}
				else
				{
					turnOnObject((short)(26 * counter + 485 + (name.msg[counter] - 'a')));
				}
			}
		}
	}

}

void botInfo::turnOnObject(short number, short type)
{
	if (type == HALF)
	{
		if (number < 1 || number > 3)
			return; // illegal

		turnOnObject(590 + number);
	}

	if (type == TEAM_ONE_TIMEOUT)
	{
		
		if (number == 0)
		{
			if (objects[373] == true)
			{
				objects[373] = false;
				sendPublic("*objoff 373");
			}
			if (objects[374] == true)
			{
				objects[374] = false;
				sendPublic("*objoff 374");
			}
			if (objects[375] == true)
			{
				objects[375] = false;
				sendPublic("*objoff 375");
			}
		}
		else if (number > 0 && number < 4)
			turnOnObject(372 + number);

		return;
	}

	if (type == TEAM_TWO_TIMEOUT)
	{
		if (number == 0)
		{
			if (objects[376] == true)
			{
				objects[376] = false;
				sendPublic("*objoff 376");
			}
			if (objects[377] == true)
			{
				objects[377] = false;
				sendPublic("*objoff 377");
			}
			if (objects[378] == true)
			{
				objects[378] = false;
				sendPublic("*objoff 378");
			}
		}
		else if (number > 0 && number < 4)
			turnOnObject(375 + number);

		return;
	}

	if (type == POSSESION)
	{
		if (number < 0 || number > 2)
			number = 0;

		if (number == 0)
			turnOnObject(371);
		else
			turnOnObject(334 + number);

		return;

	}

	if (type == TEAM_ONE_SCORE)
	{
		if (number < 0 || number > 199)
			number = 199;

		turnOnObject(number % 10 + 200);
		turnOnObject((number / 10) + 210);

		return;
	}

	if (type == TEAM_TWO_SCORE)
	{
		if (number < 0 || number > 199)
			number = 199;

		turnOnObject(number % 10 + 230);
		turnOnObject((number / 10) + 240);

		return;
	}

	if (type == PLAY_CLOCK)
	{
		if (number < 0 || number > 99)
		number = 99;

		turnOnObject(number % 10 + 270);
		turnOnObject((number / 10) + 280);

		return;
	}

	if (type == TIMER)
	{
		if (number < 0 || number > 1259)
		number = 1259;

		if (number < 1200)
			turnOnObject((number / 60) + 310);
		else
			turnOnObject(589);
		
		turnOnObject(number % 10 + 290);
		turnOnObject((number / 10) % 6 + 300);

		return;
	}

	if (type == DOWN)
	{
		//sendPublic("*arena turning on down!");
		if (number < 1 || number > 4)
		number = 4;

		turnOnObject(number + 330);

		return;
	}

	if (type == TOGO)
	{
		if (number < -1 || number > 99)
		number = 99;

		if (number == 0) // turn off graphics cause possesion == 0
		{
			turnOffDown();
			return;
		}

		if (number > 9)
		{
			turnOnObject(number % 10 + 340);
			turnOnObject(number / 10 + 350);
		} 
		else if (number != -1)
		{
			turnOnObject(number + 360);
		}
		else
		{
			turnOnObject(339);
		}
	}
}

void botInfo::turnOffDown()
{
	 // down = 331-334
	 // yards To go = 340-349, 351-359, 361 - 369, 339

	int i;

	for(i = 331; i < 335;++i)
	{ // 1st, 2nd, ect.
		if(objects[i])
		{
			objects[i] = false;
			sendPublic("*objoff " + (String)i);
		}
	}

	for(i = 340; i < 370;++i)
	{ // tens / ones
		if(objects[i])
		{
			objects[i] = false;
			sendPublic("*objoff " + (String)i);
		}
	}

	if(objects[339])
	{ // and goal
		objects[339] = false;
		sendPublic("*objoff " + (String)339);
	}

}

void botInfo::turnOnObject(short objectNumber)
{
	int counter = 0;

	if (objectNumber > 999)
		objectNumber = 96;

	if (objectNumber < 1)
		objectNumber = 4;

	if (objectNumber > 590 && objectNumber < 594)
	{
		for (counter = 591; counter <= 593;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		}
	}

	if (objectNumber == 379)
	{ // team 1 default name
		for (counter = 381; counter < 485;counter++)
		{
			if (objects[counter])
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[379] == false)
		{
			objects[379] = true;
			sendPublic("*objon 379");
		}

		return;
	}

	if (objectNumber == 380)
	{ // team 2 default name
		for (counter = 485; counter < 589;counter++)
		{
			if (objects[counter])
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[380] == false)
		{
			objects[380] = true;
			sendPublic("*objon 380");
		}

		return;
	}

	if (objectNumber >= 381 && objectNumber <= 406)
	{ // letter 1

		for (counter = 381; counter <= 406;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[379] == true)
		{ // default team 1 graphic
			objects[379] = false;
			sendPublic("*objoff 379");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 407 && objectNumber <= 432)
	{ // letter 2

		for (counter = 407; counter <= 432;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[379] == true)
		{ // default team 1 graphic
			objects[379] = false;
			sendPublic("*objoff 379");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 433 && objectNumber <= 458)
	{ // letter 3

		for (counter = 433; counter <= 458;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[379] == true)
		{ // default team 1 graphic
			objects[379] = false;
			sendPublic("*objoff 379");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 459 && objectNumber <= 484)
	{ // letter 4

		for (counter = 459; counter <= 484;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[379] == true)
		{ // default team 1 graphic
			objects[379] = false;
			sendPublic("*objoff 379");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 485 && objectNumber <= 510)
	{ // letter 5

		for (counter = 485; counter <= 510;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[380] == true)
		{ // default team 1 graphic
			objects[380] = false;
			sendPublic("*objoff 380");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 511 && objectNumber <= 536)
	{ // letter 6

		for (counter = 511; counter <= 536;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[380] == true)
		{ // default team 1 graphic
			objects[380] = false;
			sendPublic("*objoff 380");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 537 && objectNumber <= 562)
	{ // letter 7

		for (counter = 537; counter <= 562;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[380] == true)
		{ // default team 1 graphic
			objects[380] = false;
			sendPublic("*objoff 380");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 563 && objectNumber <= 588)
	{ // letter 8

		for (counter = 563; counter <= 588;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				objects[counter] = false;
				sendPublic("*objoff " + (String)counter);
			}
		}

		if (objects[380] == true)
		{ // default team 1 graphic
			objects[380] = false;
			sendPublic("*objoff 380");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 372 && objectNumber <= 375)
	{// team 1 dots
		
		for (counter = 372; counter < 376;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}

	if (objectNumber >= 376 && objectNumber <= 378)
	{// team 2 dots
		
		for (counter = 376; counter < 379;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}

		return;
	}
	
	if (objectNumber == 371 || objectNumber == 335 || objectNumber == 336)
	{// possesion
		if (objectNumber == 371)
		{// special teams
			if (objects[335])
			{
				objects[335] = false;
				sendPublic("*objoff 335");
			}
			if (objects[336])
			{
				objects[336] = false;
				sendPublic("*objoff 336");
			}
			if (!objects[371])
			{
				objects[371] = true;
				sendPublic("*objon 371");
			}

			// turn off "AND"
			if (objects[370] == true)
			{
				objects[370] = false;
				sendPublic("*objoff 370");
			}
			
		}
		else if (objectNumber == 335)
		{
			if (!objects[335])
			{
				objects[335] = true;
				sendPublic("*objon 335");
			}
			if (objects[336])
			{
				objects[336] = false;
				sendPublic("*objoff 336");
			}
			if (objects[371])
			{
				objects[371] = false;
				sendPublic("*objoff 371");
			}

			if (objects[370] == false)
			{
				objects[370] = true;
				sendPublic("*objon 370");
			}

		}
		else if (objectNumber == 336)
		{
			if (objects[335])
			{
				objects[335] = false;
				sendPublic("*objoff 335");
			}
			if (!objects[336])
			{
				objects[336] = true;
				sendPublic("*objon 336");
			}
			if (objects[371])
			{
				objects[371] = false;
				sendPublic("*objoff 371");
			}
			if (objects[370] == false)
			{
				objects[370] = true;
				sendPublic("*objon 370");
			}
		}

		//// turn on lines
		//showLinesAndDown();

		return;
	
	}

	// --------------

	//----------------------

	if (objectNumber >= 200 && objectNumber < 210)
	{// team one score (ones)
		
		for (counter = 200; counter < 210;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber >= 210 && objectNumber < 230)
	{// team one score (tens or hunderds + tens)
		
		for (counter = 210; counter < 230;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false && objectNumber != 210)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}

	//--------------------

	if (objectNumber >= 230 && objectNumber < 240)
	{// team two score (ones)
		
		for (counter = 230; counter < 240;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber >= 240 && objectNumber < 260)
	{// team two score (tens)
		
		for (counter = 240; counter < 260;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false && objectNumber != 240)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}

	//----------------------

	if (objectNumber >= 270 && objectNumber < 280)
	{// playclock (ones)
		
		for (counter = 270; counter < 280;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber >= 280 && objectNumber < 290)
	{// playclock (tens)
		
		for (counter = 280; counter < 290;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}

	//----------------------

	if (objectNumber >= 290 && objectNumber < 300)
	{// timer (seconds - ones)
		
		for (counter = 290; counter < 300;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber >= 300 && objectNumber < 310)
	{// timer (seconds - tens)
		for (counter = 300; counter < 310;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber >= 310 && objectNumber < 320)
	{// timer (minutes - ones)
		
		for (counter = 310; counter < 329;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[589])
		{
			objects[589] = false;
			sendPublic("*objoff 589");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber >= 320 && objectNumber < 330 || objectNumber == 589)
	{// timer (minutes - ten + ones)
		
		for (counter = 310; counter < 330;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[589] && objectNumber != 589)
		{
			objects[589] = false;
			sendPublic("*objoff 589");
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}

	//----------------------

	if (objectNumber >= 340 && objectNumber < 350)
	{// yards to go (ones - when yards to go is > 10)
		
		for (counter = 339; counter < 350;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		for (counter = 360; counter < 370;counter++)
		{
			if (objects[counter] == true)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber >= 350 && objectNumber < 360)
	{//yards to go (tens)
		
		for (counter = 350; counter < 370;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}
	if (objectNumber == 339)
	{//yards to go (goal)

		for (counter = 340; counter < 370;counter++)
		{
			if (objects[counter] == true)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[339] == false)
		{
			sendPublic("*objon 339");
			objects[339] = true;
		}	

		return;
	}
	if (objectNumber >= 360 && objectNumber < 370)
	{//yards to go (ones - when yards to go is < 10)		
		
		for (counter = 339; counter < 370;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}
		
		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}
		
		return;
	}

	//-----------------------------------

	if (objectNumber >= 331 && objectNumber < 335)
	{//down
				
		for (counter = 331; counter < 335;counter++)
		{
			if (objects[counter] == true && counter != objectNumber)
			{
				sendPublic("*objoff " + (String)counter);
				objects[counter] = false;
			}
		}

		if (objects[objectNumber] == false)
		{
			objects[objectNumber] = true;
			sendPublic("*objon " + (String)objectNumber);
		}		

		return;
	}
}

Player* botInfo::findPlayerWithExactName(const char* name)
{
	_listnode <Player> *parse = playerlist->head;

	while (parse)
	{
		if (string(parse->item->name) == string(name))
			return parse->item;

		parse = parse->next;
	}

	return NULL;
}

void botInfo::placeBall(int xCoord, int yCoord) // place the ball on xcoord,ycoord
{
	tell(makeShip(SHIP_Warbird));
	tell(makeGrabBall(0));
	tell(makeFireBall(0,xCoord,yCoord,0,0));
	tell(makeShip(SHIP_Spectator));
}

void botInfo::makeRegions()
{
	spawnArea.rects.push_back(Rect(500,372,26,7));
}


// add to a region using a fill mechenism
// r -> the region to add ti
// start -> the starting point
// endTiles -> the tiles to end on
void botInfo::addToRegion(Region *r, Point *start,set<int> *endTiles)
{
	list<Point> toProcess;
	toProcess.push_back(*start);
	bool cont = false;

	while (!toProcess.empty())
	{
		Point p = toProcess.back();
		toProcess.pop_back();

		if (p.x < 0 || p.x > 1023 || p.y < 0 || p.y > 1023)
			continue;

		if (r->pts.find(p) != r->pts.end())
			continue; // point is already added

		int tile = map[p.x+ p.y *1024];

		cont = true;

		if (endTiles->find(tile) != endTiles->end())
		{
			cont = false;
		}

		if (!cont)
			continue;

		r->pts.insert(p);

		toProcess.push_back(Point(p.x + 1,p.y));
		toProcess.push_back(Point(p.x - 1,p.y));
		toProcess.push_back(Point(p.x,p.y + 1));
		toProcess.push_back(Point(p.x,p.y - 1));
	}
}

bool Region::containsPlayerExactly(Player *pl) // does this region contain the center of this player's ship?
{
	Point p(pl->tile.x,pl->tile.y);
	Point *cur = &p;
	bool rv = false;

	for (unsigned int x = 0; x < rects.size();++x)
	{
		if (rects[x].contains(cur->x,cur->y))
		{
			rv = true;
			break;
		}
	}

	if (!rv && pts.find(*cur) != pts.end())
	{
		rv = true;
	}

	return rv;
}

bool Region::containsPlayer(Player *pl) // does this region contain this player?
{
	Point p(pl->pos.x,pl->pos.y);
	int west = (p.x - 15)/16;
	int east = (p.x + 15)/16;
	int north = (p.y - 15)/16;
	int south = (p.y + 15)/16;
	int x = p.x / 16;
	int y = p.y / 16;
	bool rv = false;	
	Point points[9];
	
	points[0] = Point(west,north); // nw
	points[1] = Point(x,north); // n
	points[2] = Point(east,north); // ne
	points[3] = Point(west,y); // w
	points[4] = Point(x,y); // c
	points[5] = Point(east,y); // e
	points[6] = Point(west,south); // w
	points[7] = Point(x,south); // c
	points[8] = Point(east,south); // e

	for (int i = 0; i < 9;++i)
	{
		Point *cur = &(points[i]);

		for (unsigned int x = 0; x < rects.size();++x)
		{
			if (rects[x].contains(cur->x,cur->y))
			{
				rv = true;
				break;
			}
		}

		if (rv)
			break;

		if (pts.find(*cur) != pts.end())
		{
			rv = true;
			break;
		}
	}

	return rv;
}

// Rectangle Class
Rect::Rect()
{
	x = 0;
	y = 0;
	width = 0;
	height = 0;
}

Rect::Rect(int newx, int newy, int newwidth, int newheight)
{
	x = positiveorzero(newx);
	y = positiveorzero(newy);
	width = positiveorzero(newwidth);
	height = positiveorzero(newheight);
}

Rect::Rect(int newx, int newy, int newwidth)
{
	x = positiveorzero(newx);
	y = positiveorzero(newy);
	width = positiveorzero(newwidth);
	height = positiveorzero(2 * (512 - y));
}

int Rect::getX()
{
	return x;
}

int Rect::getY()
{
	return y;
}

int Rect::getWidth()
{
	return width;
}

int Rect::getHeight()
{
	return height;
}

void Rect::flip()
{
	int newx = 16384 - x - width - 1; // +1 ???
	x = newx;
}

void Rect::setWidth(int newwidth)
{
	width = positiveorzero(newwidth);
}

void Rect::setHeight(int newheight)
{
	height = positiveorzero(newheight);
}

bool Rect::contains(int xToCheck, int yToCheck)
{
	if (xToCheck > x && yToCheck > y)
	{
		if (xToCheck < (x + width) && yToCheck < (y + height))
			return true;
	}
	
	return false;
}

void Rect::set(Rect *anotherRect)
{
	x = anotherRect->getX();
	y = anotherRect->getY();
	width = anotherRect->getWidth();
	height = anotherRect->getHeight();
}

void Rect::operator=(Rect *anotherRect)
{
	set(anotherRect);
}

String Rect::toString()
{
	String msg = "X: ";
	msg+=x;
	msg+= " Y: ";
	msg+=y;
	msg+= " Width: ";
	msg+=width;
	msg+= " Height: ";
	msg+=height;

	return msg;
}

int Rect::positiveorzero(int value)
{
	if (value >= 0)
		return (value);
	
	return (0);
}

String botInfo::getTimeString(int seconds)
{
	String workingString = "";

	workingString += (String)(seconds / 60);
	workingString += ":";
	workingString += getString(seconds % 60, 10, 2, true);

	return workingString;
}

//////// Bot list ////////

_linkedlist <botInfo> botlist;

botInfo *findBot(CALL_HANDLE handle)
{
	_listnode <botInfo> *parse = botlist.head;

	while (parse)
	{
		botInfo *item = parse->item;

		if (item->validate(handle))
			return item;

		parse = parse->next;
	}

	return 0;
}


//////// DLL "import" ////////

void botInfo::tell(BotEvent &event)
{
	if (callback && handle)
	{
		event.handle = handle;
		callback(event);
	}
}

void botInfo::gotEvent(BotEvent &event)
{
	if (CONNECTION_DENIED) return;

	switch (event.code)
	{
//////// Periodic ////////
	case EVENT_Tick:
		{
			Player *p;
			int inGameCount = 0;

			FOR_EACH_PLAYER(p)
			{
				// decrement bans
				int secLeft = get_tag(p,TAG_BANNEDTIME);

				if (secLeft == 1)
				{
					sendPrivate(p,"You may now go in, but if the captain really doesn't want you in don't be rude and keep going in.");
				}
				else if (secLeft > 1 && p->ship != SHIP_Spectator)
				{
					sendPrivate(p,"A captain has removed you. Please don't go in for another " + (String)secLeft + " seconds.");
					sendPrivate(p,"*spec");
					sendPrivate(p,"*spec");
				}

				--secLeft;

				if (secLeft >= 0)
				{					
					set_tag(p,TAG_BANNEDTIME,secLeft);
				}

				// player count
				if (p->ship != SHIP_Spectator)
					++inGameCount;

				// player ships legal?
				if (p->team == 0 || p->team == 1)
				{
					if (p->ship == SHIP_Spectator)
						sendPrivate(p,"*setfreq 2"); // no spectators!
					else if (!fg.isLegalShip(p->team, p->ship))
						sendPrivate(p,"*setship " + (String)fg.getDefaultShip(p->team));
				}

				// is captain on the other team?

				if (cap[0] == p->name && p->team == 1)
				{
					sendPrivate(p,"You have lost your captainship of freq 0 by joining freq 1.");
					cap[0] = "";
					teamOneName = "team";
					setTeamNames(teamOneName + ":" + teamTwoName);
				}
				else if (cap[1] == p->name && p->team == 0)
				{
					sendPrivate(p,"You have lost your captainship of freq 1 by joining freq 0.");
					cap[1] = "";
					teamTwoName = "team";
					setTeamNames(teamOneName + ":" + teamTwoName);
				}

				// am I in the game?
				if (me && me->ship != SHIP_Spectator)
				{
					tell(makeShip(SHIP_Spectator));
				}
			}

			if (mode == PICKING && (inGameCount == playersPerTeam * 2 || numSpeccers() == 0) 
					&& findPlayerWithExactName(cap[0]) && findPlayerWithExactName(cap[1]))
			{ // do coin toss
				shouldBeLocked = false;
				sendPublic("*lock");

				mode = COIN_TOSS;
				pickingCaptain = rand() % 2;

				sendPublic("*arena COIN TOSS: " + (String)cap[pickingCaptain] + ", heads or tails?");
				coinTossed = false;
			}


			fg.tick();
		}
		break;
//////// Arena ////////
	case EVENT_ArenaEnter:
		{
			arena = (char*)event.p[0];
			me = (Player*)event.p[1];	// if(me) {/*we are in the arena*/}
			bool biller_online = *(bool*)&event.p[2];

			refreshAllLvz();

			sendPublic("*lock");
			sendPublic("*specall");
		}
		break;
	case EVENT_ArenaSettings:
		{
			settings = (arenaSettings*)event.p[0];
		}
		break;
	case EVENT_ArenaLeave:
		{
			me = 0;
			killTags();
		}
		break;
	case EVENT_ArenaListEntry:
		{
			char *name = (char*)event.p[0];
			bool current = *(bool*)&event.p[1];
			int population = *(int*)&event.p[2];
		}
		break;
	case EVENT_ArenaListEnd:
		{
			char *name = (char*)event.p[0];
			bool current = *(bool*)&event.p[1];
			int population = *(int*)&event.p[2];
		}
		break;
//////// Flag ////////
	case EVENT_FlagGrab:
		{
			Player *p = (Player*)event.p[0];
			Flag *f = (Flag*)event.p[1];
		}
		break;
	case EVENT_FlagDrop:
		{
			Player *p = (Player*)event.p[0];
		}
		break;
	case EVENT_FlagMove:
		{
			Flag *f = (Flag*)event.p[0];
		}
		break;
	case EVENT_FlagVictory:
		{
			int team = *(int*)&event.p[0];
			int reward = *(int*)&event.p[1];
		}
		break;
	case EVENT_FlagGameReset:
		{
		}
		break;
	case EVENT_FlagReward:
		{
			int team = *(int*)&event.p[0];
			int reward = *(int*)&event.p[1];
		}
		break;
//////// Timed ////////
	case EVENT_TimedGameOver:
		{
			Player *p[5];
			for (int i = 0; i < 5; i++)
				p[i] = (Player*)event.p[i];
		}
		break;
//////// Soccer ////////
	case EVENT_SoccerGoal:
		{
			int team = *(int*)&event.p[0];
			int reward = *(int*)&event.p[1];

			fg.goal();
			justScoredAGoal = true;
		}
		break;
	case EVENT_BallMove:
		{
			ball = (PBall*)event.p[0];
			
			Player* ballCarrier = findPlayerWithID(ball->carrier);

			if (ballCarrier != me)
			{
				if (!lastBallCarrier && !ballCarrier && justScoredAGoal)
				{
					justScoredAGoal = false;
					fg.ballSpawnAfterGoal();
				}
				else if (ballCarrier && ballCarrier != lastBallCarrier)
					fg.playerPickedUpBall(ballCarrier);
				else if (lastBallCarrier && !ballCarrier)
					fg.playerThrewBall(lastBallCarrier,ball);

				lastBallCarrier = ballCarrier;
			}
			else
			{
				lastBallCarrier = NULL;
			}
		}
		break;
//////// File ////////
	case EVENT_File:
		{
			char *name = (char*)event.p[0];
		}
		break;
//////// Player ////////
	case EVENT_PlayerEntering:
		{
			Player *p = (Player*)event.p[0];

			sendPlayerObjects(p);
		}
		break;
	case EVENT_PlayerMove:
		{
			Player *p = (Player*)event.p[0];

			if (p == me)
				return;

			// spawning players need to be warped
			if (p->ship != SHIP_Spectator && !fg.playOn && spawnArea.containsPlayerExactly(p))
			{
				if (fg.isLegalShip(p->team, p->ship) && get_tag(p,TAG_BANNEDTIME) == 0)
				{
					int x = get_tag(p,TAG_LASTX);
					int y = get_tag(p,TAG_LASTY);

					if (x == 0 || y == 0) // invalid tags, warp normally
						fg.warpPlayer(p);
					else
					{
						if (x < OOB_LEFT)
							x = OOB_LEFT;
						else if (x > OOB_RIGHT)
							x = OOB_RIGHT;

						if(y < OOB_TOP)
							y = OOB_TOP;
						else if (y > OOB_BOTTOM)
							y = OOB_BOTTOM;

						sendPrivate(p,"*warpto " + (String)x + " " + (String)y);
					}
				}
			}
			else if (!spawnArea.containsPlayerExactly(p))
			{
				int x = p->tile.x;
				int y = p->tile.y;

				if (x < OOB_LEFT)
					x = OOB_LEFT;

				if (x > OOB_RIGHT)
					x = OOB_RIGHT;

				if (x < OOB_TOP)
					x = OOB_TOP;

				if (x > OOB_BOTTOM)
					x = OOB_BOTTOM;

				set_tag(p,TAG_LASTX,x);
				set_tag(p,TAG_LASTY,y);

				fg.playerMoved(p);
			}
		}
		break;
	case EVENT_PlayerWeapon:
		{
			Player *p = (Player*)event.p[0];
			weaponInfo wi;
			wi.n = *(Uint16*)&event.p[1];
		}
		break;
	case EVENT_WatchDamage:
		{
			Player *p = (Player*)event.p[0];	// player
			Player *k = (Player*)event.p[1];	// attacker
			weaponInfo wi;
			wi.n = *(Uint16*)&event.p[2];
			Uint16 energy = *(Uint16*)&event.p[3];
			Uint16 damage = *(Uint16*)&event.p[4];
		}
		break;
	case EVENT_PlayerDeath:
		{
			Player *p = (Player*)event.p[0],
				   *k = (Player*)event.p[1];
			Uint16 bounty = (Uint16)event.p[2];
		}
		break;
	case EVENT_PlayerScore:
		{
			Player *p = (Player*)event.p[0];
		}
		break;
	case EVENT_PlayerPrize:
		{
			Player *p = (Player*)event.p[0];
			int prize = *(int *)&event.p[1];
		}
		break;
	case EVENT_PlayerShip:
		{
			Player *p = (Player*)event.p[0];
			Uint16 oldship = (Uint16)event.p[1];
			Uint16 oldteam = (Uint16)event.p[2];

			if (p == me)
				return;

			if (p->ship == SHIP_Spectator)
			{
				addToLvzBuffer(337,true);
				addToLvzBuffer(338,false);				
			}
			else if (oldship == SHIP_Spectator)
			{
				addToLvzBuffer(337,false);
				addToLvzBuffer(338,true);	
			}

			flushLvzBuffer(p);
		}
		break;
	case EVENT_PlayerSpec:
		{
			Player *p = (Player*)event.p[0];
			Uint16 oldteam = (Uint16)event.p[1];
			Uint16 oldship = (Uint16)event.p[2];

			if (p == me)
				return;
			
			if (p->ship == SHIP_Spectator)
				sendPrivate(p,"*objon 337");
			else if (oldship == SHIP_Spectator)
				sendPrivate(p,"*objon 338");
		}
		break;
	case EVENT_PlayerTeam:
		{
			Player *p = (Player*)event.p[0];
			Uint16 oldteam = (Uint16)event.p[1];
			Uint16 oldship = (Uint16)event.p[2];
		}
		break;
	case EVENT_PlayerLeaving:
		{
			Player *p = (Player*)event.p[0];

			fg.playerLeft(p);

			killTags(p);
		}
		break;
//////// Selfish ////////
	case EVENT_SelfShipReset:
		{
		}
		break;
	case EVENT_SelfPrize:
		{
			Uint16 prize = (Uint16)event.p[0];
			Uint16 count = (Uint16)event.p[1];
		}
		break;
	case EVENT_SelfUFO:
		{
		}
		break;
	case EVENT_PositionHook:
		{
		}
		break;
//////// Bricks ////////
	case EVENT_BrickDropped:
		{
			int x1 = *(int*)&event.p[0];
			int y1 = *(int*)&event.p[1];
			int x2 = *(int*)&event.p[2];
			int y2 = *(int*)&event.p[3];
			int team = *(int*)&event.p[4];
		}
		break;
//////// LVZ ////////
	case EVENT_ObjectToggled:
		{
			objectInfo obj;
			obj.n = (Uint16)event.p[0];
		}
		break;
//////// Turret ////////
	case EVENT_CreateTurret:
		{
			Player *turreter = (Player*)event.p[0];
			Player *turretee = (Player*)event.p[1];
		}
		break;
	case EVENT_DeleteTurret:
		{
			Player *turreter = (Player*)event.p[0];
			Player *turretee = (Player*)event.p[1];
		}
		break;
//////// Chat ////////
	case EVENT_Chat:
		{
			int type  = *(int*)&event.p[0];
			int sound = *(int*)&event.p[1];
			Player *p = (Player*)event.p[2];
			char *msg = (char*)event.p[3];

			switch (type)
			{
			case MSG_Arena:
				{
					if (CMPSTR(msg,"Arena LOCKED") && !shouldBeLocked)
					{
						sendPublic("*lock");
					}
					else if (CMPSTR(msg,"Arena UNLOCKED") && shouldBeLocked)
					{
						sendPublic("*lock");
					}
				}
				break;
			case MSG_PublicMacro:		if (!p) break;
				{
				}
				break;
			case MSG_Public:			if (!p) break;
				{
					String mes = msg;
					mes.lcase();

					if (cap[0] == p->name || cap[1] == p->name) // captain commands
					{
						if (coinTossed == false && cap[pickingCaptain] == p->name && (mes == "heads" || mes == "tails"))
						{
							int pick;

							if (mes == "heads")
								pick = 0;
							else
								pick = 1;

							//int pickingCaptain;

							int toss = rand() % 2;

							sendPublic("*arena The coin landed on " + (String)(toss == 0 ? "heads" : "tails") + "!");

							if (toss != pick)
								pickingCaptain = (pickingCaptain == 0 ? 1 : 0);

							coinTossed = true;
							sendPublic("*arena " + (String)cap[pickingCaptain] + ", kick or receive?");
						}
						else if (coinTossed == true && cap[pickingCaptain] == p->name && (mes == "kick" || mes == "receive"))
						{						
							// start the game with the appropriate team receiving the ball
							// i'll never use nested tertiary operators again, I promise...
							// why don't I change it instead of writing this long comment? screw you
							fg.startGame(mes == "kick" ? (pickingCaptain == 0 ? 1 : 0) : pickingCaptain);
						}

						if (mes == "ready" || mes == "rdy")
						{
							int team = (cap[0] == p->name ? 0 : 1);

							fg.captainSaid(READY, team);

						}
					}
				}
				break;
			case MSG_Team:				if (!p) break;
				{
				}
				break;
			case MSG_TeamPrivate:		if (!p) break;
				{
				}
				break;
			case MSG_Private:			if (!p) break;
				{
				}
				break;
			case MSG_PlayerWarning:		if (!p) break;
				{
				}
				break;
			case MSG_RemotePrivate:
				{
				}
				break;
			case MSG_ServerError:
				{
				}
				break;
			case MSG_Channel:
				{
				}
				break;
			};
		}
		break;
	case EVENT_LocalCommand:
		{
			Player *p = (Player*)event.p[0];
			Command *c = (Command*)event.p[1];

			gotCommand(p, c);
		}
		break;
	case EVENT_LocalHelp:
		{
			Player *p = (Player*)event.p[0];
			Command *c = (Command*)event.p[1];

			gotHelp(p, c);
		}
		break;
	case EVENT_RemoteCommand:
		{
			char *p = (char*)event.p[0];
			Command *c = (Command*)event.p[1];
			Operator_Level o = *(Operator_Level*)&event.p[2];

			gotRemote(p, c, o);
		}
		break;
	case EVENT_RemoteHelp:
		{
			char *p = (char*)event.p[0];
			Command *c = (Command*)event.p[1];
			Operator_Level o = *(Operator_Level*)&event.p[2];

			gotRemoteHelp(p, c, o);
		}
		break;
//////// Containment ////////
	case EVENT_Init:
		{
			int major	= HIWORD(*(int*)&event.p[0]);
			int minor	= LOWORD(*(int*)&event.p[0]);
			callback	= (CALL_COMMAND)event.p[1];
			playerlist	= (CALL_PLIST)event.p[2];
			flaglist	= (CALL_FLIST)event.p[3];
			map			= (CALL_MAP)event.p[4];
			bricklist	= (CALL_BLIST)event.p[5];

			if (major > CORE_MAJOR_VERSION)
			{
				tell(makeEcho("DLL plugin cannot connect.  This plugin is out of date."));

				CONNECTION_DENIED = true;

				return;
			}
			else if ((major < CORE_MAJOR_VERSION) || (minor < CORE_MINOR_VERSION))
			{
				tell(makeEcho("DLL plugin cannot connect.  This plugin requires the latest version of MERVBot."));

				CONNECTION_DENIED = true;

				return;
			}
			else
				tell(makeEcho("DLL plugin connected."));

		}
		break;
	case EVENT_Term:
		{
			tell(makeEcho("DLL plugin disconnected."));
		}
		break;
	};
}


//////// DLL export ////////

_declspec(dllexport) void __stdcall talk(BotEvent &event)
{
	botInfo *bot;

	bot = findBot(event.handle);

	if (!bot)
	{
		bot = new botInfo(event.handle);
		botlist.append(bot);
	}

	if (bot) bot->gotEvent(event);
}


//////// Tag emulation ////////

int botInfo::get_tag(Player *p, int index)
{
	_listnode <PlayerTag> *parse = taglist.head;
	PlayerTag *tag;

	while (parse)
	{
		tag = parse->item;

		if (tag->p == p)
		if (tag->index == index)
			return tag->data;

		parse = parse->next;
	}

	return 0;
}

void botInfo::set_tag(Player *p, int index, int data)
{
	_listnode <PlayerTag> *parse = taglist.head;
	PlayerTag *tag;

	while (parse)
	{
		tag = parse->item;

		if (tag->p == p)
		if (tag->index == index)
		{
			tag->data = data;
			return;
		}

		parse = parse->next;
	}

	tag = new PlayerTag;
	tag->p = p;
	tag->index = index;
	tag->data = data;
	taglist.append(tag);
}

void botInfo::killTags(Player *p)
{
	_listnode <PlayerTag> *parse = taglist.head;
	PlayerTag *tag;

	while (parse)
	{
		tag = parse->item;
		parse = parse->next;

		if (tag->p != p) continue;

		taglist.kill(tag);
	}
}

void botInfo::killTags()
{
	taglist.clear();
}


//////// LVZ Object Toggling ////////

void botInfo::clear_objects()
{
	num_objects = 0;
}

void botInfo::object_target(Player *p)
{
	object_dest = p;
}

void botInfo::toggle_objects()
{
	Player *p = object_dest;

	if (!p)	tell(makeToggleObjects(UNASSIGNED, (Uint16 *)object_array, num_objects));
	else	tell(makeToggleObjects(p->ident, (Uint16 *)object_array, num_objects));

	num_objects = 0;
}

void botInfo::queue_enable(int id)
{
	if (num_objects == MAX_OBJECTS)
		toggle_objects();

	object_array[num_objects].id = id;
	object_array[num_objects].disabled = false;
	++num_objects;
}

void botInfo::queue_disable(int id)
{
	if (num_objects == MAX_OBJECTS)
		toggle_objects();

	object_array[num_objects].id = id;
	object_array[num_objects].disabled = true;
	++num_objects;
}


//////// Chatter ////////

void botInfo::sendPrivate(Player *player, BYTE snd, char *msg)
{
	tell(makeSay(MSG_Private, snd, player->ident, msg));
}

void botInfo::sendPrivate(Player *player, char *msg)
{
	tell(makeSay(MSG_Private, 0, player->ident, msg));
}

void botInfo::sendTeam(char *msg)
{
	tell(makeSay(MSG_Team, 0, 0, msg));
}

void botInfo::sendTeam(BYTE snd, char *msg)
{
	tell(makeSay(MSG_Team, snd, 0, msg));
}

void botInfo::sendTeamPrivate(Uint16 team, char *msg)
{
	tell(makeSay(MSG_TeamPrivate, 0, team, msg));
}

void botInfo::sendTeamPrivate(Uint16 team, BYTE snd, char *msg)
{
	tell(makeSay(MSG_TeamPrivate, snd, team, msg));
}

void botInfo::sendPublic(char *msg)
{
	tell(makeSay(MSG_Public, 0, 0, msg));
}

void botInfo::sendPublic(BYTE snd, char *msg)
{
	tell(makeSay(MSG_Public, snd, 0, msg));
}

void botInfo::sendPublicMacro(char *msg)
{
	tell(makeSay(MSG_PublicMacro, 0, 0, msg));
}

void botInfo::sendPublicMacro(BYTE snd, char *msg)
{
	tell(makeSay(MSG_PublicMacro, snd, 0, msg));
}

void botInfo::sendChannel(char *msg)
{
	tell(makeSay(MSG_Channel, 0, 0, msg));
}

void botInfo::sendRemotePrivate(char *msg)
{
	tell(makeSay(MSG_RemotePrivate, 0, 0, msg));
}

void botInfo::sendRemotePrivate(char *name, char *msg)
{
	String s;
	s += ":";
	s += name;
	s += ":";
	s += msg;

	sendRemotePrivate(s);
}
