// Stan Bak
// New Football header
// This file will maintain the footbal game (hopefully)

#ifndef FOOTBALL_H_
#define FOOTBALL_H_

#include <string>
using namespace std;

#define INIT_SECONDS 900

#define REG_ZERO		0
#define REG_ONE			1
#define KICKOFF_ZERO	2
#define KICKOFF_ONE		3
#define PUNT_ZERO		4
#define PUNT_ONE		5
#define FG_ZERO			6
#define FG_ONE			7
#define PRE_GAME		8
#define EXTRA_ZERO		9
#define EXTRA_ONE		10
#define EXTRA_FAKE_ZERO	11
#define EXTRA_FAKE_ONE	12
#define PUNT_FAKE_ZERO	13
#define PUNT_FAKE_ONE	14
#define	FG_FAKE_ZERO	15
#define FG_FAKE_ONE		16

#define TOP_Y_LOS		489
#define BOTTOM_Y_LOS	535

// these are inclusive
#define OOB_TOP			440
#define OOB_BOTTOM		582
#define OOB_RIGHT		688
#define OOB_LEFT		336
#define TD_ZONE_RIGHT	662
#define	TD_ZONE_LEFT	362

// the offset for the los tile
// los 0 is a touchdown... so is 300, 3 is yardline 1
#define LOS_OFFSET		362

#define READY			0

// forward declare classes, structs
class botInfo;
struct Player;
struct PBall;
class String;

class FootballGame
{
public:
	FootballGame();

	void setBi(botInfo* theBot);
	void resetGame();
	void playerPickedUpBall(Player *p);
	void playerThrewBall(Player *p,PBall* ball);
	void playerMoved(Player *p);
	void playerLeft(Player *p);
	void startGame(int receivingTeam);
	void warpPlayer(Player *p);
	bool isLegalShip(int team, int ship);
	int getDefaultShip(int team);
	void captainSaid(int sayWhat, int team);
	void tick();
	void goal();
	void ballSpawnAfterGoal();

	bool playOn; // is a play in progress?
private:
	void setGameMode(int newMode);
	int getGameMode();
	void setLos(int newLos); // set los and center the ball
	int getLos();
	void setScore(int score0, int score1);
	void sendPrivate(Player *p, String msg);
	void sendPublic(String msg);
	void centerBall();
	bool isOob(Player *p);
	bool isTouchDown(Player *p);
	void setYLos(int newY);

	string ballCarrier;
	string lastBallCarrier;

	botInfo *bi;
	int score[2];
	int timeouts[2];
	int half;
	int los;
	int gameMode;
	int seconds;
	int yLos; // the y coordinate of the los
	bool freqZeroHadBallFirst;
	bool teamIsReady; // before the kickoff
	bool ballKicked; // has the ball been kicked on the kickoff
	bool ballCaught; // has the ball been caught on the kickoff
	bool kickedOutOfBounds; // was the ball kicked out of bounds
	bool ranOutOfEndzone; // did the player run out of the endzone
	int tileOob; // the tile where the ball will end up if it goes out of bounds, for lateral fumbles
	int throwingTeam; // the team that lateraled the ball
	bool goingUp; // was it lateraled upward or downward?
	bool timerTicking; // is the timer currently ticking?
	bool wasSafety; // was the last play a safety?
};


#endif