#include "football.h"
#include "spawn.h"

FootballGame::FootballGame()
{
	resetGame();
}

void FootballGame::setBi(botInfo *theBot)
{
	bi = theBot;
}

void FootballGame::resetGame()
{
	score[0] = 0;
	score[1] = 0;
	timeouts[0] = 3;
	timeouts[1] = 3;
	seconds = INIT_SECONDS;
	half = 0;
	los = 60 * 3;
	gameMode = PRE_GAME;
	yLos = 512;
	playOn = false;
	timerTicking = false;
	wasSafety = false;
}

void FootballGame::setGameMode(int newMode)
{
	gameMode = newMode;
	playOn = false;

	switch (gameMode)
	{
		case PRE_GAME:
		{
			timerTicking = false;
			playOn = false;
			break;
		}
		case KICKOFF_ZERO:
		{
			bi->turnOnObject(0,POSSESION);
			bi->turnOnObject(0,PLAY_CLOCK);
			bi->turnOnObject(0,TOGO);

			yLos = 512;
			if (wasSafety)
				setLos(35 * 3);
			else
				setLos(40 * 3);

			wasSafety = false;

			playOn = false;
			teamIsReady = false;
			ballCaught = false;
			ballKicked = false;
			ranOutOfEndzone = false;
			timerTicking = false;
			
			sendPublic("*arena Freq 1 captain please say ready when your team is ready.");
			
			break;
		}
		case KICKOFF_ONE:
		{
			bi->turnOnObject(0,POSSESION);
			bi->turnOnObject(0,PLAY_CLOCK);
			bi->turnOnObject(0,TOGO);

			yLos = 512;

			if (wasSafety)
				setLos(65 * 3);
			else
				setLos(60 * 3);

			wasSafety = false;

			teamIsReady = false;
			playOn = false;
			ballCaught = false;
			ballKicked = false;
			timerTicking = false;
			ranOutOfEndzone = false;
			
			sendPublic("*arena Freq 0 captain please say ready when your team is ready.");

			break;
		}
		case REG_ZERO:
		{
			timerTicking = false;
			sendPublic("*arena Reg-zero");

			break;
		}
		case REG_ONE:
		{
			timerTicking = false;
			sendPublic("*arena Reg-one");

			break;
		}
	}
}

void FootballGame::captainSaid(int sayWhat, int team)
{
	switch (gameMode)
	{
		case KICKOFF_ZERO:
		{
			if (sayWhat == READY && team == 1 && teamIsReady == false)
			{
				sendPublic("*arena Freq " + (String)team + " is now ready. The kickoff may proceed.");
				teamIsReady = true;
				centerBall();
			}
			
			break;
		}
		case KICKOFF_ONE:
		{
			if (sayWhat == READY && team == 0 && teamIsReady == false)
			{
				sendPublic("*arena Freq " + (String)team + " is now ready. The kickoff may proceed.");
				teamIsReady = true;
				centerBall();
			}

			break;
		}
	}
}

int FootballGame::getGameMode()
{
	return gameMode;
}

void FootballGame::setLos(int newLos)
{
	los = newLos;

	centerBall();
	
	if (gameMode != KICKOFF_ZERO && gameMode != KICKOFF_ONE)
	{
		// fix los graphic and first down graphic
	}
}

int FootballGame::getLos()
{
	return los;
}


void FootballGame::playerPickedUpBall(Player *p)
{
	ballCarrier = p->name;

	switch (gameMode)
	{
		case PRE_GAME:
		{
			sendPrivate(p,"Please don't pick up the ball before the game.");
			warpPlayer(p);
			centerBall();

			break;
		}
		case KICKOFF_ZERO:
		{
			if (ballKicked == false)
			{
				if (p->ship != SHIP_Weasel || p->team != 0)
				{ 
					sendPrivate(p,"Please don't pick up the ball unless you are the kicker(weasel).");
					warpPlayer(p);
					centerBall();
				}
				else if (!teamIsReady)
				{
					sendPrivate(p,"Please don't pick up the ball until the other team is ready.");
					warpPlayer(p);
					centerBall();
				}
			}
			else // ball is kicked
			{
				if (ballCaught == false)
				{
					ballCaught = true;
					playOn = true;
					timerTicking = true;
					sendPublic("*arena Kick caught by " + (String)p->name + "!");

					if ((p->tile.x - (LOS_OFFSET + los) < 30))
					{ // illegal onside kick
						int half = (los) / 2;
						int norm = los - 30;
						int set = half > norm ? half : norm;
						if (set < 1)
							set = 1;
						if (set > 299)
							set = 299;

						String arrow = "";
						if (set < 150)
							arrow = "<-";
						else if (set > 150)
							arrow = "->";

						int yardline = set < 150 ? set / 3 : (300 - set) / 3;						

						setLos(set);

						sendPublic("*arena Illegal onside kick(ball must go 10 yards before it's caught)! Kicking team move back " +
							(String)"to the " + arrow + " " + (String)yardline + ".");
						ballCaught = false;
						ballKicked = false;
						teamIsReady = false;
						sendPublic("*arena Freq 1 captain say ready when your team is ready for the kickoff.");
					}
				}
				else
				{ // lateral caught
					if (p->team != throwingTeam)
					{
						sendPublic("*arena Turnover!");
					}
				}
			}

			break;
		}
		case KICKOFF_ONE:
		{
			if (ballKicked == false)
			{
				if (p->ship != SHIP_Weasel || p->team != 1)
				{ 
					sendPrivate(p,"Please don't pick up the ball unless you are the kicker(weasel).");
					warpPlayer(p);
					centerBall();
				}
				else if (!teamIsReady)
				{
					sendPrivate(p,"Please don't pick up the ball until the other team is ready.");
					warpPlayer(p);
					centerBall();
				}
			}
			else // ball is kicked
			{
				if (ballCaught == false)
				{
					ballCaught = true;
					playOn = true;
					timerTicking = true;
					sendPublic("*arena Kick caught by " + (String)p->name + "!");

					if (((LOS_OFFSET + los) - p->tile.x < 30))
					{ // illegal onside kick
						int half = (los + 300) / 2;
						int norm = los + 30;
						int set = half < norm ? half : norm;
						if (set < 1)
							set = 1;
						if (set > 299)
							set = 299;

						String arrow = "";
						if (set < 150)
							arrow = "<-";
						else if (set > 150)
							arrow = "->";

						int yardline = set < 150 ? set / 3 : (300 - set) / 3;						

						setLos(set);

						sendPublic("*arena Illegal onside kick(ball must go 10 yards before it's caught)! Kicking team move back " +
							(String)"to the " + arrow + " " + (String)yardline + ".");
						ballCaught = false;
						ballKicked = false;
						teamIsReady = false;
						sendPublic("*arena Freq 1 captain say ready when your team is ready for the kickoff.");
					}
				}
				else
				{ // lateral caught
					if (p->team != throwingTeam)
					{
						sendPublic("*arena Turnover!");
					}
				}
			}

			break;
		}
	}
}

void FootballGame::goal()
{
	switch (gameMode)
	{
		case KICKOFF_ZERO:
		{
			if (ballKicked && !ballCaught)
			{
				if (kickedOutOfBounds)
				{
					sendPublic("*arena Penalty on freq zero! Ball placed on 45 yardline.");
					setLos(55 * 3);
					setGameMode(REG_ONE);
				}
				else
				{
					sendPublic("*arena Touchback!");
					setLos(75 * 3);
					setGameMode(REG_ONE);
				}
			}
			else if (ballCaught)
			{ // fumble oob, three possiblities, touchback, safety, or regular oob
				if (throwingTeam == 0)
				{
					if (tileOob <= TD_ZONE_LEFT)
					{
						if (ranOutOfEndzone)
						{
							sendPublic("*arena Safety!");
							setScore(score[0],score[1] + 2);
							wasSafety = true;
							setGameMode(KICKOFF_ZERO);
						}
						else 
						{
							sendPublic("*arena Touchback!");
							setLos(25 * 3);
							setGameMode(REG_ZERO);
						}
					}
					else
					{
						int tile = tileOob - LOS_OFFSET;
						if (tile >= 300)
							tile = 299;

						if (goingUp)
							setYLos(OOB_TOP);
						else
							setYLos(OOB_BOTTOM);

						setLos(tile);
						setGameMode(REG_ZERO);
					}
				}
				else if (throwingTeam == 1)
				{
					if (tileOob >= TD_ZONE_RIGHT)
					{
						if (ranOutOfEndzone)
						{
							sendPublic("*arena Safety!");
							setScore(score[0] + 2,score[1]);
							wasSafety = true;
							setGameMode(KICKOFF_ONE);
						}
						else 
						{
							sendPublic("*arena Touchback!");
							setLos(75 * 3);
							setGameMode(REG_ONE);
						}
					}
					else
					{
						int tile = tileOob - LOS_OFFSET;
						if (tile <= 0)
							tile = 1;

						if (goingUp)
							setYLos(OOB_TOP);
						else
							setYLos(OOB_BOTTOM);

						setLos(tile);
						setGameMode(REG_ONE);
					}
				}
			}

			break;
		}
		case KICKOFF_ONE:
		{
			if (ballKicked && !ballCaught)
			{
				if (kickedOutOfBounds)
				{
					sendPublic("*arena Penalty on freq one! Ball placed on 45 yardline.");
					setLos(45 * 3);
					setGameMode(REG_ZERO);
				}
				else
				{
					sendPublic("*arena Touchback!");
					setLos(25 * 3);
					setGameMode(REG_ZERO);
				}
			}
			else if (ballCaught)
			{ // fumble oob, three possiblities, touchback, safety, or regular oob
				if (throwingTeam == 0)
				{
					if (tileOob <= TD_ZONE_LEFT)
					{
						if (ranOutOfEndzone)
						{
							sendPublic("*arena Safety!");
							setScore(score[0],score[1] + 2);
							wasSafety = true;
							setGameMode(KICKOFF_ZERO);
						}
						else 
						{
							sendPublic("*arena Touchback!");
							setLos(25 * 3);
							setGameMode(REG_ZERO);
						}
					}
					else
					{
						int tile = tileOob - LOS_OFFSET;
						if (tile >= 300)
							tile = 299;

						if (goingUp)
							setYLos(OOB_TOP);
						else
							setYLos(OOB_BOTTOM);

						setLos(tile);
						setGameMode(REG_ZERO);
					}
				}
				else if (throwingTeam == 1)
				{
					if (tileOob >= TD_ZONE_RIGHT)
					{
						if (ranOutOfEndzone)
						{
							sendPublic("*arena Safety!");
							setScore(score[0] + 2,score[1]);
							wasSafety = true;
							setGameMode(KICKOFF_ONE);
						}
						else 
						{
							sendPublic("*arena Touchback!");
							setLos(75 * 3);
							setGameMode(REG_ONE);
						}
					}
					else
					{
						int tile = tileOob - LOS_OFFSET;
						if (tile <= 0)
							tile = 1;

						if (goingUp)
							setYLos(OOB_TOP);
						else
							setYLos(OOB_BOTTOM);

						setLos(tile);
						setGameMode(REG_ONE);
					}
				}

			}
			break;
		}
	}
}

void FootballGame::playerThrewBall(Player *p, PBall* ball)
{
	lastBallCarrier = ballCarrier;
	throwingTeam = p->team;
	ballCarrier = "";
	//ballKicked

	switch (gameMode)
	{
		case PRE_GAME:
		{
			sendPrivate(p,"Please don't pick up the ball before the game.");
			warpPlayer(p);
			centerBall();

			break;
		}
		case KICKOFF_ZERO:
		{
			if (ballKicked == false)
			{
				if (!teamIsReady || p->ship != SHIP_Weasel)
				{ // player already got warped and warned... just recenter ball
					centerBall();
				}
				else if (p->ship == SHIP_Weasel && p->team == 0 && teamIsReady)
				{
					if (ball->xvel > 0)
					{
						sendPublic("*arena The kick is off!");
						ballKicked = true;

						kickedOutOfBounds = bi->getOobTile() < TD_ZONE_RIGHT;
					}
					else
					{
						sendPrivate(p,"Kick it towards the other team please.");
						warpPlayer(p);
						centerBall();
					}
				}
			}

			else if (ballCaught == true)
			{
				if (p->team == 0)
				{
					if (ball->xvel < 0)
					{
						sendPublic("*arena Lateral by " + (String)p->name);
						goingUp = ball->yvel < 0;
						tileOob = bi->getOobTile();
					}
					else
					{ // tackled
						int tile = p->tile.x - LOS_OFFSET;
						if (tile <= 0) // safety or touchback
						{
							if (ranOutOfEndzone)
							{
								sendPublic("*arena Safety!");
								setScore(score[0],score[1] + 2);
								wasSafety = true;
								setGameMode(KICKOFF_ZERO);
							}
							else
							{
								sendPublic("*arena Touchback!");
								setLos(25 * 3);
								setGameMode(REG_ZERO);
							}
						}
						else if (tile > 299)
						{ // touchdown
							sendPublic("*arena Touchdown!");
							setScore(score[0] + 7,score[1]);
							setGameMode(KICKOFF_ZERO);
						}
						else
						{						
							setYLos(p->tile.y);
							setLos(tile);
							setGameMode(REG_ZERO);
						}
					}
				}
				else if (p->team == 1)
				{
					if (ball->xvel > 0)
					{
						sendPublic("*arena Lateral by " + (String)p->name);
						goingUp = ball->yvel < 0;
						tileOob = bi->getOobTile();
					}
					else
					{ // tackled
						int tile = p->tile.x - LOS_OFFSET;
						if (tile >= 300) // safety or touchback
						{
							if (ranOutOfEndzone)
							{
								sendPublic("*arena Safety!");
								setScore(score[0] + 2,score[1]);
								wasSafety = true;
								setGameMode(KICKOFF_ONE);
							}
							else
							{
								sendPublic("*arena Touchback!");
								setLos(75 * 3);
								setGameMode(REG_ONE);
							}
						}
						else if (tile <= 0)
						{ // touchdown
							sendPublic("*arena Touchdown!");
							setScore(score[0],score[1] + 7);
							setGameMode(KICKOFF_ONE);
						}
						else 
						{						
							setYLos(p->tile.y);
							setLos(tile);
							setGameMode(REG_ONE);
						}
					}
				}
			}
			break;
		}
		case KICKOFF_ONE:
		{
			if (ballKicked == false)
			{
				if (!teamIsReady || p->ship != SHIP_Weasel)
				{ // player already got warped and warned... just recenter ball
					centerBall();
				}
				if (p->ship == SHIP_Weasel && p->team == 1 && teamIsReady)
				{
					if (ball->xvel < 0)
					{
						sendPublic("*arena The kick is off!");
						ballKicked = true;

						kickedOutOfBounds = bi->getOobTile() > TD_ZONE_LEFT;
					}
					else
					{
						sendPrivate(p,"Kick it towards the other team please.");
						warpPlayer(p);
						centerBall();
					}
				}
			}


			else if (ballCaught == true)
			{
				if (p->team == 0)
				{
					if (ball->xvel < 0)
					{
						sendPublic("*arena Lateral by " + (String)p->name);
						goingUp = ball->yvel < 0;
						tileOob = bi->getOobTile();
					}
					else
					{ // tackled
						int tile = p->tile.x - LOS_OFFSET;
						if (tile <= 0) // safety or touchback
						{
							if (ranOutOfEndzone)
							{
								sendPublic("*arena Safety!");
								setScore(score[0],score[1] + 2);
								wasSafety = true;
								setGameMode(KICKOFF_ZERO);
							}
							else
							{
								sendPublic("*arena Touchback!");
								setLos(25 * 3);
								setGameMode(REG_ZERO);
							}
						}
						else if (tile > 299)
						{ // touchdown
							sendPublic("*arena Touchdown!");
							setScore(score[0] + 7,score[1]);
							setGameMode(KICKOFF_ZERO);
						}
						else
						{						
							setYLos(p->tile.y);
							setLos(tile);
							setGameMode(REG_ZERO);
						}
					}
				}
				else if (p->team == 1)
				{
					if (ball->xvel > 0)
					{
						sendPublic("*arena Lateral by " + (String)p->name);
						goingUp = ball->yvel < 0;
						tileOob = bi->getOobTile();
					}
					else
					{ // tackled
						int tile = p->tile.x - LOS_OFFSET;
						if (tile >= 300) // safety or touchback
						{
							if (ranOutOfEndzone)
							{
								sendPublic("*arena Safety!");
								setScore(score[0] + 2,score[1]);
								wasSafety = true;
								setGameMode(KICKOFF_ONE);
							}
							else
							{
								sendPublic("*arena Touchback!");
								setLos(75 * 3);
								setGameMode(REG_ONE);
							}
						}
						else if (tile <= 0)
						{ // touchdown
							sendPublic("*arena Touchdown!");
							setScore(score[0],score[1] + 7);
							setGameMode(KICKOFF_ONE);
						}
						else 
						{						
							setYLos(p->tile.y);
							setLos(tile);
							setGameMode(REG_ONE);
						}
					}
				}
			}
			break;
		}
	}

}

void FootballGame::playerMoved(Player *p)
{
	switch (gameMode)
	{
		case KICKOFF_ZERO:
		{
			if (ballKicked == false && ballCarrier == p->name)
			{ // check to see if they've migrated too far
				Point po(p->tile.x,p->tile.y);
				if (po.distSq(Point(LOS_OFFSET + los,512)) > 15 * 15)
				{
					sendPrivate(p,"Please don't move so far when kicking the ball.");
					warpPlayer(p);
					centerBall();
				}


			}
			if (ballCaught == true)
			{ // player is returning the kickoff
				if (ballCarrier == p->name && p->team == 1)
				{
					if (p->tile.x < TD_ZONE_RIGHT)
						ranOutOfEndzone = true;

					if (isTouchDown(p))
					{
						sendPublic("*arena Touchdown! by " + (String)p->name);
						setScore(score[0],score[1] + 7);
						setGameMode(KICKOFF_ONE);
					}
					else if (isOob(p))
					{
						if (!ranOutOfEndzone)
						{ // touchback
							sendPublic("*arena Touchback!");
							setLos(75 * 3);
							setGameMode(REG_ONE);
						}
						else
						{// safety or down
							if (p->tile.x  >= TD_ZONE_RIGHT)
							{ // safety
								sendPublic("*arena Safety!");
								setScore(score[0] + 2,score[1]);
								wasSafety = true;
								setGameMode(KICKOFF_ONE);
							}
							else
							{ // oob
								setYLos(p->tile.y);
								setLos(p->tile.x - LOS_OFFSET);
								setGameMode(REG_ONE);
							}
						}
					}
				
				}
				else if (ballCarrier == p->name && p->team == 0)
				{ // turnover... check for safery, touchdown, down
					if (isTouchDown(p))
					{
						sendPublic("*arena Touchdown! by " + (String)p->name);
						setScore(score[0] + 7,score[1]);
						setGameMode(KICKOFF_ZERO);
					}
					else if (isOob(p))
					{
						if (p->tile.x  <= TD_ZONE_LEFT)
						{ // safety
							sendPublic("*arena Safety!");
							setScore(score[0],score[1] + 2);
							wasSafety = true;
							setGameMode(KICKOFF_ZERO);
						}
						else
						{ // oob
							setYLos(p->tile.y);
							setLos(p->tile.x - LOS_OFFSET);
							setGameMode(REG_ZERO);
						}
						
					}
				}
			}
			break;
		}
		case KICKOFF_ONE:
		{
			if (ballKicked == false && ballCarrier == p->name)
			{ // check to see if they've migrated too far
				Point po(p->tile.x,p->tile.y);
				if (po.distSq(Point(LOS_OFFSET + los,512)) > 15 * 15)
				{
					sendPrivate(p,"Please don't move so far when kicking the ball.");
					warpPlayer(p);
					centerBall();
				}


			}
			if (ballCaught == true)
			{ // player is returning the kickoff
				if (ballCarrier == p->name && p->team == 0)
				{
					if (ballCarrier == p->name)
					{
						if (p->tile.x > TD_ZONE_LEFT)
							ranOutOfEndzone = true;
					}

					if (isTouchDown(p))
					{
						sendPublic("*arena Touchdown! by " + (String)p->name);
						setScore(score[0] + 7,score[1]);
						setGameMode(KICKOFF_ZERO);
					}
					else if (isOob(p))
					{
						if (!ranOutOfEndzone)
						{ // touchback
							sendPublic("*arena Touchback!");
							setLos(25 * 3);
							setGameMode(REG_ONE);
						}
						else
						{// safety or down
							if (p->tile.x  <= TD_ZONE_LEFT)
							{ // safety
								sendPublic("*arena Safety!");
								setScore(score[0],score[1] + 2);
								wasSafety = true;
								setGameMode(KICKOFF_ZERO);
							}
							else
							{ // oob
								setYLos(p->tile.y);
								setLos(p->tile.x - LOS_OFFSET);
								setGameMode(REG_ONE);
							}
						}
					}
				}
				else if (ballCarrier == p->name && p->team == 1)
				{ // turnover... check for safery, touchdown, down
					if (isTouchDown(p))
					{
						sendPublic("*arena Touchdown! by " + (String)p->name);
						setScore(score[0],score[1] + 7);
						setGameMode(KICKOFF_ONE);
					}
					else if (isOob(p))
					{
						if (p->tile.x >= TD_ZONE_RIGHT)
						{ // safety
							sendPublic("*arena Safety!");
							setScore(score[0] + 2,score[1]);
							wasSafety = true;
							setGameMode(KICKOFF_ONE);
						}
						else
						{ // oob
							setYLos(p->tile.y);
							setLos(p->tile.x - LOS_OFFSET);
							setGameMode(REG_ONE);
						}
					}
				}
			}
			break;
		}
	}
}

void FootballGame::setScore(int score0, int score1)
{
	score[0] = score0;
	score[1] = score1;

	bi->turnOnObject(score[0],TEAM_ONE_SCORE);
	bi->turnOnObject(score[1],TEAM_TWO_SCORE);
}

void FootballGame::playerLeft(Player *p) // in case he just threw the ball
{
	switch (gameMode)
	{
		case KICKOFF_ZERO:
		case KICKOFF_ONE:
		{
			if (ballKicked && !ballCaught && lastBallCarrier == p->name)
			{ // kicker left
				sendPublic("*arena Kicker left, re-doing kickoff.");
				ballKicked = false;
				centerBall();
			}
			break;
		}
	}
}


void FootballGame::ballSpawnAfterGoal()
{
	centerBall();
}
void FootballGame::startGame(int receivingTeam) // start the game with the appropriate receiving team
{	
	freqZeroHadBallFirst = receivingTeam == 0; 
	bi->turnOnObject(1,HALF);
	bi->turnOnObject(3,TEAM_ONE_TIMEOUT);
	bi->turnOnObject(3,TEAM_TWO_TIMEOUT);
	bi->turnOnObject(0,TEAM_ONE_SCORE);
	bi->turnOnObject(0,TEAM_TWO_SCORE);
	bi->turnOnObject(seconds,TIMER);

	receivingTeam == 0 ? setGameMode(KICKOFF_ONE) : setGameMode(KICKOFF_ZERO);
}

void FootballGame::tick() // called once a second
{
	if (timerTicking)
	{
		seconds--;
		bi->turnOnObject(seconds,TIMER);
	}

	switch (gameMode)
	{
		case KICKOFF_ZERO:
		{			

			break;
		}
		case KICKOFF_ONE:
		{
			

			break;
		}
	}
}


bool FootballGame::isLegalShip(int team, int ship)
{
	bool legal = true;

	switch (gameMode)
	{
		case KICKOFF_ZERO:
		{
			if (team == 0 && (ship == SHIP_Warbird || ship == SHIP_Javelin || ship == SHIP_Terrier || ship == SHIP_Lancaster))
				legal = false;
			else if (team == 1 && (ship == SHIP_Spider || ship == SHIP_Leviathan || ship == SHIP_Weasel ||
									ship == SHIP_Terrier || ship == SHIP_Shark))
				legal = false;

			break;
		}
		case KICKOFF_ONE:
		{
			if (team == 1 && (ship == SHIP_Warbird || ship == SHIP_Javelin || ship == SHIP_Terrier || ship == SHIP_Lancaster))
				legal = false;
			else if (team == 0 && (ship == SHIP_Spider || ship == SHIP_Leviathan || ship == SHIP_Weasel ||
									ship == SHIP_Terrier || ship == SHIP_Shark))
				legal = false;

			break;
		}
	}

	return legal;
}

int FootballGame::getDefaultShip(int team)
{
	int ship = SHIP_Warbird;

	switch (gameMode)
	{
		case KICKOFF_ZERO:
		{
			if (team == 0)
				ship = SHIP_Spider;
			else if (team == 1)
				ship = SHIP_Warbird;

			break;
		}
		case KICKOFF_ONE:
		{
			if (team == 1)
				ship = SHIP_Spider;
			else if (team == 0)
				ship = SHIP_Warbird;

			break;
		}
	}

	return ship + 1;
}

//
bool FootballGame::isOob(Player *p) // is p out of bounds?
{
	int tileX = p->tile.x;
	int tileY = p->tile.y;
	bool oob = false;

	if (tileX - 1 <= OOB_LEFT || tileX + 1 >= OOB_RIGHT || tileY - 1 <= OOB_TOP || tileY + 1 >= OOB_BOTTOM)
		oob = true;

	return oob;
}

bool FootballGame::isTouchDown(Player *p)
{
	int tileX = p->tile.x;
	int tileY = p->tile.y;
	bool td = false;

	if (p->team == 0 && tileX >= TD_ZONE_RIGHT)
		td = true;
	else if (p->team == 1 && tileX <= TD_ZONE_LEFT)
		td = true;

	return td;
}

void FootballGame::setYLos(int newY)
{
	if (newY < TOP_Y_LOS)
		newY = TOP_Y_LOS;
	else if (newY > BOTTOM_Y_LOS)
		newY = BOTTOM_Y_LOS;

	yLos = newY;
}

//
void FootballGame::warpPlayer(Player *p) // warp a player, like if he picks up the ball when he shouldn't
{
	int yTile = p->tile.y;

	if (yTile < OOB_TOP)
		yTile = OOB_TOP;

	if (yTile > OOB_BOTTOM)
		yTile = OOB_BOTTOM;

	int xTile = LOS_OFFSET + los + (p->team == 0 ? -30 : 30);

	sendPrivate(p,"*warpto " + (String)xTile + " " + (String)yTile);
}


void FootballGame::centerBall()
{
	int xTile = LOS_OFFSET + los;
	int yTile = yLos;

	bi->placeBall(xTile* 16 + 8, yTile * 16 + 8);
	lastBallCarrier = "";
	ballCarrier = "";
}

void FootballGame::sendPrivate(Player *p,String msg)
{
	bi->sendPrivate(p,msg);
}

void FootballGame::sendPublic(String msg)
{
	bi->sendPublic(msg);
}