#include "spawn.h"

#include "..\algorithms.h"

#define PLUGIN_NAME "New Football"
#define PLUGIN_VERSION "1"
#define PLUGIN_MAKER "bak2007@gmail.com"
#define PLUGIN_ABOUT_TEXT "New football plugin by Bak!"

void botInfo::gotHelp(Player *p, Command *c)
{
	// List commands

	if (!*c->final)
	{
		switch (p->access)
		{
		case OP_Duke:
		case OP_Baron:
		case OP_King:
		case OP_Emperor:
		case OP_RockStar:
		case OP_Q:
		case OP_God:
		case OP_Owner:
			{	// Owner-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_SysOp:
			{	// SysOp-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_SuperModerator:
			{	// SuperModerator-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_Moderator:
			{	// Moderator-level commands
//				sendPrivate(p, "Ext: ");
				sendPrivate(p, "----- <> FOOTBALL MOD COMMANDS <> -----");
				sendPrivate(p,"!setcmds                        (help with the set commands)");
			}
		case OP_Limited:
			{	// Limited-level commands
			}
		case OP_Player:
			{	// Player-level commands
				// Player-level commands
				sendPrivate(p, " ");
				sendPrivate(p, "----- <> FOOTBALL CAPTAIN COMMANDS <> -----");
				sendPrivate(p, "!add *name*                    (add a player");
				sendPrivate(p, "!remove *name*                 (remove a player)");
				sendPrivate(p, " ");
				sendPrivate(p, "----- <> FOOTBALL PLAYER COMMANDS <> -----");
				sendPrivate(p, "!captain                       (this will give you captain if there is none)");
				sendPrivate(p, "!capts                         (who are the captains?)");
				sendPrivate(p, "!refreshgraphics               (refreshes your graphics)");
				sendPrivate(p, "!about						   (ask me of my use)");
			}
		}

		return;
	}

	// Specific command help

	switch (p->access)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
			if (c->checkParam("owner") || c->checkParam("all"))
			{
//				sendPrivate(p, "Ext: ");
			}
		}
	case OP_SysOp:
		{	// SysOp-level commands
			if (c->checkParam("sop") || c->checkParam("all"))
			{
//				sendPrivate(p, "Ext: ");
			}
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
			if (c->checkParam("smod") || c->checkParam("all"))
			{
//				sendPrivate(p, "Ext: ");
			}
		}
	case OP_Moderator:
		{	// Moderator-level commands
			if (c->checkParam("mod") || c->checkParam("all"))
			{
//				sendPrivate(p, "Ext: ");
			}
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}

void botInfo::gotCommand(Player *p, Command *c)
{
	if (!p) return;
	if (!c) return;

	switch (p->access)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
			if (c->check("version"))
			{
				sendPrivate(p, "[name:" + (String)PLUGIN_NAME + ".dll] [maker:" + (String)PLUGIN_MAKER 
					+ "] [build:" + (String)PLUGIN_VERSION + "]");
			}
		}
	case OP_Moderator:
		{	// Moderator-level commands
			if (c->check("setcmds"))
			{
				sendPrivate(p, "!restartgame                (restart the game with the current captains)");
				sendPrivate(p, "!setnames name1:name2       (set the team names)");
				sendPrivate(p, "!setcaps name1:name2        (set the team captains)");
			}
			else if (c->check("setcaps"))
			{
				String final = c->final;

				String one = final.split(':');

				Player *c0 = findPlayerWithName(one);
				Player *c1 = findPlayerWithName(final);

				cap[0] = c0 ? c0->name : "";
				cap[1] = c1 ? c1->name : "";

				sendPublic("*arena " + (String)p->name + " set new captains: " 
							+ toCapNameString(cap[0]) + " and " + toCapNameString(cap[1]) + "!");



				setTeamNames(cap[0] + (String)":" + cap[1]);

			}
			else if (c->check("setnames"))
			{
				setTeamNames(c->final);
				sendPrivate(p,"Done.");
			}
			else if (c->check("restartgame"))
			{
				String final = c->final;
				mode = PLAYING;
				shouldBeLocked = false;
				sendPublic("*lock");
				fg.resetGame();

				fg.startGame(final.len > 0 ? 1 : 0);

				sendPrivate(p,"Done.");
			}
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
			if (c->check("about"))
			{
				sendPrivate(p, PLUGIN_ABOUT_TEXT);
			}
			else if (c->check("capts"))
			{
				sendPrivate(p,"Current captains: " + toCapNameString(cap[0]) + " and " + toCapNameString(cap[1]) + ".");
			}
			else if (c->check("captain"))
			{
				nextCapt(p);
			}
			else if (c->check("refreshgraphics"))
			{
				sendPlayerObjects(p);
				sendPrivate(p,"Your graphics have been refreshed.");
			}
			else if (c->check("add"))
			{
				if (mode == BEFORE_PICKING)
				{
					sendPrivate(p,"Please don't add players until both teams have a captian.");
				}
				else
				{
					int capOf = -1; // capOf is the team he's the captain of

					if (cap[0] == p->name)
						capOf = 0;
					else if (cap[1] == p->name)
						capOf = 1;

					if (capOf != -1)
					{
						if (getNumPlayersInGameOnTeam(0) < getNumPlayersInGameOnTeam(1) && capOf == 1)
						{
							sendPrivate(p,"Please wait for the other captain to add another player before you continue picking.");
						}
						else if (getNumPlayersInGameOnTeam(0) > getNumPlayersInGameOnTeam(1) && capOf == 0)
						{
							sendPrivate(p,"Please wait for the other captain to add another player before you continue picking.");
						}
						else
						{
							Player *picked = findPlayerWithName(c->final);

							if (picked == NULL)
							{
								sendPrivate(p,"I could not find that player in the arena.");
							}
							else if (picked == me)
							{
								sendPrivate(p,"I'm not playing. Thank you though.");
							}
							else if (picked->ship != SHIP_Spectator)
							{
								sendPrivate(p,"You can only add people if they are in spectator mode.");
							}
							else if (cap[(capOf == 0 ? 1 : 0)] == picked->name)
							{
								sendPrivate(p,"You can't add the other captain to your team.");
							}
							else
							{
								int sec = get_tag(picked,TAG_BANNEDTIME);

								if (sec > 0)
									set_tag(picked,TAG_BANNEDTIME,0);

								sendPrivate(picked,"*setship 1");
								sendPrivate(picked,"*setfreq " + (String)capOf);

								sendPrivate(p,"Player " + (String)picked->name + " added.");
								sendPrivate(picked,"You have been added to freq " + (String)capOf + " by " + (String)p->name + ".");
							}
						}
					}
					else
					{
						sendPrivate(p,"You must be a captain in order to use this command.");
					}
				}
			}
			else if (c->check("remove"))
			{
				int capOf = -1; // capOf is the team he's the captain of

				if (cap[0] == p->name)
					capOf = 0;
				else if (cap[1] == p->name)
					capOf = 1;

				if (capOf != -1)
				{
					Player *picked = findPlayerWithName(c->final);

					if (picked == NULL)
					{
						sendPrivate(p,"I could not find that player in the arena.");
					}
					else if (picked->ship == SHIP_Spectator)
					{
						sendPrivate(p,"You can't remove people who are already in spectator mode.");
					}
					else if (picked->team != capOf)
					{
						sendPrivate(p,"You can't remove players from the other team, although it would be nice if you could ;)");
					}
					else if (picked == me)
					{
						sendPrivate(p,"I'm not in the game, probably just placing the ball.");
					}
					else
					{
						sendPrivate(picked,"*spec");
						sendPrivate(picked,"*spec");
						set_tag(picked,TAG_BANNEDTIME,30);

						sendPrivate(picked,"The team captain, " + (String)p->name + ", has removed you from the team.");
						sendPrivate(p,"Player " + (String)picked->name + " has been removed from your team.");
					}
				}
				else
				{
					sendPrivate(p,"You must be a captain in order to use this command.");
				}
			}

		}
	}
}

void botInfo::gotRemoteHelp(char *p, Command *c, Operator_Level l)
{
	// List commands

	if (!*c->final)
	{
		switch (l)
		{
		case OP_Duke:
		case OP_Baron:
		case OP_King:
		case OP_Emperor:
		case OP_RockStar:
		case OP_Q:
		case OP_God:
		case OP_Owner:
			{	// Owner-level commands
			}
		case OP_SysOp:
			{	// SysOp-level commands
			}
		case OP_SuperModerator:
			{	// SuperModerator-level commands
			}
		case OP_Moderator:
			{	// Moderator-level commands
			}
		case OP_Limited:
			{	// Limited-level commands
			}
		case OP_Player:
			{	// Player-level commands
			}
		}

		return;
	}

	// Specific command help

	switch (l)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}

void botInfo::gotRemote(char *p, Command *c, Operator_Level l)
{
	if (!c) return;

	switch (l)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}
