// #autoload
// #name = Kill Popup
// #version = 1.2
// #date = July 6, 2001
// #author = Matt Timlin
// #warrior = Ptavv
// #email = ptavv@tribalwar.com
// #web = http://scripts.tribalwar.com/ptavv/
// #description = Popup hud when you die/kill someone
// #status = pretty much done

package KillPopup {

function handleJoin(%msgType, %msgString, %clientName, %clientId, %targetId, %isAI, %isAdmin, %isSuperAdmin, %isSmurf, %guid) {

	if(StrStr(%msgString, "Welcome to Tribes") != -1)
	{
		$CurrentClientId = %clientId;
		$CurrentPlayerName = detag(%clientName);
	}
}

function handleKill(%msgType, %msgString, %victimName, %vgen, %vposs, %killerName, %kgen, %kposs, %damageType)
{
	%killer = detag(%killerName);
	%victim = detag(%victimName);
//	%weapon = $DamageTypeText[%damageType];

	if(%killer $= "" || %victim $= "")
		return;

	if(%victim $= $CurrentPlayerName)
	{
		KillPopupHudText.setText("<just:center><color:2cacb5>You were killed by<color:ffffff>: <color:06e166>" @ %killer );
		KillPopupHudSchedule();
		return;
	}

	if(%killer $= $CurrentPlayerName)
	{
		KillPopupHudText.setText("<just:center><color:2cacb5>You killed<color:ffffff>: <color:06e166>" @ %victim );
		KillPopupHudSchedule();
		return;
	}
}

function KillPopupHudSchedule()
{
	KillPopupHud.setVisible(true);

	if (KillPopupHud.schedule !$= "")
	{
		cancel(KillPopupHud.schedule);
		KillPopupHud.schedule = "";
	}
	KillPopupHud.schedule = schedule(3000, 0, eval, "KillPopupHud.setVisible(false);");
}

function KillPopupHudSetup()
{
	addMessageCallback('MsgClientJoin', handleJoin);
	addMessageCallBack('MsgLegitKill', handleKill);
	addMessageCallBack('MsgHeadshotKill', handleKill);

	new GuiControlProfile("KillPopupHudText")
	{
		fontType = "Univers Condensed";
		fontSize = 16;
		fontColor = "169 215 250";
		justify = "center"; 
		fontColors[6] = $PlayerNameColor;
		fontColors[7] = $TribeTagColor;
		fontColors[8] = $SmurfNameColor;
		fontColors[9] = $BotNameColor;
	};
}

function KillPopupHudCreate()
{
	KillPopupHudDestroy();
	
	$KillPopupHud = new ShellFieldCtrl(KillPopupHud)
	{
		profile = "GuiChatBackProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "220 400";
		extent = "200 26";
		minExtent = "8 8";
		visible = "0";
		setFirstResponder = "0";
		
		new GuiMLTextCtrl(KillPopupHudText)
		{
			profile = "KillPopupHudText";
			horizSizing = "center";
			vertSizing = "center";
			position = "3 5";
			extent = "194 16";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};
	};
	playgui.add($KillPopupHud);

	if(isObject(HM) && isObject(HudMover))
		hudmover::addhud(KillPopupHud,"KillsPopup HUD");
}

function KillPopupHudDestroy()
{
	if ($KillPopupHud !$= "")
	{
		playgui.remove($KillPopupHud);
		KillPopupHud.delete();
		$KillPopupHud = "";
	}
}

//
// --- Overrides ---
//

function DispatchLaunchMode()
{
	KillPopupHudSetup();

	parent::DispatchLaunchMode();
}

function LoadingGui::onWake(%this)
{
	if (!$KillPopupHudsetup)
	{
		KillPopupHudCreate();
		$KillPopupHudSetup = true;
	}
	
	parent::onWake(%this);
}

}; // END package FlagResponse
activatePackage(KillPopup);