/*********************************************************
*Name:          WinBolo Brain Template
*Filename:      BrainTemplate.c
*Author:        John Morrison
*Creation Date: 7/12/99
*Last Modified:  6/9/00
*Purpose:
* This file is a sample skeleton brain that can be used
* to assist in writing plugin brains for WinBolo.
*
* 6/09/00 - Ported to GTK. This file was compiled by
*       gcc BrainTempate.c -o BrainTemplate.so -shared \
*           `gtk-config --cflags --libs`
* 8/01/00 -  Added code submitted by db48 that fixes the
*           menu popup.
* 7/12/99 - Initial revision.
* 
* LinBolo (C) 1998-2000 John Morrison
* Bolo    (C) 1987-1995 Stuart Cheshire
*
*********************************************************/

/* Includes */
#include <stdio.h>
#include "brain.h"
#include <glib.h>
#include <gmodule.h>
#include <gtk/gtk.h>

/* Defines */

/* What we want to call our menu entry */
#define BRAIN_MENU_NAME "Template" 
/* Generic brain error */
#define BRAIN_ERROR -1

Boolean opt1, opt2, opt3; /* Menu options         */
GtkWidget *menu_top;      /* The top of the menu  */


/* Functions */

/* Callback for OK button click */
void dialogAboutOK(GtkWidget *widget, gpointer user_data) {
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


/* Build and display the about box */
void menuAboutActivate(GtkMenuItem *menuItem, gpointer user_data) {
  GtkWidget *dialogAbout;
  GtkWidget *vbox1;
  GtkWidget *lblTitle;
  GtkWidget *lblCaption;
  GtkWidget *button;

  dialogAbout = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_object_set_data(GTK_OBJECT(dialogAbout), "dialogAbout", dialogAbout);
  gtk_container_set_border_width(GTK_CONTAINER (dialogAbout), 15);
  gtk_window_set_title(GTK_WINDOW(dialogAbout), "About");
  gtk_window_set_position(GTK_WINDOW(dialogAbout), GTK_WIN_POS_CENTER);
  gtk_window_set_modal(GTK_WINDOW(dialogAbout), TRUE);
  gtk_window_set_policy(GTK_WINDOW(dialogAbout), FALSE, FALSE, FALSE);

  vbox1 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox1);
  gtk_object_set_data_full(GTK_OBJECT(dialogAbout), "vbox1", vbox1, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox1);
  gtk_container_add(GTK_CONTAINER(dialogAbout), vbox1);
  lblTitle = gtk_label_new ("LinBolo Brain Template");
  gtk_widget_ref (lblTitle);
  gtk_object_set_data_full(GTK_OBJECT(dialogAbout), "lblTitle", lblTitle, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(lblTitle);
  gtk_box_pack_start(GTK_BOX(vbox1), lblTitle, FALSE, FALSE, 0);

  lblCaption = gtk_label_new("This template is a skeleton example on how\nto build plugin Brains for LinBolo");
  gtk_widget_ref (lblCaption);
  gtk_object_set_data_full(GTK_OBJECT(dialogAbout), "lblCaption", lblCaption, (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_show (lblCaption);
  gtk_box_pack_start (GTK_BOX (vbox1), lblCaption, FALSE, TRUE, 9);
  gtk_label_set_justify (GTK_LABEL (lblCaption), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblCaption), 7.45058e-09, 0.5);

  button = gtk_button_new_with_label ("OK");
  gtk_widget_ref (button);
  gtk_object_set_data_full (GTK_OBJECT (dialogAbout), "button", button, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (vbox1), button, FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_focus (button);
  gtk_widget_grab_default (button);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(dialogAboutOK), dialogAbout);

  /* Show it */
  gtk_widget_show(dialogAbout);
}


void menuOptionsActivate(GtkMenuItem *menuItem, gpointer user_data) {
  Boolean *item; /* The item (opt1,2 or 3) we are going to change */

  item = (Boolean *) user_data;
  *item ^= 1; 
}


/* Sample brain think call. Returns TRUE. 
   Add brain details here. */
Boolean brainThink(const BrainInfo *info) {
  return TRUE;
}

/* A sample brainOpen function. It shows how to add a menu entry 
   onto WinBolo's menu and creates an about dialogbox. Returns 
   success of the opertaion. */
Boolean brainOpen(GtkWidget *menu_bar) {
  Boolean returnValue;     /* Value to return                */
  GtkWidget *brain_menu;   /* The submenu the items live in  */
  GtkWidget *item;         /* Item to create and add to menu */

  returnValue = TRUE;
  opt1 = 0;
  opt2 = 0;
  opt3 = 0;
  
  /* Create our menu */
  menu_top = gtk_menu_item_new_with_label(BRAIN_MENU_NAME);
  gtk_widget_ref(menu_top);
  gtk_widget_show(menu_top);
  gtk_container_add(GTK_CONTAINER(menu_bar), menu_top); /* Append it here */
  brain_menu = gtk_menu_new();
  gtk_widget_ref(brain_menu);
  gtk_object_set_data_full (GTK_OBJECT(menu_top), "About", brain_menu, (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_top), brain_menu);

  /* About */
  item = gtk_menu_item_new_with_label ("About");
  gtk_widget_ref(item);
  gtk_object_set_data_full (GTK_OBJECT(menu_top), "About", item, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (item);
  gtk_container_add(GTK_CONTAINER(brain_menu), item);
  
  gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(menuAboutActivate), NULL);

  /* Seperator */
  item = gtk_menu_item_new ();
  gtk_widget_ref(menu_top);
  gtk_object_set_data_full (GTK_OBJECT(menu_top), "item", item, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(brain_menu), item);

  /* Option 1 */
  item = gtk_check_menu_item_new_with_label("Option 1");
  gtk_widget_ref(item);
  gtk_object_set_data_full(GTK_OBJECT(menu_top), "option1", item, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(brain_menu), item);
 
  gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(menuOptionsActivate), &opt1);
  
  /* Option 2 */
  item = gtk_check_menu_item_new_with_label("Option 2");
  gtk_widget_ref(item);
  gtk_object_set_data_full(GTK_OBJECT(menu_top), "option2", item, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(brain_menu), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(menuOptionsActivate), &opt2);
  
  /* Option 3 */
  item = gtk_check_menu_item_new_with_label("Option 3");
  gtk_widget_ref(item);
  gtk_object_set_data_full(GTK_OBJECT(menu_top), "option3", item, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(brain_menu), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(menuOptionsActivate), &opt3);

  /* Add any brain specific startup code here... */

  return returnValue;
}

/* This is the brains closing function. It should free all 
   resources it uses as well as remove and menus it creates */
void brainClose(void) {
  /* Remove menu */
  gtk_widget_destroy(menu_top);
  /* Add any brain specific shutdown code here... */
}

/* The exported brain function that gets called.
   Returns 0 if OK or anything else on an error. 
   Remember if you return an error you will not be called again with 
   the BRAIN_CLOSE message */
G_MODULE_EXPORT short BrainMain(const BrainInfo *brainInfo) {
  short returnValue; /* Value to return */

  returnValue = 0;
  if (brainInfo->InfoVersion != CURRENT_BRAININFO_VERSION) {
    returnValue = BRAIN_ERROR;
  } else {
    switch (brainInfo->operation) {
    case BRAIN_OPEN:
      /* Do brain startup. */
      if (brainOpen((GtkWidget *) brainInfo->userdata) == FALSE) {
        returnValue = BRAIN_ERROR;
      }
      break;
    case BRAIN_CLOSE:
      /* Do brain shutdown. */
      brainClose();
      break;
    case BRAIN_THINK:
      /* Do brain think call */
      if (brainThink(brainInfo) == FALSE) {
        returnValue = BRAIN_ERROR;
      } 
      break;
    case BRAIN_MENU:
      /* Do brain menu action. */
      /* Not required under linux/GTK */
      break;
    default:
      /* This should never be reached so it must be an unexpected error.
         Shutdown and return an error. */
      returnValue = BRAIN_ERROR;
    }
  }

  if (returnValue != 0) {
    /* We must of encounted an error so shutdown */
    brainClose();
  }
  return returnValue;
}

