'---------------------------------------------------------------------------------------------------------------------------'
'															    '
' 			  Install script for admin mod  v2.50.50							    '
'			  Original Copyright (C) 2000 Alfred Reynolds (alfred@mazuma.net.au) 				    '
'			  Copyright (C) 2002-2003 David Mart  				    '
'			  $Id: install_admin.vbs,v 1.1.2.1 2003/03/21 22:28:24 darope Exp $			    '
' 			  Installer version 1.6												    '
' 															    '
'----------------------------------------------------------------------------------------------Declarations-and-setup-------'
Option Explicit ' enforces explicit variable declaration, don't touch this.

'---------------------------------------------------------------------------------------------------------------------------'
'  To enable debugging set the line below to "Const DEBUGME=1" , boolean value: 1 = On, 0 = Off.
'---------------------------------------------------------------------------------------------------------------------------'
Const DEBUGME = 0

'---------------------------------------------------------------------------------------------------------------------------'
'  To disable filesystem changes set the line below to "Const NEUTER=1" , boolean value: 1 = On, 0 = Off.
'---------------------------------------------------------------------------------------------------------------------------'
Const NEUTER = 0

'---------------------------------------------------------------------------------------------------------------------------'
'  To disable automatic search and execution of the uninstaller set the line below to "NOUNINSTALL=1" , boolean value: 1 = On, 0 = Off.
'---------------------------------------------------------------------------------------------------------------------------'
Const NOUNINSTALL=0

'---------------------------------------------------------------------------------------------------------------------------'
'  To disable desktop shortcut to the manual creation set the line below to "NOSHORTCUT=1" , boolean value: 1 = On, 0 = Off.
'---------------------------------------------------------------------------------------------------------------------------'
Const NOSHORTCUT=0

'---------------------------------------------------------------------------------------------------------------------------'
'  To disable prompting and retanetion of old config files set the line below to "NOKEEPCONFIGS=1" , boolean value: 1 = On, 0 = Off.
'---------------------------------------------------------------------------------------------------------------------------'
Const NOKEEPCONFIGS=0

'---------------------------------------------------------------------------------------------------------------------------'
'  Sets the wscript version used in version dependant switches, wscript.version is normal but setting it will force a single set of methods.
'---------------------------------------------------------------------------------------------------------------------------'
dim WSCRIPT_VERSION
WSCRIPT_VERSION=cstr(wscript.version)

'==========================================================================================================================='
'                                YOU SHOULD NOT NEED TO CHANGE ANYTHING BELOW THIS LINE !!
'==========================================================================================================================='



'----------------------------------------------------------------------------------------Script-Declarations----------------'
Dim GamedllFound,RO,InConsoleMode,Files,FilesCount,ModifyLiblist 'int/bool
Dim WSHShell,FSO,TSO,FSD,TSD,Folders,Folder,File 'objects
Dim mod_name,line,invar,HLpath,HLDSpath,Path,answer,Version,filenamein,filenameout,Mods,EXEname,DocPath,Strings,OldConfigsPath
Const ForReading=1,ForWriting=2,ForAppending=8,FILE_ATTRIBUTE_READONLY=1
Const AM_CONFIG="\addons\adminmod\config",AM_DLLS="\addons\adminmod\dlls",AM_SCRIPTS="\addons\adminmod\scripts",AM_ROOT="\addons\adminmod"
Const MM_DLLS="\addons\metamod\dlls",MM_ROOT="\addons\metamod"
'----------------------------------------------------------------------------------------Script-Initialisation--------------'
	Version= "2.50.52"
	on error resume next
	Set fso = CreateObject("Scripting.FileSystemObject")
	if err.number<>0 then message "The installer was unable to create the ActiveX componant required to"&vbcrlf&"interact with your computers filesystem."&vbcrlf&"This is a problem with your windows scripting host installtion and can be fixed"&vbcrlf&"by reinstalling/updating the Windows Scripting Host."&vbcrlf&vbcrlf&"The windows scripting host can be downloaded free from Microsoft at"&vbcrlf&"http://msdn.microsoft.com/scripting",vbokonly,"Object creation error": err.clear: wscript.quit
	on error goto 0
'----------------------------------------------------------------------------------------Script-Starts-here-----------------'
	DebugStart() ' self explanatory really
	InConsoleMode=IsHostCscript() ' determines console or gui mode

	'message GetString("BETA"),64,"Admin Mod Beta Installer"
	Strings=array(GetString("WELCOME"),GetString("REGISTRY"),GetString("REGISTRYERROR"),GetString("SHELLERROR"),GetString("KEEPCONFIGS"),GetString("SHORTEND"),GetString("NOSHORTEND"),GetString("MISSINGFILE"),GetString("NOUNINSTALL"),getString("CONFIGWARNING")) 'sets up an array of long strings read from the very end of this file.

	if InConsoleMode=true then debug "script is running in console mode"&vbcrlf else debug "script is running in GUI mode"&vbcrlf
	checkfiles() ' check to make sure all required Admin Mod files are present before beginning the installation
	answer = Message(Strings(0),33,"Starting Installation")
	If answer<> vbOk Then debug "user canceled installation": wscript.quit
	answer = Message(Strings(1),vbOKCancel,"Allow Admin Mod Installer to read a registry key?")
	if answer = vbOk then answer=GetHLKeys() 
	if answer = 0 then
		Search() ' search, pretty simple really
		if HLpath="" and HLDSpath="" then 
			answer=Message("No Halflife game or dedicated server installations found." & vbcrlf & vbcrlf & "Advanced users who wish to use a full path for the installation click OK."&vbcrlf&"Click Cancel To exit.",vbokcancel,"No Half-Life dedicated server found")
			If answer=vbCancel then debug "chose to quit": wscript.quit
			If answer=vbOk     then Specify: debug "No HL.exe HLDS.exe or Cstrike.exe found: chose to specify a path"&vbCrlf
		end if
		if HLpath="" and HLDSpath<>"" then
			answer=Message("Admin Mod has detected a dedicated server installation at "&vbcrlf&vbtab& HLDSpath&"."&vbCrlf&vbCrlf&"To install to this directory click Yes."&vbCrlf&"Advanced users who wish to use a full path for the installation click No."&vbCrlf&"To exit now click Cancel.",vbYesnocancel,"Dedicated Server found")
			If answer=vbYes    then Path=HLDSpath: debug "HLDs.exe only found: chose to install to dedicated server at: "& HLDSpath&vbCrlf
			If answer=vbNo     then Specify(): debug "chose to specify a path"
			If answer=vbCancel then debug "chose to quit":wscript.quit
		end if
		if HLpath<>""and HLDSpath="" then
			answer=Message("Admin Mod has detected a Half-Life game installation at "&vbcrlf&vbtab& HLpath&"."&vbCrlf&vbCrlf&"To install to this directory click Yes."&vbCrlf&"Advanced users who wish to use a full path for the installation click No."&vbCrlf&"To exit now click Cancel.",vbYesnocancel,"Half-Life game found")
			If answer=vbYes    then Path=HLpath: debug "HL.exe or Cstrike.exe only found: chose to install at: "& HLpath&vbCrlf
			if answer=vbNo     then Specify(): debug "chose to specify a path"&vbCrlf
			if answer=vbCancel then debug "chose to quit":wscript.quit
		End If
		if HLpath<>"" and HLDSpath<>"" then
			answer=Message("Admin Mod has detected a Half-Life game installation at :"&vbCrlf&vbTab& HLpath&vbCrlf&"and has also detected a dedicated server installation at :"&vbCrlf&vbTab&HLDSpath&vbCrlf&vbCrlf&"To install to the Half-Life game click Yes."&vbCrlf&"To install to the dedicated server click No."&vbCrlf&"To exit now click Cancel.",vbYesnocancel,"Half-Life game and Dedicated Server found")
			If answer=vbYes    then Path=HLpath: debug "HLDS.exe and HL.exe or Cstrike.exe found: chose to install at: "& HLpath&vbCrlf
			If answer=vbNo     then Path=HLDSpath: debug "HLDS.exe and HL.exe or Cstrike.exe found: chose to install to dedicated server at: "& HLDSpath&vbCrlf
			If answer=vbCancel then debug "chose to quit": wscript.quit
		end if
	else
		specify()
	end if

	FindMods() ' find the mods and list them for the user to choose

	debug "prompting user for mod choice"
	mod_name = Input("Enter the directory name (e.g. 'cstrike') of the mod you wish to install Admin Mod to."&vbcrlf&"Valid folders are listed below."&vbCrlf&vbCrlf&mods&vbCrlf&"Click OK when the folder has been entered.","Modification choice")
	If mod_name="" then
		debug vbtab&"blank input is interpreted as cancel: quitting": DebugClose(): wscript.quit
	elseif folderexists(path & "\" & mod_name)=False Then
		debug vbtab&"user input """&mod_name&""" which is not a valid mod folder, second and final prompt"
		mod_name = Input("Enter the directory name of the Mod you wish To install Admin Mod To."&vbcrlf&"Valid folders are listed below."&vbCrlf&vbCrlf&mods&vbCrlf&"Click OK when the folder has been entered.","Modification choice")
		If mod_name="" then
			debug vbtab&"blank input is interpreted as cancel: quitting": DebugClose(): wscript.quit
		elseif folderexists(path & "\" & mod_name)=False Then
			debug vbTab&"second erroneous folder: quiting":message "Either you can't type or you don't know where your halflife/server is installed to. Please try again when you know."&vbcrlf&vbcrlf&"This script will now exit",vbokonly,"Exiting": DebugClose(): wscript.quit
		else
			debug vbTab&"valid mod folder supplied """&mod_name&""" installation will begin"
		end if
	else
		debug vbTab&"valid mod folder supplied """&mod_name&""" installation will begin"
	end if

	
	CheckUninstall() 'come on, i shouldn't have to explain what this one does
	debug "completed mod choice"

	gamedllFound=False: debug vbCrlf&"Locating host mod essentials"
	If FileExists(path&"\"&mod_name&"\liblist.gam")<>True Then
		if mod_name="" then
			DebugClose(): wscript.quit
		Else
			If EXEname="CStrike" Then
				Message "The installer could not find the liblist.gam file for your mod."&vbcrlf&"This means you may not have specifed a valid modification folder."&vbCrlf&vbCrlf&"Retail Counter-Strike sometimes cannot be properly identified by this installer,"&vbcrlf&"if you find that you cannot get theis script to work then please refer to"&vbcrlf&"the manual installation instruction in the manual."&vbCrlf&vbCrlf&"This installer will now Exit.",vbOkonly,"Exiting"
			Else
				Message "The installer could not find the liblist.gam file for your mod."&vbcrlf&"This probably means you have not specifed a valid modification folder."&vbCrlf&"This installer will now exit.",vbOkonly,"Exiting"
			End If
			DebugClose(): wscript.quit
		end if
	end if

	If FolderExists(Path&"\"&mod_name&"\dlls")<>true then
		Message "The installer was unable to find the dlls directory of the mod you specified."&vbcrlf&"This installer will now exit.",vbokonly,"Exiting"
		debug "Unable to locate mod dlls folder": DebugClose(): wscript.quit
	end if
	debug "completed locating host mod essentials"

	ModifyLiblist = InstallMetamod() ' install the metamod files if required
	ModifyLiblistFile(ModifyLiblist) ' modify the liblist.gam, make sure it's not write protected first though

	debug vbCrlf & "starting installation and modification of files"
	' create the new folders if they are not present
	if not folderexists(Path & "\" & mod_name & AM_ROOT)    then CreateFolder(Path & "\" & mod_name & AM_ROOT)
	if not folderexists(Path & "\" & mod_name & AM_CONFIG)  then CreateFolder(Path & "\" & mod_name & AM_CONFIG)
	if not folderexists(Path & "\" & mod_name & AM_SCRIPTS) then CreateFolder(Path & "\" & mod_name & AM_SCRIPTS)
	if not folderexists(Path & "\" & mod_name & AM_DLLS)    then CreateFolder(Path & "\" & mod_name & AM_DLLS)

	' now install the essential Admin files, if base files are not found then create then, do not overwrite though
	copyfile "config\plugin.ini" ,    Path & "\" & mod_name & AM_CONFIG  & "\", true 'overwrite any present ini file
	copyfile "dlls\admin_MM.dll",     Path & "\" & mod_name & AM_DLLS    & "\", true 'always overwrite the dlls
	copyfile "dlls\amx_admin.dll",    Path & "\" & mod_name & AM_DLLS    & "\", true 'always overwrite the dlls
	copyfile "scripting\binaries\*.*",Path & "\" & mod_name & AM_SCRIPTS & "\", true 'always overwrite amx binaries

	if OldConfigsPath="" then
		copyfile "config\adminmod.cfg",   Path & "\" & mod_name & AM_CONFIG  & "\", true 'always overwrite the config file
		if fileexists(Path & "\" & mod_name & AM_CONFIG & "\maps.ini")    = false then CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\maps.ini",true' : debug vbtab & "created maps.ini"
		if fileexists(Path & "\" & mod_name & AM_CONFIG & "\ips.ini")     = false then CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\ips.ini",true': debug vbtab & "created ips.ini"
		if fileexists(Path & "\" & mod_name & AM_CONFIG & "\models.ini")  = false then CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\models.ini", true': debug vbtab & "created models.ini"
		if fileexists(Path & "\" & mod_name & AM_CONFIG & "\users.ini")   = false then CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\users.ini",true ': debug vbtab & "created users.ini"
		if fileexists(Path & "\" & mod_name & AM_CONFIG & "\wordlist.txt")= false then CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\wordlist.txt",true': debug vbtab & "created wordlist.txt"
	else
		debug vbtab&"restoring old config files where possible, new files will otherwise be created"
		if fileexists(OldConfigsPath&"\adminmod.cfg") then copyfile OldConfigsPath&"\adminmod.cfg", Path & "\" & mod_name & AM_CONFIG & "\",true else copyfile "config\adminmod.cfg",   Path & "\" & mod_name & AM_CONFIG  & "\", true
		if fileexists(OldConfigsPath&"\maps.ini")     then copyfile OldConfigsPath&"\maps.ini", Path & "\" & mod_name & AM_CONFIG & "\",true     else CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\maps.ini",true' : debug vbtab & "created maps.ini"
		if fileexists(OldConfigsPath&"\ips.ini")      then copyfile OldConfigsPath&"\ips.ini", Path & "\" & mod_name & AM_CONFIG & "\",true      else CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\ips.ini",true' : debug vbtab & "created ips.ini"
		if fileexists(OldConfigsPath&"\models.ini")   then copyfile OldConfigsPath&"\models.ini", Path & "\" & mod_name & AM_CONFIG & "\",true   else CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\models.ini",true' : debug vbtab & "created models.ini"
		if fileexists(OldConfigsPath&"\users.ini")    then copyfile OldConfigsPath&"\users.ini", Path & "\" & mod_name & AM_CONFIG & "\",true    else CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\users.ini",true' : debug vbtab & "created users.ini"
		if fileexists(OldConfigsPath&"\wordlist.txt") then copyfile OldConfigsPath&"\wordlist.txt", Path & "\" & mod_name & AM_CONFIG & "\",true else CreateTextFile Path & "\" & mod_name & AM_CONFIG & "\wordlist.txt",true' : debug vbtab & "created wordlist.txt"
		debug vbtab&"files restored, """&OldConfigsPath&""" will be deleted"
		deletefolder OldConfigsPath,true
	end if

	debug "completed installation and modification of files"

	' now edit the server.cfg and listenserver.cfg files to exec the adminmod cfg file, take account of read only status
	Files=array("listenserver.cfg","server.cfg")
	dim EditedFile
	EditedFile=false
	for FilesCount = 0 to ubound(Files)
		EditedFile = EditConfigFile(Files(filesCount))
	next
	if EditedFile=false then
		debug vbtab&"neither statndard config files could be located to add the adminmod.cfg entry to, the user will be notified"
		message "The installer was unable to locate either listenserver.cfg or server.cfg. These files would normally be appeneded with an exec entry which causes the adminmod.cfg to be executed when the server runs, this will not be the case on this server. You will need to manually add the exec entry (which can be found in the manual section on this insatller) to a config file which you know will be eecuted each time the server or a map loads.",vbokonly,"No exec line created"
	end if
		

	' inform of the sucessful install and then do the cleanup procedures
	if CreateShortcut()=true then
		debug "displaying end dialogue"&vbcrlf
		Message Strings(5),vbOkonly,"Installation Completed" 'shortcut created string
	else
		debug vbCrlf&"displaying end dialogue"
		Message Strings(6),vbOkonly,"In+stallation Completed" 'no shortcut created string
	end if

	debug "installation complete, objects will be destroyed and the script will exit.":	Set fso=Nothing: DebugClose()

'----------------------------------------------------------------------------------------------End-of-Script-----------------
'			THE END
'----------------------------------------------------------------------------------------------------------------------------
Private function InstallMetamod
	debug vbcrlf&"beginning InstallMetamod function"
	debug vbtab&"removing any old style metamod installation"
	ModifyLiblist =true

	dim LiblistCorrect,Liblist_stream,invar
	' remove any oldstyle metamod install found

	if fileexists( Path & "\" & mod_name & "\dlls\metamod.dll")               then deletefile Path & "\" & mod_name & "\dlls\metamod.dll",true
	if fileexists( Path & "\" & mod_name & "\metamod.ini")                    then deletefile Path & "\" & mod_name & "\metamod.ini",true
	if fileexists( Path & "\" & mod_name & "\AdminMod backup of liblist.gam") then ' if the old backup of liblist.gamis present then restore it.
		deletefile Path & "\" & mod_name & "\liblist.gam",true
		copyfile   Path & "\" & mod_name & "\AdminMod backup of liblist.gam",Path & "\" & mod_name & "\liblist.gam",true
		deletefile Path & "\" & mod_name & "\AdminMod backup of liblist.gam",true
	end if
	debug vbtab & "completed old style metamod file removal"

	set Liblist_stream = fso.opentextfile(Path&"\"&mod_name&"\liblist.gam",forreading,false)
	debug vbtab&"scanning liblist for metamod.dll"
	do while Liblist_stream.atendofstream<>true
		invar=lcase(trim(Liblist_stream.readline))
		if len(invar) >2 then
			if instr(1,invar,"metamod.dll") >0 and instr(1,invar,"dlls\metamod.dll") =0 and left(invar,2) <>"//" and instr(1,invar,"amedll")>0 then
				LiblistCorrect=false
			end if
		end if
	loop
	Liblist_stream.close: set Liblist_stream=nothing

	'check for a new style metamod installtion.
	debug vbtab&"checking for new style metamod installation"
	if folderexists(Path&"\"&mod_name&"\addons") and folderexists(Path&"\"&mod_name&"\addons\metamod") and folderexists(Path&"\"&mod_name&"\addons\metamod\dlls") and fileexists(Path&"\"&mod_name&"\addons\metamod\dlls\metamod.dll") then
		if liblistCorrect=false then
			ModifyLiblist =true
			debug vbtab&"complete new style metamod installtion found with erroneous liblist, this will be fixed"
		 else
			debug vbtab&"complete new style metamod installtion found"
			ModifyLiblist=false
		end if
	else
		debug vbtab&"incomplete or no new style metamod installtion found, installling."
		if not folderexists(Path & "\" & mod_name & "\addons")  then createfolder Path & "\" & mod_name & "\addons"
		if not folderexists(Path & "\" & mod_name & MM_ROOT)    then createfolder Path & "\" & mod_name & MM_ROOT
		if not folderexists(Path & "\" & mod_name & MM_DLLS)    then createfolder Path & "\" & mod_name & MM_DLLS
		copyfile "dlls\metamod.dll",   Path & "\" & mod_name & MM_DLLS & "\",          true
		copyfile "config\metamod.ini", Path & "\" & mod_name & MM_ROOT &"\plugins.ini",true
		ModifyLiblist =true
		debug vbtab&"completed metamod installation"
	end if

	InstallMetamod=ModifyLiblist
	debug "completed InstallMetamod function"
end function
'----------------------------------------------------------------------------------------------ModifyLiblistFile-Sub-----
Private sub ModifyLiblistFile(ModifyLiblist)
	dim out_lib,in_lib
	debug vbCrlf & "beginning ModifyLiblistFile sub"
	if ModifyLiblist=true then
		set file=fso.getfile(Path&"\"&mod_name&"\liblist.gam")
		
		If (file.attributes And FILE_ATTRIBUTE_READONLY)=FILE_ATTRIBUTE_READONLY Then
			debug vbTab&"liblist.gam Is a read-only file, changing"
			file.attributes= (file.attributes Xor FILE_ATTRIBUTE_READONLY)
			RO=True
		End If

		set file=nothing

		Set in_lib = fso.OpenTextFile(Path&"\"&mod_name&"\liblist.gam",ForReading,False)

		debug vbTab&"creating temporary file to replace liblist.gam"
		Set out_lib = fso.OpenTextFile("admin.tmp",ForWriting,True)

		do while in_lib.AtEndOfStream<>true
			line = in_lib.readline
			If instr(line,"gamedll")>0 And instr(line,"gamedll_linux")<1 Then
				debug vbTab&"found gamedll line, changing"
				line ="gamedll ""addons\metamod\dlls\metamod.dll"""
				If line<>"" And GamedllFound =False Then out_lib.writeline(line)
				if GamedllFound=false then GamedllFound=true
			else 
				out_lib.writeline(line)
			end if
		loop

		in_lib.close: set in_lib=nothing
		out_lib.close: set out_lib=Nothing
		debug vbTab&"checking for previous backup of liblist.gam"

		If fileexists(path&"\"&mod_name&"\AdminMod backup of liblist.gam")=false then
			debug vbTab&"no previous backup found"
			copyfile Path&"\"&mod_name&"\liblist.gam", path&"\"&mod_name&"\AdminMod backup of liblist.gam",true
		Else
			debug vbTab&"previous backup found"
			deletefile Path&"\"&mod_name&"\liblist.gam",true
		end if
		copyFile "admin.tmp",Path&"\"&mod_name&"\liblist.gam",true

		If RO=True Then
			set file=fso.getfile(Path&"\"&mod_name&"\liblist.gam")
			file.attributes=(file.attributes Or FILE_ATTRIBUTE_READONLY)
			Set File=Nothing: RO=False
			debug vbTab&"liblist.gam read-only status restored"
		End If

		deletefile "admin.tmp",True
	else
		debug vbtab&"no liblist.gam modifications required"
	end if
	debug "completed ModifyLiblistFile sub"
end sub
'----------------------------------------------------------------------------------------------EditConfigFile-Sub--------
Private function EditConfigFile(FileName)
	dim execString,in_lib,out_lib
	debug vbCrlf&"beginning EditConfigFile sub"
	debug vbTab&"starting "&FileName&" file changes"
	If fileexists(Path&"\"&mod_name&"\"&FileName)=True Then
		debug vbtab&"server.cfg file located at """&Path&"\"&mod_name&"\"&FileName&""""
		Set file =fso.getfile(Path&"\"&mod_name&"\"&FileName)

		If (file.attributes And FILE_ATTRIBUTE_READONLY)=FILE_ATTRIBUTE_READONLY Then
			debug vbTab&FileName&" Is a read-only file, changing"
			file.attributes= (file.attributes Xor FILE_ATTRIBUTE_READONLY)
			RO=True
		End If

		if file.size=0 then 
			debug vbtab&FileName&" file size is 0 bytes"
			invar=""
		else
			Set out_lib = fso.opentextfile(Path&"\"&mod_name&"\"&FileName,ForReading,false)
			invar=out_lib.readall
			out_lib.close
			Set out_lib=Nothing
			debug vbTab&"scanning for ""adminmod.cfg"""
		end if

		If instr(1,invar,"adminmod.cfg")=0 Then
			debug vbTab&"no reference to adminmod.cfg found, appending"
			if invar<>"" then
				Set out_lib = fso.opentextfile(Path & "\" & mod_name & "\" & FileName,forappending,false)
			else
				Set out_lib = fso.opentextfile(Path & "\" & mod_name & "\" & FileName,forwriting,false)
			end if

			If NEUTER=0 Then
				out_lib.WriteBlankLines(2)
				out_lib.write "// Execute the Admin Mod configuration file"&vbCrlf
				execstring=replace(AM_CONFIG & "/adminmod.cfg"&vbCrlf,"\","/")
				execstring=right(execstring, len(execstring)-1)
				execstring="exec "&execstring
				out_lib.write execstring
			End If
			out_lib.close
			Set out_lib = Nothing
			debug vbTab&"file appended and closed"
		else
			debug vbtab&"found reference to ""adminmod.cfg"" no changes are required"
		end If

		invar=""

		If RO=True Then
			file.attributes=(file.attributes Or FILE_ATTRIBUTE_READONLY)
			Set File=Nothing
			debug vbTab&FileName&" read-only status of restored"
			RO=False
		End If
		EditConfigFile=true
	Else
		debug vbTab&"server.cfg not found, no changes can be made"
		EditConfigFile=false
	end if
	debug vbtab&"completed "&FileName&" file changes"
	debug "completed EditConfigFile sub"
end function
'----------------------------------------------------------------------------------------------GetHLKeys-Sub-----------------
Private function GetHLKeys()
	Dim ValveHLKey,SolHlKey,SolCSKey,SolHLDSKey,SoftHLKey,SoftCSKey,SoftHLDSKey
	debug "beginning getHLkeys sub"
	on error resume next ' handle errors in _this procedure only_
	debug vbtab&"Creating Wscript.shell object"
	set WSHShell = CreateObject("WScript.Shell") 
	if err.number<>0 then
		err.clear
		on error goto 0
		debug vbtab&"Could not create Wscript.Shell object. Wscript version is "&wscript.version&"."
		debug vbtab&"Prompting user to continue or fail installation."
		dim MsgRet
		MsgRet = message(Strings(2),vbokcancel,"Object creation error")
		if MsgRet =vbcancel then 
			debug "completed GetHLKys"&vbcrlf&"user canceled installation"
			DebugClose()
			Set fso=Nothing
			wscript.quit
		else
			debug vbtab&"chose to continue"&vbcrlf&"completed GetHLkeys sub (unsucessfully)"&vbcrlf
		end if
		GetHLKeys=1
	else
		' get the keys, soooo many keys, blame valve
		debug vbtab&"registry keys are"
		ValveHLKey =WSHShell.RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\VALVE\HALF-LIFE\InstallPath")
		if ValveHLKey<>"" then if right(ValveHLKey,1)="\" then ValveHLKey=left(ValveHLKey,len(ValveHLKey)-1)
		debug vbtab&vbtab&"ValveHLKey  = "&ValveHLKey
		SolHlKey =WSHShell.RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Sierra OnLine\Setup\HALFLIFE\directory")
		if SolHlKey<>"" then if right(SolHlKey,1)="\" then SolHlKey=left(SolHlKey,len(SolHlKey)-1)
		debug vbtab&vbtab&"SolHlKey    = "&SolHlKey
		SolCSKey =WSHShell.RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Sierra OnLine\Setup\CSTRIKE\directory")
		if SolCSKey<>"" then if right(SolCSKey,1)="\" then SolCSKey=left(SolCSKey,len(SolCSKey)-1)
		debug vbtab&vbtab&"SolCSKey    = "&SolCSKey
		SolHLDSKey =WSHShell.RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Sierra OnLine\Setup\HLSERVER\directory")
		if SolHLDSKey<>"" then if right(SolHLDSKey,1)="\" then SolHLDSKey=left(SolHLDSKey,len(SolHLDSKey)-1)
		debug vbtab&vbtab&"SolHLDSKey  = "&SolHLDSKey
		SoftHLKey =WSHShell.RegRead("HKEY_CURRENT_USER\Software\Valve\Half-Life\InstallPath")
		if SoftHLKey<>"" then if right(SoftHLKey,1)="\" then SoftHLKey=left(SoftHLKey,len(SoftHLKey)-1)
		debug vbtab&vbtab&"SoftHLKey   = "&SoftHLKey
		SoftCSKey =WSHShell.RegRead("HKEY_CURRENT_USER\Software\Valve\CounterStrike\InstallPath")
		if SoftCSKey<>"" then if right(SoftCSKey,1)="\" then SoftCSKey=left(SoftCSKey,len(SoftCSKey)-1)
		debug vbtab&vbtab&"SoftCSKey   = "&SoftCSKey
		SoftHLDSKey =WSHShell.RegRead("HKEY_CURRENT_USER\Software\Valve\CounterStrike\InstallPath")
		if SoftHLDSKey<>"" then if right(SoftHLDSKey,1)="\" then SoftHLDSKey=left(SoftHLDSKey,len(SoftHLDSKey)-1)
		debug vbtab&vbtab&"SoftHLDSKey = "&SoftHLDSKey
		Set WSHShell=Nothing: debug vbtab&"keys read and WSH shell object destroyed"

		if SoftHlKey<>"" then ' now determine which HL key to use, of three
			if fileexists(SoftHlKey&"\hl.exe") then	HLPath=SoftHlKey
		else
			if SolHLKey<>"" then 
				if fileexists(SolHLKey&"\hl.exe") then HLPath=SolHLKey
			else
				if ValveHLKey<>"" then
					if fileexists(ValveHLKey&"\hl.exe") then HLPath=ValveHLkey
				end if
			end if
		end if

		if HLPath<>"" then ' if HLpath isn't blank we've found a valid HL install, so the exe is HL
			EXEname ="HL"
		else 'otherwise search the Cstrike retail keys.
			if SoftHLKey<>"" then
				if fileexists(SoftHLKey&"\cstrike.exe") then	HLpath=SoftHLKey
			else
				if SolCSKey<>"" then
					if fileexists(SolCSKey&"\cstrike.exe") then HLPath=SolCSKey
				end if
			end if
			if HLpath<>"" then EXEName="CS"
		end if

		if SoftHLDSKey<>"" then
			if fileexists(SoftHLDSKey&"\hlds.exe") then HLDSpath=SoftHLDSKey
		else
			if SolHLDSKey<>"" then
				if fileexists(SolHLDSKey&"\hlds.exe") then HLDSpath=SolHLDSKey
			end if
		end if

		debug vbTab & "HLpath = " & hlpath & vbCrlf & vbTab & "HLDSpath = " & HLDSpath & vbCrlf & vbTab & "EXEname = " & EXEname
		debug "completed GetHLkeys sub"&vbCrlf
		GetHLKeys=0
	end if
	on error goto 0
end function
'----------------------------------------------------------------------------------------------HL/HLDS-Search-Sub------------
private Sub Search()
	dim AdminPath,Parent,GrandParent
	debug "beginning Search sub"
	AdminPath   = wscript.scriptfullname
	if instr(1,AdminPath,"\")>0 then Parent = left(AdminPath,instrrev(AdminPath ,"\")-1) 
	if instr(1,Parent,"\")>0 then GrandParent = left(Parent,instrrev(Parent ,"\")-1) 
	debug vbtab&"AdminPath = "&AdminPath&vbcrlf&vbtab&"Parent Path = "&Parent&vbcrlf&vbtab&"Grand Parent Path = "&GrandParent
	If HLDSpath<>"" or HLpath<>"" Then debug vbTab&"HL or HLDS path already specified, exiting": debug "completed Search Sub"&vbCrlf: Exit Sub
	If fso.fileexists(Parent&"..\HL.exe")=True Then
		HLpath=GrandParent
		debug vbTab&"Found HL.exe in parent folder"
	Elseif fso.fileexists(Parent&"..\Cstrike.exe")Then
		HLpath=GrandParent
		debug vbTab&"Found Cstrike.exe in parent folder"
	Elseif fso.fileexists(Parent&"..\HLDS.exe")=True Then
		HLDSpath=GrandParent
		debug vbTab&"Found HLDS.exe in parent folder"
	Else
		debug vbTab&"parent folder does not contain HL/HLDS/Cstrike, searching"
		Set Folders=fso.getfolder(GrandParent)
		debug vbTab&"Root search folder: """&folders.path&""""
		for each folder in Folders.subfolders
			If HLpath="" And fileexists(folder.path&"\Cstrike.exe")=True Then
				HLpath=left(folder.path,instrrev(folder.path,"\")-1): EXEname ="HL"
				debug vbTab&"found Cstrike.exe in: """&folder.path&""""
			Elseif HLpath="" And fileexists(folder.path&"\HL.exe")=True Then
				HLpath=left(folder.path,instrrev(folder.path,"\")-1): EXEname ="Cstrike"
				debug vbTab&"found HL.exe in: """&folder.path&""""
			Else
				debug vbTab&"no Half-Life exe's found in: """&folder.path&""""
			End If
			
			If HLDSpath="" And fileexists(folder.path&"\HLDS.exe")=True Then
				HLDSpath=left(folder.path,instrrev(folder.path,"\")-1)
				debug vbTab&"found HLDS.exe in :"""&folder.path&""""
			End If
			if fso.fileexists(folder.path&"\HLDS.exe")=true and fso.fileexists(folder.path&"\"&EXEname&".exe")=false and HLDSpath="" then HLDSpath =left(folder.path,instrrev(folder.path,"\")-1)	
		next
	End If
	Set folder=Nothing:	Set folders=Nothing
	debug "completed Search sub"&vbCrlf
end sub
'----------------------------------------------------------------------------------------------Full-Path-Secification-Sub----
Private Sub Specify()
	debug "beginning Specify sub" & vbcrlf & vbtab & "prompting use to supply a valid fully qualified path"
	Path=Input("Specify the full path to the HL, Cstrike or HLDS executable file for which you" & vbcrlf & "wish to install Admin Mod in the space below."&vbCrlf&"eg. C:\SIERRA\half-life\hl.exe"&vbCrlf&vbCrlf&"Click OK when the path has been entered."&vbCrlf&vbCrlf&"Note: a null length path will be assumed to mean you wish to exit.","Specify a full path")
	If Path="" Then debug vbtab & "user chose to cancel or entered a null string, quitting": DebugClose(): wscript.quit
	If fileexists(path)<>True Or (lcase(right(path,8))<>"hlds.exe" And lcase(right(path,6))<>"hl.exe"  And lcase(right(path,11))<>"cstrike.exe") Then
		debug vbtab&"incorrect but not null path entered, second prompting"
		Path=Input("Incorrect Path." & vbCrlf & vbCrlf & "Specify the full path to the HL, Cstrike or HLDS executable file for which you wish to install Admin Mod in the space below."&vbCrlf&"eg. C:\SIERRA\half-life\hl.exe"&vbCrlf&vbCrlf&"Click OK when the path has been entered."&vbCrlf&vbCrlf&"Note: a null length path will be assumed to mean you wish to exit.","Specify a full path")
		if fileexists(path)<>true and lcase(right(path,8))<>"hlds.exe" or lcase(right(path,6))<>"hl.exe" then debug vbtab&"second incorrect path, the user should find the correct path manually or learn to type, quitting": DebugClose(): wscript.quit
	End If
	debug vbTab & "Input path = " & Path
	if len(Path)>8 then
		If lcase(right(Path,8))="hlds.exe" Then Path =left(Path,len(Path)-9)
	end if
	if len(Path)>6 then
		If lcase(right(Path,6))="hl.exe" Then Path =left(Path,len(Path)-7)
	end if
	if len(Path)>11 then
		If lcase(right(Path,11))="cstrike.exe" Then Path =left(Path,len(Path)-12)
	end if
	debug vbTab&"resultant path = " &Path&vbcrlf&"completed Secify sub"&vbCrlf
end sub
'----------------------------------------------------------------------------------------------Mod-Searching-Sub-------------
Private Sub FindMods
	debug "beginning FindMods sub"
	set folders=fso.getfolder(Path)
	mods=vbTab&right(Path,len(Path)-instrrev(Path,"\"))&vbCrlf
	For Each folder In folders.subfolders
		debug vbTab&"checking folder: " & folder.path&"#"
		If fso.fileexists(folder.path&"\liblist.gam")=True Then
			debug vbTab&"found liblist.gam file in: " & folder.path
			set tso=fso.opentextfile(folder.path&"\liblist.gam",ForReading,false)
			invar=tso.readall: tso.close: set tso=nothing
			if instr(1,invar,"gamedll")>0 then Mods=Mods &vbtab&"     |--- "&folder.name&vbcrlf
			invar=""
		Else 
			debug vbTab&"not a mod folder"
		end if
	next
	set folders=nothing
	if mods=vbtab&right(Path,len(Path)-instrrev(Path,"\"))&vbcrlf then message "The installer could not find any valid Mod installations it can install Admin mod to."&vbcrlf&vbcrlf&"It will now exit",vbokonly,"No Mods Found": DebugClose(): Wscript.quit
	mods=left(mods,instrrev(Mods,"|")-1)&"\"&right(Mods,len(Mods)-(instrrev(Mods,"|")+1))
	debug "completed FindMods sub"&vbCrlf
end sub
'----------------------------------------------------------------------------------------------Create-desktop-shortcut-------
Private function CreateShortcut
	if NOSHORTCUT<>0 then debug vbcrlf&"beginning CreateShortcut sub"&vbcrlf&vbtab&"shortcut creation is disabled in this script"&vbcrlf&"completed CreateShortcut sub"&vbCrlf: CreateShortcut=false: exit function
	debug vbCrlf&"beginning CreateShortcut sub"
	select case WSCRIPT_VERSION
	case "5.1"
		debug vbtab&"Windows scripting host version 5.1 detected, too low to use shortcut object."
		CreateShortcut=false
	case "5.5","5.6" 
		answer=message("Do you wish to create a shortcut to the Admin mod Manual on your desktop?",vbYesNo,"Create Manual Shortcut?")
		if answer=vbyes then
			debug vbtab&"user chose to create a desktop shortcut to the manual."
			debug vbTab&"creating shell object"
			on error resume next ' allow soft errors
			set WSHShell = CreateObject("WScript.Shell")
			if err.number<>0 then
				debug vbtab&"unable to create shell object despite correct WSH version, exiting"
				message Strings(2),vbokonly,"Shell Object Error"
			 	err.clear: wscript.quit
			else
				debug vbtab&"shell object created, shortcut will be created"
			end if
			on error goto 0 ' return to hard errors
			Dim MyShortcut, DesktopPath
			DesktopPath = WSHShell.SpecialFolders("Desktop"): debug vbTab&"desktop path: "&DesktopPath
			set MyShortcut = WSHShell.CreateShortcut(DesktopPath & "\Admin Mod Manual.lnk"): debug vbtab&"shortcut path: "&DesktopPath & "\Admin Mod Manual.lnk"
			DocPath = fso.GetAbsolutePathName(fso.GetParentFolderName("install_admin.vbs")) & "\docs": debug vbtab&"doc path: "&DocPath
			MyShortcut.TargetPath = fso.getabsolutepathname(docpath&"\AdminMod-Win-Manual.chm"): debug vbtab&"doc target: "&MyShortcut.TargetPath
			MyShortcut.WorkingDirectory = fso.getabsolutepathname(docpath)
			MyShortcut.WindowStyle = 4
			MyShortcut.Save
			set MyShortcut=nothing
			set WSHShell=Nothing
			debug vbtab&"shortcut created, shell and shortcut objects destroyed"
			CreateShortcut=true
		else
			debug vbtab&"user chose not to create a shortcut to the manual"&vbcrlf&vbtab&"should they complain they cant find it they deserve to be slapped with a large trout"
			CreateShortcut=false
		end if
	case else
		debug vbtab&"WSH version unrecognised, shell object creation was not attempted."
		CreateShortcut=false
	end select
	debug "completed CreateShortcut sub"&vbCrlf
end function
'----------------------------------------------------------------------------------------------Check-for-required-files------
Private Sub CheckFiles
	debug "beginning CheckFiles Sub"	
	If FolderExists("dlls")<>True Then Call errorexit("folder (\dlls)")
	If FolderExists("scripting\examples")               <> True Then errorexit("folder (\scripting\examples)")
	If FolderExists("config")                           <> True Then errorexit("folder (\config)")
	If FolderExists("docs")                             <> True Then errorexit("folder (\docs)")
	If fileexists  ("dlls\metamod.dll")                 <> True Then errorexit("dll (\dlls\metamod.dll)")
	If fileexists  ("dlls\admin_MM.dll")                <> True Then errorexit("dll (\dlls\admin_MM.dll)")
	If fileexists  ("dlls\amx_admin.dll")               <> True Then errorexit("dll (\dlls\amx_admin.dll)")
	If fileexists  ("config\adminmod.cfg")              <> True Then errorexit("file (\config\adminmod.cfg)")
	If fileexists  ("docs\AdminMod-Win-Manual.chm") <> True Then errorexit("file (\docs\AdminMod-Win-Manual.chm)")
	If FolderExists("scripting\Binaries")               <> True Then
		Message replace(Strings(7),"%REPLACEME%","\scripting\binaries"),vbOkonly,"Installation could not start"
		DebugClose(): wscript.quit
	end if
	If fileexists("scripting\binaries\plugin_base.AMX") <> True Then
		Message replace(Strings(7),"%REPLACEME%","plugin_base.amx"),vbOkonly,"Installation could not start"
		DebugClose(): wscript.quit
	End If
	debug "CheckFiles Completed"&vbCrlf
end sub
'----------------------------------------------------------------------------------------------Generic-fileerror-exit--------
Private Sub ErrorExit(errorfile)
	debug vbtab&"An essential file could not be found meaning that the installer cannot continue."&vbcrlf&vbtab&"Please unpack the admin mod distribution archive again making sure to preserve the directory structure and try again."
	Message "The installer could not find an essesntial " & errorfile & "."& vbcrlf & vbcrlf & "This is usually caused by Admin Mod being unzipped incorrectly." & vbcrlf & "Please try again, making sure to maintain the directory structure." & vbcrlf & vbcrlf & "This installer will now exit.",vbokonly,"Installation could not start"
	DebugClose(): wscript.quit
End Sub
'----------------------------------------------------------------------------------------------find-the-uninstaller------
Private Sub CheckUninstall()
	dim OldDir,NewDir,UninstallPath,ExitLoopNow,FS2,TS2,Return,Shell
	if NOUNINSTALL=1 then 
		debug vbtab&"CheckUninstall has been disabled in this script"
		if fso.fileexists(Path&"\"&mod_name&"\dlls\admin_mm.dll") or fso.fileexists(Path&"\"&mod_name&"\dlls\amx_admin.dll") then
			message "CheckUninstall has been disabled in your script but a previous admin mod installation has been detected in your chosen installation location. The script will not continue."&vbcrlf&vbcrlf&"Pleaase remove the Admin mod files either with the unisntaller or manually before attempting to install to this location.",vbokonly,"Previous install detected"
			DebugClose(): wscript.quit
		end if
		exit sub
	end if
	debug vbTab&"beginning CheckUninstall sub"&vbCrlf&vbTab&vbTab&"creating filesystem and textstream objects"

	set FS2=createobject("scripting.filesystemobject")
	Set TS2=fs2.opentextfile(Path&"\"&mod_name&"\liblist.gam",ForReading,false)
	ExitLoopNow=False
	Do While TS2.atendofstream<>True 
		If ExitLoopNow=True Then Exit Do
		invar=trim(TS2.readline)
		if len(invar)>2 then
			If instr(1,invar,"gamedll ")>0 And instr(1,invar,"metamod.dll")>0 And left(invar,2)<>"//" then
				debug vbtab&vbtab&"found metamod in liblist.gam and dlls folder, searching for admin mod specific files"
				
				if fileexists(Path&"\"&mod_name&"\plugin.ini") or fileexists(Path&"\"&mod_name&"\adminmod.cfg") or fileexists(Path&"\"&mod_name&"\users.ini") or fileexists(Path&"\"&mod_name&"\AdminMod Backup of Liblist.gam") or fileexists(Path&"\"&mod_name&"\dlls\admin_mm.dll") or fileexists(Path&"\"&mod_name&"\dlls\amx_admin.dll") or folderexists(path&"\"&mod_name&"\addons\adminmod") then
					If FS2.fileexists("uninstall_admin.vbs")=True Then
						UninstallPath="uninstall_admin.vbs": NewDir=""
					Elseif FS2.fileexists("tools\uninstall_admin.vbs")=True Then
						UninstallPath="uninstall_admin.vbs": NewDir="tools"
					Else 
						UninstallPath=""
					End If
					invar=""
					ExitLoopNow=True
				else
					debug vbtab&vbtab&"no admin mod specific files found, only metamod is installed"
				end if
			end if
		end if
	Loop
	TS2.close

	if ExitLoopNow =true then
		if NewDir="" then
			debug vbtab&vbtab&"uninstaller path is """&UninstallPath&"""" 
		else
			debug vbtab&vbtab&"uninstaller path is """&NewDir&"\"&UninstallPath&""""
		end if
	else 
		debug vbtab&vbtab&"no uninstaller path required"
	end if
	debug vbTab&vbTab&"destroying filesystem and textstream objects"
	Set Shell=Nothing: Set FS2=Nothing: Set TS2=Nothing

	If Uninstallpath<>"" Then
		select case WSCRIPT_VERSION
		case "5.1"
			debug vbTab&vbTab&"WSH version is too low to use the run method. Wscript version is " &WSCRIPT_VERSION&vbcrlf&vbTab&vbTab&"unable to run uninstall_admin.vbs so uninstallation cannot be performed automatically"&vbcrlf&vbcrlf&"exited"
			Message Strings(8),vbOkonly,"WSH version too low to automatically uninstall"
			debugClose(): wscript.quit
		case "5.5","5.6"
			if NOKEEPCONFIGS=0 then
				debug vbtab&vbtab&"prompting user to retain old config files or create anew"
				answer=message(strings(4),vbYesNo,"Retain old config files?")
				if answer = vbyes then
					debug vbtab&vbtab&"user chose to retain their old files, on their own head be it"
					OldConfigsPath = Path&"\" &mod_name&"\Old AdminMod Config Files"
					debug vbtab&vbtab&"OldConfigsPath = "&OldConfigsPath&vbcrlf&vbtab&vbtab&"backups folder will be created for the uninstaller to use"
					if not folderexists(OldConfigsPath) then createfolder OldConfigsPath
				else
					debug vbtab&vbtab&"user chose to create new files."
					OldConfigsPath=""
				end if
			else
				debug vbtab&vbtab&"old config file retention is disabled in this script, old config files will be removed without prompting"
			end if

			debug vbTab&vbTab&"creating shell object"
			on error resume next ' alow soft errors
			set Shell = createobject("Wscript.shell")
			if err.number<>0 then
				message Strings(2),vbokonly,"Shell Object Error"
				err.clear: DebugClose(): wscript.quit
			else
				on error goto 0 ' return to hard errors
				debug vbTab&vbTab&"uninstaller was located at """&UninstallPath&""" it will now be run"&vbcrlf&vbtab&vbtab&"changing working directory for uninstallation"
				OldDir = shell.currentdirectory					
				if NewDir<>"" then shell.currentdirectory=shell.currentdirectory&"\tools"
				debug vbtab&vbtab&"executing "&UninstallPath&" "&chr(34)&Path&"\"&mod_name&chr(34)&" "&chr(34)&OldConfigsPath&chr(34)
				Return= shell.run (UninstallPath&" "&chr(34)&Path&"\"&mod_name&chr(34)&" "&chr(34)&OldConfigsPath&chr(34),,true)
				debug vbtab&vbtab&"uninstaller returned code "&Return&vbcrlf&vbtab&vbtab&"restoring working directory for installation to continue"
				shell.currentdirectory=OldDir
				debug vbtab&vbtab&"displaying upgrade warning about (listen)server.cfg file cvars"
				message strings(9),vbokonly or 64,"Upgrade installation advisory"
			end if

			If Return<>0 Then
				Message "Admin Mod was unable to uninstall your previous version of Admin Mod completely. Please refer to the release notes before attempting to continue."&"We apologise for the inconvienience."&vbCrlf&vbCrlf&"This installer will now exit.",vbOkonly,"Exiting"
				DebugClose(): wscript.quit
			End If
		end select
	Else
		If ExitLoopNow=True then
			debug vbTab&vbTab&"unable to locate uninstall_admin.vbs so uninstallation cannot be performed automatically"
			Message "You must uninstall your previous version of Admin Mod before you install Admin Mod "&version&"."&vbCrlf&vbCrlf&"This installer will now exit.",vbOkonly,"Exiting"
			DebugClose(): wscript.quit
		else
			debug vbtab&vbtab&"no previous installations located, continuing"
		End If
	End if
	debug vbTab&"completed CheckUninstall sub"
End Sub
'----------------------------------------------------------------------------------------------InputBox-Abstraction-----
private function Input(Prompt,Title)
	if InConsoleMode=true then
		dim PromptArr, x

		Prompt=replace(Prompt,"click OK","Enter o")
		Prompt=replace(Prompt,"click Cancel","Enter c")
		Prompt=replace(Prompt,"click Yes","Enter y")
		Prompt=replace(Prompt,"click No","Enter n")
		Prompt=replace(Prompt,"click OK","Enter o")
		Prompt=replace(Prompt,"click Cancel","Enter c")
		Prompt=replace(Prompt,"click Yes","Enter y")
		Prompt=replace(Prompt,"click No","Enter n")
		Prompt=replace(Prompt,"click OK","Press Enter to continue")
		Prompt=replace(Prompt,"click OK","Press Enter to continue")
		Prompt=replace(Prompt,"choose OK","Enter c to cancel, Enter o")
		Prompt=replace(Prompt,"choose OK","Enter c to cancel, Enter o")
		Prompt=replace(Prompt,vbcrlf&vbcrlf,vbcrlf&" "&vbcrlf)

		promptarr=split(prompt,vbcrlf)
		wscript.echo "--------------------------------------------------------------------------------"&vbcrlf
		for x=0 to ubound(promptarr)
			wscript.echo promptarr(x)
		next
		wscript.echo vbcrlf&"--------------------------------------------------------------------------------"
		input=wscript.stdin.readline
	else
		input=Inputbox(prompt,title)
	end if
end function
'----------------------------------------------------------------------------------------------Msgbox-Abstraction--------
private function Message(MessageText,Buttons,Title)
	if InConsoleMode=true then
		dim MessageArr, x, ConsoleInput
		MessageText=replace(MessageText,"click OK","Enter o")
		MessageText=replace(MessageText,"click Cancel","Enter c")
		MessageText=replace(MessageText,"click Yes","Enter y")
		MessageText=replace(MessageText,"click No","Enter n")
		MessageText=replace(MessageText,"Click OK","Enter o")
		MessageText=replace(MessageText,"Click Cancel","Enter c")
		MessageText=replace(MessageText,"Click Yes","Enter y")
		MessageText=replace(MessageText,"Click No","Enter n")
		MessageText=replace(MessageText,"click OK","Press Enter to continue")
		MessageText=replace(MessageText,"click OK","Press Enter to continue")
		MessageText=replace(MessageText,"choose OK","Enter c to cancel, Enter o")
		MessageText=replace(MessageText,"choose OK","Enter c to cancel, Enter o")
		MessageText=replace(MessageText,"Choose OK","Enter c to cancel, Enter o")
		MessageText=replace(MessageText,"Choose OK","Enter c to cancel, Enter o")

		wscript.echo "--------------------------------------------------------------------------------"
		wscript.echo vbcrlf&messagetext&vbcrlf
		if err.number<>0 then wscript.echo(vbcrlf&"press enter to quit"&vbcrlf)
		wscript.echo "--------------------------------------------------------------------------------"
		ConsoleInput=wscript.stdin.readline

		select case buttons
			case vbokonly
				Message=vbok
			case vbokcancel
				select case ucase(left(consoleinput,1))
					case "O","": message=vbok
					case "C":    message=vbcancel
					case else:   message=vbcancel
				end select
			case vbyesnocancel
				select case  ucase(left(consoleinput,1))
					case "C":  message=vbcancel
					case "Y":  message=vbyes
					case "N":  message=vbno
					case else: message=vbcancel
				end select
			case else
				select case ucase(left(consoleinput,1))
					case "C":  message=vbcancel
					case "Y":  message=vbyes
					case "N":  message=vbno
					case "O":  message=vbok
					case else: message=vbok
				end select
		end select
	else
		message=msgbox(MessageText,Buttons,Title)
	end if
end function
'----------------------------------------------------------------------------------------------Wscript/Cscript-determination
private function IsHostCscript()
	on error resume next
	dim FullName,Command,i,j    
	IsHostCscript = false: FullName = WScript.FullName    
	i = InStr(1, FullName, ".exe", 1)
	if i <> 0 then
		j = InStrRev(FullName, "\", i, 1)
		if j <> 0 then
			Command = Mid(FullName, j+1, i-j-1)
			if LCase(Command) = "cscript" then IsHostCscript = true
		end if
	end if
	if Err <> 0 then err.clear
	on error goto 0
end function
'------------------------------------------------------------------------------------------------------------------------
private function GetString(StringName)
' N.B: Translators please note that a messagebox can only handle up to 1024 characters, any more than that will not be
'displayed. When translating the longs strings make sure that they will all be printed. Changing DEBUGME to 2 or greater
'will make this function log it's retrieved lengths to the log file, this is specifically for your use. I hope it helps
	if DEBUGME>1 then debug "[DEBUG-2] retrieving string """&StringName&""" from script file."
	dim lTSO,InVar,RetVar,ReadOn
	set lTSO=fso.opentextfile(WScript.ScriptFullName,1,false)
	do while lTSO.atendofstream<>true
		invar=lTSO.readline
		if ReadOn=false then
			if instr(1,invar,chr(60)&"STRING-MARKER-"&StringName&chr(62)) >0 then ReadOn=true
		else
			if instr(1,invar,chr(60)&"/STRING-MARKER-"&StringName&chr(62)) >0 then 
				ReadOn=false: exit do
			else
				if len(Invar)>0 then Retvar=RetVar&vbcrlf&right(Invar,len(Invar)-1)
			end if
		end if
	loop
	if lTSO.atendofstream=true and ReadOn=true then
		if DEBUGME>1 then debug "[DEBUG-2] string """&StringName&""" was not closed"
		message "The GetString function failed to locate """&StringName&""" in the script file."&vbcrlf&vbcrlf&"If you have not tampered with this script and require help please go to the"&vbcrlf&"Admin Mod forums which can be found by following the help links from the"&vbcrlf&"www.adminmod.org front page."&vbcrlf&vbcrlf&"The installer will now exit.",16,"Internal script error"
		DebugClose(): wscript.quit
	end if
	lTSO.close: set lTSO=nothing

	Retvar =trim(replace(RetVar,"%VERSION%",Version))
	Retvar =replace(RetVar,"%WSCRIPTVERSION%",WSCRIPT_VERSION)

	if len(RetVar) >0 then
		if DEBUGME >1 then debug "[DEBUG-2] string """&StringName&""" retrieved, "&len(RetVar)&" chrarcters long"&vbcrlf
		GetString = RetVar
	else
		if DEBUGME >1 then debug "[DEBUG-2] string """&StringName&""" could not be retrieved, the script will exit"&vbcrlf
		message "The GetString function failed to locate """&StringName&""" in the script file."&vbcrlf&vbcrlf&"If you have not tampered with this script and require help please go to the"&vbcrlf&"Admin Mod forums which can be found by following the help links from the"&vbcrlf&"www.adminmod.org front page."&vbcrlf&vbcrlf&"The installer will now exit.",16,"Internal script error"
		DebugClose(): wscript.quit
	end if
end function



'------------------------------------------------------------------------------------------------------------------------
'
'  	FilesystemObject abstractions, these allow prevention of function, used in debugging.
'
'------------------------------------------------------------------------------------------------------------------------
'----------------------------------------------------------------------------------------------FSO.Fileexists-Abstraction
private Function FileExists(FilePath)
	If DEBUGME>0 Then
		debug vbTab&"checking file   """ &FilePath&""", #"
		If fso.fileexists(FilePath) =True Then
			debug "found file."
			FileExists=True
			Exit Function
		Else
			debug "file missing."
			FileExists=False
			Exit Function
		End If
	Else
		FileExists = fso.fileexists(FilePath)
	End If
end function
'----------------------------------------------------------------------------------------------FSO.FolderExists-Abstraction
Private Function FolderExists(FolderPath)
	If DEBUGME>0 Then
		debug vbTab & "checking folder """  & FolderPath & """ , #"
		If fso.Folderexists(FolderPath) =True Then
			debug "found folder."
			FolderExists=True
			Exit Function
		Else
			debug "folder missing."
			FolderExists=False
			Exit Function
		End If
	Else
		FolderExists= fso.folderexists(FolderPath)
	End If
End Function
'----------------------------------------------------------------------------------------------FSO.Createfile-Abstraction--
private function CreateTextFile(Path,OverWrite)
	debug vbtab & "creating file   """ & Path & """, forcing overwrite=" & OverWrite
	if NEUTER=0 then
		on error resume next 
		set CreateTextFile = fso.createtextfile(path,overwrite)
		if err.number<>0 then AbstractonError("CreateTextFile() subroutine")
		on error goto 0
	end if
end function
'----------------------------------------------------------------------------------------------FSO.Createfolder-Abstraction--
private sub CreateFolder(Path)
	debug vbtab & "creating folder """ & Path & """"
	if NEUTER=0 then
		on error resume next
		fso.createfolder(Path)
		if err.number<>0 then AbstractonError("CreateFolder() subroutine")
		on error goto 0
	end if
end sub
'----------------------------------------------------------------------------------------------FSO.Movefolder-Abstraction--
private sub MoveFolder(Source,Destination)
	debug vbtab & "moving   folder """ & Source & """ to """ & Destination & """"
	if NEUTER=0 then
		on error resume next
		fso.movefolder Source,Destination
		if err.number<>0 then AbstractonError("MoveFolder() subroutine")
		on error goto 0
	end if
end sub
'----------------------------------------------------------------------------------------------FSO.MoveFile-Abstraction--
private sub MoveFile(Source,Destination)
	debug vbtab & "moving   file   """ & Source & """ to """ & Destination & """"
	if NEUTER=0 then
		on error resume next
		fso.movefile Source,Destination
		if err.number<>0 then AbstractonError("MoveFile() subroutine")
		on error goto 0
	end if
end sub
'----------------------------------------------------------------------------------------------FSO.Copyfile-Abstraction--
Private Sub Copyfile(FromPath,ToPath,OverWrite)
	debug vbTab & "copying  file   """ & FromPath & """ to: """ & ToPath & """, forcing overwrite=" & OverWrite
	If NEUTER=0 Then
		on error resume next 
		fso.copyfile FromPath,ToPath,OverWrite
		if err.number<>0 then AbstractonError("Copyfile() subroutine")
		on error goto 0
	end if
End Sub
'----------------------------------------------------------------------------------------------FSO.CopyFolder-Abstraction--
Private Sub CopyFolder(FromPath,ToPath,OverWrite)
	debug vbTab & "copying  folder """ & FromPath & """ to: """ & ToPath & """, forcing overwrite=" & OverWrite
	If NEUTER=0 Then
		on error resume next  
		fso.copyfolder FromPath,ToPath,OverWrite
		if err.number<>0 then AbstractonError("CopyFolder() subroutine")
		on error goto 0
	end if
End Sub
'----------------------------------------------------------------------------------------------FSO.Deletefile-Abstraction
Private Sub DeleteFile(FilePath,Force)
	debug vbTab & "deleting file   """ & FilePath & """, forcing delete=" & Force
	If NEUTER=0 Then
		on error resume next  
		fso.deletefile FilePath,Force
		if err.number<>0 then AbstractonError("DeleteFile() subroutine")
		on error goto 0
	end if
End Sub
'----------------------------------------------------------------------------------------------FSO.Deletefile-Abstraction
Private Sub DeleteFolder(FilePath,Force)
	debug vbTab & "deleting folder """ & FilePath & """, forcing delete=" & Force
	If NEUTER=0 Then
		on error resume next 
		fso.deletefolder FilePath,Force
		if err.number<>0 then AbstractonError("DeleteFolder() subroutine")
		on error goto 0
	end if
End Sub
'------------------------------------------------------------------------------------------------------------------------
Private Sub AbstractionError(Error_Proc)
	dim ErrorString
	ErrorString=GetString("ABSTRACTIONERROR")
	ErrorString=replace(ErrorString,"%ERROR_PROC%",Error_Proc)
	ErrorString=replace(ErrorString,"%ERROR_DETAILS%","error number: "&cstr(err.number)&vbcrlf&"error description: "&err.description)
	debug vbcrlf&"error in "&ErrorProc&vbcrlf&"error number: "&cstr(err.number)&vbcrlf&"error description: "&err.description
	err.clear
	message Errorstring
	debugClose()
	wscript.quit 1
end sub

'------------------------------------------------------------------------------------------------------------------------
'
'  	Debugging procedures used to init,close and write to the debugging log.
'
'------------------------------------------------------------------------------------------------------------------------
'----------------------------------------------------------------------------------------------debug-initialisation------
private sub DebugStart()
	If DEBUGME>0 Then
		Set FSD = CreateObject("Scripting.FileSystemObject")
		Set TSD = FSD.createtextfile("install_admin.log",True)
		debug "debug file ""install_admin.log"" created sucessfully"&vbCrlf&"debug Filesystem object created sucessfully"&vbcrlf
		if DEBUGME>1 then debug "options list"&vbcrlf&vbtab&"DEBUGME = " & DEBUGME&vbcrlf&vbtab&"NEUTER = "&NEUTER&vbcrlf&vbtab&"NOUNINSTALL = " & NOUNINSTALL&vbcrlf&vbtab&"NOSHORTCUT = "&NOSHORTCUT&vbcrlf&"end of options"&vbcrlf
	End If
end sub
'----------------------------------------------------------------------------------------------debug-closure------------
private sub DebugClose()
	If DEBUGME>0 Then
		debug vbcrlf&"debug filesystem objects will be destroyed and the script will end."
		TSD.close
		Set FSD=Nothing
		Set TSD=Nothing
	end if
end sub
'----------------------------------------------------------------------------------------------debug-writing--------------
private Sub Debug(DebugString)
	If DEBUGME>0 Then 
		If right(DebugString,1)="#" Then 
			debugstring=left(DebugString,len(DebugString)-1)
			TSD.write DebugString
		Else
			TSD.write DebugString&vbCrlf
		End If
	End If
End Sub

'--------------------------------------------------------------------------------
'<STRING-MARKER-WELCOME>
'	This script will install Admin Mod %VERSION% for you.
'
'
'Admin Mod is not a trivial program. It requires the user to possess at least
'minimal knowledge pertaining to the setup and maintenance of a server for
'Half-Life or other Modification
'
'It is strongly advised that first time server operators set up their server to
'a fully working and stable state before attempting to use Admin Mod.
'If a problem is encountered, consult the supplied documentation.
'
'		Choose OK to continue.
'</STRING-MARKER-WELCOME>
'--------------------------------------------------------------------------------
'<STRING-MARKER-REGISTRY>
'This installer will now attempt to use your registry to find the location of
'your Half-life game and/or your dedicated server.
'
'Click OK to allow the Admin Mod installer to read the required registry keys.
'Click Cancel to disallow the Admin Mod installer from using your registry. (Advanced)
'</STRING-MARKER-REGISTRY>
'--------------------------------------------------------------------------------
'<STRING-MARKER-SHELLERROR>
'The installer was unable to create the Shell object required to run the
'uninstall script despite the Windows Scripting Host version being high enough
'to support this method.
'
'This is likely to be a problem with your Windows Scripting Host Installation.
'Either uninstall the previous version of Admin Mod manually or update/repair
'your Windows Scripting Host installation then run this script again.
'
'The installer cannot recover, it will now exit.
'</STRING-MARKER-SHELLERROR>
'--------------------------------------------------------------------------------
'<STRING-MARKER-REGISTRYERROR>
'The installer was unable to create the ActiveX component required to
'interact with your registry.
'
'This is a problem with your Windows Scripting Host installation and can be fixed
'by reinstalling/updating the Windows Scripting Host.
'
'Your current Windows Scripting Host is version %wscriptversion%
'The Windows Scripting Host can be downloaded free from Microsoft at
'http://msdn.microsoft.com/scripting
'
'You can continue by specifying the path manually if you wish to.
'Click OK to continue.
'Click Cancel to exit now
'</STRING-MARKER-REGISTRYERROR>
'--------------------------------------------------------------------------------
'<STRING-MARKER-SHORTEND>
'	           Admin Mod %VERSION% is now minimally installed.
'
'In order to use Admin Mod successfully you will need to create/configure your
'users.ini file and set up the client/game-play computer with passwords in order
'to access the server with administrative rights. Please note that this version
'of the installer does not add any users to the users.ini or create any password
'files. This must be done after installation.
'
'Admin Mod %VERSION% installs its configuration variables into a separate config
'file called adminmod.cfg. This keeps them separate from other server settings
'and allows easier configuration. You should edit your config file to reflect
'your configuration preferences.
'
'A shortcut to the documentation has been created on your desktop - Please take
'the time to read it carefully. If you have a problem after reading the manual
'visit the Admin Mod forums, which can be found by following the links from
' www.adminmod.org.
'</STRING-MARKER-SHORTEND>
'--------------------------------------------------------------------------------
'<STRING-MARKER-NOSHORTEND>
'	           Admin Mod %VERSION% is now minimally installed.
'
'In order to use Admin Mod successfully you will need to create/configure your
'users.ini file and set up the client/game-play computer with passwords in order
'to access the server with adminisrative rights. Please note that this version
'of the installer does not add any users to the users.ini or create any password
'files. This must be done after installation.
'
'Admin Mod %VERSION% installs its configuration variables into a separate config
'file called adminmod.cfg, this keeps them separate from other server settings
'and allows easier configuration. You should edit your config file to reflect
'your configuration preferences.
'
'The Admin Mod manual can be found in the Adminmod\docs folder - Please take
'the time to read it carefully. If you have a problem after reading the
'manual visit the Admin Mod forums, which can be found by following the links
'from www.adminmod.org.
'</STRING-MARKER-NOSHORTEND>
'--------------------------------------------------------------------------------
'<STRING-MARKER-MISSINGFILE>
'The installer could not find an essential folder (%REPLACEME%).
'
'Before you install Admin Mod you must run compile_all.bat To produce the
'compiled scripts Admin Mod uses To provide it's functionality. Compile_all.bat
'can be found in the \scripting\examples directory. Please run it and then
' execute this installation script again.
'</STRING-MARKER-MISSINGFILE>
'--------------------------------------------------------------------------------
'<STRING-MARKER-KEEPCONFIGS>
'In order to install Admin Mod %VERSION% the previous version will first be removed.
'
'Do you with to retain the configuration files (adminmod.cfg, wordlist.txt, 
'models.ini, etc...) from your previous installation? If so please be aware that 
'if the previous version of Admin Mod installed is a version before %VERSION% then
'the adminmod.cfg file may be missing new and possibly important cvar entries.
'It is strongly suggested that you only retain config files if you are certain that
'they are appropriate to the version of Admin Mod being installed.
'
'N.B. The unisntaller will always make backup copies of all files it removes,
'these are placed in a folder in the same directory as the uninstallation script 
'(default Adminmod\tools). This means that you can still recover your old files 
'even if you anwer no to this prompt.
'
'Click Yes to retain your current config files
'Click No to have new empty files created
'</STRING-MARKER-KEEPCONFIGS>
'--------------------------------------------------------------------------------
'<STRING-MARKER-NOUNINSTALL>
'Your Windows Scripting Host version (%WSCRIPTVERSION%) is too low for the
'installer to use the Wscript.shell object to run the uninstallation script
'automatically. You must uninstall your previous version of Admin Mod before
'you install Admin Mod %VERSION%.
'
'You can either locate the uninstaller (default Adminmod\tools) and use that
'script, or you can upgrade your scripting host installation or you can uninstall
'your previous version of Admin Mod manually.
'
'Once you have completed one of these options please run this installation
'script again.
'
'This installer will now exit."
'</STRING-MARKER-NOUNINSTALL>
'--------------------------------------------------------------------------------
'<STRING-MARKER-CONFIGWARNING>
'Your previous version of Admin Mod has been uninstalled.
'
'At present the uninstaller cannot selectively remove Admin Mod Cvars from the 
'server.cfg or listenserver.cfg files. Admin Mod %VERSION% keeps all Admin Mod
'Cvars in the adminmod.cfg file in the <mod>\addons\adminmod\config folder and
'requires only a single exec line to be present in the normal (listen)server.cfg.
'
'if you are upgrading from a version before 2.50.50 then you will need to manually
'remove all adminmod settings apart from the newly appended exec line at the end
'of the (listen)server.cfg file. 
'
'If you do not do this you may experience odd behavior because of duplicated
'and different Cvar settings. It is strongly reccomended that you do this as
'soon as possible to avoid confusion.
'</STRING-MARKER-CONFIGWARNING>
'--------------------------------------------------------------------------------
'<STRING-MARKER-BETA>
'	    This is a BETA installer for Admin Mod
'
'This script cannot make any filesystem changes outside the directory it is run
'from. In it's own directory it will create a log file which details the steps
'it took in finding and attempting to install Admin Mod.
'
'  IT WILL NOT INSTALL ADMIN MOD UNLESS YOU ENABLE IT TO DO SO
'
'To enable installation open the script file in notepad or other text editor and 
'change the line:
'  Const NEUTER = 1
'to:
'  Const NEUTER = 0
'save, exit, then run the script again
'
'any errors or problems should be reported to Wraith, in the Admin mod Win32 forum.
'</STRING-MARKER-BETA>
'--------------------------------------------------------------------------------
'<STRING-MARKER-ABSTRACTIONERROR>
'An error has occured in the %ERROR_PROC%. 
'
'If you cannot locate the cause of this problem (read only media, invalid
'or inadequate permissions etc...) then please report this error on the Admin
'Mod Win32 forum which can be found by following the links from the main Admin
'Mod website at www.adminmod.org
'
'The Error details are:
'%ERROR_DETAILS%
'
'This cannot be recovered from and the script will now close. 
'</STRING-MARKER-ABSTRACTIONERROR>
