# Application description
DESCRIPTION.mysimple = Crystal Space tutorial MySimple

#------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Application-specific help commands
APPHELP += $(NEWLINE)echo $"  make mysimple      Make the $(DESCRIPTION.mysimple)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: mysimple mysimpleclean

all apps: mysimple
mysimple:
	$(MAKE_APP)
mysimpleclean:
	$(MAKE_CLEAN)

endif # ifeq ($(MAKESECTION),roottargets)

#------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp apps/tutorial/mysimple

MYSIMPLE.EXE=mysimple$(EXE)
INC.MYSIMPLE = $(wildcard apps/tutorial/mysimple/*.h)
SRC.MYSIMPLE = $(wildcard apps/tutorial/mysimple/*.cpp)
OBJ.MYSIMPLE = $(addprefix $(OUT)/,$(notdir $(SRC.MYSIMPLE:.cpp=$O)))
DEP.MYSIMPLE = CSTOOL CSGFX CSUTIL CSSYS CSGEOM CSUTIL
LIB.MYSIMPLE = $(foreach d,$(DEP.MYSIMPLE),$($d.LIB))

#TO_INSTALL.EXE += $(MYSIMPLE.EXE)

MSVC.DSP += MYSIMPLE
DSP.MYSIMPLE.NAME = mysimple
DSP.MYSIMPLE.TYPE = appcon

endif # ifeq ($(MAKESECTION),postdefines)

#----------------------------------------------------------------- targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: build.mysimple mysimpleclean

all: $(MYSIMPLE.EXE)
build.mysimple: $(OUTDIRS) $(MYSIMPLE.EXE)
clean: mysimpleclean

$(MYSIMPLE.EXE): $(DEP.EXE) $(OBJ.MYSIMPLE) $(LIB.MYSIMPLE)
	$(DO.LINK.EXE)

mysimpleclean:
	-$(RMDIR) $(MYSIMPLE.EXE) $(OBJ.MYSIMPLE)

ifdef DO_DEPEND
dep: $(OUTOS)/mysimple.dep
$(OUTOS)/mysimple.dep: $(SRC.MYSIMPLE)
	$(DO.DEP)
else
-include $(OUTOS)/mysimple.dep
endif

endif # ifeq ($(MAKESECTION),targets)
