
/*
    Copyright (C) 2002 by M. Kohel
    modified by Andreas Busch to work with the current
    CVS-Version of CrystalSpace V0.95
*/

#ifndef __MYSIMPLE_H__
#define __MYSIMPLE_H__

#include <stdarg.h>
#include <iengine/engine.h>

struct iEngine;
struct iLoader;
struct iGraphics3D;
struct iKeyboardDriver;
struct iSoundHandle;
struct iSoundRender;
struct iSoundSource;
struct iVirtualClock;
struct iObjectRegistry;
struct iEvent;
struct iSector;
struct iTextureManager;
struct iView;

//added for collision detection
struct iCollider;
struct iCollideSystem;
struct iMeshWrapper;
struct iMeshList;
struct iMovable;

// Wrap sprite and sound into one struct
/*
  struct ModelStruct
  {
    csRef<iMeshWrapper> sprite;
    csRef<iSoundSource> snd;
  };
*/

class Simple
{
private:
  iObjectRegistry      * object_reg;
  csRef<iEngine>         engine;
  csRef<iLoader>         loader;
  csRef<iGraphics3D>     g3d;
  csRef<iKeyboardDriver> kbd;
  csRef<iVirtualClock>   vc;
  iSector              * room;
  csRef<iView>           view;
  csRef<iTextureManager> txtmgr;
  bool                   forward;
  csVector3		 old_pos;
  csVector3		 real_old_pos;
  
  //next few  lines added for collision detection
  csRef<iCollideSystem>  cdsys;
  csRef<iMeshWrapper>    mesh_in_sector;
  iCollider            * npc_collide1;
  iCollider            * npc_collide2;
  iCollider            * npc_collide3;
  iCollider            * mesh_collider;
  iMeshList            * mesh_list;
  csRef<iMeshWrapper>    mesh1;
  csRef<iMeshWrapper>    mesh2;
  csRef<iMeshWrapper>    mesh3;

  //needed for sound
  csRef<iSoundRender>	 soundr;
  csRef<iSoundSource>    musicsrc;
  iSoundHandle	       * sound_footsteps;
  iSoundHandle	       * sound_talking;
  iSoundHandle	       * sound_music;
  csRef<iSoundSource>	 sound1;
  csRef<iSoundSource>	 sound2;
  csRef<iSoundSource>	 sound3;
  bool                   loop;
  bool                   sound_ok;
  bool                   music_playing;
  
  static bool SimpleEventHandler (iEvent& ev);
  bool HandleEvent (iEvent& ev);
  void SetupFrame ();
  void FinishFrame ();
  bool LoadMap ();
  iCollider* InitCollider (csRef<iMeshWrapper> mesh);

public:
  Simple ();
  ~Simple ();

  bool Initialize (iObjectRegistry* object_reg);
  void Start ();
};

#endif // __MYSIMPLE_H__

