FlierData Explorer
{
        explosionId = FlierExplosion;
        debrisId = FlierDebris;
        classname = "Vehicle";
        shapeFile = "flyer";
        shieldShapeName = "shield_medium";
        mass = 1.0;
        drag = 0.1;
        density = 1.0;
        maxBank = 12.5;
        maxPitch = 12.0;
        maxSpeed = 65;
        minSpeed = -15;
        maxSideSpeed = 10;

        lift = 0.2;
        maxAlt = 100000;
        maxVertical = 0.0000001;
        maxDamage = 0.55;

        damageLevel = {1.0, 1.0};
        maxEnergy = 30;
        accel = 1.5;
        groundDamageScale = 0.5;
        #projectileType = rifleBullet2;
        reloadDelay = 0.15;
        repairRate = 0;
        fireSound = ShockExplosion;
        damageSound = SoundFlierCrash;
        ramDamage = 0.65;
        ramDamageType = -1;
        mapFilter = 2;
        mapIcon = "M_vehicle";
        visibleToSensor = true;
        shadowDetailMask = 2;
        mountSound = SoundFlyerMount;
        dismountSound = SoundFlyerDismount;
        idleSound = SoundFlyerIdle;
        moveSound = SoundFlyerActive;
        visibleDriver = False;
        driverPose = 22;
        description = "3DFX Explorer";
};

FlierData Avenger
{
        explosionId = FlierExplosion;
        debrisId = FlierDebris2;
        className = "Vehicle";
   shapeFile = "flyer";
   shieldShapeName = "shield_medium";
   mass = 9.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 32;
   maxPitch = 32;
   maxSpeed = 60;
        maxSideSpeed = 20;
   minSpeed = -10;
        lift = 0.2;
        maxAlt = 600;
        maxVertical = 10;
        maxDamage = 3.0;
        damageLevel = {1.0, 1.0};
        maxEnergy = 40;
        accel = 0.5;

        groundDamageScale = 0.5;

        projectileType = AntiMatter;
        reloadDelay = 0.5;
        repairRate = 0;
        fireSound = ShockExplosion;
        damageSound = SoundTankCrash;
        ramDamage = 20;
        ramDamageType = -1;
        mapFilter = 2;
        mapIcon = "M_vehicle";
        visibleToSensor = true;
        shadowDetailMask = 2;

        mountSound = SoundFlyerMount;
        dismountSound = SoundFlyerDismount;
        idleSound = SoundFlyerIdle;
        moveSound = SoundFlyerActive;

        visibleDriver = true;
        driverPose = 22;
        description = "Assault Rammer";
};

FlierData LAPC
{
	explosionId = flashExpLarge;
	debrisId = flashDebrisLarge;
	className = "Vehicle";
   shapeFile = "hover_apc_sml";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 32;
   maxPitch = 32;
   maxSpeed = 45;
   minSpeed = -1;
	lift = 0.2;
	maxAlt = 3000;
	maxVertical = 10;
	maxDamage = 6;
	damageLevel = {1.0, 1.0};
	destroyDamage = 1.0;
	maxEnergy = 100;
	accel = 0.90;

	groundDamageScale = 0.50;

	repairRate = 0;
	ramDamage = 2;
	ramDamageType = -1;
	mapFilter = 2;
	mapIcon = "M_vehicle";
	reloadDelay = 3.0;
	damageSound = SoundTankCrash;
	visibleToSensor = true;
	shadowDetailMask = 2;

	mountSound = SoundFlyerMount;
	dismountSound = SoundFlyerDismount;
	idleSound = SoundFlyerIdle;
	moveSound = SoundFlyerActive;

	visibleDriver = true;
	driverPose = 23;
	description = "HighAlt.Assault Tank";
};

function LAPC::onFire(%this) 
{
	if(%this.lastFire > getSimTime()) return;
	%this.lastFire = getSimTime() + 3.0;
	playsound(SoundFireFlierRocket, GameBase::getPosition(%this));
	%rot = GameBase::getRotation(%this);
	%t = GameBase::getMuzzleTransform(%this); 	
	%vel = Item::getVelocity(%this); 
	for(%i = 0; %i < 9 ; %i++)
		%trans = %trans @ getword(%t, %i) @ " ";
	%pos = getword(%t, 9) @ " " @ getword(%t, 10) @ " " @ getword(%t, 11);
	%vec = Vector::getFromRot(%rot, 20);
	%newpos = Vector::add(%vec, %pos);
	%newtrans = %trans @ %newpos;
	Projectile::spawnProjectile("FlierRocket",%newtrans,%this,%vel);
	%newrot = (getword(%rot, 0) + 1.57) @ " " @ getword(%rot, 1) @ " " @ getword(%rot, 2);
	%vec = Vector::getFromRot(%newrot, 5);
	%newpos = Vector::add(%vec, %pos);
	%newtrans = %trans @ %newpos;
	Projectile::spawnProjectile("FlierRocket",%newtrans,%this,%vel);
	%newrot = (getword(%rot, 0) - 1.57) @ " " @ getword(%rot, 1) @ " " @ getword(%rot, 2);
	%vec = Vector::getFromRot(%newrot, 5);
	%newpos = Vector::add(%vec, %pos);
	%newtrans = %trans @ %newpos;
	Projectile::spawnProjectile("FlierRocket",%newtrans,%this,%vel);
	%newrot = getword(%rot, 0) @ " " @ getword(%rot, 1) @ " " @ (getword(%rot, 2) + 1.57);
	%vec = Vector::getFromRot(%newrot, 5);
	%newpos = Vector::add(%vec, %pos);
	%newtrans = %trans @ %newpos;
	Projectile::spawnProjectile("FlierRocket",%newtrans,%this,%vel);
	%newrot = getword(%rot, 0) @ " " @ getword(%rot, 1) @ " " @ (getword(%rot, 2) - 1.57);
	%vec = Vector::getFromRot(%newrot, 5);
	%newpos = Vector::add(%vec, %pos);
	%newtrans = %trans @ %newpos;
	Projectile::spawnProjectile("FlierRocket",%newtrans,%this,%vel);
}

FlierData HAPC
{
        explosionId = FlierExplosion;
        debrisId = FlierDebris3;
        className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.25;
   maxPitch = 0.175;
   maxSpeed = 25;
   minSpeed = -1;
        lift = 0.35;
        maxAlt = 1500;
        maxVertical = 6;
        maxDamage = 4.0;
        damageLevel = {1.0, 1.0};
        maxEnergy = 50;
        accel = 0.25;

        groundDamageScale = 0.125;

        repairRate = 0;
        ramDamage = 2;
        ramDamageType = -1;
        mapFilter = 2;
        mapIcon = "M_vehicle";
        fireSound = SoundFireFlierRocket;
        reloadDelay = 3.0;
        damageSound = SoundTankCrash;
        visibleToSensor = false;
        shadowDetailMask = 2;

        mountSound = SoundFlyerMount;
        dismountSound = SoundFlyerDismount;
        idleSound = SoundFlyerIdle;
        moveSound = SoundFlyerActive;

        visibleDriver = true;
        driverPose = 23;
};

FlierData HoverTank
{
        explosionId = FlierExplosion;
        debrisId = FlierDebris3;
        className = "Vehicle";
   shapeFile = "hover_apc";
   shieldShapeName = "shield_large";
   mass = 18.0;
   drag = 1.0;
   density = 1.2;
   maxBank = 0.9;
   maxPitch = 10;
   maxSpeed = 25;
   minSpeed = -1;
        lift = 0.75;
        maxAlt = 100;
        maxVertical = 0.001;
        maxDamage = 6.0;
        maxSideSpeed = 45;
        damageLevel = {1.0, 1.0};
        maxEnergy = 50;
        accel = 0.25;

        groundDamageScale = 0.001;

        repairRate = 0;
        ramDamage = 2;
        ramDamageType = -1;
        mapFilter = 2;
        mapIcon = "M_vehicle";
        projectileType = RPM;
        fireSound = SoundFireMortar;
        reloadDelay = 2;
        damageSound = SoundTankCrash;
        visibleToSensor = false;
        shadowDetailMask = 2;

        mountSound = SoundFlyerMount;
        dismountSound = SoundFlyerDismount;
        idleSound = SoundFlyerIdle;
        moveSound = SoundFlyerActive;

        visibleDriver = true;
        driverPose = 23;
};

//============================================================================
//Drones, Missiles and crap as such
//============================================================================

FlierData EOMissile
{
        explosionId = MortarExp;
        className = "Vehicle";
    shapeFile = "rocket";
    shieldShapeName = "shield_medium";
    mass = 0.1;
    drag = 1.0;
    density = 1.2;
    maxBank = 10.5;
    maxPitch = 11.15;
    maxSpeed = 65;
    minSpeed = 40;
        maxSideSpeed = 10;
        lift = 0.85;
        maxAlt = 200;
        maxVertical = 200;
        maxDamage = 0.001;
        damageLevel = {0.1, 0.1};
        maxEnergy = 30; // time in seconds until explodes
        accel = 2.0;

        groundDamageScale = 1.0;

        repairRate = 0;
        damageSound = ShockExplosion;
        ramDamage = 0.1;
        ramDamageType = $MortarDamageType;
        mapFilter = 2;
        mapIcon = "M_vehicle";
        visibleToSensor = true;
        shadowDetailMask = 2;

        mountSound = SoundFlyerMount;
        dismountSound = SoundFlyerDismount;
        idleSound = SoundJetHeavy;
        moveSound = SoundJetHeavy;

        visibleDriver = false;
        driverPose = 22;
        description = "Electro-Optical Missile";
};

function EOMissile::onAdd(%this)
{
        GameBase::setRechargeRate (%this,0);
        schedule("EOMissile::exhaustFuel("@%this@");",1,%this);
}

function EOMissile::onCollision(%this,%object)
{
        GameBase::applyDamage(%this,$MissileDamageType,10,GameBase::getPosition(%this),"0 0 0","0 0 0",%this);
        calcRadiusDamage(%this,$MortarDamageType, 20, 1.0, 250, 20, 20, 1.0, 1.0, 250, 250);
}

function EOMissile::jump(%this,%mom)
{
        GameBase::applyDamage(%this,$MissileDamageType,10,GameBase::getPosition(%this),"0 0 0",%mom,%this);
}

function EOMissile::onDestroyed (%this,%mom)
{
   %cl = GameBase::getControlClient(%this);

  %pl = Client::getOwnedObject(%cl);
   if(%pl != -1)
   {
    Player::setMountObject(%pl, -1, 0);
           Client::setControlObject(%cl, %pl);
        if(%pl.lastWeapon != "")
        {
                Player::useItem(%pl,%pl.lastWeapon);
                %pl.lastWeapon = "";
        }
        %pl.driver = "";
        %pl.vehicle= "";
   }
   calcRadiusDamage(%this,$MortarDamageType, 20, 1.0, 250, 20, 20, 1.0, 1.0, 250, 250);
}

function EOMissile::exhaustFuel(%this)
{
  %fuel = GameBase::getEnergy(%this);
  if(%fuel < 1){
        GameBase::applyDamage(%this,$MissileDamageType,10,GameBase::getPosition(%this),"0 0 0","0 0 0",%this);
        calcRadiusDamage(%this,$MortarDamageType, 20, 1.0, 250, 20, 20, 1.0, 1.0, 250, 250);
  }
  else
  {
   GameBase::setEnergy(%this,%fuel - 1);
   schedule("EOMissile::exhaustFuel("@%this@");",1,%this);
  }
}

function ScouterMissile::onAdd(%this)
{
        GameBase::setRechargeRate (%this,0);
         schedule("ScouterMissile::exhaustFuel("@%this@");",1,%this);
}

function ScouterMissile::onCollision(%this,%object)
{
         GameBase::applyDamage(%this,$MissileDamageType,10,GameBase::getPosition(%this),"0 0 0","0 0 0",%this);
}

function ScouterMissile::jump(%this,%mom)
{
        GameBase::applyDamage(%this,$MissileDamageType,10,GameBase::getPosition(%this),"0 0 0",%mom,%this);
}

function ScouterMissile::onDestroyed (%this,%mom)
{
   %cl = GameBase::getControlClient(%this);
   %pl = Client::getOwnedObject(%cl);
   if(%pl != -1)
   {
    Player::setMountObject(%pl, -1, 0);
           Client::setControlObject(%cl, %pl);
        if(%pl.lastWeapon != "")
        {
                Player::useItem(%pl,%pl.lastWeapon);
                %pl.lastWeapon = "";
        }
        %pl.driver = "";
        %pl.vehicle= "";
   }
}

function ScouterMissile::exhaustFuel(%this)
{
  %fuel = GameBase::getEnergy(%this);
  if(%fuel < 1){
        GameBase::applyDamage(%this,$ImpactDamageType,10,GameBase::getPosition(%this),"0 0 0","0 0 0",%this);
  }
  else
  {
   GameBase::setEnergy(%this,%fuel - 1);
   schedule("ScouterMissile::exhaustFuel("@%this@");",1,%this);
  }
}

//===========================================================================
//Now here is the codez!
//===========================================================================

$DamageScale[EOMissile, $ImpactDamageType] = 1.0;
$DamageScale[EOMissile, $BulletDamageType] = 1.0;
$DamageScale[EOMissile, $PlasmaDamageType] = 1.0;
$DamageScale[EOMissile, $EnergyDamageType] = 1.0;
$DamageScale[EOMissile, $ExplosionDamageType] = 1.0;
$DamageScale[EOMissile, $ShrapnelDamageType] = 1.0;
$DamageScale[EOMissile, $DebrisDamageType] = 1.0;
$DamageScale[EOMissile, $MissileDamageType] = 1.0;
$DamageScale[EOMissile, $LaserDamageType] = 0.5;
$DamageScale[EOMissile, $MortarDamageType] = 1.0;
$DamageScale[EOMissile, $BlasterDamageType] = 0.5;
$DamageScale[EOMissile, $ElectricityDamageType] = 1.0;
$DamageScale[EOMissile, $MineDamageType]        = 1.0;

function ShortCoolProj::onFire(%this) { GameBase::setDamageLevel(%this, 10); }

$DamageScale[LAPC, $ImpactDamageType] = 1.0;
$DamageScale[LAPC, $BulletDamageType] = 1.0;
$DamageScale[LAPC, $PlasmaDamageType] = 1.0;
$DamageScale[LAPC, $EnergyDamageType] = 1.0;
$DamageScale[LAPC, $ExplosionDamageType] = 1.0;
$DamageScale[LAPC, $ShrapnelDamageType] = 1.0;
$DamageScale[LAPC, $DebrisDamageType] = 1.0;
$DamageScale[LAPC, $MissileDamageType] = 1.0;
$DamageScale[LAPC, $LaserDamageType] = 0.5;
$DamageScale[LAPC, $MortarDamageType] = 1.0;
$DamageScale[LAPC, $BlasterDamageType] = 0.5;
$DamageScale[LAPC, $ElectricityDamageType] = 1.0;
$DamageScale[LAPC, $MineDamageType]        = 1.0;

$DamageScale[HAPC, $ImpactDamageType] = 1.0;
$DamageScale[HAPC, $BulletDamageType] = 1.0;
$DamageScale[HAPC, $PlasmaDamageType] = 1.0;
$DamageScale[HAPC, $EnergyDamageType] = 1.0;
$DamageScale[HAPC, $ExplosionDamageType] = 1.0;
$DamageScale[HAPC, $ShrapnelDamageType] = 1.0;
$DamageScale[HAPC, $DebrisDamageType] = 1.0;
$DamageScale[HAPC, $MissileDamageType] = 1.0;
$DamageScale[HAPC, $LaserDamageType] = 0.5;
$DamageScale[HAPC, $MortarDamageType] = 1.0;
$DamageScale[HAPC, $BlasterDamageType] = 0.5;
$DamageScale[HAPC, $ElectricityDamageType] = 1.0;
$DamageScale[HAPC, $MineDamageType]        = 1.0;

$DamageScale[Explorer, $ImpactDamageType] = 1.0;
$DamageScale[Explorer, $BulletDamageType] = 1.0;
$DamageScale[Explorer, $PlasmaDamageType] = 1.0;
$DamageScale[Explorer, $EnergyDamageType] = 1.0;
$DamageScale[Explorer, $ExplosionDamageType] = 1.0;
$DamageScale[Explorer, $ShrapnelDamageType] = 1.0;
$DamageScale[Explorer, $DebrisDamageType] = 1.0;
$DamageScale[Explorer, $MissileDamageType] = 1.0;
$DamageScale[Explorer, $LaserDamageType] = 0.5;
$DamageScale[Explorer, $MortarDamageType] = 1.0;
$DamageScale[Explorer, $BlasterDamageType] = 0.5;
$DamageScale[Explorer, $ElectricityDamageType] = 1.0;
$DamageScale[Explorer, $MineDamageType]        = 1.0;

$DamageScale[HoverTank, $ImpactDamageType] = 1.0;
$DamageScale[HoverTank, $BulletDamageType] = 1.0;
$DamageScale[HoverTank, $PlasmaDamageType] = 1.0;
$DamageScale[HoverTank, $EnergyDamageType] = 1.0;
$DamageScale[HoverTank, $ExplosionDamageType] = 1.0;
$DamageScale[HoverTank, $ShrapnelDamageType] = 1.0;
$DamageScale[HoverTank, $DebrisDamageType] = 1.0;
$DamageScale[HoverTank, $MissileDamageType] = 1.0;
$DamageScale[HoverTank, $LaserDamageType] = 0.5;
$DamageScale[HoverTank, $MortarDamageType] = 1.0;
$DamageScale[HoverTank, $BlasterDamageType] = 0.5;
$DamageScale[HoverTank, $ElectricityDamageType] = 1.0;
$DamageScale[HoverTank, $MineDamageType]        = 1.0;

function keepers(%this) {
        %cl = GameBase::getControlClient(%this);
        %pl = Client::getOwnedObject(%cl);
        %cl.safet = false;
        remoteEval(%cl, SetControls);
        if(%pl != -1) {
                doneposs(%cl);
                Client::setControlObject(%cl, %pl);
        }
}

//----------------------------------------------------------------------------

function Vehicle::onAdd(%this)
{
        %this.isMarked=false;
        GameBase::setRechargeRate (%this, 0);
        GameBase::setMapName (%this, "Vehicle");
        %data = GameBase::getDataName(%this);
        if(%data.shapefile == "rocket") {
                if (%data == ShortCoolProj) {
                        schedule("keepers("@%this@");",10,%this);
                        schedule("GameBase::setDamageLevel("@%this@", "@%data.maxDamage@");",10.5,%this);
                        }
        }
         if(GameBase::getDataName(%this) == Scout)
        {        GameBase::setMapName (%this, "Scout");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == LAPC)
        {        GameBase::setMapName (%this, "LPC");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == HAPC)
        {        GameBase::setMapName (%this, "HPC");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == HoverTank)
        {        GameBase::setMapName (%this, "Hover Tank");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == StarHammer)
        {        GameBase::setMapName (%this, "Star Hammer");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == Arwing)
        {        GameBase::setMapName (%this, "Arwing");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == SkyCutter)
        {        GameBase::setMapName (%this, "Sky Cutter");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
         if(GameBase::getDataName(%this) == EscapePod)
        {        GameBase::setMapName (%this, "Lightning");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == Icarus)
        {        GameBase::setMapName (%this, "Annihilator");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == Skyranger)
        {        GameBase::setMapName (%this, "Skyranger");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == StarFighter)
        {        GameBase::setMapName (%this, "StarFighter");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == Avenger)
        {        GameBase::setMapName (%this, "ThunderTank");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == Explorer)
        {        GameBase::setMapName (%this, "3DFX Explorer");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }
        else if(GameBase::getDataName(%this) == Jetfire)
        {        GameBase::setMapName (%this, "Human Flier");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 8);
        }
        else if(GameBase::getDataName(%this) == Interceptor)
        {        GameBase::setMapName (%this, "Valkyrie Interceptor");
                %this.shieldStrength = 0;
                GameBase::setRechargeRate (%this, 0);
        }

}

function Vehicle::onCollision (%this, %object)
{
        %data = GameBase::getDataName(%this);
        if(%data.shapefile == "remoteturret") return;
        if(%data.shapefile == "rocket" || (%data.shapefile == "discb" && getObjectType(%object) == "Player")) {
                GameBase::setDamageLevel(%this, 99);
                return;
        }

        if(%object.driver != "") return;

        if(GameBase::getDamageLevel(%this) < (GameBase::getDataName(%this)).maxDamage) {
                if (getObjectType (%object) == "Player" && %object.vehicle == "" && (getSimTime() > %object.newMountTime || %object.lastMount != %this) && %this.fading == "")
                        {
                        %armor = Player::getArmor(%object);
                      %client = Player::getClient(%object);
//                                if ((%armor == "larmor" || %armor == "lfemale" || %armor == "BlastechM" || %armor == "BlastechF || %armor == "MagIonM" || %armor == "MagIonF || %armor == "marmor" || %armor == "mfemale") && Vehicle::canMount (%this, %object))
                                if ((%armor == "larmor" || %armor == "lfemale" || %armor == "marmor" || %armor == "mfemale" || %armor == "BlastechM" || %armor == "BlastechF" || %armor == "MagIonM" || %armor == "MagIonF") && Vehicle::canMount (%this, %object))
                                        {
                                        if (!Player::isAiControlled(%object))  //No bots allowed as drivers!! Only as passengers!
                                                {
                                                %weapon = Player::getMountedItem(%object,$WeaponSlot);
                                                if(%weapon != -1) {
                                                        %object.lastWeapon = %weapon;
                                                        Player::unMountItem(%object,$WeaponSlot);
                                                        }
                                                        if(%data == Explorer) {
                                                        if(Player::getMountedItem(%object,$FlagSlot) != "flag")
                                                                GameBase::startFadeout(%this);
                                                }
                                                Player::setMountObject(%object, %this, 1);
                                                doneposs(%client);
                                                %client.safet = false;
                                                Client::setControlObject(%client, %this);
                                                playSound (GameBase::getDataName(%this).mountSound, GameBase::getPosition(%this));
                                                %object.driver= 1;
                                                %object.vehicle = %this;
                                                %this.clLastMount = %client;
                                                }
                                        }

					    else if(GameBase::getDataName(%this) != SuperX) 
                                        {
                                                 %mountSlot= Vehicle::findEmptySeat(%this,%client);
                                                if(%mountSlot)
                                                        {
                                                                %object.vehicleSlot = %mountSlot;
                                                                %object.vehicle = %this;
                                                                Player::setMountObject(%object, %this, %mountSlot);
                                                                playSound (GameBase::getDataName(%this).mountSound, GameBase::getPosition(%this));
                                                        }
                                        }
                                else if (GameBase::getControlClient(%this) == -1){
                                        Client::sendMessage(Player::getClient(%object),0,"You must be in Light or Blastech armor to pilot the vehicles.~wError_Message.wav");
                                        return;
                                }
                        }
        }
}

function Vehicle::findEmptySeat(%this,%client)
{
	%name = GameBase::getDataName(%this);
	if(%name == HAPC || %name == HoverTank){
                %numSlots = 4;} 
	else if(%name == LAPC){
                %numSlots = 2;}
	else if(%name == Explorer){
                %numSlots = 1;}
	else if(%name == EOMissile || %name == ScouterMissile){
                %numSlots = 0;}
        %count=0;
        for(%i=0;%i<%numSlots;%i++)
                if(%this.Seat[%i] == "") {
                        %slotPos[%count] = Vehicle::getMountPoint(%this,%i+2);
                        %slotVal[%count] = %i+2;
                        %lastEmpty = %i+2;
                        %count++;
                }
        if(%count == 1) {
                %this.Seat[%lastEmpty-2] = %client;
                return %lastEmpty;
        }
        else if (%count > 1)        {
                %freeSlot = %slotVal[getClosestPosition(%count,GameBase::getPosition(%client),%slotPos[0],%slotPos[1],%slotPos[2],%slotPos[3])];
                %this.Seat[%freeSlot-2] = %client;
                return %freeSlot;
        }
        else
                return "False";
}

function getClosestPosition(%num,%playerPos,%slotPos0,%slotPos1,%slotPos2,%slotPos3)
{
        %playerX = getWord(%playerPos,0);
        %playerY = getWord(%playerPos,1);
        for(%i = 0 ;%i<%num;%i++) {
                %x = (getWord(%slotPos[%i],0)) - %playerX;
                %y = (getWord(%slotPos[%i],1)) - %playerY;
                if(%x < 0)
                        %x *= -1;
                if(%y < 0)
                        %y *= -1;
                %newDistance = sqrt((%x*%x)+(%y*%y));
                if(%newDistance < %distance || %distance == "") {
                          %distance = %newDistance;
                        %closePos = %i;
                }
        }
        return %closePos;
}

function Vehicle::passengerJump(%this,%passenger,%mom)
{
        %armor = Player::getArmor(%passenger);
        if(%armor == "larmor" || %armor == "lfemale" || %armor == "BlastechM" || %armor == "BlastechF") {
                %height = 2;
                %velocity = 70;
                %zVec = 70;
        }
        else if(%armor == "marmor" || %armor == "mfemale" || %armor == "MagIonM" || %armor == "MagIonF") {
                %height = 2;
                %velocity = 100;
                %zVec = 100;
        }
        else if(%armor == "harmor"|| %armor == "MECH") {
                %height = 2;
                %velocity = 140;
                %zVec = 110;
        }

        %pos = GameBase::getPosition(%passenger);
        %posX = getWord(%pos,0);
        %posY        = getWord(%pos,1);
        %posZ        = getWord(%pos,2);

        if(GameBase::testPosition(%passenger,%posX @ " " @ %posY @ " " @ (%posZ + %height))) {
                %client = Player::getClient(%passenger);
                %this.Seat[%passenger.vehicleSlot-2] = "";
                %passenger.vehicleSlot = "";
           %passenger.vehicle= "";
                Player::setMountObject(%passenger, -1, 0);
                %rotZ = getWord(GameBase::getRotation(%passenger),2);
                GameBase::setRotation(%passenger, "0 0 " @ %rotZ);
                GameBase::setPosition(%passenger,%posX @ " " @ %posY @ " " @ (%posZ + %height));
                %jumpDir = Vector::getFromRot(GameBase::getRotation(%passenger),%velocity,%zVec);
                Player::applyImpulse(%passenger,%jumpDir);
        }
        else
                Client::sendMessage(Player::getClient(%passanger),0,"Can not dismount - Obstacle in the way.~wError_Message.wav");
}

function Vehicle::BlowUp(%this)
{
		%time = GameBase::getEnergy(%this);
		if(%time < 8) GameBase::applyDamage(%this,$EnergyDamageType,10,GameBase::getPosition(%this),"0 0 0","0 0 0",%this);
  		else 
  		{
   			GameBase::setEnergy(%this,%time - 1);
   			schedule("Vehicle::BlowUp("@%this@");",0.1,%this);
  		}
}

function Vehicle::jump(%this,%mom)
{
   Vehicle::dismount(%this,%mom);
}

function Vehicle::dismount(%this,%mom)
{
   %cl = GameBase::getControlClient(%this);
   if(%cl != -1)
   {
        if(GameBase::getDataName(%this) == "Jetfire")
        {
                Jetfire::Dismount(%this, %cl);
                return;
        }
      %pl = Client::getOwnedObject(%cl);
      if(getObjectType(%pl) == "Player")
      {
                   // dismount the player
                        if(GameBase::testPosition(%pl, Vehicle::getMountPoint(%this,0))) {
                                %pl.lastMount = %this;
                                %pl.newMountTime = getSimTime() + 3.0;
                                Player::setMountObject(%pl, %this, 0);
                         Player::setMountObject(%pl, -1, 0);
                                %rot = GameBase::getRotation(%this);
                                %rotZ = getWord(%rot,2);
                                GameBase::setRotation(%pl, "0 0 " @ %rotZ);
                                Player::applyImpulse(%pl,%mom);
                         Client::setControlObject(%cl, %pl);
                                playSound (GameBase::getDataName(%this).dismountSound, GameBase::getPosition(%this));
                                if(%pl.lastWeapon != "") {
                                        Player::useItem(%pl,%pl.lastWeapon);
                                        %pl.lastWeapon = "";
                                                if(GameBase::getDataName(%this) == Explorer)
                                                {
                                                        GameBase::startFadein(%this);
                                                }
                                                if(%data == Test) 
								{
									$DrivingLV[%client] = false;
                                                }

                      }
                                %pl.driver = "";
                                %pl.vehicle = "";
                        }
                        else
                                Client::sendMessage(%cl,0,"Can not dismount - Obstacle in the way.~wError_Message.wav");
                }
   }
}

function Vehicle::onDestroyed (%this,%mom) {

$TeamItemCount[GameBase::getTeam(%this) @ $VehicleToItem[GameBase::getDataName(%this)]]--;
%cl = GameBase::getControlClient(%this);
%pl = Client::getOwnedObject(%cl);

Client::setOwnedObject(%cl, %this);
Client::setOwnedObject(%cl, %pl);

%name = GameBase::getDataName(%this);
if(%name == ShortCoolProj || %name == SurveyDrone || %name == EOMissile || %name == ScouterMissile)
{
}
else
{
	remotekill(%cl);
}

%data = GameBase::getDataName(%this);
%cl.safet = false;

%meo = (%data.shapefile == "camera" || %data.shapefile == "discb");

if(%data.shapefile == "rocket" || %meo) {
        doneposs(%cl);
        Client::setControlObject(%cl, %pl);
        if (%data == EOMissile) {
                GameBase::applyRadiusDamage($MortarDamageType, getBoxCenter(%this), 80, 1.0, 175, %cl);
        } else if (%data == ShortCoolProj) {
                GameBase::applyRadiusDamage($ExplosionDamageType, getBoxCenter(%this), 23, 0.4, 305, %cl);
                GameBase::applyRadiusDamage($MissileDamageType, getBoxCenter(%this), 35.0, 0.65, 0, %cl);
        } 
        if(%pl != -1) {
                Player::setMountObject(%pl, -1, 0);
                doneposs(%cl);
                Client::setControlObject(%cl, %pl);
                if(%pl.lastWeapon != "") {
                        Player::useItem(%pl,%pl.lastWeapon);
                        %pl.lastWeapon = "";
                }
                %pl.driver = "";
        }
        for(%i = 0 ; %i < 4 ; %i++)
                if(%this.Seat[%i] != "") {
                        %pl = Client::getOwnedObject(%this.Seat[%i]);
                        Player::setMountObject(%pl, -1, 0);
                        doneposs(%this.Seat[%i]);
                        Client::setControlObject(%this.Seat[%i], %pl);
                }
        calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.55, 0.1, 225, 100);
}
}

function Vehicle::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
        %value *= $damageScale[GameBase::getDataName(%this), %type];
        StaticShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object);
        if(%type == $EMPDamageType) {
                Vehicle::BlowUp(%this); 
        }
}

function Vehicle::getHeatFactor(%this)
{
        // Not getting called right now because turrets don't track
        // vehicles.  A hack has been placed in Player::getHeatFactor.
   return 1.0;
}

function Vehicle::getHeat(%this) { return 1.0; }

function checkEm(%cl, %pl, %obj) {
        if(Client::getControlObject(%cl) == %obj && Client::getOwnedObject(%cl) != -1) {
                Client::setControlObject(%cl, Client::getOwnedObject(%cl));
                doneposs(%cl);
        }
        %cl.booyah = false;
}

function StartGroundMode(%vehicle, %clientId, %changeZRot, %changeYRot)
{
	// Global var. True if driving vehicle. False if not. 
	if($DrivingLV[%clientId] != false)  
	{
		%refX1 = "-0.393 0 0";
		%refX2 = "-0.393 0 1.571";
		%refX3 = "-0.786 0 0";
		%refX4 = "-0.786 0 1.571";
		
		%refY1 = "-0.393 0 0.786";
		%refY2 = "-0.393 0 -0.786";
		%refY3 = "-0.786 0 0.786";
		%refY4 = "-0.786 0 -0.786";
		
		%refHeight = "-1.575 0 0";

		//Temp set Rotations
		%OldRot = GameBase::getRotation(%vehicle);
		%NewXRot = getword(%OldRot, 0);
		%NewYRot = getword(%OldRot, 1);
		%changeInZ = %changeYRot - %NewYRot;
		%changeInZ = %changeInZ * 2;
		echo(%changeInZ);
		%NewZRot = %changeZRot + %changeInZ;
		

	// Front Middle Position
		//----------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refX1))
			%frontMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refX3))
				%frontMiddlePos = $los::position;
			else
				%frontMiddlePos = "0 0 0";
		
		// Rear Middle Position
		//-----------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refX2))
			%rearMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refX4))
				%rearMiddlePos = $los::position;
			else
				%rearMiddlePos = "0 0 0";

		// Left Middle Position
		//------------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refY1))
			%leftMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refY3))
				%leftMiddlePos = $los::position;
			else
				%leftMiddlePos = "0 0 0";

		// Right Middle Position
		//------------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refY2))
			%rightMiddlePos = $los::position;
		else
			if(GameBase::getLOSInfo(%vehicle,1000,%refY4))
				%rightMiddlePos = $los::position;
			else
				%rightMiddlePos = "0 0 0";

		//-------------------
		// X Rotation Stuff
		//-------------------
		// Rear Position
		%rMidX = getword(%rearMiddlePos, 0);
		%rMidY = getword(%rearMiddlePos, 1);
		%rMidZ = getword(%rearMiddlePos, 2);
		// Front Position
		%fMidX = getword(%frontMiddlePos , 0);
		%fMidY = getword(%frontMiddlePos , 1);
		%fMidZ = getword(%frontMiddlePos , 2);
		// X Distance
		%rpos = %rMidX@" "@%rMidY@" 0";
		%fpos = %fMidX@" "@%fMidY@" 0";
		// Total Distance
		%totDist = Vector::getDistance(%rpos, %fpos);
		%zDistance = %fMidZ - %rMidZ;
		if(%totDist != 0)
			if( %zDistance != 0 )
			{
				%OppAdd = %zDistance/%totDist;
				%NewXRot = inverseTan(%OppAdd);
			}

		//-------------------
		// Y Rotation Stuff
		//-------------------
		// Right Side Position
		%rsMidX = getword(%rightMiddlePos, 0);
		%rsMidY = getword(%rightMiddlePos, 1);
		%rsMidZ = getword(%rightMiddlePos, 2);
		// Left Side Position
		%lsMidX = getword(%leftMiddlePos , 0);
		%lsMidY = getword(%leftMiddlePos , 1);
		%lsMidZ = getword(%leftMiddlePos , 2);
		// Y Distance
		%rsPos = %rsMidX@" "@%rsMidY@" 0";
		%lsPos = %lsMidX@" "@%lsMidY@" 0";
		// Total Distance
		%totDist = Vector::getDistance(%rsPos, %lsPos);
		%zDistance = %lsMidZ - %rsMidZ;
		if(%totDist != 0)
			if( %zDistance != 0 )
			{
				%OppAdd = %zDistance/%totDist;
				%NewYRot = inverseTan(%OppAdd);
			}

		//-------------------
		// Height Stuff
		//-------------------
		if(GameBase::getLOSInfo(%vehicle,20,%refHeight))
		{
			%groundPos = $los::position;
			%vehiclePos = GameBase::getPosition(%vehicle);
			%vehicleX = getword(%vehiclePos, 0);
			%vehicleY = getword(%vehiclePos, 1);
			%vehicleZ = getword(%vehiclePos, 2);
			%groundz = getword(%groundPos, 2);
			%height = %vehicleZ - %groundZ;
			if(%height >= 2.49 || %height <= 2.51)
			{
				%newpos = %vehicleX @ " " @ %vehicleY @ " " @ (%groundZ + 2.5);
				GameBase::setPosition(%vehicle,%newpos);
			}
		}

		//-------------------
		// Set Rotation Stuff
		//-------------------
		// New Rotation
		%NewRot = %NewXRot@" "@%NewYRot@" "@%NewZRot;
		GameBase::setRotation(%vehicle,%NewRot);

		schedule("StartGroundMode("@%vehicle@","@%clientId@","@%NewZRot@","@%NewYRot@");",0.05, %vehicle);
	}
}

function inverseTan(%x)
{
	%theta = %x - ((%x*%x*%x)/3) + ((%x*%x*%x*%x*%x)/5) - ((%x*%x*%x*%x*%x*%x*%x)/7);
	return %theta;
}

#End