# ptrPack -> ptrFlag functions

function Player::hasFlag(%player)
{
	%flag = Player::getMountedItem(%player, $FlagSlot);
	$theFlag = %flag;

	if(%flag == Flag)	
		return true;
	else 
		return false;
}

function FindFlag(%pos,%xdist,%ydist,%zdist)
{
 	%set = newObject("set",SimSet);
	%num = containerBoxFillSet(%set,$StaticObjectType,%pos,%xDist,%yDist,%zDist,0);
	%flag = CountObjects(%set,"FlagStand",%num);

	deleteObject(%set);

	if(%flag)
		return true;
	else
		FindActualFlag(%pos,%xdist,%ydist,%zdist);
}

function findActualFlag(%pos,%xdist,%ydist,%zdist)
{
 	%set = newObject("set",SimSet);
	%num = containerBoxFillSet(%set,$ItemObjectType,%pos,%xDist,%yDist,%zDist,0);
	%flag = CountObjects(%set,"Flag",%num);

	deleteObject(%set);

	if(%flag)
		return true;
	else 
		return false;
}

//----------------------------------------------------------------------------
ItemImageData EnergyPackImage
{
	shapeFile = "jetPack";
	weaponType = 2;  // Sustained

	mountPoint = 2;
	mountOffset = { 0, -0.1, 0 };

	minEnergy = -1;
 	maxEnergy = -8;
	firstPerson = false;
};

ItemData EnergyPack
{
	description = "Energy Pack";
	shapeFile = "jetPack";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = EnergyPackImage;
	price = 150;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function EnergyPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
}

function EnergyPack::onMount(%player,%item)
{
	Player::trigger(%player,$BackpackSlot,true);
}
//===========================

$InvList[Reactor] = 1;
$RemoteInvList[Reactor] = 0;

$ItemMax[harmor, Reactor] = 0;
$ItemMax[marmor, Reactor] = 0;
$ItemMax[mfemale, Reactor] = 0;
$ItemMax[larmor, Reactor] = 0;
$ItemMax[lfemale, Reactor] = 0;
$ItemMax[BlastechF, Reactor] = 1;
$ItemMax[BlastechM, Reactor] = 1;
$ItemMax[MagIonM, Reactor] = 0;
$ItemMax[MagIonF, Reactor] = 0;
$ItemMax[MECH, Reactor] = 0;

ItemImageData ReactorImage
{
	shapeFile = "shieldPack";
	weaponType = 2;  // Sustained

	mountPoint = 2;
	mountOffset = { 0, 0, -0.3 };
	mountRotation = { 0, 0, 1.57 };

	minEnergy = -10;
 	maxEnergy = -20;
	firstPerson = false;
};

ItemData Reactor
{
	description = "Mini-Reactor";
	shapeFile = "shieldPack";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = ReactorImage;
	price = 1200;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function Reactor::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
}

function Reactor::onMount(%player,%item)
{
	Player::trigger(%player,$BackpackSlot,true);
}
//===========================

$InvList[Accelerator] = 1;
$RemoteInvList[Accelerator] = 0;

$ItemMax[harmor, Accelerator] = 0;
$ItemMax[marmor, Accelerator] = 1;
$ItemMax[mfemale, Accelerator] = 1;
$ItemMax[larmor, Accelerator] = 0;
$ItemMax[lfemale, Accelerator] = 0;
$ItemMax[BlastechF, Accelerator] = 1;
$ItemMax[BlastechM, Accelerator] = 1;
$ItemMax[MagIonM, Accelerator] = 1;
$ItemMax[MagIonF, Accelerator] = 1;
$ItemMax[MECH, Accelerator] = 0;

ItemImageData AcceleratorImage
{
	shapeFile = "mortarpack";
	weaponType = 2;  // Sustained

	mountPoint = 2;
	mountOffset = { 0, -0.1, 0 };

	minEnergy = -3;
 	maxEnergy = -12;
	firstPerson = false;
};

ItemData Accelerator
{
	description = "Particle Accelerator";
	shapeFile = "mortarpack";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = AcceleratorImage;
	price = 450;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function Accelerator::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
}

function Accelerator::onMount(%player,%item)
{
	Player::trigger(%player,$BackpackSlot,true);
}

function Accelerator::onUnmount(%player,%item)
{
	if (Player::getMountedItem(%player,$WeaponSlot) == PBW) 
		Player::unmountItem(%player,$WeaponSlot);
}

//----------------------------------------------------------------------------

$InvList[MitziCharger] = 1;
$RemoteInvList[MitziCharger] = 1;

$ItemMax[harmor, MitziCharger] = 1;
$ItemMax[marmor, MitziCharger] = 1;
$ItemMax[mfemale, MitziCharger] = 1;
$ItemMax[larmor, MitziCharger] = 1;
$ItemMax[lfemale, MitziCharger] = 1;
$ItemMax[BlastechF, MitziCharger] = 1;
$ItemMax[BlastechM, MitziCharger] = 1;
$ItemMax[MagIonM, MitziCharger] = 1;
$ItemMax[MagIonF, MitziCharger] = 1;
$ItemMax[MECH, MitziCharger] = 1;

ItemImageData MitziChargerImage
{
	shapeFile = "mineammo";
	weaponType = 2;  // Sustained

	mountPoint = 2;
        mountOffset = { 0, 0, 0.1 };
        mountRotation = { 1.57, 0, 0 };
	minEnergy = -1;
 	maxEnergy = -1;
	firstPerson = false;
};

ItemData MitziCharger
{
	description = "Mitzi Charger";
	shapeFile = "mineammo";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = MitziChargerImage;
	price = 1000;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

//----------------------------------------------------------------------------

$InvList[GravFieldPack] = 1;
$RemoteInvList[GravFieldPack] = 1;

$ItemMax[harmor, GravFieldPack] = 0;
$ItemMax[marmor, GravFieldPack] = 0;
$ItemMax[mfemale, GravFieldPack] = 0;
$ItemMax[larmor, GravFieldPack] = 0;
$ItemMax[lfemale, GravFieldPack] = 0;
$ItemMax[BlastechF, GravFieldPack] = 0;
$ItemMax[BlastechM, GravFieldPack] = 0;
$ItemMax[MagIonM, GravFieldPack] = 1;
$ItemMax[MagIonF, GravFieldPack] = 1;
$ItemMax[MECH, GravFieldPack] = 0;

ItemImageData GravFieldPackI
{
	shapeFile = "mortarammo";
	weaponType = 2;  // Sustained

	mountPoint = 2;
	mountOffset = { 0, 0, 0.0 };
	mass = -8;
	minEnergy = -1;
 	maxEnergy = -1;
	firstPerson = false;
};

ItemData GravFieldPack
{
	description = "Gravitron Field Pack";
	shapeFile = "mortarammo";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = GravFieldPackI;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

//----------------------------------------------------------------------------

ItemImageData RepairPackImage
{
	shapeFile = "armorPack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
   minEnergy = 0;
	maxEnergy = 0;   // Energy used/sec for sustained weapons
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData RepairPack
{
	description = "Repair Pack";
	shapeFile = "armorPack";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = RepairPackImage;
	price = 125;
	hudIcon = "repairpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function RepairPack::onUnmount(%player,%item)
{
	if (Player::getMountedItem(%player,$WeaponSlot) == RepairGun) {
		Player::unmountItem(%player,$WeaponSlot);
	}
}

function RepairPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::mountItem(%player,RepairGun,$WeaponSlot);
	}
}

function RepairPack::onDrop(%player,%item)
{
	if($matchStarted) {
		%mounted = Player::getMountedItem(%player,$WeaponSlot);
		if (%mounted == RepairGun) {
			Player::unmountItem(%player,$WeaponSlot);
		}
		else {
			// Remount the existing weapon to make sure the RepairGun
			// is not on the delayed mount "stack".
			Player::mountItem(%player,%mounted,$WeaponSlot);
		}
		Item::onDrop(%player,%item);
	}
}	

//*************************************
// AAOD Mod BACKPACK Kit
//*************************************
//----------------------------------------------------------------------------
// ====================================
//		**** SuperRepair Pack ****
// ++++++++++++++++++++++++++++++++++++

$InvList[AODSuperRPack]			= 1;
$RemoteInvList[AODSuperRPack]		= 1;

$ItemMax[larmor, AODSuperRPack] = 0;
$ItemMax[lfemale, AODSuperRPack] = 0;
$ItemMax[marmor, AODSuperRPack] = 1;
$ItemMax[mfemale, AODSuperRPack] = 1;
$ItemMax[harmor, AODSuperRPack] = 1;
$ItemMax[BlastechF, AODSuperRPack] = 0;
$ItemMax[BlastechM, AODSuperRPack] = 0;
$ItemMax[MagIonM, AODSuperRPack] = 0;
$ItemMax[MagIonF, AODSuperRPack] = 0;
$ItemMax[MECH, AODSuperRPack] = 0;

RepairEffectData SuperRBolt
{	bitmapName			= "LightningNew.bmp";
	boltLength			= 200.0;
	segmentDivisions	= 6;
	beamWidth			= 0.175;
	updateTime			= 450;
	skipPercent			= 0.6;
	displaceBias		= 0.15;
	lightRange			= 6.0;
	lightColor			= { 0.85, 0.25, 0.25 };
};

ItemImageData SuperRPackImage
{	
	shapeFile		= "armorPack";
	mountPoint		= 2;
	weaponType		= 2;  // Sustained
	minEnergy		= 0;
	maxEnergy		= 0;   // Energy used/sec for sustained weapons
  	mountOffset		= { 0, -0.05, 0 };
  	mountRotation	= { 0, 0, 0 };
	firstPerson		= false;
};

ItemData AODSuperRPack
{	description		= "Super-Repair Pack";
	shapeFile		= "armorPack";
	className		= "Backpack";
	heading			= "kBackpacks";
	shadowDetailMask = 4;
	imageType		= SuperRPackImage;
	price			= 750;
	hudIcon			= "repairpack";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

ItemImageData SuperR2Image
{	shapeFile		= "armorPack";
	mountPoint		= 2;
	weaponType		= 2;  // Sustained
	minEnergy		= 0;
	maxEnergy		= 0;   // Energy used/sec for sustained weapons
  	mountOffset		= { 0, -0.05, -0.10 };
  	mountRotation	= { 0, 3.14159, -0.015 };
	firstPerson		= false;
};

ItemData SuperR2Pack
{	description		= "Super-Repair Pack";
	shapeFile		= "armorPack";
	className		= "Backpack";
	heading			= "eBackpacks";
	shadowDetailMask = 4;
	imageType		= SuperR2Image;
	hudIcon			= "repairpack";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

ItemImageData SuperRGunImage
{	shapeFile		= "repairgun";
	mountPoint		= 0;
	mountOffset		= { -0.15, 0, 0 };
	mountRotation	= { 0, 1.57, 0};
	weaponType		= 2;	// Sustained
	projectileType	= SuperRBolt;
	minEnergy		= 1;
	maxEnergy		= 7;	// Energy used/sec for sustained weapons
	lightType		= 3;	// Weapon Fire
	lightRadius		= 1;
	lightTime		= 1;
	lightColor		= { 0.25, 1, 0.25 };
	sfxActivate		= SoundPickUpWeapon;
	sfxFire			= SoundSuperRepair;
};

ItemData AODSuperRGun
{	description		= "Super-Repair Gun";
	shapeFile		= "repairgun";
	className		= "Weapon";
	shadowDetailMask = 4;
	imageType		= SuperRGunImage;
	showInventory	= false;
	price			= 750;
};

function AODSuperRPack::onUnmount(%player,%item)
{	if (Player::getMountedItem(%player,$WeaponSlot) == AODSuperRGun) 
	{	Player::unmountItem(%player,$WeaponSlot);
	}
	Player::UnMountItem(%player,$FlagSlot);
}

function AODSuperRPack::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	Player::mountItem(%player,%item,$BackpackSlot);
	
	}
	else
	{	Player::mountItem(%player,AODSuperRGun,$WeaponSlot);
	}
}

function AODSuperRPack::onMount(%player,%item)
{	Player::mountItem(%player,SuperR2Pack,$FlagSlot);
}

function AODSuperRPack::onDrop(%player,%item)
{	%client = Player::getClient(%player);
	Client::SendMessage(%client,0,"Unable to DROP this type of pack. Must be sold at an inventory station~wAAODSFX14.WAV");
}	

function AODSuperRGun::onMount(%player,%imageSlot)
{	Player::trigger(%player,$BackpackSlot,true);
	Player::trigger(%player,$FlagSlot,true);
}

function AODSuperRGun::onUnmount(%player,%imageSlot)
{	Player::trigger(%player,$BackpackSlot,false);
	Player::trigger(%player,$FlagSlot,false);
}

//******************************************************
//				End Super Repair Pack
//******************************************************

ItemImageData autoPackImage
{
	shapeFile = "shieldPack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = 4;
	maxEnergy = 11;   // Energy/sec for sustained weapons
	sfxFire = SoundElfFire;
	firstPerson = false;
};

ItemData AutoPack
{
	description = "AutoRepair Pack";
	shapeFile = "shieldPack";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = AutoPackImage;
	price = 1250;
	hudIcon = "shieldpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AutoPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"AutoRepair On");
	gameBase::setAutoRepairRate(%player, 0.075);
	checkAutoRepair(%player);
}

function checkAutorepair(%player, %imageslot, %this)
{
	if(GameBase::getDamageLevel(%player) == 0)
	{
		Player::trigger(%player,$BackpackSlot,false);
		gameBase::setAutoRepairRate(%player, 0);
	}
	else
	{
		schedule("checkAutoRepair(" @ %player @ ");", 0.5,%player);
	}
}

function AutoPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"AutoRepair Off");
	Player::trigger(%player,$BackpackSlot,false);
	gameBase::setAutoRepairRate(%player, 0);
}

$InvList[AutoPack] = 1;
$RemoteInvList[AutoPack] = 1;

$ItemMax[harmor, AutoPack] = 1;
$ItemMax[marmor, AutoPack] = 1;
$ItemMax[mfemale, AutoPack] = 1;
$ItemMax[larmor, AutoPack] = 1;
$ItemMax[lfemale, AutoPack] = 1;
$ItemMax[BlastechF, AutoPack] = 0;
$ItemMax[BlastechM, AutoPack] = 0;
$ItemMax[MagIonM, AutoPack] = 0;
$ItemMax[MagIonF, AutoPack] = 0;
$ItemMax[MECH, AutoPack] = 0;

//----------------------------------------------------------------------------

ItemImageData ShieldPackImage
{
	shapeFile = "shieldPack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = 4;
	maxEnergy = 9;   // Energy/sec for sustained weapons
	sfxFire = SoundShieldOn;
	firstPerson = false;
};

ItemData ShieldPack
{
	description = "Shield Pack";
	shapeFile = "shieldPack";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = ShieldPackImage;
	price = 175;
	hudIcon = "shieldpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function ShieldPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Shield On");
	%player.shieldStrength = 0.019;
}

function ShieldPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Shield Off");
	Player::trigger(%player,$BackpackSlot,false);
	%player.shieldStrength = 0;
}

//----------------------------------------------------------------------------

ItemImageData SensorJammerPackImage
{
	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 10;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData SensorJammerPack
{
	description = "Sensor Jammer Pack";
	shapeFile = "sensorjampack";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = SensorJammerPackImage;
	price = 200;
	hudIcon = "sensorjamerpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SensorJammerPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Sensor Jammer On");
	%rate = Player::getSensorSupression(%player) + 20;
	Player::setSensorSupression(%player,%rate);
}

function SensorJammerPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Sensor Jammer Off");
	%rate = Player::getSensorSupression(%player) - 20;
	Player::setSensorSupression(%player,%rate);
	Player::trigger(%player,$BackpackSlot,false);
}

//----------------------------------------------------------------------------
// Cloaking Device - INH*DynaBlade
//----------------------------------------------------------------------------

$InvList[CloakingDevice] = 1;
$RemoteInvList[CloakingDevice] = 1;

$ItemMax[harmor, CloakingDevice] = 0;
$ItemMax[marmor, CloakingDevice] = 0;
$ItemMax[mfemale, CloakingDevice] = 0;
$ItemMax[larmor, CloakingDevice] = 1;
$ItemMax[lfemale, CloakingDevice] = 1;
$ItemMax[BlastechF, CloakingDevice] = 1;
$ItemMax[BlastechM, CloakingDevice] = 1;
$ItemMax[MagIonM, CloakingDevice] = 0;
$ItemMax[MagIonF, CloakingDevice] = 0;
$ItemMax[MECH, CloakingDevice] = 0;

ItemImageData CloakingDeviceImage
{
	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 9;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData CloakingDevice
{
	description = "Cloaking Device";
	shapeFile = "sensorjampack";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = CloakingDeviceimage;
	price = 600;
	hudIcon = "sensorjamerpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function CloakingDeviceImage::onActivate(%player,%imageSlot)
{
	%radius = Player::getSensorSupression(%player) + 1;
	Player::setSensorSupression(%player,%radius);
	GameBase::playSound(%player,ForceFieldOpen,0);
 	GameBase::startFadeout(%player);
 	$cloaked[%player] = 1;
 	Cloaker(%player);
 	%ClientId = Player::getClient(%player);
	Client::sendMessage(Player::getClient(%player),0,"Cloaking Device On");
	Player::trigger(%player,$BackpackSlot,true);
}

function CloakingDeviceImage::onDeactivate(%player,%imageSlot)
{
	%radius = Player::getSensorSupression(%player) - 1;
	Player::setSensorSupression(%player,%radius);
	GameBase::playSound(%player,ForceFieldClose,0);
 	GameBase::startFadein(%player);
 	$cloaked[%player] = 0;
 	Cloaker(%player);
	Client::sendMessage(Player::getClient(%player),0,"Cloaking Device Off");
	Player::trigger(%player,$BackpackSlot,false);
}

//----------------------------------------------------------------------------

ItemImageData AmmoPackImage
{
	shapeFile = "AmmoPack";
	mountPoint = 2;
   mountOffset = { 0, -0.03, 0 };
	firstPerson = false;
};

ItemData AmmoPack
{
	description = "Ammo Pack";
	shapeFile = "AmmoPack";
	className = "Backpack";
   heading = "kBackpacks";
	imageType = AmmoPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 325;
	hudIcon = "ammopack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AmmoPack::onDrop(%player, %item)
{
	if($matchStarted) {
		%item = Item::onDrop(%player,%item);
		for(%i = 0; %i < 7 ; %i = %i +1) {
			%numPack = 0;
			%ammoItem = $AmmoPackItems[%i];
			%maxnum = $ItemMax[Player::getArmor(%player), %ammoItem];
			%pCount = Player::getItemCount(%player, %ammoItem);
			if(%pCount > %maxnum) {
				%numPack = %pCount - %maxnum;
				Player::decItemCount(%player,%ammoItem,%numPack);
			}	
			if(%i == 0) {
	 	    	%item.ATCAmmo = %numPack;
			}
			else if(%i == 1) {
	 	    	%item.PlasmaAmmo = %numPack;
			}
			else if(%i == 2) {
	 	    	%item.DiscAmmo = %numPack;
			}
			else if(%i == 3) {
	 	    	%item.GrenadeAmmo = %numPack;
			}
			else if(%i == 4) {
	 	    	%item.Grenade = %numPack;
			}
			else if(%i == 5) {
	 	    	%item.MortarAmmo = %numPack;
			}
			else if(%i == 6) {
	 	    	%item.MineAmmo = %numPack;
			}
			else if(%i == 7) {
	 	    	%item.GaussAmmo = %numPack;
			}
			else if(%i == 8) {
	 	    	%item.MinigunAmmo = %numPack;
			}
			else if(%i == 9) {
	 	    	%item.MMinigunAmmo = %numPack;
			}
			else if(%i == 10) {
	 	    	%item.ImpactAmmo = %numPack;
			}
			else if(%i == 11) {
	 	    	%item.EMPGrenadeAmmo = %numPack;
			}
			else if(%i == 12) {
	 	    	%item.MultiMineAmmo = %numPack;
			}
			else if(%i == 13) {
	 	    	%item.IMPAmmo = %numPack;
			}
			else if(%i == 14) {
	 	    	%item.MitziCore = %numPack;
			}
			else if(%i == 15) {
	 	    	%item.MissileAmmo = %numPack;
			}
			else if(%i == 16) {
	 	    	%item.LaserAmmo = %numPack;
			}
			else if(%i == 17) {
	 	    	%item.MrpgAmmo = %numPack;
			}
			else if(%i == 18) {
	 	    	%item.Darts = %numPack;
			}
			else if(%i == 19) {
	 	    	%item.ARAmmo = %numPack;
			}
			else if(%i == 20) {
	 	    	%item.RailAmmo = %numPack;
			}
			else if(%i == 21) {
	 	    	%item.Shells = %numPack;
			}
			else if(%i == 22) {
	 	    	%item.Bolts = %numPack;
			}
			else if(%i == 23) {
	 	    	%item.SXAmmo = %numPack;
			}
			else if(%i == 24) {
	 	    	%item.Beacon = %numPack;
			}
		}
	}
}

function AmmoPack::onCollision(%this,%object)
{
	if (getObjectType(%object) == "Player") {
		%item = Item::getItemData(%this);
		%count = Player::getItemCount(%object,%item);
		if (Item::giveItem(%object,%item,Item::getCount(%this))) {
			Item::playPickupSound(%this);
			checkPacksAmmo(%object, %this);
			Item::respawn(%this);
		}
	}
}

//----------------------------------------------------------------------------

$InvList[AmmoGeneratorPack]			= 1;
$RemoteInvList[AmmoGeneratorPack]		= 1;

$ItemMax[lfemale, AmmoGeneratorPack]	= 0;
$ItemMax[mfemale, AmmoGeneratorPack]	= 0;
$ItemMax[larmor, AmmoGeneratorPack]		= 0;
$ItemMax[marmor, AmmoGeneratorPack]		= 0;
$ItemMax[harmor, AmmoGeneratorPack]		= 1;
$ItemMax[BlastechF, AmmoGeneratorPack] = 0;
$ItemMax[BlastechM, AmmoGeneratorPack] = 0;
$ItemMax[MagIonM, AmmoGeneratorPack] = 0;
$ItemMax[MagIonF, AmmoGeneratorPack] = 0;
$ItemMax[MECH, AmmoGeneratorPack] = 1;

ItemImageData AmmoGenI
{
	shapeFile = "ammopack";
	mountPoint = 2;
   mountOffset = { 0, -0.03, 0 };
   mountRotation = { 0, 1.57, 0 };
	weaponType = 2;  // Sustained
	minEnergy = 8;
	maxEnergy = 8;   // Energy/sec for sustained weapons
	firstPerson = false;
};

ItemData AmmoGeneratorPack
{
	description = "Ammo Generator";
	shapeFile = "ammopack";
	className = "Backpack";
   heading = "kBackpacks";
	imageType = AmmoGenI;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 1000;
	hudIcon = "ammogen";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AmmoGenI::onMount(%player,%item)
{
	%player.AmmoGenActive = "false";
	%player.AmmoGenCounter = 0;
}

function AmmoGenI::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),3,"Ammo Fabrication started...");
	%player.ammogenActive = "true";
	#Player::trigger(%player,$BackpackSlot,true);
	ammogenImage::RegenerateAmmo(%player);
}

function ammogenI::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),1,"Ammo Fabrication stopped");
	Player::trigger(%player,$BackpackSlot,false);
	%player.ammogenActive = "false";
}

function AmmoGen::onDrop(%player, %item)
{
	Client::sendMessage(Player::getClient(%player),1,"Ammo Fabrication stopped");
	Player::trigger(%player,$BackpackSlot,false);
	%player.ammogenActive = "false";
}

function AmmoGenI::onDrop(%player, %item)
{
	Client::sendMessage(Player::getClient(%player),1,"Ammo Fabrication stopped");
	Player::trigger(%player,$BackpackSlot,false);
	%player.ammogenActive = "false";
}

function ammogenImage::RegenerateAmmo(%player)
{
	%player.ammogenCounter++;

	if (checkResources(%player,ImpAmmo,1,1) > 0 && Player::getItemCount(%player,ImpGun) == 1) ammogenImage::resupply(%player,"ImpGun",ImpAmmo,1,30);
	else if (checkResources(%player,PlasmaAmmo,1,1) > 0 && Player::getItemCount(%player,PlasmaGun) == 1) ammogenImage::resupply(%player,"PlasmaGun",PlasmaAmmo,1,4);
	else if (checkResources(%player,DiscAmmo,1,1) > 0 && Player::getItemCount(%player,DiscLauncher) == 1) ammogenImage::resupply(%player,"DiscLauncher",DiscAmmo,1,4);
	else if (checkResources(%player,GrenadeAmmo,1,1) > 0 && Player::getItemCount(%player,GrenadeLauncher) == 1) ammogenImage::resupply(%player,"GrenadeLauncher",GrenadeAmmo,1,4);
	else if (checkResources(%player,ImpactAmmo,1,1) > 0 && Player::getItemCount(%player,ImpactMortar) == 1) ammogenImage::resupply(%player,"ImpactMortar",ImpactAmmo,1,10);
	else if (checkResources(%player,MortarAmmo,1,1) > 0 && Player::getItemCount(%player,Mortar) == 1) ammogenImage::resupply(%player,"Mortar",MortarAmmo,1,10);
	else if (checkResources(%player,EMPGrenadeAmmo,1,1) > 0 && Player::getItemCount(%player,EMPGrenadeLauncher) == 1) ammogenImage::resupply(%player,"EMPGrenadeLauncher",EMPGrenadeAmmo,1,10);
	else if (checkResources(%player,MissileAmmo,1,1) > 0 && Player::getItemCount(%player,AODStinger) == 1) ammogenImage::resupply(%player,"AODStinger",MissileAmmo,1,10);
	else if (checkResources(%player,MinigunAmmo,1,1) > 0 && Player::getItemCount(%player,Minigun) == 1) ammogenImage::resupply(%player,"Minigun",MinigunAmmo,1,1);
	else if (checkResources(%player,MMinigunAmmo,1,1) > 0 && Player::getItemCount(%player,MMinigun) == 1) ammogenImage::resupply(%player,"MMinigun",MMinigunAmmo,1,1);
	else if (checkResources(%player,GrenadeAmmo,1,1) > 0 && Player::getItemCount(%player,RPGLauncher) == 1) ammogenImage::resupply(%player,"RPGLauncher",GrenadeAmmo,1,4);
	else if (checkResources(%player,MortarAmmo,1,1) > 0 && Player::getItemCount(%player,RPMLauncher) == 1) ammogenImage::resupply(%player,"RPMLauncher",MortarAmmo,1,10);
	else if (checkResources(%player,EMPGrenadeAmmo,1,1) > 0 && Player::getItemCount(%player,RPEMPLauncher) == 1) ammogenImage::resupply(%player,"RPEMPLauncher",EMPGrenadeAmmo,1,10);
	else if (checkResources(%player,MissileAmmo,1,1) > 0 && Player::getItemCount(%player,MechRocketLauncher) == 1) ammogenImage::resupply(%player,"MechRocketLauncher",MissileAmmo,1,10);
	else if (checkResources(%player,MRPGAmmo,1,1) > 0 && Player::getItemCount(%player,MRPGLauncher) == 1) ammogenImage::resupply(%player,"MRPGLauncher",MRPGAmmo,1,15);
	else if (checkResources(%player,GaussAmmo,1,1) > 0 && Player::getItemCount(%player,Gauss) == 1) ammogenImage::resupply(%player,"Gauss",GaussAmmo,1,5);
	else if (checkResources(%player,ATCAmmo,1,1) > 0 && Player::getItemCount(%player,ATC) == 1) ammogenImage::resupply(%player,"ATC",ATCAmmo,1,5);	
	else if (checkResources(%player,Darts,1,1) > 0 && Player::getItemCount(%player,DartGun) == 1) ammogenImage::resupply(%player,"DartGun",Darts,1,5);	
	else if (checkResources(%player,Shells,1,1) > 0 && Player::getItemCount(%player,Rifle) == 1) ammogenImage::resupply(%player,"Rifle",Shells,1,5);	
	else if (checkResources(%player,bolts,1,1) > 0 && Player::getItemCount(%player,massdriver) == 1) ammogenImage::resupply(%player,"Massdriver",Bolts,1,5);	
	else if (checkResources(%player,SXAmmo,1,1) > 0 && Player::getItemCount(%player,AAODSniperX) == 1) ammogenImage::resupply(%player,"AAODSniperX",SXAmmo,1,10);	
	else if (checkResources(%player,Beacon,1,1) > 0 && Player::getItemCount(%player,aodbeacongun) == 1) ammogenImage::resupply(%player,"AODBeaconGun",Beacon,1,10);
	
	else if (checkResources(%player,Grenade,1,1) > 0 ) ammogenImage::resupply(%player,"",Grenade,1,25);
	else if (checkResources(%player,MineAmmo,1,1) > 0 ) ammogenImage::resupply(%player,"",MineAmmo,1,25);
	else if (checkResources(%player,Beacon,1,1) > 0 ) ammogenImage::resupply(%player,"",Beacon,1,25);
	else if (checkResources(%player,RepairKit,1,1) > 0 ) ammogenImage::resupply(%player,"",RepairKit,1,20);

	else 
		{
			%player.ammogenCounter = 0;
			Client::sendMessage(Player::getClient(%player),3,"Ammo level optimum--Fabrication complete.");
			Player::trigger(%player,$BackpackSlot,false);
			%player.ammogenActive = "false";
		}
      if (%player.ammogenActive == "true") {
		  schedule("ammogenImage::RegenerateAmmo(" @ %player @ ");", 0.1,%player);
		}
}

function ammogenImage::resupply(%player,%weapon,%item,%delta,%genreq)
{
	if (%player.ammogenCounter >= %genreq) 
		{
			%delta = checkResources(%player,%item,%delta,1);		
			if(%delta > 0) {						
				Player::incItemCount(%player,%item,%delta);
				%player.ammogenCounter = 0;
	 			return %delta;
			}
			return 0;
	}
}

//-----------------------------------------------

function checkPacksAmmo(%player, %item)
{
	for(%i = 0; %i < 10 ; %i = %i +1) {
		%ammoItem = $AmmoPackItems[%i];
		if(%i == 0) {
	        %numAdd = %item.ATCAmmo;
		}
		else if(%i == 1) {
	    	%numAdd = %item.PlasmaAmmo;
		}
		else if(%i == 2) {
	    	%numAdd = %item.DiscAmmo;
		}
		else if(%i == 3) {
	    	%numAdd = %item.GrenadeAmmo;
		}
		else if(%i == 4) {
	    	%numAdd = %item.Grenade;
		}
		else if(%i == 5) {
		%numAdd = %item.MortarAmmo;
		}
		else if(%i == 6) {
	    	%numAdd = %item.MineAmmo;
		}
		else if(%i == 7) {
 	    	%numAdd = %item.GaussAmmo;
		}
		else if(%i == 8) {
 	    	%numAdd = %item.MinigunAmmo;
		}
		else if(%i == 9) {
 	    	%numAdd = %item.MMinigunAmmo;
		}
		else if(%i == 10) {
 	    	%numAdd = %item.ImpactAmmo;
		}
		else if(%i == 11) {
 	    	%numAdd = %item.EMPGrenadeAmmo;
		}
		else if(%i == 12) {
 	    	%numAdd = %item.MultiMineAmmo;
		}
		else if(%i == 13) {
 	    	%numAdd = %item.IMPAmmo;
		}
		else if(%i == 14) {
 	    	%numAdd = %item.MitziCore;
		}
		else if(%i == 15) {
 	    	%numAdd = %item.MissileAmmo;
		}
		else if(%i == 16) {
 	    	%numAdd = %item.LaserAmmo;
		}
		else if(%i == 17) {
 	    	%numAdd = %item.MrpgAmmo;
		}
		else if(%i == 18) {
 	    	%numAdd = %item.Darts;
		}
		else if(%i == 19) {
 	    	%numAdd = %item.ARAmmo;
		}
		else if(%i == 20) {
 	    	%numAdd = %item.RailAmmo;
		}
		else if(%i == 21) {
 	    	%numAdd = %item.Shells;
		}
		else if(%i == 22) {
 	    	%numAdd = %item.Bolts;
		}
		else if(%i == 23) {
 	    	%numAdd = %item.SXAmmo;
		}
		else if(%i == 24) {
 	    	%numAdd = %item.Beacon;
		}
		Player::incItemCount(%player,%ammoItem,%numAdd);
	}						 
}

function fillAmmoPack(%client)
{
	%player = Client::getOwnedObject(%client);
	for(%i = 0; %i < 10 ; %i = %i +1) {
		%item = $AmmoPackItems[%i];
		%maxnum = $AmmoPackMax[%item];
		%maxnum = checkResources(%player,%item,%maxnum); 
		if(%maxnum) {
			Player::incItemCount(%client,%item,%maxnum);
			teamEnergyBuySell(%player,%item.price * %maxnum * -1);

	}	
	}
}


//===========AODCmdPack Backpack Script=====================
$InvList[AODCmdPack]			= 1;
$RemoteInvList[AODCmdPack]		= 1;
$TeamItemMax[AODCmdPack]		= 999999999;

$ItemMax[larmor, AODCmdPack]	= 0;
$ItemMax[lfemale, AODCmdPack]	= 0;
$ItemMax[marmor, AODCmdPack]	= 1;
$ItemMax[mfemale, AODCmdPack]	= 1;
$ItemMax[harmor, AODCmdPack]	= 0;
$ItemMax[BlastechF, AODCmdPack] = 0;
$ItemMax[BlastechM, AODCmdPack] = 0;
$ItemMax[MagIonM, AODCmdPack] = 0;
$ItemMax[MagIonF, AODCmdPack] = 0;
$ItemMax[MECH, AODCmdPack] = 0;

ItemImageData AODCmdPackImage 
{	shapeFile		= "ammounit_remote";
	mountPoint		= 2;
	mountOffset		= { 0, -0.25, 0.5 };
	mountRotation	= { 0, 3.141592654, 0 };


	mass			= 1.0;
	firstPerson		= false;
};

ItemData AODCmdPack 
{	description = "Turret Control pack";
	shapeFile = "CMDPNL";
	classname = "Backpack";
	heading = "kBackpacks";
	imageType = AODCmdPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 250;
	hudIcon = "repairpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AODCmdPack::onUse(%player,%item)
{	
	%client = Player::getClient(%player);
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{	
		remoteCommandMode(%client);
	}
}

//--------------------------------------------------------------------------------------------------------
// Hyperdrive Pack 
//--------------------------------------------------------------------------------------------------------

$InvList[HyperPack] = 1;
$RemoteInvList[HyperPack] = 1;

$ItemMax[lfemale,HyperPack] = 1;	
$ItemMax[larmor,HyperPack] = 1;	
$ItemMax[mfemale,HyperPack] = 0;	
$ItemMax[marmor,HyperPack] = 0;	
$ItemMax[harmor,HyperPack] = 0;	
$ItemMax[BlastechF, HyperPack] = 1;
$ItemMax[BlastechM, HyperPack] = 1;
$ItemMax[MagIonM, HyperPack] = 0;
$ItemMax[MagIonF, HyperPack] = 0;
$ItemMax[MECH, HyperPack] = 0;

ItemImageData HyperPackImage
{
        shapeFile = "armorkit";
        mountPoint = 2;
        weaponType = 2;
        minEnergy = 1;
        maxEnergy = 1;
        lightType = 3;
        lightRadius = 10;
        lightTime = 10;
        lightColor = { 0.3, 0.1, 0.6 };
        firstPerson = false;
};

ItemData HyperPack
{
        description = "Hyperdrive/GasMask";
        shapeFile = "armorkit";
        className = "Backpack";
        heading = kBackpacks;
        shadowDetailMask = 4;
        imageType = HyperPackImage;
        price = 2500;
        hudIcon = "compass";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function HyperPackImage::onActivate(%player,%imageSlot)
{
	%energy = GameBase::getEnergy(%player);

	if(%energy > 30)
	{
		%client = Player::getClient(%player);
		%pos = GameBase::getPosition(%player);

		if(GameBase::getLOSInfo(%player, 302))
		{
			if(Player::hasFlag(%player))
			{
				Player::dropItem(%player, $theFlag);	// pun city :)
				Client::sendMessage(%client, 1, "Cannot carry flag on Teleportation; dropping flag.~werror_message.wav");
			}

			if(FindFlag($los::position,50,50,1024))	// making sure
			{
				Client::sendMessage(%client, 1, "Cannot teleport within 50m of the flag.");
				Player::trigger(%player, $BackpackSlot,false);	
			}

			GameBase::setPosition(%player,$los::position);
			playSound(ForceFieldOpen,$los::position);
			useEnergy(%player,20);
			Player::trigger(%player,$BackPackSlot,false);
		}
		else
		{
			Bottomprint(%client, "<jc>Hyperdrive destination position out of range -- get within 300m");
			Player::trigger(%player,$BackPackSlot,false);
		}	
	}
	else
	{
		playSound(SoundPackFail,%pos);
		Player::trigger(%player,$BackPackSlot,false);
	}
}

function HyperPackImage::onDeactivate(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,false);
}

//--------------------------------------------------------------------------------------------------------
// Super Speed Pack 
//--------------------------------------------------------------------------------------------------------

ItemImageData SpeedPackImage
{
	shapeFile = "mortarAmmo";
	weaponType = 2;  // Sustained
	mountRotation = { 0, 0, -1.57 };
	minEnergy = 2;
	maxEnergy = 10;   // Energy/sec for sustained weapons
	sfxFire = SoundUseAmmoStation;
	firstPerson = false;
};

ItemData SpeedPack
{
	description = "SuperSpeed Pack";
	shapeFile = "mortarAmmo";
	className = "Backpack";
   heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = SpeedPackImage;
	price = 500;
	hudIcon = "clock";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SpeedPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),3,"SuperSpeed On !!!~wmine_act.wav");
	%armor = Player::getArmor(%player);

	if(!$SpeedPackOn)
	{
		%armor.maxForwardSpeed += 30;
		%armor.maxBackwardSpeed += 15;
		%armor.maxSideSpeed += 8;
		%armor.maxJetForwardVelocity += 8;
		$SpeedPackOn = "True";
	}
}

function SpeedPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"SuperSpeed Off");
	%armor = Player::getArmor(%player);

	if($SpeedPackOn) // So it doesn't screw up by double-negative LOL!!
	{
		%armor.maxForwardSpeed -= 30;
		%armor.maxBackwardSpeed -= 15;
		%armor.maxSideSpeed -= 8;
		%armor.maxJetForwardVelocity -= 8;
		$SpeedPackOn = "False";
	}

	Player::trigger(%player,$BackpackSlot,false);
}

$InvList[SpeedPack] = 1;
$RemoteInvList[SpeedPack] = 0;

$ItemMax[harmor, SpeedPack] = 0;
$ItemMax[marmor, SpeedPack] = 1;
$ItemMax[mfemale, SpeedPack] = 1;
$ItemMax[larmor, SpeedPack] = 0;
$ItemMax[lfemale, SpeedPack] = 0;
$ItemMax[BlastechF, SpeedPack] = 0;
$ItemMax[BlastechM, SpeedPack] = 0;
$ItemMax[MagIonM, SpeedPack] = 0;
$ItemMax[MagIonF, SpeedPack] = 0;
$ItemMax[MECH, SpeedPack] = 1;

//--------------------------------------------------------------------------------------------------------
// Jet Pack
//--------------------------------------------------------------------------------------------------------

$Jet::HoverValue = 1.15; // How much vel per 1/100th of a second to keep a player stationary
$Jet::Speed = 25; // How fast does it propel an object in the direction

ItemImageData JetGunImage
{
	shapeFile = "repairgun";
	mountPoint = 0;

	weaponType = 2; // Sustained
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.0;
	maxEnergy = 0.5;

	sfxFire     = SoundFlyerActive;
};

ItemData JetGun
{
	description = "Jet Pack";
	shapeFile = "paintgun";
	className = "Weapon";
	shadowDetailMask = 4;
	imageType = JetGunImage;
	showInventory = false;
	price = 0;
};

function JetGun::onUnmount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,false);
}

ExplosionData nullExp
{
   shapeName = "breath.dts";

   faceCamera = false;
   randomSpin = false;
   hasLight   = false;
   lightRange = 3.0;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 1.0, 1.0,  1.0 };
   radFactors = { 1.0, 1.0,  1.0 };

   shiftPosition = false;
};

GrenadeData PassiveSmoke
{
   bulletShapeName    = "breath.dts";
   explosionTag       = nullExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 0;
   damageValue        = 0;
   damageType         = false;

   explosionRadius    = 0;
   kickBackStrength   = 0;
   maxLevelFlightDist = 0;
   totalTime          = 0.01;    // special meaning for grenades...
   liveTime           = 0.01;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

GrenadeData ActiveSmoke
{
   bulletShapeName    = "breath.dts";
   explosionTag       = nullExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 0;
   damageValue        = 0;
   damageType         = false;

   explosionRadius    = 0;
   kickBackStrength   = 0;
   maxLevelFlightDist = 0;
   totalTime          = 0.01;    // special meaning for grenades...
   liveTime           = 0.01;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "tumult_small.dts";
};

ItemImageData JetPackImage
{
	shapeFile = "mortargun";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = 1;
	maxEnergy = 8.5;   // Energy used/sec for sustained weapons
  	mountOffset = { 0, 0, 0.31 };
  	mountRotation = { 5, 0, 3 };
	firstPerson = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 15;
	lightTime = 2;
	lightColor = { 1, 1, 0.2 };
	sfxFire = SoundFlyerIdle;
};

ItemData JetPack
{
	description = "Jet Pack";
	shapeFile = "mortargun";
	className = "Backpack";
      heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = JetPackImage;
	price = 2000;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function JetPack::onUnmount(%player,%item,$BackPackSlot)
{
	if (Player::getMountedItem(%player,$WeaponSlot) == JetGun)
		Player::unmountItem(%player,$WeaponSlot);
}

function JetPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
		Player::mountItem(%player,%item,$BackpackSlot);
	else
	{
		Player::trigger(%player,$BackpackSlot,true);
		Player::mountItem(%player,JetGun,$WeaponSlot);
	}
}

function JetPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),1,"Jetpack On !!!~wAAODSFX51.wav"); // hehe :)
	%player.hasJetpack = true;
	TSR::JetPack(%player);
}

function TSR::JetPack(%player)
{
	if(%player.hasJetpack)	// Keep him there; negate the gravity effect
	{
		if(Player::isTriggered(%player,$WeaponSlot)) // Only if the trigger is on
		{
			if(Player::getMountedItem(%player,$WeaponSlot) == JetGun) // Incoming MATH BLASTER! AAAAAA!!
			{
				%trans = GameBase::getMuzzleTransform(%player);
				%c1 = getWord(getBoxCenter(%player), 0);
				%c2 = getWord(getBoxCenter(%player), 1);
				%c3 = getWord(getBoxCenter(%player), 2) + 0.125;
				%middle = %c1@" "@%c2@" "@%c3;
				%center = "0 0 1 0 0 0 0 0 1 " @ %middle; 
				%rot = GameBase::getRotation(%player);
				%zrot = getWord(%trans,5);
				%kick = Vector::getFromRot(%rot,$Jet::Speed,%zrot*10); // Sensitive :)
				%xkick = getWord(%kick, 0);
				%ykick = getWord(%kick, 1);
				%zkick = getWord(%kick, 2); 

				if(%zkick > 8.75)
					%vel = "0 0 "@%zkick + 5;
				else if(%zkick < -8.75)
					%vel = "0 0 "@%zkick - 5;
				else 
					%vel = %xkick@" "@%ykick@" "@%zkick; // New way of looking at velocity

				Item::setVelocity(%player, %vel);

				if(%player.smokeCount >= 15)
				{
					Projectile::spawnProjectile(PassiveSmoke,%center,%player,%vel);
					Projectile::spawnProjectile(ActiveSmoke,%center,%player,%vel);
					%player.smokeCount = 0;
				}
			}
		}
		else
		{
			Item::setVelocity(%player, "0 0 "@$Jet::HoverValue); // $Jet::HoverValue being the universal constanst taking place from the earlier float pack
			%player.jetActive = false;

			if(%player.smokeCount >= 15)
			{
				Projectile::spawnProjectile(PassiveSmoke,%center,%player,%vel);
				%player.smokeCount = 0;
			}
		}

		%player.smokeCount += 1;
		schedule("TSR::JetPack("@%player@");", 0.01, %player); // Only 100x a second...
	}
}

function JetPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),3,"Jetpack Off~wmine_act.wav");
	Player::trigger(%player,$BackpackSlot,false);
	%player.hasJetpack = false; // Strings in place to keep a const int on pack activation

	if(Player::getMountedItem(%player,$WeaponSlot) == JetGun)
		Player::unmountItem(%player,$WeaponSlot);
}

function JetPack::onDrop(%player,%item)
{
	if($matchStarted)
	{
		%mounted = Player::getMountedItem(%player,$WeaponSlot);

		if (%mounted == JetGun)
			Player::unmountItem(%player,$WeaponSlot);
		else
			Player::mountItem(%player,%mounted,$WeaponSlot);

		Item::onDrop(%player,%item);
	}
}

$InvList[JetPack] = 1;
$RemoteInvList[JetPack] = 0;

$ItemMax[larmor, JetPack] = 0;
$ItemMax[lfemale, JetPack] = 0;
$ItemMax[marmor, JetPack] = 1;
$ItemMax[mfemale, JetPack] = 1;
$ItemMax[harmor, JetPack] = 1;
$ItemMax[BlastechF, JetPack] = 0;
$ItemMax[BlastechM, JetPack] = 0;
$ItemMax[MagIonM, JetPack] = 0;
$ItemMax[MagIonF, JetPack] = 0;
$ItemMax[MECH, JetPack] = 1;
