//----------------------------------------------------------------------------
// TURRET DYNAMIC DATA

TurretData PlasmaTurret
{
	maxDamage = 4.0;
	maxEnergy = 200;
	minGunEnergy = 75;
	maxGunEnergy = 6;
	reloadDelay = 0.3;
//	reloadDelay = 0.8;
	fireSound = SoundPlasmaTurretFire;
	activationSound = SoundPlasmaTurretOn;
	deactivateSound = SoundPlasmaTurretOff;
	whirSound = SoundPlasmaTurretTurn;
	range = 100;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "hellfiregun";
	shieldShapeName = "shield_medium";
	speed = 12.0;
	speedModifier = 2.0;
	projectileType = FusionBolt;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Plasma Turret";
};
																						 
TurretData ELFTurret	   
{			 
	maxDamage = 4.0;
	maxEnergy = 150;
	minGunEnergy = 50;
	maxGunEnergy = 5;
	range = 125;
//	range = 40;
	visibleToSensor = true;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisMedium;
	className = "ELF Turret";
	shapeFile = "chainturret";
	shieldShapeName = "shield";
	speed = 8.0;
	speedModifier = 1.5;
	projectileType = turretCharge;
	reloadDelay = 0.3;
	explosionId = LargeShockwave;
	description = "ELF Turret";

	fireSound        = SoundGeneratorPower;
	activationSound  = SoundChainTurretOn;
	deactivateSound  = SoundChainTurretOff;
	damageSkinData   = "objectDamageSkins";
	shadowDetailMask = 8;

	isSustained     = true;
	firingTimeMS    = 750;
	energyRate      = 30.0;
};

TurretData RocketTurret
{
	maxDamage = 4.75;
	maxEnergy = 100;
	minGunEnergy = 20;
	maxGunEnergy = 20;
//	minGunEnergy = 60;
//	maxGunEnergy = 60;
	range = 150;
	gunRange = 300;
	visibleToSensor = true;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisLarge;
	className = "Turret";
	shapeFile = "missileturret";
	shieldShapeName = "shield_medium";
	speed = 8.0;
	speedModifier = 2.0;
	projectileType = TurretMissile3;
	reloadDelay = 2.5;
	fireSound = SoundMissileTurretFire;
	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
//	whirSound = SoundMissileTurretTurn;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	targetableFovRatio = 0.5;
	explosionId = LargeShockwave;
	description = "Rocket Turret";
};

function RocketTurret::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.0075;
		GameBase::setRechargeRate(%this,30);
		GameBase::setAutoRepairRate(%this, 0.01);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
		GameBase::setAutoRepairRate(%this, 0);
	}
	GameBase::setActive(%this,%power);
}

function RocketTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

//--------------------------------------------

TurretData MortarTurret
{
	maxDamage = 5.0;
	maxEnergy = 450;
	minGunEnergy = 15;
	maxGunEnergy = 15;
	reloadDelay = 3.0;
	fireSound = SoundMortarTurretFire;
	activationSound = SoundMortarTurretOn;
	deactivateSound = SoundMortarTurretOff;
	whirSound = SoundMortarTurretTurn;
	range = 250;
	gunRange = 300;
//	dopplerVelocity = 30;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	supressable = false;//these 2 make it motion-sensor
	pinger = false;//these 2 make it motion-sensor
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "mortar_turret";
	shieldShapeName = "shield_medium";
	speed = 8.0;
	speedModifier = 2.0;
//	projectileType = SeekingRPM2;
//	projectileType = MortarTurretShell;
	projectileType = RPTurretMortar;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Mortar Turret";
};

function MortarTurret::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.008;
		GameBase::setRechargeRate(%this,30);
		GameBase::setAutoRepairRate(%this, 0.01);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
		GameBase::setAutoRepairRate(%this, 0);
	}
	GameBase::setActive(%this,%power);
}

//function MortarTurret::verifyTarget(%this,%target)
//{
//	if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
//		return "True";
//	else
//		return "False";
//}

//--------------------------------------------

TurretData IndoorTurret
{
	className = "Turret";
	shapeFile = "indoorgun";
	projectileType = MiniFusionBolt;
	maxDamage = 3.5;
	maxEnergy = 60;
	minGunEnergy = 20;
	maxGunEnergy = 6;
	reloadDelay = 0.02;
	speed = 20.0;
	speedModifier = 1.0;
	range = 145;
	visibleToSensor = true;
	dopplerVelocity = 0;
//	dopplerVelocity = 2;
	castLOS = true;
	supression = false;
	supressable = false;
	pinger = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisMedium;
	shieldShapeName = "shield";
	fireSound = SoundEnergyTurretFire;
	activationSound = SoundEnergyTurretOn;
	deactivateSound = SoundEnergyTurretOff;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = debrisExpMedium;
	description = "Indoor Turret";

};


//--------------------------------------------

TurretData DeployableTurret
{
	className = "Turret";
	shapeFile = "remoteturret";
   validateShape = true;
   validateMaterials = true;
	projectileType = SniperLaser;
	maxDamage = 12.75;
	maxEnergy = 640;
	minGunEnergy = 45;
	maxGunEnergy = 45;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	reloadDelay = 1.5;
//	reloadDelay = 5;
	speed = 14.0;
	speedModifier = 1.5;
	range = 328;
//	range = 128;
	visibleToSensor = true;
	shadowDetailMask = 4;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = flashDebrisMedium;
	shieldShapeName = "shield";
	fireSound = SoundFireLaser;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId = flashExpMedium;
	description = "Laser Turret";
	damageSkinData = "objectDamageSkins";
};

function DeployableTurret::onAdd(%this)
{
	schedule("DeployableTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,20);
	%this.shieldStrength = 0;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Laser Turret");
	}
}

function DeployableTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DeployableTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "TurretPack"]--;
}

// Override base class just in case.
function DeployableTurret::onPower(%this,%power,%generator) {}
function DeployableTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,20);
	GameBase::setActive(%this,true);
}	


//--------------------------------------------

TurretData CameraTurret
{
	className = "Turret";
	shapeFile = "camera";
	maxDamage = 10.25;
	maxEnergy = 10;
	speed = 20;
	speedModifier = 1.0;
	range = 100;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 2;
	mapIcon = "M_camera";
	debrisId = defaultDebrisSmall;
	FOV = 0.707;
	pinger = false;
	explosionId = debrisExpMedium;
	description = "Camera";
};

function CameraTurret::onAdd(%this)
{
	schedule("CameraTurret::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Camera");
	}
}

function CameraTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function CameraTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function CameraTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "CameraPack"]--;
}	

//---------------------------------------------------

TurretData SatchelCharge
{
	className = "Turret";
	shapeFile = "camera";
	maxDamage = 0.25;
	maxEnergy = 10;
	minGunEnergy = 5;
	maxGunEnergy = 10;
	speed = 20;
	speedModifier = 1.0;
	range = 0;
	projectileType = SatchelShell;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 2;
	mapIcon = "M_camera";
	debrisId = defaultDebrisSmall;
	FOV = 0.707;
	pinger = false;
	explosionId = debrisExpMedium;
	description = "Satchel Charge";
};

//---------------------------------------------------

function Turret::onAdd(%this)
{
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Turret");
	}
}

function Turret::onActivate(%this)
{
	GameBase::playSequence(%this,0,power);
}

function Turret::onDeactivate(%this)
{
	GameBase::stopSequence(%this,0);
	Turret::checkOperator(%this);
}

function Turret::onSetTeam(%this,%oldTeam)
{
	if(GameBase::getTeam(%this) != Client::getTeam(GameBase::getControlClient(%this))) 
		Turret::checkOperator(%this);

}

function Turret::checkOperator(%this)
{
   %cl = GameBase::getControlClient(%this);
   if(%cl != -1) {
   	%pl = Client::getOwnedObject(%cl);
		Player::setMountObject(%pl, -1,0);
	   Client::setControlObject(%cl, %pl);
   }
	Client::setGuiMode(%cl,2);
}

function Turret::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.006;
		GameBase::setRechargeRate(%this,30);
		GameBase::setAutoRepairRate(%this, 0.005);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
		GameBase::setAutoRepairRate(%this, 0);
	}
	GameBase::setActive(%this,%power);
}

function Turret::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {
		%this.shieldStrength = 0.006;
		GameBase::setRechargeRate(%this,30);
		GameBase::setActive(%this,true);
		GameBase::setAutoRepairRate(%this, 0.005);
	}
}

function Turret::onDisabled(%this)
{
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
}

function Turret::onDestroyed(%this)
{
	StaticShape::objectiveDestroyed(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
	staticshape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 9, 3, 0.40, 
		0.1, 200, 100); 
}

function Turret::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	if(%type == $EMPDamageType)
	{
		staticshape::objectiveDestroyed(%this);
		GameBase::setRechargeRate(%this,0);
	}

	if(%type == $AcidBathDamageType)
	{
		staticshape::objectiveDestroyed(%this);
		GameBase::setAutoRepairRate(%this,0);
	}

	if(%type == $BlasterDamageType)
	{
		%energy = GameBase::getEnergy(%this);
 		%energy -= 5;
		GameBase::setEnergy(%this,%energy); 
	}

	if(%type == $ShotgunDamageType)
	{
		%energy = GameBase::getEnergy(%this);
 		%energy -= 10;
		GameBase::setEnergy(%this,%energy); 
	}

   if(%this.objectiveLine)
		%this.lastDamageTeam = GameBase::getTeam(%object);
	%TDS= 1;
	if(GameBase::getTeam(%this) == GameBase::getTeam(%object)) {
		%name = GameBase::getDataName(%this);
		if(%name != DeployableTurret && %name != CameraTurret )	
			%TDS = $Server::TeamDamageScale;
	}
	StaticShape::shieldDamage(%this,%type,%value * %TDS,%pos,%vec,%mom,%object);
}

function Turret::onControl (%this, %object)
{
	%client = Player::getClient(%object); 
	Client::sendMessage(%client,0,"Controlling turret " @ %this); 
} 

function Turret::onDismount (%this, %object) 
{ 
	%client = Player::getClient(%object); 
	Client::sendMessage(%client,0,"Leaving turret " @ %this); 
} 

function Turret::onCollision (%this, %object) 
{ 
	%name = GameBase::getDataName(%this); 
	%client = Player::getClient(%object);
	%armor = Player::getArmor(%object); 

	if(getObjectType (%object) == "Player") 
	{
		if (Player::getMountedItem(%object,$BackpackSlot) == AODCmdPack) 
		{
			if((%name == DeployableMortar || %name == DeployablePlasma || %name == MortarTurret || %name == DeployableRocket || %name == DeployableTurret || %name == ELFTurret || %name == IndoorTurret || %name == GROGTurret || %name == VELCROTurret || Fluxturret || %name == FusionTurret || %name == DisruptorTurret || %name == IonTurret || %name == PulseTurret || %name == DiscTurret || %name == ArtilleryTurret || %name == AntiTurret) && (GameBase::getTeam(%this) != GameBase::getTeam(%object)))
			{
				if (%object.reprogramTurret == 0)
				{ 
					if(GameBase::GetPosition(%this) != GameBase::GetPosition(%object)) 
					{
						Client::getOwnedObject(%client).CommandTag = 1; 
						Client::sendMessage(%client,3,"Re-programming turret...~wsensor_deploy.wav");
						%origteam = GameBase::getTeam(%this);
						GameBase::setTeam (%this,GameBase::getTeam (%client));
//						Client::takeControl(%client, %this);
						%object.reprogramTurret = 1;
						schedule(%object @ ".reprogramTurret  = 0;",25.0,%object);//25 sec for pack to rechg
						schedule("GameBase::setTeam(" @ %this @ " ," @ %origteam @ ");",600,%this);
						Client::sendMessage(%client,3,"It will revert control back to the original team in 10 minutes.");
						return;
					} 
				} 
				else 
				{
					Client::sendMessage(%client,1,"Turret Control pack is recharging.");
				//	schedule(%object @ ".reprogramTurret  = 0;",25.0,%object);
					return;
				}
			}
		}
		if((GameBase::getTeam(%object) == GameBase::getTeam(%this)) && (%name == PlasmaTurret || %name == PulseTurret || %name == AntiTurret || %name == FusionTurret))
//		else if((GameBase::getTeam(%object) == GameBase::getTeam(%this)) && (%name == PlasmaTurret || %name == PulseTurret || %name == AntiTurret || %name == FusionTurret))
		{
			if(%object.pushedTurret == 0)
			{
				if(%armor != "harmor" && %armor != "MECH")
				{
					if(GameBase::GetPosition(%object) != GameBase::GetPosition(%this)) 
					{
						Client::getOwnedObject(%client).CommandTag = 1; 
						Client::sendMessage(%client,0,"Manually controlling turret"); 
						Client::takeControl(%client, %this); 
						GameBase::SetPosition(%object,GameBase::GetPosition(%this));
						%object.pushedTurret = 1;
//						schedule(%object @ ".pushedTurret = 0;",5.0,%object);
						Client::getOwnedObject(%client).CommandTag = 0; 
						return;
					}
				}
				else 
				{
					Client::sendMessage(%client,0,"Can not manually command turrets in this class."); 
				}
			}
			else
			{
				Client::sendMessage(%client,1,"Turret is recharging.");
				schedule(%object @ ".pushedTurret = 0;",5.0,%object);

				%height = 2;
				%pos = GameBase::getPosition(%object);
				%posX = getWord(%pos,0);
				%posY = getWord(%pos,1);
				%posZ = getWord(%pos,2);
				if(GameBase::testPosition(%object,%posX @ " " @ %posY @ " " @ (%posZ + %height))) 
				{
					%dest = Vector::add(Gamebase::getPosition(%object), MoveForward::rotVector( "0 2 0", GameBase::getRotation(%object)));
				}
				else
				{
					%dest = Vector::add(Gamebase::getPosition(%object), MoveForward::rotVector( "0 2 -1.0", GameBase::getRotation(%object)));
				}
				GameBase::SetPosition(%object,%dest);
				return;
			}
		} 
		else
		{
			Client::sendMessage(%client,0,"--ACCESS DENIED-- ~waccess_denied.wav"); 
		}
	} 
} 

function LaptopDrain(%clientId, %player) 
{ 
	Player::unmountItem(%player,$WeaponSlot);
	if($lapTime[%clientId] == 0) 
	{ 
		Client::getOwnedObject(%clientId).CommandTag = ""; 
		$lapTime[%clientId] = 30; 
		checkPlayerLaptop(%clientId, %player); 
	} 
	else $lapTime[%clientId] = 30; 
} 

function checkPlayerLaptop(%clientId, %player) 
{ 
	if($lapTime[%clientId] > 0) 
	{
		$lapTime[%clientId] -= 5;
		schedule("checkPlayerLaptop(" @ %clientId @ ", " @ %player @ ");",5,%player); 
		bottomprint(%clientId, "<f1><jc>Turret controller is recharging.", 2);
//		Client::sendMessage(%clientId,2,"Turret controller is recharging.");
	}
	else
	{
		Client::sendMessage(%clientId,3,"Turret controller is RECHARGED. ~wmine_act.wav");
//		bottomprint(%clientId, "<f1><jc>Turret controller is <f2>RECHARGED<f1>.", 2);
	}
}

