# ptrPack -> ptrFlag functions

function Player::hasFlag(%player)
{
	%flag = Player::getMountedItem(%player, $FlagSlot);
	$theFlag = %flag;

	if(%flag == Flag)	
		return true;
	else 
		return false;
}

function FindFlag(%pos,%xdist,%ydist,%zdist)
{
 	%set = newObject("set",SimSet);
	%num = containerBoxFillSet(%set,$StaticObjectType,%pos,%xDist,%yDist,%zDist,0);
	%flag = CountObjects(%set,"FlagStand",%num);

	deleteObject(%set);

	if(%flag)
		return true;
	else
		FindActualFlag(%pos,%xdist,%ydist,%zdist);
}

function findActualFlag(%pos,%xdist,%ydist,%zdist)
{
 	%set = newObject("set",SimSet);
	%num = containerBoxFillSet(%set,$ItemObjectType,%pos,%xDist,%yDist,%zDist,0);
	%flag = CountObjects(%set,"Flag",%num);

	deleteObject(%set);

	if(%flag)
		return true;
	else 
		return false;
}

//===================================================================================

ItemImageData EnergyPackImage
{
	shapeFile = "jetPack";
	weaponType = 2;  // Sustained

	mountPoint = 2;
	mountOffset = { 0, -0.1, 0 };
	mass = -2;
	minEnergy = -1;
 	maxEnergy = -3;
	firstPerson = false;
};

ItemData EnergyPack
{
	description = "Energy Pack";
	shapeFile = "jetPack";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = EnergyPackImage;
	price = 150;
	hudIcon = "energyrifle";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function EnergyPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
}

function Energypack::onMount(%player,%item)
{
	Player::trigger(%player,$BackpackSlot,true);
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc><f1>Restores an additional <f2>3<f1> pts of energy over your standard recharge rate.\n<jc><f1>It is very lightweight. Helps the Blaster use less energy per shot.", 10);
}

//===================================================================================

$InvList[Accelerator] = 1;
$RemoteInvList[Accelerator] = 1;

$ItemMax[harmor, Accelerator] = 1;
$ItemMax[marmor, Accelerator] = 1;
$ItemMax[mfemale, Accelerator] = 1;
$ItemMax[larmor, Accelerator] = 1;
$ItemMax[lfemale, Accelerator] = 1;
$ItemMax[BlastechF, Accelerator] = 1;
$ItemMax[BlastechM, Accelerator] = 1;
$ItemMax[MagIonM, Accelerator] = 1;
$ItemMax[MagIonF, Accelerator] = 1;
$ItemMax[MECH, Accelerator] = 1;

ItemImageData AcceleratorImage
{
	shapeFile = "mortarpack";
	weaponType = 2;  // Sustained

	mountPoint = 2;
	mountOffset = { 0, -0.1, 0 };

	minEnergy = -1;
 	maxEnergy = -27;
// 	maxEnergy = -12;
	firstPerson = false;
};

ItemData Accelerator
{
	description = "Particle Accelerator";
	shapeFile = "mortarpack";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = AcceleratorImage;
	price = 450;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function Accelerator::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
}

function Accelerator::onMount(%player,%item)
{
	Player::trigger(%player,$BackpackSlot,true);
        %client = Player::getClient(%player);
      Bottomprint(%client, "<jc><f1>Recharges an additional <f2>27<f1> pts over your standard recharge rate.\n<jc>You must have this to use the PBW gun.", 10);
}

function Accelerator::onUnmount(%player,%item)
{
	if (Player::getMountedItem(%player,$WeaponSlot) == PBW) 
		Player::unmountItem(%player,$WeaponSlot);
}

//===================================================================================

$InvList[MitziCharger] = 1;
$RemoteInvList[MitziCharger] = 1;

$ItemMax[harmor, MitziCharger] = 1;
$ItemMax[marmor, MitziCharger] = 1;
$ItemMax[mfemale, MitziCharger] = 1;
$ItemMax[larmor, MitziCharger] = 1;
$ItemMax[lfemale, MitziCharger] = 1;
$ItemMax[BlastechF, MitziCharger] = 1;
$ItemMax[BlastechM, MitziCharger] = 1;
$ItemMax[MagIonM, MitziCharger] = 1;
$ItemMax[MagIonF, MitziCharger] = 1;
$ItemMax[MECH, MitziCharger] = 1;

ItemImageData MitziChargerImage
{
	shapeFile = "dsply_s2";
//	shapeFile = "dsply_s1";
//	shapeFile = "mineammo";
	weaponType = 2;  // Sustained

	mountPoint = 2;
	mountOffset = { 0, 0.06, -0.4 };
//	mountRotation = { 1.57, 0, 0 };
	minEnergy = -1;
 	maxEnergy = -5;
	firstPerson = false;
};

ItemData MitziCharger
{
	shapeFile = "dsply_s2";
	description = "ReCharger";
//	shapeFile = "dsply_s1";
//	shapeFile = "mineammo";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = MitziChargerImage;
	price = 8000;
	hudIcon = "bigfear";
//	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};
function MitziCharger::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Faster recharging for your <f2>Mitzi Cannon<f1>, <f2>Marlowe Bazooka<f1>, and\n<jc>ALL <f2>Heavy Weapons<f1>.", 7);
}

function MitziChargerImage::onActivate(%player,%imageSlot)
{
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);
	if (%playerId.WeapRchgr == 0)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>2 times<f1> faster on the <f2>Mitzi Cannon<f1>, <f2>Marlowe Bazooka<f1>, and ALL <f2>Heavy Weapons<f1>.", 7);
	}
	else if (%playerId.WeapRchgr == 1)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>5 times<f1> faster on the <f2>Mitzi Cannon<f1>\n<jc><f2>1.25 times<f1> faster on the <f2>Marlowe Bazooka<f1> and ALL <f2>Heavy Weapons<f1>", 7);
	}
	else if (%playerId.WeapRchgr == 2)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>5 times<f1> faster on the <f2>Marlowe Bazooka<f1>\n<jc><f2>1.25 times<f1> faster on the <f2>Mitzi Cannon<f1> and ALL <f2>Heavy Weapons<f1>.", 7);
	}
	else if (%playerId.WeapRchgr == 3)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>5 times<f1> faster on ALL <f2>Heavy Weapons<f1>\n<jc><f2>1.25 times<f1> faster on the <f2>Marlowe Bazooka<f1> and <f2>Mitzi Cannon<f1>.", 7);
	}
}

function MitziChargerImage::onDeactivate(%player,%imageSlot)
{
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);
	if (%playerId.WeapRchgr == 0)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>2 times<f1> faster on the <f2>Mitzi Cannon<f1>, <f2>Marlowe Bazooka<f1>, and ALL <f2>Heavy Weapons<f1>.", 7);
	}
	else if (%playerId.WeapRchgr == 1)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>5 times<f1> faster on the <f2>Mitzi Cannon<f1>\n<jc><f2>1.25 times<f1> faster on the <f2>Marlowe Bazooka<f1> and ALL <f2>Heavy Weapons<f1>", 7);
	}
	else if (%playerId.WeapRchgr == 2)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>5 times<f1> faster on the <f2>Marlowe Bazooka<f1>\n<jc><f2>1.25 times<f1> faster on the <f2>Mitzi Cannon<f1> and ALL <f2>Heavy Weapons<f1>.", 7);
	}
	else if (%playerId.WeapRchgr == 3)
	{
		Bottomprint(%client, "<jc><f1>Current Setting: <f2>5 times<f1> faster on ALL <f2>Heavy Weapons<f1>\n<jc><f2>1.25 times<f1> faster on the <f2>Marlowe Bazooka<f1> and <f2>Mitzi Cannon<f1>.", 7);
	}
}

//===================================================================================

$InvList[GravFieldPack] = 1;
$RemoteInvList[GravFieldPack] = 0;

$ItemMax[harmor, GravFieldPack] = 1;
$ItemMax[marmor, GravFieldPack] = 0;
$ItemMax[mfemale, GravFieldPack] = 0;
$ItemMax[larmor, GravFieldPack] = 0;
$ItemMax[lfemale, GravFieldPack] = 0;
$ItemMax[BlastechF, GravFieldPack] = 0;
$ItemMax[BlastechM, GravFieldPack] = 0;
$ItemMax[MagIonM, GravFieldPack] = 0;
$ItemMax[MagIonF, GravFieldPack] = 0;
$ItemMax[MECH, GravFieldPack] = 1;

ItemImageData FullGravImage
{
	shapeFile = "discb";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mass = -6;
	firstPerson = false;
};

ItemData FullGrav
{
	description = "Gravitron Field Pack is ON";
	shapeFile = "force";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = FullGravImage;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

ItemImageData PartialGravImage
{
	shapeFile = "plasma";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mass = -3;
	firstPerson = false;
};

ItemData PartialGrav
{
	description = "Gravitron Field Pack is Partially ON";
	shapeFile = "force";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = PartialGravImage;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

ItemImageData HoverGravImage
{
	shapeFile = "repairgun";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	firstPerson = false;
};

ItemData HoverGrav
{
	description = "Hover Effect is ON";
	shapeFile = "force";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = HoverGravImage;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

ItemImageData GravFieldPackI
{
	shapeFile = "liqcyl";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mountOffset = { 0, 0, -0.56 };
//	mass = -8;
	minEnergy = 5;
 	maxEnergy = -2;
//	minEnergy = -1;
// 	maxEnergy = -2;
	firstPerson = false;
};

ItemData GravFieldPack
{
	description = "Gravitron Field Pack";
	shapeFile = "liqcyl";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = GravFieldPackI;
	price = 12500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function GravFieldpack::onMount(%player,%item)
{
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);
	if (%playerId.grav == 0)
	{
	        Bottomprint(%client, "<jc><f1>" @ %item.description @ " \nProvides a powerful gravity field.  Current Setting:  <f0>Full Anti-Gravity <f1>.\nAdds negative mass of 6 to your armor.  Turrets target you more now, though.", 10);
	}
	else if (%playerId.grav == 1)
	{
	      Bottomprint(%client, "<jc><f1>" @ %item.description @ " \nProvides a powerful gravity field.  Current Setting:  <f0>Hover Field<f1>.\nNegates the pull of gravity around you, allowing you to <f0>Hover<f1> in midair.\nTurrets target you more now, though.", 10);
	}	
	else if (%playerId.grav == 2)
	{
	        Bottomprint(%client, "<jc><f1>" @ %item.description @ " \nProvides a minor gravity field.\nCurrent Setting:  <f0>Partial Anti-Grav plus Sensor Jamming<f1>.\nA lesser <f0>Anti-Gravity field<f1> plus <f0>Sensor Jamming<f1> aids you in flying\nwithout the annoying turrets firing at you all the time.", 10);
	}	
}

function HoverGrav(%client, %player)
{
	%clientId = Player::getClient(%player);
	%client = Player::getClient(%player);
	if(Player::getMountedItem(%client,$ExtraWeaponSlotC) == HoverGrav)
	{
		Item::setVelocity(%player, "0 0 1.15"); // Gravity "null-zone" is a constant 1.13 - 1.15 vel upwards; keeps you inplace instead of moving you down.
//		Player::applyImpulse(%client, Vector::getFromRot(GameBase::getRotation(%player),0,3.53));
//		%energy = GameBase::getEnergy(%player);
//		%energy -= 0.15;
//		GameBase::setEnergy(%player,%energy); 
		schedule("HoverGrav(" @ %client @ ", " @ %player @ ");",0.01,%player);
	}
	else if(Player::getMountedItem(%client,$ExtraWeaponSlotC) == PartialGrav)
	{
//		%energy = GameBase::getEnergy(%player);
//		%energy += 0.25;
//		GameBase::setEnergy(%player,%energy); 
		Player::setSensorSupression(%player,2);
		schedule("HoverGrav(" @ %client @ ", " @ %player @ ");",0.1,%player);
	}
}

function GravFieldPackI::onActivate(%player,%imageSlot)
{
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);
	%armor = Player::getArmor(%player);
	Player::unmountItem(%player,$ExtraWeaponSlotC);
	Player::setSensorSupression(%player,0);
	if (%playerId.grav == 0)
	{
		Player::mountItem(%player,FullGrav,$ExtraWeaponSlotC);
		Client::sendMessage(Player::getClient(%player),0,"Gravitron Field is FULLY active.");
	}
	else if (%playerId.grav == 1)
	{
		Player::mountItem(%player,HoverGrav,$ExtraWeaponSlotC);
		Client::sendMessage(Player::getClient(%player),0,"Hover force is active.");
		HoverGrav(%client, %player);
	}	
	else if (%playerId.grav == 2)
	{
		Player::mountItem(%player,PartialGrav,$ExtraWeaponSlotC);
		Client::sendMessage(Player::getClient(%player),0,"Gravitron Field is PARTIALLY active with some Sensor Jamming.");
		HoverGrav(%client, %player);
	}	
}

function GravFieldPackI::onDeactivate(%player,%imageSlot)
{
	Player::setSensorSupression(%player,0);
	Player::unmountItem(%player,$ExtraWeaponSlotC);
	Client::sendMessage(Player::getClient(%player),2,"Gravitron Field is OFF.");
	Player::trigger(%player,$BackpackSlot,false);
}

//===================================================================================

ItemImageData RepairPackImage
{
	shapeFile = "armorPack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = 0;
	maxEnergy = -100;   // Energy used/sec for sustained weapons
//	maxEnergy = 0;   // Energy used/sec for sustained weapons
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData RepairPack
{
	description = "Repair Pack";
	shapeFile = "armorPack";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = RepairPackImage;
	price = 125;
	hudIcon = "repairpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function RepairPack::onUnmount(%player,%item)
{
	if (Player::getMountedItem(%player,$WeaponSlot) == RepairGun) {
		Player::unmountItem(%player,$WeaponSlot);
	}
}

function RepairPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		%armor = Player::getArmor(%player);
		if (%armor == "marmor" || %armor == "mfemale")
		{
			Player::mountItem(%player,AODSuperRGun,$WeaponSlot); 
		}
		else
		{
			Player::mountItem(%player,RepairGun,$WeaponSlot); 
		}
	}
}

function RepairPack::onDrop(%player,%item)
{
	if($matchStarted) {
		%mounted = Player::getMountedItem(%player,$WeaponSlot);
		if (%mounted == RepairGun) {
			Player::unmountItem(%player,$WeaponSlot);
		}
		else {
			// Remount the existing weapon to make sure the RepairGun
			// is not on the delayed mount "stack".
			Player::mountItem(%player,%mounted,$WeaponSlot);
		}
		Item::onDrop(%player,%item);
	}
}	

//===================================================================================

//*************************************
// AAOD Mod BACKPACK Kit
//*************************************
//----------------------------------------------------------------------------
// ====================================
//		**** SuperRepair Pack ****
// ++++++++++++++++++++++++++++++++++++
//	Repairs Items Very Fast
//	Occupies 2 Slots BackPack & Flag
//	Can only Be unmounted At Inventory Station
//	Has 4 x The Range of normal repair bolts
//	Has 2 x the repair speed of normal Packs
//	Uses 11/3 the energy

$InvList[AODSuperRPack]			= 1;
$RemoteInvList[AODSuperRPack]		= 1;

$ItemMax[larmor, AODSuperRPack] = 0;
$ItemMax[lfemale, AODSuperRPack] = 0;
$ItemMax[marmor, AODSuperRPack] = 1;
$ItemMax[mfemale, AODSuperRPack] = 1;
$ItemMax[harmor, AODSuperRPack] = 1;
$ItemMax[BlastechF, AODSuperRPack] = 0;
$ItemMax[BlastechM, AODSuperRPack] = 0;
$ItemMax[MagIonM, AODSuperRPack] = 1;
$ItemMax[MagIonF, AODSuperRPack] = 1;
$ItemMax[MECH, AODSuperRPack] = 1;

ItemImageData SuperRPackImage
{	
	shapeFile		= "armorPack";
	mountPoint		= 2;
	weaponType		= 2;  // Sustained
	minEnergy		= 0;
	maxEnergy		= 0;   // Energy used/sec for sustained weapons
  	mountOffset		= { 0, -0.05, 0 };
  	mountRotation	= { 0, 0, 0 };
	firstPerson		= false;
};

ItemData AODSuperRPack
{	description		= "Super-Repair Pack";
	shapeFile		= "armorPack";
	className		= "Backpack";
	heading		= "kBackpacks";
	shadowDetailMask  = 4;
	imageType		= SuperRPackImage;
	price			= 750;
	hudIcon		= "repairpack";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

ItemImageData SuperR2Image
{	shapeFile		= "armorPack";
	mountPoint		= 2;
	weaponType		= 2;  // Sustained
	minEnergy		= 0;
	maxEnergy		= 0;   // Energy used/sec for sustained weapons
  	mountOffset		= { 0, -0.05, -0.10 };
  	mountRotation	= { 0, 3.14159, -0.015 };
	firstPerson		= false;
};

ItemData SuperR2Pack
{	description		= "Super-Repair Pack";
	shapeFile		= "armorPack";
	className		= "Backpack";
	heading		= "eBackpacks";
	shadowDetailMask  = 4;
	imageType		= SuperR2Image;
	hudIcon		= "repairpack";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

ItemImageData SuperRGunImage
{	shapeFile		= "repairgun";
	mountPoint		= 0;
	mountOffset		= { -0.15, 0, 0 };
	mountRotation	= { 0, 1.57, 0};
	weaponType		= 2;	// Sustained
	projectileType	= SuperRBolt;
	minEnergy		= 3;
	maxEnergy		= 13;	// Energy used/sec for sustained weapons
	lightType		= 3;	// Weapon Fire
	lightRadius		= 1;
	lightTime		= 1;
	lightColor		= { 0.25, 1, 0.25 };
	sfxActivate		= SoundPickUpWeapon;
	sfxFire			= SoundSuperRepair;
};

ItemData AODSuperRGun
{	description		= "Super-Repair Gun";
	shapeFile		= "repairgun";
	className		= "Weapon";
	shadowDetailMask  = 4;
	imageType		= SuperRGunImage;
	showInventory	= false;
	price			= 150;
};

function AODSuperRPack::onUnmount(%player,%item)
{	if (Player::getMountedItem(%player,$WeaponSlot) == AODSuperRGun) 
	{	Player::unmountItem(%player,$WeaponSlot);
	}
	Player::UnMountItem(%player,$FlagSlot);
}

function AODSuperRPack::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	Player::mountItem(%player,%item,$BackpackSlot);
	
	}
	else
	{	Player::mountItem(%player,AODSuperRGun,$WeaponSlot);
	}
}

function AODSuperRPack::onMount(%player,%item)
{	Player::mountItem(%player,SuperR2Pack,$FlagSlot);
}

function AODSuperRPack::onDrop(%player,%item)
{	%client = Player::getClient(%player);
	Client::SendMessage(%client,0,"Unable to DROP this type of pack. Must be sold at an inventory station~wAAODSFX14.WAV");
}	

function AODSuperRGun::onMount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,true);
	Player::trigger(%player,$FlagSlot,true);

        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Very rapidly repairs you, teammates and your stuff.\n<jc>It also acts as a heat sink so those Rocket turrets won't fire at you.", 10);
}

function AODSuperRGun::onUnmount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,false);
	Player::trigger(%player,$FlagSlot,false);
}

//******************************************************
//				End Super Repair Pack
//******************************************************

//===================================================================================

ItemImageData autoPackImage
{
	shapeFile = "rocket";
	mountPoint = 2;
	mountOffset = { 0, 0, 0.25 };
	mountRotation = { 1.57, 0, 0 };
	weaponType = 2;  // Sustained
	minEnergy = -1;
	maxEnergy = -2;   // Energy/sec for sustained weapons
	mass = -2;
//	sfxFire = SoundElfFire;
	firstPerson = false;
};

ItemData AutoPack
{
	description = "Rocket Assist";
	shapeFile = "rocket";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = AutoPackImage;
	price = 1250;
	hudIcon = "shieldpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AutoPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Attaches a micro-rocket to the shells lobbed from the <f2>Grenade Launcher<f1> and <f2>Mortar<f1>.\nWhen <f0>activated<f1>, it provides extra bursts for jetting.  It has an exta-efficient\nexhaust to keep unwanted smoke away.", 10);
}

function AutoPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Extra Jet Boosting: ON");
	checkJetBoost(%player);
}

function checkJetBoost(%player)
{
	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "AutoPack") 
	{
//		GiveKickback(%player, %strength, %lift); positive strength goes backwards
		GiveKickback(%player, -150, 150);
		%pos = GameBase::getPosition(%player);
		playSound (SoundFireSeeking, %pos);
		schedule("checkJetBoost(" @ %player @ ");", 2.0,%player);
	}
}

function AutoPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Extra Jet Boosting: OFF");
	Player::trigger(%player,$BackpackSlot,false);
}

$InvList[AutoPack] = 1;
$RemoteInvList[AutoPack] = 1;

$ItemMax[harmor, AutoPack] = 1;
$ItemMax[marmor, AutoPack] = 1;
$ItemMax[mfemale, AutoPack] = 1;
$ItemMax[larmor, AutoPack] = 1;
$ItemMax[lfemale, AutoPack] = 1;
$ItemMax[BlastechF, AutoPack] = 1;
$ItemMax[BlastechM, AutoPack] = 1;
$ItemMax[MagIonM, AutoPack] = 1;
$ItemMax[MagIonF, AutoPack] = 1;
$ItemMax[MECH, AutoPack] = 1;

//===================================================================================

ItemImageData ShieldPackImage
{
	shapeFile = "shieldPack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = 0;
	maxEnergy = 1;   // Energy/sec for sustained weapons
//	minEnergy = 4;
//	maxEnergy = 9;   // Energy/sec for sustained weapons
	sfxFire = SoundShieldOn;
	firstPerson = false;
};

ItemData ShieldPack
{
	description = "Shield Pack";
	shapeFile = "shieldPack";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = ShieldPackImage;
	price = 175;
	hudIcon = "shieldpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function ShieldPack::onMount(%player,%item)
{
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc><f1>Shielding that is varied based on what armor you are wearing.\n<jc>Seems to give complete immunity to Standard Mitzi Blast, Lasers, & PBW. ", 10);
//	Bottomprint(%client, "<jc><f1>Shields you from most nasty attacks. It even gives you partial shields while OFF.\n<jc>Seems to give complete immunity to Standard Mitzi Blast, Lasers, & PBW. ", 10);
}

function ShieldPackImage::onActivate(%player,%imageSlot)
{
	%armor = Player::getArmor(%player);
	Client::sendMessage(Player::getClient(%player),0,"Shield On");
	if(%armor == "MECH")
	{	%player.shieldStrength = 0.013;
	}
	else if(%armor == "harmor" || %armor == "marmor" || %armor == "mfemale")
	{	%player.shieldStrength = 0.01;
	}
	else if(%armor == "BlastechM" || %armor == "BlastechF" || %armor == "MagIonM" || %armor == "MagIonF")
	{	%player.shieldStrength = 0.015;
	}
	else if(%armor == "larmor" || %armor == "lfemale")
	{	%player.shieldStrength = 0.02;
	}
}

function ShieldPackImage::onDeactivate(%player,%imageSlot)
{
	%armor = Player::getArmor(%player);
	Player::trigger(%player,$BackpackSlot,false);
	%player.shieldStrength = 0;
	
//	if(%armor != "MECH")
//	{	%player.shieldStrength = 0;
//		Client::sendMessage(Player::getClient(%player),0,"Shield Off");
//	}
//	else
//	{	%player.shieldStrength = 0.001;
//		Client::sendMessage(Player::getClient(%player),0,"Shield mostly Off");
//	}
}

//===================================================================================

$InvList[SShieldPack] = 1;
$RemoteInvList[SShieldPack] = 1;

$ItemMax[harmor, SShieldPack] = 1;
$ItemMax[marmor, SShieldPack] = 1;
$ItemMax[mfemale, SShieldPack] = 1;
$ItemMax[larmor, SShieldPack] = 1;
$ItemMax[lfemale, SShieldPack] = 1;
$ItemMax[BlastechF, SShieldPack] = 1;
$ItemMax[BlastechM, SShieldPack] = 1;
$ItemMax[MagIonM, SShieldPack] = 0;
$ItemMax[MagIonF, SShieldPack] = 0;
$ItemMax[MECH, SShieldPack] = 1;

ItemImageData SShieldPackImage
{
	shapeFile = "dsply_s1";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = 5;
	maxEnergy = 11;   // Energy/sec for sustained weapons
	sfxFire = SoundShieldOn;
	firstPerson = false;
	mass = 10;
};

ItemData SShieldPack
{
	description = "Super Shield Pack";
	shapeFile = "dsply_s1";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = SShieldPackImage;
	price = 13175;
	hudIcon = "shieldpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SShieldPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>This is the ULTIMATE Base Defender Pack.  Shield strength is AWESOME!!\n<jc>But the weight of it is awesome, too.\n<jc>It also ATTRACTS missiles from turrets.\n<jc>And you are immune to <f0>* * HELLFIRE * *<f1>.", 10);
}

function SShieldPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Super Shield On");
	%player.shieldStrength = 0.5;
	Xi::initDeCloak(%player);
}

function SShieldPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Super Shield Off");
	Player::trigger(%player,$BackpackSlot,false);
	%player.shieldStrength = 0;
}

function Xi::initDeCloak(%player)
{
	if(Player::isTriggered(%player,$BackpackSlot))
	{
		if(Player::getMountedItem(%player,$BackpackSlot) == SShieldPack)
		{
			%team = GameBase::getTeam(%player);
			%set = newObject("set",SimSet);
			%pos = GameBase::getPosition(%player);
			%armor = Player::getArmor(%player);
			%playerId = Player::getClient(%player);
			if (%armor == "larmor" || %armor == "lfemale")
			{
				$Xi::DeCloakFieldSize = 90; 	// How big the DeCloak field is for each player.
			}
			else if (%armor == "BlastechM" || %armor == "BlastechF")
			{
				$Xi::DeCloakFieldSize = 55; 	// How big the DeCloak field is for each player.
			}
			else if (%armor == "MagIonM" || %armor == "MagIonF")
			{
				$Xi::DeCloakFieldSize = 85; 	// How big the DeCloak field is for each player.
			}
			else if (%armor == "marmor" || %armor == "mfemale")
			{
				$Xi::DeCloakFieldSize = 150; 	// How big the DeCloak field is for each player.
			}
			else if(%armor == "MECH")
			{
				$Xi::DeCloakFieldSize = 70; 	// How big the DeCloak field is for each player.
			}
			else if(%armor == "harmor")
			{
				$Xi::DeCloakFieldSize = 80; 	// How big the DeCloak field is for each player.
			}

			containerBoxFillSet(%set,$SimPlayerObjectType | $MineObjectType | $ItemObjectType | $StaticObjectType | $VehicleObjectType | $MoveableObjectType,%pos,$Xi::DeCloakFieldSize,$Xi::DeCloakFieldSize,$Xi::DeCloakFieldSize,0);
			%count = Group::objectCount(%set);

			if(%count)
      		{ 
				for(%i; %i < %count; %i++)
				{
					%tgt = Group::getObject(%set,%i);
					%tgtTeam = GameBase::getTeam(%tgt);
					%target = Group::getObject(%set, %count); 

					if(%team != %tgtTeam) // no TK DeCloaking :)
					{
						%tgtName = GameBase::getDataName(%tgt);

						if($cloaked[%tgt] == 1)
						{
							GameBase::startFadein(%tgt);
							Player::setSensorSupression(%tgt,0);
	 						$cloaked[%tgt] = 0;
							Cloaker(%tgt);
						}

						if(%tgtName == CloakingNode) 
						{
							%pos = GameBase::getPosition(%tgt);
							GameBase::applyDamage(%tgt,$NullDamageType,1.25,%pos,"0 0 0","0 0 0",%player);
						}

						if(%tgtName == Explorer)
						{
							GameBase::startFadeIn(%tgt);
						}

					}
				}
			}
		      deleteObject(%set); // no need for the set anymore, killit()
			schedule("Xi::initDeCloak(" @ %player @ ");", 0.05,%player); // 20x per second or 2x per 1/10th second
		}
	}
}

//===================================================================================

ItemImageData SensorJammerPackImage
{
	shapeFile = "vehi_pur_pnl";
//	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = -1;
 	maxEnergy = -4;
	mass		= -3;
	sfxFire = SoundJammerOn;
	mountOffset = { 0, 0.15, -0.6 };
//  	mountOffset = { 0, 0, 0 };
//  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData SensorJammerPack
{
	description = "Amazing Stuff";
	shapeFile = "vehi_pur_pnl";
//	shapeFile = "sensorjampack";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = SensorJammerPackImage;
	price = 20000;
	hudIcon = "sensorjamerpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SensorJammerPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
   Bottomprint(%client, "<jc><f1>The Amazing Stuff pack is a combination of most of the other packs.\n<jc>It includes lesser abilities of -- Energy,Shield,Autorepair,Command,AmmoGen,\n<jc>Grav, and Missile Targeting. It has a tendency to attract missiles, too. ", 20);
}

function SensorJammerPackImage::onActivate(%player,%imageSlot)
{
	%clientId = Player::getClient(%player);
	%client = Player::getClient(%player);
	if ($amazingrecycleTime[%client] == 0)  
	{
		Client::sendMessage(Player::getClient(%player),0,"Amazing Stuff is WORKING!!");
		%player.AmmoGenCounter = 0;
		%player.ammogenActive = "true";
		ammogenImage::RegenerateAmmo(%player);
		%player.CommandTag = 1;
		gameBase::setAutoRepairRate(%player, 0.1);
		%player.shieldStrength = 0.0075;  
		Player::trigger(%player,$BackpackSlot,true);
		schedule("checkPlayerAmazing(" @ %client @ ", " @ %player @ ");",5,%player);
		if($cloakTime[%clientId] > 0)
		{
			%clientid.beaconCloak = false;
			GameBase::playSound(%player,ForceFieldClose,0);
			GameBase::startFadein(%player);
			%rate = Player::getSensorSupression(%player) - 1;
			Player::setSensorSupression(%player,0);
		 	$cloaked[%player] = 0;
			Cloaker(%player);
			$cloakTime[%clientId] = 0;  
		}
		$amazingTime[%client] = 100;
	}
	else
	{
		Client::sendMessage(Player::getClient(%player),0,"Amazing Stuff needs to rest.");
		Player::trigger(%player,$BackpackSlot,false);
	}
}

function SensorJammerPackImage::onDeactivate(%player,%imageSlot)
{
	%client = Player::getClient(%player);
	Client::sendMessage(Player::getClient(%player),0,"Amazing Stuff is on STANDBY");
	Player::trigger(%player,$BackpackSlot,false);
	$AmazingTime[%client] = 0;
	%player.ammogenActive = "false";
	%player.CommandTag = 0;
	gameBase::setAutoRepairRate(%player, 0);
	%player.shieldStrength = 0;    
}

function SensorJammerPack::onDrop(%player, %item)
{
	%client = Player::getClient(%player);
	if($amazingoverload[%client] == 5)
	{
            %obj = newObject("Deployable Mortar","Mine","TNTAmazing");
            addToSet("MissionCleanup", %obj);
            %client = Player::getClient(%player);
            GameBase::throw(%obj,%player,3 * %client.throwStrength,false);
		$amazingoverload[%client] = 0;

		Client::sendMessage(Player::getClient(%player),0,"Amazing Stuff is loose in the world");
		%player.ammogenActive = "false";
		%player.CommandTag = 0;
		%player.shieldStrength = 0;
		gameBase::setAutoRepairRate(%player, 0);

		Item::onDropAmazing(%player,%item);
	}
	else
	{
		Client::sendMessage(Player::getClient(%player),0,"Amazing Stuff is loose in the world");
		%player.ammogenActive = "false";
		Item::onDrop(%player,%item);
		%player.CommandTag = 0;
		%player.shieldStrength = 0;
		gameBase::setAutoRepairRate(%player, 0);
	}

}

function checkPlayerAmazing(%client, %player)
{
		%clientId = Player::getClient(%player);
		%client = Player::getClient(%player);
	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "SensorJammerPack") 
	{
		if($AmazingTime[%client] > 0 && $amazingoverload[%client] != 5)
		{
			$AmazingTime[%client] -= 2;  
			schedule("checkPlayerAmazing(" @ %client @ ", " @ %player @ ");",2,%player);
			%rnd = floor(getRandom() * 10);
			 if(%rnd > 8)
			 {
				Client::sendMessage(Player::getClient(%player),2,"Amazing Stuff is checking its' integrity.");
			 }

			if($cloakTime[%clientId] > 0)
			{
				%clientid.beaconCloak = false;
				GameBase::playSound(%player,ForceFieldClose,0);
				GameBase::startFadein(%player);
				%rate = Player::getSensorSupression(%player) - 1;
				Player::setSensorSupression(%player,0);
			 	$cloaked[%player] = 0;
 				Cloaker(%player);
				$cloakTime[%clientId] = 0;  
			}

			%rnd = floor(getRandom() * 100);
			%playerId = Player::getClient(%player);
			 if(%rnd > 95)
			 {
				Client::sendMessage(Player::getClient(%player),2,"Amazing Stuff has OVERLOADED!!  She's going to BLOW!!!!");
				GameBase::playSound(%player,bigExplosion1,0);
				$amazingoverload[%client] = 5;
				SensorJammerPack::Detonate(%client, 6);

				%player.ammogenActive = "false";
				%player.CommandTag = 0;
				gameBase::setAutoRepairRate(%player, 0);
				%player.shieldStrength = 0;    
				Player::trigger(%player,$BackpackSlot,false);

		 	}

    		}
		else
		{
			Client::sendMessage(Player::getClient(%player),1,"Amazing Stuff is pooped!  Let it rest for 30 seconds.");
			%player.ammogenActive = "false";
			%player.CommandTag = 0;
			gameBase::setAutoRepairRate(%player, 0);
			%player.shieldStrength = 0;    
			$amazingrecycleTime[%client] = 30;
			SensorJammerPack::Charge(%client, 30);
			Player::trigger(%player,$BackpackSlot,false);
		}			
	}
}

function SensorJammerPack::Charge(%client, %time)
{
	if (%time > 0)
	{
		%time--;
		schedule("SensorJammerPack::Charge(" @ %client @", " @ %time @ ");",1.0);
		BottomPrint (%client, "** " @ %time @ " seconds before Amazing Stuff is ready  ", 1);
		return;
	}

	else
	{
			$amazingrecycleTime[%client] = 0;  
			BottomPrint (%client, "                   Amazing Stuff is ready to KICK ASS!!!!!", 6);
		return;
	}
}

function SensorJammerPack::Detonate(%client, %time)
{
	if($amazingoverload[%client] == 5)
	{
		if (%time > 0)
		{
			%time--;
			schedule("SensorJammerPack::Detonate(" @ %client @", " @ %time @ ");",1.0);
			bottomprint (%client, "<jc>** ETA to overload: " @ %time @ " seconds", 1);	
		}
		else 
		{
			Player::decItemCount(%player,SensorJammerPack,1); //should get rid of it so others cant get it
			$amazingoverload[%client] = 0;
			Player::blowUp(%client);
			%obj = newObject("","Mine","HavocBlast");
			GameBase::throw(%obj,%client,0,false);		
			addToSet("MissionCleanup", %obj);
			%padd = "0 0 1.5";
			%pos = Vector::add(GameBase::getPosition(%client), %padd);
			GameBase::setPosition(%obj, %pos);

			return;
		}
	}
	else
	{
		$amazingoverload[%client] = 0;
	}
}

//===================================================================================

//----------------------------------------------------------------------------
// Cloaking Device - INH*DynaBlade
//----------------------------------------------------------------------------

$InvList[CloakingDevice] = 1;
$RemoteInvList[CloakingDevice] = 1;

$ItemMax[harmor, CloakingDevice] = 0;
$ItemMax[marmor, CloakingDevice] = 1;
$ItemMax[mfemale, CloakingDevice] = 1;
$ItemMax[larmor, CloakingDevice] = 1;
$ItemMax[lfemale, CloakingDevice] = 1;
$ItemMax[BlastechF, CloakingDevice] = 1;
$ItemMax[BlastechM, CloakingDevice] = 1;
$ItemMax[MagIonM, CloakingDevice] = 1;
$ItemMax[MagIonF, CloakingDevice] = 1;
$ItemMax[MECH, CloakingDevice] = 0;

ItemImageData CloakingDeviceImage
{
	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 9;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData CloakingDevice
{
	description = "3Dfx Cloaking Device";
	shapeFile = "sensorjampack";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = CloakingDeviceimage;
	price = 600;
	hudIcon = "sensorjamerpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function CloakingDevice::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>The Cloak renders you invisible to all enemy players,save those running in software mode.\n<jc>Also, most turrets can't sense you, except the motion sensing ones. ", 10);
}

function CloakingDeviceImage::onActivate(%player,%imageSlot)
{
	%radius = Player::getSensorSupression(%player) + 1;
	Player::setSensorSupression(%player,%radius);
	GameBase::playSound(%player,ForceFieldOpen,0);
 	GameBase::startFadeout(%player);
 	$cloaked[%player] = 1;
 	Cloaker(%player);
 	%ClientId = Player::getClient(%player);
	Client::sendMessage(Player::getClient(%player),0,"Cloaking Device On");
	Player::trigger(%player,$BackpackSlot,true);
}

function CloakingDeviceImage::onDeactivate(%player,%imageSlot)
{
	%radius = Player::getSensorSupression(%player) - 1;
	Player::setSensorSupression(%player,%radius);
	GameBase::playSound(%player,ForceFieldClose,0);
 	GameBase::startFadein(%player);
 	$cloaked[%player] = 0;
 	Cloaker(%player);
	Client::sendMessage(Player::getClient(%player),0,"Cloaking Device Off");
	Player::trigger(%player,$BackpackSlot,false);
}

//===================================================================================

ItemImageData AmmoPackImage
{
	shapeFile = "AmmoPack";
	mountPoint = 2;
   mountOffset = { 0, -0.03, 0 };
//   mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData AmmoPack
{
	description = "Ammo Pack";
	shapeFile = "AmmoPack";
	className = "Backpack";
	heading = "kBackpacks";
	imageType = AmmoPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 325;
	hudIcon = "ammopack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AmmoPack::onMount(%player,%item)
{
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc><f1>Contains a HUGE amount of ammo.", 10);
}

function AmmoPack::onDrop(%player, %item)
{
	if($matchStarted) {
		%item = Item::onDrop(%player,%item);
		for(%i = 0; %i < 21 ; %i = %i +1) {
			%numPack = 0;
			%ammoItem = $AmmoPackItems[%i];
			%maxnum = $ItemMax[Player::getArmor(%player), %ammoItem];
			%pCount = Player::getItemCount(%player, %ammoItem);
			if(%pCount > %maxnum) {
				%numPack = %pCount - %maxnum;
				Player::decItemCount(%player,%ammoItem,%numPack);
			}	
			if(%i == 0) {
	 	    	%item.BulletAmmo = %numPack;
			}
			else if(%i == 1) {
	 	    	%item.PlasmaAmmo = %numPack;
			}
			else if(%i == 2) {
	 	    	%item.DiscAmmo = %numPack;
			}
			else if(%i == 3) {
	 	    	%item.GrenadeAmmo = %numPack;
			}
			else if(%i == 4) {
	 	    	%item.Grenade = %numPack;
			}
			else if(%i == 5) {
	 	    	%item.MineAmmo = %numPack;
			}
			else if(%i == 5) {
	 	    	%item.MortarAmmo = %numPack;
			}
			else if(%i == 6) {
	 	    	%item.PlasmaAmmo = %numPack;
			}
			else if(%i == 7) {
	 	    	%item.Beacon = %numPack;
			}
			else if(%i == 8) {
	 	    	%item.EMPGrenadeAmmo = %numPack;
			}
			else if(%i == 9) {
	 	    	%item.Darts = %numPack;
			}
			else if(%i == 10) {
	 	    	%item.GaussAmmo = %numPack;
			}
			else if(%i == 11) {
	 	    	%item.Bolts = %numPack;
			}
			else if(%i == 12) {
	 	    	%item.Mitzicore = %numPack;
			}
			else if(%i == 13) {
	 	    	%item.MinigunAmmo = %numPack;
			}
			else if(%i == 14) {
	 	    	%item.MMinigunAmmo = %numPack;
			}
			else if(%i == 15) {
	 	    	%item.Friskies = %numPack;
			}
			else if(%i == 16) {
	 	    	%item.JugAmmo = %numPack;
			}
			else if(%i == 17) {
	 	    	%item.tetbolts = %numPack;
			}
			else if(%i == 18) {
	 	    	%item.shells = %numPack;
			}
			else if(%i == 19) {
	 	    	%item.MrpgAmmo = %numPack;
			}
			else if(%i == 20) {
	 	    	%item.Pellets = %numPack;
			}
			else if(%i == 21) {
	 	    	%item.HvyWpnAmmo = %numPack;
			}
		}
	}
}

function AmmoPack::onCollision(%this,%object)
{
	if (getObjectType(%object) == "Player") {
		%item = Item::getItemData(%this);
		%count = Player::getItemCount(%object,%item);
		if (Item::giveItem(%object,%item,Item::getCount(%this))) {
			Item::playPickupSound(%this);
			checkPacksAmmo(%object, %this);
			Item::respawn(%this);
		}
	}
}

//===================================================================================

$InvList[AmmoGeneratorPack]			= 1;
$RemoteInvList[AmmoGeneratorPack]		= 1;

$ItemMax[lfemale, AmmoGeneratorPack]	= 1;
$ItemMax[mfemale, AmmoGeneratorPack]	= 1;
$ItemMax[larmor, AmmoGeneratorPack]		= 1;
$ItemMax[marmor, AmmoGeneratorPack]		= 1;
$ItemMax[harmor, AmmoGeneratorPack]		= 1;
$ItemMax[BlastechF, AmmoGeneratorPack] = 1;
$ItemMax[BlastechM, AmmoGeneratorPack] = 1;
$ItemMax[MagIonM, AmmoGeneratorPack] = 1;
$ItemMax[MagIonF, AmmoGeneratorPack] = 1;
$ItemMax[MECH, AmmoGeneratorPack] = 1;

ItemImageData AmmoGenI
{
	shapeFile = "ammopack";
	mountPoint = 2;
   mountOffset = { 0, -0.03, 0 };
   mountRotation = { 0, 1.57, 0 };
	weaponType = 2;  // Sustained
	minEnergy = 8;
	maxEnergy = 8;   // Energy/sec for sustained weapons
	firstPerson = false;
};

ItemData AmmoGeneratorPack
{
	description = "Ammo Generator";
	shapeFile = "ammopack";
	className = "Backpack";
	heading = "kBackpacks";
	imageType = AmmoGenI;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 1000;
	hudIcon = "ammogen";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AmmoGenI::onMount(%player,%item)
{
	%player.AmmoGenActive = "false";
	%player.AmmoGenCounter = 0;
}

function AmmoGeneratorPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
      Bottomprint(%client, "<jc><f1>Generates ammo for all weapons you carry, even the Mitzi Cannon.", 10);
}

function AmmoGenI::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),3,"Ammo Fabrication started...");
	%player.ammogenActive = "true";
	#Player::trigger(%player,$BackpackSlot,true);
	ammogenImage::RegenerateAmmo(%player);
}

function ammogenI::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),1,"Ammo Fabrication stopped");
	Player::trigger(%player,$BackpackSlot,false);
	%player.ammogenActive = "false";

}

function AmmoGen::onDrop(%player, %item)
{
	Client::sendMessage(Player::getClient(%player),1,"Ammo Fabrication stopped");
	Player::trigger(%player,$BackpackSlot,false);
	%player.ammogenActive = "false";
}

function AmmoGenI::onDrop(%player, %item)
{
	Client::sendMessage(Player::getClient(%player),1,"Ammo Fabrication stopped");
	Player::trigger(%player,$BackpackSlot,false);
	%player.ammogenActive = "false";
}

function ammogenImage::RegenerateAmmo(%player)
{
	%player.ammogenCounter++;

	if (checkResources(%player,BulletAmmo,1,1) > 0 && Player::getItemCount(%player,Chaingun) == 1) ammogenImage::resupply(%player,"ChainGun",BulletAmmo,1,2);
	else if (checkResources(%player,PlasmaAmmo,1,1) > 0 && Player::getItemCount(%player,PlasmaGun) == 1) ammogenImage::resupply(%player,"PlasmaGun",PlasmaAmmo,1,4);
	else if (checkResources(%player,DiscAmmo,1,1) > 0 && Player::getItemCount(%player,DiscLauncher) == 1) ammogenImage::resupply(%player,"DiscLauncher",DiscAmmo,1,4);
	else if (checkResources(%player,GrenadeAmmo,1,1) > 0 && Player::getItemCount(%player,GrenadeLauncher) == 1) ammogenImage::resupply(%player,"GrenadeLauncher",GrenadeAmmo,1,4);
	else if (checkResources(%player,MortarAmmo,1,1) > 0 && Player::getItemCount(%player,Mortar) == 1) ammogenImage::resupply(%player,"Mortar",MortarAmmo,1,10);
	else if (checkResources(%player,MinigunAmmo,1,1) > 0 && Player::getItemCount(%player,ChainRifle) == 1) ammogenImage::resupply(%player,"ChainRifle",MinigunAmmo,1,1);
	else if (checkResources(%player,MMinigunAmmo,1,1) > 0 && Player::getItemCount(%player,ChainCannon) == 1) ammogenImage::resupply(%player,"ChainCannon",MMinigunAmmo,1,1);
//	else if (checkResources(%player,GrenadeAmmo,1,1) > 0 && Player::getItemCount(%player,RPGLauncher) == 1) ammogenImage::resupply(%player,"RPGLauncher",GrenadeAmmo,1,4);
//	else if (checkResources(%player,MortarAmmo,1,1) > 0 && Player::getItemCount(%player,RPMLauncher) == 1) ammogenImage::resupply(%player,"RPMLauncher",MortarAmmo,1,10);
	else if (checkResources(%player,GaussAmmo,1,1) > 0 && Player::getItemCount(%player,Gauss) == 1) ammogenImage::resupply(%player,"Gauss",GaussAmmo,1,5);
	else if (checkResources(%player,Darts,1,1) > 0 && Player::getItemCount(%player,DartGun) == 1) ammogenImage::resupply(%player,"DartGun",Darts,1,5);	
	else if (checkResources(%player,Pellets,1,1) > 0 && Player::getItemCount(%player,Shotgun) == 1) ammogenImage::resupply(%player,"Shotgun",Pellets,1,5);	
	else if (checkResources(%player,Pellets,1,1) > 0 && Player::getItemCount(%player,DBShotgun) == 1) ammogenImage::resupply(%player,"DBShotgun",Pellets,1,5);	
	else if (checkResources(%player,MrpgAmmo,1,1) > 0 && Player::getItemCount(%player,LaserPistol) == 1) ammogenImage::resupply(%player,"LaserPistol",MrpgAmmo,1,5);
	else if (checkResources(%player,bolts,1,1) > 0 && Player::getItemCount(%player,massdriver) == 1) ammogenImage::resupply(%player,"massdriver",bolts,1,5);	
	else if (checkResources(%player,SXAmmo,1,1) > 0 && Player::getItemCount(%player,AAODSniperX) == 1) ammogenImage::resupply(%player,"AAODSniperX",SXAmmo,1,10);	
//	else if (checkResources(%player,JugAmmo,1,1) > 0 && Player::getItemCount(%player,JugLauncher) == 1) ammogenImage::resupply(%player,"JugLauncher",JugAmmo,1,100);
	else if (checkResources(%player,MitziCore,1,1) > 0 && Player::getItemCount(%player,MBcannon) == 1) ammogenImage::resupply(%player,"MBcannon",MitziCore,1,10);
	else if (checkResources(%player,Friskies,1,1) > 0 && Player::getItemCount(%player,CatGun) == 1) ammogenImage::resupply(%player,"CatGun",Friskies,1,10);
	else if (checkResources(%player,HvyWpnAmmo,1,1) > 0 && Player::getItemCount(%player,JugLauncher) == 1) ammogenImage::resupply(%player,"JugLauncher",HvyWpnAmmo,1,10);
	else if (checkResources(%player,HvyWpnAmmo,1,1) > 0 && Player::getItemCount(%player,MeteorCannon) == 1) ammogenImage::resupply(%player,"MeteorCannon",HvyWpnAmmo,1,10);
	else if (checkResources(%player,HvyWpnAmmo,1,1) > 0 && Player::getItemCount(%player,AnnihCannon) == 1) ammogenImage::resupply(%player,"AnnihCannon",HvyWpnAmmo,1,10);
	else if (checkResources(%player,HvyWpnAmmo,1,1) > 0 && Player::getItemCount(%player,PlasmaCannon) == 1) ammogenImage::resupply(%player,"PlasmaCannon",HvyWpnAmmo,1,10);
	else if (checkResources(%player,HvyWpnAmmo,1,1) > 0 && Player::getItemCount(%player,LasCannon) == 1) ammogenImage::resupply(%player,"LasCannon",HvyWpnAmmo,1,10);

	else if (checkResources(%player,Grenade,1,1) > 0 ) ammogenImage::resupply(%player,"",Grenade,1,25);
	else if (checkResources(%player,MineAmmo,1,1) > 0 ) ammogenImage::resupply(%player,"",MineAmmo,1,25);
	else if (checkResources(%player,RepairKit,1,1) > 0 ) ammogenImage::resupply(%player,"",RepairKit,1,60);
	else if (checkResources(%player,Beacon,1,1) > 0 ) ammogenImage::resupply(%player,"",Beacon,1,25);
//	else if (checkResources(%player,HvyWpnAmmo,1,1) > 0 ) ammogenImage::resupply(%player,"",HvyWpnAmmo,1,10);

	else 
		{
			%player.ammogenCounter = 0;
			Client::sendMessage(Player::getClient(%player),3,"Ammo level optimum--Fabrication complete.");
			%player.ammogenActive = "false";

       		%pack = Player::getMountedItem(%player,$BackpackSlot);
	      	if(%pack == "AmmoGeneratorPack")
                   {
			   Player::trigger(%player,$BackpackSlot,false);
                   }
		}
      if (%player.ammogenActive == "true") {
		  schedule("ammogenImage::RegenerateAmmo(" @ %player @ ");", 0.1,%player);
		}
}

function ammogenImage::resupply(%player,%weapon,%item,%delta,%genreq)
{
	if (%player.ammogenCounter >= %genreq) 
		{
			%delta = checkResources(%player,%item,%delta,1);		
			if(%delta > 0) {						
				Player::incItemCount(%player,%item,%delta);
				%player.ammogenCounter = 0;
	 			return %delta;
			}
			return 0;
	}
}

//-----------------------------------------------

function checkPacksAmmo(%player, %item)
{
	for(%i = 0; %i < 21 ; %i = %i +1) {
		%ammoItem = $AmmoPackItems[%i];
		if(%i == 0) {
 	    	%numAdd = %item.BulletAmmo;
		}
		else if(%i == 1) {
 	    	%numAdd = %item.PlasmaAmmo;
		}
		else if(%i == 2) {
 	    	%numAdd = %item.DiscAmmo;
		}
		else if(%i == 3) {
 	    	%numAdd = %item.GrenadeAmmo;
		}
		else if(%i == 4) {
 	    	%numAdd = %item.Grenade;
		}
		else if(%i == 5) {
 	    	%numAdd = %item.MineAmmo;
		}
		else if(%i == 5) {
 	    	%numAdd = %item.MortarAmmo;
		}
		else if(%i == 6) {
 	    	%numAdd = %item.PlasmaAmmo;
		}
		else if(%i == 7) {
 	    	%numAdd = %item.Beacon;
		}
		else if(%i == 8) {
 	    	%numAdd = %item.EMPGrenadeAmmo;
		}
		else if(%i == 9) {
 	    	%numAdd = %item.Darts;
		}
		else if(%i == 10) {
 	    	%numAdd = %item.GaussAmmo;
		}
		else if(%i == 11) {
 	    	%numAdd = %item.Bolts;
		}
		else if(%i == 12) {
 	    	%numAdd = %item.Mitzicore;
		}
		else if(%i == 13) {
 	    	%numAdd = %item.MinigunAmmo;
		}
		else if(%i == 14) {
 	    	%numAdd = %item.MMinigunAmmo;
		}
		else if(%i == 15) {
 	    	%numAdd = %item.Friskies;
		}
		else if(%i == 16) {
 	    	%numAdd = %item.JugAmmo;
		}
		else if(%i == 17) {
 	    	%numAdd = %item.tetbolts;
		}
		else if(%i == 18) {
 	    	%numAdd = %item.shells;
		}
		else if(%i == 19) {
 	    	%numAdd = %item.MrpgAmmo;
		}
		else if(%i == 20) {
 	    	%numAdd = %item.Pellets;
		}
		else if(%i == 21) {
 	    	%numAdd = %item.HvyWpnAmmo;
		}
		Player::incItemCount(%player,%ammoItem,%numAdd);
	}						 
}

function fillAmmoPack(%client)
{
	%player = Client::getOwnedObject(%client);
	for(%i = 0; %i < 21 ; %i = %i +1) {
		%item = $AmmoPackItems[%i];
		%maxnum = $AmmoPackMax[%item];
		%maxnum = checkResources(%player,%item,%maxnum); 
		if(%maxnum) {
			Player::incItemCount(%client,%item,%maxnum);
			teamEnergyBuySell(%player,%item.price * %maxnum * -1);

	}	
	}
}

//===================================================================================

//--------------------------------------------------
//		ADVANCED TARGETING PACK by: Valya[AAOD]
//--------------------------------------------------

$InvList[TargPack]		= 0;
$RemoteInvList[TargPack]	= 0;

$ItemMax[lfemale, TargPack]	= 1;
$ItemMax[mfemale, TargPack]	= 1;
$ItemMax[larmor, TargPack]	= 1;
$ItemMax[marmor, TargPack]	= 1;
$ItemMax[harmor, TargPack]	= 1;
$ItemMax[BlastechF, TargPack] = 1;
$ItemMax[BlastechM, TargPack] = 1;
$ItemMax[MagIonM, TargPack] 	= 1;
$ItemMax[MagIonF, TargPack] 	= 1;
$ItemMax[MECH, TargPack] 	= 1;

ItemImageData AODATPackImage
{
	shapeFile		= "radar_small";
	mountPoint		= 2;
	mountOffset		= { 0, -0.1, 0 };
	minEnergy		= 1;
 	maxEnergy		= 3;
	firstPerson		= false;
	mass			= 0.5;
};

ItemData TargPack
{
	description		= "Missile Targeting Pack";
	shapeFile		= "radar_small";
	classname		= "Backpack";
	heading			= "kBackpacks";
	shadowDetailMask = 4;
	imageType		= AODATPackImage;
	price			= 750;
	hudIcon			= "sensorjamerpack";
	showWeaponBar	= true;
	hiliteOnActive	= true;
	mass			= 0.5;
};

function TargPack::onUse(%player,%item)
{	
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	
	Player::mountItem(%player,%item,$BackpackSlot);
	}
}

function TargPack::onMount(%player,%item)
{	
	Player::trigger(%player,$BackpackSlot,true);
        %client = Player::getClient(%player);
      Bottomprint(%client, "<jc><f1>The Targeting pack makes the following weapons fire tracking projectiles\n<jc>Disc Launcher, Missile Launcher, RPG, and RPM.\n<jc>It also ATTRACTS missiles from turrets.\n<jc>You are immune to EMP & Heat blasts. ", 10);
}

function TargPack::onUnmount(%player,%item)
{
}

//===================================================================================

#--------------------------------------------------#
#=========Coyote Ear Pack by INH*DynaBlade=========#
#--------------------------------------------------#

$InvList[BugPack]			= 1;
$RemoteInvList[BugPack]		= 1;

$ItemMax[lfemale, BugPack]	= 1;
$ItemMax[mfemale, BugPack]	= 1;
$ItemMax[larmor, BugPack]	= 1;
$ItemMax[marmor, BugPack]	= 1;
$ItemMax[harmor, BugPack]	= 1;
$ItemMax[BlastechF, BugPack] 	= 1;
$ItemMax[BlastechM, BugPack] 	= 1;
$ItemMax[MagIonM, BugPack] 	= 1;
$ItemMax[MagIonF, BugPack] 	= 1;
$ItemMax[MECH, BugPack] 	= 1;

ItemImageData BugI
{	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 2;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData BugPack
{	description		= "ChatTap+SensorJamr"; // NOW you know what it is!
	shapeFile		= "sensorjamPack";
	classname		= "Backpack";
	heading		= "kBackpacks";
	shadowDetailMask  = 4;
	imageType		= BugI;
	price			= 1000;
	hudIcon = "shieldpack";
	showWeaponBar	= true;
	hiliteOnActive	= true;
//	mass			= 0.5;
};

function BugPack::onMount(%player,%item)
{	
        %client = Player::getClient(%player);
      Bottomprint(%client, "<jc><f1>Now you can listen in on the enemy team conversations and those people in Observer.\n<jc>Also acts as a 20 meter Sensor Jammer that is always on.\n<jc>And you are immune to POISON.", 10);
}

function BugI::onActivate(%player,%imageSlot)
{	
	Client::sendMessage(Player::getClient(%player),0,"Sensor Jammer On");
	%rate = Player::getSensorSupression(%player) + 20;
	Player::setSensorSupression(%player,%rate);
}

function BugI::onDeactivate(%player,%imageSlot)
{	
	Client::sendMessage(Player::getClient(%player),0,"Sensor Jammer Off");
	%rate = Player::getSensorSupression(%player) - 20;
	Player::setSensorSupression(%player,%rate);
	Player::trigger(%player,$BackpackSlot,false);
}

//===================================================================================

// 	AODCmdPack Backpack Script
$InvList[AODCmdPack]			= 1;
$RemoteInvList[AODCmdPack]		= 1;
$TeamItemMax[AODCmdPack]		= 99;

$ItemMax[larmor, AODCmdPack]	= 1;
$ItemMax[lfemale, AODCmdPack]	= 1;
$ItemMax[marmor, AODCmdPack]	= 1;
$ItemMax[mfemale, AODCmdPack]	= 1;
$ItemMax[harmor, AODCmdPack]	= 1;
$ItemMax[BlastechF, AODCmdPack] = 1;
$ItemMax[BlastechM, AODCmdPack] = 1;
$ItemMax[MagIonM, AODCmdPack] = 1;
$ItemMax[MagIonF, AODCmdPack] = 1;
$ItemMax[MECH, AODCmdPack] = 1;

ItemImageData AODCmdPackImage 
{
//	shapeFile = "flag";
	shapeFile = "CMDPNL";
	mountPoint		= 2;
	mountOffset = { 0, 0, -0.35 };
	mass = -2;
	lightType = 2;   // Pulsing
	lightRadius = 4;
	lightTime = 1.5;
	lightColor = { 1, 1, 1};
	firstPerson		= false;
};

ItemData AODCmdPack 
{
	description = "Turret Control pack";
	shapeFile = "CMDPNL";
	classname = "Backpack";
	heading = "kBackpacks";
	imageType = AODCmdPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 250;
	hudIcon = "repairpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AODCmdPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
   Bottomprint(%client, "<jc><f1>Lets's you control your turrets from the Command map.\n<jc>And you are immune to EMP blast.", 10);
}

function AODCmdPack::onUse(%player,%item)
{	
	%client = Player::getClient(%player);
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{	
		remoteCommandMode(%client);
	}
}

function AODCmdPack::onUnMount(%player,%item)
{
	%client = Player::getClient(%player);
	%player.CommandTag = 0;
}

//--------------------------------------------------------------------------------------------------------
// Hyperdrive Pack 
//--------------------------------------------------------------------------------------------------------

$InvList[HyperPack] = 1;
$RemoteInvList[HyperPack] = 1;

$ItemMax[lfemale,HyperPack] = 1;	
$ItemMax[larmor,HyperPack] = 1;	
$ItemMax[mfemale,HyperPack] = 1;	
$ItemMax[marmor,HyperPack] = 1;	
$ItemMax[harmor,HyperPack] = 1;	
$ItemMax[BlastechF, HyperPack] = 1;
$ItemMax[BlastechM, HyperPack] = 1;
$ItemMax[MagIonM, HyperPack] = 0;
$ItemMax[MagIonF, HyperPack] = 0;
$ItemMax[MECH, HyperPack] = 1;

ItemImageData HyperPackImage
{
        shapeFile = "armorkit";
        mountPoint = 2;
        weaponType = 2;
        minEnergy = 1;
        maxEnergy = 1;
        lightType = 3;
        lightRadius = 10;
        lightTime = 10;
        lightColor = { 0.3, 0.1, 0.6 };
        firstPerson = false;
};

ItemData HyperPack
{
	description = "Hyperdrive Pack";
	shapeFile = "armorkit";
	className = "Backpack";
	heading = kBackpacks;
	shadowDetailMask = 4;
	imageType = HyperPackImage;
	price = 150;
	hudIcon = "compass";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function HyperPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
   Bottomprint(%client, "<jc><f1>A Line-Of-Sight Teleporter with a range of 300 meters.  \n<jc>If you see it and it's within that range, you teleport to that spot.\n<jc>You must have <f0>Full<f1> energy to use it.", 10);
}

function HyperPackImage::onActivate(%player,%imageSlot)
{
	%energy = GameBase::getEnergy(%player);

	if(%energy > 50)
//	if(%energy > 30)
	{
		%client = Player::getClient(%player);
		%pos = GameBase::getPosition(%player);

		if(GameBase::getLOSInfo(%player, 302))
		{
			if(Player::hasFlag(%player))
			{
				Player::dropItem(%player, $theFlag);	// pun city :)
				Client::sendMessage(%client, 1, "Cannot carry flag on Teleportation; dropping flag.~werror_message.wav");
			}

			if(FindFlag($los::position,50,50,1024))	// making sure
			{
				Client::sendMessage(%client, 1, "Cannot teleport within 50m of the flag.");
				Player::trigger(%player, $BackpackSlot,false);	
			}

			GameBase::setPosition(%player,$los::position);
			playSound(ForceFieldOpen,$los::position);
			%energy = GameBase::getEnergy(%player);
		 	%energy -= 80;
			GameBase::setEnergy(%player,%energy); 
//			useEnergy(%player,30);
			Player::trigger(%player,$BackPackSlot,false);
		}
		else
		{
			Bottomprint(%client, "<jc>Hyperdrive destination position out of range -- get within 300m");
			Player::trigger(%player,$BackPackSlot,false);
		}	
	}
	else
	{
		playSound(SoundPackFail,%pos);
		Player::trigger(%player,$BackPackSlot,false);
	}
}

function HyperPackImage::onDeactivate(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,false);
}



//===================================================================================

//--------------------------------------------------------------------------------------------------------
// Slipstream Teleporter Pack 
//--------------------------------------------------------------------------------------------------------

$InvList[Slipstream] = 1;	
$RemoteInvList[Slipstream] = 1;

$ItemMax[lfemale,Slipstream] = 1;	
$ItemMax[larmor,Slipstream] = 1;	
$ItemMax[mfemale,Slipstream] = 1;	
$ItemMax[marmor,Slipstream] = 1;	
$ItemMax[harmor,Slipstream] = 1;	
$ItemMax[BlastechF, Slipstream] = 1;
$ItemMax[BlastechM, Slipstream] = 1;
$ItemMax[MagIonM, Slipstream] = 1;
$ItemMax[MagIonF, Slipstream] = 1;
$ItemMax[MECH, Slipstream] = 1;

ItemImageData SlipPackImage
{
	shapeFile = "mortarAmmo";
	mountPoint = 2;

	maxEnergy = 0;
	weaponType = 2;

	mountOffset= { 0, 0.05, 0 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData Slipstream
{
	description = "Slipstream Teleporter";
	className = "Backpack";
	shapeFile = "mortarAmmo";
	hudIcon = "compass";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = SlipPackImage;
	price = 300;
	showWeaponBar = true;
	hiliteOnActive = true;
};

function Slipstream::onMount(%player,%item)
{
        %client = Player::getClient(%player);
   Bottomprint(%client, "<jc><f1>A Waypoint Teleporter. Set your waypoint to anyplace on the map\nexcept to within 50 meters of the enemy flag.  You must have <f0>Full<f1> energy to use it.\n<jc>It deletes your waypoint upon teleportation.", 10);
}

function SlipPackImage::onActivate(%player, %imageSlot)
{
	Slipstream::Teleport(%player);
}

function Slipstream::Teleport(%player)
{
	%client = Player::getClient(%player);
	%waypoint= $point[%client];
	if(%waypoint == "0 0" || !%waypoint)	// initial waypoint check
	{
		Client::sendMessage(%client,1,"Warning! No waypoint specified.~wfailpack.wav");
		Player::trigger(%player,$BackpackSlot,false);
		return;
	}
	else
	{
		%wpPos = WaypointToWorld(%waypoint);
 		%waypointPos = Vector::add(%wpPos,"0 0 400");
		%energy = GameBase::getEnergy(%player);
		%armor =  Player::getArmor(%player);
		%pos = GameBase::getPosition(%player);

		%dpos = newObject("","Turret",cameraturret,true);	// for determining Z
		GameBase::setPosition(%zpos,%waypointPos);
		GameBase::getLOSInfo(%zpos,1024,"-1.57 0 0");	// Z LOS
		deleteObject(%dpos);

		if(Player::hasFlag(%player))
		{
			Player::dropItem(%player, $theFlag);	// pun city :)
			Client::sendMessage(%client, 1, "Cannot carry flag on Teleportation; dropping flag.~wC_buysell.wav");
		}

		if(FindFlag($los::position,50,50,1024))	// cant tele within 50 on waypoint
		{
			Client::sendMessage(%client, 1, "Cannot teleport within 50m of the flag.~werror_message.wav");
			Player::trigger(%player, $BackpackSlot,false);	
		}
		else if(FindFlag(%pos,50,50,1024))		// cant tele within 50 on player pos
		{
			Client::sendMessage(%client, 1, "Cannot teleport within 50m of the flag.~werror_message.wav");
			Player::trigger(%player, $BackpackSlot,false);	
		}
	
		if(%energy >= %armor.maxEnergy - 1) // for any armor
		{
			%waypoint = "0 0";

			useEnergy(%player,60);
			GameBase::startFadeIn(%player);
			Player::setDamageFlash(%player, 0.4);

			%zpos = newObject("","Turret",cameraturret,true);	// for determining Z
			GameBase::setPosition(%zpos,%waypointPos);
			GameBase::getLOSInfo(%zpos,1024,"-1.57 0 0");	// Z LOS
			deleteObject(%zpos);

			GameBase::setPosition(%player, $los::position);	// our LOS position :)
			playSound(SoundLaserHit,$los::position);
			setCommandStatus(%client, 0, "Teleporter ready at full energy.");
			Player::trigger(%player,$BackpackSlot,false);
		}
		else 
		{
			Client::sendMessage(%client,1,"Not enough Energy.~wfailpack.wav");
			Player::trigger(%player,$BackpackSlot,false);
		}
	}
}

//===================================================================================

//--------------------------------------------------------------------------------------------------------
// Leech Pack 
//--------------------------------------------------------------------------------------------------------

//$Xi::LeechFieldSize = 45; 				// How big the Leech field is for each player.

ItemImageData LeechPackImage
{
	shapeFile = "invent_remote";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = -1;
	maxEnergy = 4;   // Energy/sec for sustained weapons
	sfxFire = SoundSensorPower;
	firstPerson = false;
};

ItemData LeechPack
{
	description = "Leech Pack";
	shapeFile = "ammounit_remote";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = LeechPackImage;
	price = 7500;
	hudIcon = "compass";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function LeechPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
   Bottomprint(%client, "<jc><f1>Creates a field that drains enemy health and energy and transfers it to you.\n<jc>It has small area of effect, approximately 45 meter radius.", 10);
}

function LeechPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Leech Field On");
	Xi::initLeech(%player);
}

function Xi::initLeech(%player)
{
	if(Player::isTriggered(%player,$BackpackSlot))
	{
		if(Player::getMountedItem(%player,$BackpackSlot) == LeechPack)
		{
			%team = GameBase::getTeam(%player);
			%set = newObject("set",SimSet);
			%pos = GameBase::getPosition(%player);
			%armor = Player::getArmor(%player);
			%playerId = Player::getClient(%player);
			if (%armor == "larmor" || %armor == "lfemale")
			{
				$Xi::LeechFieldSize = 45; 	// How big the Leech field is for each player.
			}
			else if (%armor == "BlastechM" || %armor == "BlastechF")
			{
				$Xi::LeechFieldSize = 25; 	// How big the Leech field is for each player.
			}
			else if (%armor == "MagIonM" || %armor == "MagIonF")
			{
				$Xi::LeechFieldSize = 35; 	// How big the Leech field is for each player.
			}
			else if (%armor == "marmor" || %armor == "mfemale")
			{
				$Xi::LeechFieldSize = 50; 	// How big the Leech field is for each player.
			}
			else if(%armor == "MECH")
			{
				$Xi::LeechFieldSize = 30; 	// How big the Leech field is for each player.
			}
			else if(%armor == "harmor")
			{
				$Xi::LeechFieldSize = 40; 	// How big the Leech field is for each player.
			}

			containerBoxFillSet(%set,$SimPlayerObjectType | $MineObjectType,%pos,$Xi::LeechFieldSize,$Xi::LeechFieldSize,$Xi::LeechFieldSize,0); // will the real players (and mines) please stand up?
			%count = Group::objectCount(%set);

			if(%count)
      		{ 
				for(%i; %i < %count; %i++)
				{
					%tgt = Group::getObject(%set,%i);
					%tgtTeam = GameBase::getTeam(%tgt);
					%target = Group::getObject(%set, %count); 

					if(%team != %tgtTeam) // no TK leeching :)
					{
						%energy = GameBase::getEnergy(%player);
			 			%energy += %count; // Grabs their energy (collectively)
					      GameBase::setEnergy(%player, %energy);
						%damlevel = GameBase::getDamageLevel(%player);
						%damlevel -= 0.0025 * %count; // Grabs their health (collectively)
						GameBase::setDamageLevel(%player,%damlevel);

						%energy = GameBase::getEnergy(%tgt);	// Different DMG script for target.
			 			%energy -= 1; // Grabs their energy (collectively)
					      GameBase::setEnergy(%tgt, %energy);
//						%pos = GameBase::getPosition(tgt);
						%pos = GameBase::getPosition(%tgt);//was missing the % on tgt
						GameBase::applyDamage(%tgt,$TractorDamageType,0.0025,%pos,"0 0 0","0 0 0",%player);

					}
				}
			}
		      deleteObject(%set); // no need for the set anymore, killit()
			schedule("Xi::initLeech(" @ %player @ ");", 0.05,%player); // 20x per second or 2x per 1/10th second
		}
	}
}

function LeechPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Leech Field Off");
	Player::trigger(%player,$BackpackSlot,false);
}

$InvList[LeechPack] = 1;
$RemoteInvList[LeechPack] = 1;

$ItemMax[harmor, LeechPack] = 1;
$ItemMax[marmor, LeechPack] = 1;
$ItemMax[mfemale, LeechPack] = 1;
$ItemMax[larmor, LeechPack] = 1; 
$ItemMax[lfemale, LeechPack] = 1;
$ItemMax[BlastechF, LeechPack] = 1;
$ItemMax[BlastechM, LeechPack] = 1;
$ItemMax[MagIonM, LeechPack] = 1;
$ItemMax[MagIonF, LeechPack] = 1;
$ItemMax[MECH, LeechPack] = 1;

//===================================================================================

ItemData GigaWatt
{
	description = "WireTaps: ";
	className = "Ammo";
	shapeFile = "zap_5";
	heading = "yBugging";
	shadowDetailMask = 4;
	price = 1;
};

//===================================================================================

$InvList[SuperPack] = 0;
$RemoteInvList[SuperPack] = 0;

$ItemMax[harmor, SuperPack] = 1;
$ItemMax[marmor, SuperPack] = 1;
$ItemMax[mfemale, SuperPack] = 1;
$ItemMax[larmor, SuperPack] = 1;
$ItemMax[lfemale, SuperPack] = 1;
$ItemMax[BlastechF, SuperPack] = 1;
$ItemMax[BlastechM, SuperPack] = 1;
$ItemMax[MagIonM, SuperPack] = 1;
$ItemMax[MagIonF, SuperPack] = 1;
$ItemMax[MECH, SuperPack] = 1;

ItemImageData SuperPackImage
{
	shapeFile = "dsply_s2";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	minEnergy = 0;
	maxEnergy = 1;   // Energy/sec for sustained weapons
	mass = 5;
	sfxFire = SoundShieldOn;
	firstPerson = false;
};

ItemData SuperPack
{
	description = "Super Pill";
	shapeFile = "dsply_s2";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = SuperPackImage;
	price = 50000;
	hudIcon = "shieldpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SuperPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
   Bottomprint(%client, "<jc><f1>It's the stupendous SUPER PILL!!.\n<jc>Guaranteed to make sure your opponents will BEG for mercy!!\n<jc>Just pop one in and go on a killing spree.\n<jc><f0>* * CAUTION * *  It can bite back. ", 20);
}

function SuperPackImage::onActivate(%player,%imageSlot)
{
	%clientId = Player::getClient(%player);

	SuperP::Shield(%clientId, %player);
	SuperP::Cloak(%clientId, %player);
	SuperP::Energy(%clientId, %player);
	SuperP::Health(%clientId, %player);
	SuperP::Ammo(%clientId, %player);

		schedule("badaboom(" @ %clientId @ ", " @ %player @ ");",70,%player);

	Player::decItemCount(%player,SuperPack,1); 
}

function badaboom(%clientId, %player)
{
		%clientId = Player::getClient(%player);
		%client = Player::getClient(%player);

		if($ammoSPtime[%clientId] > 0 || $healthSPtime[%clientId] > 0 || $energySPtime[%clientId] > 0 || $shieldSPtime[%clientId] > 0 || $cloakSPtime[%clientId] > 0)
		{
				Client::sendMessage(Player::getClient(%player),2,"Super Pill can't take the stress!!!!");
				GameBase::playSound(%player,bigExplosion1,0);
				Player::blowUp(%client);
				%obj = newObject("","Mine","HavocBlast");
				GameBase::throw(%obj,%clientId,0,false);		
				addToSet("MissionCleanup", %obj);
				%padd = "0 0 1.5";
				%pos = Vector::add(GameBase::getPosition(%clientId), %padd);
				GameBase::setPosition(%obj, %pos);
		  		GameBase::applyDamage(%player, $PlasmaDamageType, 50, "0 0 0", "0 0 0", "0 0 0", %clientId);
				return;
		}
}

//===================================================================================

$InvList[SuperChargerPack] = 1;
$RemoteInvList[SuperChargerPack] = 1;

$ItemMax[harmor, SuperChargerPack] = 1;
$ItemMax[marmor, SuperChargerPack] = 1;
$ItemMax[mfemale, SuperChargerPack] = 1;
$ItemMax[larmor, SuperChargerPack] = 1;
$ItemMax[lfemale, SuperChargerPack] = 1;
$ItemMax[BlastechF, SuperChargerPack] = 1;
$ItemMax[BlastechM, SuperChargerPack] = 1;
$ItemMax[MagIonM, SuperChargerPack] = 1;
$ItemMax[MagIonF, SuperChargerPack] = 1;
$ItemMax[MECH, SuperChargerPack] = 1;

ItemImageData SuperChargerPackI
{
//	shapeFile = "shockwave_large";
	shapeFile = "plant2";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mountOffset = { 0, 0, -0.56 };

//	shapeFile = "teleport_vertical";
//	mountOffset = { 0, -1.05, -1.16 };
//	mountRotation = { -0.65, 0, 0 };

	minEnergy = -1;
 	maxEnergy = 0;
	firstPerson = false;
};

ItemData SuperChargerPack
{
	description = "Chimera Mutator";
	shapeFile = "plant2";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = SuperChargerPackI;
	price = 7000;
	hudIcon = "clock";
//	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SuperChargerPack::onMount(%player,%item)
{
	Player::trigger(%player,$BackpackSlot,true);
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc><f1>Alters the basic settings to the <f2>Rifles<f1>.  Each setting has a different effect on each rifle.", 10);
}

function SuperChargerPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
}

//===================================================================================

$InvList[Beaconizer] = 0;
$RemoteInvList[Beaconizer] = 0;

$ItemMax[harmor, Beaconizer] = 1;
$ItemMax[marmor, Beaconizer] = 1;
$ItemMax[mfemale, Beaconizer] = 1;
$ItemMax[larmor, Beaconizer] = 1;
$ItemMax[lfemale, Beaconizer] = 1;
$ItemMax[BlastechF, Beaconizer] = 1;
$ItemMax[BlastechM, Beaconizer] = 1;
$ItemMax[MagIonM, Beaconizer] = 1;
$ItemMax[MagIonF, Beaconizer] = 1;
$ItemMax[MECH, Beaconizer] = 1;

ItemImageData BeaconizerI
{
	shapeFile = "logo";
//	shapeFile = "sensor_small";
	weaponType = 2;  // Sustained

	mountPoint = 2;
//	mountOffset = { 0, 0, -0.56 };
	mass = 1;
	minEnergy = -1;
 	maxEnergy = 4;
	firstPerson = false;
};

ItemData Beaconizer
{
	description = "Beacon Switcheroo";
	shapeFile = "logo";
//	shapeFile = "sensor_small";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = BeaconizerI;
	price = 2500;
	hudIcon = "clock";
//	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function Beaconizer::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Allows you to use beacons from any armor.  Configure it from the <f2>Weapon Option<f1> menu.\n<jc><f1>Then use it as a <f2>PACK<f1>.  You can still use your regular <f0>Beacons<f1> too!", 10);

}

function BeaconizerI::onActivate(%player,%imageSlot)
{
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);
	%armor = Player::getArmor(%player);
	%clientID = Player::getclient(%player);

	if(Player::getItemCount(%player,Beacon) > 0)
	{
		GameBase::playSound(%player,SoundRemoteTurretOn,0);
//		Player::trigger(%player,$BackpackSlot,true);

		if (%playerId.SpclBecn == 0)
		{
			Player::decItemCount(%player,Beacon,1);
			schedule("BeaconizerI::onDeactivate(" @ %player @ ", " @ %imageslot @ ");",60,%player);
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo is now <f2>Shielding<f1>.",4);
			%player.shieldStrength = 0.018;    
		}
		else if (%playerId.SpclBecn == 1)
		{
			Player::decItemCount(%player,Beacon,1);
			schedule("BeaconizerI::onDeactivate(" @ %player @ ", " @ %imageslot @ ");",60,%player);
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo is now <f2>Cloaking<f1>.",4);
			GameBase::playSound(%player,ForceFieldOpen,0);
			GameBase::startFadeout(%player);
 			$cloaked[%player] = 1;
 			Cloaker(%player);
			%rate = Player::getSensorSupression(%player) + 1;
			Player::setSensorSupression(%player,%rate);
		}
		else if (%playerId.SpclBecn == 2)
		{
			Player::decItemCount(%player,Beacon,1);
			schedule("BeaconizerI::onDeactivate(" @ %player @ ", " @ %imageslot @ ");",60,%player);
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo is now <f2>Energy Recharging<f1>.",4);
			GameBase::setRechargeRate(%player,80);
			checkYourEnergy(%client, %player);
		}
		else if (%playerId.SpclBecn == 3)
		{
			Player::decItemCount(%player,Beacon,1);
			schedule("BeaconizerI::onDeactivate(" @ %player @ ", " @ %imageslot @ ");",60,%player);
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo is now <f2>Auto Repairing<f1>.",4);
			GameBase::setAutoRepairRate(%player, 0.65);
		}
		else if (%playerId.SpclBecn == 4)
		{
			Player::decItemCount(%player,Beacon,1);
			schedule("BeaconizerI::onDeactivate(" @ %player @ ", " @ %imageslot @ ");",60,%player);
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo is now <f2>Ammo Regenerating<f1>.",4);
			%player.ammogenActive = "true";
			ammogenImage::RegenerateAmmo(%player);
			checkYourAmmo(%client, %player);
		}
		else if (%playerId.SpclBecn == 5)
		{
			Player::decItemCount(%player,Beacon,1);
			schedule("BeaconizerI::onDeactivate(" @ %player @ ", " @ %imageslot @ ");",60,%player);
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo has the <f2>Universal Antidote<f1> running thru you.",4);
			if($empTime[%clientId] > 0) $empTime[%clientId] = 0;
			if($poisonTime[%clientId] > 0)  $poisonTime[%clientId] = 0;
			if($burnTime[%clientId] > 0)  $burnTime[%clientId] = 0;
			if($HFburnTime[%clientId] > 0)  $HFburnTime[%clientId] = 0;
			GameBase::repairDamage(%player,1.25);
			checkYourAntidote(%client, %player);
		}
		else if (%playerId.SpclBecn == 6)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo just deployed a <f2>Beacon<f1>.",4);
			BeaconWC::deployShape(%player,%item);
//			Player::decItemCount(%player,beacon);
			BeaconizerI::onDeactivate(%player,%imageSlot);
		}
		else if (%playerId.SpclBecn == 7)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo applied a <f2>Jet Boost<f1>.",4);
			Player::applyImpulse(%player, Vector::getFromRot(GameBase::getRotation(%client),0,975));
			%pos = GameBase::getPosition(%player);
			playSound (SoundFireSeeking, %pos);
			Player::decItemCount(%player,beacon);
			BeaconizerI::onDeactivate(%player,%imageSlot);
		}
	}
	else
	{
		Bottomprint(%client,"<jc><f1>You are all out of <f2>BEACONS<f1>.  Find some more!!!",7);
	}
}

function BeaconizerI::onDeactivate(%player,%imageSlot)
{
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);
	%armor = Player::getArmor(%player);

//	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "Beaconizer") 
//	{
		Player::trigger(%player,$BackpackSlot,false);
		GameBase::playSound(%player,SoundElevatorStop,0);

		%player.shieldStrength = 0;
		GameBase::setAutoRepairRate(%player, 0);
		GameBase::setRechargeRate(%player,8);
		GameBase::startFadein(%player);
		Player::setSensorSupression(%player,0);
		$cloaked[%player] = 0;
		Cloaker(%player);
		%player.ammogenActive = "false";

		if (%playerId.SpclBecn == 0)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo <f2>Shielding<f1> is now <f0>OFF<f1>.",4);
//			Client::sendMessage(Player::getClient(%player),3,"Beacon Switcheroo Shielding is now OFF.");
		}
		else if (%playerId.SpclBecn == 1)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo <f2>Cloaking<f1> is now <f0>OFF<f1>.",4);
		}
		else if (%playerId.SpclBecn == 2)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo <f2>Energy Recharging<f1> is now <f0>OFF<f1>.",4);
		}
		else if (%playerId.SpclBecn == 3)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo <f2>Auto Repairing<f1> is now <f0>OFF<f1>.",4);
		}
		else if (%playerId.SpclBecn == 4)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo <f2>Ammo Regenerating<f1> is now <f0>OFF<f1>.",4);
		}
		else if (%playerId.SpclBecn == 5)
		{
			Bottomprint(%client,"<jc><f1>Beacon Switcheroo <f2>Universal Antidote<f1> is now <f0>OFF<f1>.",4);
		}
//	}
}

function checkYourAmmo(%client, %player)
{
	%armor = Player::getArmor(%player);
	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "Beaconizer") 
	{
		schedule("checkYourAmmo(" @ %client @ ", " @ %player @ ");",12,%player);
		%player.ammogenActive = "true";
		ammogenImage::RegenerateAmmo(%player);
    	}
	else
	{
		%player.ammogenActive = "false";
	}			
}

function checkYourAntidote(%client, %player)
{
	%armor = Player::getArmor(%player);
	%clientId = Player::getClient(%player);
	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "Beaconizer") 
	{
		if($empTime[%clientId] > 0) $empTime[%clientId] = 0;
		if($poisonTime[%clientId] > 0)  $poisonTime[%clientId] = 0;
		if($burnTime[%clientId] > 0)  $burnTime[%clientId] = 0;
		if($HFburnTime[%clientId] > 0)  $HFburnTime[%clientId] = 0;
		schedule("checkYourAntidote(" @ %client @ ", " @ %player @ ");",2,%player);
    	}
	else
	{
	}			
}

function checkYourEnergy(%client, %player)
{
	%armor = Player::getArmor(%player);
	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "Beaconizer") 
	{
		schedule("checkYourEnergy(" @ %client @ ", " @ %player @ ");",2,%player);
		GameBase::setRechargeRate(%player,80);
	}
	else
	{
		GameBase::setRechargeRate(%player,8);
	}			
}

//===================================================================================

$InvList[LaughInYourFace] = 1;
$RemoteInvList[LaughInYourFace] = 1;

$ItemMax[harmor, LaughInYourFace] = 0;
$ItemMax[marmor, LaughInYourFace] = 1;
$ItemMax[mfemale, LaughInYourFace] = 1;
$ItemMax[larmor, LaughInYourFace] = 1;
$ItemMax[lfemale, LaughInYourFace] = 1;
$ItemMax[BlastechF, LaughInYourFace] = 1;
$ItemMax[BlastechM, LaughInYourFace] = 1;
$ItemMax[MagIonM, LaughInYourFace] = 1;
$ItemMax[MagIonF, LaughInYourFace] = 1;
$ItemMax[MECH, LaughInYourFace] = 1;

ItemImageData LaughInYourFaceImage
{
	shapeFile = "shield_medium";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	mountRotation = { 0, 3.14, 0 };
	minEnergy = -1;
	maxEnergy = 500;   // Energy/sec for sustained weapons
	mass = -3;
	sfxFire = SoundShieldOn;
	firstPerson = false;
};

ItemData LaughInYourFace
{
	description = "I Laugh at That";
	shapeFile = "shield_medium";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = LaughInYourFaceImage;
	price = 17500;
	hudIcon = "shieldpack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function LaughInYourFace::onMount(%player,%item)
{
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc><f1>Shrugs off any <f2>non-lethal<f1> damage.  But, an <f2>energy<f1> hog.", 10);
	%player.shieldStrength = 0.001;
}

function LaughInYourFaceImage::onActivate(%player,%imageSlot)
{
	%armor = Player::getArmor(%player);
	Client::sendMessage(Player::getClient(%player),0,"Super Healing: ON");
	gameBase::setAutoRepairRate(%player, 300);
	%player.shieldStrength = 0;
}

function LaughInYourFaceImage::onDeactivate(%player,%imageSlot)
{
	%armor = Player::getArmor(%player);
	Player::trigger(%player,$BackpackSlot,false);
	Client::sendMessage(Player::getClient(%player),0,"Healing: OFF     Partial Shields: ON");
	%player.shieldStrength = 0.001;
	if(%armor == "marmor" || %armor == "mfemale")
	{
		gameBase::setAutoRepairRate(%player, 0.15);
	}
	else
	{
		gameBase::setAutoRepairRate(%player, 0);
	}
}

function LaughInYourFace::onUnMount(%player,%item)
{
	%armor = Player::getArmor(%player);
	%player.shieldStrength = 0;
}

//===================================================================================

$InvList[BlinkPack] = 1;
$RemoteInvList[BlinkPack] = 1;

$ItemMax[harmor, BlinkPack] = 1;
$ItemMax[marmor, BlinkPack] = 1;
$ItemMax[mfemale, BlinkPack] = 1;
$ItemMax[larmor, BlinkPack] = 1;
$ItemMax[lfemale, BlinkPack] = 1;
$ItemMax[BlastechF, BlinkPack] = 1;
$ItemMax[BlastechM, BlinkPack] = 1;
$ItemMax[MagIonM, BlinkPack] = 1;
$ItemMax[MagIonF, BlinkPack] = 1;
$ItemMax[MECH, BlinkPack] = 1;

ItemImageData BlinkPackImage
{
	shapeFile = "dirarrows";
	mountPoint = 2;
	weaponType = 2;  // Sustained
  	mountOffset = { 0, -0.15, 0.35 };
	mountRotation = { 0, 0, 3.14 };
	mass = -3;
	minEnergy = -1;
	maxEnergy = -5;   // Energy/sec for sustained weapons
	sfxFire = SoundJammerOn;
	firstPerson = false;
};

ItemData BlinkPack
{
	description = "Blink Pack";
	shapeFile = "dirarrows";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = BlinkPackImage;
	price = 17500;
	hudIcon = "compass";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function BlinkPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Blinking <f2>teleports<f1> you short distances, randomly.", 10);
}

function BlinkPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"You will BLINK every 2 seconds now.");
	KeepBlinking(%client, %player);
}

function BlinkPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Blinking Off");
	Player::trigger(%player,$BackpackSlot,false);
}


function KeepBlinking(%client, %player)
{
	%clientId = Player::getClient(%player);
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);
	%armor = Player::getArmor(%player);
	%pack = Player::getMountedItem(%player,$BackpackSlot);
	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "BlinkPack") 
	{

		if(Player::getMountedItem(%client, $FlagSlot) == "flag")
		{
			%rnd = floor(getRandom() * 30);
			if(%rnd > 26)
			{
				Player::dropItem(%client, Player::getMountedItem(%client, $FlagSlot));
				Client::sendMessage(%client, 1, "You dropped the flag while Blinking!");
			}
			else if(%rnd > 22)
			{
				Player::dropItem(%client, Player::getMountedItem(%client, $FlagSlot));
				%pos = Vector::add(GameBase::getPosition(%player), "-5000 -5000 -5000");
				GameBase::setPosition(%player,%pos);
				Client::sendMessage(%client, 1, "Oops!  Looks like you went to HELL!!");
			}
			else
			{
				Client::sendMessage(%client, 1, "Watch out, you nearly lost the FLAG.");
			}
		}

//		(side to side   forward to back    up or down) is ("0 0 0")

		%pPos	= GameBase::getPosition(%player);

		%posX = getWord(%pPos,0);	//side to side, but not really based on actual facing
		%posY = getWord(%pPos,1);	//front to back, but not really based on actual facing
		%posZ = getWord(%pPos,2);	//up and down

		%rndX = (floor(getRandom() * 81) - 40);
		%rndY = (floor(getRandom() * 81) - 40);
		%rndZ = floor(getRandom() * 40);

	  	%newPosX = %rndX + %posX;		 
		%newPosY = %rndY + %posY;
		%newPosZ = %rndZ + %posZ;

		GameBase::setPosition(%player, " " @ %newPosX @ " " @ %newPosY @ " " @ %newPosZ @ " ");

		GameBase::playSound(%player,enterdimension,0); 
		schedule("KeepBlinking(" @ %client @ ", " @ %player @ ");",2,%player);
	}
}

//===================================================================================

ItemImageData DynamoImage
{
	shapeFile = "discammo";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mountOffset = { 0, -0.2, 0.1 };
	mountRotation = { -1.57, 1.57, -1.57 };
	mass = 0.5;
	minEnergy = -1;
 	maxEnergy = 0;
	firstPerson = false;
};

ItemData Dynamo
{
//	description = "Oops I Farted";
	description = "Pull My Finger";
	shapeFile = "discammo";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = DynamoImage;
	price = 5000;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function Dynamo::onMount(%player,%item)
{
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc><f1>This pack compresses then releases an internal charge in one explosive burst.\nThe armor wearing it is immune, most of the time, to the explosion.", 10);
}

$InvList[Dynamo] = 0;
$RemoteInvList[Dynamo] = 0;

$ItemMax[harmor, Dynamo] = 1;
$ItemMax[marmor, Dynamo] = 1;
$ItemMax[mfemale, Dynamo] = 1;
$ItemMax[larmor, Dynamo] = 1;
$ItemMax[lfemale, Dynamo] = 1;
$ItemMax[BlastechF, Dynamo] = 1;
$ItemMax[BlastechM, Dynamo] = 1;
$ItemMax[MagIonM, Dynamo] = 1;
$ItemMax[MagIonF, Dynamo] = 1;
$ItemMax[MECH, Dynamo] = 1;

function DynamoImage::onActivate(%player,%imageSlot)
{
	%client = Player::getClient(%player);
	Client::sendMessage(Player::getClient(%player),0,"You will EXPLODE every 4 seconds now.");
	Player::trigger(%player,$BackpackSlot,true);
	KeepExploding(%client, %player);
}

function DynamoImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"EXPLODING Off");
	Player::trigger(%player,$BackpackSlot,false);
}

function KeepExploding(%client, %player)
{
	%clientId = Player::getClient(%player);
	%client = Player::getClient(%player);
	%armor = Player::getArmor(%player);
	if(Player::isTriggered(%player, $BackPackSlot) && Player::getMountedItem(%player, $BackPackSlot) == "Dynamo") 
	{
		if(Player::getMountedItem(%client, $FlagSlot) == "flag")
		{
			%rnd = floor(getRandom() * 30);
			if(%rnd > 26)
			{
				Player::dropItem(%client, Player::getMountedItem(%client, $FlagSlot));
				Client::sendMessage(%client, 1, "You dropped the flag while Exploding!");
			}
		}

		%rnd = floor(getRandom() * 100);
		if(%rnd != 0)
		{
			if(%armor == "harmor")
			{
				%obj1 = newObject("","Mine","HavocBlastT");	//Terrax is immune to this one
				%obj2 = newObject("","Mine","HavocBlastT");	//Terrax is immune to this one
			}
			else if(%armor == "MECH")
			{
				%obj1 = newObject("","Mine","HavocBlastD");	//Destroyer is immune to this one
				%obj2 = newObject("","Mine","HavocBlastD");	//Destroyer is immune to this one
			}
			else if(%armor == "marmor" || %armor == "mfemale")
			{
				%obj1 = newObject("","Mine","HavocBlastM");	//Mechanic is immune to this one
				%obj2 = newObject("","Mine","HavocBlastM");	//Mechanic is immune to this one
			}
			else if(%armor == "larmor" || %armor == "lfemale")
			{
				%obj1 = newObject("","Mine","HavocBlastQ");	//Quicksilver is immune to this one
				%obj2 = newObject("","Mine","HavocBlastQ");	//Quicksilver is immune to this one
			}
			else if(%armor == "BlastechM" || %armor == "BlastechF")
			{
				%obj1 = newObject("","Mine","HavocBlastG");	//Ghost is immune to this one
				%obj2 = newObject("","Mine","HavocBlastG");	//Ghost is immune to this one
			}
			else if(%armor == "MagIonM" || %armor == "MagIonF")
			{
				%obj1 = newObject("","Mine","HavocBlastZ");	//ZzaxX is immune to this one
				%obj2 = newObject("","Mine","HavocBlastZ");	//ZzaxX is immune to this one
			}
		}
		else
		{
			%obj1 = newObject("","Mine","HavocBlastHUGE");	//No one is immune to this one
			%obj2 = newObject("","Mine","HavocBlastHUGE");	//No one is immune to this one
		}

		GameBase::setTeam(%obj1,GameBase::getTeam(%client));
		GameBase::setTeam(%obj2,GameBase::getTeam(%client));
//		GameBase::setTeam(%obj1,GameBase::getTeam(%player));
//		GameBase::setTeam(%obj2,GameBase::getTeam(%player));

		addToSet("MissionCleanup",%obj1);
		%padd = "2 0 1.5";
		%pos = Vector::add(GameBase::getPosition(%player),%padd);
		GameBase::setPosition(%obj1, %pos);

		addToSet("MissionCleanup",%obj2);
		%padd = "-2 0 1.5";
		%pos = Vector::add(GameBase::getPosition(%player),%padd);
		GameBase::setPosition(%obj2, %pos);

		GameBase::playSound(%player,SoundJetTemp,0); 
		schedule("KeepExploding(" @ %client @ ", " @ %player @ ");",4,%player);
	}
}

//===================================================================================



