//=================================================================================
// MINE DYNAMIC DATA

MineData AntipersonelMine
{
        className = "Mine";
   description = "Antipersonel Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 20.0;
        damageValue = 0.85;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function AntipersonelMine::onAdd(%this)
{
	%this.damage = 0;
	AntipersonelMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function AntipersonelMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function AntipersonelMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("AntipersonelMine::deployCheck(" @ %this @ ");", 3, %this);
}

function AntipersonelMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function AntipersonelMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================
// Concussive Mine

MineData ConcussiveMine
{
        className = "Mine";
   description = "Concussive Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 15.0;
        damageValue = 0.65;
        damageType = $NullDamageType;
        kickBackStrength = -1050;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function ConcussiveMine::onAdd(%this)
{
	%this.damage = 0;
	ConcussiveMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function ConcussiveMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function ConcussiveMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("ConcussiveMine::deployCheck(" @ %this @ ");", 3, %this);
}

function ConcussiveMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function ConcussiveMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================
// Fire Mine

MineData FireMine
{
        className = "Mine";
   description = "Fire Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 20.0;
        damageValue = 0.45;
        damageType = $MBHeatDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function FireMine::onAdd(%this)
{
	%this.damage = 0;
	FireMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function FireMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function FireMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("FireMine::deployCheck(" @ %this @ ");", 3, %this);
}

function FireMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function FireMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================
// Poison Mine

MineData PoisonMine
{
        className = "Mine";
   description = "Poison Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 20.0;
        damageValue = 0.15;
        damageType = $MethaneDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function PoisonMine::onAdd(%this)
{
	%this.damage = 0;
	PoisonMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function PoisonMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function PoisonMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("PoisonMine::deployCheck(" @ %this @ ");", 3, %this);
}

function PoisonMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function PoisonMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================
// EMP Mine

MineData EMPMine
{
        className = "Mine";
   description = "EMP Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 20.0;
        damageValue = 0.15;
        damageType = $EMPDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function EMPMine::onAdd(%this)
{
	%this.damage = 0;
	EMPMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function EMPMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function EMPMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("EMPMine::deployCheck(" @ %this @ ");", 3, %this);
}

function EMPMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function EMPMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================
// Tornado Mine

MineData TornadoMine
{
        className = "Mine";
   description = "Tornado Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 20.0;
        damageValue = 0.15;
        damageType = $TornadoDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function TornadoMine::onAdd(%this)
{
	%this.damage = 0;
	TornadoMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function TornadoMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function TornadoMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("TornadoMine::deployCheck(" @ %this @ ");", 3, %this);
}

function TornadoMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function TornadoMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================
// Heavy Gravity Mine

MineData HvyGravMine
{
        className = "Mine";
   description = "Heavy Gravity Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 20.0;
        damageValue = 0.25;
        damageType = $HvyGravDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function HvyGravMine::onAdd(%this)
{
	%this.damage = 0;
	HvyGravMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function HvyGravMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function HvyGravMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("HvyGravMine::deployCheck(" @ %this @ ");", 3, %this);
}

function HvyGravMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function HvyGravMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================
// Acid Mine

MineData AcidMine
{
        className = "Mine";
   description = "Acid Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 20.0;
        damageValue = 0.35;
        damageType = $AcidBathDamageType ;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

function AcidMine::onAdd(%this)
{
	%this.damage = 0;
	AcidMine::deployCheck(%this);
//	GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function AcidMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function AcidMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("AcidMine::deployCheck(" @ %this @ ");", 3, %this);
}

function AcidMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function AcidMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//=================================================================================

MineData NuclearMine
{
        className = "Mine";
   description = "Nuclear Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
        explosionRadius = 40.0;
        damageValue = 65;
        damageType = $NuclearMineDamageType;
        kickBackStrength = 150;
        triggerRadius = 4.5;
        maxDamage = 2.5;
        shadowDetailMask = 0;
        destroyDamage = 2.0;
        damageLevel = {1.0, 1.0};
};

function NuclearMine::onAdd(%this)
{
        %this.damage = 0;
        NuclearMine::deployCheck(%this);
        GameBase::SetTeam(%this);
//-----------------see-if-this-cloaks-this-mine-------------------------
	GameBase::startFadeout(%this);
 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-mine-------------------------
}

function NuclearMine::onCollision(%this,%object)
{
        %type = getObjectType(%object);
        %data = GameBase::getDataName(%this);

        if((%type == "Player"|| %data == AntipersonelMine  || %data == ConcussiveMine || %data == FireMine || %data == PoisonMine || %data == EMPMine || %data == TornadoMine || %data == HvyGravMine || %data == AcidMine || %data == NuclearMine || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && GameBase::getTeam(%this) != GameBase::getTeam(%object))
                GameBase::setDamageLevel(%this, %data.maxDamage);
}

function NuclearMine::deployCheck(%this)
{
        if (GameBase::isAtRest(%this)) {
                GameBase::playSequence(%this,1,"deploy");
                 GameBase::setActive(%this,true);
                %set = newObject("set",SimSet);
                if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0)) {
                        %data = GameBase::getDataName(%this);
                        GameBase::setDamageLevel(%this, %data.maxDamage);
                }
                deleteObject(%set);
        }
        else
                schedule("NuclearMine::deployCheck(" @ %this @ ");", 3, %this);
}

function NuclearMine::onDestroyed(%this)
{
        $TeamItemCount[GameBase::getTeam(%this) @ "mineammo"]--;
}

function NuclearMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

        %data = GameBase::getDataName(%this);
        if((%data.maxDamage/1.5) < %this.damage+%value)
                GameBase::setDamageLevel(%this, %data.maxDamage);
        else
                %this.damage += %value;
}

//----------------------------------------------------------------------------

MineData StandardGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Standard Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 25.0;
	damageValue = 0.5;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function StandardGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

MineData ConcussiveGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Concussive Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 30.0;
	damageValue = 0.05;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 1250;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function ConcussiveGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

MineData FireGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Fire Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 25.0;
	damageValue = 0.2;
	damageType = $MBHeatDamageType;
	kickBackStrength = 50;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function FireGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

MineData PoisonGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Poison Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 25.0;
	damageValue = 0.15;
	damageType = $MethaneDamageType;
	kickBackStrength = 50;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function PoisonGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

MineData EMPGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "EMP Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 25.0;
	damageValue = 0.05;
	damageType = $EMPDamageType;
	kickBackStrength = 50;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function EMPGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

MineData StunGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Stun Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 25.0;
	damageValue = 0.05;
	damageType = $StunDamageType;
	kickBackStrength = 50;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function StunGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

MineData BlackHoleGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "BlackHole Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 65.0;
	damageValue = 0.05;
	damageType = $ShrapnelDamageType;
	kickBackStrength = -750;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function BlackHoleGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

MineData AcidGrenade
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Acid Grenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 25.0;
	damageValue = 0.15;
	damageType = $AcidBathDamageType;
	kickBackStrength = 50;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function AcidGrenade::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
	schedule("DeployShrapnel(" @ %this @ " , 16);",2.0,%this);
}

//----------------------------------------------------------------------------

function Mine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	if (%type == $MineDamageType)
		%value = %value * 0.25;

	%damageLevel = GameBase::getDamageLevel(%this);
	GameBase::setDamageLevel(%this,%damageLevel + %value);
}

function Mine::Detonate(%this)
{
	%data = GameBase::getDataName(%this);
	GameBase::setDamageLevel(%this, %data.maxDamage);
}

//----------------------------------------------------------------------------

function ShockZap(%this)
{
	%obj = newObject("","Mine","shockadd");
	addToSet("MissionCleanup", %obj);
	%padd = "0 0 0";
	%pos = Vector::add(GameBase::getPosition(%this), %padd);
	GameBase::setPosition(%obj, %pos);
}

//----------------------------------------------------------------------------

MineData JetBoostGren
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Jet Boost Grenade";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
	explosionRadius = 7.0;
	damageValue = 0;
	damageType = $NullDamageType;
	kickBackStrength = 950;
	triggerRadius = 0.5;
	maxDamage = 0;
};

function JetBoostGren::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.25,%this);
}

//----------------------------------------------------------------------------
MineData ArmorCoreExp
{
	mass = 5.0;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "";
	shapeFile = "breath";
	shadowDetailMask = 4;
	explosionId = MortarExp;
	explosionRadius = 30;
	damageValue = 1000;
	damageType = $DebrisDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 0.5;
};

function ArmorCoreExp::onAdd(%this)
{
	Mine::Detonate(%this);
}

MineData ArmorExp
{
	mass = 5.0;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "";
	shapeFile = "breath";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
	explosionRadius = 20;
	damageValue = 1000;
	damageType = $NullDamageType;
	kickBackStrength = 0;
	triggerRadius = 0.5;
	maxDamage = 0.5;
};

function ArmorExp::onAdd(%this)
{
	Mine::Detonate(%this);
}

//----------------------------------------------------------------------------

MineData C4
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Shock Grenade";
   shapeFile = "grenammo";
   shadowDetailMask = 4;
   explosionId = GrenadeExp;
        explosionRadius = 25.0;
        damageValue = 15;
        damageType = $MineDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 14.999;
};

function C4::onAdd(%this)
{
      schedule("ShockZap(" @ %this @ ");",14.95,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",15.0,%this);
}

//----------------------------------------------------------------------------

MineData C4Quick
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Shock Grenade";
   shapeFile = "grenammo";
   shadowDetailMask = 4;
   explosionId = GrenadeExp;
        explosionRadius = 25.0;
        damageValue = 2.5;
        damageType = $MineDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 5;
};

function C4Quick::onAdd(%this)
{
      schedule("ShockZap(" @ %this @ ");",1.99,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

//----------------------------------------------------------------------------

MineData NBase
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = flashExpLarge;
        explosionRadius = 0.0;
        damageValue = 0.0;
        damageType = $MineDamageType;
        kickBackStrength = 450;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NRing1
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = LargeShockwave;
        explosionRadius = 35.0;
        damageValue = 2.1;
        damageType = $MineDamageType;
        kickBackStrength = 450;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NRing2
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.75;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NRing3
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.65;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NRing4
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 100.0;
        damageValue = 0.55;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NRing5
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 0.25;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NCloud1
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 100.0;
        damageValue = 0.25;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};
MineData NCloud2
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 0.25;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};
MineData NCloud3
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
	explosionId = mortarExp;
        explosionRadius = 100.0;
        damageValue = 0.25;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};
MineData NCloud4
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 0.25;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NCloud5
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 0.25;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};

MineData NCloud6
{
        className = "Mine";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 0.25;
        damageType = $MineDamageType;
        kickBackStrength = 150;
        triggerRadius = 2.5;
        maxDamage = 0.5;
        shadowDetailMask = 0;
        destroyDamage = 1.0;
        damageLevel = {1.0, 1.0};
};


function NBase::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.3,%this);
}
function NRing1::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.3,%this);
}
function NRing2::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.5,%this);
}
function NRing3::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.7,%this);
}
function NRing4::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.9,%this);
}
function NRing5::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.0,%this);
}
function NCloud1::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.1,%this);
}
function NCloud2::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.1,%this);
}
function NCloud3::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.1,%this);
}
function NCloud4::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.1,%this);
}
function NCloud5::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.2,%this);
}

function NCloud6::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.3,%this);
}
//=============================================================================================== Suicide Pack 1 (On Kill)
//=============================================================================================== Suicide Pack 2 On Deploy

MineData TNT
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Nega-Bomb";
   shapeFile = "magcargo";
   shadowDetailMask = 4;
   explosionId = MortarExp;
        explosionRadius = 50;
        damageValue = 400;
        damageType = $FlierBombDamageType;
        kickBackStrength = 4096;
        triggerRadius = 0.5;
        maxDamage = 0.09;
};

function TNT::onAdd(%this)
{
      schedule("TNTExplosion(" @ %this @ ");",0.25,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.5,%this);

}

MineData TNTflag
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Blast Pack";
   shapeFile = "magcargo";
   shadowDetailMask = 4;
   explosionId = MortarExp;
        explosionRadius = 50;
        damageValue = 50;
        damageType = $TractorDamageType;
        kickBackStrength = 1000;
        triggerRadius = 0.5;
        maxDamage = 49.999;
};

function TNTflag::onAdd(%this)
{
      schedule("TNTExplosion(" @ %this @ ");",2.95,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",3,%this);

}

MineData TNTmarlowe
{
   mass = 0.3;
   drag = 0.05;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Inversion Bomb";
   shapeFile = "cactus3";
   shadowDetailMask = 4;
   explosionId = MortarExp;
//        explosionRadius = 150;
//        damageValue = 25;
//        damageType = $TractorDamageType;
//        kickBackStrength = -1000;
        triggerRadius = 0.5;
        maxDamage = 1.999;

        explosionRadius = 250;
        damageValue = 45;
        damageType = $NullDamageType;
        kickBackStrength = -10000;
};

function TNTmarlowe::onAdd(%this)
{
      schedule("TNTExplosion(" @ %this @ ");",12.95,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",13,%this);

}

MineData TNTcrush
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Blast Pack";
   shapeFile = "liqcyl";
   shadowDetailMask = 4;
   explosionId = MortarExp;
        explosionRadius = 50;
        damageValue = 50;
        damageType = $CrushDamageType;
        kickBackStrength = 1000;
        triggerRadius = 0.5;
        maxDamage = 49.999;
};

function TNTcrush::onAdd(%this)
{
      schedule("TNTExplosion(" @ %this @ ");",0.75,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.8,%this);

}

function TNTExplosion(%this)
{
                %obj = newObject("","Mine","shockadd");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
                %obj = newObject("","Mine","shockadd2");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 2";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
                %obj = newObject("","Mine","shockadd3");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 4";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
}

MineData TNTAmazing
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Blast Pack";
//   shapeFile = "rsmoke";
   shapeFile = "vehi_pur_pnl";
   shadowDetailMask = 4;
   explosionId = MortarExp;
        explosionRadius = 50;
        damageValue = 50;
        damageType = $TractorDamageType;
        kickBackStrength = 1000;
        triggerRadius = 0.5;
        maxDamage = 49.999;
};

function TNTAmazing::onAdd(%this)
{
      schedule("TNTExplosion(" @ %this @ ");",4.95,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",5,%this);

}

//=============================================================================================== Suicide Pack 2 On Deploy

MineData BombX
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Handgrenade";
   shapeFile = "mortar";
//   shapeFile = "cactus2";
//   shapeFile = "generator_p";
   shadowDetailMask = 4;
   explosionId = MortarExp;
        explosionRadius = 10;
        damageValue = 1.5;
        damageType = $MortarDamageType;
        kickBackStrength = 1000;
        triggerRadius = 0.5;
        maxDamage = 20.0;
};

function BombX::onAdd(%this)
{
      schedule("NukeExplosion(" @ %this @ ");",1.45,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",1.5,%this);

}

function NukeExplosion(%this)
{
                %obj = newObject("","Mine","bomba");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 5.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombb");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 15.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombc");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombd");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "10.0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "-10.0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "0 10. 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "0 -10.0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 35";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombf");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 15";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
}

//=============================================================================================== Suicide Pack 2 On Deploy

MineData BombZ
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Handgrenade";
   shapeFile = "generator";
   shadowDetailMask = 4;
   explosionId = MortarExp;
        explosionRadius = 100;
        damageValue = 25;
        damageType = $FlierBombDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 50.0;
};

function BombZ::onAdd(%this)
{
      schedule("NukeExplosion2(" @ %this @ ");",14.95,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",15,%this);

}

function NukeExplosion2(%this)
{
                %obj = newObject("","Mine","NBase");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 5.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NRing1");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 10.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NRing2");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 20.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NRing3");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 25.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NRing4");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 30.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NRing5");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 35.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NCloud1");
                addToSet("MissionCleanup", %obj);
                %padd = "15.0 0 80.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NCloud2");
                addToSet("MissionCleanup", %obj);
                %padd = "-15.0 0 80.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NCloud3");
                addToSet("MissionCleanup", %obj);
                %padd = "0 15.0 80.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NCloud4");
                addToSet("MissionCleanup", %obj);
                %padd = "0 -15.0 80.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","NCloud5");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 100.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
}

MineData Shockadd
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "End of the line";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = LargeShockwave;
        explosionRadius = 37.5;
        damageValue = 0.25;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 0.5;
};

function shockadd::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData Shockadd2
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "End of the line";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = LargeShockwave;
        explosionRadius = 37.5;
        damageValue = 0.25;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 0.5;
};

function shockadd2::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData Shockadd3
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "End of the line";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = LargeShockwave;
        explosionRadius = 37.5;
        damageValue = 0.25;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 0.5;
};

function shockadd3::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData MinePlayer1
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.001;
        friction = 1.0;
        className = "Holomine";
        description = "Lagging Player";
        shapeFile = "larmor";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 10.0;
        damageValue = 20.0;
        damageType = $BustedDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 20.5;
};

function MinePlayer1::onAdd(%this)
{
                schedule("MinePlayer1Explosion(" @ %this @ ");",15,%this);
%data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",15,%this);

}

function MinePlayer1::onCollision(%this,%obj)
{
    if(getObjectType(%obj) != "Player")
        {
        return;
        }

    if(Player::isDead(%obj))
        {
        return;
        }

    %c = Player::getClient(%obj);


    %playerTeam = GameBase::getTeam(%obj);
        %teleTeam = GameBase::getTeam(%this);


%armor = Player::getArmor(%obj);
                   if (%armor == "earmor" || %armor == "efemale")
                {
                   %rnd = floor(getRandom() * 10);
                   if(%rnd > 7)
                   {
                       Client::sendMessage(%c,1,"OOPS! You cut the wrong wire...");
                       Mine::Detonate(" @ %this @ ");
                       return;
                   }
                   else
                   {
                       deleteObject(%this);
                       Client::sendMessage(%c,1,"You disarmed the Dynamite.");
                   }
                }

}

function MinePlayer1Explosion(%this)
{
                %obj = newObject("","Mine","shockadd");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 1.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

}

MineData MinePlayer2
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.001;
        friction = 1.0;
        className = "Holomine";
        description = "Lagging Player";
        shapeFile = "marmor";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 10.0;
        damageValue = 20.0;
        damageType = $BustedDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 20.5;
};


function MinePlayer2::onAdd(%this)
{
                schedule("MinePlayer2Explosion(" @ %this @ ");",15,%this);
%data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",15,%this);

}

function MinePlayer2::onCollision(%this,%obj)
{
    if(getObjectType(%obj) != "Player")
        {
        return;
        }

    if(Player::isDead(%obj))
        {
        return;
        }

    %c = Player::getClient(%obj);


    %playerTeam = GameBase::getTeam(%obj);
        %teleTeam = GameBase::getTeam(%this);


%armor = Player::getArmor(%obj);
                   if (%armor == "earmor" || %armor == "efemale")
                {
                %rnd = floor(getRandom() * 10);
                                                        if(%rnd > 7)
                                                        {
                                                          Client::sendMessage(%c,1,"OOPS! You cut the wrong wire...");
                                                                Mine::Detonate(" @ %this @ ");
                                                        return;
                                                        }
                                                        else
                                                        {
                                                        deleteObject(%this);
                                                        Client::sendMessage(%c,1,"You disarmed the Dynamite.");
                                                        }
                }

}

function MinePlayer2Explosion(%this)
{
                %obj = newObject("","Mine","shockadd");
                addToSet("MissionCleanup", %obj);

               %padd = "0 0 1.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

}

MineData MinePlayer3
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.001;
        friction = 1.0;
        className = "Holomine";
        description = "Lagging Player";
        shapeFile = "harmor";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 10.0;
        damageValue = 20.0;
        damageType = $BustedDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 20.5;
};

function MinePlayer3::onAdd(%this)
{
                schedule("MinePlayer3Explosion(" @ %this @ ");",15,%this);
%data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",15,%this);

}

function MinePlayer3::onCollision(%this,%obj)
{
    if(getObjectType(%obj) != "Player")
        {
        return;
        }

    if(Player::isDead(%obj))
        {
        return;
        }

    %c = Player::getClient(%obj);


    %playerTeam = GameBase::getTeam(%obj);
        %teleTeam = GameBase::getTeam(%this);


%armor = Player::getArmor(%obj);
                   if (%armor == "earmor" || %armor == "efemale")
                {
                %rnd = floor(getRandom() * 10);
                                                        if(%rnd > 7)
                                                        {
                                                          Client::sendMessage(%c,1,"OOPS! You cut the wrong wire...");
                                                                Mine::Detonate(" @ %this @ ");
                                                        return;
                                                        }
                                                        else
                                                        {
                                                        deleteObject(%this);
                                                        Client::sendMessage(%c,1,"You disarmed the Dynamite.");
                                                        }
                }

}

function MinePlayer3Explosion(%this)
{
                %obj = newObject("","Mine","shockadd");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 1.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

}

MineData Bomba
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Bomblet";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $TractorDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Bomba::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData Bombb
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Bomblet";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $FlierBombDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Bombb::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData Bombc
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Bomblet";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $FlierBombDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Bombc::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.25,%this);
}

MineData Bombd
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Bomblet";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = GrenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $FlierBombDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Bombd::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.5,%this);
}

MineData Bombe
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Bomblet";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = mortarExp;
        explosionRadius = 25.0;
        damageValue = 0.5;
        damageType = $FlierBombDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Bombe::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.75,%this);
}

MineData Bombf
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Bomblet";
        shapeFile = "force";
        shadowDetailMask = 4;
        explosionId = LargeShockwave;
        explosionRadius = 37.5;
        damageValue = 0.5;
        damageType = $FlierBombDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Bombf::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",0.375,%this);
}

//=-=-=-=-
MineData Cluster1
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Cluster";
        shapeFile = "grenade";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15;
        damageValue = 0.5;
        damageType = $PlasmaDamageType;
        kickBackStrength = 50;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Cluster1::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

MineData Cluster2
{
           mass = 4.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
        description = "Cluster";
        shapeFile = "grenade";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15;
        damageValue = 0.8;
        damageType = $PlasmaDamageType;
        kickBackStrength = 150;
        triggerRadius = 0.8;
        maxDamage = 2.5;
};

function Cluster2::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",2.25,%this);
}

MineData Cluster3
{
          mass = 8.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.55;
        friction = 1.0;
        className = "Handgrenade";
        description = "Cluster";
        shapeFile = "grenade";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 1.0;
        damageType = $PlasmaDamageType;
        kickBackStrength = 250;
        triggerRadius = 1.5;
        maxDamage = 2.5;
};

function Cluster3::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",2.5,%this);
}

MineData Cluster4
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.28;
        friction = 1.0;
        className = "Handgrenade";
        description = "Cluster";
        shapeFile = "grenade";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $PlasmaDamageType;
        kickBackStrength = 40;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Cluster4::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",2.75,%this);
}

MineData Cluster5
{
           mass = 5.0;
           drag = 1.0;
           density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
        description = "Cluster";
        shapeFile = "grenade";
        shadowDetailMask = 4;
        explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $PlasmaDamageType;
        kickBackStrength = 10;
        triggerRadius = 0.5;
        maxDamage = 1.5;
};

function Cluster5::onAdd(%this)
{
        schedule("Mine::Detonate(" @ %this @ ");",1.75,%this);
}

//===================================================================================
MineData PocketNuke1
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Pocket Nuke 1";
   shapeFile = "mortar";
   shadowDetailMask = 4;
   explosionId = FDExp;
        explosionRadius = 10.0;
        damageValue = 1;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 4;
};

function PocketNuke1::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.7,%this);
	  schedule("DeployShrapnel(" @ %this @ " , 32);",0.8,%this);
}


MineData PocketNuke2
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Pocket Nuke 2";
   shapeFile = "mortar";
//   shapeFile = "breath";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 10.0;
        damageValue = 1;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 4;
};

function PocketNuke2::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.7,%this);
}

//===================================================================================
MineData HavocBlast
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Pocket Nuke 2";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
	explosionRadius = 20.0;
	damageValue = 25;
	damageType = $TractorDamageType;
//	damageType = $MortarDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlast::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData HavocBlastH
{
	mass = 0.1;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Pocket Nuke 2";
	shapeFile = "ammo2";
//	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
	explosionRadius = 15.0;
	damageValue = 10.0;
	damageType = $PulseDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastH::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.5,%this);
}

//===================================================================================
MineData HavocBlastT
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Terrax Fart";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
//	explosionId = Shockwave;
	explosionRadius = 12.5;
	damageValue = 1.75;
	damageType = $ImmuneTDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastT::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData HavocBlastD
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Destroyer Fart";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
//	explosionId = Shockwave;
	explosionRadius = 12.5;
	damageValue = 1.75;
	damageType = $ImmuneDDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastD::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData HavocBlastM
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Mechanic Fart";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
//	explosionId = Shockwave;
	explosionRadius = 12.5;
	damageValue = 1.75;
	damageType = $ImmuneMDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastM::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData HavocBlastZ
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "ZzaxX Fart";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
//	explosionId = Shockwave;
	explosionRadius = 12.5;
	damageValue = 1.75;
	damageType = $ImmuneZDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastZ::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData HavocBlastQ
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Quicksilver Fart";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
//	explosionId = Shockwave;
	explosionRadius = 12.5;
	damageValue = 1.75;
	damageType = $ImmuneQDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastQ::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData HavocBlastG
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Ghost Fart";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
//	explosionId = Shockwave;
	explosionRadius = 12.5;
	damageValue = 1.75;
	damageType = $ImmuneGDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastG::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

MineData HavocBlastHUGE
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "HUGE Fart";
	shapeFile = "rsmoke";
	shadowDetailMask = 4;
	explosionId = LargeShockwave;
	explosionRadius = 100.0;
	damageValue = 7.5;
	damageType = $TractorDamageType;
	kickBackStrength = 2000;
	triggerRadius = 0.5;
	maxDamage = 4;
};

function HavocBlastHUGE::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.1,%this);
}

//===================================================================================
MineData BSPulla
{
   mass = 0;
   drag = 1.0;
   density = 2.0;
        elasticity = 0;
        friction = 0;
        className = "Singularity";
   description = "Singularity";
   shapeFile = "breath";
   shadowDetailMask = 4;
   explosionId = MortarExp;
        explosionRadius = 75.0;
        damageValue = 101;
        damageType = $VulcanDamageType;
        kickBackStrength = -1024;
        triggerRadius = 0.5;
        maxDamage = 100;
};

function BSPulla::onAdd(%this)
{
      schedule("BShaRMSUCK(" @ %this @ ");",2.9,%this);
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this  @ ");",3,%this);
}

function BSHarmSuck(%this)
{
                %obj = newObject("","Mine","shockadd");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
                %obj = newObject("","Mine","shockadd2");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 2";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
                %obj = newObject("","Mine","shockadd3");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 4";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
}

MineData BSpull1
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull1::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.25,%this);
}

MineData BSpull2
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull2::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.5,%this);
}

MineData BSpull3
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull3::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.75,%this);
}

MineData BSpull4
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull4::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",1.0,%this);
}

MineData BSpull5
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull5::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",1.25,%this);
}

MineData BSpull6
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull6::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",1.5,%this);
}

MineData BSpull7
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull7::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",1.75,%this);
}

MineData BSpull8
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull8::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

MineData BSpull9
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.15;
        friction = 1.0;
        className = "Handgrenade";
   description = "Black star negative force";
   shapeFile = "rsmoke";
   shadowDetailMask = 4;
   explosionId = LargeShockwave;
        explosionRadius = 150.0;
        damageValue = 0;
        damageType = $NullDamageType;
        kickBackStrength = -512;
        triggerRadius = 0.5;
        maxDamage = 0;
};

function BSpull9::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.5,%this);
}

//----------------------------------------------------------------------------

MineData MDHandgrenade1
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.45;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Grenade";
   shapeFile = "mortar";
   shadowDetailMask = 4;
   explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $ShrapnelDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MDHandgrenade1::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

//----------------------------------------------------------------------------

MineData MDHandgrenade2
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.45;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Grenade";
   shapeFile = "mortar";
   shadowDetailMask = 4;
   explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $ShrapnelDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MDHandgrenade2::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.4,%this);
}
//----------------------------------------------------------------------------

MineData MDHandgrenade3
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.45;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Grenade";
   shapeFile = "mortar";
   shadowDetailMask = 4;
   explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $ShrapnelDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MDHandgrenade3::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.7,%this);
}
//----------------------------------------------------------------------------

MineData MDHandgrenade4
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.45;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Grenade";
   shapeFile = "mortar";
   shadowDetailMask = 4;
   explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $ShrapnelDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MDHandgrenade4::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",3.1,%this);
}
//----------------------------------------------------------------------------

MineData MDHandgrenade5
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.45;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Grenade";
   shapeFile = "mortar";
   shadowDetailMask = 4;
   explosionId = grenadeExp;
        explosionRadius = 15.0;
        damageValue = 0.5;
        damageType = $ShrapnelDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MDHandgrenade5::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",3.5,%this);
}
//----------------------------------------------------------------------------

MineData MHandgrenade1
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;

        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Mortar";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 1;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MHandgrenade1::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

//----------------------------------------------------------------------------

MineData MHandgrenade2
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Mortar";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 1;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MHandgrenade2::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.4,%this);
}
//----------------------------------------------------------------------------

MineData MHandgrenade3
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Mortar";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 1;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MHandgrenade3::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.7,%this);
}
//----------------------------------------------------------------------------

MineData MHandgrenade4
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Mortar";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 1;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MHandgrenade4::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",3.1,%this);
}
//----------------------------------------------------------------------------

MineData MHandgrenade5
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Mortar";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 1;
        damageType = $MortarDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function MHandgrenade5::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",3.5,%this);
}

MineData EHandgrenade6
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Mortar";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = mortarExp;
        explosionRadius = 20.0;
        damageValue = 5;
        damageType = $EnergyDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 2;
};

function EHandgrenade6::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",0.5,%this);
}

MineData MEHandgrenade1
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Explosion";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = impExp;
        explosionRadius = 7.5;
        damageValue = 1;
        damageType = $MineDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1;
};

function MHandgrenade1::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

//----------------------------------------------------------------------------

MineData MEHandgrenade2
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Explosion";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = impExp;
        explosionRadius = 7.5;
        damageValue = 1;
        damageType = $MineDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1;
};

function MHandgrenade2::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.4,%this);
}
//----------------------------------------------------------------------------

MineData MEHandgrenade3
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Explosion";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = impExp;
        explosionRadius = 7.5;
        damageValue = 1;
        damageType = $MineDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1;
};

function MHandgrenade3::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",2.7,%this);
}
//----------------------------------------------------------------------------

MineData MEHandgrenade4
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Explosion";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = impExp;
        explosionRadius = 7.5;
        damageValue = 1;
        damageType = $MineDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1;
};

function MHandgrenade4::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",3.1,%this);
}
//----------------------------------------------------------------------------

MineData MEHandgrenade5
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
        elasticity = 0.25;
        friction = 1.0;
        className = "Handgrenade";
   description = "Implosion Explosion";
   shapeFile = "armorkit";
   shadowDetailMask = 4;
   explosionId = impExp;
        explosionRadius = 7.5;
        damageValue = 1;
        damageType = $MineDamageType;
        kickBackStrength = 100;
        triggerRadius = 0.5;
        maxDamage = 1;
};

function MHandgrenade5::onAdd(%this)
{
        %data = GameBase::getDataName(%this);
        schedule("Mine::Detonate(" @ %this @ ");",3.5,%this);
}

//----------------------------------------------------------------------------

MineData Shrapnel
{
   mass = 0.3;
   drag = 1.0;

  density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Shrapnel";
   description = "Shrapnel";
   shapeFile = "staff";
   shadowDetailMask = 4;
   explosionId = bulletExp0;
	explosionRadius = 1.0;
	damageValue = 0.07;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2;
};

function Shrapnel::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",0.75,%this);
}

function DeployShrapnel(%this, %count) 
{
	if(%count && %this)
	{
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-20,true);
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-20,false);
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,20,false);
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,20,true);
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-25,false);
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-25,true);
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this, 25,false);
		%obj = newObject("","Mine","Shrapnel");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this, 25,true);
		%count -= 1;
		schedule("DeployShrapnel(" @ %this @ ", " @ %count @ ");",0.5,%this);
	}
}

//----------------------------------------------------------------------------

MineData FWgrenade1
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.45;
	friction = 1.0;
	className = "Handgrenade";
	description = "FireWall Grenade";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 15.0;
	damageValue = 0.5;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2000;
};

function FWgrenade1::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	StartFireWall(%this);
//	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

MineData FWgrenade2
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.45;
	friction = 1.0;
	className = "Handgrenade";
	description = "FireWall Grenade";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 15.0;
	damageValue = 0.5;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2000;
};

function FWgrenade2::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	StartFireWall(%this);
//	schedule("Mine::Detonate(" @ %this @ ");",2.4,%this);
}

MineData FWgrenade3
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.45;
	friction = 1.0;
	className = "Handgrenade";
	description = "FireWall Grenade";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 15.0;
	damageValue = 0.5;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2000;
};

function FWgrenade3::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	StartFireWall(%this);
//	schedule("Mine::Detonate(" @ %this @ ");",2.7,%this);
}

MineData FWgrenade4
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.45;
	friction = 1.0;
	className = "Handgrenade";
	description = "FireWall Grenade";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 15.0;
	damageValue = 0.5;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2000;
};

function FWgrenade4::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	StartFireWall(%this);
//	schedule("Mine::Detonate(" @ %this @ ");",3.1,%this);
}

MineData FWgrenade5
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.45;
	friction = 1.0;
	className = "Handgrenade";
	description = "FireWall Grenade";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 15.0;
	damageValue = 0.5;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2000;
};

function FWgrenade5::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	StartFireWall(%this);
//	schedule("Mine::Detonate(" @ %this @ ");",3.5,%this);
}

//----------------------------------------------------------------------------

MineData SmokeGrenade1
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.45;
	friction = 1.0;
	className = "Handgrenade";
	description = "Smoke Grenade";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 15.0;
	damageValue = 0.05;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2000;
};

function SmokeGrenade1::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	StartSmoke(%this);
}

MineData SmokeGrenade2
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.45;
	friction = 1.0;
	className = "Handgrenade";
	description = "Smoke Grenade";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	explosionId = grenadeExp;
	explosionRadius = 15.0;
	damageValue = 0.05;
	damageType = $ShrapnelDamageType;
	kickBackStrength = 100;
	triggerRadius = 0.5;
	maxDamage = 2000;
};

function SmokeGrenade2::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	StartSmoke(%this);
}

//----------------------------------------------------------------------------


