//============================ Meltdown String Defs
$ItemFavoritesKey = "MeltdownHolocaustv022402"; 
$ModFavoritesKey = "MeltdownHolocaustv022402";
$DisplayTime = 8;
$ItemPopTime = 30;

$ToolSlot=0;
$WeaponSlot=0;
$BackpackSlot=1;
$FlagSlot=2;
$DefaultSlot=3;
$ExtraWeaponSlotA=4;
$ExtraWeaponSlotB=5;
$ExtraWeaponSlotC=6;
//$ArmorDetailSlot=7;
$ExtraWeaponSlotD=7;
//$ExtraSlot=4;
//$ExtraWeaponSlot=5;

$AutoUse[Blaster] = True;
$AutoUse[Chaingun] = True;
$AutoUse[PlasmaGun] = True;
$AutoUse[Mortar] = True;
$AutoUse[GrenadeLauncher] = True;
$AutoUse[LaserRifle] = True;
$AutoUse[EnergyRifle] = True;
$AutoUse[TargetingLaser] = False;
$AutoUse[ChargeGun] = True;

$Use[Blaster] = True;

$ArmorType[Male, LightArmor] = larmor;
$ArmorType[Male, MediumArmor] = marmor;
$ArmorType[Male, HeavyArmor] = harmor;
$ArmorType[Female, LightArmor] = lfemale;
$ArmorType[Female, MediumArmor] = mfemale;	   
$ArmorType[Female, HeavyArmor] = harmor;

$ArmorName[larmor] = LightArmor;
$ArmorName[marmor] = MediumArmor;
$ArmorName[harmor] = HeavyArmor;
$ArmorName[lfemale] = LightArmor;
$ArmorName[mfemale] = MediumArmor;

// Amount to remove when selling or dropping ammo
$SellAmmo[BulletAmmo] = 50;
$SellAmmo[PlasmaAmmo] = 5;
$SellAmmo[DiscAmmo] = 5;
$SellAmmo[GrenadeAmmo] = 5;
$SellAmmo[MortarAmmo] = 5;
$SellAmmo[Beacon] = 5;
$SellAmmo[MineAmmo] = 5;
$SellAmmo[Grenade] = 5;
$SellAmmo[EMPGrenadeAmmo] = 5;

// Max Amount of ammo the Ammo Pack can carry
$AmmoPackMax[BulletAmmo] = 200;
$AmmoPackMax[PlasmaAmmo] = 200;
$AmmoPackMax[DiscAmmo] = 200;
$AmmoPackMax[GrenadeAmmo] = 200;
$AmmoPackMax[MortarAmmo] = 200;
$AmmoPackMax[MineAmmo] = 75;
$AmmoPackMax[Grenade] = 75;
$AmmoPackMax[Beacon] = 75;
$AmmoPackMax[RepairKit] = 25;
$AmmoPackMax[EMPGrenadeAmmo] = 200;

// Items in the AmmoPack
$AmmoPackItems[0] = BulletAmmo;
$AmmoPackItems[1] = PlasmaAmmo;
$AmmoPackItems[2] = DiscAmmo;
$AmmoPackItems[3] = GrenadeAmmo;
$AmmoPackItems[4] = Grenade;
$AmmoPackItems[5] = MineAmmo;
$AmmoPackItems[6] = MortarAmmo;
$AmmoPackItems[7] = Beacon;
//$AmmoPackItems[8] = EMPGrenadeAmmo;

// Limit on number of special Items you can buy
$TeamItemMax[DeployableAmmoPack] = 7;
$TeamItemMax[DeployableInvPack] = 15;
$TeamItemMax[TurretPack] = 10;
$TeamItemMax[CameraPack] = 15;
$TeamItemMax[DeployableSensorJammerPack] = 18;
$TeamItemMax[PulseSensorPack] = 15;
$TeamItemMax[MotionSensorPack] = 15;
$TeamItemMax[ScoutVehicle] = 3;
$TeamItemMax[HAPCVehicle] = 1;
$TeamItemMax[LAPCVehicle] = 2;
$TeamItemMax[Beacon] = 80;
$TeamItemMax[mineammo] = 35;

// Limit on number of special Items you can buy
$TeamItemMax[DeployableAmmoPack] = 7;
$TeamItemMax[DeployableInvPack] = 15;
$TeamItemMax[TurretPack] = 10;
$TeamItemMax[CameraPack] = 15;
$TeamItemMax[DeployableSensorJammerPack] = 18;
$TeamItemMax[PulseSensorPack] = 15;
$TeamItemMax[MotionSensorPack] = 15;
$TeamItemMax[ScoutVehicle] = 3;
$TeamItemMax[HAPCVehicle] = 1;
$TeamItemMax[LAPCVehicle] = 2;
$TeamItemMax[Beacon] = 80;
$TeamItemMax[mineammo] = 35;

//============================== End Meltdown String Defs

// Global object damage skins (staticShapes Turrets Stations Sensors)
DamageSkinData objectDamageSkins
{
   bmpName[0] = "dobj1_object";
   bmpName[1] = "dobj2_object";
   bmpName[2] = "dobj3_object";
   bmpName[3] = "dobj4_object";
   bmpName[4] = "dobj5_object";
   bmpName[5] = "dobj6_object";
   bmpName[6] = "dobj7_object";
   bmpName[7] = "dobj8_object";
   bmpName[8] = "dobj9_object";
   bmpName[9] = "dobj10_object";
};

// Weapon to ammo table
$WeaponAmmo[Blaster] = "";
$WeaponAmmo[PlasmaGun] = PlasmaAmmo;
$WeaponAmmo[Chaingun] = BulletAmmo;
$WeaponAmmo[DiscLauncher] = DiscAmmo;
$WeaponAmmo[GrenadeLauncher] = GrenadeAmmo;
$WeaponAmmo[Mortar] = MortarAmmo;
$WeaponAmmo[LaserRifle] = "";
$WeaponAmmo[EnergyRifle] = "";
//$WeaponAmmo[EMPGrenadeLauncher] = EMPGrenadeAmmo;
$WeaponAmmo[RPGLauncher] = GrenadeAmmo;
$WeaponAmmo[RPMLauncher] = MortarAmmo;
$WeaponAmmo[RPEMPLauncher] = EMPGrenadeAmmo;

//----------------------------------------------------------------------------
// Server side methods
// The client side inventory dialogs call buyItem, sellItem,
// useItem and dropItem through remoteEvals.

function teamEnergyBuySell(%player,%cost)
{
	%client = Player::getClient(%player);
	%team = Client::getTeam(%client);
	// IF - Cost positive selling    IF - Cost Negitive buying 
	%station = %player.Station;
	%stationName = GameBase::getDataName(%station); 
	if(%stationName == DeployableInvStation || %stationName == DeployableAmmoStation) {
		%station.Energy += %cost;			//Remote StationEnergy
		if(%station.Energy < 1)
			%station.Energy = 0;
	}
	else if($TeamEnergy[%team] != "Infinite") { 
		$TeamEnergy[%team] += %cost;    //Total TeamEnergy
 		%client.teamEnergy += %cost;   //Personal TeamEnergy
	}
}

function remoteBuyFavorites(%client,%favItem0,%favItem1,%favItem2,%favItem3,%favItem4,%favItem5,%favItem6,%favItem7,%favItem8,%favItem9,%favItem10,%favItem11,%favItem12,%favItem13,%favItem14,%favItem15,%favItem16,%favItem17,%favItem18,%favItem19)
{
  // only can buy fav every 1/2 second
   %time = getIntegerTime(true) >> 4; // int half seconds
   if(%time <= %client.lastBuyFavTime)
      return;

   %curItem = Player::getMountedItem(%client,$WeaponSlot); 
   %client.lastBuyFavTime = %time;

	%station = (Client::getOwnedObject(%client)).Station;
	if(%station != "" ) {
		%stationName = GameBase::getDataName(%station); 
		if(%stationName == DeployableInvStation || %stationName == DeployableAmmoStation) 
			%energy = %station.Energy;
		else 
			%energy = $TeamEnergy[Client::getTeam(%client)];
		if(%energy == "Infinite" || %energy > 0) {
			%error = 0;
			%bought = 0;
			%max = getNumItems();
			for (%i = 0; %i < %max; %i = %i + 1) { 
				%item = getItemData(%i);
				if ($ServerCheats || Client::isItemShoppingOn(%client,%item)|| $TestCheats) {
					%count = Player::getItemCount(%client,%item);
					if(%count) {
						if(%item.className != Armor) 
							teamEnergyBuySell(Client::getOwnedObject(%client),(%item.price * %count));
						Player::setItemCount(%client, %item, 0);  
					}
				}
			}
			for (%i = 0; %i < 20; %i++) { 
				if(%favItem[%i] != "") {
					%item = getItemData(%favItem[%i]);
					if ((Client::isItemShoppingOn(%client,%item)) && ($ItemMax[Player::getArmor(%client),  %item] > Player::getItemCount(%client,%item) || %item.className == Armor)) {
						if(!buyItem(%client,%item))  
							%error = 1;
						else
							%bought++;
					}
				}
		  	}
			if(%bought) {
				if(%error) 
					Client::sendMessage(%client,0,"~wC_BuySell.wav");
				else 
					Client::SendMessage(%client,0,"~wbuysellsound.wav");
			}
			if (isSelectableWeapon(%client,%curItem))
				Player::useItem(%client,%curItem);
			else if (%curItem == "RepairGun") 
				Player::useItem(%client,"RepairPack");
			else 
				selectValidWeapon(%client);
			updateBuyingList(%client);
		}
	}
}


function replenishTeamEnergy(%team)
{
	$TeamEnergy[%team] += $incTeamEnergy;
	schedule("replenishTeamEnergy(" @ %team @ ");", $secTeamEnergy);
}

function resetArmor(%client,%armor)
{	%player=Client::getOwnedObject(%client);
	%client.inStasis--;
	if(%client.inStasis<=0)
	{	Player::setArmor(%client,%armor);
		%client.inStasis=0;
		%rate=$Recharge[%client.talent[$Rch]];
		%player=Client::getOwnedObject(%client);
		GameBase::setRechargeRate(%player,%rate);
	}
	else if(%client.inStasis >= 3)
	{	schedule("resetArmor("@%client@","@%armor@");",1,%player);
	}
	else
		schedule("resetArmor("@%client@","@%armor@");",2,%player);
}

function checkResources(%player,%item,%delta,%noMessage)
{
	%client = Player::getClient(%player);
	%team = Client::getTeam(%client);
	%extraAmmo = 0 ;
	if (Player::getMountedItem(%client,$BackpackSlot) == ammopack && $AmmoPackMax[%item] != "") {
		%extraAmmo = $AmmoPackMax[%item];
		if(%delta == $ItemMax[Player::getArmor(%client), %item]) 
			%delta = %delta + %extraAmmo;
	}
	if($TestCheats == 0 && %client.spawn == "") {
		%energy = $TeamEnergy[%team];
    	%station = %player.Station;
		%sName = GameBase::getDataName(%station);
		if(%sName == DeployableInvStation || %sName == DeployableAmmoStation){
			%energy = %station.Energy;
		}
		if(%energy != "Infinite") {
			if (%item.price * %delta > %energy)	
				%delta = %energy / %item.price; 
			if(%delta < 1 ) {
				if(%noMessage == "")
					Client::sendMessage(%client,0,"Can't buy " @ %item.description @ " - "@ %energy @ " Energy points left");
				return 0;
			}
		}
	}
	if(%item.className == Weapon) {
		%armor = Player::getArmor(%client);
		%wcount = Player::getItemClassCount(%client,"Weapon");
		if (Player::getItemClassCount(%client,"Weapon") >= $MaxWeapons[%armor]) {
			Client::sendMessage(%client,0,"Too many weapons for " @ $ArmorName[%armor].description @ " to carry");
			return 0;
		}
  	}
	else if(%item == RepairPatch) {
		%pDamage = GameBase::getDamageLevel(%player);
		if(GameBase::getDamageLevel(%player) > 0) 
			return 1;
		return 0;
   }
   else if($TeamItemMax[%item] != "" && !$TestCheats) {
		if($TeamItemMax[%item] <= $TeamItemCount[%team, %item]) {
			Client::sendMessage(%client,0,"Deployable item limit reached for " @ %item.description @ "s");
			return 0;
		}
	}
	if(%item.className != Armor && %item.className != Vehicle) {
	   %count = Player::getItemCount(%client,%item);
	  	%max = $ItemMax[(Player::getArmor(%client)), %item] + %extraAmmo ;
	   if(%delta + %count >= %max) 
			%delta = %max - %count;
	}
	return %delta;
}

function buyItem(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%armor = Player::getArmor(%client);
	if (($ServerCheats || Client::isItemShoppingOn(%client,%item) || $TestCheats || %client.spawn) && 
			($ItemMax[%armor, %item] || %item.className == Armor || %item.className == Vehicle || $TestCheats)) {
		if (%item.className == Armor) {
			// Assign armor by requested type & gender 
			%buyarmor = $ArmorType[Client::getGender(%client), %item];
			if(%armor != %buyarmor || Player::getItemCount(%client,%item) == 0)	{
				teamEnergyBuySell(%player,$ArmorName[%armor].price);
				if(checkResources(%player,%item,1)) {
					teamEnergyBuySell(%player,$ArmorName[%buyarmor].price * -1);
					Player::setArmor(%client,%buyarmor);
					checkMax(%client,%buyarmor);
					armorChange(%client);
     				Player::setItemCount(%client, $ArmorName[%armor], 0);  
     				Player::setItemCount(%client, %item, 1);

						if(%buyarmor == "MECH") 
						{
							GameBase::startFadein(%player);
							Player::setSensorSupression(%player,0);
	 						$cloaked[%player] = 0;
							Cloaker(%player);
							Player::setItemCount(%client, DestroyerGrenFwd,1);
							Player::mountItem(%client, DestroyerGrenFwd, 3);
							gameBase::setAutoRepairRate(%player, 0);
							GameBase::setRechargeRate(%player,10);
							Player::setItemCount(%player, WarpXTool,0);
							Client::sendMessage(%client,1,"Destroyer armor is immune to Fire and Stunning.  And mounts the Devastator Cannon in place of throwing grenades.");
						} 
						else if(%buyarmor == "harmor") 
						{
							GameBase::startFadein(%player);
							Player::setSensorSupression(%player,0);
	 						$cloaked[%player] = 0;
							Cloaker(%player);
							%player.shieldStrength = 0;
							GameBase::setRechargeRate(%player,10);
							Player::setItemCount(%player, WarpXTool,0);
							gameBase::setAutoRepairRate(%player, 0);
							if(Player::getMountedItem(%player, 3) == DestroyerGrenFwd) {
								Player::unmountItem(%player, 3);
								Player::setItemCount(%player, DestroyerGrenFwd,0);
							}
							Client::sendMessage(%client,1,"Terrax is heavily armored and can carry the heavy weapons.  It is immune to Blaster-fire and Smoke.");
						}
						else if(%buyarmor == "marmor" || %buyarmor == "mfemale") 
						{
							GameBase::startFadein(%player);
							Player::setSensorSupression(%player,0);
	 						$cloaked[%player] = 0;
							Cloaker(%player);
							%player.shieldStrength = 0;
							GameBase::setRechargeRate(%player,10);
							gameBase::setAutoRepairRate(%player, 0.15);
							Player::setItemCount(%player, WarpXTool,0);
							Player::setItemCount(%player, ElectricityRifle,1);
							Player::setItemCount(%player, Reassembler,1);
							if(Player::getMountedItem(%player, 3) == DestroyerGrenFwd) {
								Player::unmountItem(%player, 3);
								Player::setItemCount(%player, DestroyerGrenFwd,0);
							}
							Client::sendMessage(%client,1,"Mechanic armor is immune to HellFire, Acid and Poison.  It can only carry 2 weapons, but is the only armor able to deploy stuff.");
						}
						else if(%buyarmor == "larmor" || %buyarmor == "lfemale") 
						{
							GameBase::startFadein(%player);
							Player::setSensorSupression(%player,0);
	 						$cloaked[%player] = 0;
							Cloaker(%player);
							%player.shieldStrength = 0;
							GameBase::setRechargeRate(%player,10);
							gameBase::setAutoRepairRate(%player, 0);
							Player::setItemCount(%player, WarpXTool,0);
							if(Player::getMountedItem(%player, 3) == DestroyerGrenFwd) {
								Player::unmountItem(%player, 3);
								Player::setItemCount(%player, DestroyerGrenFwd,0);
							}
							Client::sendMessage(%client,1,"Quicksilver armor is very fast.");
						}
						else if(%buyarmor == "BlastechM" || %buyarmor == "BlastechF") 
						{
							GameBase::startFadeout(%player);
 							$cloaked[%player] = 1;
 							Cloaker(%player);
							Player::setSensorSupression(%player,1);
							%player.shieldStrength = 0;
							GameBase::setRechargeRate(%player,10);
							gameBase::setAutoRepairRate(%player, 0);
							Player::setItemCount(%player, WarpXTool,1);
							if(Player::getMountedItem(%player, 3) == DestroyerGrenFwd) {
								Player::unmountItem(%player, 3);
								Player::setItemCount(%player, DestroyerGrenFwd,0);
							}
							Client::sendMessage(%client,1,"Ghost armor starts off cloaked and jamming.  Plus, it carries an item that allows it to WALK THRU WALLS.");
						}
						else if(%buyarmor == "MagIonM" || %buyarmor == "MagIonF") 
						{
							GameBase::startFadein(%player);
							Player::setSensorSupression(%player,0);
	 						$cloaked[%player] = 0;
							Cloaker(%player);
							%player.shieldStrength = 0;
							GameBase::setRechargeRate(%player,30);
							gameBase::setAutoRepairRate(%player, 0);
							Player::setItemCount(%player, WarpXTool,0);
							if(Player::getMountedItem(%player, 3) == DestroyerGrenFwd) {
								Player::unmountItem(%player, 3);
								Player::setItemCount(%player, DestroyerGrenFwd,0);
							}
							Client::sendMessage(%client,1,"ZzaxX armor is immune to EMP.");
						}
					if (Player::getMountedItem(%client,$BackpackSlot) == ammopack) 
						fillAmmoPack(%client);	
					return 1;
				}

				teamEnergyBuySell(%player,$ArmorName[%armor].price * -1);
			}
		}
		else if (%item.className == Backpack) {
			// Only one backpack per armor.
			%pack = Player::getMountedItem(%client,$BackpackSlot);
			if (%pack != -1) {
				if(%pack == ammopack) 
					checkMax(%client,%armor);
				else if(%pack == Accelerator) {
					if(Player::getItemCount(%client,"PBW") > 0) {
						Client::sendMessage(%client,0,"Sold Particle Accelerator - Auto Selling PBW");
						remoteSellItem(%client, "PBW");						
					}
				}	
				teamEnergyBuySell(%player,%pack.price);
				Player::decItemCount(%client,%pack);
			}			   
			if (checkResources(%player,%item,1) || $testCheats) {
				teamEnergyBuySell(%player,%item.price * -1);
				Player::incItemCount(%client,%item);
				Player::useItem(%client,%item);									 
				if(%item == ammopack) 
					fillAmmoPack(%client);
				return 1;
			}
			else if(%pack != -1) {
				teamEnergyBuySell(%player,%pack.price * -1);
				Player::incItemCount(%client,%pack);
				Player::useItem(%client,%pack);									 
				if(%pack == ammopack) 
					fillAmmoPack(%client);
			}				 
		}
		else if(%item.className == Weapon) {
			if(checkResources(%player,%item,1)) {
				if(%item == PBW && Player::getItemCount(%client,"Accelerator") == 0) {
					buyItem(%client,"Accelerator");
					Client::sendMessage(%client,0,"Bought PBW - Auto buying Accelerator");
				}
				Player::incItemCount(%client,%item);
				teamEnergyBuySell(%player,(%item.price * -1));
				%ammoItem =  %item.imageType.ammoType; 
				if(%ammoItem != "") {
					%delta = checkResources(%player,%ammoItem,$ItemMax[%armor, %ammoItem]);
					if(%delta || $testCheats) {
						teamEnergyBuySell(%player,(%ammoItem.price * -1 * %delta));
						Player::incItemCount(%client,%ammoitem,%delta);
					}
				}
				return 1;
			}
		}
	 	else if(%item.className == Vehicle) {
			%shouldBuy = VehicleStation::checkBuying(%client,%item);
			if(%shouldBuy == 1) {
				teamEnergyBuySell(%player,(%item.price * -1));
				return 1;
			}			
 			else if(%shouldBuy == 2)
				return 1;
		}
		else {
		    %delta = checkResources(%player,%item,$ItemMax[%armor, %item]);
			if(%delta || $testCheats) {
				teamEnergyBuySell(%player,(%item.price * -1 * %delta));
				Player::incItemCount(%client,%item,%delta);
				return 1;
			}
		}
		
 	}
	return 0;
}

function armorChange(%client)
{
	%player = Client::getOwnedObject(%client);
	if(%client.respawn == "" && %player.Station != "") {
		%sPos = GameBase::getPosition(%player.Station);
		%pPos	= GameBase::getPosition(%client);
		%posX = getWord(%sPos,0);
		%posY = getWord(%sPos,1);
		%posZ = getWord(%pPos,2);
		%vec = Vector::getFromRot(GameBase::getRotation(%player.Station),-1);	
	  	%newPosX = (getWord(%vec,0) * 1) + %posX;		 
		%newPosY = (getWord(%vec,1) * 1) + %posY;
		GameBase::setPosition(%client, %newPosX @ " " @ %newPosY @ " " @ %posZ);
	}
}

function remoteBuyItem(%client,%type)
{
	%item = getItemData(%type);
	if(buyItem(%client,%item)) {
 		Client::sendMessage(%client,0,"~wbuysellsound.wav");
		updateBuyingList(%client);
	}
	else 
  		Client::sendMessage(%client,0,"You couldn't buy "@ %item.description @"~wC_BuySell.wav");
}

function remoteSellItem(%client,%type)
{
	%item = getItemData(%type);
	%player = Client::getOwnedObject(%client);
	if ($ServerCheats || Client::isItemShoppingOn(%client,%item) || $TestCheats) {
		if(Player::getItemCount(%client,%item) && %item.className != Armor) {
			%numsell = 1;
			if(%item.className == Ammo || %item.className == HandAmmo) {
				%count = Player::getItemCount(%client, %item);
				if(%count < $SellAmmo[%item]) 
					%numsell = %count; 
				else 
					%numsell = $SellAmmo[%item];
			}
			else if (%item == ammopack) 
				checkMax(%client,Player::getArmor(%client));
			else if($TeamItemMax[%item] != "") {
				if(%item.className == Vehicle) 
					$TeamItemCount[(Client::getTeam(%client)) @ %item]--;
			}
			else if(%item == Accelerator) { 
				if(Player::getItemCount(%client,"PBW") > 0) {
					Client::sendMessage(%client,0,"Sold Particle Accelerator - Auto Selling PBW");
					remoteSellItem(%client, "PBW");						
				}
			}
			teamEnergyBuySell(%player,%item.price * %numsell);
			Player::setItemCount(%player,%item,(%count-%numsell));
			updateBuyingList(%client);
			Client::SendMessage(%client,0,"~wbuysellsound.wav");
			return 1;
		}
	}
	Client::sendMessage(%client,0,"Can't sell that~wC_BuySell.wav");
}

function remoteUseItem(%client,%type) 
{ 
	%client.throwStrength = 1; 
	%item = getItemData(%type); 
	if (%item == Backpack) { 
		%item = Player::getMountedItem(%client,$BackpackSlot); 
		if(%item == "-1") ixCheckPickup(%client); 
	} else { 
		if (%item == Weapon) 
			%item = Player::getMountedItem(%client,$WeaponSlot); 
	} 
	Player::useItem(%client,%item); 
} 

function ixCheckPickup(%player) { 
	%client = Player::getClient(%player); 
	if(!%player.isDeploying) { 
		if(GameBase::getLOSinfo(%player,8)) { 
			%this = $los::object; 
			%name = GameBase::getDataName(%this); 
			if((%name.className != Armor) && (%name.className != Vehicle) && (%name.className != Generator) && (%name.className != Station)) { 
				%thisTeam = GameBase::getTeam(%this); 
				%team = Client::getTeam(%client); 
				if(%team == %thisTeam) 
					GameBase::virtual(%this,"packUp",$los::position,%client,%player); 
			} 
		} 
	} 
} 

function ixGivePack(%player, %pack, %team) { 
	%obj = newObject("","Item",%pack,1,false); 
	schedule("Item::Pop(" @ %obj @ ");", $ItemPopTime, %obj); 
	addToSet("MissionCleanup", %obj); 
	GameBase::setPosition(%obj,%player.deployPosition); 
	$TeamItemCount[%team @ %pack]--; 
	playSound(SoundPickupItem,%player.deployPosition); 
	%player.isDeploying = false; 
} 

function ixToggleDeploy(%this) { 
	if(%this.isDeploying) 
		%this.isDeploying = false; 
	else 
		%this.isDeploying = true; 
} 

function remoteThrowItem(%client,%type,%strength)
{
	//echo("Throw item: " @ %type @ " " @ %strength);
	%item = getItemData(%type);
	if (%item == Grenade || %item == MineAmmo) {
		if (%strength < 0)
			%strength = 0;
		else
			if (%strength > 100)
				%strength = 100;
		%client.throwStrength = 0.3 + 0.7 * (%strength / 100);
		Player::useItem(%client,%item);
	}
}

function remoteDropItem(%client,%type)
{
	if((Client::getOwnedObject(%client)).driver != 1) {
		//echo("Drop item: ",%type);
		%client.throwStrength = 1;

		%item = getItemData(%type);
		if (%item == Backpack) {
			%item = Player::getMountedItem(%client,$BackpackSlot);
			Player::dropItem(%client,%item);
		}
	    else if (%item == Weapon) {
			%item = Player::getMountedItem(%client,$WeaponSlot);
			Player::dropItem(%client,%item);
		}
		else if (%item == Ammo) {
			%item = Player::getMountedItem(%client,$WeaponSlot);
			if(%item.className == Weapon) {
				%item = %item.imageType.ammoType;
				Player::dropItem(%client,%item);
			}
		}
		else 
			Player::dropItem(%client,%item);
	}
}

function remoteDeployItem(%client,%type)
{
    //echo("Deploy item: ",%type);
	%item = getItemData(%type);
	Player::deployItem(%client,%item);
}

//	$NextWeapon[EnergyRifle] = Blaster;
//	$NextWeapon[Blaster] = PlasmaGun;
//	$NextWeapon[PlasmaGun] = Chaingun;
//	$NextWeapon[Chaingun] = DiscLauncher;
//	$NextWeapon[DiscLauncher] = GrenadeLauncher;
//	$NextWeapon[GrenadeLauncher] = Mortar;
//	$NextWeapon[Mortar] = LaserRifle;
//	$NextWeapon[LaserRifle] = EnergyRifle;

//	$PrevWeapon[Blaster] = EnergyRifle;
//	$PrevWeapon[PlasmaGun] = Blaster;
//	$PrevWeapon[Chaingun] = PlasmaGun;
//	$PrevWeapon[DiscLauncher] = Chaingun;
//	$PrevWeapon[GrenadeLauncher] = DiscLauncher;
//	$PrevWeapon[Mortar] = GrenadeLauncher;
//	$PrevWeapon[LaserRifle] = Mortar;
//	$PrevWeapon[EnergyRifle] = LaserRifle;

function remoteNextWeapon(%client)
{
	%item = Player::getMountedItem(%client,$WeaponSlot);
	if (%item == -1 || $NextWeapon[%item] == "")
		selectValidWeapon(%client);
	else {
		for (%weapon = $NextWeapon[%item]; %weapon != %item;
				%weapon = $NextWeapon[%weapon]) {
			if (isSelectableWeapon(%client,%weapon)) {
				Player::useItem(%client,%weapon);
				// Make sure it mounted (laser may not), or at least
				// next in line to be mounted.
				if (Player::getMountedItem(%client,$WeaponSlot) == %weapon ||
						Player::getNextMountedItem(%client,$WeaponSlot) == %weapon)
					break;
			}
		}
	}
}

function remotePrevWeapon(%client)
{
	%item = Player::getMountedItem(%client,$WeaponSlot);
	if (%item == -1 || $PrevWeapon[%item] == "")
		selectValidWeapon(%client);
	else {
		for (%weapon = $PrevWeapon[%item]; %weapon != %item;
				%weapon = $PrevWeapon[%weapon]) {
			if (isSelectableWeapon(%client,%weapon)) {
				Player::useItem(%client,%weapon);
				// Make sure it mounted (laser may not), or at least
				// next in line to be mounted.
				if (Player::getMountedItem(%client,$WeaponSlot) == %weapon ||
						Player::getNextMountedItem(%client,$WeaponSlot) == %weapon)
					break;
			}
		}
	}
}

function selectValidWeapon(%client)
{
	%item = ElectricityRifle;
	for (%weapon = $NextWeapon[%item]; %weapon != %item;	%weapon = $NextWeapon[%weapon]) 
	{
		if (isSelectableWeapon(%client,%weapon)) 
		{
			Player::useItem(%client,%weapon);
			break;
		}
	}
}

function isSelectableWeapon(%client,%weapon)
{
	if (Player::getItemCount(%client,%weapon)) 
	{
		%ammo = $WeaponAmmo[%weapon];
		if (%ammo == "" || Player::getItemCount(%client,%ammo) > 0)
			return true;
	}
	return false;
}

//----------------------------------------------------------------------------
// Default item scripts
//----------------------------------------------------------------------------

function Item::giveItem(%player,%item,%delta)
{
	%armor = Player::getArmor(%player);
	if($ItemMax[%armor, %item]) {		  
		%client = Player::getClient(%player);
		if (%item.className == Backpack) {
			// Only one backpack per armor, and it's always mounted
			if (Player::getMountedItem(%player,$BackpackSlot) == -1) {
		 		Player::incItemCount(%player,%item);
		 		Player::useItem(%player,%item);
				Client::sendMessage(%client,0,"You got a " @ %item);
		 		return 1;
			}
		}
  		else {
			// Check num weapons carried by player can't have more than max
			if (%item.className == Weapon) {
//				if (Player::getItemClassCount(%player,"Weapon") >= $MaxWeapons[%armor] && !%client.isSuperAdmin) 
				if (Player::getItemClassCount(%player,"Weapon") >= $MaxWeapons[%armor]) 
					return 0;
			}  
			%extraAmmo = 0 ;
			if (Player::getMountedItem(%client,$BackpackSlot) == ammopack && $AmmoPackMax[%item] != "") 
				%extraAmmo = $AmmoPackMax[%item];
			// Make sure it doesn't exceed carrying capacity
			%count = Player::getItemCount(%player,%item);
			if (%count + %delta > $ItemMax[%armor, %item] + %extraAmmo) 
				%delta = ($ItemMax[%armor, %item] + %extraAmmo) - %count;
			if (%delta > 0) {
				Player::incItemCount(%player,%item,%delta);
				if (%count == 0 && $AutoUse[%item]) 
					Player::useItem(%player,%item);
				Client::sendMessage(%client,0,"You got " @ %delta @ " " @ %item.description);
				return %delta;
			}
		}
   }
	return 0;
}

//----------------------------------------------------------------------------
// Default Item object methods

$PickupSound[Ammo] = "SoundPickupAmmo";
$PickupSound[Weapon] = "SoundPickupWeapon";
$PickupSound[Backpack] = "SoundPickupBackpack";
$PickupSound[Repair] = "SoundPickupHealth";

function Item::playPickupSound(%this)
{
	%item = Item::getItemData(%this);
	%sound = $PickupSound[%item.className];
	if (%sound != "")  
		playSound(%sound,GameBase::getPosition(%this));
	else {
		// Generic item sound
		playSound(SoundPickupItem,GameBase::getPosition(%this));
	}
}	

function Item::respawn(%this)
{
	// If the item is rotating we respawn it,
	if (Item::isRotating(%this)) {
		Item::hide(%this,True);
		schedule("Item::hide(" @ %this @ ",false); GameBase::startFadeIn(" @ %this @ ");",$ItemRespawnTime,%this);
	}
	else { 
		deleteObject(%this);
	}
}	

function Item::onAdd(%this)
{
}

function Item::onCollision(%this,%object)
{
	if (getObjectType(%object) == "Player") {
		%item = Item::getItemData(%this);
		%count = Player::getItemCount(%object,%item);
		if (Item::giveItem(%object,%item,Item::getCount(%this))) {
			Item::playPickupSound(%this);
			Item::respawn(%this);
		}
	}
}


//----------------------------------------------------------------------------
// Default Inventory methods

function Item::onMount(%player,%item)
{
	bottomprint(Player::getClient(%player), "<jc><f2>" @ %item.description , $Displaytime);
}

function Item::onUnmount(%player,%item)
{
}

function Item::onUse(%player,%item)
{
	//echo("Item used: ",%player," ",%item);
	Player::mountItem(%player,%item,$DefaultSlot);
}

function Item::pop(%item)
{
 	GameBase::startFadeOut(%item);
   schedule("deleteObject(" @ %item @ ");",2.5, %item);
}

function Item::onDrop(%player,%item)
{
	if($matchStarted) {
		if(%item.className != Armor) {
			//echo("Item dropped: ",%player," ",%item);
			%obj = newObject("","Item",%item,1,false);
 	 	  	schedule("Item::Pop(" @ %obj @ ");", $ItemPopTime, %obj);
 	 	 	addToSet("MissionCleanup", %obj);
			if (Player::isDead(%player)) 
				GameBase::throw(%obj,%player,10,true);
			else {
				GameBase::throw(%obj,%player,15,false);
				Item::playPickupSound(%obj);
			}
			Player::decItemCount(%player,%item,1);
			return %obj;
		}
	}
}

function Item::popAmazing(%item)
{
 	GameBase::startFadeOut(%item);
   schedule("deleteObject(" @ %item @ ");",0, %item);
}

function Item::onDropAmazing(%player,%item)
{
	if($matchStarted) {
		if(%item.className != Armor) {
			//echo("Item dropped: ",%player," ",%item);
			%obj = newObject("","Item",%item,1,false);
 	 	  	schedule("Item::PopAmazing(" @ %obj @ ");", 0, %obj);
 	 	 	addToSet("MissionCleanup", %obj);
			if (Player::isDead(%player)) 
				GameBase::throw(%obj,%player,10,true);
			else {
				GameBase::throw(%obj,%player,15,false);
				Item::playPickupSound(%obj);
			}
			Player::decItemCount(%player,%item,1);
			return %obj;
		}
	}
}

function Item::onDeploy(%player,%item,%pos)
{
	bottomprint(Player::getClient(%player), "<jc><f2>" @ %item.description @ " Deployed.", $Displaytime);
}


//----------------------------------------------------------------------------
// Flag

//----------------------------------------------------------------------------

function Flag::onUse(%player,%item)
{
	Player::mountItem(%player,%item,$FlagSlot);
}


//----------------------------------------------------------------------------

ItemImageData FlagImage
{
	shapeFile = "flag";
	mountPoint = 2;
	mountOffset = { 0, 0, -0.35 };
	mountRotation = { 0, 0, 0 };
	mass = -1.5;  //WC
	lightType = 2;   // Pulsing
	lightRadius = 4;
	lightTime = 1.5;
	lightColor = { 1, 1, 1};
};

ItemData Flag
{
	description = "Flag";
	shapeFile = "flag";
	imageType = FlagImage;
	showInventory = false;
	shadowDetailMask = 4;
	validateShape = true;

	lightType = 2;   // Pulsing
	lightRadius = 4;
	lightTime = 1.5;
	lightColor = { 1, 1, 1 };
};

ItemData RaceFlag
{
	description = "Race Flag";
	shapeFile = "flag";
	imageType = FlagImage;
	showInventory = false;
	shadowDetailMask = 4;

	lightType = 2;   // Pulsing
	lightRadius = 4;
	lightTime = 1.5;
	lightColor = { 1, 1, 1 };
};

//----------------------------------------------------------------------------
// Armors
//----------------------------------------------------------------------------

ItemData LightArmor
{
   heading = "aArmor";
	description = "Quicksilver";
	className = "Armor";
	price = 175;
	shapeFile = "larmor";
};

ItemData BlastechArmor
{
   heading = "aArmor";
	description = "Ghost";
	className = "Armor";
	price = 200;
	shapeFile = "larmor";
};

ItemData MediumArmor
{
   heading = "aArmor";
	description = "Mechanic";
	className = "Armor";
	price = 250;
	shapeFile = "marmor";
};

ItemData MagIonArmor
{
   heading = "aArmor";
	description = "ZzaxX";
	className = "Armor";
	price = 300;
	shapeFile = "marmor";
};

ItemData MECHArmor
{
   heading = "aArmor";
	description = "Destroyer";
	className = "Armor";
	price = 400;
	shapeFile = "harmor";
};

ItemData HeavyArmor
{
   heading = "aArmor";
	description = "Terrax";
	className = "Armor";
	price = 500;
	shapeFile = "harmor";
};

//----------------------------------------------------------------------------
// Vehicles
//----------------------------------------------------------------------------

ItemData JetFireVehicle
{
	description = "JetFire";
	className = "Vehicle";
   heading = "zUseless Crap";
	price = 0;
	shapeFile = "flyer";
};

ItemData RetaliatorVehicle
{
	description = "JetFire";
	className = "Vehicle";
   heading = "zUseless Crap";
	price = 0;
	shapeFile = "flyer";
};

ItemData ArwingV
{
	description = "Arwing";
	className = "Vehicle";
   heading = "aFighters";
	price = 100;
	shapeFile = "flyer";
};

ItemData EPodV
{
	description = "Lightning";
	className = "Vehicle";
   heading = "aFighters";
	price = 175;
	shapeFile = "flyer";
};

ItemData CutterV
{
	description = "Sky Cutter";
	className = "Vehicle";
   heading = "aFighters";
	price = 250;
	shapeFile = "flyer";
};

ItemData ExplorerV
{
	description = "3DFX Explorer";
	className = "Vehicle";
   heading = "aFighters";
	price = 375;
	shapeFile = "flyer";
};

ItemData RangerV
{
	description = "Sky Ranger";
	className = "Vehicle";
   heading = "aFighters";
	price = 475;
	shapeFile = "flyer";
};

ItemData ScoutVehicle
{
	description = "Scout";
	className = "Vehicle";
   heading = "aFighters";
	price = 600;
	shapeFile = "flyer";
};

ItemData HammerV
{
	description = "Star Hammer";
	className = "Vehicle";
   heading = "aFighters";
	price = 625;
	shapeFile = "flyer";
};

ItemData FighterV
{
	description = "Star Fighter";
	className = "Vehicle";
   heading = "aFighters";
	price = 650;
	shapeFile = "flyer";
};

ItemData AvengerV
{
	description = "ThunderTank";
	className = "Vehicle";
   heading = "bCarriers";
	price = 675;
	shapeFile = "hover_apc_sml";
};

ItemData LAPCVehicle
{
	description = "LPC -- LandSkimmer";
	className = "Vehicle";
   heading = "bCarriers";
	price = 700;
	shapeFile = "hover_apc_sml";
};

ItemData ValkyrieV
{
	description = "Valkyrie Interceptor";
	className = "Vehicle";
   heading = "bCarriers";
	price = 750;
	shapeFile = "hover_apc_sml";
};

ItemData HAPCVehicle
{
	description = "HPC";
	className = "Vehicle";
   heading = "cPersonnel Dropships";
	price = 800;
	shapeFile = "hover_apc";
};

ItemData TankV
{
	description = "Hover Tank";
	className = "Vehicle";
   heading = "cPersonnel Dropships";
	price = 875;
	shapeFile = "hover_apc";
};

ItemData IcarusV
{
	description = "Annihilator";
	className = "Vehicle";
   heading = "cPersonnel Dropships";
	price = 1024;
	shapeFile = "hover_apc";
};

	$TeamItemMax[ArwingV] = 5;
	$TeamItemMax[CutterV] = 5;
	$TeamItemMax[HammerV] = 5;
	$TeamItemMax[ExplorerV] = 5;
	$TeamItemMax[RangerV] = 5;
	$TeamItemMax[IcarusV] = 1;
	$TeamItemMax[AvengerV] = 5;
	$TeamItemMax[FighterV] = 5;
	$TeamItemMax[TankV] = 2;
	$TeamItemMax[ValkyrieV] = 3;
	$TeamItemMax[EpodV] = 4;

//----------------------------------------------------------------------------
// Tools, Weapons & ammo
//----------------------------------------------------------------------------

function ixDotProd(%vec, %scalar) 
{ %return = Vector::dot(%vec,%scalar @ " 0 0") @ " " @ Vector::dot(%vec,"0 " @ %scalar @ " 0") @ " " @ Vector::dot(%vec,"0 0 " @ %scalar); return %return; } 

function ixSin(%theta) 
{ return (%theta - (pow(%theta,3)/6) + (pow(%theta,5)/120) - (pow(%theta,7)/5040) + (pow(%theta,9)/362880) - (pow(%theta,11)/39916800)); }  

function ixCos(%theta) 
{ return (1 - (pow(%theta,2)/2) + (pow(%theta,4)/24) - (pow(%theta,6)/720) + (pow(%theta,8)/40320) - (pow(%theta,10)/3628800)); } 

function ixApplyKickback(%player, %strength, %lift) 
{ if((!%lift) && (%lift != 0)) %lift = 0; %rot = GameBase::getRotation(%player); %rad = getWord(%rot, 2); %x = (-1) * (ixSin(%rad)); %y = ixCos(%rad); %dir = %x @ " " @ %y @ " 0"; %force = ixDotProd(Vector::neg(%dir),%strength); %x = getWord(%force, 0); %y = getWord(%force, 1); %dir = %x @ " " @ %y @ " " @ %lift; Player::applyImpulse(%player,%force); } 

function Sin(%theta)
{ return (%theta - (pow(%theta,3)/6) + (pow(%theta,5)/120) - (pow(%theta,7)/5040) + (pow(%theta,9)/362880) - (pow(%theta,11)/39916800));}
 
function Cos(%theta) 
{ return (1 - (pow(%theta,2)/2) + (pow(%theta,4)/24) - (pow(%theta,6)/720) + (pow(%theta,8)/40320) - (pow(%theta,10)/3628800));}

function NewVector(%vec, %scalar)
{	%return = Vector::dot(%vec,%scalar @ " 0 0") @ " " @ Vector::dot(%vec,"0 " @ %scalar @ " 0") @ " " @ Vector::dot(%vec,"0 0 " @ %scalar);
	return %return;
}

function GiveKickback(%player, %strength, %lift)
{	
	if((!%lift) && (%lift != 0)) %lift = 0;
	%rot = GameBase::getRotation(%player);
	%rad = getWord(%rot, 2);
	%x = (-1) * (Sin(%rad));
	%y = Cos(%rad);
	%dir = %x @ " " @ %y @ " 0";
	%force=NewVector(Vector::neg(%dir),%strength);
	%x = getWord(%force, 0);
	%y = getWord(%force, 1);
	%force = %x @ " " @ %y @ " " @ %lift;
	Player::applyImpulse(%player,%force);
}

ItemData Weapon
{
	description = "Weapon";
	showInventory = false;
};

function Weapon::onDrop(%player,%item)
{
	%state = Player::getItemState(%player,$WeaponSlot);
	if (%state != "Fire" && %state != "Reload")
		Item::onDrop(%player,%item);
}	

function Weapon::onUse(%player,%item)
{
	if(%player.Station==""){
		%ammo = %item.imageType.ammoType;
		if (%ammo == "") {
			// Energy weapons dont have ammo types
			Player::mountItem(%player,%item,$WeaponSlot);
		}
		else {
			if (Player::getItemCount(%player,%ammo) > 0) 
				Player::mountItem(%player,%item,$WeaponSlot);
			else {
				Client::sendMessage(Player::getClient(%player),0,
				strcat(%item.description," has no ammo"));
			}
		}
	}
}

ItemImageData DestroyerGrenFwdImage
{
	shapeFile = "camera";
//	shapeFile = "plasma";
//	shapeFile = "mortargun";
	mountPoint = 3;
	mountOffset = { 0.08, 0.13, 1.475 };
	mountRotation = { 0, 0, -1.57 };
//	mountOffset = { 0, 0, 2.675 };
//	mountOffset = { -0.27, 0.1, 2.175 };
//	mountOffset = { 0.08, -0.3, 1.775 };
//	mountRotation = { 0, -1.57, 0 };
	weaponType = 0;
	projectileType = FastPimpinMissile;
	accuFire = true;
	reloadTime = 1.5;
	fireTime = 0.5;
	lightType = 3;
	lightRadius = 5;
	lightTime = 2;
	lightColor = { 1, 1, 1.0 };
	sfxFire = explosion3;
	sfxReload = SoundFlyerDismount;
};

ItemData DestroyerGrenFwd
{
	description = "Devastator Cannon";
	shapeFile = "mortargun";
	heading = "dBackpacks";
	shadowDetailMask = 4;
	imageType = DestroyerGrenFwdImage;
	price = 350;
	hudIcon = "mortar";
	showWeaponBar = false;
	hiliteOnActive = true;
	showInventory = false;
};

ItemData Backpack
{				
	description = "Backpack";
	showInventory = false;
};

function Backpack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::trigger(%player,$BackpackSlot);
	}
}

//----------------------------------------------------------------------------

ItemData Tool
{
	description = "Tool";
	showInventory = false;
};

function Tool::onUse(%player,%item)
{
	Player::mountItem(%player,%item,$ToolSlot);
}



//----------------------------------------------------------------------------

ItemData Ammo
{
	description = "Ammo";
	showInventory = false;
};

function Ammo::onDrop(%player,%item)
{
	if($matchStarted) {
		%count = Player::getItemCount(%player,%item);
		%delta = $SellAmmo[%item];
		if(%count <= %delta) { 
			if( %item == BulletAmmo || (Player::getMountedItem(%player,$WeaponSlot)).imageType.ammoType != %item)
				%delta = %count;
			else 
				%delta = %count - 1;

		}
		if(%delta > 0) {
			%obj = newObject("","Item",%item,%delta,false);
      	schedule("Item::Pop(" @ %obj @ ");", $ItemPopTime, %obj);

      	addToSet("MissionCleanup", %obj);
			GameBase::throw(%obj,%player,20,false);
			Item::playPickupSound(%obj);
			Player::decItemCount(%player,%item,%delta);
		}
	}
}	

//----------------------------------------------------------------------------

ItemData RepairPatch
{
	description = "Repair Patch";
	className = "Repair";
	shapeFile = "armorPatch";
   heading = "gMiscellany";
	shadowDetailMask = 4;
  	price = 2;
   validateShape = true;
   validateMaterials = true;
};

function RepairPatch::onCollision(%this,%object)
{
	if (getObjectType(%object) == "Player") {
		%clientId = Player::getClient(%object);
			if($empTime[%clientId] > 0) $empTime[%clientId] = 0;
			if($poisonTime[%clientId] > 0)  $poisonTime[%clientId] = 0;
			if($burnTime[%clientId] > 0)  $burnTime[%clientId] = 0;
			if($HFburnTime[%clientId] > 0)  $HFburnTime[%clientId] = 0;
			if($AcidBthTime[%clientId] > 0)  $AcidBthTime[%clientId] = 0;
			if($HvyGravTime[%clientId] > 0)  $HvyGravTime[%clientId] = 0;
			if($TornadoSpinTime[%clientId] > 0)  $TornadoSpinTime[%clientId] = 0;
			if($SmokedTime[%clientId] > 0)  $SmokedTime[%clientId] = 0;
			%item = Item::getItemData(%this);
			Item::playPickupSound(%this);
			Item::respawn(%this);
		if(GameBase::getDamageLevel(%object)) 
		{
			GameBase::repairDamage(%object,1.25);
//			GameBase::repairDamage(%object,0.125);
			%item = Item::getItemData(%this);
			Item::playPickupSound(%this);
			Item::respawn(%this);
		}
	}
}

function RepairPatch::onUse(%player,%item)
{
	Player::decItemCount(%player,%item);
	GameBase::repairDamage(%player,1.25);
//	GameBase::repairDamage(%player,0.1);
	%clientId = Player::getClient(%item);
		if($empTime[%clientId] > 0) $empTime[%clientId] = 0;
		if($poisonTime[%clientId] > 0)  $poisonTime[%clientId] = 0;
		if($burnTime[%clientId] > 0)  $burnTime[%clientId] = 0;
		if($HFburnTime[%clientId] > 0)  $HFburnTime[%clientId] = 0;
		if($AcidBthTime[%clientId] > 0)  $AcidBthTime[%clientId] = 0;
		if($HvyGravTime[%clientId] > 0)  $HvyGravTime[%clientId] = 0;
		if($TornadoSpinTime[%clientId] > 0)  $TornadoSpinTime[%clientId] = 0;
		if($StunnedTime[%clientId] > 0) $StunnedTime[%clientId] = 0;
		if($SmokedTime[%clientId] > 0)  $SmokedTime[%clientId] = 0;
}

//----------------------------------------------------------------------------

$AutoUse[RepairKit] = false;

ItemData RepairKit
{
   description = "Repair Kit";
   shapeFile = "armorKit";
   heading = "oMiscellany";
   shadowDetailMask = 4;
   price = 35;
   validateShape = true;
   validateMaterials = true;
};

function RepairKit::onUse(%player,%item) 
{
	%c = Player::getClient(%player);
	if(!%player.inStation || %player != Station::getTarget(%player.inStation)) {
		if(GameBase::getLOSInfo(%player,4) && GameBase::getTeam($los::object) == Client::getTeam(%c)) { 
			%o = $los::object;
			%object = getObjectType(%o); 
			if (%object == "StaticShape" || %object == "Turret" || %object == "Player") { 
				if(%object == "Player") {
					%oc = Player::getClient(%o);
					if(%oc.poisonTime > 0)
						$poisonTime[%clientId] -= 10; 
//					if(%oc.poisonTime > 0)
//						%c.poisonTime = -10; 
					if(%oc.burnTime > 0)
						$burnTime[%clientId] -= 100; 
					if(%oc.empTime > 2) $empTime[%clientId] -= 5;
					GameBase::repairDamage(%o,0.23); 
					Client::sendMessage(%c,0,"Repair Kit used on " @ Client::getName(%oc));
					Client::sendMessage(%oc,0,"Being repaired by " @ Client::getName(%c));
					Player::decItemCount(%player,%item);
				} else {
					%trans = GameBase::getMuzzleTransform(%player); 
					%vel = Item::getVelocity(%player); 
					Projectile::spawnProjectile("RepairItemBolt",%trans,%player,%vel,$los::object);
				}
				return;
			}
		} 
	}
	GameBase::repairDamage(%player,0.20);
	%clientId = Player::getClient(%player);
	if($empTime[%clientId] > 0) $empTime[%clientId] -= 5;
	if($poisonTime[%clientId] > 0)  $poisonTime[%clientId] -= 7;
	if($burnTime[%clientId] > 0)  $burnTime[%clientId] -= 100;
	if($HFburnTime[%clientId] > 0)  $HFburnTime[%clientId] -= 10;
	if($AcidBthTime[%clientId] > 0)  $AcidBthTime[%clientId] -= 50;
	if($HvyGravTime[%clientId] > 0)  $HvyGravTime[%clientId] -= 7;
	if($TornadoSpinTime[%clientId] > 0)  $TornadoSpinTime[%clientId] -= 350;
	if($StunnedTime[%clientId] > 0) $StunnedTime[%clientId] -= 40;
	if($SmokedTime[%clientId] > 0)  $SmokedTime[%clientId] -= 60;
	if(!%player.inStation || %player != Station::getTarget(%player.inStation))
		Player::decItemCount(%player,%item);
}

//----------------------------------------------------------------------------

ItemData Beacon
{
   description = "Beacon";
   shapeFile = "sensor_small";
   heading = "oMiscellany";
   shadowDetailMask = 4;
   price = 5;
	className = "HandAmmo";
};

function Beacon::onUse(%player,%item)
{
	%armor = Player::getArmor(%player);
	%clientId = Player::getClient(%player);
	%client = Player::getClient(%player);
	%playerId = Player::getClient(%player);

	if(%playerId.beacon == 0)
	{	//deploy a beacon
		if (Beacon::deployShape(%player,%item)) 
		{
			Player::decItemCount(%player,%item);
		}
	}
	else if(%playerId.beacon == 1)
	{	//shield
			$energyTime[%clientId] = 0;  
			$healthTime[%clientId] = 0;  
//			$ammoTime[%clientId] = 0;
			$ammoTime[%player] = 0;
			$antidoteTime[%clientId] = 0;  
		Gundam::Shield(%clientId, %player);
		Player::decItemCount(%player,%item);
	}
	else if(%playerId.beacon == 2)
	{	//energy recharge
			$shieldTime[%clientId] = 0;  
			$healthTime[%clientId] = 0;  
//			$ammoTime[%clientId] = 0;
			$ammoTime[%player] = 0;
			$antidoteTime[%clientId] = 0;  
		Gundam::Energy(%clientId, %player);
		Player::decItemCount(%player,%item);
	}
	else if(%playerId.beacon == 3)
	{	//autorepair
			$shieldTime[%clientId] = 0;  
			$energyTime[%clientId] = 0;  
//			$ammoTime[%clientId] = 0;
			$ammoTime[%player] = 0;
			$antidoteTime[%clientId] = 0;  
		Gundam::Health(%clientId, %player);
		Player::decItemCount(%player,%item);
	}
	else if(%playerId.beacon == 4)
	{	//universal antidote
			$shieldTime[%clientId] = 0;  
			$energyTime[%clientId] = 0;  
			$healthTime[%clientId] = 0;  
//			$ammoTime[%clientId] = 0;
			$ammoTime[%player] = 0;
		Gundam::Antidote(%clientId, %player);
		Player::decItemCount(%player,%item);
	}
	else if(%playerId.beacon == 5)
	{	//jet boost
			$cloakTime[%clientId] = 0;  
			$shieldTime[%clientId] = 0;  
			$energyTime[%clientId] = 0;  
			$healthTime[%clientId] = 0;  
//			$ammoTime[%clientId] = 0;
			$ammoTime[%player] = 0;
			$antidoteTime[%clientId] = 0;  
		Gundam::JetBoost(%clientId, %player);
		Player::decItemCount(%player,%item);
	}
	else if(%playerId.beacon == 6)
	{	//ammo gen
			$cloakTime[%clientId] = 0;  
			$shieldTime[%clientId] = 0;  
			$energyTime[%clientId] = 0;  
			$healthTime[%clientId] = 0;  
//			$ammoTime[%clientId] = 0;
			$ammoTime[%player] = 0;
			$antidoteTime[%clientId] = 0;  
		Gundam::Ammo(%clientId, %player);
		Player::decItemCount(%player,%item);
	}
	else if(%playerId.beacon == 7)
	{	//deploy a beacon
	}
}

function Beacon::deployShape(%player,%item)
{
 	%client = Player::getClient(%player);
	if (GameBase::getLOSInfo(%player,20)) {
		// GetLOSInfo sets the following globals:
		// 	los::position
		// 	los::normal
		// 	los::object
		%obj = getObjectType($los::object);
		if (%obj == "SimTerrain" || %obj == "InteriorShape") {
			// Try to stick it straight up or down, otherwise
			// just use the surface normal
			if (Vector::dot($los::normal,"0 0 1") > 0.6) {
				%rot = "0 0 0";
			}
			else {
				if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
					%rot = "3.14159 0 0";
				}
				else {
					%rot = Vector::getRotation($los::normal);
				}
			}
		  	%set=newObject("set",SimSet);
			%num=containerBoxFillSet(%set,$StaticObjectType | $ItemObjectType | $SimPlayerObjectType,$los::position,0.3,0.3,0.3,1);
			deleteObject(%set);
			if(!%num) {
				%team = GameBase::getTeam(%player);
				if($TeamItemMax[%item] > $TeamItemCount[%team @ %item] || $TestCheats) {
					%beacon = newObject("Target Beacon", "StaticShape", "DefaultBeacon", true);
				   addToSet("MissionCleanup", %beacon);
					//, CameraTurret, true);
					GameBase::setTeam(%beacon,GameBase::getTeam(%player));
					GameBase::setRotation(%beacon,%rot);
					GameBase::setPosition(%beacon,$los::position);

					Gamebase::setMapName(%beacon,"Target Beacon");
   			   Beacon::onEnabled(%beacon);
					Client::sendMessage(%client,0,"Beacon deployed");
					//playSound(SoundPickupBackpack,$los::position);
					$TeamItemCount[GameBase::getTeam(%beacon) @ "Beacon"]++;
					return true;
				}
				else
					Client::sendMessage(%client,0,"Deployable Item limit reached");
			}
			else
				Client::sendMessage(%client,0,"Unable to deploy - Item in the way");
		}
		else {
			Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
	}
	else {
		Client::sendMessage(%client,0,"Deploy position out of range");
	}
	return false;
}

function BeaconWC::deployShape(%player,%item)
{
 	%client = Player::getClient(%player);
	if (GameBase::getLOSInfo(%player,800)) 
	{

		// Try to stick it straight up or down, otherwise
		// just use the surface normal
		if (Vector::dot($los::normal,"0 0 1") > 0.6) 
		{
			%rot = "0 0 0";
		}
		else 
		{
			if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
			{
				%rot = "3.14159 0 0";
			}
			else 
			{
				%rot = Vector::getRotation($los::normal);
			}
		}

			%team = GameBase::getTeam(%player);
			if($TeamItemMax[beacon] > $TeamItemCount[%team @ beacon] || $TestCheats) 
			{
				%beacon = newObject("Target Beacon", "StaticShape", "DefaultBeacon", true);
				addToSet("MissionCleanup", %beacon);
				//, CameraTurret, true);
				GameBase::setTeam(%beacon,GameBase::getTeam(%player));
				GameBase::setRotation(%beacon,%rot);
				GameBase::setPosition(%beacon,$los::position);
				Gamebase::setMapName(%beacon,"Target Beacon");
				Beacon::onEnabled(%beacon);
				Client::sendMessage(%client,0,"Beacon deployed");
				//playSound(SoundPickupBackpack,$los::position);
				$TeamItemCount[GameBase::getTeam(%beacon) @ "Beacon"]++;
				Player::decItemCount(%player,beacon);
				return true;
			}
			else
			{
				Client::sendMessage(%client,0,"Deployable Item limit reached");
			}
	}
	else 
	{
		Client::sendMessage(%client,0,"Deploy position out of range");
	}
	return false;
}


//----------------------------------------------------------------------------
//--these are used in menu selection for configurable grenades, mines, and beacons---

ItemImageData GrenadeSelectorImage
{
	shapeFile = "Grenade";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mountOffset = { 0, 0, -0.56 };
	firstPerson = false;
};

ItemData GrenadeSelector
{
	description = "Grenade Selection";
	shapeFile = "Grenade";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = GrenadeSelectorImage;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

ItemImageData MineSelectorImage
{
	shapeFile = "Mine";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mountOffset = { 0, 0, -0.56 };
	firstPerson = false;
};

ItemData MineSelector
{
	description = "Mine Selection";
	shapeFile = "Mine";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = MineSelectorImage;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

ItemImageData BeaconSelectorImage
{
//	shapeFile = "force";
	shapeFile = "sensor_small";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mountOffset = { 0, 0, -0.56 };
	firstPerson = false;
};

ItemData BeaconSelector
{
	description = "Beacon Selection";
//	shapeFile = "force";
	shapeFile = "sensor_small";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = BeaconSelectorImage;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

//----------------------------------------------------------------------------

ItemImageData HvyGravDeviceImage
{
	shapeFile = "endarrow";
//	shapeFile = "flash_medium";
	weaponType = 2;  // Sustained
	mountPoint = 2;
	mountOffset = { 0, 0, 4.56 };
	mountRotation = { -1.57, 0, 0 };
	mass = 30;
	firstPerson = false;
};

ItemData HvyGravDevice
{
	description = "Heavy Gravity Field Active";
	shapeFile = "flash_medium";
	className = "Backpack";
	heading = "kBackpacks";
	shadowDetailMask = 4;
	imageType = HvyGravDeviceImage;
	price = 2500;
	hudIcon = "fear";
	showWeaponBar = true;
	hiliteOnActive = true;
};

//----------------------------------------------------------------------------

ItemData Grenade
{
   description = "Grenade";
   shapeFile = "grenade";
   heading = "oMiscellany";
   shadowDetailMask = 4;
   price = 5;
	className = "HandAmmo";
};

function Grenade::onUse(%player,%item)
{
	%playerId = Player::getClient(%player);
	if($matchStarted && !%playerId.isPrisoner)
//	if($matchStarted)
	{
		if(%player.throwTime < getSimTime() )
		{
			Player::decItemCount(%player,%item);
			%client = Player::getClient(%player);
			%armor = Player::getArmor(%player);
			%rnd = floor(getRandom() * 10);

			if (%armor == "MECH")
			{
				%state = Player::getItemState(%player,3);
				if (%state != "Fire" && %state != "Reload")
				{
					Player::trigger(%player,3,true);
					Player::trigger(%player,3,false);
					GiveKickback(%player, 320, 65);
//					Player::decItemCount(%player,%item);
				}
				else
				{
					Client::sendMessage(%client,0, "Unable to fire - Missile is reloading");
					Player::incItemCount(%player,%item);
				}
				return;
			}

			if(%playerId.grenade == 0)
			{
				if(%rnd > 7)
				{
					%obj = newObject("","Mine","HavocblastH");
					Bottomprint(%client, "<jc><f0>Annihilator<f1> grenade tossed.", 2);
				}
				else
				{
					%obj = newObject("","Mine","StandardGrenade");
					Bottomprint(%client, "<jc><f2>Standard<f1> grenade tossed.", 2);
				}
			}
			else if(%playerId.grenade == 1)
			{
				%obj = newObject("","Mine","ConcussiveGrenade");
				Bottomprint(%client, "<jc><f2>Concussive<f1> grenade tossed.", 2);
			}
			else if(%playerId.grenade == 2)
			{
				%obj = newObject("","Mine","FireGrenade");
				Bottomprint(%client, "<jc><f2>Fire<f1> grenade tossed.", 2);
			}
			else if(%playerId.grenade == 3)
			{
				%obj = newObject("","Mine","PoisonGrenade");
				Bottomprint(%client, "<jc><f2>Poison<f1> grenade tossed.", 2);
			}
			else if(%playerId.grenade == 4)
			{
				%obj = newObject("","Mine","EMPGrenade");
				Bottomprint(%client, "<jc><f2>EMP<f1> grenade tossed.", 2);
			}
			else if(%playerId.grenade == 5)
			{
				%obj = newObject("","Mine","StunGrenade");
				Bottomprint(%client, "<jc><f2>Stun<f1> grenade tossed.", 2);
			}
			else if(%playerId.grenade == 6)
			{
				%obj = newObject("","Mine","BlackHoleGrenade");
				Bottomprint(%client, "<jc><f2>Black Hole<f1> grenade tossed.", 2);
			}
			else if(%playerId.grenade == 7)
			{
				%obj = newObject("","Mine","AcidGrenade");
				Bottomprint(%client, "<jc><f2>Acid<f1> grenade tossed.", 2);
			}
 	 	 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,15 * %client.throwStrength,false);
			%player.throwTime = getSimTime() + 0.5;
			GameBase::setTeam(%obj,GameBase::getTeam(%client));
		}
	}
}

//----------------------------------------------------------------------------

ItemData MineAmmo
{
   description = "Mine";
   shapeFile = "mineammo";
   heading = "oMiscellany";
   shadowDetailMask = 4;
   price = 10;
	className = "HandAmmo";
};

$InvList[MineAmmo] = 1;
$RemoteInvList[MineAmmo] = 1;

function MineAmmo::onUse(%player,%item)
{
	%playerId = Player::getClient(%player);
	if($matchStarted && !%playerId.isPrisoner)
//	if($matchStarted)
	{
		%armor = Player::getArmor(%player);
		%client = Player::getClient(%player);
		if(%player.throwTime < getSimTime() ) 
		{
			Player::decItemCount(%player,%item);
			%rnd = floor(getRandom() * 20);
			if(%playerId.mine == 0)
			{
				if(Player::getMountedItem(%player,$BackpackSlot) != MitziCharger)
				{
					if(%rnd > 18)
					{
						%obj = newObject("","Mine","NuclearMine");
						Bottomprint(%client, "<jc><f0>NUCLEAR<f1> mine deployed.  Get the HELL away...NOW!!!", 3);
					}
					else
					{
						%obj = newObject("","Mine","antipersonelMine");
						Bottomprint(%client, "<jc><f2>Standard<f1> mine deployed.", 2);
					}
				}
				else
				{
					%satch = "SatchelChrgPack";
					if($TeamItemCount[GameBase::getTeam(%player) @ %satch] < $TeamItemMax[%satch]) 
					{
						%client = Player::getClient(%player);
						SatchelChrgPack::deployShape(%player,%item);
						Bottomprint(%client, "<jc><f1>You just laid a <f0>Satchel Charge", 2);
					}
					else
					{
//						%obj = newObject("","Mine","antipersonelMine");
//						Bottomprint(%client, "<jc><f2>Standard<f1> mine deployed.", 2);
						%obj = newObject("","Mine","NuclearMine");
						Bottomprint(%client, "<jc><f0>NUCLEAR<f1> mine deployed.  Get the HELL away...NOW!!!", 3);
					}
				}
			}
			else if(%playerId.mine == 1)
			{
				%obj = newObject("","Mine","ConcussiveMine");
				Bottomprint(%client, "<jc><f2>Concussive<f1> mine deployed.", 2);
			}
			else if(%playerId.mine == 2)
			{
				%obj = newObject("","Mine","FireMine");
				Bottomprint(%client, "<jc><f2>Fire<f1> mine deployed.", 2);
			}
			else if(%playerId.mine == 3)
			{
				%obj = newObject("","Mine","PoisonMine");
				Bottomprint(%client, "<jc><f2>Poison<f1> mine deployed.", 2);
			}
			else if(%playerId.mine == 4)
			{
				%obj = newObject("","Mine","EMPMine");
				Bottomprint(%client, "<jc><f2>EMP<f1> mine deployed.", 2);
			}
			else if(%playerId.mine == 5)
			{
				%obj = newObject("","Mine","TornadoMine");
				Bottomprint(%client, "<jc><f2>Tornado<f1> mine deployed.", 2);
			}
			else if(%playerId.mine == 6)
			{
				%obj = newObject("","Mine","HvyGravMine");
				Bottomprint(%client, "<jc><f2>Heavy Gravity<f1> mine deployed.", 2);
			}
			else if(%playerId.mine == 7)
			{
				%obj = newObject("","Mine","AcidMine");
				Bottomprint(%client, "<jc><f2>Acid<f1> mine deployed.", 2);
			}

			GameBase::setTeam(%obj,GameBase::getTeam(%player));
		 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,15 * %client.throwStrength,false);
			%player.throwTime = getSimTime() + 0.5;
		}
	}
}

function CountObjects(%set,%name,%num) 
{
	%count = 0;
	for(%i=0;%i<%num;%i++) {
		%obj=Group::getObject(%set,%i);
		if(GameBase::getDataName(Group::getObject(%set,%i)) == %name) 
			%count++;
	}
	return %count;
}

function checkDeployArea(%client,%pos)
{
  	%set=newObject("set",SimSet);
	%num=containerBoxFillSet(%set,$StaticObjectType | $ItemObjectType | $SimPlayerObjectType,%pos,1,1,1,1);
	%team = Client::getTeam(%client);
	for(%i=0;%i<%num;%i++) {
		%obj=Group::getObject(%set,%i);
		if(GameBase::getDataName(Group::getObject(%set,%i)) == "BlastFloorShape") 
			if(GameBase::getTeam(Group::getObject(%set,%i)) == %team)
				%num--;
	}
	if(!%num) {
		deleteObject(%set);
		return 1;
	}
	else if(%num == 1 && getObjectType(Group::getObject(%set,0)) == "Player") { 
		%obj = Group::getObject(%set,0);	
		if(Player::getClient(%obj) == %client)	
			Client::sendMessage(%client,0,"Unable to deploy - You're in the way");
		else
			Client::sendMessage(%client,0,"Unable to deploy - Player in the way");
	}
	else
		Client::sendMessage(%client,0,"Unable to deploy - Item in the way");

	deleteObject(%set);
	return 0;	
		

}

//----------------------------------------------------------------------------
// Remote deploy for items

function Item::deployShape(%player,%name,%shape,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,8)) {
			// GetLOSInfo sets the following globals:
			// 	los::position
			// 	los::normal
			// 	los::object
//			%obj = getObjectType($los::object);
//			if (%obj == "SimTerrain" || %obj == "InteriorShape" || GameBase::getDataName($los::object) == "BlastFloorShape") {
//				if (Vector::dot($los::normal,"0 0 1") > 0.7) {
//					if(checkDeployArea(%client,$los::position)) {

                  %obj = getObjectType($los::object);
                  %rot = GameBase::getRotation(%player);
			%zRot = getWord(%rot, 2);
			if (Vector::dot($los::normal, "0 0 1") > 0.6)
			{
				%rot = "0 0 " @ %zRot;
			}
			else
			{
				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
				{
					%rot = "3.14159 0 " @ %zRot;
				} 
				else
				{
					%rot = Vector::getRotation($los::normal);
				}
			 }


						%sensor = newObject("","Sensor",%shape,true);
		 	        	   	addToSet("MissionCleanup", %sensor);
						GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                                    GameBase::setRotation(%sensor,%rot);
						GameBase::setPosition(%sensor,$los::position);
						Gamebase::setMapName(%sensor,%name);
						Client::sendMessage(%client,0,%item.description @ " deployed");
						playSound(SoundPickupBackpack,$los::position);
						echo("MSG: ",%client," deployed a ",%name);
						return true;
//					}
//				}
//				else 
//					Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
//			}
//			else 
//				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %name @ "s");
	return false;
}

//----------------------------------------------------------------------------

function remoteGiveAll(%clientId)
{
	if ($TestCheats) {}
	else if($ServerCheats) {}
}


//----------------------------------------------------------------------------


function checkMax(%client,%armor)
{
 	%weaponflag = 0;
	%numweapon = Player::getItemClassCount(%client,"Weapon");
	if (%numweapon > $MaxWeapons[%armor]) {
	   %weaponflag = %numweapon - $MaxWeapons[%armor];
	}
	%max = getNumItems();
	for (%i = 0; %i < %max; %i = %i + 1) {
		%item = getItemData(%i);
		%maxnum = $ItemMax[%armor, %item];
		if(%maxnum != "") {
			%numsell = 0;
			%count = Player::getItemCount(%client,%item);
			if(%count > %maxnum) {
				%numsell =  %count - %maxnum;
			}
			if (%count > 0 && %weaponflag && %item.className == Weapon) {
				%numsell = 1;
				%weaponflag = %weaponflag - 1;
			}
			if(%numsell > 0) {
		    	Client::sendMessage(%client,0,"SOLD " @ %numsell @ " " @ %item);
				teamEnergyBuySell(Client::getOwnedObject(%client),(%item.price * %numsell));
				Player::setItemCount(%client, %item, %count - %numsell);  
				updateBuyingList(%client);
			} 
		}
	}
}

function checkPlayerCash(%client)
{
	%team = Client::getTeam(%client);	
	if($TeamEnergy[%team] != "Infinite") {
		if(%client.teamEnergy > ($InitialPlayerEnergy * -1) ) {

		if(%client.teamEnergy >= 0)
				%diff = $InitialPlayerEnergy;
			else 
				%diff = $InitialPlayerEnergy + %client.teamEnergy;
			$TeamEnergy[%team] -= %diff;
		}
	}
}	


function Mission::reinitData()
{
      $TeamItemCount[0 @ CNode] = 0;
      $TeamItemCount[1 @ CNode] = 0;
      $TeamItemCount[2 @ CNode] = 0;
      $TeamItemCount[3 @ CNode] = 0;

	$TeamItemCount[0 @ ArwingV] = 0;
	$TeamItemCount[1 @ ArwingV] = 0;
	$TeamItemCount[2 @ ArwingV] = 0;
	$TeamItemCount[3 @ ArwingV] = 0;

	$TeamItemCount[0 @ CutterV] = 0;
	$TeamItemCount[1 @ CutterV] = 0;
	$TeamItemCount[2 @ CutterV] = 0;
	$TeamItemCount[3 @ CutterV] = 0;

	$TeamItemCount[0 @ HammerV] = 0;
	$TeamItemCount[1 @ HammerV] = 0;
	$TeamItemCount[2 @ HammerV] = 0;
	$TeamItemCount[3 @ HammerV] = 0;

	$TeamItemCount[0 @ ExplorerV] = 0;
	$TeamItemCount[1 @ ExplorerV] = 0;
	$TeamItemCount[2 @ ExplorerV] = 0;
	$TeamItemCount[3 @ ExplorerV] = 0;

	$TeamItemCount[0 @ RangerV] = 0;
	$TeamItemCount[1 @ RangerV] = 0;
	$TeamItemCount[2 @ RangerV] = 0;
	$TeamItemCount[3 @ RangerV] = 0;

	$TeamItemCount[0 @ IcarusV] = 0;
	$TeamItemCount[1 @ IcarusV] = 0;
	$TeamItemCount[2 @ IcarusV] = 0;
	$TeamItemCount[3 @ IcarusV] = 0;

	$TeamItemCount[0 @ AvengerV] = 0;
	$TeamItemCount[1 @ AvengerV] = 0;
	$TeamItemCount[2 @ AvengerV] = 0;
	$TeamItemCount[3 @ AvengerV] = 0;

	$TeamItemCount[0 @ FighterV] = 0;
	$TeamItemCount[1 @ FighterV] = 0;
	$TeamItemCount[2 @ FighterV] = 0;
	$TeamItemCount[3 @ FighterV] = 0;

	$TeamItemCount[0 @ TankV] = 0;
	$TeamItemCount[1 @ TankV] = 0;
	$TeamItemCount[2 @ TankV] = 0;
	$TeamItemCount[3 @ TankV] = 0;

	$TeamItemCount[0 @ ValkyrieV] = 0;
	$TeamItemCount[1 @ ValkyrieV] = 0;
	$TeamItemCount[2 @ ValkyrieV] = 0;
	$TeamItemCount[3 @ ValkyrieV] = 0;

	$TeamItemCount[0 @ DeployableAmmoPack] = 0;
	$TeamItemCount[0 @ DeployableInvPack] = 0;
	$TeamItemCount[0 @ TurretPack] = 0;
	$TeamItemCount[0 @ CameraPack] = 0;
	$TeamItemCount[0 @ DeployableSensorJammerPack] = 0;
	$TeamItemCount[0 @ PulseSensorPack] = 0;
	$TeamItemCount[0 @ MotionSensorPack] = 0;
	$TeamItemCount[0 @ ScoutVehicle] = 0;
	$TeamItemCount[0 @ LAPCVehicle] = 0;
	$TeamItemCount[0 @ HAPCVehicle] = 0;
	$TeamItemCount[0 @ Beacon] = 0;
	$TeamItemCount[0 @ mineammo] = 0;

	$TeamItemCount[1 @ DeployableAmmoPack] = 0;
	$TeamItemCount[1 @ DeployableInvPack] = 0;
	$TeamItemCount[1 @ TurretPack] = 0;
	$TeamItemCount[1 @ CameraPack] = 0;
	$TeamItemCount[1 @ DeployableSensorJammerPack] = 0;
	$TeamItemCount[1 @ PulseSensorPack] = 0;
	$TeamItemCount[1 @ MotionSensorPack] = 0;
	$TeamItemCount[1 @ ScoutVehicle] = 0;
	$TeamItemCount[1 @ LAPCVehicle] = 0;
	$TeamItemCount[1 @ HAPCVehicle] = 0;
	$TeamItemCount[1 @ Beacon] = 0;
	$TeamItemCount[1 @ mineammo] = 0;

	$TeamItemCount[2 @ DeployableAmmoPack] = 0;
	$TeamItemCount[2 @ DeployableInvPack] = 0;
	$TeamItemCount[2 @ TurretPack] = 0;
	$TeamItemCount[2 @ CameraPack] = 0;
	$TeamItemCount[2 @ DeployableSensorJammerPack] = 0;
	$TeamItemCount[2 @ PulseSensorPack] = 0;
	$TeamItemCount[2 @ MotionSensorPack] = 0;
	$TeamItemCount[2 @ ScoutVehicle] = 0;
	$TeamItemCount[2 @ LAPCVehicle] = 0;
	$TeamItemCount[2 @ HAPCVehicle] = 0;
	$TeamItemCount[2 @ Beacon] = 0;
	$TeamItemCount[2 @ mineammo] = 0;

	$TeamItemCount[3 @ DeployableAmmoPack] = 0;
	$TeamItemCount[3 @ DeployableInvPack] = 0;
	$TeamItemCount[3 @ TurretPack] = 0;
	$TeamItemCount[3 @ CameraPack] = 0;
	$TeamItemCount[3 @ DeployableSensorJammerPack]= 0;
	$TeamItemCount[3 @ PulseSensorPack] = 0;
	$TeamItemCount[3 @ MotionSensorPack] = 0;
	$TeamItemCount[3 @ ScoutVehicle] = 0;
	$TeamItemCount[3 @ LAPCVehicle] = 0;
	$TeamItemCount[3 @ HAPCVehicle] = 0;
	$TeamItemCount[3 @ Beacon] = 0;
	$TeamItemCount[3 @ mineammo] = 0;

	$TeamItemCount[4 @ DeployableAmmoPack] = 0;
	$TeamItemCount[4 @ DeployableInvPack] = 0;
	$TeamItemCount[4 @ TurretPack] = 0;
	$TeamItemCount[4 @ CameraPack] = 0;
	$TeamItemCount[4 @ DeployableSensorJammerPack]= 0;
	$TeamItemCount[4 @ PulseSensorPack] = 0;
	$TeamItemCount[4 @ MotionSensorPack] = 0;
	$TeamItemCount[4 @ ScoutVehicle] = 0;
	$TeamItemCount[4 @ LAPCVehicle] = 0;
	$TeamItemCount[4 @ HAPCVehicle] = 0;
	$TeamItemCount[4 @ Beacon] = 0;
	$TeamItemCount[4 @ mineammo] = 0;

	$TeamItemCount[5 @ DeployableAmmoPack] = 0;
	$TeamItemCount[5 @ DeployableInvPack] = 0;
	$TeamItemCount[5 @ TurretPack] = 0;
	$TeamItemCount[5 @ CameraPack] = 0;
	$TeamItemCount[5 @ DeployableSensorJammerPack]= 0;
	$TeamItemCount[5 @ PulseSensorPack] = 0;
	$TeamItemCount[5 @ MotionSensorPack] = 0;
	$TeamItemCount[5 @ ScoutVehicle] = 0;
	$TeamItemCount[5 @ LAPCVehicle] = 0;
	$TeamItemCount[5 @ HAPCVehicle] = 0;
	$TeamItemCount[5 @ Beacon] = 0;
	$TeamItemCount[5 @ mineammo] = 0;

	$TeamItemCount[6 @ DeployableAmmoPack] = 0;
	$TeamItemCount[6 @ DeployableInvPack] = 0;
	$TeamItemCount[6 @ TurretPack] = 0;
	$TeamItemCount[6 @ CameraPack] = 0;
	$TeamItemCount[6 @ DeployableSensorJammerPack]= 0;
	$TeamItemCount[6 @ PulseSensorPack] = 0;
	$TeamItemCount[6 @ MotionSensorPack] = 0;
	$TeamItemCount[6 @ ScoutVehicle] = 0;
	$TeamItemCount[6 @ LAPCVehicle] = 0;
	$TeamItemCount[6 @ HAPCVehicle] = 0;
	$TeamItemCount[6 @ Beacon] = 0;
	$TeamItemCount[6 @ mineammo] = 0;

	$TeamItemCount[7 @ DeployableAmmoPack] = 0;
	$TeamItemCount[7 @ DeployableInvPack] = 0;
	$TeamItemCount[7 @ TurretPack] = 0;
	$TeamItemCount[7 @ CameraPack] = 0;
	$TeamItemCount[7 @ DeployableSensorJammerPack]= 0;
	$TeamItemCount[7 @ PulseSensorPack] = 0;
	$TeamItemCount[7 @ MotionSensorPack] = 0;
	$TeamItemCount[7 @ ScoutVehicle] = 0;
	$TeamItemCount[7 @ LAPCVehicle] = 0;
	$TeamItemCount[7 @ HAPCVehicle] = 0;
	$TeamItemCount[7 @ Beacon] = 0;
	$TeamItemCount[7 @ mineammo] = 0;

	$TeamItemCount[0 @ DronePack] = 0;
	$TeamItemCount[0 @ AODGrogPack] = 0;
	$TeamItemCount[0 @ AODVelcroPack] = 0;
	$TeamItemCount[0 @ FluxPack] = 0;
	$TeamItemCount[0 @ AODArtilleryPack] = 0;
	$TeamItemCount[0 @ AODDefender] = 0;
	$TeamItemCount[0 @ Turret4Pack] = 0;
	$TeamItemCount[0 @ DisruptorTurretPack] = 0;
	$TeamItemCount[0 @ DMortarPack] = 0;
	$TeamItemCount[0 @ IonTurretPack] = 0;
	$TeamItemCount[0 @ PulseTurretPack] = 0;
	$TeamItemCount[0 @ DiscTurretPack] = 0;
	$TeamItemCount[0 @ RocketPack] = 0;
	$TeamItemCount[0 @ ElectroTurretPack] = 0;
	$TeamItemCount[0 @ TTurretPack] = 0;
	$TeamItemCount[0 @ LELFpack] = 0;
	$TeamItemCount[0 @ PortaAmmo] = 0;
	$TeamItemCount[0 @ PortaComm] = 0;
	$TeamItemCount[0 @ AODMobileInv] = 0;
	$TeamItemCount[0 @ AAairTurretPack] = 0;
	$TeamItemCount[0 @ doorfivebyfiveForceFieldShape] = 0;
	$TeamItemCount[0 @ doorfourbyeightForceFieldShape] = 0;
	$TeamItemCount[0 @ shieldedfivebyfiveForceFieldShape] = 0;
	$TeamItemCount[0 @ doorfivebyfiveForceFieldPack] = 0;
	$TeamItemCount[0 @ doorfourbyeightForceFieldPack] = 0;
	$TeamItemCount[0 @ shieldedfivebyfiveForceFieldPack] = 0;
	$TeamItemCount[0 @ BlastDoorShape] = 0;
	$TeamItemCount[0 @ SuperDoor] = 0;
	$TeamItemCount[0 @ DiagonalDoor] = 0;
	$TeamItemCount[0 @ PoweredDoor] = 0;
	$TeamItemCount[0 @ BlastFloorShape] = 0;
	$TeamItemCount[0 @ BaseOpsPack] = 0;
	$TeamItemCount[0 @ DeployableBaseOps] = 0;
	$TeamItemCount[0 @ MiniBase] = 0;
	$TeamItemCount[0 @ TNTPack] = 0;
	$TeamItemCount[0 @ C4Pack] = 0;
	$TeamItemCount[0 @ DShield] = 0;
	$TeamItemCount[0 @ DShieldPack] = 0;
	$TeamItemCount[0 @ BlastDoor] = 0;
	$TeamItemCount[0 @ BlastFloor] = 0;
	$TeamItemCount[0 @ GROGTurret] = 0;
	$TeamItemCount[0 @ VELCROTurret] = 0;
	$TeamItemCount[0 @ Fluxturret] = 0;
	$TeamItemCount[0 @ FusionTurret] = 0;
	$TeamItemCount[0 @ PlasmaTurret] = 0;
	$TeamItemCount[0 @ MortarTurret] = 0;
	$TeamItemCount[0 @ IonTurret] = 0;
	$TeamItemCount[0 @ RoundTurretPack] = 0;
	$TeamItemCount[0 @ PulseTurret] = 0;
	$TeamItemCount[0 @ DiscTurret] = 0;
	$TeamItemCount[0 @ DeployableRocket] = 0;
	$TeamItemCount[0 @ ArtilleryTurret] = 0;
	$TeamItemCount[0 @ AntiTurret] = 0;
	$TeamItemCount[0 @ AirTurret] = 0;
	$TeamItemCount[0 @ SniperAirTurret] = 0;
	$TeamItemCount[0 @ SniperAirTurretPack] = 0;
	$TeamItemCount[0 @ HFTurretPack] = 0;
	$TeamItemCount[0 @ BumperTurretPack] = 0;
	$TeamItemCount[0 @ SatchelChrgPack] = 0;

	$TeamItemCount[0 @ jailpack] = 0;
	$TeamItemCount[1 @ jailpack] = 0;
	$TeamItemCount[2 @ jailpack] = 0;
	$TeamItemCount[3 @ jailpack] = 0;

	$TeamItemCount[0 @ jailcappack] = 0;
	$TeamItemCount[1 @ jailcappack] = 0;
	$TeamItemCount[2 @ jailcappack] = 0;
	$TeamItemCount[3 @ jailcappack] = 0;

//	$TeamItemCount[0 @ SniperSpotPack] = 0;
//	$TeamItemCount[1 @ SniperSpotPack] = 0;
//	$TeamItemCount[2 @ SniperSpotPack] = 0;
//	$TeamItemCount[3 @ SniperSpotPack] = 0;

	$TeamItemCount[0 @ ElectrifiedDoor] = 0;
	$TeamItemCount[1 @ ElectrifiedDoor] = 0;
	$TeamItemCount[2 @ ElectrifiedDoor] = 0;
	$TeamItemCount[3 @ ElectrifiedDoor] = 0;

	$TeamItemCount[1 @ DronePack] = 0;
	$TeamItemCount[1 @ AODGrogPack] = 0;
	$TeamItemCount[1 @ AODVelcroPack] = 0;
	$TeamItemCount[1 @ FluxPack] = 0;
	$TeamItemCount[1 @ AODArtilleryPack] = 0;
	$TeamItemCount[1 @ AODDefender] = 0;
	$TeamItemCount[1 @ Turret4Pack] = 0;
	$TeamItemCount[1 @ DisruptorTurretPack] = 0;
	$TeamItemCount[1 @ DMortarPack] = 0;
	$TeamItemCount[1 @ IonTurretPack] = 0;
	$TeamItemCount[1 @ PulseTurretPack] = 0;
	$TeamItemCount[1 @ DiscTurretPack] = 0;
	$TeamItemCount[1 @ RocketPack] = 0;
	$TeamItemCount[1 @ ElectroTurretPack] = 0;
	$TeamItemCount[1 @ TTurretPack] = 0;
	$TeamItemCount[1 @ LELFpack] = 0;
	$TeamItemCount[1 @ PortaAmmo] = 0;
	$TeamItemCount[1 @ PortaComm] = 0;
	$TeamItemCount[1 @ AODMobileInv] = 0;
	$TeamItemCount[1 @ AAairTurretPack] = 0;
	$TeamItemCount[1 @ doorfivebyfiveForceFieldShape] = 0;
	$TeamItemCount[1 @ doorfourbyeightForceFieldShape] = 0;
	$TeamItemCount[1 @ shieldedfivebyfiveForceFieldShape] = 0;
	$TeamItemCount[1 @ doorfivebyfiveForceFieldPack] = 0;
	$TeamItemCount[1 @ doorfourbyeightForceFieldPack] = 0;
	$TeamItemCount[1 @ shieldedfivebyfiveForceFieldPack] = 0;
	$TeamItemCount[1 @ BlastDoorShape] = 0;
	$TeamItemCount[1 @ SuperDoor] = 0;
	$TeamItemCount[1 @ DiagonalDoor] = 0;
	$TeamItemCount[1 @ PoweredDoor] = 0;
	$TeamItemCount[1 @ BlastFloorShape] = 0;
	$TeamItemCount[1 @ BaseOpsPack] = 0;
	$TeamItemCount[1 @ DeployableBaseOps] = 0;
	$TeamItemCount[1 @ MiniBase] = 0;
	$TeamItemCount[1 @ TNTPack] = 0;
	$TeamItemCount[1 @ C4Pack] = 0;
	$TeamItemCount[1 @ DShield] = 0;
	$TeamItemCount[1 @ DShieldPack] = 0;
	$TeamItemCount[1 @ BlastDoor] = 0;
	$TeamItemCount[1 @ BlastFloor] = 0;
	$TeamItemCount[1 @ GROGTurret] = 0;
	$TeamItemCount[1 @ VELCROTurret] = 0;
	$TeamItemCount[1 @ Fluxturret] = 0;
	$TeamItemCount[1 @ FusionTurret] = 0;
	$TeamItemCount[1 @ PlasmaTurret] = 0;
	$TeamItemCount[1 @ MortarTurret] = 0;
	$TeamItemCount[1 @ IonTurret] = 0;
	$TeamItemCount[1 @ RoundTurretPack] = 0;
	$TeamItemCount[1 @ PulseTurret] = 0;
	$TeamItemCount[1 @ DiscTurret] = 0;
	$TeamItemCount[1 @ DeployableRocket] = 0;
	$TeamItemCount[1 @ ArtilleryTurret] = 0;
	$TeamItemCount[1 @ AntiTurret] = 0;
	$TeamItemCount[1 @ AirTurret] = 0;
	$TeamItemCount[1 @ SniperAirTurret] = 0;
	$TeamItemCount[1 @ SniperAirTurretPack] = 0;
	$TeamItemCount[1 @ HFTurretPack] = 0;
	$TeamItemCount[1 @ BumperTurretPack] = 0;
	$TeamItemCount[1 @ SatchelChrgPack] = 0;

	for(%i = 0; %i < 8; %i++)
	{
		$TeamItemCount[%i @ DronePack] = 0;
		$TeamItemCount[%i @ AODGrogPack] = 0;
		$TeamItemCount[%i @ AODVelcroPack] = 0;
		$TeamItemCount[%i @ FluxPack] = 0;
		$TeamItemCount[%i @ AODArtilleryPack] = 0;
		$TeamItemCount[%i @ AODDefender] = 0;
		$TeamItemCount[%i @ Turret4Pack] = 0;
		$TeamItemCount[%i @ DisruptorTurretPack] = 0;
		$TeamItemCount[%i @ DMortarPack] = 0;
		$TeamItemCount[%i @ IonTurretPack] = 0;
		$TeamItemCount[%i @ RoundTurretPack] = 0;
		$TeamItemCount[%i @ PulseTurretPack] = 0;
		$TeamItemCount[%i @ DiscTurretPack] = 0;
		$TeamItemCount[%i @ RocketPack] = 0;
		$TeamItemCount[%i @ ElectroTurretPack] = 0;
		$TeamItemCount[%i @ TTurretPack] = 0;
		$TeamItemCount[%i @ LELFpack] = 0;
		$TeamItemCount[%i @ PortaAmmo] = 0;
		$TeamItemCount[%i @ PortaComm] = 0;
		$TeamItemCount[%i @ AODMobileInv] = 0;
		$TeamItemCount[%i @ AAairTurretPack] = 0;
		$TeamItemCount[%i @ doorfivebyfiveForceFieldShape] = 0;
		$TeamItemCount[%i @ doorfourbyeightForceFieldShape] = 0;
		$TeamItemCount[%i @ shieldedfivebyfiveForceFieldShape] = 0;
		$TeamItemCount[%i @ doorfivebyfiveForceFieldPack] = 0;
		$TeamItemCount[%i @ doorfourbyeightForceFieldPack] = 0;
		$TeamItemCount[%i @ shieldedfivebyfiveForceFieldPack] = 0;
		$TeamItemCount[%i @ BlastDoorShape] = 0;
		$TeamItemCount[%i @ SuperDoor] = 0;
		$TeamItemCount[%i @ DiagonalDoor] = 0;
		$TeamItemCount[%i @ PoweredDoor] = 0;
		$TeamItemCount[%i @ BlastFloorShape] = 0;
		$TeamItemCount[%i @ BaseOpsPack] = 0;
		$TeamItemCount[%i @ DeployableBaseOps] = 0;
		$TeamItemCount[%i @ MiniBase] = 0;
		$TeamItemCount[%i @ TNTPack] = 0;
		$TeamItemCount[%i @ C4Pack] = 0;
		$TeamItemCount[%i @ DShield] = 0;
		$TeamItemCount[%i @ DShieldPack] = 0;
		$TeamItemCount[%i @ BlastDoor] = 0;
		$TeamItemCount[%i @ BlastFloor] = 0;
		$TeamItemCount[%i @ GROGTurret] = 0;
		$TeamItemCount[%i @ VELCROTurret] = 0;
		$TeamItemCount[%i @ Fluxturret] = 0;
		$TeamItemCount[%i @ FusionTurret] = 0;
		$TeamItemCount[%i @ PlasmaTurret] = 0;
		$TeamItemCount[%i @ MortarTurret] = 0;
		$TeamItemCount[%i @ IonTurret] = 0;
		$TeamItemCount[%i @ PulseTurret] = 0;
		$TeamItemCount[%i @ DiscTurret] = 0;
		$TeamItemCount[%i @ DeployableRocket] = 0;
		$TeamItemCount[%i @ ArtilleryTurret] = 0;
		$TeamItemCount[%i @ AntiTurret] = 0;
		$TeamItemCount[%i @ AirTurret] = 0;
		$TeamItemCount[%i @ SniperAirTurret] = 0;
		$TeamItemCount[%i @ SniperAirTurretPack] = 0;
		$TeamItemCount[%i @ HFTurretPack] = 0;
		$TeamItemCount[%i @ BumperTurretPack] = 0;
		$TeamItemCount[%i @ SatchelChrgPack] = 0;
	}

	%numPlayers = getNumClients();
	for(%i = -1; %i < 2 ; %i++)		// AAOD Mod Only Supports 2 Teams at this time
	{	
		$NodeSet[%i]		= false;
		$PowerSet[%i]		= false;
		$ShieldGenOn[%i]	= false;
		$ShieldGen[%i]		= false;
		$NodeSet[%i]		= "";
		$LastFlagHolder[%i]	= false;
		$Teleporter[%i]		= false;
		$TeleportNode[%i]	= false;
		$GenSet[%i]			= "";
				
		$TeamItemCount[%i @ deployableTeleport]					= 0;
		$TeamItemCount[%i @ teleportpack]				= 0;

		$TeamItemCount[%i @ AODBunker]					= 0;
		$TeamItemCount[%i @ AODMobileInv]				= 0;
		$TeamItemCount[%i @ AODMobileGen]				= 0;
		$TeamItemCount[%i @ AODShieldGen]				= 0;
		$TeamItemCount[%i @ AODShieldNode]				= 0;
		$TeamItemCount[%i @ AODTeleporter]				= 0;
	}

	$totalNumCameras = 0;
	$totalNumTurrets = 0;


for(%i = -1; %i < 8 ; %i++)
		$TeamEnergy[%i] = $DefaultTeamEnergy; 
}

exec(defs);
//exec("HaVoCEmu.dat");
exec(weapons);
exec(packs);
exec(deployables);
