//-----------------------------------------------------------------------------------------------------------
//					AAOD Deployables File
//___________________________________________________________________________________________________________
//	Contains all the Deployable related functions as well as the generic 
//	Deployable Routines......
//-----------------------------------------------------------------------------------------------------------

$boostStr	= 0.17;

function DeployTheShape(%player, %item, %turret, %objects, %flagdist, %flatonly, %MaxLength, %MaxWidth, %MaxHeight, %MinLength, %MinWidth, %MinHeight, %number, %msg) 
{
 	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{
		if (GameBase::getLOSInfo(%player,8)) 
		{
			%playerTeam = GameBase::getTeam(%player);
			if(Vector::getDistance(GameBase::getPosition($teamFlag[%playerTeam]), $los::position) < %flagdist) 
			{
				Client::sendMessage(%client,0,"You are too close to your flag~waccess_denied.wav");
				return false;
			}
			%obj = getObjectType($los::object);
			if (%obj != "SimTerrain" && %obj != "InteriorShape" && GameBase::getDataName($los::object) != "AirAmmoBasePad") {
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
				return false;
			}
			if(!checkDeployArea(%client, $los::position)) return false;
			%set = newObject("set",SimSet); 
			%num = containerBoxFillSet(%set, $StaticObjectType, $los::position, 32, 32, 17, 0); 
			%num = CountThes(%set, %num);
			deleteObject(%set); 
			if(%num > 4) 
			{
				Client::sendMessage(%client,0,"Sensor Interference - Too many turrets in the area");
				return false;
			}			
			%set = newObject("set",SimSet); 
			%numinset = containerBoxFillSet(%set, $StaticObjectType, $los::position, %MaxLength, %MaxWidth, %MaxHeight, 0); 
			%num = CountObjects(%set, %turret, %numinset);
			%object = getword(%objects, 0);
			for(%i = 1; %object != -1; %i++) 
			{
				%num = %num + CountObjects(%set, %object, %numinset);
				%object = getword(%objects, %i);
			}
			deleteObject(%set); 
			if(%num < $MaxNumTurretsInBox) 
			{ 
				%set = newObject("set",SimSet); 
				%numinset = containerBoxFillSet(%set, $StaticObjectType, $los::position, %MinLength, %MinWidth, %MinHeight, 0); 
				%num = CountObjects(%set, %turret, %numinset);
				%object = getword(%objects, 0);
				for(%i = 1; %object != -1; %i++) 
				{
					%num = %num + CountObjects(%set, %object, %numinset);
					%object = getword(%objects, %i);
				}
				deleteObject(%set); 
				if(%num == 0) 
				{
					%rot = GameBase::getRotation(%player);
					if (%flatonly) 
					{
						if (Vector::dot($los::normal, "0 0 1") <= 0.7) 
						{
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
							return false;
						}
					} 
					else 
					{
						%zRot = getWord(%rot, 2);
						if (Vector::dot($los::normal, "0 0 1") > 0.6) 
						{
							%rot = "0 0 " @ %zRot;
						} 
						else 
						{
							if (Vector::dot($los::normal, "0 0 -1") > 0.6) 
							{
								%rot = "3.14159 0 " @ %zRot;
							} 
							else 
							{
								%rot = Vector::getRotation($los::normal);
							}
						}
					}
					if(%number != "") 
					{
						%number++;
						%number = " #" @ %number;
					}
					%turret = newObject("", "Turret", %turret, true);
					addToSet("MissionCleanup", %turret);
					GameBase::setTeam(%turret, %playerTeam);
					GameBase::setRotation(%turret, %rot);
					GameBase::startFadeIn(%turret);
					GameBase::setPosition(%turret, $los::position);
					%turret.ownerName = Client::getName(%client); 
					dotog(%player);
					Gamebase::setMapName(%turret, %item.description @ %number @ " " @ %turret.ownerName);
					Client::sendMessage(%client, 0, %item.description @ %number @ " deployed");
					echo("MSG: ",%client," ",%turret.ownerName," deployed ",%item.description,%number); 
					playSound(SoundPickupBackpack,$los::position);
					$TeamItemCount[%playerTeam @ %item]++;
					%client.hasDeployed = true;
					doset(%client, %player, %turret);
					return %turret;
				} 
				else
				{
					Client::sendMessage(%client,0,"Frequency Overload - Too close to another " @ %msg @ " Turret"); 
				}
			} 
			else
			{
				Client::sendMessage(%client,0,"Interference from other " @ %msg @ " Turrets in the area");
			}
		} 
		else
		{
			Client::sendMessage(%client,0,"Deploy position out of range");
		}
	} 
	else																				{
	 	Client::sendMessage(%client,0,"Deployable item limit reached for " @ %item.description @ "s");
		return false;
	}
}

function DeployAnyShape(%player, %item, %cat, %name, %flatonly, %deployon) 
{
 	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{
		if (GameBase::getLOSInfo(%player,8)) 
		{
			%playerTeam = GameBase::getTeam(%player);
			if(Vector::getDistance(GameBase::getPosition($teamFlag[%playerTeam]), $los::position) < 1) 
			{
				Client::sendMessage(%client,0,"You are too close to your flag~waccess_denied.wav");
				return false;
			}
			%obj = getObjectType($los::object);
			if(%deployon == 1) 
			{
				if (%obj != "SimTerrain" && %obj != "InteriorShape" && GameBase::getDataName($los::object) != "AirAmmoBasePad") 
				{
					Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
					return false;
				}
			} 
			else if(%deployon == 2) 
			{
				if (%obj != "SimTerrain") 
				{
					Client::sendMessage(%client,0,"Can only deploy on terrain");
					return false;
				}
			}
			if(!checkDeployArea(%client, $los::position)) return false;
			%rot = GameBase::getRotation(%player);
			if (%flatonly) 
			{
				if (Vector::dot($los::normal, "0 0 1") <= 0.7) 
				{
					Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					return false;
				}
			} 
			else 
			{
				%zRot = getWord(%rot, 2);
				if (Vector::dot($los::normal, "0 0 1") > 0.6) 
				{
					%rot = "0 0 " @ %zRot;
				} 
				else 
				{
					if (Vector::dot($los::normal, "0 0 -1") > 0.6) 
					{
						%rot = "3.14159 0 " @ %zRot;
					} 
					else 
					{
						%rot = Vector::getRotation($los::normal);
					}
				}
			}
			%turret = newObject("", %cat, %name, true);
			addToSet("MissionCleanup", %turret);
			GameBase::setTeam(%turret, %playerTeam);
			GameBase::setRotation(%turret, %rot);
			GameBase::startFadeIn(%turret);
			GameBase::setPosition(%turret, $los::position);
			%turret.ownerName = Client::getName(%client); 
			dotog(%player);
			Gamebase::setMapName(%turret, %item.description);
			Client::sendMessage(%client, 0, %item.description @ " deployed");
			echo("MSG: ",%client," ",%turret.ownerName," deployed ",%item.description); 
			playSound(SoundPickupBackpack,$los::position);
			$TeamItemCount[%playerTeam @ %item]++;
			%client.hasDeployed = true;
			doset(%client, %player, %turret);
			return %turret;
		} 
		else
		{
			Client::sendMessage(%client,0,"Deploy position out of range");
		}
	} 
	else																				{
	 	Client::sendMessage(%client,0,"Deployable item limit reached for " @ %item.description @ "s");
		return false;
	}
}

function CheckObjectType(%object,%type)
{	//if($traceDep) Echo("Checking: Is deployable placement on ",%object," valid for type: ",%type);

	if (%type==0)		// **** Can be PLaced on Terrain Only
	{
		if (%object=="SimTerrain")
		return(true);
	}
	else if (%type==1)	// **** Can Be Placed on Terrain & Buildings
//	{	if (%object=="SimTerrain" || %object=="InteriorShape")
	{
		if (%object=="SimTerrain" || %object=="InteriorShape"|| GameBase::getDataName($los::object) == "BlastFloorShape")
		return(true);
	}	
	else if (%type==2)	// **** Can Be Placed on Terrain, Buildings & Some objects
	{
		if ((%object=="SimTerrain" || %object=="InteriorShape" ) || (%object=="Turret" || %object=="sensor"))
		return(true);
	}
	else if(%type==3)	// **** Can Be Placed on Buildings & Terrain but Must be Outside
	{
		if (%object=="SimTerrain" || %object=="InteriorShape")
		{
			%num=0;
			%setx = newObject("set",SimSet);
			%pos1=$los::position;
			%pos=Vector::Add(%pos1,"0 0 30");
			%num = containerBoxFillSet(%setx,$SimInteriorObjectType,%pos,1,1,50,0);
			deleteObject(%setx);
			if(!%num)	return(true);
		}
	}
	else if (%type==5)	// **** Can Be Placed on Buildings only
	{
		if (%object=="InteriorShape")
		return(true);
	}
	return(false);
}

function DeployStuff(%player,%item,%shape,%pType,%dist,%cType,%dtype,%DonD,%Power,%pRange)
{	
	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	// %ptype = 0 for SimTerrain only
	// %ptype = 1 for SimTerrain or Interior Shapes
	// %ptype = 2 for SimTerrain or Interior Shapes or Objects
	// %ptype = 3 Outside clear sky above....(is this possible - The answer being yes!!!)
	// %ptype = 5 for Interior Shapes only
	// %dist is the max deploy distance
	// %ctype = 0	Use Defaults for Interference Checking
	// %ctype = 1	Turret Use Turret Box Values for checking interference
	// %ctype = 2	Forcefield Use Forcefield Values for Interference checking
	// %dtype = true or false	(True means it can be placed on any surface)
	// %shape = Shape Name (String) The Name of the DATA Block for this shape
	// %shape = Shape
	// %DonD  = Delete on Destroy True or False
	// %tname = Name of Type items
	// %power = 0= Item has No special Power Needs|1=Item Requires Power|2=Item generates Power 
	//			   (Item which requires Power will have an %item.prange var for how far it can look for power)
	
	%descr=%item.description;
		
	if(%ptype==0)
		%pDesc="Terrain";
	else if(%ptype==1)
		%pDesc="Terrain & Buildings";
	else if(%ptype==2)
		%pDesc="Terrain, Buildings & Objects";
	else if(%ptype==3)
		%pDesc="Terrain & Buildings but MUST be Outside";
	else if(%ptype==4)
		%pDesc="Terrain";
	else if(%ptype==5)
		%pDesc="Buildings";

			
	if (%ctype==1)
	{	%BxMxL=$TurretBoxMaxLength;
		%BxMnL=$TurretBoxMinLength;
		%BxMxW=$TurretBoxMaxWidth;
		%BxMnW=$TurretBoxMinWidth;
		%BxMxH=$TurretBoxMaxHeight;
		%BxMnH=$TurretBoxMinHeight;
		%MaxNum=$MaxNumTurretsInBox;
		%class="Turret";
		%tname="deployable Turrets";
	}
	else if (%ctype==2)
	{	%BxMxL=$FFBxMxLength;
		%BxMnL=$FFBxMnLength;
		%BxMxW=$FFBxMxWidth;
		%BxMnW=$FFBxMnWidth;
		%BxMxH=$FFBxMxHeight;
		%BxMnH=$FFBxMnHeight;
		%MaxNum=$MaxNumFieldsInBox;
		%class="StaticShape";
		%tname="Deployable Forcefields";
	}
	else if (%ctype==4)	// Nodes
	{	%BxMxL=10;
		%BxMnL=1;
		%BxMxW=10;
		%BxMnW=1;
		%BxMxH=10;
		%BxMnH=1;
		%MaxNum=2;
		%class="StaticShape";
	}
	else
	{	%BxMxL=2;
		%BxMnL=1;
		%BxMxW=2;
		%BxMnW=1;
		%BxMxH=2;
		%BxMnH=1;
		%MaxNum=1;
		%class="StaticShape";
	}
	
	%team=GameBase::getTeam(%player);
	%client = Player::getClient(%player);
	if($TeamItemCount[ %team @ %item] < $TeamItemMax[%item])	// Check to see if Item Count has been Reached
	{
		%thisnum=$TeamItemCount[%team @ %item]+1;
		if (GameBase::getLOSInfo(%player,%dist)) 
		{
			%obj = getObjectType($los::object);
			if(CheckObjectType(%obj,%ptype))
			{
				%set = newObject("set",SimSet);
				%tnum = containerBoxFillSet(%set,$StaticObjectType,$los::position,%BxMxL,%BxMxW,%BxMxH,0);
				%num = GetNumObjects(%set,%ctype,%tnum);
				deleteObject(%set);
				if(%MaxNum > %num) 
				{
					%set = newObject("set",SimSet);
					%tnum = containerBoxFillSet(%set,$StaticObjectType,$los::position,%BxMnL,%BxMnW,%BxMnH,0);
					%num = GetNumObjects(%set,%ctype,%tnum);
					if(0 == %num)	// No Objects within the Minimum Box
					{
						if(%dtype==1)	//	If Deployable on Any Surface
						{	// Try to stick it straight up or down, otherwise
							// just use the surface normal
							%prot = GameBase::getRotation(%player);
							//if($trace) echo("Player Rotation ",%prot);
							//%zRot = (3.141592654-getWord(%prot,2));
							//if($trace) echo("Player Rotation ",%zrot);
							%zRot = (getWord(%prot,2));

							if (Vector::dot($los::normal,"0 0 1") > 0.6) 
							{
								%rot = "0 0 " @ %zRot;
							}
							else
							{
								if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
								{
									%rot = "3.14159 0 " @ %zRot;
								}
								else
								{
									%rot = Vector::getRotation($los::normal);
								}
							}
						}
						else if(%dtype==2)	//	Matches Any Surface
						{
							%rot = Vector::getRotation($los::normal);
						}
						else
						{
							if (Vector::dot($los::normal,"0 0 1") <= 0.7)
							{
								Client::sendMessage(%client,0,%desc@" Can only deploy on flat surfaces~werror_message.wav");
								return (false);
							}
							%rot = GameBase::getRotation(%player);
						}	
							
						if(checkDeployArea(%client,$los::position)) 
						{
							%newitem = newObject(%shape,%class,%shape,%DonD);
							if($traceObj) Echo($Ver,"|Created New Object :",%newitem," ",%descr);
							GameBase::playSequence(%newitem,1,"deploy");
							GameBase::SetActive(%newItem,false);
							%newitem.faded=1;
							addToSet("MissionCleanup", %newitem);
							GameBase::setTeam(%newitem,%team);
							GameBase::setPosition(%newitem,$los::position);
							GameBase::setRotation(%newitem,%rot);
							Gamebase::setMapName(%newitem,%descr @" #" @ %thisnum @ " " @ Client::getName(%client));
							Client::sendMessage(%client,0,%descr @" deployed");
							playSound(SoundCreateItem,$los::position);
							$TeamItemCount[%team @ %item]++;
							
							%newitem.deployedBy	= %client;
							%newitem.powerReq	= %power;
							%newitem.pRange		= %pRange;

							if(%power==1)	// Item Requires Power
							{
								if($TracePwr) echo(%newitem," requires Power!");
								Client::sendMessage(%client,0,"Attempting to connect to Main Power Grid~AAODSFX13.WAV");
								schedule("PowerItem("@%newitem@","@%pRange@","@%client@");",2,%newitem);
							}
							else if(%power==2)	// Item generates Power
							{
								if($TracePwr) echo(%newitem,"	Power Generator!");
								GameBase::SetActive(%newItem,true);
								Client::sendMessage(%client,0,"Attempting to connect Generator to Main Grid~AAODSFX13.WAV");
								schedule("ConnectGenerator("@%newitem@","@%client@");",2,%newitem);
								if($GenSet[%team])
								{
									addToSet($GenSet[%team],%newItem);
								}
								else
								{
									$GenSet[%team]=newObject("set",SimSet);
									addToSet("MissionCleanup",$GenSet[%team]);
									addToSet($GenSet[%team],%newItem);
								}
							}
							else
							{
								GameBase::SetActive(%newItem,true);
							}
							echo(">INF: ",$User[%client]," deployed a "@ %descr);
							return (%newitem);
						}
					}
					else Client::sendMessage(%client,0,"Frequency Overload - Too close to other "@%tname);
				}
				else Client::sendMessage(%client,0,"Too Many Other "@%tname@" in the area");
			}
			else Client::sendMessage(%client,0,%descr@" can only be deployed on "@%pDesc@"~wAAODSFX09.WAV");
		}
		else Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %descr);
	return (false);
}

function MoveForward::rotVector(%vec,%rot)
{
	// this function rotates a vector about the z axis

	%vec_x = getWord(%vec,0);
	%vec_y = getWord(%vec,1);
	%vec_z = getWord(%vec,2);

	// new vector with z axis removed
	%basevec = %vec_x @ "  " @ %vec_y @ "  0";
	
	// change vector to distance and rotation
	%basedis = Vector::getDistance( "0 0 0", %basevec);
	%normvec = Vector::normalize( %basevec );
	%baserot = Vector::add( Vector::getRotation( %normvec ), "1.571 0 0" );

	// modify rotation and change back to vector (put z axis offset back)
	%newrot = Vector::add( %baserot, %rot );
	%newvec = Vector::getFromRot( %newrot, %basedis, %vec_z );

	return %newvec;
}

function CountObjects(%set,%name,%num)
{
	%count = 0;
	for(%i=0;%i<%num;%i++) 
	{
		%obj=Group::getObject(%set,%i);
		if(GameBase::getDataName(Group::getObject(%set,%i)) == %name)
		{
			%count++;
		}
	}
	return %count;
}

//----------------------------------------------------------------------------
// Remote Cloaking Node
//----------------------------------------------------------------------------

$InvList[AODShieldNode]	= 1;
$RemoteInvList[AODShieldNode]	= 1;
$TeamItemMax[AODShieldNode]	= 30;

$ItemMax[larmor, AODShieldNode]	= 1;
$ItemMax[lfemale, AODShieldNode]	= 1;
$ItemMax[marmor, AODShieldNode]	= 1;
$ItemMax[mfemale, AODShieldNode]	= 1;
$ItemMax[harmor, AODShieldNode]	= 1;

ItemImageData AODShieldNodeImage 
{	shapeFile = "sensor_jammer";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 3.0;
	firstPerson = false;
};

ItemData AODShieldNode 
{	description = "Remote Shield Node";
	shapeFile = "sensor_jammer";
	classname = "Backpack";
	heading = "lDeployables";
	imageType = AODShieldNodeImage;
	shadowDetailMask = 4;
	mass = 3.0;
	elasticity = 0.2;
	price = 750;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

StaticShapeData RemoteShieldNode 
{	description		= "Shield Node";
	shapeFile		= "sensor_jammer";
	classname		= "ShieldNode";
	debrisId		= flashDebrisSmall;
	sfxAmbient		= SoundGeneratorPower;
	maxDamage		= 72.5;
	mapIcon			= "M_generator";
	damageSkinData	= "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId		= flashExpMedium;
	visibleToSensor = true;
	mapFilter		= 4;
	maxEnergy		= 50;
};

function AODShieldNode::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	
		Player::mountItem(%player,%item,$BackpackSlot);	
	}
	else 
	{	
		Player::deployItem(%player,%item);
	}
}

function AODShieldNode::onDeploy(%player,%item,%pos)
{
	if (AODShieldNode::deployShape(%player,%item)) 
	{
		Player::decItemCount(%player,%item);
	}
}

function AODShieldNode::deployShape(%player,%item)
{
	if($trace) echo( $ver@"|Deploying Remote Shield Node");
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{	if (GameBase::getLOSInfo(%player,8)) 
		{	%obj = getObjectType($los::object);
			if($trace) echo( $ver@"|Object Type = ",%obj);
			if ((%obj == "SimTerrain" || %obj == "InteriorShape") || (%obj == "Turret" || %obj =="sensor") ||( %obj == "StaticShape"))
			{	%set = newObject("set",SimSet);
				%tnum = containerBoxFillSet(%set,$StaticObjectType,$los::position,2,2,2,0);
				%num = GetNumObjects(%set,0,%tnum);
				if(%num==1) 
				{		%boostObj=Group::getObject(%set,0);
						if (%boostObj.shieldNode)
						{	Client::sendMessage(%client,0,"DANGER!!! Shield Node Feedback!!~wError_message.wav");
							%pos1=GameBase::getPosition(%BoostObj.shieldNode);
							%pos2=GameBase::getPosition(%client);
							%vec=vector::sub(%pos1,%pos2);
							Player::onDamage(%client,$EnergyDamageType,1.5,%pos,%vec,"","head","front_left",%node);
							return false;
						}
						else
						{	deleteObject(%set);
							%prot = GameBase::getRotation(%player);
							%zRot = getWord(%prot,2);
							if (Vector::dot($los::normal,"0 0 1") > 0.6) 
							{	%rot = "0 0 " @ %zRot;}
							else
							{	if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
								{	%rot = "3.14159 0 " @ %zRot;}
								else
								{	%rot = Vector::getRotation($los::normal);}
							}
							%node = newObject("RemoteShieldNode","StaticShape",RemoteShieldNode,true);
							if($traceObj) Echo($Ver,"|Created New Object :",%newitem," | Remote Shield Node");
							echo("Shield Node Created (Node #",%node,") ");
							%team=GameBase::getTeam(%player);
							GameBase::setTeam(%node,%team);
							GameBase::setPosition(%node,$los::position);
							GameBase::setRotation(%node,%rot);
							Gamebase::setMapName(%node,"ShieldNode#" @ $totalNumNodes++ @ " " @ Client::getName(%client));
							Gamebase::StartFadein(%node);
							addToSet("MissionCleanup", %node);
							Client::setOwnedObject(%client, %node); 
							Client::setOwnedObject(%client, %player);
							GameBase::setActive(%node,true);
							playSound(SoundCreateItem,$los::position);
							%boostObj.shieldNode=%node;
							%node.isGuarding=%boostObj;
							// Add Node to Node Set
							if(!$NodeSet[%team])
							{	if($trace) echo( $ver@"|Creating a Node Set for Team ",%team);
								$NodeSet[%team] = newObject("ShieldNodes",SimSet);
								addToSet("MissionCleanup", $NodeSet[%team]);
							}
								
							addToSet($NodeSet[%team],%node);
							%name=GameBase::GetDataName(%boostObj);
							//	Get the shield strength of the Item
							if (!$ShieldGenOn[%team])
								Client::sendMessage(%client,1,"Shield Generator is NOT functioning!!");
							Client::sendMessage(%client,0,"Remote Shield Node deployed - Shield activated on:"@%name);
							$TeamItemCount[GameBase::getTeam(%player) @ "AODShieldNode"]++;
							echo("MSG: ",$User[%client]," deployed a Remote Shield Node on ",%name);
							return true;						
						}
				}
				else 
				{	deleteObject(%set);
					if (%num>1)
					{	Client::sendMessage(%client,0,"Too Many Items in area - unable to obtain single interface");}
					else if (%num==0)
					{	Client::sendMessage(%client,0,"Nothing to interface to. Node Must be placed close to an object which will have its shield boosted.~Werror_message.wav");}
				}
				
			}
			else Client::sendMessage(%client,0,"Can only deploy on terrain/buildings or objects");
		}
		else Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	return false;
}


function RemoteShieldNode::onEndSequence(%this)
{	echo("Node on End sequence");
	if(%this.position==1)	
		GameBase::playSequence(%this,0,"power");
}

function RemoteShieldNode::onDestroyed(%this)
{	if($trace) echo( $ver@"|Remote Shield Node::On destroyed");
	%team=GameBase::getTeam(%this);
	$TeamItemCount[%team @ "AODShieldNode"]--;
	$totalNumNodes--;
	for(%i=0;%i<=Group::objectCount($NodeSet[%team]);%i++)
	{	%node=Group::GetObject($NodeSet[%team],%i);
		if(%node==%this)
		{	removeFromSet($NodeSet[%team], %i);
		}
	}
	%boostObj				= %this.isGuarding;
	%this.isGuarding		="";
	%boostObj.shieldNode	="";
						
	if ($ShieldGen[%team])
	{	if($trace) echo( $ver@"|Shield Gen Exists applying Node Feedback Damage");
		%pos1=GameBase::getPosition(%this);
		%pos2=GameBase::getPosition($ShieldGen[%team]);
		%vec=vector::sub(%pos1,%pos2);
		%damageLevel = GameBase::getDamageLevel($ShieldGen[%team]);
		NewStaticShapeDamage($ShieldGen[%team],%this,%damageLevel,0.1);
	}
}

function RemoteShieldNode::onDisabled(%this)
{	if($trace) echo( $ver@"|Remote Shield Node on Disabled");
	GameBase::setRechargeRate(%this,0);
	Gamebase::setEnergy(%this,0);
	%this.Position=0;
	GameBase::stopSequence(%this,0);
	GameBase::setSequenceDirection(%this,1,0);
	GameBase::playSequence(%this,1,"deploy");
	%this.shieldStrength = 0;
	
}

function RemoteShieldNode::onActivate(%this)
{	if($trace) echo( $ver@"|Remote Shield Node onActivate");
	if($trace) echo( $ver@"|Node ID = ",%this);
	%team=GameBase::getTeam(%this);
	%this.shieldStrength = $boostStr;
	if($ShieldGen[%team])
	{	if($trace) echo( $ver@"|Shield Generator Exists for This Team (",%team,")& is ON");
		if($ShieldGenOn[%team])
		{	if($trace) echo($Ver,"| Shield Generator is On!");
		GameBase::setActive(%this,true);
			%this.Position=1;
			GameBase::setSequenceDirection(%this,1,1);
			GameBase::playSequence(%this,1,"deploy");
			GameBase::setRechargeRate(%this,15);
			GameBase::playSequence(%this,1); 
			GameBase::setAutoRepairRate(%this, 0.5);
//			GameBase::setAutoRepairRate(%this, 0.05);
		}
		else
			if($trace) echo($Ver,"| Shield Generator is Off!");

	}
	else
		if($trace) echo( $ver@"|Shield Generator Does Not Exist for This Team");
	
}

function RemoteShieldNode::onEnabled(%this)
{	if($trace) echo( $ver@"|Shield Node - Enabled");
	if($trace) echo( $ver@"|Node ID = ",%this);
	RemoteShieldNode::onActivate(%this);
}

function RemoteShieldNode::onDeActivate(%this)
{	if($trace) echo( $ver@"|Shield Node - DeActivated");
	RemoteShieldNode::onDisabled(%this);
}

//----------------------------------------------------------------------------
// Remote Cloaking Node
//----------------------------------------------------------------------------

ItemImageData CNodeImage
{
	shapeFile = "sensor_small";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 2.5;
	firstPerson = false;
};

ItemData CNode
{
	description = "Remote Cloaking Node";
	shapeFile = "sensor_small";
	className = "Backpack";
	heading = "lDeployables";
	imageType = CNodeImage;
	shadowDetailMask = 4;
	mass = 2.0;
	elasticity = 0.2;
	price = 1200;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function CNode::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function CNode::onDeploy(%player,%item,%pos)
{
	if (CNode::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}


function CNode::deployShape(%player,%item)
{
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,8)) {
                        %obj = getObjectType($los::object);
                        %data = GameBase::getDataName($los::object);
                        if ((%obj == "StaticShape" || %obj == "Turret" || %obj == "Sensor" || %obj == "Flier") && %data != "BlastDoorShape" && %data != "doorfivebyfiveForceFieldShape" && %data != "doorthreebyfourForceFieldShape" && %data != "doorfourbyeightForceFieldShape") {
//                        if ((%obj == "StaticShape" || %obj == "Turret" || %obj == "Sensor") && %data != "BlastDoorShape" && %data != "BlastFloorShape" && %data != "doorfivebyfiveForceFieldShape" && %data != "doorthreebyfourForceFieldShape" && %data != "doorfourbyeightForceFieldShape" && %data != "TowerSwitch") {
                                    %prot = GameBase::getRotation(%player);
                                %zRot = getWord(%prot,2);
                                if (Vector::dot($los::normal,"0 0 1") > 0.6) {
                                        %rot = "0 0 " @ %zRot;
                                } else {
                                        if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
                                                %rot = "3.14159 0 " @ %zRot;
                                        } else {
                                                %rot = Vector::getRotation($los::normal);
                                        }
                                }
                                %turret = newObject("","Sensor",CloakingNode,true);
		                    addToSet("MissionCleanup", %turret);
                                GameBase::setTeam(%turret,GameBase::getTeam(%player));
                                GameBase::setPosition(%turret,$los::position);
                                GameBase::setRotation(%turret,%rot);
                                Gamebase::setMapName(%turret,"Cloaking Node");
                                Client::sendMessage(%client,0,"Cloaking Node deployed");
                                playSound(SoundPickupBackpack,$los::position);
                                $TeamItemCount[GameBase::getTeam(%player) @ "CNode"]++;
//                                $TeamItemCount[GameBase::getTeam(%player) @ "Hider"]++;
                                echo("MSG: ",%client," ",Client::getName(%client)," deployed a Cloaking Node");
                                GameBase::startFadeOut($los::object);
//					  $cloaked[$los::object] = 1;
                                schedule("GameBase::startFadeOut("@%turret@");", 6, $los::object);
                                schedule("Item::hide("@%turret@", true);", 6, $los::object);
                                %turret.cloaked = $los::object;
                                return true;
                        } else {
                                Client::sendMessage(%client,0,"Cannot cloak this object");
                        }
                } else {
                        Client::sendMessage(%client,0,"Deploy position out of range");
                }
        } else {                                                                                                                                                                			Client::sendMessage(%client,0,"Deployable item limit reached for " @ %item.description @ "s");
        }
        return false;
}

$InvList[CNode]        			   = 1;
$RemoteInvList[CNode]        		   = 1;
$TeamItemMax[CNode]        		   = 30;

$ItemMax[larmor, CNode]                = 0;
$ItemMax[lfemale, CNode]        	   = 0;
$ItemMax[marmor, CNode]                = 1;
$ItemMax[mfemale, CNode]        	   = 1;
$ItemMax[harmor, CNode]                = 0;

//----------------------------------------------------------------------------
// Pulse Sensor
//----------------------------------------------------------------------------

ItemImageData PulseSensorPackImage
{
	shapeFile = "radar_small";
	mountPoint = 2;
	mountOffset = { 0, 0, 0.1 };
	mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData PulseSensorPack
{
	description = "Pulse Sensor";
	shapeFile = "radar_small";
	className = "Backpack";
	heading = "lDeployables";
	imageType = PulseSensorPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 125;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function PulseSensorPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		Player::deployItem(%player,%item);
	}
}

function PulseSensorPack::onDeploy(%player,%item,%pos)
{
	if (Item::deployShape(%player,"Pulse Sensor",DeployablePulseSensor,%item)) 
	{
		Player::decItemCount(%player,%item);
		$TeamItemCount[GameBase::getTeam(%player) @ "PulseSensorPack"]++;
	}
}

//----------------------------------------------------------------------------
// Sensor Jammer
//----------------------------------------------------------------------------

ItemImageData DeployableSensorJamPackImage
{
	shapeFile = "sensor_jammer";
	mountPoint = 2;
	mountOffset = { 0, 0.03, 0.1 };
	mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData DeployableSensorJammerPack
{
	description = "Sensor Jammer";
	shapeFile = "sensor_jammer";
	className = "Backpack";
	heading = "lDeployables";
	imageType = DeployableSensorJamPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 225;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DeployableSensorJammerPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		Player::deployItem(%player,%item);
	}
}

function DeployableSensorJammerPack::onDeploy(%player,%item,%pos)
{
	if (Item::deployShape(%player,"Sensor Jammer",DeployableSensorJammer,%item)) 
	{
		Player::decItemCount(%player,%item);
		$TeamItemCount[GameBase::getTeam(%player) @ "DeployableSensorJammerPack"]++;
	}
}

//----------------------------------------------------------------------------
// Motion Sensor
//----------------------------------------------------------------------------

ItemImageData MotionSensorPackImage
{
	shapeFile = "sensor_small";
	mountPoint = 2;
	mountOffset = { 0, 0, 0.1 };
	mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData MotionSensorPack
{
	description = "Motion Sensor";
	shapeFile = "sensor_small";
	className = "Backpack";
	heading = "lDeployables";
	imageType = MotionSensorPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 125;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function MotionSensorPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		Player::deployItem(%player,%item);
	}
}

function MotionSensorPack::onDeploy(%player,%item,%pos)
{
	if (MotionSensorPack::deployShape(%player,%item)) 
	{
		Player::decItemCount(%player,%item);
	}
}

function MotionSensorPack::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,8)) {
                        %obj = getObjectType($los::object);
                        if (%obj == "SimTerrain" || %obj == "InteriorShape" || GameBase::getDataName($los::object) == "BlastFloorShape") {
                                %prot = GameBase::getRotation(%player);
                                %zRot = getWord(%prot,2);
                                if (Vector::dot($los::normal,"0 0 1") > 0.6) {
                                        %rot = "0 0 " @ %zRot;
                                }
                                else {
                                        if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
                                                %rot = "3.14159 0 " @ %zRot;
                                        }
                                        else {
                                                %rot = Vector::getRotation($los::normal);
                                        }
                                }
                                if(checkDeployArea(%client,$los::position)) {
                                        %mSensor = newObject("","Sensor",DeployableMotionSensor,true);
			                      addToSet("MissionCleanup", %mSensor);
                                        GameBase::setTeam(%mSensor,GameBase::getTeam(%player));
                                        GameBase::setRotation(%mSensor,%rot);
                                        GameBase::setPosition(%mSensor,$los::position);
                                        Gamebase::setMapName(%mSensor,"Motion Sensor");
                                        Client::sendMessage(%client,0,"Motion Sensor deployed");
                                        playSound(SoundPickupBackpack,$los::position);
				                $TeamItemCount[GameBase::getTeam(%player) @ "MotionSensorPack"]++;
                                        echo("MSG: ",%client," deployed a Motion Sensor");
                                        return true;
                                }
                        }
                        else 
				{
                                Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
                        }
                }
                else 
		    {
                        Client::sendMessage(%client,0,"Deploy position out of range");
                }
        }
        else
	  {
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	  }
        return false;
}

//----------------------------------------------------------------------------
// Camera
//----------------------------------------------------------------------------

ItemImageData CameraPackImage
{
	shapeFile = "camera";
	mountPoint = 2;
	mountOffset = { 0, -0.1, -0.06 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData CameraPack
{
	description = "Camera";
	shapeFile = "camera";
	className = "Backpack";
	heading = "lDeployables";
	imageType = CameraPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 100;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function CameraPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		Player::deployItem(%player,%item);
	}
}

function CameraPack::onDeploy(%player,%item,%pos)
{
	if (CameraPack::deployShape(%player,%item)) 
	{
		Player::decItemCount(%player,%item);
	}
}

function CameraPack::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,8)) {
                        %obj = getObjectType($los::object);
                        if (%obj == "SimTerrain" || %obj == "InteriorShape"|| GameBase::getDataName($los::object) == "BlastFloorShape")  {
                                %prot = GameBase::getRotation(%player);
                                %zRot = getWord(%prot,2);
                                if (Vector::dot($los::normal,"0 0 1") > 0.6) {
                                        %rot = "0 0 " @ %zRot;
                                }
                                else {
                                        if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
                                                %rot = "3.14159 0 " @ %zRot;

                                        }
                                        else {
                                                %rot = Vector::getRotation($los::normal);
                                        }
                                }
                                if(checkDeployArea(%client,$los::position)) 
					  {
                                        %camera = newObject("Camera","Turret",CameraTurret,true);
		                            addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
                                        GameBase::setRotation(%camera,%rot);
                                        GameBase::setPosition(%camera,$los::position);
                                        Gamebase::setMapName(%camera,"Camera#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
                                        Client::sendMessage(%client,0,"Camera deployed");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%camera) @ "CameraPack"]++;
                                        echo("MSG: ",%client," deployed a Camera");
                                        return true;
                                }
                        }
                        else 
				{
                                Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
                        }
                }
                else 
		    {
                        Client::sendMessage(%client,0,"Deploy position out of range");
                }
        }
        else
	  {
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	  }
        return false;
}

//----------------------------------------------------------------------------
// Inventory Station
//----------------------------------------------------------------------------

ItemImageData DeployableInvPackImage
{
	shapeFile = "invent_remote";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData DeployableInvPack
{
	description = "Inventory Station";
	shapeFile = "invent_remote";
	className = "Backpack";
	heading = "lDeployables";
	shadowDetailMask = 4;
	imageType = DeployableInvPackImage;
	mass = 1.0;
	elasticity = 0.2;
	price = 1500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function DeployableInvPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		Player::deployItem(%player,%item);
	}
}

function DeployableInvPack::onDeploy(%player,%item,%pos)
{
	if (DeployableInvPack::deployShape(%player,%item)) 
	{
		Player::decItemCount(%player,%item);
	}
}

function DeployableInvPack::deployShape(%player,%item)
{
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,8)) {
                        %obj = getObjectType($los::object);
                        if (%obj == "SimTerrain" || %obj == "InteriorShape"|| GameBase::getDataName($los::object) == "BlastFloorShape")  {
                                if (Vector::dot($los::normal,"0 0 1") > 0.7) 
					  {
                                        if(checkDeployArea(%client,$los::position)) 
						    {
                                                %inv = newObject("ammounit_remote","StaticShape","DeployableInvStation",true);
		                                    addToSet("MissionCleanup", %inv);
                                                %rot = GameBase::getRotation(%player);
                                                GameBase::setTeam(%inv,GameBase::getTeam(%player));
                                                GameBase::setPosition(%inv,$los::position);
                                                GameBase::setRotation(%inv,%rot);
                                                Gamebase::setMapName(%inv,%name);
                                                Client::sendMessage(%client,0,"Inventory Station deployed");
                                                playSound(SoundPickupBackpack,$los::position);
                                                $TeamItemCount[GameBase::getTeam(%inv) @ "DeployableInvPack"]++;
                                                echo("MSG: ",%client," deployed an Inventory Station");
                                                return true;
                                        }
                                }
                                else 
					  {
                                        Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
                                }

                       }
                       else 
			     {
                                Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
                       }
                }
                else 
		    {
                        Client::sendMessage(%client,0,"Deploy position out of range");
                }
        }
        else
	  {
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	  }
        return false;
}

//----------------------------------------------------------------------------
// Ammo Station
//----------------------------------------------------------------------------

ItemImageData DeployableAmmoPackImage
{
	shapeFile = "ammounit_remote";
	mountPoint = 2;
	mountOffset = { 0, -0.1, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData DeployableAmmoPack
{
	description = "Ammo Station";
	shapeFile = "ammounit_remote";
	className = "Backpack";
	heading = "lDeployables";
	shadowDetailMask = 4;
	imageType = DeployableAmmoPackImage;
	mass = 1.0;
	elasticity = 0.2;
	price = 1000000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DeployableAmmoPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		Player::deployItem(%player,%item);
	}
}

function DeployableAmmoPack::onDeploy(%player,%item,%pos)
{
	if (DeployableAmmoPack::deployShape(%player,%item)) 
	{
		Player::decItemCount(%player,%item);
	}
}

function DeployableAmmoPack::deployShape(%player,%item)
{
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	  {
                if (GameBase::getLOSInfo(%player,8)) 
		    {
                        %obj = getObjectType($los::object);
                        if (%obj == "SimTerrain" || %obj == "InteriorShape" || GameBase::getDataName($los::object) == "BlastFloorShape")  
				{
                                if (Vector::dot($los::normal,"0 0 1") > 0.7) 
					  {
                                        if(checkDeployArea(%client,$los::position)) 
						    {
                                                %inv = newObject("ammounit_remote","StaticShape","DeployableAmmoStation",true);
                            				addToSet("MissionCleanup", %inv);
                                                %rot = GameBase::getRotation(%player);
                                                GameBase::setTeam(%inv,GameBase::getTeam(%player));
                                                GameBase::setPosition(%inv,$los::position);
                                                GameBase::setRotation(%inv,%rot);
                                                Gamebase::setMapName(%inv,%name);
                                                Client::sendMessage(%client,0,"Ammo Station deployed");
                                                playSound(SoundPickupBackpack,$los::position);
                                                $TeamItemCount[GameBase::getTeam(%inv) @ "DeployableAmmoPack"]++;
                                                echo("MSG: ",%client," deployed an Ammo Station");
                                                return true;
                                        }
                                }
                                else
                                        Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
                        }
                        else
                                Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
                }
                else
                        Client::sendMessage(%client,0,"Deploy position out of range");
        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
        return false;
}

//----------------------------------------------------------------------------
// Drone
//----------------------------------------------------------------------------

ItemImageData DronePackImage
{
	shapeFile = "ammopack";
	weaponType = 2;
	mountPoint = 2;
	mountOffset = { 0, -0.1, 0 };	
	minEnergy = 4;
	maxEnergy = 4.5;
	firstPerson = false;
};

ItemData DronePack
{
	description = "Drone";
	shapeFile = "ammopack";
	className = "Backpack";
	heading = "lDeployables";
	shadowDetailMask = 4;
	imageType = DronePackImage;
	mass = 1;
	price = 2000000;
	hudIcon = "energypack";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DronePack::onUse(%player,%item)
{
	if(Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else 
	{
		Player::deployItem(%player,%item);
	}
}

function DronePack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

	if(DeployDrone(%player,%item,SurveyDrone,flier,SurveyDrone)) 
	{
		if(!Player::isDead(%player)) 
		{
			Player::decItemCount(%player,%item);
		}
	}
}

function DeployDrone(%player,%item,%shape,%data,%name)
{
	%client = Player::getClient(%player);
	if(GameBase::getLOSInfo(%player,8))
	{
		if(Vector::dot($los::normal,"0 0 1") > 0.7)
		{
			%rot = GameBase::getRotation(%player);
			%obj = newObject(%name,%data,%shape,true);
			if($TeamItemCount[GameBase::getTeam(%player) @ %name@"Pack"] >= $TeamItemMax[%item])
			{
				centerprint(%client,"<jc>Maximum number of "@%name@"s deployed.");
				deleteObject(%obj);
				return;
			}
			addToSet("MissionCleanup",%obj);
			GameBase::setTeam(%obj,GameBase::getTeam(%player));
			GameBase::setPosition(%obj,$los::position);
			GameBase::setRotation(%obj,%rot);
			Gamebase::setMapName(%obj,%name);
			Client::sendMessage(%client,0,%name@" Deployed ");
			GameBase::startFadeIn(%obj);
			playSound(SoundPickupBackpack,$los::position);
			Client::setControlObject(%client,%obj);
			%player.vehicle = %obj;
			$TeamItemCount[GameBase::getTeam(%inv) @ "DronePack"]++;
//			$TeamItemCount[GameBase::getTeam(%player) @ %name@"Pack"]++;
			return true;
		}
		else Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
	}
	else Client::sendMessage(%client,0,"Deploy position out of range");
	return false;
}

$TeamItemMax[DronePack] = 5;
$InvList[DronePack] = 1;
$RemoteInvList[DronePack] = 0;

$ItemMax[marmor, DronePack] = 1;
$ItemMax[mfemale, DronePack] = 1;
$ItemMax[larmor, DronePack] = 0;
$ItemMax[lfemale, DronePack] = 0;
$ItemMax[harmor, DronePack] = 0;

//----------------------------------------------------------------------------
// Defender Defense Turret
//----------------------------------------------------------------------------

$InvList[AODDefender]			= 1;
$RemoteInvList[AODDefender]		= 1;
$TeamItemMax[AODDefender]		= 4;

$ItemMax[larmor, AODDefender]		= 0;
$ItemMax[lfemale, AODDefender]	= 0;
$ItemMax[marmor, AODDefender]		= 1;
$ItemMax[mfemale, AODDefender]	= 1;
$ItemMax[harmor, AODDefender]		= 0;

ItemImageData AODDefenderImage
{
	shapeFile				= "CAMERA";
	mountPoint				= 2;
	mass					= 2.0;
	firstPerson				= false;
};

ItemData AODDefender
{
	description				= "Defender Designator";
	shapeFile				= "CAMERA";
	classname				= "Backpack";
	heading				= "pTurrets";
	imageType				= AODDefenderImage;
	shadowDetailMask			= 4;
	mass					= 3.0;
	elasticity				= 0.2;
	price					= 325;
	hudIcon				= "deployable";
	showWeaponBar			= true;
	hiliteOnActive			= true;
};

TurretData DefenderTurret
{
	classname				= "SensorNet";
	shapeFile				= "CAMERA";
	projectileType			= designatorX;
	maxDamage				= 0.75;
	maxEnergy				= 100;
	minGunEnergy			= 0.1;	
	maxGunEnergy			= 1;
	sequenceSound[0]			= {"deploy", SoundActivateMotionSensor};
	reloadDelay				= 0.3;
//	reloadDelay				= 1;
	speed					= 9.5;
	speedModifier			= 1.5;
	range					= 200;
	visibleToSensor			= true;
	shadowDetailMask			= 4;
	dopplerVelocity			= 0;
	castLOS				= true;
	supression				= false;
	mapFilter				= 2;
	mapIcon				= "M_turret";
	debrisId				= flashDebrisSmall;
	shieldShapeName			= "shield";
	fireSound				= SoundFireDefender;
	activationSound			= SoundRemoteTurretOn;
	deactivateSound			= SoundRemoteTurretOff;
	explosionId				= flashExpMedium;
	description				= "Defender Turret";
	damageSkinData			= "objectDamageSkins";
	pinger				= false;
	lightColor				= { 0.75, 0.75, 0.85 };
};


function AODDefender::onUse(%player,%item)
{
	%client = Player::getClient(%player);
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function AODDefender::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
//			%enemyflagpos = gamebase::getPosition(%enemyflag);
//			%myflagpos = gamebase::getPosition(%playerTeam);
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

	  if (AODDefender::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);
//			$TeamItemCount[GameBase::getTeam(%player) @ "AODDefender"]++;
	}
}

function AODDefender::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	DeployStuff(%player,%item,DefenderTurret,1,8,1,1,true,false,0);
}

function DefenderTurret::onAdd(%this)
{
	schedule("DefenderTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,10);
	%this.shieldStrength = 0.0025;
//	%this.shieldStrength = 0.025;
	if (GameBase::getMapName(%this) == "")
	{
		GameBase::setMapName (%this, "Defender Turret");
	}
}

function DefenderTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DefenderTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DefenderTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "AODDefender"]--;
}

function DefenderTurret::onPower(%this,%power,%generator)
{}

function DefenderTurret::onEnabled(%this)
{
	GameBase::setRechargeRate(%this,10);
	GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.01);
}

//----------------------------------------------------------------------------
// Laser Turret
//----------------------------------------------------------------------------

ItemImageData TurretPackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1;
        firstPerson = false;
};

ItemData TurretPack
{
        description = "Laser Turret";
        shapeFile = "remoteturret";
        className = "Backpack";
   heading = "pTurrets";
        imageType = TurretPackImage;
        shadowDetailMask = 4;
        mass = 1;
        elasticity = 0.2;
        price = 350;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function TurretPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function TurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
//	%playerTeam = $teamFlagLoc[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
//		%oteam = $teamFlagLoc[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (TurretPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "TurretPack"]++;
        }
}

function TurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,DeployableTurret,1,8,1,1,true,false,0);
}

//----------------------------------------------------------------------------
// Tractor Turret
//----------------------------------------------------------------------------

$InvList[TTurretPack]                        = 1;
$RemoteInvList[TTurretPack]                = 1;
$TeamItemMax[TTurretPack]                = 3;

$ItemMax[larmor, TTurretPack]        = 0;
$ItemMax[lfemale, TTurretPack]        = 0;
$ItemMax[marmor, TTurretPack]        = 1;
$ItemMax[mfemale, TTurretPack]        = 1;
$ItemMax[harmor, TTurretPack]        = 0;

ItemImageData TractorTurretI 
{ 
	shapeFile = "remoteturret"; 
	mountPoint = 2; 
	mountOffset = { 0, -0.12, -0.1 }; 
	mountRotation = { 0, 0, 0 }; 
	mass = 2.5; 
	firstPerson = false; 
}; 

ItemData TTurretPack 
{ 
	description = "Tractor Turret"; 
	shapeFile = "remoteturret"; 
	className = "Backpack"; 
	heading = "pTurrets"; 
	imageType = TractorTurretI; 
	shadowDetailMask = 4; 
	mass = 2.0; 
	elasticity = 0.2; 
	price = 400; 
	hudIcon = "deployable"; 
	showWeaponBar = true; 
	hiliteOnActive = true; 
};

function TTurretPack::onUse(%player,%item) 
{ 
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{ 
		Player::mountItem(%player,%item,$BackpackSlot); 
	} 
	else 
	{ 
		Player::deployItem(%player,%item); 
	} 
} 

function TTurretPack::onDeploy(%player,%item,%pos) 
{ 
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

	if (DeployTheShape(%player, %item, "DeployableTTurret", "", 8, false, $TurretBoxMaxLength, $TurretBoxMaxWidth, $TurretBoxMaxHeight, $TurretBoxMinLength, $TurretBoxMinWidth, $TurretBoxMinHeight, "", "Tractor")) 
	{
		Player::decItemCount(%player,%item); 
//		$TeamItemCount[GameBase::getTeam(%player) @ "TTurretPack"]++;
	} 
} 

ExplosionData turret1Exp
{
   shapeName = "breath.dts";
   soundId   = SoundFireFlierRocket;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 4.5;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 0.0,  1.0,  0.0 };
   radFactors = { 1.0, 1.0, 1.0 };
};

RocketData IonEEBolt { bulletShapeName = "breath.dts"; explosionTag = turret1Exp; collisionRadius = 0.0; mass = 2.0; damageClass = 1; damageValue = 0.07; damageType = $TractorDamageType; explosionRadius = 4; kickBackStrength = -300.0; muzzleVelocity = 200.0; terminalVelocity = 200.0; acceleration = 5.0; totalTime = 10.0; liveTime = 11.0; lightRange = 5.0; lightColor = { 0.2, 1.0, 0.2 }; inheritedVelocityScale = 0.5; trailType = 1; trailLength = 130; trailWidth = 0.5; soundId = SoundJetHeavy; }; 

TurretData DeployableTTurret { className = "Turret"; shapeFile = "remoteturret"; projectileType = IonEEBolt; maxDamage = 5.5; maxEnergy = 75; minGunEnergy = 6; maxGunEnergy = 5; sequenceSound[0] = { "deploy", SoundActivateMotionSensor }; reloadDelay = 0.9; speed = 2.5; speedModifier = 1.5; range = 145; gunrange = 65; visibleToSensor = true; shadowDetailMask = 4; dopplerVelocity = 0; castLOS = true; supression = false; mapFilter = 2; mapIcon = "M_turret"; debrisId = flashDebrisMedium; shieldShapeName = "shield"; activationSound = SoundRemoteTurretOn; deactivateSound = SoundRemoteTurretOff; explosionId = flashExpMedium; description = "Tractor Turret"; damageSkinData = "objectDamageSkins"; }; function DeployableTTurret::onAdd(%this) { schedule("DeployableTTurret::deploy(" @ %this @ ");",1,%this); GameBase::setRechargeRate(%this,5); %this.shieldStrength = 0.001; if (GameBase::getMapName(%this) == "") { GameBase::setMapName (%this, "Tractor Turret"); } } 

function DeployableTTurret::deploy(%this) { GameBase::playSequence(%this,1,"deploy"); } function DeployableTTurret::onEndSequence(%this,%thread) { GameBase::setActive(%this,true); } function DeployableTTurret::onDestroyed(%this) { Turret::onDestroyed(%this); $TeamItemCount[GameBase::getTeam(%this) @ "TTurretPack"]--; } function DeployableTTurret::onPower(%this,%power,%generator) {} function DeployableTTurret::onEnabled(%this) { GameBase::setRechargeRate(%this,5); GameBase::setActive(%this,true); } 

//----------------------------------------------------------------------------
// ELF Turret
//----------------------------------------------------------------------------

$InvList[LELFPack]                        = 1;
$RemoteInvList[LELFPack]                = 0;
$TeamItemMax[LELFPack]                = 3;

$ItemMax[larmor, LELFPack]        = 0;
$ItemMax[lfemale, LELFPack]        = 0;
$ItemMax[marmor, LELFPack]        = 1;
$ItemMax[mfemale, LELFPack]        = 1;
$ItemMax[harmor, LELFPack]        = 0;

ItemImageData LELFPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 2.5;
	firstPerson = false;
};

ItemData LELFPack
{
	description = "ELF Turret";
	shapeFile = "chainturret";
	className = "Backpack";
   heading = "pTurrets";
	imageType = LELFPackImage;
	shadowDetailMask = 4;
	mass = 2.0;
	elasticity = 0.2;
	price = 550;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function LELFPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	} else {
		Player::deployItem(%player,%item);
	}
}

function LELFPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (LELFPack::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "LELFPack"]++;
	}
}

function LELFPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete,PackName,PowerReq,PRange)
        DeployStuff(%player,%item,LELFTurret,1,8,1,1,true,false,0);
}

TurretData LELFTurret { maxDamage = 5.85; maxEnergy = 150; minGunEnergy = 50; maxGunEnergy = 5; range = 70; visibleToSensor = true; dopplerVelocity = 0; castLOS = true; supression = false; mapFilter = 2; mapIcon = "M_turret"; debrisId = defaultDebrisMedium; className = "Turret"; shapeFile = "chainturret"; shieldShapeName = "shield"; speed = 10.0; speedModifier = 1.5; projectileType = turretCharge; reloadDelay = 0.3; explosionId = LargeShockwave; description = "ELF Turret"; fireSound = SoundGeneratorPower; activationSound = SoundChainTurretOn; deactivateSound = SoundChainTurretOff; damageSkinData = "objectDamageSkins"; shadowDetailMask = 8; isSustained = true; firingTimeMS = 750; energyRate = 30.0; }; 

function LELFTurret::onAdd(%this)
{

	schedule("LELFTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,15);
//	GameBase::setAutoRepairRate(%this, 0.01);
	%this.shieldStrength = 0.00315;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "ELF Turret");
	}
}

function LELFTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function LELFTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function LELFTurret::onDestroyed(%this)
{
	%this.shieldStrength = 0;
	GameBase::stopSequence(%this,0);
	GameBase::setRechargeRate(%this,0);
	GameBase::setEnergy(%this, 0);
	GameBase::setActive(%this,false);
	StaticShape::objectiveDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "LELFPack"]--;
}

function LELFTurret::onPower(%this,%power,%generator) {}
function LELFTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,15);
	GameBase::setActive(%this,true);
}	

//----------------------------------------------------------------------------
// Chaingun Turret
//----------------------------------------------------------------------------

$InvList[AODGrogPack]                        = 1;
$RemoteInvList[AODGrogPack]                = 1;
$TeamItemMax[AODGrogPack]                = 10;

$ItemMax[larmor, AODGrogPack]        = 0;
$ItemMax[lfemale, AODGrogPack]        = 0;
$ItemMax[marmor, AODGrogPack]        = 1;
$ItemMax[mfemale, AODGrogPack]        = 1;
$ItemMax[harmor, AODGrogPack]        = 0;

BulletData GrogShot
{        bulletShapeName = "bullet.DTS";
        explosionTag = bulletExp0;
        expRandCycle        = 3;
        mass = 1;
        collisionRadius = 0.0;
        bulletHoleIndex = 0;
        ExplosionRadius = 0;
        damageClass = 0;
        damageValue = 0.12;
        damageType = $BulletDamageType;
//        damageType = $ChaingunDamageType;
        aimDeflection = 0.005;
        muzzleVelocity = 500.0;
        totalTime = 0.5;

        inheritedVelocityScale = 0.5;
        liveTime = 2.0;
        isVisible = False;
        tracerPercentage = 0.0;
        tracerLength = 0;
        detachFromShooter = false;
        rotationPeriod = 0;
        lightRange = 0.0;
        lightColor = {1.0, 0.25,0.25};
};

ItemImageData AODGrogPackImage
{        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1;
        firstPerson = false;
};

ItemData AODGrogPack
{        description                = "Chaingun Turret";
        shapeFile                = "remoteturret";
        classname                = "Backpack";
        heading                        = "pTurrets";
        imageType                = AODGrogPackImage;
        shadowDetailMask = 4;
        mass                        = 3.0;
        elasticity                = 0.2;
        price                        = 650;
        hudIcon                        = "deployable";
        showWeaponBar        = true;

       hiliteOnActive        = true;
};

TurretData GROGTurret
{         classname                = "Turret";
        shapeFile                = "remoteturret";
        projectileType        = GrogShot;
        maxDamage                = 1.15;
        maxEnergy                = 1500;
        minGunEnergy        = 5;
        maxGunEnergy        = 5;
        sequenceSound[0]= {"deploy", SoundActivateMotionSensor};
        reloadDelay                = 0.15;
        speed                        = 9.0;
        speedModifier        = 5.5;
        range                        = 140;
        visibleToSensor = true;
        shadowDetailMask= 4;
        dopplerVelocity = 0;
        castLOS                        = true;
        supression                = false;
        mapFilter                = 2;
        mapIcon                        = "M_turret";
        debrisId                = flashDebrisMedium;
        shieldShapeName = "shield";
        fireSound                = SoundGrogFire;
        activationSound = SoundRemoteTurretOn;
        deactivateSound = SoundRemoteTurretOff;
        explosionId                = flashExpMedium;
        description                = "Chaingun Turret";
        damageSkinData        = "objectDamageSkins";
        pinger                        = false;
};

function AODGrogPack::onUse(%player,%item)
{        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {        Player::mountItem(%player,%item,$BackpackSlot);        }
        else
        {        Player::deployItem(%player,%item); }
}

function AODGrogPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (AODGrogPack::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "AODGrogPack"]++;
	}
}

function AODGrogPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,GrogTurret,5,8,1,1,true,false,0);
//        DeployStuff(%player,%item,GrogTurret,1,8,1,1,true,false,0);
}


function GROGTurret::onAdd(%this)
{        schedule("GROGTurret::deploy(" @ %this @ ");",1,%this);
}

function GROGTurret::deploy(%this)
{        GameBase::playSequence(%this,1,"deploy");
}

function GROGTurret::onEndSequence(%this,%thread)
{        GameBase::setActive(%this,true);
}

function GROGTurret::onDestroyed(%this)
{        Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "AODGrogPack"]--;
}

function GROGTurret::onPower(%this,%power,%generator)
{
}

function GROGTurret::onEnabled(%this)
{        GameBase::setRechargeRate(%this,35);
        GameBase::setActive(%this,true);
        %this.shieldStrength = 0.0035;
//	GameBase::setAutoRepairRate(%this, 0.01);
}

//----------------------------------------------------------------------------
// Velcro Turret
//----------------------------------------------------------------------------

$InvList[AODVelcroPack]                        = 1;
$RemoteInvList[AODVelcroPack]                = 1;
$TeamItemMax[AODVelcroPack]                = 8;

$ItemMax[larmor, AODVelcroPack]        = 0;
$ItemMax[lfemale, AODVelcroPack]        = 0;
$ItemMax[marmor, AODVelcroPack]        = 1;
$ItemMax[mfemale, AODVelcroPack]        = 1;
$ItemMax[harmor, AODVelcroPack]        = 0;

ExplosionData velcroExp
{
   shapeName = "enex.dts";
   soundId   = energyExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 3.0;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.75, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.75, 1.0 };
   colors[2]  = { 0.5, 1.0,  0.5 };
   radFactors = { 1.0, 1.0,  1.0 };

   shiftPosition = True;
};

BulletData VelcroProjectile
{
   bulletShapeName  = "mortartrail.dts";
   explosionTag     = velcroExp;
   mass             = 0.05;
   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.25;
   damageType       = $AcidBathDamageType;
	explosionRadius    = 2;
   muzzleVelocity   = 60.0;
   totalTime        = 4.0;
   liveTime         = 4.0;
   isVisible        = True;
   rotationPeriod        = 0.15;
};


ItemImageData AODVelcroPackImage
{        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1.0;
        firstPerson = false;
};

ItemData AODVelcroPack
{        description = "Velcro Turret";
        shapeFile = "remoteturret";
        classname = "Backpack";
        heading = "pTurrets";
        imageType = AODVelcroPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 750;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

TurretData VELCROTurret
{
         classname                = "Turret";
        shapeFile                = "remoteturret";

//        projectileType        = VELCROMissile;
        projectileType        = VelcroProjectile;
        maxDamage                = 5.70;
//        maxDamage                = 0.70;
        maxEnergy                = 600;
        minGunEnergy        = 7.5;
        maxGunEnergy        = 15;
        sequenceSound[0] = {"deploy", SoundActivateMotionSensor};
        reloadDelay                = 0.15;
//        reloadDelay                = 0.75;
        speed                        = 9.0;
        speedModifier        = 5.5;
        range                        = 75;
        visibleToSensor = true;
        shadowDetailMask = 4;
        dopplerVelocity = 0;
        castLOS                        = true;
        supression                = false;
        mapFilter                = 2;
        mapIcon                        = "M_turret";
        debrisId                = flashDebrisMedium;
        shieldShapeName = "shield";
        fireSound                = SoundRemoteTurretFire;
        activationSound = SoundRemoteTurretOn;
        deactivateSound = SoundRemoteTurretOff;
        explosionId                = flashExpMedium;
        description                = "Velcro Turret";
        damageSkinData        = "objectDamageSkins";
        pinger                        = false;
};


function AODVelcroPack::onUse(%player,%item)
{
 if (Player::getMountedItem(%player,$BackpackSlot) != %item)
{
Player::mountItem(%player,%item,$BackpackSlot);
}
else
{
Player::deployItem(%player,%item);
 }
}

function AODVelcroPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (AODVelcroPack::deployShape(%player,%item))
                Player::decItemCount(%player,%item);
 //       $TeamItemCount[GameBase::getTeam(%player) @ "AODVelcroPack"]++;
}

function AODVelcroPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PackName,PowerReq,PRange)
        DeployStuff(%player,%item,VELCROTurret,1,8,1,1,true,false,0);
}


function VELCROTurret::onAdd(%this)
{        schedule("VELCROTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,10);
        %this.shieldStrength = 0.0010;
        if (GameBase::getMapName(%this) == "")
                GameBase::setMapName (%this, "Velcro Turret");
}

function VELCROTurret::deploy(%this)
{        GameBase::playSequence(%this,1,"deploy");
}

function VELCROTurret::onEndSequence(%this,%thread)
{        GameBase::setActive(%this,true);
}

function VELCROTurret::onDestroyed(%this)
{        Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "AODVelcroPack"]--;
}

function VELCROTurret::onPower(%this,%power,%generator)
{
}

function VELCROTurret::onEnabled(%this)
{        GameBase::setRechargeRate(%this,10);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.01);
}

//----------------------------------------------------------------------------
// Flux Turret
//----------------------------------------------------------------------------

ItemImageData FluxPackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1;
        firstPerson = false;
};

ItemData FluxPack
{
        description = "EMP Blast Turret";
        shapeFile = "remoteturret";
        className = "Backpack";
   heading = "pTurrets";
        imageType = FluxPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 1000;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function FluxPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function FluxPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (FluxPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
//          $TeamItemCount[GameBase::getTeam(%player) @ "FluxPack"]++;
        }
}

function FluxPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,FluxTurret,1,8,1,1,true,false,0);
}

TurretData Fluxturret
{
        maxDamage = 5.75;
        maxEnergy = 60;
        minGunEnergy = 15;
        maxGunEnergy = 15;
        range = 100;
        gunRange = 150;
        visibleToSensor = true;
        dopplerVelocity = 0;
        castLOS = true;
        supression = false;
        mapFilter = 2;
        mapIcon = "M_turret";
        debrisId = defaultDebrisLarge;
        className = "Turret";
        shapeFile = "remoteturret";
        shieldShapeName = "shield_medium";
        speed = 10.0;
        speedModifier = 5.0;
        projectileType = SeekingRPEMP;
        reloadDelay = 5;
        fireSound = SoundMissileTurretFire;
        activationSound = SoundMissileTurretOn;
        deactivateSound = SoundMissileTurretOff;
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 8;
	  targetableFovRatio = 0.5;
        explosionId = LargeShockwave;
        description = "EMP Blast Turret";
};

function FluxTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

function Fluxturret::onAdd(%this)
{
        schedule("Fluxturret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,5);
        %this.shieldStrength = 0.001;
        if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "EMP Blast Turret");
        }
}

function Fluxturret::deploy(%this)
{
        GameBase::playSequence(%this,1,"deploy");
}

function Fluxturret::onEndSequence(%this,%thread)
{
        GameBase::setActive(%this,true);
}

function Fluxturret::onDestroyed(%this)
{
        Turret::onDestroyed(%this);
          $TeamItemCount[GameBase::getTeam(%this) @ "FluxPack"]--;
}

// Override base class just in case.
function Fluxturret::onPower(%this,%power,%generator) {}
function Fluxturret::onEnabled(%this)
{
        GameBase::setRechargeRate(%this,15);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.01);
}

$InvList[FluxPack] = 1;
$RemoteInvList[FluxPack] = 1;

$TeamItemMax[FluxPack] = 5;
$ItemMax[marmor, FluxPack] = 1;
$ItemMax[mfemale, FluxPack] = 1;
$ItemMax[larmor, FluxPack] = 0;
$ItemMax[lfemale, FluxPack] = 0;
$ItemMax[harmor, FluxPack] = 0;

//----------------------------------------------------------------------------
// Fusion Turret
//----------------------------------------------------------------------------

ItemImageData Turret4PackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1.5;
        firstPerson = false;
};

ItemData Turret4Pack
{
        description = "Fusion Turret";
        shapeFile = "remoteturret";
        className = "Backpack";
   heading = "pTurrets";
        imageType = Turret4PackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 3500;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function Turret4Pack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }

       else {
                Player::deployItem(%player,%item);
        }

}

function Turret4Pack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (Turret4Pack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
//          $TeamItemCount[GameBase::getTeam(%player) @ "Turret4Pack"]++;
        }
}

function Turret4Pack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,FusionTurret,1,8,1,1,true,false,0);
}

TurretData FusionTurret
{
        maxDamage = 5.0;
//        maxDamage = 1.0;
        maxEnergy = 100;
        minGunEnergy = 75;
        maxGunEnergy = 15;
        reloadDelay = 0.45;
//        reloadDelay = 0.5;
        fireSound = SoundPlasmaTurretFire;
        activationSound = SoundPlasmaTurretOn;
        deactivateSound = SoundPlasmaTurretOff;
        whirSound = SoundPlasmaTurretTurn;
        range = 250;
        dopplerVelocity = 0;
        castLOS = true;
        supression = false;
        mapFilter = 2;
        mapIcon = "M_turret";
        visibleToSensor = true;
        debrisId = defaultDebrisMedium;
        className = "Turret";
        shapeFile = "hellfiregun";
        shieldShapeName = "shield_medium";
        speed = 9.0;
        speedModifier = 4.0;
        projectileType = ChargedFusionBolt;
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 8;
        explosionId = LargeShockwave;
        description = "Fusion Turret";
};

function FusionTurret::onAdd(%this)
{
        schedule("FusionTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,25);
        %this.shieldStrength = 0.004;
        if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "Fusion Turret");
        }
}

function FusionTurret::deploy(%this)
{
        GameBase::playSequence(%this,1,"deploy");
}

function FusionTurret::onEndSequence(%this,%thread)
{
        GameBase::setActive(%this,true);
}

function FusionTurret::onDestroyed(%this)
{
        Turret::onDestroyed(%this);
          $TeamItemCount[GameBase::getTeam(%this) @ "Turret4Pack"]--;
}

// Override base class just in case.
function FusionTurret::onPower(%this,%power,%generator) {}
function FusionTurret::onEnabled(%this)
{
        GameBase::setRechargeRate(%this,25);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.01);
}

$InvList[Turret4Pack] = 1;
$RemoteInvList[Turret4Pack] = 0;

$TeamItemMax[Turret4Pack] = 3;
$ItemMax[marmor, Turret4Pack] = 1;
$ItemMax[mfemale, Turret4Pack] = 1;
$ItemMax[larmor, Turret4Pack] = 0;
$ItemMax[lfemale, Turret4Pack] = 0;
$ItemMax[harmor, Turret4Pack] = 0;

//----------------------------------------------------------------------------
// Mitzi Blast Turret
//----------------------------------------------------------------------------

ItemImageData IonTurretPackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1;
        firstPerson = false;
};

ItemData IonTurretPack
{
        description = "Mitzi Blast Turret";
        shapeFile = "remoteturret";
        className = "Backpack";
   heading = "pTurrets";
        imageType = IonTurretPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 3000;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function IonTurretPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function IonTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (IonTurretPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
//          $TeamItemCount[GameBase::getTeam(%player) @ "IonTurretPack"]++;
        }
}

function IonTurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,IonTurret,1,8,1,1,true,false,0);
}

TurretData IonTurret
{
        maxDamage = 5.0;
        maxEnergy = 300;
        minGunEnergy = 25;
        maxGunEnergy = 25;
        reloadDelay = 4;
        fireSound = capturedTower;
        activationSound = SoundMortarTurretOn;
        deactivateSound = SoundMortarTurretOff;
        whirSound = SoundMortarTurretTurn;
        range = 250;
        dopplerVelocity = 0;
        castLOS = true;
        supression = false;
        mapFilter = 2;
        mapIcon = "M_turret";
        visibleToSensor = true;
        debrisId = defaultDebrisMedium;
        className = "Turret";
        shapeFile = "remoteturret";
//        shapeFile = "mortar_turret";
        shieldShapeName = "shield_medium";
        speed = 2.0;
//        speed = 12.0;
        speedModifier = 4.0;
        projectileType = IonShock8;
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 8;
        explosionId = LargeShockwave;
        description = "Mitzi Blast Turret";
};

function IonTurret::onAdd(%this)
{
        schedule("IonTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,35);
        %this.shieldStrength = 0.004;
        if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "Mitzi Blast Turret");
        }
}

function IonTurret::deploy(%this)
{
        GameBase::playSequence(%this,1,"deploy");
}

function IonTurret::onEndSequence(%this,%thread)
{
        GameBase::setActive(%this,true);
}

function IonTurret::onDestroyed(%this)
{
        Turret::onDestroyed(%this);
          $TeamItemCount[GameBase::getTeam(%this) @ "IonTurretPack"]--;
}

// Override base class just in case.
function IonTurret::onPower(%this,%power,%generator) {}
function IonTurret::onEnabled(%this)
{
        GameBase::setRechargeRate(%this,35);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.15);
}

$InvList[IonTurretPack] = 1;
$RemoteInvList[IonTurretPack] = 0;

$TeamItemMax[IonTurretPack] = 3;

$ItemMax[marmor, IonTurretPack] = 1;
$ItemMax[mfemale, IonTurretPack] = 1;
$ItemMax[larmor, IonTurretPack] = 0;
$ItemMax[lfemale, IonTurretPack] = 0;
$ItemMax[harmor, IonTurretPack] = 0;

//----------------------------------------------------------------------------
// Pulse Turret
//----------------------------------------------------------------------------

ItemImageData PulseTurretPackImage
{

       shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 0.5;
        firstPerson = false;
};

ItemData PulseTurretPack
{
        description = "AA Battery";
        shapeFile = "remoteturret";
        className = "Backpack";
   heading = "pTurrets";
        imageType = PulseTurretPackImage;
        shadowDetailMask = 4;
        mass = 0.5;
        elasticity = 0.2;
        price = 950;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function PulseTurretPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function PulseTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (PulseTurretPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
 //         $TeamItemCount[GameBase::getTeam(%player) @ "PulseTurretPack"]++;
        }
}

function PulseTurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,PulseTurret,1,8,1,1,true,false,0);
}

TurretData PulseTurret
{
        maxDamage = 8.0;
//        maxDamage = 1.0;
        maxEnergy = 250;
        minGunEnergy = 15;
        maxGunEnergy = 5;
        reloadDelay = 0.05;
//        reloadDelay = 0.025;
        fireSound = SoundFireSeeking;
        activationSound = SoundPlasmaTurretOn;
        deactivateSound = SoundPlasmaTurretOff;
        whirSound = SoundPlasmaTurretTurn;
        range = 400;
        dopplerVelocity = 0;
        castLOS = true;
        supression = false;
        mapFilter = 2;
        mapIcon = "M_turret";
        visibleToSensor = true;
        debrisId = defaultDebrisMedium;
        className = "Turret";
        shapeFile = "hellfiregun";
        shieldShapeName = "shield_medium";
        speed = 12.0;
        speedModifier = 6.0;
        projectileType = AFBolt;
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 8;
        explosionId = LargeShockwave;
        description = "AF Turret";
};

function PulseTurret::onAdd(%this)
{
        schedule("PulseTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,15);
        %this.shieldStrength = 0.005;
//	  GameBase::setAutoRepairRate(%this, 0.005);
        if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "AF Turret");
        }
}

function PulseTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

function PulseTurret::deploy(%this)
{
        GameBase::playSequence(%this,1,"deploy");
}

function PulseTurret::onEndSequence(%this,%thread)
{
        GameBase::setActive(%this,true);
}

function PulseTurret::onDestroyed(%this)
{
        Turret::onDestroyed(%this);
          $TeamItemCount[GameBase::getTeam(%this) @ "PulseTurretPack"]--;
}

// Override base class just in case.
function PulseTurret::onPower(%this,%power,%generator) {}
function PulseTurret::onEnabled(%this)
{
        GameBase::setRechargeRate(%this,15);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.005);
}

$InvList[PulseTurretPack] = 1;
$RemoteInvList[PulseTurretPack] = 0;

$TeamItemMax[PulseTurretPack] = 3;

$ItemMax[marmor, PulseTurretPack] = 1;
$ItemMax[mfemale, PulseTurretPack] = 1;
$ItemMax[larmor, PulseTurretPack] = 0;
$ItemMax[lfemale, PulseTurretPack] = 0;
$ItemMax[harmor, PulseTurretPack] = 0;

//----------------------------------------------------------------------------
// Flame Turret
//----------------------------------------------------------------------------

ItemImageData DiscPackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 0.5;
        firstPerson = false;
};

ItemData DiscTurretPack
{
       description = "Flamer Turret";
//       description = "Disc Turret";
        shapeFile = "remoteturret";
        className = "Backpack";
   heading = "pTurrets";
        imageType = DiscPackImage;
        shadowDetailMask = 4;
       mass = 0.5;
        elasticity = 0.2;
        price = 700;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function DiscTurretPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function DiscTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (DiscTurretPack::deployShape(%player,%item)) {
               Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "DiscTurretPack"]++;
        }
}

function DiscTurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,DiscTurret,1,8,1,1,true,false,0);
}

TurretData DiscTurret
{
        maxDamage = 4.0;
        maxEnergy = 200;
        minGunEnergy = 0;
        maxGunEnergy = 0;
        reloadDelay = 0;
//        minGunEnergy = 45;
//        maxGunEnergy = 5;
//        reloadDelay = 1;
//        fireSound = SoundFireDisc;
	sfxActivate = SoundPickUpWeapon;
	sfxFire = SoundFireFlamer;
        activationSound = SoundPlasmaTurretOn;
        deactivateSound = SoundPlasmaTurretOff;
        whirSound = SoundPlasmaTurretTurn;
        range = 150;
        dopplerVelocity = 2;
        castLOS = true;
        supression = false;
	supressable = false;
	pinger = false;
        mapFilter = 2;
        mapIcon = "M_turret";
        visibleToSensor = true;
        debrisId = defaultDebrisMedium;
        className = "Turret";
        shapeFile = "chainturret";
        shieldShapeName = "shield_medium";
        speed = 10.0;
        speedModifier = 5.0;
        projectileType = flamesz;
//        projectileType = TurretDiscShell;
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 8;
        explosionId = LargeShockwave;
        description = "Flamer Turret";
};

function DiscTurret::onAdd(%this)
{
        schedule("DiscTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,18);
        %this.shieldStrength = 0.03;
//        %this.shieldStrength = 0.006;
//		GameBase::setAutoRepairRate(%this, 0.05);
        if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "Disc Turret");
        }
}

function DiscTurret::deploy(%this)
{
        GameBase::playSequence(%this,1,"deploy");
}

function DiscTurret::onEndSequence(%this,%thread)
{
        GameBase::setActive(%this,true);
}

function DiscTurret::onDestroyed(%this)
{
        Turret::onDestroyed(%this);
          $TeamItemCount[GameBase::getTeam(%this) @ "DiscTurretPack"]--;
}

// Override base class just in case.
function DiscTurret::onPower(%this,%power,%generator) {}
function DiscTurret::onEnabled(%this)
{
        GameBase::setRechargeRate(%this,18);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.05);
}

$InvList[DiscTurretPack] = 1;
$RemoteInvList[DiscTurretPack] = 0;

$TeamItemMax[DiscTurretPack] = 3;

$ItemMax[marmor, DiscTurretPack] = 1;
$ItemMax[mfemale, DiscTurretPack] = 1;
$ItemMax[larmor, DiscTurretPack] = 0;
$ItemMax[lfemale, DiscTurretPack] = 0;
$ItemMax[harmor, DiscTurretPack] = 0;

//----------------------------------------------------------------------------
//  Rocket Turret
//----------------------------------------------------------------------------

ItemImageData RocketPackImage
{
        shapeFile = "missileturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 3.0;
        firstPerson = false;
};

ItemData RocketPack
{
        description = "Rocket Turret";
        shapeFile = "remoteturret";
        className = "Backpack";
   heading = "pTurrets";
        imageType = RocketPackImage;
        shadowDetailMask = 4;
        mass = 3.0;
        elasticity = 0.2;
        price = 1200;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function RocketPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function RocketPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (RocketPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
//          $TeamItemCount[GameBase::getTeam(%player) @ "DeployableRocket"]++;
        }
}

function RocketPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,DeployableRocket,1,8,1,1,true,false,0);
}

$InvList[RocketPack] = 1;
$RemoteInvList[RocketPack] = 0;

$TeamItemMax[RocketPack] = 3;

$ItemMax[marmor, RocketPack] = 1;
$ItemMax[mfemale, RocketPack] = 1;
$ItemMax[larmor, RocketPack] = 0;
$ItemMax[lfemale, RocketPack] = 0;
$ItemMax[harmor, RocketPack] = 0;
$ItemMax[MagIonM, RocketPack] = 0;
$ItemMax[MAgIonF, RocketPack] = 0;
$ItemMax[BlastechM, RocketPack] = 0;
$ItemMax[BlastechF, RocketPack] = 0;
$ItemMax[MECH, RocketPack] = 0;

TurretData DeployableRocket
{
        maxDamage = 2.0;
        maxEnergy = 100;
        minGunEnergy = 60;
        maxGunEnergy = 60;
        range = 250;
        gunRange = 300;
        visibleToSensor = true;
        dopplerVelocity = 0;
        castLOS = true;
        supression = false;
        mapFilter = 2;
        mapIcon = "M_turret";
        debrisId = defaultDebrisLarge;
        className = "Turret";
        shapeFile = "missileturret";
        shieldShapeName = "shield_medium";
        speed = 10.0;
        speedModifier = 5.0;
        projectileType = TurretMissile;
        fireSound = SoundMissileTurretFire;
        activationSound = SoundMissileTurretOn;
        deactivateSound = SoundMissileTurretOff;
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 8;
	  targetableFovRatio = 0.5;
        explosionId = LargeShockwave;
        description = "Rocket Turret";
};

function DeployableRocket::onAdd(%this)
{
        schedule("DeployableTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,14);
        %this.shieldStrength = 0.03;
//	GameBase::setAutoRepairRate(%this, 0.01);
       if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "Rocket Turret");
        }
}

function DeployableRocket::deploy(%this)
{
        GameBase::playSequence(%this,1,"deploy");
}

function DeployableRocket::onEndSequence(%this,%thread)
{
        GameBase::setActive(%this,true);
}

function DeployableRocket::onDestroyed(%this)
{
        Turret::onDestroyed(%this);
          $TeamItemCount[GameBase::getTeam(%this) @ "DeployableRocket"]--;
}

// Override base class just in case.
function DeployableRocket::onPower(%this,%power,%generator) {}
function DeployableRocket::onEnabled(%this)
{
        GameBase::setRechargeRate(%this,14);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.01);
}

function DeployableRocket::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

//----------------------------------------------------------------------------
//  Super Hyper Blaster Turret
//----------------------------------------------------------------------------

$InvList[AODArtilleryPack] = 1;
$RemoteInvList[AODArtilleryPack] = 0;
$TeamItemMax[AODArtilleryPack] = 3;

$ItemMax[larmor, AODArtilleryPack] = 0;
$ItemMax[lfemale, AODArtilleryPack] = 0;
$ItemMax[marmor, AODArtilleryPack] = 1;
$ItemMax[mfemale, AODArtilleryPack] = 1;
$ItemMax[harmor, AODArtilleryPack] = 0;

ItemImageData AODArtilleryPackImage
{        shapeFile                = "magcargo";
        mountPoint                = 2;
        mountOffset                = { 0, -0.65, -0.4 };
        mountRotation        = { 0, 0, 0 };
        mass                                = 3.0;
        firstPerson                = false;
};

ItemData AODArtilleryPack
{        description                = "SHB Turret";
        shapeFile                = "Mortar_Turret";
        classname                = "Backpack";
        heading                        = "pTurrets";
        imageType                = AODArtilleryPackImage;
        shadowDetailMask = 4;
        mass                        = 3.0;
        elasticity                = 0.2;
        price                        = 9500;
        hudIcon                        = "deployable";
        showWeaponBar        = true;
        hiliteOnActive = true;
};


TurretData ArtilleryTurret
{        classname                = "Turret";
        shapeFile                = "Mortar_Turret";
        projectileType        = SuperBlaster2;
//        projectileType        = SuperBlaster;
        maxDamage                = 10.0;
        maxEnergy                = 100;
        minGunEnergy        = 15;
        maxGunEnergy        = 10;
        sequenceSound[0]= {"deploy", SoundActivateMotionSensor};
        reloadDelay                = 0.05;
        speed                        = 12.0;
        speedModifier        = 4.5;
        range                        = 150;
        visibleToSensor = true;
        shadowDetailMask= 4;
        dopplerVelocity = 0;
        castLOS                        = true;
        supression                = false;
        mapFilter                = 2;
        mapIcon                        = "M_turret";
        debrisId                = FlierDebris;
        shieldShapeName = "shield";
        fireSound                = SoundPlasmaTurretFire;
        activationSound = SoundRemoteTurretOn;
        deactivateSound = SoundRemoteTurretOff;
        explosionId                = LargeShockwave;
        description                = "Super Hyper Blaster Turret";
        damageSkinData        = "objectDamageSkins";
        pinger                        = false;
};


function AODArtilleryPack::onUse(%player,%item)
{        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {        Player::mountItem(%player,%item,$BackpackSlot);}
        else
        {        Player::deployItem(%player,%item);}
}

function AODArtilleryPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (AODArtilleryPack::deployShape(%player,%item))
        {
	        Player::decItemCount(%player,%item);
//        $TeamItemCount[GameBase::getTeam(%player) @ "AODArtilleryPack"]++;
	}
}

function AODArtilleryPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete,PowerReq,PRange)
        DeployStuff(%player,%item,ArtilleryTurret,1,8,1,1,true,true,250);
}

function ArtilleryTurret::onDestroyed(%this)
{        ArtilleryTurret::onDisabled(%this);
        Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "AODArtilleryPack"]--;
}

function ArtilleryTurret::onEnabled(%this)
{        if(GameBase::isPowered(%this))
        {
	          GameBase::setRechargeRate(%this,50);
//	          GameBase::setRechargeRate(%this,24);
                %this.shieldStrength = 0.05;
//			GameBase::setAutoRepairRate(%this, 0.05);
                GameBase::setActive(%this,true);
//-----------------see-if-this-cloaks-this-turret-------------------------
		 	GameBase::startFadeout(%this);
		 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-turret-------------------------
        }
}

function ArtilleryTurret::onDisabled(%this)
{        GameBase::setRechargeRate(%this,0);
        %this.shieldStrength = 0.0;
        GameBase::setActive(%this,false);
}

function ArtilleryTurret::onPower(%this,%power,%gen)
{        if(%power)
                ArtilleryTurret::onEnabled(%this);
        else
                ArtilleryTurret::onDisabled(%this);
}

//----------------------------------------------------------------------------
// PBW Turret
//----------------------------------------------------------------------------

ItemImageData ElectroTurretPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 0.5;
	firstPerson = false;
};

ItemData ElectroTurretPack
{
	description = "PBW Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
	heading = "pTurrets";
	imageType = ElectroTurretPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.2;
	price = 400000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function ElectroTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function ElectroTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

	if (ElectroTurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function ElectroTurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,AntiTurret,1,8,1,1,true,false,0);
}

TurretData AntiTurret
{
	maxDamage = 0.2;
//	maxDamage = 1.0;
	maxEnergy = 320;
	minGunEnergy = 160;
	maxGunEnergy = 160;
	reloadDelay = 2.5;
	fireSound = SoundPBWBreakSoundBarrier;
	activationSound = SoundPlasmaTurretOn;
	deactivateSound = SoundPlasmaTurretOff;
	whirSound = SoundPlasmaTurretTurn;
	range = 200;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
		supressable = false;  //these 2 make it motion sensor
		pinger = false;       //these 2 make it motion sensor
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "hellfiregun";
	shieldShapeName = "shield_medium";
	speed = 12.0;
	speedModifier = 2.0;
	projectileType = ParticleBeamD;
//	projectileType = ParticleBeam;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "PBW Turret";
};

function AntiTurret::onAdd(%this)
{
	schedule("AntiTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,40);
	%this.shieldStrength = 0.008;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "PBW Turret");
	}
}

function AntiTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function AntiTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function AntiTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "ElectroTurretPack"]--;
}

// Override base class just in case.
function AntiTurret::onPower(%this,%power,%generator) {}
function AntiTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,40);
	GameBase::setActive(%this,true);
}

$InvList[ElectroTurretPack] = 1;
$RemoteInvList[ElectroTurretPack] = 1;

$TeamItemMax[ElectroTurretPack] = 5;

$ItemMax[marmor, ElectroTurretPack] = 1;
$ItemMax[mfemale, ElectroTurretPack] = 1;
$ItemMax[larmor, ElectroTurretPack] = 0;
$ItemMax[lfemale, ElectroTurretPack] = 0;
$ItemMax[harmor, ElectroTurretPack] = 0;

//----------------------------------------------------------------------------
// Indoor Turret
//----------------------------------------------------------------------------

ItemImageData RoundTurretPackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1;
        firstPerson = false;
};

ItemData RoundTurretPack
{
        description = "Indoor Turret";
        shapeFile = "remoteturret";
        className = "Backpack";
	  heading = "pTurrets";
        imageType = RoundTurretPackImage;
        shadowDetailMask = 4;
        mass = 1;
        elasticity = 0.2;
        price = 1500;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function RoundTurretPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function RoundTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (RoundTurretPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
        }
}

function RoundTurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,IndoorTurret,5,8,1,1,true,false,0);
//        DeployStuff(%player,%item,IndoorTurret,1,8,1,1,true,false,0);
}

function IndoorTurret::onAdd(%this)
{
        schedule("IndoorTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,25);
        %this.shieldStrength = 0.016;
        if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "Indoor Turret");
        }
}

function IndoorTurret::deploy(%this)
{
        GameBase::playSequence(%this,1,"deploy");
}

function IndoorTurret::onEndSequence(%this,%thread)
{
        GameBase::setActive(%this,true);
}

function IndoorTurret::onDestroyed(%this)
{
        Turret::onDestroyed(%this);
          $TeamItemCount[GameBase::getTeam(%this) @ "RoundTurretPack"]--;
}

// Override base class just in case.
function IndoorTurret::onPower(%this,%power,%generator) {}
function IndoorTurret::onEnabled(%this)
{
        GameBase::setRechargeRate(%this,25);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.05);
}

$InvList[RoundTurretPack] = 1;
$RemoteInvList[RoundTurretPack] = 0;

$TeamItemMax[RoundTurretPack] = 8;

$ItemMax[marmor, RoundTurretPack] = 1;
$ItemMax[mfemale, RoundTurretPack] = 1;
$ItemMax[larmor, RoundTurretPack] = 0;
$ItemMax[lfemale, RoundTurretPack] = 0;
$ItemMax[harmor, RoundTurretPack] = 0;

//----------------------------------------------------------------------------
// Bumper Turret
//----------------------------------------------------------------------------

$InvList[BumperTurretPack]                        = 1;
$RemoteInvList[BumperTurretPack]                = 1;
$TeamItemMax[BumperTurretPack]                = 2;

$ItemMax[larmor, BumperTurretPack]        = 0;
$ItemMax[lfemale, BumperTurretPack]        = 0;
$ItemMax[marmor, BumperTurretPack]        = 1;
$ItemMax[mfemale, BumperTurretPack]        = 1;
$ItemMax[harmor, BumperTurretPack]        = 0;

ExplosionData BumperExp
{
   shapeName = "bluex.dts";
   soundId   = energyExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 3.0;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.75, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.75, 1.0 };
   colors[2]  = { 0.5, 1.0,  0.5 };
   radFactors = { 1.0, 1.0,  1.0 };

   shiftPosition = True;
};

SeekingMissileData BumperMissile
{
   bulletShapeName = "mortar.dts";
   explosionTag    = BumperExp;
   collisionRadius = 0.0;
   mass            = 2.0;
   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.07;
   damageType       = $EnergyDamageType;
   explosionRadius  = 13;
   kickBackStrength = 1250.0;
//   kickBackStrength = 2575.0;
   muzzleVelocity    = 175.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;
   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };
   inheritedVelocityScale = 0.5;
   soundId = SoundJetHeavy;
};

ItemImageData BumperTurretPackImage
{        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1.0;
        firstPerson = false;
};

ItemData BumperTurretPack
{        description = "Bumper Turret";
        shapeFile = "remoteturret";
        classname = "Backpack";
        heading = "pTurrets";
        imageType = BumperTurretPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 2750;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

TurretData BumperTurret
{
	  classname                = "Turret";
	  shapeFile                = "remoteturret";
        projectileType        = BumperMissile;
        maxDamage                = 3.70;
        maxEnergy                = 600;
        minGunEnergy        = 7.5;
        maxGunEnergy        = 15;
        sequenceSound[0] = {"deploy", SoundActivateMotionSensor};
        reloadDelay                = 4.0;
        speed                        = 9.0;
        speedModifier        = 5.5;
        range                        = 225;
        visibleToSensor = true;
        shadowDetailMask = 4;
        dopplerVelocity = 0;
        castLOS                        = true;
        supression                = false;
        mapFilter                = 2;
        mapIcon                        = "M_turret";
        debrisId                = flashDebrisMedium;
        shieldShapeName = "shield";
        fireSound                = SoundRemoteTurretFire;
        activationSound = SoundRemoteTurretOn;
        deactivateSound = SoundRemoteTurretOff;
        explosionId                = flashExpMedium;
        description                = "Bumper Turret";
        damageSkinData        = "objectDamageSkins";
        pinger                        = false;
	  supressable = false;
};


function BumperTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function BumperTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

function BumperTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

	  if (BumperTurretPack::deployShape(%player,%item))
                Player::decItemCount(%player,%item);
}

function BumperTurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PackName,PowerReq,PRange)
        DeployStuff(%player,%item,BumperTurret,1,8,1,1,true,false,0);
}


function BumperTurret::onAdd(%this)
{
        schedule("BumperTurret::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,10);
        %this.shieldStrength = 0.0010;
        if (GameBase::getMapName(%this) == "")
                GameBase::setMapName (%this, "Bumper Turret");
}

function BumperTurret::deploy(%this)
{        GameBase::playSequence(%this,1,"deploy");
}

function BumperTurret::onEndSequence(%this,%thread)
{        GameBase::setActive(%this,true);
}

function BumperTurret::onDestroyed(%this)
{        Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "BumperTurretPack"]--;
}

function BumperTurret::onPower(%this,%power,%generator)
{
}

function BumperTurret::onEnabled(%this)
{        GameBase::setRechargeRate(%this,10);
        GameBase::setActive(%this,true);
//	GameBase::setAutoRepairRate(%this, 0.01);
}

//----------------------------------------------------------------------------
// Teleporter
//----------------------------------------------------------------------------

$TeamItemMax[TeleportPack] = 2;
//$TeamItemMax[DeployableTeleport] = 2;

$InvList[TeleportPack] = 1;
$RemoteInvList[TeleportPack] = 1;

$ItemMax[marmor, TeleportPack] = 1;
$ItemMax[mfemale, TeleportPack] = 1;
$ItemMax[larmor, TeleportPack] = 0;
$ItemMax[lfemale, TeleportPack] = 0;
$ItemMax[harmor, TeleportPack] = 0;

ItemImageData TeleportPackImage
{
        shapeFile = "mineammo";
        mountPoint = 2;
        mountOffset = { 0, 0, 0.1 };
        mountRotation = { 1.57, 0, 0 };
        firstPerson = false;
};

ItemData TeleportPack
{
        description = "Backup Teleporter Pad";
        shapeFile = "mineammo";
        className = "Backpack";
	heading = "lDeployables";
        imageType = TeleportPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 3200;
        hudIcon = "deployable";
        showWeaponBar = true;

        hiliteOnActive = true;
};

function TeleportPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function TeleportPack::onDeploy(%player,%item,%pos)
{
        if (teleportPack::deployShape(%player,"Teleport Pad",DeployableTeleport,%item)) {
                Player::decItemCount(%player,%item);
//                $TeamItemCount[GameBase::getTeam(%player) @ "DeployableTeleport"]++;
        }
}

function CreateteleportSimSet()
{
    %teleset = nameToID("MissionCleanup/Teleports");
        if(%teleset == -1)
        {
                newObject("Teleports",SimSet);
                addToSet("MissionCleanup","Teleports");
        }
}

function TeleportPack::deployShape(%player,%name,%shape,%item)
{
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ "TeleportPack"] < $TeamItemMax[TeleportPack]) {
                if (GameBase::getLOSInfo(%player,8)) {
                        // GetLOSInfo sets the following globals:
                        //         los::position
                        //         los::normal
                        //         los::object
                        %obj = getObjectType($los::object);
                        if (%obj == "SimTerrain" || %obj == "InteriorShape" || GameBase::getDataName($los::object) == "BlastFloorShape") {
                                if (Vector::dot($los::normal,"0 0 1") > 0.7) {
                                        if(checkDeployArea(%client,$los::position)) {
                                                %sensor = newObject("Teleport Pad","StaticShape",%shape,true);
                                                CreateteleportSimSet();
				                        addToSet("MissionCleanup/Teleports", %sensor);
                        			      addToSet("MissionCleanup", %sensor);
                                                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                                                %pos = Vector::add($los::position,"0 0 0.1");
                                                echo("LOS pos " @ $los::position @ " " @ %pos);
                                                GameBase::setPosition(%sensor,%pos);
                                                Gamebase::setMapName(%sensor,%name);
                                                Client::sendMessage(%client,0,%item.description @ " deployed");
                                                %sensor.disabled = false;
                                                playSound(SoundPickupBackpack,$los::position);
					                  $TeamItemCount[GameBase::getTeam(%player) @ "TeleportPack"]++;
//					                  $TeamItemCount[GameBase::getTeam(%player) @ "DeployableTeleport"]++;
                                                %beam = newObject("","StaticShape",ElectricalBeamBig,true);
	                                          addToSet("MissionCleanup", %beam);
                                                GameBase::setTeam(%beam,GameBase::getTeam(%player));
                                                GameBase::setPosition(%beam,%pos);
                                                %sensor.beam1 = %beam;
                                                return true;
                                        }
                                }
                                else
                                        Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
                        }
                        else
                                Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
                }
                else
                        Client::sendMessage(%client,0,"Deploy position out of range");
        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %name @ "s");
        return false;
}

//----------------------------------------------------------------------------
// Mobile Inventory Station
//----------------------------------------------------------------------------

$InvList[AODMobileInv]        = 1;
$RemoteInvList[AODMobileInv] = 0;
$TeamItemMax[AODMobileInv]        = 16;

$ItemMax[larmor, AODMobileInv]        = 0;
$ItemMax[lfemale, AODMobileInv]        = 0;
$ItemMax[marmor, AODMobileInv]        = 1;
$ItemMax[mfemale, AODMobileInv]        = 1;
$ItemMax[harmor, AODMobileInv]        = 0;

ItemImageData AODMobileInvImage
{        shapeFile        = "MagCargo";
        mountPoint        = 2;
        mountOffset = { 0, -0.65, -0.4 };
        mass                        = 5.0;
        firstPerson = false;
};

ItemData AODMobileInv
{        description                = "Mobile Inventory Stn";
        shapeFile                = "inventory_sta";
        classname                = "Backpack";
        heading                        = "lDeployables";
        imageType                = AODMobileInvImage;
        shadowDetailMask = 4;
        elasticity                = 0.2;
        price                        = 5000;
        hudIcon                        = "deployable";
        showWeaponBar        = true;
        hiliteOnActive        = true;
};

StaticShapeData MobileInvent
{  description                = "Mobile Supply Unit";
        shapeFile                = "inventory_sta";
        classname                = "station";
        visibleToSensor = true;
        sequenceSound[0] = { "activate", SoundActivateInventoryStation };
        sequenceSound[1] = { "power", SoundInventoryStationPower };
        sequenceSound[2] = { "use", SoundUseInventoryStation };
        maxDamage                = 5.5;
        debrisId                = flashDebrisLarge;
        mapFilter                = 4;
        mapIcon                        = "M_station";
        damageSkinData        = "objectDamageSkins";
        shadowDetailMask = 16;
        triggerRadius        = 1.5;
        explosionId                = flashExpLarge;
        shieldShapeName = "shield";

};


function AODMobileInv::onUse(%player,%item)
{        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {        Player::mountItem(%player,%item,$BackpackSlot);}
    else
        {        Player::deployItem(%player,%item);}
}

function AODMobileInv::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (AODMobileInv::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);

        }
}

function AODMobileInv::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,MobileInvent,1,8,0,1,true,1,200);

}

function MobileInvent::onEndSequence(%this,%thread)
{
        if (Station::onEndSequence(%this,%thread))
                InventoryStation::onResupply(%this,"InvList");
}

//----------------------------------------------------------------------------
// Mobile Command Station
//----------------------------------------------------------------------------

$InvList[PortaComm]        = 1;
$RemoteInvList[PortaComm] = 0;
$TeamItemMax[PortaComm]        = 5;

$ItemMax[larmor, PortaComm]        = 0;
$ItemMax[lfemale, PortaComm]        = 0;
$ItemMax[marmor, PortaComm]        = 1;
$ItemMax[mfemale, PortaComm]        = 1;
$ItemMax[harmor, PortaComm]        = 0;

ItemImageData PortaCommImage

{        shapeFile        = "MagCargo";
        mountPoint        = 2;
        mountOffset = { 0, -0.65, -0.4 };
        mass                        = 5.0;
        firstPerson = false;
};

ItemData PortaComm
{        description                = "Mobile Command Stn";
        shapeFile                = "cmdpnl";
        classname                = "Backpack";
        heading                        = "lDeployables";
        imageType                = PortaCommImage;
        shadowDetailMask = 4;
        elasticity                = 0.2;
        price                        = 5000;
        hudIcon                        = "deployable";
        showWeaponBar        = true;
        hiliteOnActive        = true;
};

StaticShapeData PortaC
{  description                = "Mobile Command Unit";
        shapeFile                = "cmdpnl";
        classname                = "station";
        visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateCommandStation };
	sequenceSound[1] = { "power", SoundCommandStationPower };
	sequenceSound[2] = { "use", SoundUseCommandStation };
        maxDamage                = 1.5;
        debrisId                = flashDebrisLarge;
        mapFilter                = 4;

        mapIcon                        = "M_station";
        damageSkinData        = "objectDamageSkins";
        shadowDetailMask = 16;
        triggerRadius        = 1.5;
        explosionId                = flashExpLarge;
        shieldShapeName = "shield";

};

function PortaComm::onUse(%player,%item)
{        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {        Player::mountItem(%player,%item,$BackpackSlot);}
    else
        {        Player::deployItem(%player,%item);}
}

function PortaComm::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (PortaComm::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);

        }
}

function PortaComm::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,PortaC,1,8,0,1,true,1,200);
}

function PortaC::onEndSequence(%this,%thread)
{
        if (Station::onEndSequence(%this,%thread))
                CommandStation::onResupply(%this);
}

//----------------------------------------------------------------------------
// Mobile Ammo Station
//----------------------------------------------------------------------------

$InvList[PortaAmmo]        = 1;
$RemoteInvList[PortaAmmo] = 0;
$TeamItemMax[PortaAmmo]        = 5;

$ItemMax[larmor, PortaAmmo]        = 0;
$ItemMax[lfemale, PortaAmmo]        = 0;
$ItemMax[marmor, PortaAmmo]        = 1;
$ItemMax[mfemale, PortaAmmo]        = 1;
$ItemMax[harmor, PortaAmmo]        = 0;

ItemImageData PortaAmmoImage
{        shapeFile        = "MagCargo";
        mountPoint        = 2;
        mountOffset = { 0, -0.65, -0.4 };
        mass                        = 5.0;
        firstPerson = false;
};

ItemData PortaAmmo
{        description                = "Mobile Ammo Stn";
        shapeFile                = "ammounit";
        classname                = "Backpack";
        heading                        = "lDeployables";
        imageType                = PortaAmmoImage;
        shadowDetailMask = 4;
        elasticity                = 0.2;
        price                        = 5000;
        hudIcon                        = "deployable";
        showWeaponBar        = true;
        hiliteOnActive        = true;
};

StaticShapeData PortaA
{  description                = "Mobile Ammo Unit";
        shapeFile                = "Ammounit";
        classname                = "station";
        visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateAmmoStation };
	sequenceSound[1] = { "power", SoundAmmoStationPower };
	sequenceSound[2] = { "use", SoundUseAmmoStation };
        maxDamage                = 5.5;
        debrisId                = flashDebrisLarge;

       mapFilter                = 4;
        mapIcon                        = "M_station";
        damageSkinData        = "objectDamageSkins";
        shadowDetailMask = 16;
        triggerRadius        = 1.5;
        explosionId                = flashExpLarge;
        shieldShapeName = "shield";

};

function PortaAmmo::onUse(%player,%item)
{        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {        Player::mountItem(%player,%item,$BackpackSlot);}
    else
        {        Player::deployItem(%player,%item);}
}

function PortaAmmo::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (PortaAmmo::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);

        }
}

function PortaAmmo::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,PortaA,1,8,0,1,true,1,200);
}


function PortaA::onEndSequence(%this,%thread)
{
        if (Station::onEndSequence(%this,%thread))
                AmmoStation::onResupply(%this);
}

//----------------------------------------------------------------------------
// Portable Generator
//----------------------------------------------------------------------------

$TeamItemMax[AODMobileGen]	= 6;
$InvList[AODMobileGen]		= 1;
$RemoteInvList[AODMobileGen]	= 1;

$ItemMax[larmor, AODMobileGen] = 0;
$ItemMax[lfemale, AODMobileGen] = 0;
$ItemMax[marmor, AODMobileGen] = 1;
$ItemMax[mfemale, AODMobileGen] = 1;
$ItemMax[harmor, AODMobileGen] = 0;

ItemImageData AODMobileGenImage 
{	shapeFile	= "generator_p";
	mountPoint	= 2;
	mountOffset = { 0, -0.65, -0.4 };
	mas			= 5.0;
	firstPerson = false;
};


ItemData AODMobileGen
{	description		= "Generator Booster";
	shapeFile		= "generator_p";
	classname		= "Backpack";
	heading			= "lDeployables";
	imageType		= AODMobileGenImage;
	shadowDetailMask = 4;
	mass			= 4.5;
	elasticity		= 0.2;
	price			= 2500;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

StaticShapeData MobileGen 
{	description		= "Generator Booster";
	shapeFile		= "tower";
//	shapeFile		= "generator_p";
	classname		= "pGen";
	debrisId		= flashDebrisSmall;
	sfxAmbient		= SoundGeneratorPower;
	maxDamage		= 6.8;
	mapIcon			= "M_generator";
	damageSkinData	= "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId		= flashExpMedium;
	visibleToSensor = true;
	mapFilter		= 4;
	shieldShapeName = "shield";
		
};


function AODMobileGen::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {	Player::mountItem(%player,%item,$BackpackSlot);}
    else
	{	Player::deployItem(%player,%item);}
}

function AODMobileGen::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

	if (AODMobileGen::deployShape(%player,%item))
	{	Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "AODMobileGen"]++; 
	}
}

function AODMobileGen::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	DeployStuff(%player,%item,MobileGen,1,8,0,1,false,2,350);
	
}

function MobileGen::onAdd(%this)
{}

function MobileGen::onDestroyed(%this)
{	if($trace) echo($ver,"| MobileGen::onDestroyed");
	MobileGen::onDisabled(%this);
	StaticShape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 3, 0.55, 0.30, 250, 170); 
	$TeamItemCount[GameBase::getTeam(%this) @ "AODMobileGen"]--; 
	deleteobject(%this);
//		RecheckGrid(%this);	// Main Power Restored..... Check Backup Power Grid & re-route
}

function MobileGen::onEnabled(%this)
{	if($trace) echo($ver,"| MobileGen::onEnabled ",%this);
	GameBase::setActive(%this,true);
	GameBase::playSequence(%this,0,"power");
	GameBase::generatePower(%this, true);
	GameBase::isPowerGenerator(%this);
//		RecheckGrid(%this);	// Main Power Restored..... Check Backup Power Grid & re-route
}

function MobileGen::onDisabled(%this)
{	if($trace) echo($ver,"| MobileGen::onDisabled ",%this);
	GameBase::stopSequence(%this,0);
 	GameBase::generatePower(%this, false);
//		RecheckGrid(%this);	// Main Power Restored..... Check Backup Power Grid & re-route
}

//===============================================================================================
// Force field doors Blast Door
//===============================================================================================

//----------------------------------------------------------------------------
// 5x5 Forcefield
//----------------------------------------------------------------------------

ItemImageData doorfivebyfiveForceFieldPackImage
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.5;
        firstPerson = false;
};

ItemData doorfivebyfiveForceFieldPack
{
        description = "5x5 Forcefield";
        shapeFile = "AmmoPack";
        className = "Backpack";
        heading = "nBarriers";
        imageType = doorfivebyfiveForceFieldPackImage;
        shadowDetailMask = 4;
        mass = 1.5;
        elasticity = 0.2;
        price = 500;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;

};

function doorfivebyfiveForceFieldPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {

               Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function doorfivebyfiveForceFieldPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================
	if (doorfivebyfiveForceFieldPack::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function doorfivebyfiveForceFieldPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{
		if (GameBase::getLOSInfo(%player,8)) 
		{
			%obj = getObjectType($los::object);
			%rot = GameBase::getRotation(%player);
			%zRot = getWord(%rot, 2);
			if (Vector::dot($los::normal, "0 0 1") > 0.6)
			{
				%rot = "0 0 " @ %zRot;
			}
			else
			{
				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
				{
					%rot = "3.14159 0 " @ %zRot;
				} 
				else
				{
					%rot = Vector::getRotation($los::normal);
				}
			}
			%camera = newObject("doorfivebyfiveForceFieldPack","StaticShape",doorfivebyfiveForceFieldShape,true);
			addToSet("MissionCleanup", %camera);
			GameBase::setTeam(%camera,GameBase::getTeam(%player));
			GameBase::setRotation(%camera,%rot);
			GameBase::setPosition(%camera,$los::position);
			Gamebase::setMapName(%camera,"5x5 FF Door#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
			Client::sendMessage(%client,0,"5x5 Force Field Door deployed");
			playSound(SoundPickupBackpack,$los::position);
			$TeamItemCount[GameBase::getTeam(%camera) @ "doorfivebyfiveForceFieldPack"]++;
			echo("MSG: ",%client," deployed a 5x5 Force Field Door ");
			return true;
		}
		else
		{
			Client::sendMessage(%client,0,"Cannot deploy here.");
		}
	}
	else
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	}
	return false;
}

StaticShapeData doorfivebyfiveForceFieldShape
{
	className = "LargeForceField";
	damageSkinData = "objectDamageSkins";
	shapeFile = "forcefield_5x5";
//	maxDamage = 15;
	maxDamage = 50;
	maxEnergy = 20;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "5x5 Field Door";
	shieldShapeName = "shield";
};
function doorfivebyfiveForceFieldShape::Destruct(%this)
{
	doorfivebyfiveForceFieldShape::doDamage(%this);
}

function doorfivebyfiveForceFieldShape::doDamage(%this) 
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function doorfivebyfiveForceFieldShape::onDestroyed(%this)
{
	doorfivebyfiveForceFieldShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "doorfivebyfiveForceFieldShape"]--;
}

function doorfivebyfiveForceFieldShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj)) 
	{
		return;
	}
	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);
	if(%fieldTeam != %playerTeam)
	{
		return;
	}
	doorfivebyfiveForceFieldShape::openDoor(%this);
	return;
}

function doorfivebyfiveForceFieldShape::openDoor(%this) 
{
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 16");
	GameBase::setPosition(%this,%pos);
	schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
	schedule("doorfivebyfiveForceFieldShape::closeDoor("@%this@");",4);
}

function doorfivebyfiveForceFieldShape::closeDoor(%this) 
{
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -16");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);
	schedule("GameBase::playSound("@%this@",ForceFieldClose,0);",0.15);
}

$TeamItemMax[doorfivebyfiveForceFieldPack] = 32;
//$TeamItemMax[doorfivebyfiveForceFieldPack] = 128;

$InvList[doorfivebyfiveForceFieldPack] = 1;
$RemoteInvList[doorfivebyfiveForceFieldPack] = 1;

$ItemMax[marmor, doorfivebyfiveForceFieldPack] = 1;
$ItemMax[mfemale, doorfivebyfiveForceFieldPack] = 1;
$ItemMax[larmor, doorfivebyfiveForceFieldPack] = 0;
$ItemMax[lfemale, doorfivebyfiveForceFieldPack] = 0;
$ItemMax[harmor, doorfivebyfiveForceFieldPack] = 0;

//----------------------------------------------------------------------------
// 4x8 Forcefield
//----------------------------------------------------------------------------

ItemImageData doorfourbyeightForceFieldPackImage
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.5;
        firstPerson = false;
};

ItemData doorfourbyeightForceFieldPack
{
	description = "4x8 Forcefield";
	shapeFile = "AmmoPack";
	className = "Backpack";
	heading = "nBarriers";
	imageType = doorfourbyeightForceFieldPackImage;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 1000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function doorfourbyeightForceFieldPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function doorfourbyeightForceFieldPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

	if (doorfourbyeightForceFieldPack::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function doorfourbyeightForceFieldPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{
		if (GameBase::getLOSInfo(%player,8)) 
		{
			%obj = getObjectType($los::object);
			%rot = GameBase::getRotation(%player);
			%zRot = getWord(%rot, 2);
			if (Vector::dot($los::normal, "0 0 1") > 0.6)
			{
				%rot = "0 0 " @ %zRot;
			}
			else
			{
				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
				{
					%rot = "3.14159 0 " @ %zRot;
				} 
				else
				{
					%rot = Vector::getRotation($los::normal);
				}
			}
			%camera = newObject("doorfourbyeightForceFieldPack","StaticShape",doorfourbyeightForceFieldShape,true);
			addToSet("MissionCleanup", %camera);
			GameBase::setTeam(%camera,GameBase::getTeam(%player));
			GameBase::setRotation(%camera,%rot);
			GameBase::setPosition(%camera,$los::position);
			Gamebase::setMapName(%camera,"4x8 FF Door#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
			Client::sendMessage(%client,0,"4x8 Force Field Door deployed");
			playSound(SoundPickupBackpack,$los::position);
			$TeamItemCount[GameBase::getTeam(%camera) @ "doorfourbyeightForceFieldPack"]++;
			echo("MSG: ",%client," deployed a 4x8 Force Field Door ");
			return true;
		}
		else
		{
			Client::sendMessage(%client,0,"Cannot deploy here.");
		}
	}
	else
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	}
	return false;
}

StaticShapeData doorfourbyeightForceFieldShape
{
	className = "LargeForceField";
	damageSkinData = "objectDamageSkins";
	shapeFile = "forcefield_4x8";
//	maxDamage = 25.0;
	maxDamage = 60.0;
	maxEnergy = 40;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "4x8 Field Door";
	shieldShapeName = "shield";
};
function doorfourbyeightForceFieldShape::Destruct(%this)
{
	doorfourbyeightForceFieldShape::doDamage(%this);
}

function doorfourbyeightForceFieldShape::doDamage(%this) 
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function doorfourbyeightForceFieldShape::onDestroyed(%this)
{
	doorfourbyeightForceFieldShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "doorfourbyeightForceField"]--;
}

function doorfourbyeightForceFieldShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj)) 
	{
		return;
	}
	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);
	if(%fieldTeam != %playerTeam)
	{
		return;
	}
	doorfourbyeightForceFieldShape::openDoor(%this);
	return;
}

function doorfourbyeightForceFieldShape::openDoor(%this) 
{
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 16");
	GameBase::setPosition(%this,%pos);
	schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
	schedule("doorfourbyeightForceFieldShape::closeDoor("@%this@");",4);
}

function doorfourbyeightForceFieldShape::closeDoor(%this) 
{
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -16");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);
	schedule("GameBase::playSound("@%this@",ForceFieldClose,0);",0.15);
}

$TeamItemMax[doorfourbyeightForceFieldPack] = 28;
//$TeamItemMax[doorfourbyeightForceFieldPack] = 86;

$InvList[doorfourbyeightForceFieldPack] = 1;
$RemoteInvList[doorfourbyeightForceFieldPack] = 1;

$ItemMax[marmor, doorfourbyeightForceFieldPack] = 1;
$ItemMax[mfemale, doorfourbyeightForceFieldPack] = 1;
$ItemMax[larmor, doorfourbyeightForceFieldPack] = 0;
$ItemMax[lfemale, doorfourbyeightForceFieldPack] = 0;
$ItemMax[harmor, doorfourbyeightForceFieldPack] = 0;

//----------------------------------------------------------------------------
// Blast Door
//----------------------------------------------------------------------------

ItemImageData BlastDoorI
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.5;
        firstPerson = false;
};

ItemData BlastDoor
{
	description = "Blast Door";
	shapeFile = "AmmoPack";
	className = "Backpack";
	heading = "nBarriers";
	imageType = BlastDoorI;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 2000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function BlastDoor::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function BlastDoor::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================
	if (BlastDoor::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function BlastDoor::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{
		if (GameBase::getLOSInfo(%player,8)) 
		{
			%obj = getObjectType($los::object);
			%rot = GameBase::getRotation(%player);
			%zRot = getWord(%rot, 2);
			if (Vector::dot($los::normal, "0 0 1") > 0.6)
			{
				%rot = "0 0 " @ %zRot;
			}
			else
			{
				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
				{
					%rot = "3.14159 0 " @ %zRot;
				} 
				else
				{
					%rot = Vector::getRotation($los::normal);
				}
			}
			%camera = newObject("BlastDoor","StaticShape",BlastDoorShape,true);
			addToSet("MissionCleanup", %camera);
			GameBase::setTeam(%camera,GameBase::getTeam(%player));
			GameBase::setRotation(%camera,%rot);
			GameBase::setPosition(%camera,$los::position);
			Gamebase::setMapName(%camera,"BlastDoor #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
			Client::sendMessage(%client,0,"Blast Door deployed");
			playSound(SoundPickupBackpack,$los::position);
			$TeamItemCount[GameBase::getTeam(%camera) @ "BlastDoor"]++;
			echo("MSG: ",%client," deployed a Blast Door");
			return true;
		}
		else
		{
			Client::sendMessage(%client,0,"Cannot deploy here.");
		}
	}
	else
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	}
	return false;
}

StaticShapeData BlastDoorShape
{
	className = "Blast Door";
	damageSkinData = "objectDamageSkins";
	shapeFile = "Newdoor5";
//	maxDamage = 30;
	maxDamage = 100;
	maxEnergy = 80;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "Blast Door";
	shieldShapeName = "shield";
};

function BlastDoorShape::onAdd(%this)
{
	GameBase::setRechargeRate(%this,20);
// 	%this.shieldStrength = 0.003;
	GameBase::setAutoRepairRate(%this, 0.1);
}

function BlastDoorShape::Destruct(%this)
{
	BlastDoorShape::doDamage(%this);
}

function BlastDoorShape::doDamage(%this)
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function BlastDoorShape::onDestroyed(%this)
{
	BlastDoorShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "BlastDoor"]--;
}

function BlastDoorShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj))
	{
		return;
	}
	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);
	if(%fieldTeam != %playerTeam)
	{
		return;
	}
	BlastDoorShape::openDoor(%this);
	return;
}

function BlastDoorShape::openDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorOpen,0);",0.15);
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 18");
	GameBase::setPosition(%this,%pos);
	schedule("BlastDoorShape::closeDoor("@%this@");",4);
}

function BlastDoorShape::closeDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorClose,0);",0.15);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -18");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);
	GameBase::setAutoRepairRate(%this, 0.1);
}

function BlastDoorShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{	
	if(%this.destroyed) return;	//	Shape Has Already Been Destroyed....
	%damageLevel = GameBase::getDamageLevel(%this);
	%this.lastDamageObject = %object;
	%this.lastDamageTeam = GameBase::getTeam(%object);
	
	if(%type == $AcidBathDamageType && GameBase::getAutoRepairRate(%this) != "0")
	{
		%OrigRepairRate = GameBase::getAutoRepairRate(%this);
		GameBase::setAutoRepairRate(%this,0);
		schedule("GameBase::setAutoRepairRate(" @ %this @ "," @ %OrigRepairRate @ ");",60.0,%this);
	}

	// Does a Node Exist on this Object ??
	if (%this.shieldNode)
	{	%node=%this.shieldNode;					// Apply Damage to Node Shield first
		%energy = GameBase::getEnergy(%node);
		%strength = %node.shieldStrength;
		%NodeDamageLevel = GameBase::getDamageLevel(%node);
		if($traceDam) echo( $ver@"|Shield Node :",%node," Node Energy:",%energy," Node Shield Strength:",%strength,"");
		if (%type == $ShrapnelDamageType)
			%strength *= 0.5;
		else
			if (%type == $MortarDamageType)
				%strength *= 0.25;
			else
				if (%type == $BlasterDamageType)
					%strength *= 2.0;
				else
					if (%type == $NullDamageType || %type == $Gauss2DamageType)
//						%strength *= 0;
						%strength *= 0.05;
		%absorb = %energy * %strength;
		GameBase::setEnergy(%node,%energy - (%value / %strength));
		%centerPos = getBoxCenter(%this);
		%sphereVec = findPointOnSphere(getBoxCenter(%object),%centerPos,%vec,%this);
		%centerPosX = getWord(%centerPos,0);
		%centerPosY = getWord(%centerPos,1);
		%centerPosZ = getWord(%centerPos,2);
		%pointX = getWord(%pos,0);
		%pointY = getWord(%pos,1);
		%pointZ = getWord(%pos,2);
		%newVecX = %centerPosX - %pointX;
		%newVecY = %centerPosY - %pointY;
		%newVecZ = %centerPosZ - %pointZ;
		%norm = Vector::normalize(%newVecX @ " " @ %newVecY @ " " @ %newVecZ);
		%zOffset = 0;
		if(GameBase::getDataName(%this) == PulseSensor)
			%zOffset = (%pointZ-%centerPosZ) * 0.5;
		GameBase::activateShield(%this,%sphereVec,%zOffset);
		if (%value > %absorb)
		{	// if($trace) echo( $ver@"|Shield Node unable to Deflect All damage!!!"); 
			GameBase::setEnergy(%node,0);
			BlastDoorShapeDamage (%node,%object,%NodeDamagelevel,%value-%absorb);
			// if($trace) echo( $ver@"|Shield Node Damage Level is :",%NodeDamageLevel," Damage appllied ",%value-%absorb);
		}
		return;	
	}

	%name=GameBase::GetDataName(%this);
	if (%this.shieldStrength) 
	{	//if this is a shield Node Then it has no shield
		if(%name=="RemoteShieldNode")
		{	
			BlastDoorShapeDamage (%this,%object,%damagelevel,%value);	
		}
		else
		{	%energy = GameBase::getEnergy(%this);
			%strength = %this.shieldStrength;
			if (%type == $ShrapnelDamageType)
				%strength *= 0.5;
			else
				if (%type == $MortarDamageType)
					%strength *= 0.25;
				else
					if (%type == $BlasterDamageType)
						%strength *= 2.0;
				else if (%type == $NullDamageType || %type == $Gauss2DamageType)
//						%strength *= 0;
						%strength *= 0.05;

			%absorb = %energy * %strength;
			if (%value < %absorb) 
			{	//if($trace) echo( $ver@"|the shields wil absorb all damage");
				GameBase::setEnergy(%this,%energy - (%value / %strength));
				%centerPos = getBoxCenter(%this);
				%sphereVec = findPointOnSphere(getBoxCenter(%object),%centerPos,%vec,%this);
				%centerPosX = getWord(%centerPos,0);
				%centerPosY = getWord(%centerPos,1);
				%centerPosZ = getWord(%centerPos,2);
	
				%pointX = getWord(%pos,0);
				%pointY = getWord(%pos,1);
				%pointZ = getWord(%pos,2);
	
				%newVecX = %centerPosX - %pointX;
				%newVecY = %centerPosY - %pointY;
				%newVecZ = %centerPosZ - %pointZ;
				%norm = Vector::normalize(%newVecX @ " " @ %newVecY @ " " @ %newVecZ);
				%zOffset = 0;
				if(GameBase::getDataName(%this) == PulseSensor)
					%zOffset = (%pointZ-%centerPosZ) * 0.5;
				GameBase::activateShield(%this,%sphereVec,%zOffset);
			}
			else 
			{	GameBase::setEnergy(%this,0);
				BlastDoorShapeDamage (%this,%object,%damagelevel,%value-%absorb);
				//if($trace) echo( $ver@"|the shields wil absorb some Damage - Damage =",%value-%absorb);
			}
		}
	}
	else
		BlastDoorShapeDamage (%this,%object,%damagelevel,%value);
		
}

function BlastDoorShapeDamage(%this,%object,%damageLevel,%value)
{
//	%dValue = %damageLevel + %value;
//	%dValue = %damageLevel + (1.0 - %value);
	%dValue = %damageLevel + ((0.7 - %value) * 2);
	%name = GameBase::getDataName(%this);
	GameBase::setDamageLevel(%this,%dValue);
}

$TeamItemMax[BlastDoor] = 20;
//$TeamItemMax[BlastDoor] = 56;

$InvList[BlastDoor] = 1;
$RemoteInvList[BlastDoor] = 0;

$ItemMax[marmor, BlastDoor] = 1;
$ItemMax[mfemale, BlastDoor] = 1;
$ItemMax[larmor, BlastDoor] = 0;
$ItemMax[lfemale, BlastDoor] = 0;
$ItemMax[harmor, BlastDoor] = 0;

//----------------------------------------------------------------------------
// Blast Floor
//----------------------------------------------------------------------------

ItemImageData BlastFloorI
{
	shapeFile = "AmmoPack";
	mountPoint = 2;
	mass = 1.5;
	firstPerson = false;
};

ItemData BlastFloor
{
	description = "Blast Floor";
	shapeFile = "AmmoPack";
	className = "Backpack";
	heading = "nBarriers";
	imageType = BlastFloorI;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 2500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function BlastFloor::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function BlastFloor::onDeploy(%player,%item,%pos)
{
        if (BlastFloor::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}

function BlastFloor::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item])
	{
		if (GameBase::getLOSInfo(%player,12))
		{
			%obj = getObjectType($los::object);
			%rot = GameBase::getRotation(%player);
			%camera = newObject("BlastFloor","StaticShape",BlastFloorShape,true);
			addToSet("MissionCleanup", %camera);
			GameBase::setTeam(%camera,GameBase::getTeam(%player));
			GameBase::setRotation(%camera,%rot);
			GameBase::setPosition(%camera,$los::position);
			Gamebase::setMapName(%camera,"BlastFloor #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
			Client::sendMessage(%client,0,"Blast Floor deployed");
			playSound(SoundPickupBackpack,$los::position);
			$TeamItemCount[GameBase::getTeam(%camera) @ "BlastFloor"]++;
			echo("MSG: ",%client," deployed a Blast Floor");
			return true;
		}
		else
		{
			Client::sendMessage(%client,0,"Cannot deploy here.");
		}
	}
	else
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	}
	return false;
}

StaticShapeData BlastFloorShape
{
	className = "Blast Floor";
	damageSkinData = "objectDamageSkins";
	shapeFile = "elevator6x6thin";
//	maxDamage = 15;
	maxDamage = 65;
	maxEnergy = 10;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "Blast Floor";
	shieldShapeName = "shield";
};

function BlastFloorShape::Destruct(%this)
{
	BlastFloorShape::doDamage(%this);
}

function BlastFloorShape::doDamage(%this)
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function BlastFloorShape::onDestroyed(%this)
{
	BlastDoorShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "BlastFloor"]--;
}

//$TeamItemMax[BlastFloor] = 32;
$TeamItemMax[BlastFloor] = 132;

$InvList[BlastFloor] = 1;
$RemoteInvList[BlastFloor] = 0;

$ItemMax[marmor, BlastFloor] = 1;
$ItemMax[mfemale, BlastFloor] = 1;
$ItemMax[larmor, BlastFloor] = 0;
$ItemMax[lfemale, BlastFloor] = 0;
$ItemMax[harmor, BlastFloor] = 0;

//----------------------------------------------------------------------------
// Super Door
//----------------------------------------------------------------------------

ItemImageData SuperDoorI
{
	shapeFile = "AmmoPack";
	mountPoint = 2;
	mass = 1.5;
	firstPerson = false;
};

ItemData SuperDoor
{
	description = "Super Door";
	shapeFile = "AmmoPack";
	className = "Backpack";
	heading = "nBarriers";
	imageType = SuperDoorI;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 15200;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SuperDoor::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function SuperDoor::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================
	if (SuperDoor::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function SuperDoor::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{
		if (GameBase::getLOSInfo(%player,8)) 
		{
			%obj = getObjectType($los::object);
			%rot = GameBase::getRotation(%player);
			%zRot = getWord(%rot, 2);
			if (Vector::dot($los::normal, "0 0 1") > 0.6)
			{
				%rot = "0 0 " @ %zRot;
			}
			else
			{
				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
				{
					%rot = "3.14159 0 " @ %zRot;
				} 
				else
				{
					%rot = Vector::getRotation($los::normal);
				}
			}
			%camera = newObject("SuperDoor","StaticShape",SuperDoorShape,true);
			addToSet("MissionCleanup", %camera);
			GameBase::setTeam(%camera,GameBase::getTeam(%player));
			GameBase::setRotation(%camera,%rot);
			GameBase::setPosition(%camera,$los::position);
			Gamebase::setMapName(%camera,"SuperDoor #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
			Client::sendMessage(%client,0,"Super Door deployed");
			playSound(SoundPickupBackpack,$los::position);
			$TeamItemCount[GameBase::getTeam(%camera) @ "SuperDoor"]++;
			echo("MSG: ",%client," deployed a Super Door");
			return true;
		}
		else
		{
			Client::sendMessage(%client,0,"Cannot deploy here.");
		}
	}
	else
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	}
	return false;
}

StaticShapeData SuperDoorShape
{
	className = "Super Door";
	damageSkinData = "objectDamageSkins";
	shapeFile = "PlasmaWall";
//	maxDamage = 500;
	maxDamage = 1500;
	maxEnergy = 2000;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "Super Door";
	shieldShapeName = "shield";
};

function SuperDoorShape::Destruct(%this)
{
	SuperDoorShape::doDamage(%this);
}

function SuperDoorShape::doDamage(%this)
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function SuperDoorShape::onDestroyed(%this)
{
	SuperDoorShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "SuperDoor"]--;
}

function SuperDoorShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj))
	{
		return;
	}
	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);
	if(%fieldTeam != %playerTeam)
	{
		return;
	}
	SuperDoorShape::openDoor(%this);
	return;
}

function SuperDoorShape::openDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorOpen,0);",0.15);
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 18");
	GameBase::setPosition(%this,%pos);
	schedule("SuperDoorShape::closeDoor("@%this@");",4);
}

function SuperDoorShape::closeDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorClose,0);",0.15);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -18");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);
}

$TeamItemMax[SuperDoor] = 6;

$InvList[SuperDoor] = 0;
$RemoteInvList[SuperDoor] = 1;

$ItemMax[marmor, SuperDoor] = 1;
$ItemMax[mfemale, SuperDoor] = 1;
$ItemMax[larmor, SuperDoor] = 0;
$ItemMax[lfemale, SuperDoor] = 0;
$ItemMax[harmor, SuperDoor] = 0;

//----------------------------------------------------------------------------
// Powered Door
//----------------------------------------------------------------------------

ItemImageData PoweredDoorI
{
	shapeFile = "Ammo2";
	mountPoint = 2;
	mass = 1.5;
	firstPerson = false;
};

ItemData PoweredDoor
{
	description = "Powered Door";
	shapeFile = "Ammo2";
	className = "Backpack";
	heading = "nBarriers";
	imageType = PoweredDoorI;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 15200;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function PoweredDoor::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function PoweredDoor::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================
	if (PoweredDoor::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "PoweredDoor"]++;
	}
}

function PoweredDoor::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete,PowerReq,PRange)
	DeployStuff(%player,%item,PoweredDoorShape,1,8,0,1,true,true,150);
//	%client = Player::getClient(%player);
//	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
//	{
//		if (GameBase::getLOSInfo(%player,8)) 
//		{
//			%obj = getObjectType($los::object);
//			%rot = GameBase::getRotation(%player);
//			%zRot = getWord(%rot, 2);
//			if (Vector::dot($los::normal, "0 0 1") > 0.6)
//			{
//				%rot = "0 0 " @ %zRot;
//			}
//			else
//			{
//				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
//				{
//					%rot = "3.14159 0 " @ %zRot;
//				} 
//				else
//				{
//					%rot = Vector::getRotation($los::normal);
//				}
//			}
//			%camera = newObject("PoweredDoor","StaticShape",PoweredDoorShape,true);
//			addToSet("MissionCleanup", %camera);
//			GameBase::setTeam(%camera,GameBase::getTeam(%player));
//			GameBase::setRotation(%camera,%rot);
//			GameBase::setPosition(%camera,$los::position);
//			Gamebase::setMapName(%camera,"PoweredDoor #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
//			Client::sendMessage(%client,0,"Powered Door deployed");
//			playSound(SoundPickupBackpack,$los::position);
//			$TeamItemCount[GameBase::getTeam(%camera) @ "PoweredDoor"]++;
//			echo("MSG: ",%client," deployed a Powered Door");
//			return true;
//		}
//		else
//		{
//			Client::sendMessage(%client,0,"Cannot deploy here.");
//		}
//	}
//	else
//	{
//		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
//	}
//	return false;
}

StaticShapeData PoweredDoorShape
{
	className = "Powered Door";
	damageSkinData = "objectDamageSkins";
	shapeFile = "ForceField";
	maxDamage = 10.0;
//	maxEnergy = 100;
//	maxDamage = 250.0;
	maxEnergy = 1000;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "Powered Door";
	shieldShapeName = "shield_large";
};

function PoweredDoorShape::Destruct(%this)
{
	PoweredDoorShape::doDamage(%this);
}

function PoweredDoorShape::doDamage(%this)
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function PoweredDoorShape::onDestroyed(%this)
{
	PoweredDoorShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "PoweredDoor"]--;
}

function PoweredDoorShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj))
	{
		return;
	}
	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);
	if(%fieldTeam != %playerTeam)
	{
		return;
	}
	PoweredDoorShape::openDoor(%this);
	return;
}

function PoweredDoorShape::openDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorOpen,0);",0.15);
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 18");
	GameBase::setPosition(%this,%pos);
	schedule("PoweredDoorShape::closeDoor("@%this@");",4);
}

function PoweredDoorShape::closeDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorClose,0);",0.15);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -18");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);

	GameBase::setAutoRepairRate(%this, 0.1);
}

function PoweredDoorShape::onPower(%this,%power,%generator)
{
	if (%power) 
	{
		%this.shieldStrength = 5.0;
		GameBase::setRechargeRate(%this,50);
		GameBase::setAutoRepairRate(%this, 0.1);
	}
	else 
	{
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		GameBase::setAutoRepairRate(%this, 0.1);
	}
	GameBase::setActive(%this,%power);
}

//$TeamItemMax[PoweredDoor] = 6;
$TeamItemMax[PoweredDoor] = 16;

$InvList[PoweredDoor] = 0;
$RemoteInvList[PoweredDoor] = 1;

$ItemMax[marmor, PoweredDoor] = 1;
$ItemMax[mfemale, PoweredDoor] = 1;
$ItemMax[larmor, PoweredDoor] = 0;
$ItemMax[lfemale, PoweredDoor] = 0;
$ItemMax[harmor, PoweredDoor] = 0;

//----------------------------------------------------------------------------
// Shielded 5x5 Forcefield
//----------------------------------------------------------------------------

ItemImageData shieldedfivebyfiveForceFieldPackImage
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.5;
        firstPerson = false;
};

ItemData shieldedfivebyfiveForceFieldPack
{
        description = "Shielded 5x5 FF";
        shapeFile = "AmmoPack";
        className = "Backpack";
        heading = "nBarriers";
        imageType = shieldedfivebyfiveForceFieldPackImage;
        shadowDetailMask = 4;
        mass = 1.5;
        elasticity = 0.2;
        price = 4500;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;

};

function shieldedfivebyfiveForceFieldPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {

               Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function shieldedfivebyfiveForceFieldPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (shieldedfivebyfiveForceFieldPack::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}

function shieldedfivebyfiveForceFieldPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{
		if (GameBase::getLOSInfo(%player,8)) 
		{
			%obj = getObjectType($los::object);
			%rot = GameBase::getRotation(%player);
			%zRot = getWord(%rot, 2);
			if (Vector::dot($los::normal, "0 0 1") > 0.6)
			{
				%rot = "0 0 " @ %zRot;
			}
			else
			{
				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
				{
					%rot = "3.14159 0 " @ %zRot;
				} 
				else
				{
					%rot = Vector::getRotation($los::normal);
				}
			}
			%camera = newObject("shieldedfivebyfiveForceFieldPack","StaticShape",shieldedfivebyfiveForceFieldShape,true);
			addToSet("MissionCleanup", %camera);
			GameBase::setTeam(%camera,GameBase::getTeam(%player));
			GameBase::setRotation(%camera,%rot);
			GameBase::setPosition(%camera,$los::position);
			Gamebase::setMapName(%camera,"Shielded 5x5 FF Door #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
			Client::sendMessage(%client,0,"Shielded 5x5 FF Door deployed");
			playSound(SoundPickupBackpack,$los::position);
			$TeamItemCount[GameBase::getTeam(%camera) @ "shieldedfivebyfiveForceFieldPack"]++;
			echo("MSG: ",%client," deployed a Shielded 5x5 FF Door ");
			return true;
		}
		else
		{
			Client::sendMessage(%client,0,"Cannot deploy here.");
		}
	}
	else
	{
		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	}
	return false;
}


StaticShapeData shieldedfivebyfiveForceFieldShape
{
	className = "LargeForceField";
	damageSkinData = "objectDamageSkins";
	shapeFile = "forcefield_5x5";
	maxDamage = 45;
	maxEnergy = 50;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "5x5 Shielded Door";
	shieldShapeName = "shield";
};

function shieldedfivebyfiveForceFieldShape::Destruct(%this)
{
	shieldedfivebyfiveForceFieldShape::doDamage(%this);
}

function shieldedfivebyfiveForceFieldShape::doDamage(%this) 
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function shieldedfivebyfiveForceFieldShape::onDestroyed(%this)
{
	shieldedfivebyfiveForceFieldShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "shieldedfivebyfiveForceFieldShape"]--;
}

function shieldedfivebyfiveForceFieldShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj)) 
	{
		return;
	}
	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);
	if(%fieldTeam != %playerTeam)
	{
		return;
	}
	shieldedfivebyfiveForceFieldShape::openDoor(%this);
	return;
}

function shieldedfivebyfiveForceFieldShape::openDoor(%this) 
{
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 16");
	GameBase::setPosition(%this,%pos);
	schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
	schedule("shieldedfivebyfiveForceFieldShape::closeDoor("@%this@");",4);
}

function shieldedfivebyfiveForceFieldShape::closeDoor(%this) 
{
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -16");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);
	schedule("GameBase::playSound("@%this@",ForceFieldClose,0);",0.15);

	GameBase::setAutoRepairRate(%this, 2.0);
	%this.shieldStrength = 0.075;
	GameBase::setRechargeRate(%this,35);
}

function shieldedfivebyfiveForceFieldShape::onEnabled(%this)
{
	GameBase::setRechargeRate(%this,35);
	GameBase::setActive(%this,true);
	%this.shieldStrength = 0.075;
	GameBase::setAutoRepairRate(%this, 2.0);
}

//$TeamItemMax[shieldedfivebyfiveForceFieldPack] = 8;
$TeamItemMax[shieldedfivebyfiveForceFieldPack] = 18;

$InvList[shieldedfivebyfiveForceFieldPack] = 1;
$RemoteInvList[shieldedfivebyfiveForceFieldPack] = 1;

$ItemMax[marmor, shieldedfivebyfiveForceFieldPack] = 1;
$ItemMax[mfemale, shieldedfivebyfiveForceFieldPack] = 1;
$ItemMax[larmor, shieldedfivebyfiveForceFieldPack] = 0;
$ItemMax[lfemale, shieldedfivebyfiveForceFieldPack] = 0;
$ItemMax[harmor, shieldedfivebyfiveForceFieldPack] = 0;

//----------------------------------------------------------------------------
// Electrified 4x17 Fence
//----------------------------------------------------------------------------

ItemImageData ElectrifiedDoorI
{
	shapeFile = "Ammo2";
	mountPoint = 2;
	mass = 1.5;
	firstPerson = false;
};

ItemData ElectrifiedDoor
{
	description = "Electrified Fence";
	shapeFile = "Ammo2";
	className = "Backpack";
	heading = "nBarriers";
	imageType = ElectrifiedDoorI;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 12500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function ElectrifiedDoor::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function ElectrifiedDoor::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (ElectrifiedDoor::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);
//	$TeamItemCount[GameBase::getTeam(%player) @ "ElectrifiedDoor"]++;
	}
}

function ElectrifiedDoor::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete,PowerReq,PRange)
	DeployStuff(%player,%item,ElectrifiedDoorShape,1,8,0,1,true,true,175);
//	%client = Player::getClient(%player);
//	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
//	{
//		if (GameBase::getLOSInfo(%player,8)) 
//		{
//			%obj = getObjectType($los::object);
//			%rot = GameBase::getRotation(%player);
//			%zRot = getWord(%rot, 2);
//			if (Vector::dot($los::normal, "0 0 1") > 0.6)
//			{
//				%rot = "0 0 " @ %zRot;
//			}
//			else
//			{
//				if (Vector::dot($los::normal, "0 0 -1") > 0.6)
//				{
//					%rot = "3.14159 0 " @ %zRot;
//				} 
//				else
//				{
//					%rot = Vector::getRotation($los::normal);
//				}
//			}
//			%camera = newObject("ElectrifiedDoor","StaticShape",ElectrifiedDoorShape,true);
//			addToSet("MissionCleanup", %camera);
//			GameBase::setTeam(%camera,GameBase::getTeam(%player));
//			GameBase::setRotation(%camera,%rot);
//			GameBase::setPosition(%camera,$los::position);
//			Gamebase::setMapName(%camera,"ElectrifiedFence #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
//			Client::sendMessage(%client,0,"Electrified Fence deployed");
//			playSound(SoundPickupBackpack,$los::position);
//			$TeamItemCount[GameBase::getTeam(%camera) @ "ElectrifiedDoor"]++;
//			echo("MSG: ",%client," deployed an Electrified Fence");
//			return true;
//		}
//		else
//		{
//			Client::sendMessage(%client,0,"Cannot deploy here.");
//		}
//	}
//	else
//	{
//		Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
//	}
//	return false;
}

StaticShapeData ElectrifiedDoorShape
{
	className = "LargeForceField";
	damageSkinData = "objectDamageSkins";
	shapeFile = "forcefield_4x17";
	maxDamage = 75.0;
	maxEnergy = 500;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "Electrified Fence";
	shieldShapeName = "shield_large";
};

function ElectrifiedDoorShape::Destruct(%this)
{
	ElectrifiedDoorShape::doDamage(%this);
}

function ElectrifiedDoorShape::doDamage(%this)
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function ElectrifiedDoorShape::onDestroyed(%this)
{
	ElectrifiedDoorShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "ElectrifiedDoor"]--;
}

function ElectrifiedDoorShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj))
	{
		return;
	}
	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);
	if(%fieldTeam != %playerTeam)
	{
		GameBase::applyDamage(%obj, $Electricity2DamageType, 500, "0 0 0", "0 0 0", "0 0 0", %this);
		return;
	}
	ElectrifiedDoorShape::openDoor(%this);
	return;
}

function ElectrifiedDoorShape::openDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorOpen,0);",0.15);
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 18");
	GameBase::setPosition(%this,%pos);
	schedule("ElectrifiedDoorShape::closeDoor("@%this@");",4);
}

function ElectrifiedDoorShape::closeDoor(%this)
{
	schedule("GameBase::playSound("@%this@",BlastDoorClose,0);",0.15);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -18");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);

	GameBase::setRechargeRate(%this,250);
	GameBase::setAutoRepairRate(%this, 5.0);
}

function ElectrifiedDoorShape::onPower(%this,%power,%generator)
{
	if (%power) 
	{
		GameBase::setRechargeRate(%this,250);
		GameBase::setAutoRepairRate(%this, 5.0);
	}
	else 
	{
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		GameBase::setAutoRepairRate(%this, 0.1);
	}
	GameBase::setActive(%this,%power);
}

$TeamItemMax[ElectrifiedDoor] = 12;

$InvList[ElectrifiedDoor] = 0;
$RemoteInvList[ElectrifiedDoor] = 1;

$ItemMax[marmor, ElectrifiedDoor] = 1;
$ItemMax[mfemale, ElectrifiedDoor] = 1;
$ItemMax[larmor, ElectrifiedDoor] = 0;
$ItemMax[lfemale, ElectrifiedDoor] = 0;
$ItemMax[harmor, ElectrifiedDoor] = 0;

//these go in item.cs at mission::reinit
//	$TeamItemCount[0 @ ElectrifiedDoor] = 0;
//	$TeamItemCount[1 @ ElectrifiedDoor] = 0;
//	$TeamItemCount[2 @ ElectrifiedDoor] = 0;
//	$TeamItemCount[3 @ ElectrifiedDoor] = 0;

//----------------------------------------------------------------------------
// Air Base
//----------------------------------------------------------------------------

$TeamItemMax[MiniBase] = 2;

ItemImageData MiniBaseImage
{
	shapeFile = "ammounit_remote";
	mountPoint = 2;
	mountOffset = { 0, 0, 0 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData MiniBase
{
	description = "Air Base";
//	description = "Mini-Base";
	shapeFile = "ammounit_remote";
	className = "Backpack";
	heading =  "qAir Deployables";
//	heading =  "lDeployables";
	imageType = MiniBaseImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 10000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

StaticShapeData MiniBaseGenerator
{
	description = "Power Source";
	shapeFile = "generator_p";
	className = "Generator";
	debrisId = flashDebrisSmall;
	sfxAmbient = SoundGeneratorPower;
	maxDamage = 30.0;
	mapIcon = "M_generator";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId = flashExpMedium;
	visibleToSensor = true;
	mapFilter = 4;
};

function MiniBase::Destruct(%this)
{
	%obj = newObject("","Mine","armorCoreExp");
	addToSet("MissionCleanup", %obj);
	%padd = "0 0 -2";
	%pos = Vector::add(GameBase::getPosition(%this), %padd);
	GameBase::setPosition(%obj, %pos);
	%obj = newObject("","Mine","armorExp");
	addToSet("MissionCleanup", %obj);
	%padd = "0 0 0";
	%pos = Vector::add(GameBase::getPosition(%this), %padd);
	GameBase::setPosition(%obj, %pos);
	%obj = newObject("","Mine","armorExp");
	addToSet("MissionCleanup", %obj);
	%padd = "0 0 2";
	%pos = Vector::add(GameBase::getPosition(%this), %padd);
	GameBase::setPosition(%obj, %pos);
	%obj = newObject("","Mine","armorExp");
	addToSet("MissionCleanup", %obj);
	%padd = "0 0 4";
	%pos = Vector::add(GameBase::getPosition(%this), %padd);
	GameBase::setPosition(%obj, %pos);
	return;
}

function MiniBaseGenerator::onDestroyed(%this)
{
	StaticShape::onDestroyed(%this);
	MiniBase::Destruct(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "MiniBase"]--;
}

StaticShapeData BasePlatform
{
	shapeFile = "elevator16x16_octo";
	debrisId = defaultDebrisLarge;
	maxDamage = 200.0;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId = debrisExpLarge;
	visibleToSensor = true;
	mapFilter = 4;
	description = "Mini-Base";
};

function BasePlatform::onDestroyed(%this)
{
	StaticShape::onDestroyed(%this);
      $TeamItemCount[GameBase::getTeam(%player) @ "MiniBase"]--;//warcan, is this line needed?
	MiniBase::Destruct(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 100, 2000, 2500, 50, 45, 1000, 999, 250, 100);
//    calcRadiusDamage(%this,%type,%radiusRatio,%damageRatio,%forceRatio,%rMax,%rMin,%dMax,%dMin,%fMax,%fMin) 
}

function MiniBase::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function MiniBase::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================
	if (MiniBase::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "MiniBase"]++;
	}
}

function MiniBase::deployshape(%player,%item)
{
	GameBase::getLOSInfo(%player,8);
      %client = Player::getClient(%player);
      %playerPos = GameBase::getPosition(%player);

      if($TeamItemCount[GameBase::getTeam(%player) @ "MiniBase"] >= $TeamItemMax[MiniBase])
      { 
		Client::sendMessage(%client,0,"Too many Mini-Bases"); 
		return false; 
	}

      %obj = getObjectType($los::object);
      %set = newObject("MiniBase",SimSet);
      %num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$ForceFieldBoxMinLength,$ForceFieldBoxMinWidth,$ForceFieldBoxMinHeight,0);
      %num = CountObjects(%set,"MiniBase",%num);
      deleteObject(%set);

      %objDevice = newObject("groundBase","Staticshape",MiniBaseGenerator,true);
      %objDevice.objSide1 = newObject("groundBase1","Staticshape",BasePlatform,true);
      %objDevice.objSide2 = newObject("groundBase2","Staticshape",BasePlatform,true);
      %objDevice.objSide3 = newObject("groundBase3","Staticshape",BasePlatform,true);
      %objDevice.objSide4 = newObject("groundBase4","Sensor",PulseSensor,true);
      %objDevice.objSide5 = newObject("groundBase5","StaticShape",BasePlatform,true);
      %objDevice.objSide6 = newObject("groundBase6","StaticShape",AmmoStation,true);
      %objDevice.objSide7 = newObject("groundBase7","StaticShape",InventoryStation,true);
      %objDevice.objSide8 = newObject("groundBase8","StaticShape",VehicleStation,true);
      %objDevice.objSide9 = newObject("groundBase9","StaticShape",VehiclePad,true);
      %objDevice.objSide10 = newObject("groundBase10","Turret",AirTurret,true);
//      %objDevice.objSide10 = newObject("groundBase10","Turret",GROGTurret,true);
      %objDevice.objSide11 = newObject("groundBase11","Turret",VelcroTurret,true);

      %objDevice.objSide1.objParent = %objDevice;
      %objDevice.objSide2.objParent = %objDevice;
      %objDevice.objSide3.objParent = %objDevice;
      %objDevice.objSide4.objParent = %objDevice;
      %objDevice.objSide5.objParent = %objDevice;
      %objDevice.objSide6.objParent = %objDevice;
      %objDevice.objSide7.objParent = %objDevice;
      %objDevice.objSide8.objParent = %objDevice;
      %objDevice.objSide9.objParent = %objDevice;
      %objDevice.objSide10.objParent = %objDevice;
      %objDevice.objSide11.objParent = %objDevice;

      addToSet(MissionCleanup, %objDevice);
      addToSet(MissionCleanup, %objDevice.objSide1);
      addToSet(MissionCleanup, %objDevice.objSide2);
      addToSet(MissionCleanup, %objDevice.objSide3);
      addToSet(MissionCleanup, %objDevice.objSide4);
      addToSet(MissionCleanup, %objDevice.objSide5);
      addToSet(MissionCleanup, %objDevice.objSide6);
      addToSet(MissionCleanup, %objDevice.objSide7);
      addToSet(MissionCleanup, %objDevice.objSide8);
      addToSet(MissionCleanup, %objDevice.objSide9);
      addToSet(MissionCleanup, %objDevice.objSide10);
      addToSet(MissionCleanup, %objDevice.objSide11);

// The Building <(8)>

      %pos = Vector::add(GameBase::getPosition(%player), "7.5 0 122");
      %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
      GameBase::setRotation(%objDevice.objSide5,%rot);
      GameBase::setPosition(%objDevice.objSide5,%pos);
      GameBase::setTeam(%objDevice,GameBase::getTeam(%player));

      %pos = Vector::add(GameBase::getPosition(%player), "-7.5 0 122");
      %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
      GameBase::setRotation(%objDevice.objSide1,%rot);
      GameBase::setPosition(%objDevice.objSide1,%pos);
      GameBase::setTeam(%objDevice.objSide1,GameBase::getTeam(%player));

      %pos = Vector::add(GameBase::getPosition(%player), "0 7 115");
      %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
      GameBase::setRotation(%objDevice.objSide2,%rot);
      GameBase::setPosition(%objDevice.objSide2,%pos);
      GameBase::setTeam(%objDevice.objSide2,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "0 -7 115");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
       GameBase::setRotation(%objDevice.objSide3,%rot);
       GameBase::setPosition(%objDevice.objSide3,%pos);
       GameBase::setTeam(%objDevice.objSide3,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "0 0 122.50");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
       GameBase::setRotation(%objDevice.objSide4,%rot);
       GameBase::setPosition(%objDevice.objSide4,%pos);
       GameBase::setTeam(%objDevice.objSide4,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "0 0 115.40");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice,%rot);
       GameBase::setPosition(%objDevice,%pos);
       GameBase::setTeam(%objDevice.objSide5,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "-1 7 115.40");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 -4.71339");
       GameBase::setRotation(%objDevice.objSide6,%rot);
       GameBase::setPosition(%objDevice.objSide6,%pos);
       GameBase::setTeam(%objDevice.objSide6,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "1 7 115.40");
       %rot = Vector::add(GameBase::getRotation(%player), "-3.14 0 0");
       GameBase::setRotation(%objDevice.objSide11,%rot);
       GameBase::setPosition(%objDevice.objSide11,%pos);
       GameBase::setTeam(%objDevice.objSide11,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "1 -7 115.40");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice.objSide7,%rot);
       GameBase::setPosition(%objDevice.objSide7,%pos);
       GameBase::setTeam(%objDevice.objSide7,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "1 -7 115.40");
       %rot = Vector::add(GameBase::getRotation(%player), "-3.14 0 0");
       GameBase::setRotation(%objDevice.objSide10,%rot);
       GameBase::setPosition(%objDevice.objSide10,%pos);
       GameBase::setTeam(%objDevice.objSide10,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "-7 1 122.50");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice.objSide8,%rot);
       GameBase::setPosition(%objDevice.objSide8,%pos);
       GameBase::setTeam(%objDevice.objSide8,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "7 -1 122.50");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice.objSide9,%rot);
       GameBase::setPosition(%objDevice.objSide9,%pos);
       GameBase::setTeam(%objDevice.objSide9,GameBase::getTeam(%player));
       Gamebase::setMapName(%inv,"Mini-Base " @  Client::getName(%client));

       playSound(SoundPickupBackpack,$los::position);
       $TeamItemCount[GameBase::getTeam(%player) @ "MiniBase"]++;
       Client::sendMessage(%client,0,"Mini-Base Deployed.");
//----v-------warcan-says-right-here-is-where-the-deployer-goes-to-the-ship---above-it-actually------v------
	%posYOU = Vector::add(GameBase::getPosition(%player), "0 -3 116");
	GameBase::setPosition(%player,%posYOU);
//----^-------warcan-says-right-here-is-where-the-deployer-goes-to-the-ship---above-it-actually------^------
       echo("MSG: ",%client," deployed a Mini-Base");
       return true;
}

$InvList[MiniBase] = 1;
$RemoteInvList[MiniBase] = 1;

$ItemMax[harmor, MiniBase] = 0;
$ItemMax[marmor, MiniBase] = 1;
$ItemMax[mfemale, MiniBase] = 1;
$ItemMax[larmor, MiniBase] = 1;
$ItemMax[lfemale, MiniBase] = 1;

//--------------------------------------------------------------------------------------------------------
function ItemBusy(%this)
{        %this.isbusy=true;
}

function ItemNotBusy(%this)
{        %this.isbusy=false;
}

//----------------------------------------------------------------------------
// Shield Generator    provides power to Shield Nodes
//----------------------------------------------------------------------------

$InvList[AODShieldGen]		= 1;
$RemoteInvList[AODShieldGen]	= 0;
$TeamItemMax[AODShieldGen]		= 1;

$ItemMax[larmor, AODShieldGen]		= 0;
$ItemMax[lfemale, AODShieldGen]	= 0;
$ItemMax[marmor, AODShieldGen]		= 1;
$ItemMax[mfemale, AODShieldGen]	= 1;
$ItemMax[harmor, AODShieldGen]		= 0;

ItemImageData AODShieldGenImage 
{	shapeFile		= "MagCargo";
	mountPoint		= 2;
	mountOffset		= { 0, -0.65, -0.4 };
	mountRotation	= { 0, 0, 0 };
	mass			= 5.0;
	firstPerson		= false;
};


ItemData AODShieldGen
{	description		= "Shield Generator";
	shapeFile		= "generator";
	classname		= "Backpack";
	heading			= "lDeployables";
	imageType		= AODShieldGenImage;
	shadowDetailMask = 4;
	elasticity		= 0.2;
	price			= 1500;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

StaticShapeData ShieldGen 
{	description			= "Shield Generator";
	shapeFile			= "generator";
	classname			= "ShieldGen";
	debrisId			= flashDebrisLarge;
	maxDamage			= 6.8;
	mapIcon				= "M_generator";
	damageSkinData		= "objectDamageSkins";

shadowDetailMask	= 16;
	explosionId			= LargeShockWave;
	visibleToSensor		= true;
	mapFilter			= 4;
	shieldShapeName		= "shield";
//	sequenceSound[0] = { "enable", SoundFabGenStart };
	sequenceSound[1] = { "power", SoundShieldGenerator };
};


function AODShieldGen::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {	Player::mountItem(%player,%item,$BackpackSlot);}
    else
	{	Player::deployItem(%player,%item);}
}

function AODShieldGen::onDeploy(%player,%item,%pos)
{	if (AODShieldGen::deployShape(%player,%item))
	{	Player::decItemCount(%player,%item);
//		$TeamItemCount[GameBase::getTeam(%player) @ "AODShieldGen"]++; 
	}
}

function AODShieldGen::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	%gen=DeployStuff(%player,%item,ShieldGen,1,8,0,1,false,1,196);
	if(%gen)
	{	%team=GameBase::getTeam(%player);
		$ShieldGen[%team]=%gen;
		$ShieldGenOn[%team]=true;
		if($trace) echo( $ver@"|NodeSet for this team is ",$NodeSet[%team]);
		if(!$NodeSet[%team])
		{	if($trace) echo( $ver@"|Creating a Node Set for Team ",%team);
			$NodeSet[%team] = newObject("ShieldNodes",SimSet);
			addToSet("MissionCleanup", $NodeSet[%team]);
		}

	}
}

function ShieldGen::onAdd(%this)
{}

function ShieldGen::onEnabled(%this)
{	if($trace) echo( $ver@"|Shield Gen OnEnabled");
	%team=GameBase::getTeam(%this);
	if(%this.destroyed==true)
	{	// Was destroyed but is no longer - Has been repaired
		%this.destroyed=false;
	}
	if(GameBase::isPowered(%this))
	{	GameBase::playSequence(%this,0,"power");
		if (%team!=-1)
		{	$ShieldGenOn[%team]=true;
			ActivateNodes(true,%team);
		}
	}
}

function ShieldGen::onDestroyed(%this)
{	if($trace) echo( $ver@"|ShieldGen::onDestroyed");
	%team=GameBase::getTeam(%this);
	if($ShieldGenOn[%team])
		ShieldGen::onDisabled(%this);

	$ShieldGen[%team]=false;
	StaticShape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 8.5, 0.10, 55, 23, 3, 1.5, 1.0, 250, 170); 

	$TeamItemCount[GameBase::getTeam(%this) @ "AODShieldGen"]--; 
	deleteobject(%this);
}

function ShieldGen::onDisabled(%this)
{	if($trace) echo( $ver@"|ShieldGen::onDisabled");
	%team=GameBase::getTeam(%this);
	GameBase::stopSequence(%this,0);
 	$ShieldGenOn[%team]=false;
	ActivateNodes(false,%team);
}

function ShieldGen::onPower(%this, %state, %generator)
{	if($trace) echo($ver,"|ShieldGen::onPower this|state|generator ",%this,%state,%generator);
	if(%state)
		ShieldGen::OnEnabled(%this);
	else
		ShieldGen::OnDisabled(%this);
}

function ActivateNodes(%status,%team)
{	if($trace) echo( $ver@"|Activate Shield Nodes for Team ",%team);
	%num=$TeamItemCount[%team @ AODShieldNode];
	if (%num>0)
	{	for(%i=0;%i<%num;%i++)
		{	%node=Group::GetObject($NodeSet[%team],%i);
			if($trace) echo( $ver@"|Node ID is:",%node);
			if (%status==true)
			{	if($trace) echo( $ver@"|Activating Node :",%i);
				if($trace) echo( $ver@"|Node ID = ",%node);
				RemoteShieldNode::onActivate(%node);}
			else
			{	if($trace) echo( $ver@"|DeActivating Node :",%i);
				if($trace) echo( $ver@"|Node ID = ",%node);
				RemoteShieldNode::onDeActivate(%node);}
		}
	}
	else
		if($trace) echo( $ver@"|No Nodes to Activate");
}

//Shield node Connection objects
$ObjType[0]="DeployableTurret";
$ObjType[1]="VELCROTurret";
$ObjType[2]="GROGTurret";
$ObjType[3]="Fluxturret";
$ObjType[4]="RocketTurret";
$ObjType[5]="PlasmaTurret";
$ObjType[6]="FusionTurret";
$ObjType[7]="AATurret";
$ObjType[8]="ELFTurret";
$ObjType[9]="IndoorTurret";
$ObjType[10]="ArtilleryTurret";
$ObjType[11]="DisruptorTurret";
$ObjType[12]="IonTurret";

// ForceFields
$ObjType[13]="BlastFloorShape";
$ObjType[14]="doorfivebyfiveForceFieldShape";
$ObjType[15]="doorfourbyeightForceFieldShape";
$ObjType[16]="BlastDoorShape";

// Other Static Objects
$ObjType[17]="PulseSensor";
$ObjType[18]="Generator";
$ObjType[19]="SolarPanel";
$ObjType[20]="DeployableRocket";
$ObjType[21]="CloakingNode";

$ObjType[22]="VehiclePad";
$ObjType[23]="ShieldGen";
$ObjType[24]="CameraTurret";
$ObjType[25]="MobileGen";
$ObjType[26]="MobileInvent";
$ObjType[27]="InventoryStation";
$ObjType[28]="BumperTurret";
$ObjType[29]="LELFTurret";
$ObjType[30]="DeployableTeleport";
$ObjType[31]="AntiTurret";
$ObjType[32]="DiscTurret";
$ObjType[33]="PulseTurret";
$ObjType[34]="PortaC";

$ObjType[35]="AirTurret";
$ObjType[36]="PortGenerator";
$ObjType[37]="AmmoStation";
$ObjType[38]="DeployableAmmoStation";
$ObjType[39]="DeployableInvStation";
$ObjType[40]="CommandStation";
$ObjType[41]="VehicleStation";
$ObjType[42]="shieldedfivebyfiveForceFieldShape";

function GetNumObjects(%set,%type,%tnum)
{        if(%tnum==0)
                return (0);
        if(%type==4)
                return(0);

        if(%type==1)        //        Turrets only
        {        %num=0;
                %num+=CountObjects(%set,$ObjType[0],%tnum);
                %num+=CountObjects(%set,$ObjType[1],%tnum);
                %num+=CountObjects(%set,$ObjType[2],%tnum);
                %num+=CountObjects(%set,$ObjType[3],%tnum);
                %num+=CountObjects(%set,$ObjType[4],%tnum);
                %num+=CountObjects(%set,$ObjType[5],%tnum);
                %num+=CountObjects(%set,$ObjType[6],%tnum);
                %num+=CountObjects(%set,$ObjType[7],%tnum);
                %num+=CountObjects(%set,$ObjType[8],%tnum);
                %num+=CountObjects(%set,$ObjType[9],%tnum);
                %num+=CountObjects(%set,$ObjType[10],%tnum);
                %num+=CountObjects(%set,$ObjType[11],%tnum);
                %num+=CountObjects(%set,$ObjType[12],%tnum);
                return (%num);
        }
        else if(%type==2)        // Forcefields Only
        {        %num=0;
                %num+=CountObjects(%set,$ObjType[13],%tnum);

               %num+=CountObjects(%set,$ObjType[14],%tnum);
                %num+=CountObjects(%set,$ObjType[15],%tnum);
                %num+=CountObjects(%set,$ObjType[16],%tnum);
                return (%num);
        }

        else if(%type==3)        // Forcefields & Static Objects
        {        %num=0;
                %num+=CountObjects(%set,$ObjType[13],%tnum);
                %num+=CountObjects(%set,$ObjType[14],%tnum);
                %num+=CountObjects(%set,$ObjType[15],%tnum);
                %num+=CountObjects(%set,$ObjType[16],%tnum);
                %num+=CountObjects(%set,$ObjType[17],%tnum);
                %num+=CountObjects(%set,$ObjType[18],%tnum);
                %num+=CountObjects(%set,$ObjType[19],%tnum);
                %num+=CountObjects(%set,$ObjType[20],%tnum);
                %num+=CountObjects(%set,$ObjType[21],%tnum);
                %num+=CountObjects(%set,$ObjType[22],%tnum);
                %num+=CountObjects(%set,$ObjType[23],%tnum);
                %num+=CountObjects(%set,$ObjType[24],%tnum);
                %num+=CountObjects(%set,$ObjType[25],%tnum);
                %num+=CountObjects(%set,$ObjType[26],%tnum);
                %num+=CountObjects(%set,$ObjType[27],%tnum);

                %num+=CountObjects(%set,$ObjType[28],%tnum);
                %num+=CountObjects(%set,$ObjType[29],%tnum);
                %num+=CountObjects(%set,$ObjType[30],%tnum);
                %num+=CountObjects(%set,$ObjType[31],%tnum);

               %num+=CountObjects(%set,$ObjType[32],%tnum);
                %num+=CountObjects(%set,$ObjType[33],%tnum);
                %num+=CountObjects(%set,$ObjType[34],%tnum);
                %num+=CountObjects(%set,$ObjType[35],%tnum);
                %num+=CountObjects(%set,$ObjType[36],%tnum);
                %num+=CountObjects(%set,$ObjType[37],%tnum);
                %num+=CountObjects(%set,$ObjType[38],%tnum);
                %num+=CountObjects(%set,$ObjType[39],%tnum);
                %num+=CountObjects(%set,$ObjType[40],%tnum);
                %num+=CountObjects(%set,$ObjType[41],%tnum);
                %num+=CountObjects(%set,$ObjType[42],%tnum);

                return(%num);
        }
        else if(%type==0)
        {        %num=0;
                %num+=CountObjects(%set,$ObjType[0],%tnum);
                %num+=CountObjects(%set,$ObjType[1],%tnum);
                %num+=CountObjects(%set,$ObjType[2],%tnum);
                %num+=CountObjects(%set,$ObjType[3],%tnum);
                %num+=CountObjects(%set,$ObjType[4],%tnum);
                %num+=CountObjects(%set,$ObjType[5],%tnum);
                %num+=CountObjects(%set,$ObjType[6],%tnum);
                %num+=CountObjects(%set,$ObjType[7],%tnum);
                %num+=CountObjects(%set,$ObjType[8],%tnum);
                %num+=CountObjects(%set,$ObjType[9],%tnum);
                %num+=CountObjects(%set,$ObjType[10],%tnum);
                %num+=CountObjects(%set,$ObjType[11],%tnum);
                %num+=CountObjects(%set,$ObjType[12],%tnum);
                %num+=CountObjects(%set,$ObjType[13],%tnum);
                %num+=CountObjects(%set,$ObjType[14],%tnum);
                %num+=CountObjects(%set,$ObjType[15],%tnum);
                %num+=CountObjects(%set,$ObjType[16],%tnum);
                %num+=CountObjects(%set,$ObjType[17],%tnum);
                %num+=CountObjects(%set,$ObjType[18],%tnum);
                %num+=CountObjects(%set,$ObjType[19],%tnum);
                %num+=CountObjects(%set,$ObjType[20],%tnum);
                %num+=CountObjects(%set,$ObjType[21],%tnum);
                %num+=CountObjects(%set,$ObjType[22],%tnum);
                %num+=CountObjects(%set,$ObjType[23],%tnum);
                %num+=CountObjects(%set,$ObjType[24],%tnum);
                %num+=CountObjects(%set,$ObjType[25],%tnum);
                %num+=CountObjects(%set,$ObjType[26],%tnum);
                %num+=CountObjects(%set,$ObjType[27],%tnum);
                %num+=CountObjects(%set,$ObjType[28],%tnum);
                %num+=CountObjects(%set,$ObjType[29],%tnum);
                %num+=CountObjects(%set,$ObjType[30],%tnum);

                %num+=CountObjects(%set,$ObjType[31],%tnum);
                %num+=CountObjects(%set,$ObjType[32],%tnum);
                %num+=CountObjects(%set,$ObjType[33],%tnum);

                %num+=CountObjects(%set,$ObjType[34],%tnum);
                %num+=CountObjects(%set,$ObjType[35],%tnum);
                %num+=CountObjects(%set,$ObjType[36],%tnum);
                %num+=CountObjects(%set,$ObjType[37],%tnum);
                %num+=CountObjects(%set,$ObjType[38],%tnum);
                %num+=CountObjects(%set,$ObjType[39],%tnum);
                %num+=CountObjects(%set,$ObjType[40],%tnum);
                %num+=CountObjects(%set,$ObjType[41],%tnum);
                %num+=CountObjects(%set,$ObjType[42],%tnum);

                return(%num);
        }
}

//----------------------------------------------------------------------------
// Anti-Aircraft Air-Deployed Turret
//----------------------------------------------------------------------------

$InvList[AAairTurretPack]                        = 0;
$RemoteInvList[AAairTurretPack]                = 1;
$TeamItemMax[AAairTurretPack]                = 5;

$ItemMax[larmor, AAairTurretPack]        = 0;
$ItemMax[lfemale, AAairTurretPack]        = 0;
$ItemMax[marmor, AAairTurretPack]        = 1;
$ItemMax[mfemale, AAairTurretPack]        = 1;
$ItemMax[harmor, AAairTurretPack]        = 0;

ItemImageData AAairTurretPackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1;
        firstPerson = false;
};

ItemData AAairTurretPack
{
        description                = "AA Air Turret";
        shapeFile                = "camera";
        classname                = "Backpack";
	  heading =  "qAir Deployables";
        imageType                = AAairTurretPackImage;
        shadowDetailMask = 4;
        mass                        = 3.0;
        elasticity                = 0.2;
        price                        = 36050;
        hudIcon                        = "deployable";
        showWeaponBar        = true;

       hiliteOnActive        = true;
};

TurretData AirTurret
{
         classname                = "Turret";
        shapeFile                = "remoteturret";
        projectileType        = AAairShot;
        maxDamage                = 4.15;
        maxEnergy                = 150;
        minGunEnergy        = 5;
        maxGunEnergy        = 5;
        sequenceSound[0]= {"deploy", SoundActivateMotionSensor};
        reloadDelay                = 0.25;
        speed                        = 12.0;
        speedModifier        = 5.5;
        range                        = 300;
        visibleToSensor = true;
        shadowDetailMask= 4;
        dopplerVelocity = 0;
        castLOS                        = true;
        supression                = false;
        mapFilter                = 2;
        mapIcon                        = "M_turret";
        debrisId                = flashDebrisMedium;
        shieldShapeName = "shield";
        fireSound                = SoundGrogFire;
        activationSound = SoundRemoteTurretOn;
        deactivateSound = SoundRemoteTurretOff;
        explosionId                = flashExpMedium;
        description                = "AA Air Turret";
        damageSkinData        = "objectDamageSkins";
        pinger                        = false;
};

function AAairTurretPack::onUse(%player,%item)
{        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {        Player::mountItem(%player,%item,$BackpackSlot);        }
        else
        {        Player::deployItem(%player,%item); }
}

function AAairTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================

        if (AAairTurretPack::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);}
}

function AAairTurretPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
//        DeployStuff(%player,%item,AirTurret,1,8,1,1,true,false,0);
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ "AAairTurretPack"] < $TeamItemMax[AAairTurretPack])
	{
		%mTurret = newObject("","Turret",AirTurret,true);
		addToSet("MissionCleanup", %mTurret);
		GameBase::setTeam(%mTurret,GameBase::getTeam(%player));
		%pos = Vector::add(GameBase::getPosition(%player), "0 0 50");
		%rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
		GameBase::setRotation(%mTurret,%rot);
		GameBase::setPosition(%mTurret,%pos);
//		GameBase::setPosition(%mTurret,$los::position);
		Gamebase::setMapName(%mTurret,"AA Air Turret");
		Client::sendMessage(%client,0,"AA Air Turret deployed");
		playSound(SoundPickupBackpack,$los::position);
		Client::sendMessage(Player::getClient(%player),1,"AA Air Turret has been deployed 50 meters above you.");
		GameBase::playSound(%player,enterdimension,0); 
		echo("MSG: ",%client," deployed a AA Air Turret");
		Client::setOwnedObject(%client, %mturret);//these two credit kill points to the owner
		Client::setOwnedObject(%client, %player);//these two credit kill points to the owner
		$TeamItemCount[GameBase::getTeam(%player) @ "AAairTurretPack"]++;
		return true;
	}
	else
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for AA Air Turrets");
	return false;
}

function AirTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

function AirTurret::onAdd(%this)
{        schedule("AirTurret::deploy(" @ %this @ ");",1,%this);
}

function AirTurret::deploy(%this)
{        GameBase::playSequence(%this,1,"deploy");
}

function AirTurret::onEndSequence(%this,%thread)
{        GameBase::setActive(%this,true);
}

function AirTurret::onDestroyed(%this)
{        Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "AAairTurretPack"]--;
}

function AirTurret::onPower(%this,%power,%generator)
{
}

function AirTurret::onEnabled(%this)
{        GameBase::setRechargeRate(%this,35);
        GameBase::setActive(%this,true);
        %this.shieldStrength = 0.0085;
	GameBase::setAutoRepairRate(%this, 0.02);
}

//----------------------------------------------------------------------------
// Sniper Air-Deployed Turret
//----------------------------------------------------------------------------

$InvList[SniperAirTurretPack]			= 0;
$RemoteInvList[SniperAirTurretPack]		= 1;
$TeamItemMax[SniperAirTurretPack]		= 1;

$ItemMax[larmor, SniperAirTurretPack]	= 0;
$ItemMax[lfemale, SniperAirTurretPack]	= 0;
$ItemMax[marmor, SniperAirTurretPack]	= 1;
$ItemMax[mfemale, SniperAirTurretPack]	= 1;
$ItemMax[harmor, SniperAirTurretPack]	= 0;

ItemImageData SniperAirTurretPackImage
{
        shapeFile = "remoteturret";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 1;
        firstPerson = false;
};

ItemData SniperAirTurretPack
{
        description = "Sniper Air Turret";
        shapeFile = "camera";
        classname = "Backpack";
	  heading =  "qAir Deployables";
        imageType = SniperAirTurretPackImage;
        shadowDetailMask = 4;
        mass = 3.0;
        elasticity = 0.2;
        price = 75000;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

TurretData SniperAirTurret
{
	classname = "Turret";
	shapeFile =	"mortar_turret";
//	projectileType = AcidRocketTracker;
	projectileType = DropMeRocketTracker;
	maxDamage =	1.5;
	maxEnergy =	35;
	minGunEnergy = 5;
	maxGunEnergy = 5;
	sequenceSound[0]= {"deploy", SoundActivateMotionSensor};
//	reloadDelay = 15;
	reloadDelay = 10;
	speed = 12.0;
	speedModifier = 5.5;
	range = 900;
	visibleToSensor = true;
	shadowDetailMask= 4;
	dopplerVelocity = 0;
	castLOS = true;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = flashDebrisMedium;
	shieldShapeName = "shield";
	fireSound = SoundEnergyTurretFire;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId = flashExpMedium;
	description = "Sniper Air Turret";
	damageSkinData = "objectDamageSkins";
	supression = false;
	supressable = false;  //these 2 make it motion sensor
	pinger = false;       //these 2 make it motion sensor
};

function SniperAirTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function SniperAirTurretPack::onDeploy(%player,%item,%pos)
{
//=======v========== this works best ====================v==================
	//put this in function XXXXXXXXXXXPack::onDeploy(%player,%item,%pos)
	%client = Player::getClient(%player);
	%playerTeam = $teamFlag[GameBase::getTeam(%player)];
	for(%i = 0; %i < getNumTeams(); %i = %i + 1)
	{
		%oteam = $teamFlag[%i];
		if(%oteam != %playerTeam)
		{
			%enemyflag = %oteam;
			%playerPos = GameBase::getPosition(%player);
			%enemyflagpos = %enemyflag.originalPosition;
			%myflagpos = %playerTeam.originalPosition;
			%halfway = Vector::getDistance(%enemyflagpos, %myflagpos);//new line
			%halfway *= 0.45;
			if(Vector::getDistance(%enemyflagpos, %playerpos) < %halfway)
			{
				Client::sendMessage(%client,0,"You are " @ Vector::getDistance(%enemyflagpos, %playerpos) @ "m from the enemy flag.  You must be " @ %halfway @ "m or farther from it to deploy offensive stuff.");
				return ;
			}
		}
	}
//=======^========== this works best ====================^==================
	if (SniperAirTurretPack::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function SniperAirTurretPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ "SniperAirTurretPack"] < $TeamItemMax[SniperAirTurretPack])
	{
		%mTurret = newObject("","Turret",SniperAirTurret,true);
		addToSet("MissionCleanup", %mTurret);
		GameBase::setTeam(%mTurret,GameBase::getTeam(%player));
		%pos = Vector::add(GameBase::getPosition(%player), "0 0 450");
		%rot = Vector::add(GameBase::getRotation(%player), "3.14 0 0");
		GameBase::setRotation(%mTurret,%rot);
		GameBase::setPosition(%mTurret,%pos);
		Gamebase::setMapName(%mTurret,"Sniper Air Turret");
		Client::sendMessage(%client,0,"Sniper Air Turret deployed");
		playSound(SoundPickupBackpack,$los::position);
		Client::sendMessage(Player::getClient(%player),1,"Sniper Air Turret has been deployed 450 meters above you.");
		GameBase::playSound(%player,enterdimension,0); 
		echo("MSG: ",%client," deployed a Sniper Air Turret");
		Client::setOwnedObject(%client, %mturret);//these two credit kill points to the owner
		Client::setOwnedObject(%client, %player);//these two credit kill points to the owner
		$TeamItemCount[GameBase::getTeam(%player) @ "SniperAirTurretPack"]++;
		return true;
	}
	else
	{
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for Sniper Air Turrets");
		return false;
	}
}

function SniperAirTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

function SniperAirTurret::onAdd(%this)
{        schedule("SniperAirTurret::deploy(" @ %this @ ");",1,%this);
}

function SniperAirTurret::deploy(%this)
{        GameBase::playSequence(%this,1,"deploy");
}

function SniperAirTurret::onEndSequence(%this,%thread)
{        GameBase::setActive(%this,true);
}

function SniperAirTurret::onDestroyed(%this)
{        Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "SniperAirTurretPack"]--;
}

function SniperAirTurret::onPower(%this,%power,%generator)
{
}

function SniperAirTurret::onEnabled(%this)
{        GameBase::setRechargeRate(%this,35);
        GameBase::setActive(%this,true);
//        %this.shieldStrength = 0.001;
	GameBase::setAutoRepairRate(%this, 0.01);
}

//----------------------------------------------------------------------------
// Satchel Charge
//----------------------------------------------------------------------------

ItemImageData SatchelChrgPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 0.5;
	firstPerson = false;
};

ItemData SatchelChrgPack
{
	description = "Satchel Charge";
	shapeFile = "remoteturret";
	className = "Backpack";
	heading = "pTurrets";
	imageType = SatchelChrgPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.2;
	price = 2000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SatchelChrgPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function SatchelChrgPack::onDeploy(%player,%item,%pos)
{
	if (SatchelChrgPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function SatchelChrgPack::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
//        DeployStuff(%player,%item,SatchelCharge,1,8,1,1,true,false,0);
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,8)) {
                        %obj = getObjectType($los::object);
                        if (%obj == "SimTerrain" || %obj == "InteriorShape"|| GameBase::getDataName($los::object) == "BlastFloorShape")  {
                                %prot = GameBase::getRotation(%player);
                                %zRot = getWord(%prot,2);
                                if (Vector::dot($los::normal,"0 0 1") > 0.6) {
                                        %rot = "0 0 " @ %zRot;
                                }
                                else {
                                        if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
                                                %rot = "3.14159 0 " @ %zRot;

                                        }
                                        else {
                                                %rot = Vector::getRotation($los::normal);
                                        }
                                }
                                if(checkDeployArea(%client,$los::position)) {
                                        %camera = newObject("Satchel Charge","Turret",SatchelCharge,true);
  			                      addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
                                        GameBase::setRotation(%camera,%rot);
                                        GameBase::setPosition(%camera,$los::position);
                                        Gamebase::setMapName(%camera,"Satchel Charge#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
                                        Client::sendMessage(%client,0,"Satchel Charge deployed");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%camera) @ "SatchelChrgPack"]++;
					 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ "SatchelChrgPack"] @ " out of " @ $TeamItemMax["SatchelChrgPack"] @ " Satchel Charges now deployed.");//warcan testing this
                                        echo("MSG: ",%client," deployed a Satchel Charge");
                                        return true;
                                }
                        }
                        else {
                                Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
                        }
                }
                else {
                        Client::sendMessage(%client,0,"Deploy position out of range");
                }
        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}

function DeploySatchel( %clientId, %player, %item) 
{ 
	%item = "SatchelPack";
        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,SatchelCharge,1,8,1,1,true,false,0);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");//warcan testing this
}

function SatchelCharge::onAdd(%this)
{
	schedule("SatchelCharge::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,0.1);
//-----------------see-if-this-cloaks-this-turret-------------------------
		 	GameBase::startFadeout(%this);
		 	$cloaked[%this] = 1;
//-----------------see-if-this-cloaks-this-turret-------------------------
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Satchel Charge");
	}
}

function SatchelCharge::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function SatchelCharge::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function SatchelCharge::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "SatchelChrgPack"]--;
}

// Override base class just in case.
function SatchelCharge::onPower(%this,%power,%generator) {}
function SatchelCharge::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,0.1);
	GameBase::setActive(%this,true);
}

$InvList[SatchelChrgPack] = 1;
$RemoteInvList[SatchelChrgPack] = 1;

$TeamItemMax[SatchelChrgPack] = 15;

$ItemMax[marmor, SatchelChrgPack] = 1;
$ItemMax[mfemale, SatchelChrgPack] = 1;
$ItemMax[larmor, SatchelChrgPack] = 0;
$ItemMax[lfemale, SatchelChrgPack] = 0;
$ItemMax[harmor, SatchelChrgPack] = 0;

//---------------------------------------------------------
// Jail
//---------------------------------------------------------

$InvList[jailpack] = 0;
$RemoteInvList[jailpack] = 1;

$TeamItemMax[jailpack] = 1;

$ItemMax[harmor, jailpack] = 0;
$ItemMax[marmor, jailpack] = 1;
$ItemMax[mfemale, jailpack] = 1;
$ItemMax[larmor, jailpack] = 0;
$ItemMax[lfemale, jailpack] = 0;

ItemImageData jailpackImage
{
	shapeFile = "ammopack";
	mountPoint = 2;
	mountOffset = { 0, 0, 0 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};
ItemData jailpack
{
	description = "Air Jail";
	shapeFile = "shieldpack";
	className = "Backpack";
	heading =  "qAir Deployables";
	imageType = jailpackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 10000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function jailpack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function jailpack::onDeploy(%player,%item,%pos)
{
        if (jailpack::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}
function CreatejailportSimSet()
{
    %teleset = nameToID("MissionCleanup/jailports");
        if(%teleset == -1)
        {
                newObject("jailports",SimSet);
                addToSet("MissionCleanup","jailports");
        }
}

function jailpack::deployshape(%player,%item)
{
	GameBase::getLOSInfo(%player,8);
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ "jailpack"] >= $TeamItemMax[jailpack])
	{
		Client::sendMessage(%client,0,"Can Not Deploy. A Jail Cell Already In Place");
		return false;
	}

	if(%player.outArea == 1)
	{
		Client::sendMessage(%client,0,"Can Not Deploy Jail Cell OFF the map.");
		return false;
	}

                %playerPos = GameBase::getPosition(%player);
                %flag = $teamFlag[GameBase::getTeam(%player)];
                %flagpos = gamebase::getPosition(%flag);
                %obj = getObjectType($los::object);
                %set = newObject("Jail",SimSet);
                %num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$ForceFieldBoxMinLength,$ForceFieldBoxMinWidth,$ForceFieldBoxMinHeight,0);
                %num = CountObjects(%set,"Jail",%num);



                %objDevice =   newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide1 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide2 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide3 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide4 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide5 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide6 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide7 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide8 = newObject("Jail","StaticShape",JailSwitchOpen,true);
                %objDevice.objSide9 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide10 = newObject("Jail","StaticShape",JailSwitchClose,true);


                %objDevice.objSide1.objParent = %objDevice;
                %objDevice.objSide2.objParent = %objDevice;
                %objDevice.objSide3.objParent = %objDevice;
                %objDevice.objSide4.objParent = %objDevice;
                %objDevice.objSide5.objParent = %objDevice;
                %objDevice.objSide6.objParent = %objDevice;
                %objDevice.objSide7.objParent = %objDevice;
                %objDevice.objSide8.objParent = %objDevice;
                %objDevice.objSide9.objParent = %objDevice;
                %objDevice.objSide10.objParent = %objDevice;


                 addToSet(MissionCleanup, %objDevice);
                 addToSet(MissionCleanup, %objDevice.objSide1);
                 addToSet(MissionCleanup, %objDevice.objSide2);
                 addToSet(MissionCleanup, %objDevice.objSide3);
                 addToSet(MissionCleanup, %objDevice.objSide4);
                 addToSet(MissionCleanup, %objDevice.objSide5);
                 addToSet(MissionCleanup, %objDevice.objSide6);
                 addToSet(MissionCleanup, %objDevice.objSide7);
                 addToSet(MissionCleanup, %objDevice.objSide8);
                 addToSet(MissionCleanup, %objDevice.objSide9);
                 addToSet(MissionCleanup, %objDevice.objSide10);

                %pos = Vector::add(GameBase::getPosition(%player), "0 1 2080");
                GameBase::setRotation(%objDevice.objSide1,"0 0 0");
                GameBase::setPosition(%objDevice.objSide1,%pos);
                GameBase::setTeam(%objDevice.objSide1,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "-5.5 6.5 2080");
                GameBase::setRotation(%objDevice.objSide2,"0 0 4.71339");
                GameBase::setPosition(%objDevice.objSide2,%pos);
                GameBase::setTeam(%objDevice.objSide2,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "5.5 6.5 2080");
                GameBase::setRotation(%objDevice.objSide3,"0 0 4.71339");
                GameBase::setPosition(%objDevice.objSide3,%pos);
                GameBase::setTeam(%objDevice.objSide3,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "0 12.5 2086");
                 GameBase::setRotation(%objDevice.objSide4,"-4.71339 0 0");
                 GameBase::setPosition(%objDevice.objSide4,%pos);
                 GameBase::setTeam(%objDevice.objSide4,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "0 .5 2086");
                 GameBase::setRotation(%objDevice,"4.71339 0 0");
                 GameBase::setPosition(%objDevice,%pos);
                 GameBase::setTeam(%objDevice,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "0 12.5 2080");
                GameBase::setRotation(%objDevice.objSide6,"-4.71339 0 0");
                GameBase::setPosition(%objDevice.objSide6,%pos);
                GameBase::setTeam(%objDevice.objSide6,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "0 .5 2080");
                 GameBase::setRotation(%objDevice.objSide7,"4.71339 0 0");
                 GameBase::setPosition(%objDevice.objSide7,%pos);
                 GameBase::setTeam(%objDevice.objSide7,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "-5 13 2080.00");
                 GameBase::setRotation(%objDevice.objSide8,"0 0 0");
                 GameBase::setPosition(%objDevice.objSide8,%pos);
                 GameBase::setTeam(%objDevice.objSide8,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "0 18 2080");
                 GameBase::setRotation(%objDevice.objSide9,"-4.71339 0 0");
                 GameBase::setPosition(%objDevice.objSide9,%pos);
                 GameBase::setTeam(%objDevice.objSide9,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "5 13 2080.00");
                 GameBase::setRotation(%objDevice.objSide10,"0 0 0");
                 GameBase::setPosition(%objDevice.objSide10,%pos);
                 GameBase::setTeam(%objDevice.objSide10,GameBase::getTeam(%player));

                playSound(SoundPickupBackpack,$los::position);

               newObject("jaildoor",SimSet);
                addToSet("MissionCleanup","jaildoor");
                %sensor = newObject("jaildoor","StaticShape",jLargeForceField,true);

                addToSet("MissionCleanup/jaildoor", %sensor);
                addToSet("MissionCleanup", %sensor);
                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                %pos = Vector::add(GameBase::getPosition(%player), "0 12 2080");
                GameBase::setPosition(%sensor,%pos);
                GameBase::setRotation(%sensor,"0 0 0");
                %sensor.disabled = false;
                playSound(SoundPickupBackpack,$los::position);


		    %sensor = newObject("Teleport Pad","StaticShape","jailStand",true);
                CreatejailportSimSet();
                addToSet("MissionCleanup/jailports", %sensor);
                addToSet("MissionCleanup", %sensor);
                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                %pos = Vector::add(GameBase::getPosition(%player), "0 3 2081");
                GameBase::setPosition(%sensor,%pos);
                Gamebase::setMapName(%sensor,%name);

                %sensor.disabled = false;
                playSound(SoundPickupBackpack,$los::position);

                %beam = newObject("","StaticShape",ElectricalBeamBig,true);
                addToSet("MissionCleanup", %beam);
                GameBase::setTeam(%beam,GameBase::getTeam(%player));
                GameBase::setPosition(%beam,%pos);
                %sensor.beam1 = %beam;
                playSound(SoundPickupBackpack,$los::position);

                %sensor = newObject("releasepad","StaticShape","jailStandTop",true);
                CreatereleasepadSimSet();
                addToSet("MissionCleanup/releasepad", %sensor);
                addToSet("MissionCleanup", %sensor);
                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                %pos = Vector::add(GameBase::getPosition(%player), "0 3 2086.30");
                GameBase::setPosition(%sensor,%pos);
                Gamebase::setMapName(%sensor,%name);

                %sensor.disabled = false;
                    playSound(SoundPickupBackpack,$los::position);

                $TeamItemCount[GameBase::getTeam(%sensor) @ "jailpack"]++;
                echo("MSG: ",%client," deployed a Jail Cell");
                Client::sendMessage(%client,0,%item.description @ " deployed Somewhere......!");

                return true;
}

function CreatereleasepadSimSet()
{
	%teleset = nameToID("MissionCleanup/releasepad");
	if(%teleset == -1)
	{
		newObject("releasepad",SimSet);
		addToSet("MissionCleanup","releasepad");
	}
}

//----------------------------------------------------------------------------
// Jail Capture Pad
//----------------------------------------------------------------------------

$InvList[jailcappack] = 0;
$RemoteInvList[jailcappack] = 1;

$TeamItemMax[jailcappack] = 20;

$ItemMax[harmor, jailcappack] = 0;
$ItemMax[marmor, jailcappack] = 1;
$ItemMax[mfemale, jailcappack] = 1;
$ItemMax[larmor, jailcappack] = 0;
$ItemMax[lfemale, jailcappack] = 0;

ItemImageData JailCapPackImage
{
	shapeFile = "flagstand";
	mountPoint = 2;
	mountOffset = { 0, -0.5, -0.3 };
	mountRotation = { 0, 1.57, 0 };
	mass = 1.5;
	firstPerson = false;
};

ItemData JailCapPack
{
	description = "Jail Capture Pad";
	shapeFile = "flagstand";
	className = "Backpack";
	heading =  "lDeployables";
	imageType = JailCapPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function JailCapPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function JailCapPack::onDeploy(%player,%item,%pos)
{
        if (JailCapPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
        }
}
function JailCapPack::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,8)) {

                        %obj = getObjectType($los::object);

                                        %camera = newObject("","StaticShape","jailpad",true);
                                        addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
						    %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
						    GameBase::setRotation(%camera,%rot);
						    GameBase::setPosition(%camera,$los::position);
                                        Gamebase::setMapName(%camera,"JailPad " @ $totalNumCameras++ @ " " @ Client::getName(%client));
//                                        Client::sendMessage(%client,0,"Jail Pad Deployed");
						    Client::sendMessage(%client,0,"Jail Pad Deployed~wwnoway.wav");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%player) @ "JailCapPack"]++;
                                        echo("MSG: ",%client," deployed a Jail Pad");
                                        return true;

                        }
                       else {
                                Client::sendMessage(%client,0,"Cannot deploy here.");
                        }

        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}

//****************************************************

function ConnectGenerator (%this,%client)
{	if($TracePwr) echo("Connect this ",%this," Generator to Power Grid (Client = ",%client,")");
	if(%this.isBusy)
		return;
	%name=GameBase::GetMapName(%this);
	if(!%name)
		%name=GameBase::GetDataName(%this);

	if(GameBase::getDamageState(%this)!="Enabled")
	{	echo("Backup Generator ",%this," is disabled!!");
		TeamMessages(0,%team,%name@" DIS-ABLED Unable to come ON Line...~wAAODSFX50.wav");
		return;
	}

	%range = %this.pRange;
	ItemBusy(%this);
	%team = GameBase::getTeam(%this);
	echo("Connecting Generator for Team ",%team);
	echo("Connecting Generator for Client ",$User[%client]);

	
	if(%this.pset)
	{	// Generator has a powerset....refresh it
		%pset=%this.pset;
		if($tracePwr) echo("Generator ",%this," has a power set (",%pset,") ....Refreshing");
	}
	else	// Generator does not have a powerset Create one & refresh it
	{	%pset=MakePowerSet(%this);
		%this.powerset=getGroup(%this);
		removeFromSet(%this.powerset,%this);
		addtoSet(%pset,%this);
		%this.pset=%pset;
	}
	// Scan for Items to Power
	%set = newObject("set",SimSet);
	%pos =	GameBase::getPosition(%this);
	%tnum = containerBoxFillSet(%set,$StaticObjectType | $StaticShapeType ,%pos,%range,%range,%range,0);
	%td=0;
	if (%tnum>0)
	{	// There are Items within scan range
		if($tracePwr) echo($Ver,"| Generator Checking ",%tnum," items");
		for (%i=0;%i<%tnum;%i++)
		{	%tgt=Group::getObject(%set,%i);
			%tgtTeam=GameBase::getTeam(%tgt);
			if(PowerReq(%tgt))									// Does Item Require Power then check otherwise don't Bother
			{	if(%team==%tgtTeam)								// Is it of the Same Team
				{	if (!GameBase::isPowered(%tgt))				// Has NO Power so Connect to it!
					{	%td+=0.3;									// Time to hookup = 3 Sec
						if(%tgt.powerSet=="")					// This Item has Not Been previously Connected to a Portable Generator
						{	%tgt.powerSet=getGroup(%tgt);			// If it Had Power Remeber where it Was from
						}
						if($tracePwr) echo($Ver,"|Item Has No Power - Removing from Old group ",%tgt.powerSet," adding to ",%pset);
						schedule("PowerSet("@%this@","@%tgt@");",%td);
					}
				}
			}			
		}
	}
	deleteObject(%set);
	schedule("ItemNotBusy("@%this@");",%td);
	if (%td==0)
	{	if(%client)
			Client::SendMessage(%client,3,"Backup power grid Initialized");
		return (false);
	}
	else
		TeamMessages(3,%team,%name@" coming ON line...~wAAODSFX50.wav");
	return (true);
}

function DisconnectGenerator(%this)	
{	if($TracePwr) echo("Disconnecting this ",%this," Generator from Power Grid");
	//	Use when Packing up a Power Generator
	//	& End of Mission 
	//	Unhooks everything
	ItemBusy(%this);
	%pset=%this.pset;
	%name=GameBase::GetMapName(%this);
	if(!%name)
		%name=GameBase::GetDataName(%this);
	%team = GameBase::getTeam(%this);
	%tnum = Group::objectCount(%pset);
	TeamMessages(1,%team,%name@" going OFF line...~wAAODSFX50.wav");
	%td=0;
	if (%tnum>0)
	{	for (%i=0;%i<%tnum;%i++)
		{	%tgt=Group::getObject(%pset,0);
			%td+=2;
			schedule("PowerReset("@%this@","@%tgt@");",%td);
		}
	}
	%td+=1;
	schedule("deleteObject("@%pset@");",%td);
	schedule("ItemNotBusy("@%this@");",%td,%this);
	return (%td);
}


function PowerReq(%this)
{	
	%name=GameBase::GetDataName(%this);
	if(%this.powerReq==1) 
		return true;
	else if(%this.powerReq==false) 
		return false;
	else if(%name.classname == "Turret" || %name.classname == "Station" || %name=="PulseSensor" )
		return (true);
	else
		return (false);
}

function RecheckGrid(%this)
{	if($TracePwr) echo("RE-Connect this ",%this," Generator to Power Grid ");
	// Call When Main Power Source has come back online after a failure
	%mset=getGroup(%this);
	%team=GameBase::getTeam(%this);
	%tnum = Group::objectCount($GenSet[%team]);
	if ($tracePwr) echo($ver,"| Main Gen ",%this," Back on line .. re-routing power from ",%tnum," alternate Generators for Team ",%team);
	if (%tnum>0)
	{	for (%i=0;%i<%tnum;%i++)
		{	%tgt=Group::getObject($GenSet[%team],%i);
			%num = Group::objectCount(%tgt.pset);
			if(%num>1)	// If it has more than one object the unit is powering something
			{	for (%j=0;%j<%num;%j++)
				{	%tgt2=Group::getObject(%tgt.pset,%j);
					if(%tgt2.powerset==%mset)	// Object belong in the Power Set for %this which was just restored
					{	removeFromSet(%tgt.pset,%tgt2);
						addToSet(%mset,%tgt2);
						%j--;
						%num--;
					}
				}
			}
		}
	}
}

function EngageBackupPower(%this)
{	if($tracePwr) echo("Engage Backup Power for this ",%this," Generator (It has Been Destroyed or Disabled)");
	%NumFF=0;
	// Call When Main Power has Experienced a failure
	// Check Main Generator Group... If Multiple generators Then Dont Engage Backup
	%Mainset=getGroup(%this);
	%MainNum = Group::objectCount(%MainSet);
	if($tracePwr) echo("Generator Group = ",%MainSet," Number of Items in Group ",%MainNum);
	for (%i=0;%i<%MainNum;%i++)
	{	%tgt=Group::getObject(%MainSet,%i);
		%name = GameBase::getDataName(%tgt);
		%type = GetObjectType(%tgt);
		// if(%name=="" && %type == SimGroup) %name="DoorGroup";
		if($tracePwr) echo("Checking Item ",%tgt," Item is: ",%Name," Class = ",%name.className," type ",%type);
		if(%name == "Generator" || %name == "SolarPanel" || %name == "PortGenerator")
		{	%result=GameBase::getDamageState(%tgt);	
			if(%result==Enabled) %NotReq=True;
		}
		else if(%name=="DoorGroup" || %name.classname == "ForceDoor" || %name.classname == "Door" || %name.classname == "ForceField")
		{	if($TracePwr) echo("Re-Routing ForceField Power for ",%name," Id# ",%tgt);
			%ForceField[%NumFF]=%tgt;
			%NumFF++;
		}
		if(%NotReq==true) %i=%MainNum;
	}

	if(%NotReq) return;
	%team=GameBase::getTeam(%this);
	%tnum = Group::objectCount($GenSet[%team]);
	if ($tracePwr) echo($ver,"| Main Gen ",%this," FAILURE .. ",%tnum," alternate Generators re-checking Grid ",%team);
	%td=0;
	if (%tnum>0)
	{	for (%i=0;%i<%tnum;%i++)
		{	%td+=2;
			%tgt=Group::getObject($GenSet[%team],%i);
			// ForceField Reconnect Routine
			// First Active Generator Gets the ForceFields
			%result=GameBase::getDamageState(%tgt);	
			if(GameBase::getDamageState(%tgt) == "Enabled")
			{	for (%j=0;%j<%NumFF;%j++)
				{	%ff=%ForceField[%j];
					%ff.powerSet=getGroup(%ff);			// Remember where it Was from
					PowerSet(%tgt,%ff);
					//schedule("PowerSet("@%tgt@","@%ff@");",5,%ff);
					if ($tracePwr) echo($ver,"| Routing Power for ",%ff," Forcefield to ",GetGroup(%tgt));
					
				}
			}
			schedule("ConnectGenerator("@%tgt@", false);",%td);
		}
	}
}

function MakePowerSet(%this)
{	%SetName ="PG"@%this;
	%pset= newObject(%SetName,SimGroup);
	addToSet("MissionCleanup", %pset);
	if($tracePwr) echo("Created NEW power set (",%pset,") for Generator ",%this);
	return(%pset);
}

function Powerset(%gen,%object)
{	%gname=GameBase::GetMapName(%gen);
	if(!%gname)
		%gname=GameBase::GetDataName(%gen);
	%pset=%gen.pset;
	%mname = GameBase::getMapName(%object);
	if(%mname=="")							
		%mname = GameBase::getDataName(%object);
	%team=GameBase::getTeam(%gen);
	TeamMessages(3,%team,"Power for "@%mname@" routed to: "@%gname@"~wAAODSFX52.wav");
	%OldSet=getGroup(%object);
	RemoveFromSet(%OldSet,%object);
	%res=AddToSet(%pset,%object);
	if ($tracePwr) echo("Power for "@%object@" routed to power group "@%pset@" generator "@%gen@" for Team ",%team);
}

function Powerreset(%gen,%object)
{	%gname=GameBase::GetMapName(%gen);
	if(!%gname)
		%gname=GameBase::GetDataName(%gen);
	%pset=%gen.pset;
	%mname = GameBase::getMapName(%object);
	if(%mname=="")							
		%mname = GameBase::getDataName(%object);
	%team=GameBase::getTeam(%gen);
	if(%object.powerReq!=2)
		TeamMessages(1,%team,"Power for "@%mname@" disconnected from "@%gname@"~wAAODSFX52.wav");
	removeFromSet(%pset,%object);
	%res=addToSet(%object.powerSet,%object);
	if ($tracePwr) echo("Power for ",%object," set to orignal group ",%object.powerSet," from  generator ",%gen," for Team ",%team);
}


function PowerItem (%this,%range,%client)
{	if($TracePwr) echo($ver,"|Looking for POWER for ",%this," in a ",%range," meter area");
	//** Search Area within specified range
	//** If a Main Generator exists Draw power from that
	//** If a portable generator exists Place %this into the power set for it..
	%numGen=0;
	%team = GameBase::getTeam(%this);
	%set = newObject("set",SimSet);
	%pos =	GameBase::getPosition(%this);
	%tnum = containerBoxFillSet(%set, $StaticObjectType ,%pos,%range,%range,%range,0);
	echo(" Number of Objects Found = ",%tnum);
	if (%tnum>0)
	{	// There are Items within scan range
		if($trace) echo($Ver,"|Scanning ",%tnum," items");
		for (%i=0;%i<%tnum;%i++)
		{	%tgt=Group::getObject(%set,%i);
			%tgtTeam=GameBase::getTeam(%tgt);
			%name = GameBase::getDataName(%tgt);
			if(%team==%tgtTeam)	
			{	if(%name == "Generator" || %name == "SolarPanel" || %name == "PortGenerator")
				{	%nset=getGroup(%tgt);
					if(GameBase::getDamageState(%tgt) == "Enabled")
					{	Client::sendMessage(%client,3,"Main Power connection found... connecting...~wAAODSFX16.wav");
						if($tracePwr) echo($Ver,"| Found MAIN Generator : Group ",%nset," Placing Unit in Group");	
						// %power=true;
						if(%nset)
						{	addToSet(%nset,%this);
							%this.powerset=%nset;
							%i=%tnum;
						}
						%numGen++;
					}
					else if(%nset) %this.powerset=%nset;	// Route Main Connection to Main Power Group...

				}
				else if(%name == "MobileGen" || %name == "PortaSolar" || %name == "PowerNode")
				{	if($tracePwr) echo($Ver,"|Found an alternate Power Source.. if needed ",%tgt);

				%Pgen=%tgt;	
				}
					
			}
			
		}
	}
	deleteObject(%set);
	if (%numGen==0)										// If there are No Main Generators to connect to... then
	{	if(%Pgen)										// If there is a portable Power Source connect to it
		{	if($trace) echo($Ver,"|Found a Secondary power Generator ",%PGen," Connecting to it");
			Client::sendMessage(%client,3,"Secondary Power connection found... connecting...");
			%result=GameBase::getDamageState(%Pgen);	// Check state of Generator
			%nset=getGroup(%Pgen);
			if(%nset)
				addToSet(%nset,%this);
			//if(%result==Enabled)
				// %power=true;
			//else
				// %power=false;
			// GameBase::virtual(%this,"onPower",%power,%Pgen);
			return (true);
		}
		else
		{	Client::sendMessage(%client,1,"Warning! This item is not within range of a Generator!!~werror_message.wav");
			return (false);
		}

	}
	return (true);
}

