function Blaster::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.Blaster == 0)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.15\nFire Rate: 0.15 seconds\nBasic light-duty weapon.  Current setting:<f1> Standard Fire Mode<f0>.", $DisplayTime);
	}
	else if (%playerId.Blaster == 1)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.1\nFire Rate: 0.15 seconds\nFires a 3-shot spread. Each projectile is 66% of regular bolts.\nUses 3x the energy.  \nCurrent setting:<f1> Triple Shot Mode<f0>.", $DisplayTime);
	}
	else if (%playerId.Blaster == 2)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.75\nFire Rate: 0.15 seconds\nFires the Super-Blaster shot. Higher energy per shot required.\nCurrent setting:<f1> Super-Blaster Mode<f0>.", $DisplayTime);
	}
}

function VertigoCannon::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.Gep == 0)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>Guided Energy Projectile gun\n<f0>Damage per shot: 0.125\nFire Rate: 0.8 seconds\nSpecial Ability: Rocket Launcher designed specifically to tracks for everyone.\nCurrent setting:<f1> Energy-based<f0> damage.", $DisplayTime);
	}
	else if (%playerId.Gep == 1)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>Guided Energy Projectile gun\n<f0>Damage per shot: 0.1\nFire Rate: 0.8 seconds\nSpecial Ability: Rocket Launcher designed specifically to tracks for everyone.\nCurrent setting:<f1> Flame-based<f0> damage.", $DisplayTime);
	}
	else if (%playerId.Gep == 2)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>Guided Energy Projectile gun\n<f0>Damage per shot: 0\nFire Rate: 0.8 seconds\nSpecial Ability: Rocket Launcher designed specifically to tracks for everyone.\nCurrent setting:<f1> Knock-back<f0> ONLY.", $DisplayTime);
	}
}

function AALaser::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.razor == 0)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nDamage per shot: <f0>0.5   <f1>Fire Rate: <f0>0.6 seconds\n<f1>Amplifies targets' internal temperature.\nCurrent setting:<f0> Flaming<f1> mode.", $DisplayTime);
	}
	else if (%playerId.razor == 1)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nDamage per shot: <f0>0.25   <f1>Fire Rate: <f0>0.6 seconds\n<f1>Disintegrates targets' ammunition.\nCurrent setting:<f0> HellFire<f1> mode.", $DisplayTime);
	}
	else if (%playerId.razor == 2)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nDamage per shot: <f0>1.0   <f1>Fire Rate: <f0>0.6 seconds\n<f1>Armor-piercing beam does minor damage to light armors, medium damage to medium armors,\nand a considerable amount to heavies.  Current setting:<f0> Armor-piercing<f1> mode.", $DisplayTime);
	}
	else if (%playerId.razor == 3)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nDamage per shot: <f0>0.1 <f1>(to players)   Fire Rate: <f0>0.6 seconds\n<f1>Very strong against doors and turrets, but not much else.\nCurrent setting:<f0> Door Buster<f1> mode.", $DisplayTime);
	}
}

function PBW::onUse(%player,%item)
{
	if(Player::getMountedItem(%player,$BackpackSlot) != Accelerator)
	{
		Client::sendMessage(Player::getClient(%player),1,
		"Must have Particle Accelerator to use PBW."); 
	}
	else
	{
		Weapon::onUse(%player,%item);
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nDamage per shot: <f0>1.1   <f1>Fire Rate: <f0>1.0 seconds\n<f1>High-powered particle beam punches holes in all armors.\nMust have the <f2>Accelerator Pack<f1> mounted to use it.", $DisplayTime);
	}
}

function Charger::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per second: 0.625  <f1>EnergyDrain: 175\n<f0>Fire Rate: 0.1 seconds   <f1>Bolt length:  200m", $DisplayTime);
}

function Reassembler::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%armor = Player::getArmor(%player);
	if(%armor == "marmor" || %armor == "mfemale")
	{ 
		bottomprint(Player::getClient(%player), "<jc><f1>Mega Repair Gun\n<f1>Repair Rate: <f0>2.2 per second <f1>EnergyDrain: 13\n<f1>Fire Rate: <f0>0.1 seconds   <f1>Bolt length:  <f0>400m\n<f1>The Mechanic gets the <f2>Mega Repair Gun<f1> in place of the Reassembler.", $DisplayTime);
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f1>Repair Rate: <f0>0.2 per second <f1>EnergyDrain: 5\n<f1>Fire Rate: <f0>0.1 seconds   <f1>Bolt length:  <f0>50m\n<f1>Repairs you, other players and other busted stuff.", $DisplayTime);
	}
}

function ElectricityRifle::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f1><jc>Bolt length:  <f0>20m\n<f1><jc>Provides power to items when your generator has been disabled.", $DisplayTime);
}

function OmegaRifle::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.homewreck == 0)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nCurrent Setting: <f0>Omega <f1>mode.    <f1>Bolt length:  <f0>10m \n<f1>Drains target's health and transfers to your health.\nTransfer Rate: <f0>0.25 <f1>health per second", $DisplayTime);
	}
	else if (%playerId.homewreck == 1)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nCurrent Setting: <f0>Pull beam <f1>mode.    <f1>Bolt length:  <f0>200m \n<f1>Pulls you towards your foe or some object.\nPoint it at <f0>turrets<f1>, <f0>sensors<f1>, <f0>generators<f1>, <f0>players<f1>, etc.", $DisplayTime);
	}
	else if (%playerId.homewreck == 2)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nCurrent Setting: <f0>Anti-Aircraft<f1>   Damage per second: <f0>3.1  <f1>EnergyDrain: <f0>75\n<f1>Fire Rate: <f0>0.1 seconds   <f1>Bolt length:  <f0>250m\n<f1>Great against those vehicles.", $DisplayTime);
	}
	else if (%playerId.homewreck == 3)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nCurrent Setting: <f0>Super Door Buster<f1>   Damage per second: <f0>25  <f1>EnergyDrain: <f0>10\n<f1>Fire Rate: <f0>0.1 seconds   <f1>Bolt length:  <f0>5m\n<f1>This is the ''kryptonite'' for Super Doors.", $DisplayTime);
	}
}

function MBCannon::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.cannon == 0)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 1.0   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Standard Mode.<f0> Fires Standard Mitzi Blast.\nHoplite is immune and so are shielded players.", $DisplayTime);	
	}
	else if (%playerId.cannon == 1)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 0.75 seconds\nCurrent setting:<f1> EMP Mode.<f0> Fires an EMP Mitzi Blast.\nKnocks down energy on most players.\nSome packs render you immune.", $DisplayTime);	
	}
	else if (%playerId.cannon == 2)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Standard Boost Mode.<f0> Fires a boost to help jet you across the field.", $DisplayTime);	
	}
	else if (%playerId.cannon == 3)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Poison Mode.<f0> Infect someone with a powerful virus.\nChat Tapper makes you immune.", $DisplayTime);	
	}
	else if (%playerId.cannon == 4)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Heat Mode.<f0> \nFires an heat blast.\nAnyone caught in this radius is ON FIRE!!\nSome packs render players immune.", $DisplayTime);	
	}
	else if (%playerId.cannon == 5)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 75   Fire Rate: 150 ammo\nCurrent setting:<f1> ANNIHILATOR<f0>   Fires the biggest blast in the game.\nOnly Myrmidon armor can fire this.\nEngineer armor is immune, but the impulse could still kill him.", $DisplayTime);	
	}
	else if (%playerId.cannon == 6)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 10.0   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Door & Turret Buster Mode.<f0> Fires a heavy duyt Mitzi blast.\nGood for taking down doors in short order.", $DisplayTime);	
	}
	else if (%playerId.cannon == 7)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: ??   Fire Rate: 0.75 seconds\nCurrent setting:<f1> * *ECSTACY * * Mode.<f0> \nFires a sheet-pile of Ecstacy shots.\nNOT good against Blastech.", $DisplayTime);	
	}
	else if (%playerId.cannon == 8)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: ??   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Anti-Aircraft Barrage <f0>Mode. \nGood at shooting down vehicles, but poor against all else.", $DisplayTime);	
	}
}

function CatGun::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.bazooka == 1)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: None   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Standard Mode.<f0> Fires a slow, rocket-assisted Beacon. \nStill based on Team max for Beacons.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 0)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.4   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Tracking Disc.<f0> Fires an Disc that can target the enemy player.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 2)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\nCurrent setting:<f1> Inversion Bomb.<f0> Tosses an <f2>Inversion Bomb<f0> that is good against destroying objects, but\ndoes NO direct damage to players.  However, it <f1>SUCKS<f0> you toward it.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 3)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.5   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Sniper Round.<f0> Fires a minor sniping bullet.\nBest to knock the weapon out of someones' hand.  Can kill mediums and light armors with a <f1>head shot<f0>.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 4)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.08   Fire Rate: 0.75 seconds\nCurrent setting:<f1> BlackHole Missile.<f0> \nFires a rocket containing some <f1>negative gravity<f0> material.  It <f2>pulls<f0> players towards the impact.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 5)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: REAL BIG   Fire Rate: 0.75 seconds\nCurrent setting:<f1> METEOR.<f0>   Launches a big rock that has a very large blast radius.\nOnly Heavy armors can fire this. It requires <f2>extra<f0> ammo to fire it.\nLike grenades, mines, and beacons.", $DisplayTime);	}
	else if (%playerId.bazooka == 6)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: varies   Fire Rate: 0.75 seconds\nCurrent setting:<f1> * * Swarmer * *.<f0> Fires a bunch of fusion-powered, Swarmer shots.\nGood against everyone except Hoplite.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 7)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.5   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Klutzy Blast Mode.<f0> \nCan cause the person to drop their carried weapon, backpack, or even the FLAG.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 8)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: ??   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Acid Bath <f0>Mode. \nNeutralizes the ''autorepair'' on most items for 60 seconds.\Can dissolve the mounted weapon.  Extra damage against Terrax armor.", $DisplayTime);	
	}
	else if (%playerId.bazooka == 9)		
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: ??   Fire Rate: 0.75 seconds\nCurrent setting:<f1> Tornado <f0>Mode. \nCreates a small whirlwind that lasts about 6 seconds.  Does no physical damage, \nbut is good for disorienting your opponent.", $DisplayTime);	
	}
}

function EnergyRifle::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per second: 0.55  <f1>EnergyDrain: 200\n<f0>Fire Rate: 0.1 seconds   <f1>Bolt length:  100m", $DisplayTime);
}

function SuperELF::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per second: 3.55  <f1>EnergyDrain: 450\n<f0>Fire Rate: 0.1 seconds   <f1>Bolt length:  50m", $DisplayTime);
}

function Chaingun::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.chaingun == 0) {
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.11   Fire Rate: 0.2 seconds\nCurrent setting:<f1> Standard Mode.<f0> Fires regular bullets. \nUnlimited ammo.", $DisplayTime);	}
	else if (%playerId.chaingun == 1){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.11   Fire Rate: 0.2 seconds\nCurrent setting:<f1> Vulcan Mode.<f0> Fires extra amount of bullets. \nUses 1 ammo per shot.", $DisplayTime);	}
	else if (%playerId.chaingun == 2){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.11   Fire Rate: 0.2 seconds\nCurrent setting:<f1> Flamer Mode.<f0> Fires Flames. \nUses extra ammo. Peltast is immune to flames.", $DisplayTime);	}
	else if (%playerId.chaingun == 3){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.11   Fire Rate: 0.2 seconds\nCurrent setting:<f1> Fusion & Energy Mode.<f0>\n Fires Fusion and Energy shots. Uses extra ammo.\nThis setting is the HEAVY ARMOR killer.", $DisplayTime);	}
	else if (%playerId.chaingun == 4){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.11   Fire Rate: 0.2 seconds\nCurrent setting:<f1> Ecstacy Mode.<f0> Fires Ecstacy shot. \nUses extra ammo.\nThis setting is uesless against Blastech.", $DisplayTime);	}
}

function Gauss::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.gauss == 0)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.22\nFire Rate: 0.2 seconds\nAn explosive, cutting round.  Twice as devastating as chaingun fire.\nCurrent setting:<f1> Standard Fire Mode<f0>.", $DisplayTime);
	}
	else if (%playerId.gauss == 1)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.22\nFire Rate: 0.2 seconds\nAn explosive, cutting round.  Twice the rounds of Standard mode.\nCurrent setting:<f1> Vulcan Mode<f0>.", $DisplayTime);
	}
	else if (%playerId.gauss == 2)
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.66  Fire Rate: 0.2 seconds\nAn explosive, cutting round.  Little damage to players and ships.\nGood against barriers and turrets.\nCurrent setting:<f1> Door & Turret Busting<f0> Mode.", $DisplayTime);
	}
}

function ChainRifle::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.ChainRifle == 0) {
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire Rate: 0.05 seconds\nCurrent setting:<f1> Standard Mode.<f0> Fires regular bullets. \nUses no ammo.", $DisplayTime);	}
	else if (%playerId.ChainRifle == 1){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire  Rate: 0.05 seconds\nCurrent setting:<f1> Vulcan Mode.<f0> Fires extra amount of bullets. \nUses normal amount of ammo.", $DisplayTime);	}
	else if (%playerId.ChainRifle == 2){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire  Rate: 0.05 seconds\nCurrent setting:<f1> Hellfire Mode.<f0> Fires Hellfire rounds. \nSets foe ablaze and destroys much of his ammo.", $DisplayTime);	}
	else if (%playerId.ChainRifle == 3){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire Rate: 0.05 seconds\nCurrent setting:<f1> Fusion & Energy Mode.<f0>\n Fires Fusion and Energy shots. Uses extra ammo.\nThis setting is the HEAVY ARMOR killer.", $DisplayTime);	}
	else if (%playerId.ChainRifle == 4){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire  Rate: 0.05 seconds\nCurrent setting:<f1> Ecstacy Mode.<f0> Fires Ecstacy shot. \nUses extra ammo.\nThis setting is uesless against Blastech.", $DisplayTime);	}
}

function ChainCannon::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.ChainCannon == 0) {
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire Rate: 0.025 seconds\nCurrent setting:<f1> Standard Mode.<f0> Fires regular bullets. \nUses no ammo.", $DisplayTime);	}
	else if (%playerId.ChainCannon == 1){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire  Rate: 0.025 seconds\nCurrent setting:<f1> Vulcan Mode.<f0> Fires extra amount of bullets. \nUses normal amount of ammo.", $DisplayTime);	}
	else if (%playerId.ChainCannon == 2){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire  Rate: 0.025 seconds\nCurrent setting:<f1> Hellfire Mode.<f0> Fires Hellfire rounds. \nSets foe ablaze and destroys much of his ammo.", $DisplayTime);	}
	else if (%playerId.ChainCannon == 3){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire Rate: 0.025 seconds\nCurrent setting:<f1> Fusion & Energy Mode.<f0>\n Fires Fusion and Energy shots. Uses extra ammo.\nThis setting is the HEAVY ARMOR killer.", $DisplayTime);	}
	else if (%playerId.ChainCannon == 4){
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.075   Fire  Rate: 0.025 seconds\nCurrent setting:<f1> Ecstacy Mode.<f0> Fires Ecstacy shot. \nUses extra ammo.\nThis setting is uesless against Blastech.", $DisplayTime);	}
}

function GrenadeLauncher::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.grenadeL == 0)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.4   Fire Rate: 1 second\nCurrent setting:<f1> Standard Mode.<f0> Fires regular grenade shell.", $DisplayTime);	}
	else if (%playerId.grenadeL == 1)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 1 second\nCurrent setting:<f1> EMP Mode.<f0> Fires an EMP grenade shell.", $DisplayTime);	}
	else if (%playerId.grenadeL == 2)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.4   Fire Rate: 1 second\nCurrent setting:<f1> Vertigo Mode.<f0> Fires an energy grenade shell.", $DisplayTime);	}
	else if (%playerId.grenadeL == 3)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.4   Fire Rate: 1 second\nCurrent setting:<f1> Impact Mode.<f0> Fires an impact grenade shell.", $DisplayTime);	}
	else if (%playerId.grenadeL == 4)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.4   Fire Rate: 1 second\nCurrent setting:<f1> Vertigo Impact Mode.<f0> \nFires an energy impact grenade shell.", $DisplayTime);	}
	else if (%playerId.grenadeL == 6)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.4   Fire Rate: 1 second\nCurrent setting:<f1> Rocket-powered Mode.<f0> \nFires rocket-powered grenade.\nChance to be seeking. Five or 10 ammo used.", $DisplayTime);	}
	else if (%playerId.grenadeL == 5)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.4   Fire Rate: 1 second\nCurrent setting:<f1> Firebomb Mode.<f0> Fires a shell that bursts into flames for up to 30 seconds.\nUses 10 ammo.", $DisplayTime);	}
	else if (%playerId.grenadeL == 7)		{
		bottomprint(Player::getClient(%player),"<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 1 second\nCurrent setting:<f1> Smoke Bomb Mode.<f0> Fires a Smoke Bomb shell that obscures vision and induces choking.", $DisplayTime);	}
}

function Mortar::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.mortar == 0)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 1.0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> Standard Mode.<f0> Fires regular mortar shell.", $DisplayTime);	}
	else if (%playerId.mortar == 1)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> EMP Mode.<f0> Fires an EMP mortar shell.", $DisplayTime);	}
	else if (%playerId.mortar == 2)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 1.0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> Vertigo Mode.<f0> Fires an energy mortar shell.\nGood against Blastech.", $DisplayTime);	}
	else if (%playerId.mortar == 3)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 1.0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> Impact Mode.<f0> Fires an impact mortar shell.", $DisplayTime);	}
	else if (%playerId.mortar == 4)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 1.0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> Vertigo Impact Mode.<f0> \nFires an energy impact mortar shell.\nGood against Blastech.", $DisplayTime);	}
	else if (%playerId.mortar == 6)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 1.0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> Rocket-powered Mode.<f0> \nFires rocket-powered mortar.\nChance to be seeking. Ten or 20 ammo used.", $DisplayTime);	}
	else if (%playerId.mortar == 5)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 1.0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> Firebomb Mode.<f0> Fires a Firebomb shell.\nUses 10 ammo.", $DisplayTime);	}
	else if (%playerId.mortar == 7)		{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0   Fire Rate: 2.5 seconds\nFires a mortar based on Mortar Weapon menu setting\nCurrent setting:<f1> Smoke Bomb Mode.<f0> Fires a Smoke Bomb shell.", $DisplayTime);	}
}

function DiscLauncher::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.discL == 0)
	{
		bottomprint(Player::getClient(%player), "<jc><f2>" @ %item.description @ "\n<f1>Damage per shot: <f0>0.5  <f1>Fire Rate: <f0>1.75 seconds\n<f1>Current setting:<f0> Standard <f1>mode.  Fires the standard Stormhammer disc shell.", $DisplayTime);
	}
	else if (%playerId.discL == 1)
	{
		bottomprint(Player::getClient(%player), "<jc><f2>" @ %item.description @ "\n<f1>Damage per shot: <f0>0.3 <f1>each shell  <f1>Fire Rate: <f0>1.75 seconds\n<f1>Current setting:<f0> Spread shot <f1>mode.  Fires a spread of lesser disc shells.", $DisplayTime);
	}
	else if (%playerId.discL == 2)
	{
		bottomprint(Player::getClient(%player), "<jc><f2>" @ %item.description @ "\n<f1>Damage per shot: <f0>0.5  <f1>Fire Rate: <f0>1.75 seconds\n<f1>Current setting:<f0> Short-range Tracker <f1>mode.  A tracking disc shell is fired if target is within 300m.", $DisplayTime);
	}
}

function MRPGLauncher::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>MECH Super Hyper Blaster\n<f0>Damage per shot: 1.2\nFire Rate: 0.5 seconds\nCan be enhanced by Super-Charger Pack. Only HEAVY armors can mount this.", $DisplayTime);
}

function LaserPistol::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if(Player::getMountedItem(%player,$BackpackSlot) == SuperChargerPack)
	{
		if(%playerId.SCpack == 0)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot:<f2> 0.45   <f0>Fire Rate: <f2>0.35 seconds\n<f0>Special Abilities due to Chimera:<f2> 2 - 5 rounds.", $DisplayTime);
		}
		if(%playerId.SCpack == 1)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot:<f2> 0.45   <f0>Fire Rate: <f2>0.35 seconds\n<f0>Special Abilities due to Chimera:<f2> Lite explosive round.", $DisplayTime);
		}
		else if(%playerId.SCpack == 2)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot:<f2> 1.01   <f0>Fire Rate: <f2>2 seconds\n<f0>Special Abilities due to Chimera:<f2> Stunning round.", $DisplayTime);
		}
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot:<f2> 0.45   <f0>Fire Rate: <f2>0.35 seconds\nA nice pistol with multiple uses.", $DisplayTime);
	}	
}

function LaserRifle::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Medium\nFire Rate: 0.3 seconds", $DisplayTime);
}

function Dartgun::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if(Player::getMountedItem(%player,$BackpackSlot) == SuperChargerPack)
	{
		if(%playerId.SCpack == 0)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>N/A   <f0>Fire Rate: <f2>1.5 seconds\n<f0>Special Abilities due to Chimera:<f2> Poisons + EMP.", $DisplayTime);
		}
		if(%playerId.SCpack == 1)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>N/A   <f0>Fire Rate: <f2>1.5 seconds\n<f0>Special Abilities due to Chimera:<f2> Poisons + EMP in a 5m radius of impact.", $DisplayTime);
		}
		else if(%playerId.SCpack == 2)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>N/A   <f0>Fire Rate: <f2>1.5 seconds\n<f0>Special Abilities due to Chimera:<f2> Poisons + Tornado + HellFire.", $DisplayTime);
		}
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>N/A   <f0>Fire Rate: <f2>1.5 seconds\n<f0>Special Ability: Poisons your target.", $DisplayTime);
	}	
}

function Shotgun::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if(Player::getMountedItem(%player,$BackpackSlot) == SuperChargerPack)
	{
		if(%playerId.SCpack == 0)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Light to Medium at short range\nFire Rate: 1.0 seconds\n<f0>Special Abilities due to Chimera:<f2> Explosive pellets.", $DisplayTime);
		}
		if(%playerId.SCpack == 1)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Light to Medium at short range\nFire Rate: 1.0 seconds\n<f0>Special Abilities due to Chimera:<f2> Stunning pellets.", $DisplayTime);
		}
		else if(%playerId.SCpack == 2)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Light to Medium at short range\nFire Rate: 1.0 seconds\n<f0>Special Abilities due to Chimera:<f2> Black Hole pellets.", $DisplayTime);
		}
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Light to Medium at short range\nFire Rate: 1.0 seconds\nAn extremely close range weapon.", $DisplayTime);
	}	
}

function DBShotgun::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if(Player::getMountedItem(%player,$BackpackSlot) == SuperChargerPack)
	{
		if(%playerId.SCpack == 0)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Medium to High at short range\nFire Rate: 2.2 seconds\nBoth barrels fire together and uses 2 ammo per shot.\n<f0>Special Abilities due to Chimera:<f2> Door & Turret buster pellets.", $DisplayTime);
		}
		if(%playerId.SCpack == 1)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Medium to High at short range\nFire Rate: 2.2 seconds\nBoth barrels fire together and uses 2 ammo per shot.\n<f0>Special Abilities due to Chimera:<f2> High Impact pellets.", $DisplayTime);
		}
		else if(%playerId.SCpack == 2)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Medium to High at short range\nFire Rate: 2.2 seconds\nBoth barrels fire together and uses 2 ammo per shot.\n<f0>Special Abilities due to Chimera:<f2> High-explosive pellets.", $DisplayTime);
		}
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Medium to High at short range\nFire Rate: 2.2 seconds\nBoth barrels fire together and uses 2 ammo per shot.  Light armors can't carry it.", $DisplayTime);
	}	
}

function MassDriver::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if(Player::getMountedItem(%player,$BackpackSlot) == SuperChargerPack)
	{
		if(%playerId.SCpack == 2)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>1.01   <f0>Fire Rate: <f2>1.2 seconds\n<f0>Special Abilities due to Chimera:<f2> TET round.", $DisplayTime);
		}
		if(%playerId.SCpack == 1)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot:<f2> 1.01   <f0>Fire Rate: <f2>1.2 seconds\n<f0>Special Abilities due to Chimera:<f2> 2 - 4 rounds.", $DisplayTime);
		}
		else if(%playerId.SCpack == 0)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot:<f2> 1.01   <f0>Fire Rate: <f2>1.2 seconds\n<f0>Special Abilities due to Chimera:<f2> 3-shot spread.", $DisplayTime);
		}
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>1.01   <f0>Fire Rate: <f2>1.2 seconds\n<f0>Explosive rounds.", $DisplayTime);
	}	
}

function AAODSniperX::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if(Player::getMountedItem(%player,$BackpackSlot) == SuperChargerPack)
	{
		if(%playerId.SCpack == 0)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>Special   <f0>Fire Rate: <f2>1.5 seconds\n<f0>Special Abilities due to Chimera:<f2> 60%strength shot + Acid round.", $DisplayTime);
		}
		if(%playerId.SCpack == 1)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>1.32+   <f0>Fire Rate: <f2>1.5 seconds\n<f0>Special Abilities due to Chimera:<f2> 3-shot spread.", $DisplayTime);
		}
		else if(%playerId.SCpack == 2)
		{
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>1.32+   <f0>Fire Rate: <f2>1.5 seconds\n<f0>Special Abilities due to Chimera:<f2> 2 - 4 rounds.", $DisplayTime);
		}
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>1.32   <f0>Fire Rate: <f2>1.5 seconds\nSpecial Ability: The heavier the armor plating, the more damage this weapon does.", $DisplayTime);
	}
}

function PlasmaGun::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if(Player::getMountedItem(%player,$BackpackSlot) == SuperChargerPack)
	{
		if(%playerId.SCpack == 0)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>0.4 per   <f0>Fire Rate: <f2>0.6 seconds\n<f0>Special Abilities due to Chimera:<f2> 4-shot spread.", $DisplayTime);
		}
		if(%playerId.SCpack == 1)
		{ 
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>2.45    <f0>Fire Rate: <f2>0.6 seconds\n<f0>Special Abilities due to Chimera:<f2> Beefy round.", $DisplayTime);
		}
		else if(%playerId.SCpack == 2)
		{
			bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: <f2>0.75    <f0>Fire Rate: <f2>0.6 seconds\n<f0>Special Abilities due to Chimera:<f2> Long-range, faster round.", $DisplayTime);
		}
	}
	else
	{
		bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: 0.45\nFire Rate: 0.6 seconds\nShort-range and small splash.", $DisplayTime);
	}
}

function LasCannon::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Varies\nFire Rate: Charge = 200", $DisplayTime);
}

function JugLauncher::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>Juggalo Electro-Optical Missile Launcher: <f2>When you fire it, be sure to control it immediately.\n<f1>*WARNING*<f2> Do not fire while in the air or inside a small or enclosed building.");
//	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Lots   <f1>Launches a pilot-view cruise missile.\nAim it at your target and fly into it or JUMP when you get close enough.", $DisplayTime);
}

function PlasmaCannon::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Lots\nFire Rate: Charge = 275\nFires a nasty plasma blast with a big splash.", $DisplayTime);
}

function AnnihCannon::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Lots\nFire Rate: Charge = 335\nThe powerful Annihilator blast has a big explosion radius and incredible amount of damage.", $DisplayTime);
}

function MeteorCannon::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Lots\nFire Rate: Charge = 400\n<f1>Pulls a swarm of <f2>METEORs<f1> down from the sky to where you point.\nSo using it <f2>INDOORS<f1> is useless.", $DisplayTime);
}

function GrenadeSelector::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.grenade == 0) {
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>Standard <f0>mode.", $DisplayTime);	}
	else if (%playerId.grenade == 1){
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>Concussive <f0>mode.", $DisplayTime);	}
	else if (%playerId.grenade == 2){
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>Fire <f0>mode.", $DisplayTime);	}
	else if (%playerId.grenade == 3){
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>Poison <f0>mode.", $DisplayTime);	}
	else if (%playerId.grenade == 4){
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>EMP <f0>mode.", $DisplayTime);	}
	else if (%playerId.grenade == 5){
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>HellFire <f0>mode.", $DisplayTime);	}
	else if (%playerId.grenade == 6){
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>Black Hole <f0>mode.", $DisplayTime);	}
	else if (%playerId.grenade == 7){
		bottomprint(Player::getClient(%player), "<jc><f0>Grenades currently set at <f2>Acid Bath <f0>mode.", $DisplayTime);	}
}

function MineSelector::onUse(%player,%item)
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.Mine == 0) {
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>Standard <f0>mode.", $DisplayTime);	}
	else if (%playerId.Mine == 1){
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>Concussive <f0>mode.", $DisplayTime);	}
	else if (%playerId.Mine == 2){
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>Fire <f0>mode.", $DisplayTime);	}
	else if (%playerId.Mine == 3){
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>Poison <f0>mode.", $DisplayTime);	}
	else if (%playerId.Mine == 4){
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>EMP <f0>mode.", $DisplayTime);	}
	else if (%playerId.Mine == 5){
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>Tornado <f0>mode.", $DisplayTime);	}
	else if (%playerId.Mine == 6){
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>Heavy Gravity <f0>mode.", $DisplayTime);	}
	else if (%playerId.Mine == 7){
		bottomprint(Player::getClient(%player), "<jc><f0>Mines currently set at <f2>Acid Bath <f0>mode.", $DisplayTime);	}
}

function BeaconSelector::onUse(%player,%item)
//function BeaconSelector::onMount(%player,%item)//if i set it to mount, it replaces mounted weapon.  doh!!
{
	Weapon::onUse(%player,%item);
	%playerId = Player::getClient(%player);
	if (%playerId.Beacon == 0) {
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Deploy a beacon <f0>mode.", $DisplayTime);	}
	else if (%playerId.Beacon == 1){
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Shield <f0>mode.", $DisplayTime);	}
	else if (%playerId.Beacon == 2){
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Energy Recharge <f0>mode.", $DisplayTime);	}
	else if (%playerId.Beacon == 3){
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Auto Repair <f0>mode.", $DisplayTime);	}
	else if (%playerId.Beacon == 4){
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Universal Antidote <f0>mode.", $DisplayTime);	}
	else if (%playerId.Beacon == 5){
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Jet Boost <f0>mode.", $DisplayTime);	}
	else if (%playerId.Beacon == 6){
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Ammo Generator <f0>mode.", $DisplayTime);	}
	else if (%playerId.Beacon == 7){
		bottomprint(Player::getClient(%player), "<jc><f0>Beacons currently set at <f2>Deploy a beacon <f0>mode.", $DisplayTime);	}
}

//================Deployable Turret Info==========================================================
function AODShieldNode::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Use the Shield Node to enhance an objects' <f2>shielding<f1>. Deployable on many items.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function CNode::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Use the Cloaking Node to <f2>cloak<f1> an object.  Deployable on many items.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function PulseSensorPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>A deployable <f2>Pulse Sensor<f1>.  Gives you some extra radar in a remote area.\n<jc>Has an effective range of 350m.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DeployableSensorJammerPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>A deployable <f2>Sensor Jammer<f1>.  Blinds radar and some turrets.\n<jc>Has an effective range of 80m.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function MotionSensorPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>A deployable <f2>Motion Sensor<f1>.  Gives motion-sensing ability to close-by turrets.\n<jc>Has an effective range of 100m.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function CameraPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>A deployable <f2>Camera<f1>.  Gives visual lock-on ability to close-by turrets.\n<jc>You can look thru it in the Command Console. Has an effective range of 100m.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DeployableInvPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>A deployable <f2>Inventory Station<f1>.  Not as comprehensive as the big ones, but\n<jc>they don't need power and you can only buy <f0>Super<f1> and <f0>Powered<f1> Doors from them.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DeployableAmmoPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>A deployable <f2>Ammo Station<f1>.  Refills ammo on your carried weapons and\n<jc>your supply of beacons, grenades, mines, and health kits.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DronePack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a remote-controlled <f2>Drone<f1>.  Guide it into the enemy base and destroy their defenses\n<jc>with its' powerful beam weapon.  To stop using it, press your <f0>jump<f1> key.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AODDefender::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Defender Designator<f1> turret.  It fires a green beam that booms on impact upon locating an\n<jc>enemy player.  The beams have a short duration, so you can see where they are going.\n<jc>Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function TurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Laser<f1> turret.  A quick, low-powered beam that accurately\n<jc>and instantly hits anenemy player.  Reload time is about 1.5 seconds and \n<jc>is moderately armored.  Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function TTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Tractor<f1> turret.  A short-range <f0>pulling<f1> beam is fired from this little turret.\n<jc>Designed to draw an enemy player closer to more <f2>lethal<f1> turrets.\n<jc>Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function LELFPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>ELF<f1> turret.  A medium-range <f0>ELF<f1> beam quickly draws all of the energy from\n<jc>an enemy player. When his energy is all gone, it starts in on his health.\n<jc>Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AODGrogPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Chaingun<f1> turret.  This medium-range turret fires a spray of <f0>chaingun<f1> bullets.\n<jc>Very rapid-fire and lightly armored. Deployable on Buildings <f0>ONLY<f1>!", 15);
//        Bottomprint(%client, "<jc><f1>Deploys the <f2>Chaingun<f1> turret.  This medium-range turret fires a spray of <f0>chaingun<f1> bullets.\n<jc>Very rapid-fire and moderately armored. Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AODVelcroPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Velcro<f1> turret.  A medium-range turret that rapid-fires <f0>guided electrical<f1> missiles.\n<jc>Low-powered and moderately armored. Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function FluxPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>EMP Blast<f1> turret.  Fires a medium-range, seeking <f0>EMP<f1> missile.\n<jc>Quickly homes in on jetting players and is moderately armored. Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function Turret4Pack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Fusion<f1> turret.  Rapid-fires medium-range <f0>Fusion<f1> blasts.\n<jc>Very deadly to Myrmidon armor and it is lightly armored. Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DisruptorTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Plasma<f1> turret.  Same as the hard-mounted ones found on most bases.\n<jc>Very deadly to Assault armor and it is moderately armored. Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DMortarPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Mortar<f1> turret.  Same as the hard-mounted ones found on most bases.\n<jc>Fires a seeking, rocket-powered mortar round. It is moderately armored and deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function IonTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Mitzi<f1> turret.  This bad boy fires the awesome <f0>ANNIHILATOR<f1> blast.\n<jc>Slow reload and is lightly armored. Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function PulseTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>AA Battery<f1> turret.  An Anti-aircraft turret that fires at jetting players and\n<jc>planes.  Extremely rapid-fire, long-range, and is lightly armored. Deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DiscTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Flamer<f1> turret.  Medium-range Flame-thrower.  It is motion-sensitive and kills most\n<jc>enemy players in short order.  Peltast is IMMUNE to flames.  It is lightly armored and deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function RocketPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Rocket<f1> turret.  Basically the same as the hard-mounted version found in some maps.\n<jc>Fires on jetting enemy players and planes with a powerful, but slow missile.\n<jc>It is lightly armored and deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AODArtilleryPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>SHB<f1> turret.  Rapid-fires the super-blaster shots. Medium speed shots, but the turret\n<jc>needs to be mounted near an energy source.  It is lightly armored, but has shields.\n<jc>It deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function ElectroTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>PBW<f1> turret.  The powerful PBW beam is fast and accurate.  Instantly kills most armors.\n<jc>It's Achilles heel is it's extremely light armor and a shielded player is unaffected by\n<jc>its beam.  It deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function RoundTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Indoor<f1> turret.  High rate of fire and is motion-sensing PLUS it has Line-of-Sight capability.\n<jc>Moderately armored and is deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function BumperTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Bumper<f1> turret.  Fires a seeking missile that does no real damage, but knocks most armors back quite a bit.\n<jc>Slow rate of fire, moderately armored and is deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function HFTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Hellfire<f1> turret.  High rate of fire and is motion-sensing PLUS it has Line-of-Sight capability.\n<jc>It eats up your ammunition and is deployable almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function SatchelChrgPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Satchel Charge<f1>.  It allows you to remote detonate a high-powered explosive charge\n<jc>Go to command screen and control it like a camera.  Then, shoot.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AAairTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Anti-Aircraft Air<f1> turret.  Deploys 50m above you.\n<jc>Fires on jetting players slower than the chaingun turret.  Moderately armored.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function SniperAirTurretPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Sniper Air<f1> turret.  It is motion-sensing PLUS it has Line-of-Sight capability.\n<jc>Deploys 350m above you and has a 60 second reload time.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

//================Deployable Object Info==========================================================
function AODTeleporter::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Main Teleporter<f1>.  You will have 5 minutes to deploy the second part\n<jc>after you deploy the first portion.  This teleporter is silent but it leaves a tell-tale power trail.\n<jc>Overhead obstructions can prevent exiting the pad.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function TeleportPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Backup Teleporter<f1>.  Teleportation is instantaneous, but a teleport sound\n<jc>may alert nearby enemy players.  Even if you cloak this, the electrical beam is a dead give-away.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AODMobileInv::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Main Inventory Station<f1>.  Does all of the things the other full-size Inventory Station does.\n<jc>It needs to be deployed within 200m of a friendly power source.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function PortaComm::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Main Command Station<f1>.  Does all of the things the other full-size Command Station does.\n<jc>It needs to be deployed within 200m of a friendly power source.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function PortaAmmo::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Main Ammo Station<f1>.  Does all of the things the other full-size Ammo Station does.\n<jc>It needs to be deployed within 200m of a friendly power source.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AODMobileGen::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Backup Generator<f1>.  This generator takes over when the main source of power has been\n<jc>destroyed.  Occasionally, one will need to be deployed even if the <f0>Main Generator<f1> has been repaired.\n<jc>Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function AODShieldGen::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Shield Node<f1> power supply.  You only need one of these, but it is very important.\n<jc>One must be deployed for any of your <f0>Shield Nodes<f1> to operate.\n<jc>Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function doorfivebyfiveForceFieldPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>5x5 ForceField<f1> door.  Opens for friendly players and is a minor obstacle to enemy players.\n<jc>However, you can set out a huge number of these.  Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function doorfourbyeightForceFieldPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>4x8 ForceField<f1> door.  Opens for friendly players and is a moderate obstacle to enemy players.\n<jc>However, you can set out a large number of these.  Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function BlastDoor::onMount(%player,%item)
{
	%client = Player::getClient(%player);
	Bottomprint(%client, "<jc><f1>Deploys a <f2>Large Blast Door<f1>.  Opens for friendly players and is a good obstacle to enemy players.\n<jc>You can set out many of these.  Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function BlastFloor::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Blast Floor<f1>.  A nice structure so you can stand on or build some objects onto it.\n<jc>It does NOT open but you can set out many of these.  Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function shieldedfivebyfiveForceFieldPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2> Shielded 5x5 ForceField<f1> door.  Opens for friendly players and is a medium obstacle to enemy players.\n<jc>However, you can set out a small number of these.  Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function ElectrifiedDoor::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys an <f2>Electrified 4x17 ForceField<f1> fence.  Opens for friendly players and is a medium obstacle to enemy players.\n<jc><f0>ZAPS<f1> enemy players touching it.  Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function jailpack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Jail<f1> somewhere on the map.  \nKeeps the enemy trapped for a period of time.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function jailcappack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Jail Capturing Pad<f1>.  \nWhen the enemy steps on this, and you have a jail deployed, it sends them there.\nIf they had the flag, they drop it before going to jail.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function SuperDoor::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys a <f2>Super<f1> door.  Be careful how you deploy it. It <f2>LAYS FLAT<f1> on the surface you are pointing at.\n<jc>It is incredibly strong and takes a long time to destroy.  Fortunately, they are rather small and few in number.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function PoweredDoor::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>The Powered Door requires to be near a power source.\n<jc>While powered, it will be a <f2>SHIELDED<f1> door and be impervious to damage.  It will still open, powered or not.\n<jc>Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function DiagonalDoor::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>The Diagonal Door needs to be pretty close to a power source.\n<jc>While powered, it will be a <f2>SHIELDED<f1> door and be nearly impervious to damage.  It will still open, powered or not.\n<jc>Deploys almost anywhere.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function TNTPack::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Nega-Bomb<f1>.  A super-powerful bomb with almost NO fuse.\n<jc>Basically, a suicide weapon meant to take out the strongest of defenses.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

function MiniBase::onMount(%player,%item)
{
        %client = Player::getClient(%player);
        Bottomprint(%client, "<jc><f1>Deploys the <f2>Air Base<f1>.  A self-sustained little platform with an Inventory Station, Ammo Station,\n<jc>an air pad, a Sensor and some small turrets.  Very good for those forward areas.  Deploys over 100m above where you point.", 15);
	 	Client::sendMessage(%client,3,"There are " @ $TeamItemCount[GameBase::getTeam(%player) @ %item] @ " out of " @ $TeamItemMax[%item] @ " " @ %item.description @ "s already deployed.");
}

