//=============================================================================================
BulletData BlasterBolt
{
	bulletShapeName    = "shotgunbolt.dts";
	explosionTag       = blasterExp;

	damageClass        = 0;
	damageValue        = 0.15;
	damageType         = $BlasterDamageType;

	muzzleVelocity     = 200.0;
	totalTime          = 2.0;
	liveTime           = 1.125;

	lightRange         = 3.0;
	lightColor         = { 1.0, 0.25, 0.25 };
	inheritedVelocityScale = 0.5;
	isVisible          = True;

	rotationPeriod = 1;
};

BulletData SpreadBlasterBolt
{
	bulletShapeName    = "shotgunbolt.dts";
	explosionTag       = blasterExp;

	damageClass        = 1;
	damageValue        = 0.1;
	damageType         = $BlasterDamageType;
	explosionRadius    = 2;
	aimDeflection      = 0.0175;

	muzzleVelocity     = 200.0;
	totalTime          = 2.0;
	liveTime           = 1.125;

	lightRange         = 3.0;
	lightColor         = { 1.0, 0.25, 0.25 };
	inheritedVelocityScale = 0.5;
	isVisible          = True;

	rotationPeriod = 1;
};

BulletData SuperBlaster
{
	bulletShapeName    = "plasmabolt.dts";
//	bulletShapeName  = "shotgunbolt.dts";
	explosionTag     = boltexp1;

	damageClass      = 1;       // 0 impact, 1, radius
//	damageValue      = 1.5;
	damageValue      = 0.75;
	damageType       = $BlasterDamageType;
	explosionRadius  = 4;
	kickBackStrength = 50.0;

	muzzleVelocity   = 150.0;
	terminalVelocity = 500.0;
	acceleration     = 35.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	isVisible          = True;

	//	rocket specific
	trailType   = 2;                // smoke trail
	trailString = "shotgunex.dts";
	smokeDist   = 15.7;

	soundId = SoundJetHeavy;
};

//=============================================================================================
SeekingMissileData VertigoEnergyMissile
{
   bulletShapeName = "fusionex.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.125;
   damageType       = $VertigoDamageType;
   explosionRadius  = 13;
   kickBackStrength = 15.0;

   muzzleVelocity    = 75.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

SeekingMissileData VertigoFlamingMissile
{
   bulletShapeName = "shotgunex.dts";
//   bulletShapeName = "mortar.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.1;
   damageType       = $FlameDamageType;
   explosionRadius  = 13;
   kickBackStrength = 15.0;

   muzzleVelocity    = 75.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

SeekingMissileData VertigoBumperMissile
{
   bulletShapeName = "mortartrail.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;
   explosionRadius  = 13;
   kickBackStrength = 275.0;

   muzzleVelocity    = 75.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

//=============================================================================================
RocketData AALaserBolt
{ 
//	bulletShapeName = "plasmabolt.dts"; 
	bulletShapeName = "enbolt.dts"; 
	explosionTag = ShockwaveFour; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
	damageValue = 0.5; 
	damageType = $FlameDamageType;
	explosionRadius = 2; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 3072.0; 
	terminalVelocity = 3000.0;
	acceleration = 500; 
	totalTime = 4.0; 
	liveTime = 4.0; 
	lightRange = 5.0; 
	lightColor = { 0.0, 0.0, 1.5 }; 
	inheritedVelocityScale = 0.0; 
	trailType = 1;
	trailLength = 3000; 
	trailWidth = 2.0; 
	soundId = SoundJetHeavy;
};

LaserData AALaserBeam
{
//	laserBitmapName   = "tekpanel.bmp";
//	laserBitmapName   = "lightningNew.bmp";
	laserBitmapName   = "leaves.bmp";
	hitName           = "shield.dts";
	damageConversion  = 0;
	baseDamageType    = $AntiAirDamageType;
	beamTime          = 0.125;
	lightRange        = 5.0;
	lightColor        = { 0.01, 0.01, 1.25 };
	detachFromShooter = true;
	hitSoundId        = SoundLaserHit;
};

RocketData AALaserBolt2
{ 
//	bulletShapeName = "plasmabolt.dts"; 
	bulletShapeName = "enbolt.dts"; 
	explosionTag = ShockwaveFour; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
	damageValue = 0.25; 
	damageType = $HFDamageType;
	explosionRadius = 2; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 3072.0; 
	terminalVelocity = 3000.0;
	acceleration = 500; 
	totalTime = 4.0; 
	liveTime = 4.0; 
	lightRange = 5.0; 
	lightColor = { 0.0, 0.0, 1.5 }; 
	inheritedVelocityScale = 0.0; 
	trailType = 1;
	trailLength = 3000; 
	trailWidth = 2.0; 
	soundId = SoundJetHeavy;
};

LaserData AALaserBeam2
{
//	laserBitmapName   = "fx_lensflare_5.bmp";//stealth
//	laserBitmapName   = "ylite02.bmp";
	laserBitmapName   = "ylite01.bmp";
	hitName           = "shield.dts";
	damageConversion  = 0;
	baseDamageType    = $CrushDamageType;
	beamTime          = 0.125;
	lightRange        = 5.0;
	lightColor        = { 0.01, 0.01, 1.25 };
	detachFromShooter = true;
	hitSoundId        = SoundLaserHit;
};

RocketData AALaserBolt3
{ 
//	bulletShapeName = "plasmabolt.dts"; 
	bulletShapeName = "enbolt.dts"; 
	explosionTag = ShockwaveFour; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
	damageValue = 1.0; 
	damageType = $SniperXDamageType;
	explosionRadius = 2; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 3072.0; 
	terminalVelocity = 3000.0;
	acceleration = 500; 
	totalTime = 4.0; 
	liveTime = 4.0; 
	lightRange = 5.0; 
	lightColor = { 0.0, 0.0, 1.5 }; 
	inheritedVelocityScale = 0.0; 
	trailType = 1;
	trailLength = 3000; 
	trailWidth = 2.0; 
	soundId = SoundJetHeavy;
};

LaserData AALaserBeam3
{
	laserBitmapName   = "blue_metaltek.bmp";
//	laserBitmapName   = "lightningNew.bmp";
	hitName           = "shield.dts";
	damageConversion  = 0;
	baseDamageType    = $SniperXDamageType;
	beamTime          = 0.125;
	lightRange        = 5.0;
	lightColor        = { 0.01, 0.01, 1.25 };
	detachFromShooter = true;
	hitSoundId        = SoundLaserHit;
};

RocketData AALaserBolt4
{ 
//	bulletShapeName = "plasmabolt.dts"; 
	bulletShapeName = "enbolt.dts"; 
	explosionTag = ShockwaveFour; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
	damageValue = 2.5; 
	damageType = $DoorBusterDamageType;
	explosionRadius = 2; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 3072.0; 
	terminalVelocity = 3000.0;
	acceleration = 500; 
	totalTime = 4.0; 
	liveTime = 4.0; 
	lightRange = 5.0; 
	lightColor = { 0.0, 0.0, 1.5 }; 
	inheritedVelocityScale = 0.0; 
	trailType = 1;
	trailLength = 3000; 
	trailWidth = 2.0; 
	soundId = SoundJetHeavy;
};

LaserData AALaserBeam4
{
	laserBitmapName   = "light04.bmp";
//	laserBitmapName   = "lightningNew.bmp";
	hitName           = "shield.dts";
	damageConversion  = 0;
	baseDamageType    = $DoorBusterDamageType;
	beamTime          = 0.125;
	lightRange        = 5.0;
	lightColor        = { 0.01, 0.01, 1.25 };
	detachFromShooter = true;
	hitSoundId        = SoundLaserHit;
};

//=============================================================================================
BulletData GaussBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp3;
   mass               = 0.05;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.22;
   damageType         = $GaussDamageType;

   explosionRadius    = 7.5;
   aimDeflection      = 0.005;
   muzzleVelocity     = 999.0;
   totalTime          = 10.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData GaussBullet2
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp3;
   mass               = 0.05;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 2.2;
   damageType         = $Gauss2DamageType;

   explosionRadius    = 2.5;
   aimDeflection      = 0.0025;
   muzzleVelocity     = 999.0;
   totalTime          = 10.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//=============================================================================================
BulletData MiniGunBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.075;
   damageType         = $BulletDamageType;

   aimDeflection      = 0.0075;
   muzzleVelocity     = 768.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData MiniGunBullet5
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 7.5;
   damageType         = $DoorBusterDamageType;

   aimDeflection      = 0.0075;
   muzzleVelocity     = 768.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData ChaingunBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.11;
   damageType         = $BulletDamageType;

   aimDeflection      = 0.005;
   muzzleVelocity     = 999.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//=============================================================================================
BulletData PoisonDart
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.07;
	damageType         = $MethaneDamageType;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData EMPDart
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.07;
	damageType         = $EMPDamageType;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData PoisonDartX
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.03;
	damageType         = $MethaneDamageType;
	explosionRadius    = 5;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData EMPDartX
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.02;
	damageType         = $EMPDamageType;
	explosionRadius    = 5;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData TornadoDart
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.07;
	damageType         = $TornadoDamageType;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData HellfireDart
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.07;
	damageType         = $HFDamageType;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

//=============================================================================================
BulletData ShotgunBullet
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.125;
	damageType         = $RealShotgunDamageType;

	aimDeflection      = 0.0375;
	muzzleVelocity     = 999.0;
	totalTime          = 1;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData ShotgunBulletX
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.125;
	damageType         = $RealShotgunDamageType;
	explosionRadius    = 4;

	aimDeflection      = 0.0375;
	muzzleVelocity     = 999.0;
	totalTime          = 1;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData ShotgunBulletStun
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.125;
	damageType         = $StunDamageType;

	aimDeflection      = 0.0375;
	muzzleVelocity     = 999.0;
	totalTime          = 1;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData ShotgunBulletXwa
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.055;
	damageType         = $RealShotgunDamageType;
	explosionRadius    = 20;
//	kickBackStrength   = -450.0;

	aimDeflection      = 0.0375;
	muzzleVelocity     = 999.0;
	totalTime          = 1;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData ShotgunBulletDTB
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 1.25;
	damageType         = $DoorBusterDamageType;

	aimDeflection      = 0.0375;
	muzzleVelocity     = 999.0;
	totalTime          = 1;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData ShotgunBulletHiImp
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.075;
	damageType         = $RealShotgunDamageType;
	explosionRadius    = 10;
	kickBackStrength   = 150.0;

	aimDeflection      = 0.0375;
	muzzleVelocity     = 999.0;
	totalTime          = 1;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData ShotgunBulletHiXplo
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.025;
	damageType         = $RealShotgunDamageType;
	explosionRadius    = 20;

	aimDeflection      = 0.0375;
	muzzleVelocity     = 999.0;
	totalTime          = 1;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

//=============================================================================================
BulletData RifleBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.7;
   damageType         = $SniperDamageType;
   explosionRadius  = 1;

   muzzleVelocity     = 1023.9;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//=============================================================================================
BulletData AutoMagBullet
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.45;
	damageType         = $SniperDamageType;

	muzzleVelocity     = 1023.9;
	totalTime          = 0.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData AutoMagBulletX
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = SmokeExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.75;
	damageType         = $SniperDamageType;
	explosionRadius    = 8;

	muzzleVelocity     = 1023.9;
	totalTime          = 0.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData AutoMagBulletStun
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = bulletExp0;
	expRandCycle       = 3;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass        = 0;       // 0 impact, 1, radius
	damageValue        = 0.65;
	damageType         = $StunDamageType;

	muzzleVelocity     = 1023.9;
	totalTime          = 0.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

//=============================================================================================
BulletData MarloweSniperBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.65;
   damageType         = $SniperDamageType;

   explosionRadius  = 7;
   kickBackStrength = -150.0;

   muzzleVelocity     = 1023.9;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//=============================================================================================
BulletData MassBullet
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = boltexp1;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 1.01;
	damageType       = $MassDamageType;

	explosionRadius  = 5;
	kickBackStrength = 150.0;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

BulletData MassBulletSpread
{
	bulletShapeName    = "bullet.dts";
	explosionTag       = boltexp1;
	mass               = 0.05;
	bulletHoleIndex    = 0;

	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 1.01;
	damageType       = $MassDamageType;

	explosionRadius  = 5;
	kickBackStrength = 150.0;
	aimDeflection    = 0.0175;

	muzzleVelocity     = 999.0;
	totalTime          = 1.5;
	inheritedVelocityScale = 1.0;
	isVisible          = False;

	tracerPercentage   = 1.0;
	tracerLength       = 30;
};

//=============================================================================================
BulletData FusionBolt
{
   bulletShapeName    = "fusionbolt.dts";
   explosionTag       = turretExp;
   mass               = 0.05;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.25;
   damageType         = $EnergyDamageType;

   muzzleVelocity     = 50.0;
   totalTime          = 6.0;
   liveTime           = 4.0;
   isVisible          = True;

   rotationPeriod = 1.5;
};

BulletData MiniFusionBolt
{
   bulletShapeName    = "enbolt.dts";
   explosionTag       = energyExp;

   damageClass        = 1;
   damageValue        = 0.1;
   damageType         = $EnergyDamageType;
   explosionRadius    = 4.0;

   muzzleVelocity     = 280.0;
//   muzzleVelocity     = 80.0;
   totalTime          = 4.0;
   liveTime           = 2.0;

   lightRange         = 3.0;
   lightColor         = { 0.25, 0.25, 1.0 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

//=============================================================================================
BulletData ProtronBoltB
{
   bulletShapeName    = "enbolt.dts";
   explosionTag       = energyExp;

   damageClass        = 0;
   damageValue        = 0.075;
   damageType         = $FusionDamageType;

   muzzleVelocity     = 255.0;
   totalTime          = 4.0;
   liveTime           = 2.0;

   lightRange         = 3.0;
   lightColor         = { 0.25, 0.25, 1.0 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

BulletData BlasterBoltR
{
   bulletShapeName    = "shotgunbolt.dts";
   explosionTag       = blasterExp;

   damageClass        = 0;
   damageValue        = 0.15;
   damageType         = $BlasterDamageType;

   muzzleVelocity     = 250.0;
   totalTime          = 2.0;
   liveTime           = 1.125;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

//=============================================================================================
RocketData AFBolt
{
   bulletShapeName = "tracer.dts";
   explosionTag    = boltexp2;

   collisionRadius = 0.0;

  mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.05;
   damageType         = $ImpactDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 150.0;

   muzzleVelocity   = 768.0;
   terminalVelocity = 768.0;
   acceleration     = 0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   trailType   = 1;
   trailLength = 0;
   trailWidth  = 0;

   soundId = SoundJetHeavy;
};

//=============================================================================================
BulletData PlasmaBolt
{
	bulletShapeName    = "plasmabolt.dts";
	explosionTag       = plasmaExp;

	damageClass        = 1;
	damageValue        = 0.45;
	damageType         = $PlasmaDamageType;
	explosionRadius    = 4.0;

	muzzleVelocity     = 55.0;
	totalTime          = 3.0;
	liveTime           = 2.0;
	lightRange         = 3.0;
	lightColor         = { 1, 1, 0 };
	inheritedVelocityScale = 0.3;
	isVisible          = True;

	soundId = SoundJetLight;
};

BulletData PlasmaBoltSpread
{
	bulletShapeName    = "plasmabolt.dts";
	explosionTag       = plasmaExp;

	damageClass        = 1;
	damageValue        = 0.4;
	damageType         = $PlasmaDamageType;
	explosionRadius    = 4.0;
	aimDeflection      = 0.0175;

	muzzleVelocity     = 55.0;
	totalTime          = 3.0;
	liveTime           = 2.0;
	lightRange         = 3.0;
	lightColor         = { 1, 1, 0 };
	inheritedVelocityScale = 0.3;
	isVisible          = True;

	soundId = SoundJetLight;
};

BulletData PlasmaBoltBeefy
{
	bulletShapeName    = "plasmabolt.dts";
	explosionTag       = plasmaExp;

	damageClass        = 1;
	damageValue        = 2.45;
	damageType         = $PlasmaDamageType;
	explosionRadius    = 14.0;

	muzzleVelocity     = 55.0;
	totalTime          = 3.0;
	liveTime           = 2.0;
	lightRange         = 3.0;
	lightColor         = { 1, 1, 0 };
	inheritedVelocityScale = 0.3;
	isVisible          = True;

	soundId = SoundJetLight;
};

BulletData PlasmaBoltLong
{
	bulletShapeName    = "plasmabolt.dts";
	explosionTag       = plasmaExp;

	damageClass        = 1;
	damageValue        = 0.75;
	damageType         = $PlasmaDamageType;
	explosionRadius    = 4.0;

	muzzleVelocity     = 555.0;
	totalTime          = 13.0;
	liveTime           = 12.0;
	lightRange         = 3.0;
	lightColor         = { 1, 1, 0 };
	inheritedVelocityScale = 0.3;
	isVisible          = True;

	soundId = SoundJetLight;
};

//=============================================================================================
RocketData DiscShell
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;

   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $ExplosionDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 300.0;
//   kickBackStrength = 150.0;

   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 1;
   trailLength = 15;
   trailWidth  = 0.3;

   soundId = SoundDiscSpin;
};

BulletData DiscShellSpread
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;

   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.3;
   damageType       = $ExplosionDamageType;

   explosionRadius  = 5.5;
   kickBackStrength = 150.0;
   aimDeflection    = 0.0175;

   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 1;
   trailLength = 15;
   trailWidth  = 0.3;

   soundId = SoundDiscSpin;
};

SeekingMissileData DiscShellTracker
{
bulletShapeName = "discb.dts";
explosionTag = rocketExp;
collisionRadius = 0.0;
mass = 2.0;
damageClass = 1;
damageValue = 0.4;
damageType = $ExplosionDamageType;
explosionRadius = 7.5;
kickBackStrength = 200.0;
muzzleVelocity = 85.0;
terminalVelocity = 500.0;
acceleration = 10.0;
totalTime = 20.0;
liveTime = 21.0;
lightRange = 5.0;
lightColor = { 1.0, 0.7, 0.5 };
inheritedVelocityScale = 0.5;
seekingTurningRadius = 0.0;
nonSeekingTurningRadius = 5.0;
smokeDist         = 15;
proximityDist = 1.5;
lightRange = 5.0;
lightColor = { 0.4, 0.4, 1.0 };
inheritedVelocityScale = 0.5;
soundId = SoundDiscSpin;
};

//=============================================================================================
SeekingMissileData MarloweDiscTracker
{
bulletShapeName = "discb.dts";
explosionTag = rocketExp;
collisionRadius = 0.0;
mass = 2.0;
damageClass = 1;
damageValue = 0.2;
damageType = $EnergyDamageType;
explosionRadius = 7.5;
kickBackStrength = -200.0;
muzzleVelocity = 45.0;
terminalVelocity = 500.0;
acceleration = 10.0;
totalTime = 20.0;
liveTime = 21.0;
lightRange = 5.0;
lightColor = { 1.0, 0.7, 0.5 };
inheritedVelocityScale = 0.5;
seekingTurningRadius = 0.0;
nonSeekingTurningRadius = 5.0;
smokeDist         = 15;
proximityDist = 1.5;
lightRange = 5.0;
lightColor = { 0.4, 0.4, 1.0 };
inheritedVelocityScale = 0.5;
soundId = SoundDiscSpin;
};

//=============================================================================================
SeekingMissileData NapalmRocketTracker
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
//   damageValue      = 2.0;
   damageValue      = 0.4;
   damageType       = $MBHeatDamageType;
   explosionRadius  = 30;
//   explosionRadius  = 9.5;
   kickBackStrength = 175.0;

   muzzleVelocity   = 140.0;
   terminalVelocity = 400.0;
   acceleration     = 15.0;

   totalTime         = 20;
   liveTime          = 20;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

SeekingMissileData PoisonRocketTracker
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
//   damageValue      = 2.0;
   damageValue      = 0.2;
   damageType       = $MethaneDamageType;
   explosionRadius  = 30;
//   explosionRadius  = 9.5;
   kickBackStrength = 175.0;

   muzzleVelocity   = 140.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;

   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

SeekingMissileData AcidRocketTracker
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
//   damageValue      = 2.0;
   damageValue      = 0.4;
   damageType       = $AcidBathDamageType;
   explosionRadius  = 30;
//   explosionRadius  = 9.5;
   kickBackStrength = 175.0;

   muzzleVelocity   = 140.0;
   terminalVelocity = 400.0;
   acceleration     = 15.0;

   totalTime         = 20;
   liveTime          = 20;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

SeekingMissileData DropMeRocketTracker
{
	bulletShapeName = "discb.dts";
	explosionTag    = rocketExp;
	collisionRadius = 0.0;
	mass            = 2.0;
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.5;
	damageType       = $DropMeDamageType;
	explosionRadius  = 10;
	kickBackStrength = 175.0;
	muzzleVelocity   = 140.0;
	terminalVelocity = 400.0;
	acceleration     = 15.0;
	totalTime         = 20;
	liveTime          = 20;
	seekingTurningRadius    = 75;
	nonSeekingTurningRadius = 75.0;
	proximityDist     = 7;
	smokeDist         = 3.14;
	lightRange       = 5.0;
	lightColor       = { 0.4, 0.4, 1.0 };
	inheritedVelocityScale = 0.5;
	soundId = SoundJetHeavy;
};

//=============================================================================================
GrenadeData GrenadeShell
{
   bulletShapeName    = "grenade.dts";
   explosionTag       = grenadeExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;
   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.4;
   damageType         = $ShrapnelDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 150;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 1.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

GrenadeData VertigoGrenadeShell
{
   bulletShapeName    = "grenade.dts";
   explosionTag       = grenadeExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;
   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.4;
   damageType         = $EnergyDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 150;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 1.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

GrenadeData ImpactGrenadeShell
{
   bulletShapeName    = "grenade.dts";
   explosionTag       = grenadeExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;
   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.4;
   damageType         = $ImpactDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 150;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.001;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

GrenadeData VertImpGrenShell
{
   bulletShapeName    = "grenade.dts";
   explosionTag       = grenadeExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;
   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.4;
   damageType         = $EnergyDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 150;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.001;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

//=============================================================================================
RocketData RPG
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.4;
	damageType       = $ShrapnelDamageType;
	
	explosionRadius  = 15;
	kickBackStrength = 150.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;

	// rocket specific
	trailType   = 2;                // smoke trail
	trailString = "rsmoke.dts";
	smokeDist   = 6;

	soundId = SoundJetHeavy;
};

RocketData ERPG
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.4;
	damageType       = $ElectricityDamageType;
	
	explosionRadius  = 15;
	kickBackStrength = 150.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;

	// rocket specific
	trailType   = 2;                // smoke trail
	trailString = "rsmoke.dts";
	smokeDist   = 6;

	soundId = SoundJetHeavy;
};

RocketData RPEMPG
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.14;
	damageType       = $EMPDamageType;
	
	explosionRadius  = 15;
	kickBackStrength = 150.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;

	// rocket specific
	trailType   = 2;                // smoke trail
	trailString = "rsmoke.dts";
	smokeDist   = 6;

	soundId = SoundJetHeavy;
};

SeekingMissileData SeekingRPG
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 2.0;

	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.4;
	damageType       = $ShrapnelDamageType;

	explosionRadius  = 15;
	kickBackStrength = 150.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;

	seekingTurningRadius    = 75;
	nonSeekingTurningRadius = 75.0;
	proximityDist     = 10;
	smokeDist         = 3.14;

	soundId = SoundJetHeavy;
};

//=============================================================================================
GrenadeData MortarShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.5;
   damageType         = $MortarDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 2.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

//=============================================================================================
GrenadeData SatchelShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 10.0;
   damageType         = $TractorDamageType;

   explosionRadius    = 80.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 5;
   totalTime          = 1.5;
   liveTime           = 0.01;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

//=============================================================================================
GrenadeData BettyShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.6;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.0;
   damageType         = $MortarDamageType;
   aimDeflection      = 0.0075;
   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 5.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

GrenadeData AntiBShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.0;
   damageType         = $EnergyDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 2.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

GrenadeData ImpactMortarShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.0;
   damageType         = $MortarDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 0.001;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

GrenadeData VertigoImpactMortarShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.0;
   damageType         = $EnergyDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 0.001;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

GrenadeData EMPGrenadeShell
{
   bulletShapeName    = "mflame.dts";
   explosionTag       = PulseExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.3;
   damageType         = $EMPDamageType;

   explosionRadius    = 25;
   kickBackStrength   = 0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.25;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;
   smokeName              = "fusionbolt.dts";
   soundId = SoundELFFire;
};

GrenadeData EMPMortarShell
{
   bulletShapeName    = "mflame.dts";
   explosionTag       = PulseExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.3;
   damageType         = $EMPDamageType;

   explosionRadius    = 50;
   kickBackStrength   = 0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.25;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;
   smokeName              = "fusionbolt.dts";
   soundId = SoundELFFire;
};

//=============================================================================================
GrenadeData LightningShell
{
   bulletShapeName    = "mflame.dts";
   explosionTag       = PulseExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 30;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.3;
   damageType         = $EMPDamageType;

   explosionRadius    = 50;
   kickBackStrength   = 0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.25;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;
   smokeName              = "fusionbolt.dts";
   soundId = SoundELFFire;
};

//=============================================================================================
RocketData RPM
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = mortarExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 1.0;
	damageType       = $MortarDamageType;
	
	explosionRadius  = 20;
	kickBackStrength = 250.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	
	// rocket specific
	trailType   = 2;                // smoke trail
	trailString = "rsmoke.dts";
	smokeDist   = 6;
	
	soundId = SoundJetHeavy;
};

RocketData ERPM
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = mortarExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 1.0;
	damageType       = $ElectricityDamageType;
	
	explosionRadius  = 20;
	kickBackStrength = 250.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	
	// rocket specific
	trailType   = 2;                // smoke trail
	trailString = "rsmoke.dts";
	smokeDist   = 6;
	
	soundId = SoundJetHeavy;
};

SeekingMissileData SeekingRPM
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = mortarExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 1.0;
	damageType       = $MortarDamageType;
	
	explosionRadius  = 20;
	kickBackStrength = 250.0;
	muzzleVelocity   = 140.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	
	seekingTurningRadius    = 75;
	nonSeekingTurningRadius = 75.0;
	proximityDist     = 10;
	smokeDist         = 3.14;
	
	soundId = SoundJetHeavy;
};

SeekingMissileData SeekingRPM2
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = mortarExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 1.35;
	damageType       = $MortarDamageType;
	
	explosionRadius  = 20;
	kickBackStrength = 600.0;
	muzzleVelocity   = 140.0;
	terminalVelocity = 200.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	
	seekingTurningRadius    = 75;
	nonSeekingTurningRadius = 75.0;
	proximityDist     = 10;
	smokeDist         = 3.14;

	soundId = SoundJetHeavy;
};

RocketData RPEMP
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = PulseExp;
	collisionRadius  = 0.0;
	mass             = 2.0;

	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.1;
	damageType       = $EMPDamageType;

	explosionRadius  = 10;
	kickBackStrength = 0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 220.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;

	// rocket specific
	trailType   = 2;                // smoke trail
	trailString = "rsmoke.dts";
	smokeDist   = 6;

	soundId = SoundJetHeavy;
};

SeekingMissileData SeekingRPEMP
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = PulseExp;
	collisionRadius  = 0.0;

	mass             = 2.0;

	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.1;
	damageType       = $EMPDamageType;

	explosionRadius  = 30;
	kickBackStrength = 0;
	muzzleVelocity   = 200.0;
	terminalVelocity = 250.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;

	seekingTurningRadius    = 75;
	nonSeekingTurningRadius = 75.0;
	proximityDist     = 10;
	smokeDist         = 3.14;

	soundId = SoundJetHeavy;
};

//=============================================================================================
GrenadeData MortarTurretShell
{
	bulletShapeName    = "mortar.dts";
	explosionTag       = mortarExp;
	collideWithOwner   = True;
	ownerGraceMS       = 400;
	collisionRadius    = 1.0;
	mass               = 5.0;
	elasticity         = 0.1;

	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 2.0;
	damageType         = $MortarDamageType;

	explosionRadius    = 50.0;
	kickBackStrength   = 250.0;
	maxLevelFlightDist = 400;
	totalTime          = 1000.0;
	liveTime           = 2.0;
	projSpecialTime    = 0.05;

	inheritedVelocityScale = 0.5;
	smokeName              = "mortartrail.dts";
};

RocketData RPTurretMortar
{
	bulletShapeName  = "rocket.dts";
	explosionTag     = mortarExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 4.0;
	damageType       = $MortarDamageType;
	
	explosionRadius  = 20;
	kickBackStrength = 250.0;
	muzzleVelocity   = 55.0;
	terminalVelocity = 200.0;
	acceleration     = 12.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	
	// rocket specific
	trailType   = 2;                // smoke trail
	trailString = "mortartrail.dts";
//	trailString = "rsmoke.dts";
	smokeDist   = 6;
	
	soundId = SoundJetHeavy;
};

//=============================================================================================
RocketData FlierRocket
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = rocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MissileDamageType;

   explosionRadius  = 9.5;
   kickBackStrength = 250.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "smoke.dts";
   smokeDist   = 15;

   soundId = SoundJetHeavy;
};

//=============================================================================================
RocketData VertigoRocket
{
   bulletShapeName  = "mortar.dts";
   explosionTag     = rocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.15;
   damageType       = $EnergyDamageType;

   explosionRadius  = 13;
   kickBackStrength = 0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 200.0;
   acceleration     = 10.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 3.14;

   soundId = SoundJetHeavy;
};

SeekingMissileData VertigoMissile
{
   bulletShapeName = "mortar.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.1;
   damageType       = $EnergyDamageType;
   explosionRadius  = 13;
   kickBackStrength = 175.0;

   muzzleVelocity    = 100.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

//=============================================================================================
RocketData SuperBlaster2
{
   bulletShapeName  = "shotgunbolt.dts";
   explosionTag     = boltexp1;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.9;
   damageType       = $BlasterDamageType;

   explosionRadius  = 13;
   kickBackStrength = 50.0;
   muzzleVelocity   = 400.0;
   terminalVelocity = 600.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15.7;

   soundId = SoundJetHeavy;
};

//=============================================================================================
SeekingMissileData TurretMissile
{
   bulletShapeName = "rocket.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 2.0;
//   damageValue      = 0.5;
   damageType       = $MissileDamageType;
   explosionRadius  = 30;
//   explosionRadius  = 9.5;
   kickBackStrength = 175.0;

   muzzleVelocity    = 72.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 10;
   smokeDist         = 3.14;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

SeekingMissileData TurretMissile2
{
   bulletShapeName = "rocket.dts";
   explosionTag    = AODStingerExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.35;
   damageType       = $MissileDamageType;
   explosionRadius  = 17.5;
   kickBackStrength = 225.0;

   muzzleVelocity    = 140.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 100;
   nonSeekingTurningRadius = 100;
   proximityDist     = 10;
   smokeDist         = 3.14;
   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };
   inheritedVelocityScale = 0.5;
   soundId = SoundJetHeavy;
};
SeekingMissileData TurretMissile3
{
   bulletShapeName = "rocket.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;
   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 1.0;
   damageType       = $TractorDamageType;
//   damageType       = $MissileDamageType;
   explosionRadius  = 30;
   kickBackStrength = 175.0;
   muzzleVelocity    = 172.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 75;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 15;
   smokeDist         = 3.14;
   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };
   inheritedVelocityScale = 0.5;
   soundId = SoundJetHeavy;
};

function SeekingMissile::updateTargetPercentage(%target)
{
   return GameBase::virtual(%target, "getHeatFactor");
}

//=============================================================================================
// These are kinda oddball dat's
// the lasers really don't fit into
// the typical projectile catagories...
//=============================================================================================

LaserData sniperlaser
{
   laserBitmapName   = "laserpulse.bmp"; //warp
   hitName           = "laserhit.dts";

   damageConversion  = 0.007;
   baseDamageType    = $LaserDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;
};

LaserData sniperlaserWC
{
   laserBitmapName   = "laserpulse.bmp"; //warp
   hitName           = "laserhit.dts";

   damageConversion  = 0.021;
   baseDamageType    = $LaserDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundLaserHit;
};

LaserData SniperLaserAcid
{
   laserBitmapName   = "orange.flag.bmp"; //warp
   hitName           = "laserhit.dts";

   damageConversion  = 0.015;
   baseDamageType    = $AcidBathDamageType;
   DamageType       = $AcidBathDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundLaserHit;
};

LaserData SniperLaserTornado
{
   laserBitmapName   = "zap05.bmp"; //warp
   hitName           = "laserhit.dts";

   damageConversion  = 0.016;
   baseDamageType    = $TornadoDamageType;
   DamageType    = $TornadoDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundLaserHit;
};

LaserData SniperLaserHvyGrav
{
   laserBitmapName   = "shotgunglow.bmp"; //warp
   hitName           = "laserhit.dts";

   damageConversion  = 0.017;
   baseDamageType    = $HvyGravDamageType;
   DamageType    = $HvyGravDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundLaserHit;
};

//=============================================================================================
LaserData DesignatorX
{
   laserBitmapName   = "paintpulse.bmp";
   hitName           = "paint.dts";

   damageConversion  = 0.0;
   baseDamageType    = $NullDamageType;

   beamTime          = 5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = explosion3;
};

//=============================================================================================
LaserData ParticleBeam
{
   laserBitmapName   = "warp.bmp";
   hitName           = "shockwave_large.dts";

   damageConversion  = 0.016;
   baseDamageType    = $PBWDamageType;

   beamTime          = 1;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundFlierCrash;
};

LaserData ParticleBeamA
{
   laserBitmapName   = "warp.bmp";
   hitName           = "shockwave_large.dts";

   damageConversion  = 0.2;
//   baseDamageType    = $ShotgunDamageType;
   baseDamageType    = $PBWDamageType;

   beamTime          = 1;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundFlierCrash;
};

LaserData ParticleBeamD
{
   laserBitmapName   = "beagle.lfemale.bmp";
//   laserBitmapName   = "chair.bmp";
   hitName           = "shockwave_large.dts";

   damageConversion  = 0.06;
   baseDamageType    = $PBWDamageType;

   beamTime          = 1;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundFlierCrash;
};

LaserData ParticleBeam3
{
   laserBitmapName   = "warp.bmp";
   hitName           = "shockwave_large.dts";

//   damageConversion  = 0.03;
   damageConversion  = 0.023;
   baseDamageType    = $PBWDamageType;

   beamTime          = 1;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = SoundFlierCrash;
};

BulletData ParticleBeam2
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.07;
   damageType         = $MBHeatDamageType;

   muzzleVelocity     = 999.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData ParticleBeam4
{
   bulletShapeName    = "shotgunbolt.dts";
   explosionTag       = blasterExp;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.04;
   damageType         = $HFDamageType;
   explosionRadius    = 3.5;

   aimDeflection      = 0.0075;
   muzzleVelocity     = 999.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;

   rotationPeriod = 1;
};

//=============================================================================================
TargetLaserData targetLaser
{
   laserBitmapName   = "paintPulse.bmp";

   damageConversion  = 0.0;
   baseDamageType    = 0;

   lightRange        = 2.0;
   lightColor        = { 0.25, 1.0, 0.25 };

   detachFromShooter = false;
};

//=============================================================================================
LightningData lightningCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 50.0;
   coneAngle        = 35.0;
   damagePerSec      = 0.25;
   energyDrainPerSec = 100.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.125;//075;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

LightningData lightningChargeWC
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 100.0;
   coneAngle        = 85.0;
   damagePerSec      = 0.55;
   energyDrainPerSec = 200.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.125;//075;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

LightningData SuperELFChargeWC
{
	bitmapName       = "fx_lensflare_5.bmp";
//	bitmapName       = "trailadd2.bmp";
//	bitmapName       = "blue_metaltek.bmp";
//	bitmapName       = "tribes1651.bmp";
	damageType       = $ElectricityDamageType;
	boltLength       = 50.0;
	coneAngle        = 175.0;
	damagePerSec      = 3.55;
	energyDrainPerSec = 450.0;
	segmentDivisions = 4;
	numSegments      = 5;
	beamWidth        = 0.125;//075;
	updateTime   = 120;
	skipPercent  = 0.5;
	displaceBias = 0.15;
	lightRange = 3.0;
	lightColor = { 0.25, 0.25, 0.85 };
	soundId = SoundELFFire;
};

//=============================================================================================
LightningData destructiveCharge
{
   bitmapName       = "repairadd.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 200.0;
   coneAngle        = 5.0;
   damagePerSec      = 0.0625;
   energyDrainPerSec = 25.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.125;//075;

   updateTime   = 80;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

LightningData destructiveChargeWC
{
   bitmapName       = "repairadd.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 200.0;
   coneAngle        = 5.0;
   damagePerSec      = 0.625;
   energyDrainPerSec = 175.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.125;//075;

   updateTime   = 80;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

//=============================================================================================
LightningData turretCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;

   boltLength       = 120.0;
   coneAngle        = 85.0;
   damagePerSec      = 0.25;
   energyDrainPerSec = 200.0;

//   boltLength       = 40.0;
//   coneAngle        = 35.0;
//   damagePerSec      = 0.06;
//   energyDrainPerSec = 60.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.125;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

function Lightning::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
   %damVal = %timeSlice * %damPerSec;
   %enVal  = %timeSlice * %enDrainPerSec;

           GameBase::applyDamage(%target, $ElectricityDamageType, %damVal, %pos, %vec, %mom, %shooterId);

   %energy = GameBase::getEnergy(%target);
   %energy = %energy - %enVal;
   if (%energy < 0) {
      %energy = 0;
   }
   GameBase::setEnergy(%target, %energy);
}

//=============================================================================================
RepairEffectData RepairBolt
{
   bitmapName       = "repairadd.bmp";
   boltLength       = 50.0;
   segmentDivisions = 4;
   beamWidth        = 0.125;

   updateTime   = 450;
   skipPercent  = 0.6;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.85, 0.25, 0.25 };
};

function RepairBolt::onAcquire(%this, %player, %target)
{
        %Tp=Gamebase::getTeam(%player);
        %Tt=GameBase::getTeam(%target);
        %client = Player::getClient(%player);

        if (%Tp!=%Tt && %Tt!=-1)
        {        Client::sendMessage(%client, 0, "REPAIR PACK OVERLOAD!! : This Repair pack is NOT Compatable with this Equipment!!~wError_Message.wav");
                %player.Overloaded=true;
                %Pos=GameBase::getPosition(%player);
                playsound(ForceFieldFeedback,%pos);
                return;
        }

        %client = Player::getClient(%player);

        if (%target == %player) {
           %player.repairTarget = -1;
                if (GameBase::getDamageLevel(%player) != 0) {
                        %player.repairRate = 0.05;
                        %player.repairTarget = %player;
                        Client::sendMessage(%client, 0, "AutoRepair On");
                }
                else {
                        Client::sendMessage(%client,0,"Nothing in range");
                        Player::trigger(%player, $WeaponSlot, false);
                        return;
                }
        }
        else {
      %player.repairTarget = %target;
                %player.repairRate   = 0.1;
                if (getObjectType(%player.repairTarget) == "Player") {
                        %rclient = Player::getClient(%player.repairTarget);
                        %name = Client::getName(%rclient);
                }
                else {
                        %name = GameBase::getMapName(%target);
                        if(%name == "") {
                                %name = (GameBase::getDataName(%player.repairTarget)).description;
                        }
                }
                if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
                        Client::sendMessage(%client,0,%name @ " is not damaged");
                        Player::trigger(%player,$WeaponSlot,false);
                        %player.repairTarget = -1;
                        return;
                }
                if (getObjectType(%player.repairTarget) == "Player") {
                        Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
                }
                Client::sendMessage(%client,0,"Repairing " @ %name);
        }
        %rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
        GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function RepairBolt::onRelease(%this, %player)
{
if(%player.overloaded==true)
        {        // Drop & Delete Pack....
                if($matchStarted)
                {        Player::trigger(%player, $WeaponSlot, false);
                        %item=Player::getMountedItem(%player,$BackpackSlot);
                        %mounted = Player::getMountedItem(%player,$WeaponSlot);
                        if (%mounted == RepairGun)
                        {        Player::unmountItem(%player,$WeaponSlot);
                        }
                        else
                        {        // Remount the existing weapon to make sure the RepairGun
                                // is not on the delayed mount "stack".
                                Player::mountItem(%player,%mounted,$WeaponSlot);
                        }

                        Player::decItemCount(%player,%item,1);

                        // Create a Grenade that looks like a repair pack...

                        %obj = newObject("","Mine","pocketnuke1");
                        addToSet("MissionCleanup", %obj);
                        // Drop It.. & Detonate in .2 Second...
                        GameBase::throw(%obj,%player,0.5,false);
                }
                return;
        }

        %object = %player.repairTarget;
        if (%object != -1) {
                %client = Player::getClient(%player);
                if (%object == %player) {
                        Client::sendMessage(%client,0,"AutoRepair Off");
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Client::sendMessage(%client,0,"Repair Done");
                        }
                        else {
                                Client::sendMessage(%client,0,"Repair Stopped");
                        }
                }
                %rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;

                GameBase::setAutoRepairRate(%object,%rate);
        }
}

function RepairBolt::checkDone(%this, %player)
{
        if (Player::isTriggered(%player,$WeaponSlot) &&
       Player::getMountedItem(%player,$WeaponSlot) == RepairGun &&
                 %player.repairTarget != -1) {
                %object = %player.repairTarget;
                if (%object == %player) {
                        if (GameBase::getDamageLevel(%player) == 0) {
                                Player::trigger(%player,$WeaponSlot,false);
                                return;
                        }
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Player::trigger(%player,$WeaponSlot,false);
                                return;
                        }
                }
        }

}

//=============================================================================================
BulletData GatlingBlasterBolt
{
   bulletShapeName    = "shotgunbolt.dts";
   explosionTag       = blasterExp;

   damageClass        = 1;
   damageValue        = 0.1;
   damageType         = $BlasterDamageType;

   muzzleVelocity     = 999.0;
   explosionRadius    = 2.5;
   totalTime          = 10.0;
   liveTime           = 8.255;
   aimDeflection      = 0.0075;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

//=============================================================================================
RocketData AAODRocket
{	
	bulletShapeName  = "rocket.dts";
	explosionTag     = AODStingerExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	damageClass      = 1;
	damageValue      = 0.5;
	damageType       = $MissileDamageType;
	explosionRadius  = 9.5;
	kickBackStrength = 175.0;
	muzzleVelocity   = 75.0;
	terminalVelocity = 80.0;
	acceleration     = 5.0;
	totalTime        = 6.0;
	liveTime         = 7.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	// rocket specific
	trailType   = 2;                
	trailString = "rsmoke.dts";
	smokeDist   = 20;
	soundId = SoundJetHeavy;
};

//=============================================================================================
RocketData IonShockMarlowe
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = ionExp_2;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $NullDamageType;

   explosionRadius  = 350;
   kickBackStrength = -712.0;
//   kickBackStrength = -1012.0;
//   kickBackStrength = 4096.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData MarloweAcidBullet
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = ionExp_2;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.35;
   damageType       = $AcidBathDamageType;

   explosionRadius  = 25;
   kickBackStrength = -42.0;
   muzzleVelocity   = 165.0;
   terminalVelocity = 315.0;
   acceleration     = 15.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData MarloweTornado
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = ionExp_2;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.05;
   damageType       = $TornadoDamageType;

   explosionRadius  = 25;
   kickBackStrength = -42.0;
   muzzleVelocity   = 165.0;
   terminalVelocity = 315.0;
   acceleration     = 15.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

//=============================================================================================
RocketData IonShock2
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp_2;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
//   kickBackStrength = 512.0;
   kickBackStrength = 4096.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData IonShock3
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 1;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData IonShock4
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp_3;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.02;
//   damageValue      = 0;
   damageType       = $EMPDamageType;

   explosionRadius  = 30;
//   explosionRadius  = 16;
   kickBackStrength = 64.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "paint.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData IonShock5
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp_2;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 30;
//   explosionRadius  = 16;
//   kickBackStrength = 512.0;
   kickBackStrength = 768.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData IonShock6
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp_4;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $MethaneDamageType;

   explosionRadius  = 30;
//   explosionRadius  = 16;
   kickBackStrength = 0.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData IonShock7
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp_5;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.01;
   damageType       = $MBHeatDamageType;

   explosionRadius  = 30;
//   explosionRadius  = 16;
   kickBackStrength = 32.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plasmatrail.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData IonShock8
{
   bulletShapeName  = "shockwave.dts";
   explosionTag     = AnnihExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 75;
//   damageValue      = 25;
   damageType       = $PulseDamageType;

   explosionRadius  = 30;
//   explosionRadius  = 30;
   kickBackStrength = 1024;
//   muzzleVelocity   = 60.0;
//   terminalVelocity = 90.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 150.0;
   acceleration     = 5.0;
   totalTime        = 20.0;

   liveTime         = 5.0;
   lightRange       = 5.0;
   lightColor       = { 0.0, 0.7, 1.0 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shockwave.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

RocketData IonShock9
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 5;
//   damageValue      = 15;
//   damageType       = $MBDamageType;
   damageType       = $DoorBusterDamageType;
   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 4;

   soundId = SoundELFIdle;
};

RocketData IonShock10
{
	bulletShapeName  = "shield_large.dts";
	explosionTag     = ionExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	damageClass      = 1;       // 0 impact, 1, radius
	damageValue      = 0.5;
	damageType       = $DropMeDamageType;
	explosionRadius  = 8;
	kickBackStrength = 512.0;
	muzzleVelocity   = 65.0;
	terminalVelocity = 115.0;
	acceleration     = 5.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;

//	rocket specific
	trailType   = 2;                // smoke trail
	trailString = "fusionbolt.dts";
	smokeDist   = 4;

	soundId = SoundELFIdle;
};

//=============================================================================================
RocketData antiMatter
{
   bulletShapeName  = "fusionex.dts";
   explosionTag     = RocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.2;
   damageType       = $PulseDamageType;

   explosionRadius  = 25;
   kickBackStrength = 1024;
   muzzleVelocity   = 100.0;
   terminalVelocity = 150.0;
   acceleration     = 5.0;
   totalTime        = 20.0;

   liveTime         = 5.0;
   lightRange       = 5.0;
   lightColor       = { 0.0, 0.7, 1.0 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionex.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

//=============================================================================================
BulletData EcstacyShot
{
   bulletShapeName    = "rocket.dts";
   explosionTag       = Exp0;

   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.255;
   damageType         = $MissileDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 50.0;


  aimDeflection      = 0.025;
   muzzleVelocity     = 255.0;


   totalTime          = 17.5;
   inheritedVelocityScale = 1.0;
   isVisible          = True;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//=============================================================================================
GrenadeData Deploybox
{
   bulletShapeName    = "smoke.dts";
   explosionTag       = BExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0;
   damageType         = $NullDamageType;

   explosionRadius    = 1;
   kickBackStrength   = 1.0;
   maxLevelFlightDist = 128;
   totalTime          = 4.2;    // special meaning for grenades...
   liveTime           = 4.19;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

        smokeName              = "smoke.dts";
};

function Deploybox::onAdd(%this)
{
        schedule("DeployMines(" @ %this @ ");",4.0,%this);
}

function DeployMines(%this, %player, %item, %team)
{
		GameBase::SetTeam(%this);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "5 5 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "5 -5 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "-5 5 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "-5 -5 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "0 5 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "0 0 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "5 0 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "-5 0 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);


               GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","AntipersonelMine");

                addToSet("MissionCleanup", %obj);
                %padd = "0 -5 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

}

//=============================================================================================
GrenadeData ClusterBomb
{
   bulletShapeName    = "Shockwave_Large.dts";
   explosionTag       = LargeShockwave;
   collideWithOwner   = True;
   ownerGraceMS       = 500;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.4;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 5;
   damageType         = $FlierBombDamageType;

   explosionRadius    = 50.0;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 350;
   totalTime          = 50.0;
   liveTime           = 6.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "shield.dts";
};

function ClusterBomb::onAdd(%this)
{
	schedule("BombSpread(" @ %this @ ");",5.0,%this);
}

function bombspread(%this)
{
                %obj = newObject("","Mine","bomba");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 5.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombb");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 15.0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombc");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombd");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "10.0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "-10.0 0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "0 10. 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "0 -10.0 25";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombe");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 35";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

                %obj = newObject("","Mine","bombf");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 15";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);

}

//=============================================================================================
RocketData TurretDiscShell
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;

   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.75;
   damageType       = $ExplosionDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 150.0;

   muzzleVelocity   = 75.0;
   terminalVelocity = 100.0;
   acceleration     = 15.0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 1;
   trailLength = 100;
   trailWidth  = 0.3;

   soundId = SoundDiscSpin;
};

//=============================================================================================
RocketData ChargedFusionBolt
{
   bulletShapeName  = "fusionbolt.dts";
   explosionTag     = rocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.75;
   damageType       = $FusionDamageType;

   explosionRadius  = 12.5;
   kickBackStrength = 150.0;
   muzzleVelocity   = 265.0;
   terminalVelocity = 400.0;
//   muzzleVelocity   = 65.0;
//   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;

   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "hflame.dts";
   smokeDist   = 3.141592654;

   soundId = SoundJetHeavy;
};

//=============================================================================================
BulletData sniperXBullet
{
	bulletShapeName = "smoke.dts";
	explosionTag = SniperXExp;
	mass = 2.0;
	collisionRadius = 0.0;
	ExplosionRadius = 7.5;
	damageClass = 1;
	damageValue = 1.32;
	damageType = $SniperXDamageType;
	muzzleVelocity = 999;
	totalTime = 9;
	liveTime = 9;
	inheritedVelocityScale = 0.5;
	isVisible = true;
	soundId = soundjetHeavy;
	rotationPeriod = 0;
	lightRange = 1.0;
	lightColor = {1.0, 0.25,0.25};
};

BulletData sniperXBullet2
{
	bulletShapeName = "smoke.dts";
	explosionTag = SniperXExp;
	mass = 2.0;
	collisionRadius = 0.0;
	ExplosionRadius = 7.5;
	damageClass = 1;
	damageValue = 12.0;
	damageType = $SniperXDamageType;
	muzzleVelocity = 999;
	totalTime = 9;
	liveTime = 9;
	inheritedVelocityScale = 0.5;
	isVisible = true;
	soundId = soundjetHeavy;
	rotationPeriod = 0;
	lightRange = 1.0;
	lightColor = {1.0, 0.25,0.25};
};

BulletData sniperXBulletLesser
{
	bulletShapeName = "smoke.dts";
	explosionTag = SniperXExp;
	mass = 2.0;
	collisionRadius = 0.0;
	ExplosionRadius = 5.5;
	damageClass = 1;
	damageValue = 0.81;
	damageType = $SniperXDamageType;
	muzzleVelocity = 999;
	totalTime = 9;
	liveTime = 9;
	inheritedVelocityScale = 0.5;
	isVisible = true;
	soundId = soundjetHeavy;
	rotationPeriod = 0;
	lightRange = 1.0;
	lightColor = {1.0, 0.25,0.25};
};

BulletData sniperXBulletAcid
{
	bulletShapeName = "smoke.dts";
	explosionTag = SniperXExp;
	mass = 2.0;
	collisionRadius = 0.0;
	ExplosionRadius = 5.5;
	damageClass = 1;
	damageValue = 0.32;
	damageType = $AcidBathDamageType;
	muzzleVelocity = 999;
	totalTime = 9;
	liveTime = 9;
	inheritedVelocityScale = 0.5;
	isVisible = true;
	soundId = soundjetHeavy;
	rotationPeriod = 0;
	lightRange = 1.0;
	lightColor = {1.0, 0.25,0.25};
};

BulletData sniperXBulletSpread
{
	bulletShapeName = "smoke.dts";
	explosionTag = SniperXExp;
	mass = 2.0;
	collisionRadius = 0.0;
	ExplosionRadius = 7.5;
	damageClass = 1;
	damageValue = 1.12;
	damageType = $SniperXDamageType;
	aimDeflection      = 0.025;
	muzzleVelocity = 999;
	totalTime = 9;
	liveTime = 9;
	inheritedVelocityScale = 0.5;
	isVisible = true;
	soundId = soundjetHeavy;
	rotationPeriod = 0;
	lightRange = 1.0;
	lightColor = {1.0, 0.25,0.25};
};

//=============================================================================================
GrenadeData ImplosionShell
{
   bulletShapeName    = "armorkit.dts";

  explosionTag       = mineExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 0.1;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.6;
   damageType         = $ShrapnelDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 450;
   totalTime          = 37.0;    // special meaning for grenades...
   liveTime           = 5.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "plasmatrail.dts";
};

function ImplosionShell::onAdd(%this)
{
	ImplosionShell::onDeployISHandgrenadeses(%this);
}

function ImplosionShell::onDeployISHandgrenadeses(%this)
{
	if (GameBase::isAtRest(%this))
		schedule("DeployISHandgrenadeses(" @ %this @ " , 5);",1.0,%this);
	else
		schedule("ImplosionShell::onDeployISHandgrenadeses(" @ %this @ ");",1.0,%this);
}

function DeployISHandgrenadeses(%this, %count)
{
                %obj = newObject("","Mine","MDHandgrenade1");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-5,true);
                %obj = newObject("","Mine","MDHandgrenade2");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-7.5,false);
                %obj = newObject("","Mine","MDHandgrenade3");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,5,false);
                %obj = newObject("","Mine","MDHandgrenade4");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,7.5,true);
                %obj = newObject("","Mine","MEHandgrenade5");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-1,false);
                %obj = newObject("","Mine","MEHandgrenade1");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-5,true);
                %obj = newObject("","Mine","MEHandgrenade2");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-7.5,false);
                %obj = newObject("","Mine","MEHandgrenade3");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,5,false);
                %obj = newObject("","Mine","MEHandgrenade4");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,7.5,true);
                %obj = newObject("","Mine","MEHandgrenade5");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-1,false);
                %obj = newObject("","Mine","MHandgrenade1");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-5,true);
                %obj = newObject("","Mine","MHandgrenade2");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-7.5,false);
                %obj = newObject("","Mine","MHandgrenade3");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,5,false);
                %obj = newObject("","Mine","MHandgrenade4");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,7.5,true);
                %obj = newObject("","Mine","MHandgrenade5");
                addToSet("MissionCleanup", %obj);
                GameBase::throw(%obj,%this,-1,false);
}

//=============================================================================================
RepairEffectData reassemblerBolt
{
   bitmapName       = "repairadd.bmp";
   boltLength       = 50.0;
   segmentDivisions = 4;
   beamWidth        = 0.125;

   updateTime   = 450;
   skipPercent  = 0.6;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.85, 0.25, 0.25 };
};

function reassemblerBolt::onAcquire(%this, %player, %target)
{
        %client = Player::getClient(%player);

        if (%target == %player) {
           %player.repairTarget = -1;

                if (GameBase::getDamageLevel(%player) != 0) {
                        %player.repairRate = 0.2;
                        %player.repairTarget = %player;
                        Client::sendMessage(%client, 0, "AutoRepair On");
                }
                else {
                        Client::sendMessage(%client,0,"Nothing in range");
                        Player::trigger(%player, $WeaponSlot, false);
                        return;
                }
        }
        else {
      %player.repairTarget = %target;
                %player.repairRate   = 0.75;
//                %player.repairRate   = 0.15;
                if (getObjectType(%player.repairTarget) == "Player") {
                        %rclient = Player::getClient(%player.repairTarget);
                        %name = Client::getName(%rclient);
                }
                else {
                        %name = GameBase::getMapName(%target);
                        if(%name == "") {
                                %name = (GameBase::getDataName(%player.repairTarget)).description;
                        }
                }
                if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
                        Client::sendMessage(%client,0,%name @ " isn't damaged");
                        Player::trigger(%player,$WeaponSlot,false);
                        %player.repairTarget = -1;
                        return;
                }
                if (getObjectType(%player.repairTarget) == "Player") {
                        Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
                }
                Client::sendMessage(%client,0,"Repairing " @ %name);
        }
        %rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
        GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function reassemblerBolt::onRelease(%this, %player)
{
        %object = %player.repairTarget;
        if (%object != -1) {
                %client = Player::getClient(%player);
                if (%object == %player) {
                        Client::sendMessage(%client,0,"AutoRepair Off");
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Client::sendMessage(%client,0,"Repair Done");
                        }
                        else {
                                Client::sendMessage(%client,0,"Repair Stopped");
                        }
                }
                %rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;

                GameBase::setAutoRepairRate(%object,%rate);
        }
}

function reassemblerBolt::checkDone(%this, %player)
{
        if (Player::isTriggered(%player,$WeaponSlot) &&
       Player::getMountedItem(%player,$WeaponSlot) == reassembler &&
                 %player.repairTarget != -1) {
                %object = %player.repairTarget;
                if (%object == %player) {
                        if (GameBase::getDamageLevel(%player) == 0) {
                                Player::trigger(%player,$WeaponSlot,false);
                                return;
                        }
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Player::trigger(%player,$WeaponSlot,false);
                                return;
                        }
                }
        }
}

//=============================================================================================
RepairEffectData SuperRBolt
{	bitmapName			= "LightningNew.bmp";
	boltLength			= 200.0;
	segmentDivisions		= 6;
	beamWidth			= 0.175;
	updateTime			= 450;
	skipPercent			= 0.6;
	displaceBias		= 0.15;
	lightRange			= 6.0;
	lightColor			= { 0.85, 0.25, 0.25 };
};

function SuperRBolt::onAcquire(%this, %player, %target)
{
        %client = Player::getClient(%player);

        if (%target == %player) {
           %player.repairTarget = -1;
                if (GameBase::getDamageLevel(%player) != 0) {
                        %player.repairRate = 1.2;
                        %player.repairTarget = %player;
                        Client::sendMessage(%client, 0, "AutoRepair On");
                }
                else {
                        Client::sendMessage(%client,0,"Nothing in range");
                        Player::trigger(%player, $WeaponSlot, false);
                        return;
                }
        }
        else {
      %player.repairTarget = %target;
                %player.repairRate   = 10.0;
//                %player.repairRate   = 0.4;
                if (getObjectType(%player.repairTarget) == "Player") {
                        %rclient = Player::getClient(%player.repairTarget);
                        %name = Client::getName(%rclient);
                }
                else {
                        %name = GameBase::getMapName(%target);
                        if(%name == "") {
                                %name = (GameBase::getDataName(%player.repairTarget)).description;
                        }

               }
                if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
                        Client::sendMessage(%client,0,%name @ " isn't damaged");
                        Player::trigger(%player,$WeaponSlot,false);
                        %player.repairTarget = -1;
                        return;
                }
                if (getObjectType(%player.repairTarget) == "Player") {
                        Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
                }
                Client::sendMessage(%client,0,"Repairing " @ %name);
        }
        %rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
        GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function SuperRBolt::onRelease(%this, %player)
{
        %object = %player.repairTarget;
        if (%object != -1) {
                %client = Player::getClient(%player);
                if (%object == %player) {
                        Client::sendMessage(%client,0,"AutoRepair Off");
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Client::sendMessage(%client,0,"Repair Done");
                        }
                        else {
                                Client::sendMessage(%client,0,"Repair Stopped");
                        }
                }
                %rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;

                GameBase::setAutoRepairRate(%object,%rate);
        }
}

function SuperRBolt::checkDone(%this, %player)
{
        if (Player::isTriggered(%player,$WeaponSlot) &&
       Player::getMountedItem(%player,$WeaponSlot) == AODSuperRGun &&
                 %player.repairTarget != -1) {
                %object = %player.repairTarget;
                if (%object == %player) {
                        if (GameBase::getDamageLevel(%player) == 0) {
                                Player::trigger(%player,$WeaponSlot,false);
                                return;
                        }
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Player::trigger(%player,$WeaponSlot,false);
                                return;
                        }
                }
        }
}

//=============================================================================================
RepairEffectData MegaRBolt
{
	bitmapName			= "paintglow.bmp";
//	bitmapName			= "LightningNew.bmp";
	boltLength			= 400.0;
	segmentDivisions		= 6;
	beamWidth			= 0.175;
	updateTime			= 450;
	skipPercent			= 0.6;
	displaceBias		= 0.15;
	lightRange			= 6.0;
	lightColor			= { 0.85, 0.25, 0.25 };
};

function MegaRBolt::onAcquire(%this, %player, %target)
{
        %client = Player::getClient(%player);

        if (%target == %player) {
           %player.repairTarget = -1;
                if (GameBase::getDamageLevel(%player) != 0) {
                        %player.repairRate = 3.2;
                        %player.repairTarget = %player;
                        Client::sendMessage(%client, 0, "AutoRepair On");
                }
                else {
                        Client::sendMessage(%client,0,"Nothing in range");
                        Player::trigger(%player, $ExtraWeaponSlotB, false);
                        return;
                }
        }
        else {
      %player.repairTarget = %target;
                %player.repairRate   = 20.0;
//                %player.repairRate   = 0.4;
                if (getObjectType(%player.repairTarget) == "Player") {
                        %rclient = Player::getClient(%player.repairTarget);
                        %name = Client::getName(%rclient);
                }
                else {
                        %name = GameBase::getMapName(%target);
                        if(%name == "") {
                                %name = (GameBase::getDataName(%player.repairTarget)).description;
                        }

               }
                if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
                        Client::sendMessage(%client,0,%name @ " isn't damaged");
                        Player::trigger(%player,$ExtraWeaponSlotB,false);
                        %player.repairTarget = -1;
                        return;
                }
                if (getObjectType(%player.repairTarget) == "Player") {
                        Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
                }
                Client::sendMessage(%client,0,"Repairing " @ %name);
        }
        %rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
        GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function MegaRBolt::onRelease(%this, %player)
{
        %object = %player.repairTarget;
        if (%object != -1) {
                %client = Player::getClient(%player);
                if (%object == %player) {
                        Client::sendMessage(%client,0,"AutoRepair Off");
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Client::sendMessage(%client,0,"Repair Done");
                        }
                        else {
                                Client::sendMessage(%client,0,"Repair Stopped");
                        }
                }
                %rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;

                GameBase::setAutoRepairRate(%object,%rate);
        }
}

function MegaRBolt::checkDone(%this, %player)
{
        if (Player::isTriggered(%player,$ExtraWeaponSlotB) &&
       Player::getMountedItem(%player,$ExtraWeaponSlotB) == ReassemblerC &&
                 %player.repairTarget != -1) {
                %object = %player.repairTarget;
                if (%object == %player) {
                        if (GameBase::getDamageLevel(%player) == 0) {
                                Player::trigger(%player,$ExtraWeaponSlotB,false);
                                return;
                        }
                }
                else {
                        if (GameBase::getDamageLevel(%object) == 0) {
                                Player::trigger(%player,$ExtraWeaponSlotB,false);
                                return;
                        }
                }
        }
}

//=============================================================================================
GrenadeData TeleportShock
{
        bulletShapeName = "breath.dts";
         explosionTag = TeleportExp;
         collideWithOwner = false;
         ownerGraceMS = 500;
         collisionRadius = 0.0;
         mass = 0.0;
         elasticity = 0.1;
         damageClass = 0;
         damageValue = 0.01;
         damageType = $NullDamageType;
         explosionRadius = 10;
         kickBackStrength = 0.0;
         maxLevelFlightDist = 1;
         totalTime = 0.05;
         liveTime = 0.05;
         projSpecialTime = 0.05;
         inheritedVelocityScale = 1.0;
         smokeName = "breath.dts";
 };

//=============================================================================================
GrenadeData Electricity
{
        bulletShapeName = "breath.dts";
        explosionTag = TurretExp2;
        collideWithOwner = false;
        ownerGraceMS = 500;
        collisionRadius = 0.0;
        mass = 0.0;
        elasticity = 0.1;
        damageClass = 0;
        damageValue = 0;
        damageType = $ElectricityDamageType;
        explosionRadius = 1;
        kickBackStrength = 0.0;
        maxLevelFlightDist = 1;
        totalTime = 0.05;
        liveTime = 0.05;
        projSpecialTime = 0.05;
        inheritedVelocityScale = 1.0;
        smokeName = "breath.dts";
};

GrenadeData OnFire
{
        bulletShapeName = "fiery.dts";
        explosionTag = OnFireExp1;
        collideWithOwner = false;
        ownerGraceMS = 500;
        collisionRadius = 0.0;
        mass = 0.0;
        elasticity = 0.1;
        damageClass = 0;
        damageValue = 0;
        damageType = $NullDamageType;
        explosionRadius = 1;
        kickBackStrength = 0.0;
        maxLevelFlightDist = 1;
        totalTime = 0.05;
        liveTime = 0.05;
        projSpecialTime = 0.05;
        inheritedVelocityScale = 1.0;
        smokeName = "fiery.dts";
};

GrenadeData AcidBthBody
{
        bulletShapeName = "dustplume.dts";
        explosionTag = AcidBthExp1;
        collideWithOwner = false;
        ownerGraceMS = 500;
        collisionRadius = 0.0;
        mass = 0.0;
        elasticity = 0.1;
        damageClass = 0;
        damageValue = 0;
        damageType = $NullDamageType;
        explosionRadius = 1;
        kickBackStrength = 0.0;
        maxLevelFlightDist = 1;
        totalTime = 0.05;
        liveTime = 0.05;
        projSpecialTime = 0.05;
        inheritedVelocityScale = 1.0;
        smokeName = "dustplume.dts";
};

//=============================================================================================
RepairEffectData PowerCharge
{
        bitmapName = "lightningNew.bmp";
        boltLength = 20.0;
        segmentDivisions = 2;
        beamWidth = 0.27;
        updateTime = 100;
        skipPercent = 0.5;
        displaceBias = 0.03;
        lightRange = 6.0;
        lightColor = { 0.25, 0.25, 1.0 };
};

function PowerCharge::onAcquire(%this, %player, %target) 
{
        %client = Player::getClient(%player);
        %player.powerTarget = "";
        %objType = getObjectType(%target);
        if(%objType == "Player") {
                if(%target == %player) {
                        Client::sendMessage(%client,0,"Nothing to power in range");
                        Player::trigger(%player, $WeaponSlot, false);
                        return;
                }
                %tc = Player::getClient(%target);
                if(%tc.isPowered) {
                        Player::trigger(%player, $WeaponSlot, false);
                        return;
                }
                Client::sendMessage(%client,0, "Enhancing energy systems of " @ Client::getName(%tc));
                Client::sendMessage(%tc,0, "Energy systems being enhanced by " @ Client::getName(%client));
                %tc.isPowered = true;
                %player.powerTarget = %target;
                GameBase::setRechargeRate(%target, 34);
                return;
        } 
        %obj = GameBase::getDataName(%target);
        if (GameBase::getDamageState(%target) != "Enabled") 
	  {
                Client::sendMessage(%client,0, %obj.description @ " is damaged");
                Player::trigger(%player, $WeaponSlot, false);
                return;
        }
        if(GameBase::isPowered(%target)) 
	  {
                Client::sendMessage(%client,0, %obj.description @ " is already powered");
                Player::trigger(%player, $WeaponSlot, false);
                return;
        }
        if(%obj == "InventoryStation" || %obj == "AmmoStation" || %obj == "CommandStation" || %obj == "MobileInvent" || %obj == "PortaC" || %obj == "ArtilleryTurret" || %obj == "VehicleStation" || %obj == "VehiclePad" || %obj == "Teleporter" || %obj == "Shieldgen") {
                %player.powerTarget = %target;
                Client::sendMessage(%client,0, "Powering " @ %obj.description);
                GameBase::playSequence(%target,0,"power");
                GameBase::playSequence(%target,1);
                GameBase::setActive(%target, true);
                %target.freeP = true;
        } else if(%obj == "PlasmaTurret" || %obj == "ELFTurret" || %obj == "RocketTurret" || %obj == "IndoorTurret" || %obj == "PulseSensor" || %obj == "MediumPulseSensor") {
                %player.powerTarget = %target;
                Client::sendMessage(%client,0, "Powering " @ %obj.description);
                %target.shieldStrength = 0.1;
                GameBase::setRechargeRate(%target,20);
                GameBase::setActive(%target, true);
                GameBase::playSequence(%target,0,"power");
        } else {


               Client::sendMessage(%client,0,"Nothing to power in range");
                Player::trigger(%player, $WeaponSlot, false);
        }
}

function PowerCharge::onRelease(%this, %player) 
{
        if (%player.powerTarget != "") 
	  {
                %objType = getObjectType(%player.powerTarget);
		    if(%objType == "Player") {
                        Player::getClient(%player.powerTarget).isPowered = false;
                        GameBase::setRechargeRate(%player.powerTarget, 10);
                        %player.powerTarget = "";
                        return;
                }
                if(!GameBase::isPowered(%player.powerTarget)) 
		    {
                        %obj = GameBase::getDataName(%player.powerTarget);
                        if(%obj == "InventoryStation" || %obj == "AmmoStation" || %obj == "CommandStation" || %obj == "MobileInvent" || %obj == "PortaC" || %obj == "ArtilleryTurret" || %obj == "VehicleStation" || %obj == "VehiclePad" || %obj == "Teleporter" || %obj == "Shieldgen") {
                                (%player.powerTarget).freeP = false;
                                Station::weaponCheck(%player.powerTarget);
                                GameBase::stopSequence(%player.powerTarget,0);
                                GameBase::setSequenceDirection(%player.powerTarget,1,0);
                                GameBase::pauseSequence(%player.powerTarget,1);
                                GameBase::stopSequence(%player.powerTarget,2);
                                Station::checkTarget(%player.powerTarget);
                                %obj = (%player.powerTarget).lastPlayer;
                                GameBase::setActive(%player.powerTarget, false);
                                if(%player.powerTarget == %obj.inStation) %obj.inStation = false;
                        } else if(%obj == "PlasmaTurret" || %obj == "ELFTurret" || %obj == "RocketTurret" || %obj == "IndoorTurret" || %obj == "PulseSensor" || %obj == "MediumPulseSensor") {
                                GameBase::setActive(%player.powerTarget, false);
                                (%player.powerTarget).shieldStrength = 0;
                                GameBase::setRechargeRate(%player.powerTarget,0);
                                GameBase::pauseSequence(%player.powerTarget,0);
                                Turret::checkOperator(%player.powerTarget);
                        }
                }
                %player.powerTarget = "";
        }
}

//=============================================================================================
RocketData F1aker { bulletShapeName = "breath.dts"; explosionTag = fakeExp; collisionRadius = 0.0; mass = 2.0; damageClass = 1; damageValue = 0; damageType = $ExplosionDamageType; explosionRadius = 0; kickBackStrength = 0.0; muzzleVelocity = 65.0; terminalVelocity = 80.0; acceleration = 5.0; totalTime = 0.1; liveTime = 0.1; lightRange = 0.0; lightColor = { 0.4, 0.4, 1.0 }; inheritedVelocityScale = 0.5; };

$DamageScale[ShortCoolProj, $ImpactDamageType] = 1.0;
$DamageScale[ShortCoolProj, $MissileDamageType] = 1.0;

function F1aker::onAdd(%this) {
        %t = $F1aky;
        %markerPos = $F1aky2;
        $F1aky = "";
        $F1aky2 = "";
        %trans = GameBase::getTransform(%this);
        %rot = getWord(%trans, 3) @ " 0 " @ getWord(%trans, 5);
        %f = Vector::getFromRot(%rot, 3.5, 2);
        %vehicle = newObject("",flier,ShortCoolProj,true);
        Gamebase::setMapName(%vehicle,"Missile");
        addToSet("MissionCleanup", %vehicle);
        %client = GameBase::getControlClient(%t);
        GameBase::setTeam(%vehicle,Client::getTeam(%client));
        GameBase::startFadeIn(%vehicle);
        %vehicle.clLastMount = %client;
        GameBase::setPosition(%vehicle,Vector::add(%markerPos, %f));
        GameBase::setRotation(%vehicle,%rot);
        %client.safet = true;
        GameBase::playSound(%vehicle,bigExplosion1,0);
        doneposs(%client);
        remoteEval(%client, SetControls, true);
        Client::setControlObject(%client, %vehicle);
}

FlierData ShortCoolProj {
        description = "Phoenix Missile";
        explosionId = SockExp;
        className = "Vehicle";
        shapeFile = "rocket";
        shieldShapeName = "shield_medium";
        mass = 9.0; drag = 1.5;
        density = 1.2;
        maxBank = 10;
        maxPitch = 5000;
        maxSpeed = 52;
        minSpeed = 30;
        lift = 0;
        maxAlt = 10000;
        maxVertical = 10;
        destroyDamage = 0.1;
        maxDamage = 0.1;
        damageLevel = {0.1, 0.1};
        maxEnergy = 10;
        accel = 10.0;
        groundDamageScale = 1000.0;
        repairRate = 0;
        damageSound = SoundFlierCrash;
        ramDamage = 0.2;
        ramDamageType = $MissileDamageType;
        visibleToSensor = true;
        shadowDetailMask = 2;
        idleSound = SoundWindDgust;
        moveSound = SoundWindDgust;
        visibleDriver = true;
        driverPose = 22;
};

RocketData FastPimpinMissile 
{ 
	bulletShapeName = "rocket.dts"; 
	explosionTag = nappyExp; 
	collisionRadius = 0.0; 
	mass = 2.0; 
	damageClass = 1; 
	damageValue = 1.4; 
	damageType = $ShrapnelDamageType;
	explosionRadius = 10; 
//	explosionRadius = 20; 
	kickBackStrength = 200.0; 
	muzzleVelocity = 190.0; 
	terminalVelocity = 255.0; 
	acceleration = 5.0; 
	totalTime = 10.0; 
	liveTime = 11.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.0, 0.0 }; 
	inheritedVelocityScale = 0.5; 
	trailType = 2; 
	trailString = "plasmatrail.dts"; 
	smokeDist = 1.8; 
	soundId = SoundJetHeavy; 
};

//=============================================================================================
LightningData tractorCharge
{
   bitmapName = "lightningNewSub.bmp";

   boltLength = 350.0;
   coneAngle = 15.0;
   damagePerSec = 0.2;
   energyDrainPerSec = 0;
   segmentDivisions = 0;
   numSegments = 5;
   beamWidth = 0.25;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 2.0;
   lightColor = { 1.00, 0.25, 0.25 };
};

function tractorCharge::pull(%client, %target)
{ 
	%myPos = GameBase::getPosition(%client);
	%yourPos = GameBase::getPosition(%target);
	%myRot = GameBase::getRotation(%client); 

	%dir = getWord(%myRot, 0) @ " " @ getWord(%myRot, 1) @ " " @ 3.14 + getWord(%myRot, 2);
	//make dir face opposite direction, thus pulls toward 

	%myFlatPos = getWord(%myPos, 0) @ " " @ getWord(%myPos, 1) @ " 0";
	%yourFlatPos = getWord(%yourPos, 0) @ " " @ getWord(%yourPos, 1) @ " 0"; 
	%dist = Vector::getDistance(%myFlatPos, %yourFlatPos);
	//so Z isn't in distance & doesn't make you go FLYING if you have a huge height difference

	%force = 20; //not too hard and fast

	%height = 10 * (getWord(%myPos, 2) - getWord(%yourPos, 2)); //diff in z-values 

	%diffVector = Vector::getFromRot(%dir, -%force, (-%height / %force)); 

	if(%client.tractorMode == 1)
		%diffVector = Item::getVelocity(%target);

	Item::setVelocity(%client, %diffVector); //the actual movement function
} 

function tractorCharge::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
	tractorCharge::pull(%shooterID,%target);
} 

//=============================================================================================
LightningData OmegaBolt
{
   bitmapName       = "shotgunbolt.bmp";

   damageType       = $TractorDamageType;
//   damageType       = $ElectricityDamageType;
   boltLength       = 100.0;
//   boltLength       = 40.0;
   coneAngle        = 350.0;
   damagePerSec      = 0.25;
//   damagePerSec      = 0.03;
   energyDrainPerSec = 10.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.155;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

function OmegaBolt::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
   %dectructiveValue = %DestructiveRotation;
   %DestructiveRotation = GameBase::GetRotation(Client::getOwnedObject(%shooterId));
   %velocity = -20;
   %destructiveShooterDir = Vector::getFromRot(GameBase::getRotation(%shooterId),%velocity,%destuctiveValue);
   Player::applyImpulse(%target, %destructiveShooterDir);
   
   %player = client::getOwnedObject(%shooterId);
   %armor = Player::getArmor(%shooterId);
   %targetDestruction = GameBase::getDamageState(%targetDestuction);

   %damVal = %timeSlice * %damPerSec;
   %enVal  = %timeSlice * %enDrainPerSec;

   GameBase::applyDamage(%target, $TractorDamageType, %damVal, %pos, %vec, %mom, %shooterId);
//   GameBase::applyDamage(%target, $ElectricityDamageType, %damVal, %pos, %vec, %mom, %shooterId);

   %energy = GameBase::getEnergy(%target);
   %energy = %energy - %enVal;
   if(%energy < 0) %energy = 0;
   GameBase::setEnergy(%target, %energy);

   if(%targetDestruction != "Destroyed")
   {
   %destructorHealth = GameBase::getDamageLevel(%player);
   if(%destructorHealth != 0) 
   GameBase::setDamageLevel(%player,%destructorHealth - (%enVal * 0.0054));
   }
}

//=============================================================================================
RepairEffectData RepairItemBolt { bitmapName = "blue_blink0.bmp"; boltLength = 5.0; segmentDivisions = 4; beamWidth = 0.125; updateTime = 450; skipPercent = 0.6; displaceBias = 0.15; lightRange = 15.0; lightColor = { 1, 0.25, 0.25 }; }; 

function RepairItemBolt::onAcquire(%this, %player, %target) { 
	%client = Player::getClient(%player); 

	if (GameBase::getDamageLevel(%target) == 0) { 
		GameBase::repairDamage(%player,0.20); 
		if(%client.poisonTime > 0) {
			$poisonTime[%clientId] -= 10;
		}
		if(%client.burnTime > 0) {
			$burnTime[%clientId] -= 30;
		}
		if(%client.empTime > 2) $empTime[%clientId] -= 5;
		Player::decItemCount(%player,"RepairKit");
		return; 
	} 

	%name = GameBase::getMapName(%target); 
	if(%name == "") { 
		%name = (GameBase::getDataName(%target)).description; 
	} 

	Player::decItemCount(%player,"RepairKit");
	
	Client::sendMessage(%client,0,"Repair Kit used on " @ %name); 

	GameBase::repairDamage(%target,0.27); 
	return; 
} 

//=============================================================================================
RocketData IonBolt 
{ 
	bulletShapeName = "fusionbolt.dts"; 
	explosionTag = turretExp; 
	collisionRadius = 0.0; 
	mass = 2.0; 
	damageClass = 1; 
	damageValue = 0.2; 
	damageType = $ShotgunDamageType; 
	explosionRadius = 6; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 200.0; 
	terminalVelocity = 200.0; 
	acceleration = 5.0; 
	totalTime = 10.0; 
	liveTime = 11.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.7, 0.5 }; 
	inheritedVelocityScale = 0.5; 
	trailType = 1; 
	trailLength = 50; 
	trailWidth = 0.3; 
	soundId = SoundJetHeavy; 
};

LaserData GatlingLaser
{
	laserBitmapName   = "lightningNew.bmp";
	hitName           = "shield.dts";
	damageConversion  = 0.10;
	baseDamageType    = $LaserDamageType;
	beamTime          = 2.5;
	lightRange        = 5.0;
	lightColor        = { 0.01, 0.01, 1.25 };
	detachFromShooter = true;
	hitSoundId        = SoundLaserHit;
};


RocketData PlasmaCannonBoltWC
{ 
	bulletShapeName  = "fiery.dts";
	explosionTag = mortarExp; 
//	explosionTag = plasmaExp; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
    	damageValue = 35.0; 
	damageType = $PlasmaDamageType;
	explosionRadius = 15; 
	kickBackStrength = 0.0; 
	muzzleVelocity   = 75.0;
	terminalVelocity = 155.0;
	acceleration     = 25.0;
	totalTime = 3.0; 
	liveTime = 3.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.0, 0.05 }; 
	inheritedVelocityScale = 0.0; 
	trailType   = 2;
	trailString = "fiery.dts";
	smokeDist   = 4.8;
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonBolt
{ 
	bulletShapeName = "plasmaex.dts"; 
	explosionTag = plasmaExp; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
    	damageValue = 20.0; 
//    	damageValue = 0.8; 
	damageType = $PlasmaDamageType;
	explosionRadius = 15; 
	kickBackStrength = 0.0; 
	muzzleVelocity   = 25.0;
	terminalVelocity = 55.0;
	acceleration     = 5.0;
	totalTime = 5.0; 
	liveTime = 6.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.0, 0.05 }; 
	inheritedVelocityScale = 0.0; 
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonBolt2

{ 
	bulletShapeName = "plasmabolt.dts"; 
	explosionTag = plasmaExp; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
    	damageValue = 0.5; 
	damageType = $PlasmaDamageType;
	explosionRadius = 10; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 35.0; 
	terminalVelocity = 45.0;
	acceleration = 35; 
	totalTime = 5.0; 
	liveTime = 5.0; 
	lightRange = 5.0; 
	lightColor = { 2.0, 0.0, 0.0 }; 
	inheritedVelocityScale = 0.0; 
	trailType   = 2;
	trailString = "plasmatrail.dts";
	smokeDist   = 180.0;
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonShock
{
	bulletShapeName  = "plasmabolt.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 0.0;
	damageClass      = 1;
	damageValue      = 1.0;
	damageType       = $PlasmaDamageType;
	explosionRadius  = 15.0;
	kickBackStrength = 0;
	muzzleVelocity   = 35.0;
	terminalVelocity = 55.0;
	acceleration     = 25.0;
	totalTime        = 5.0;
	liveTime         = 5.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.0, 0.0 };
	inheritedVelocityScale = 0.0;

	trailType   = 2;
	trailString = "plasmabolt.dts";
	smokeDist   = 140.0;
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonShock2
{
	bulletShapeName  = "plasmaex.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 0.0;
	damageClass      = 1;
	damageValue      = 1.0;
	damageType       = $PlasmaDamageType;
	explosionRadius  = 15.0;
	kickBackStrength = 0;
	muzzleVelocity   = 35.0;
	terminalVelocity = 65.0;
	acceleration     = 25.0;
	totalTime        = 5.0;
	liveTime         = 5.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.0, 0.0 };
	inheritedVelocityScale = 0.0;

	trailType   = 2;
	trailString = "plasmatrail.dts";
	smokeDist   = 160.0;
	soundId = SoundJetHeavy;
};

//========================================================================
RocketData LasCannonBolt
{ 
	bulletShapeName = "enbolt.dts"; 
	explosionTag = ShockwaveFour; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 0;
	damageValue = 10.0; 
//	damageValue = 35.0; 
//	damageValue = 0.8; 
	damageType = $LaserDamageType;
	explosionRadius = 2; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 350.0; 
	terminalVelocity = 3000.0;
	acceleration = 500; 
	totalTime = 14.0; 
	liveTime = 14.0; 
	lightRange = 5.0; 
	lightColor = { 0.0, 0.0, 1.5 }; 
	inheritedVelocityScale = 0.0; 
	trailType = 1;
	trailLength = 3000; 
	trailWidth = 2.0; 
	soundId = SoundJetHeavy;
};

RocketData LasCannonBolt2
{ 
	bulletShapeName = "enbolt.dts"; 
	explosionTag = ShockwaveFour; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 0;
    	damageValue = 0.5; 
	damageType = $LaserDamageType;
	explosionRadius = 2; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 350.0; 
	terminalVelocity = 3000.0;
	acceleration = 500; 
	totalTime = 14.0; 
	liveTime = 14.0; 
	lightRange = 5.0; 
	lightColor = { 0.0, 0.0, 1.5 }; 
	inheritedVelocityScale = 0.0; 
	trailType = 1;
	trailLength = 3000; 
	trailWidth = 1.0; 
	soundId = SoundJetHeavy;
};

RocketData LasCannonShock
{
	bulletShapeName  = "shield.dts";
	explosionTag     = ShockwaveFour;
	collisionRadius  = 0.0;
	mass             = 0.0;
	damageClass      = 0;
	damageValue      = 1.0;
	damageType       = $LaserDamageType;
	explosionRadius  = 5.0;
	kickBackStrength = 0;
	muzzleVelocity   = 350.0;
	terminalVelocity = 4000.0;

	acceleration     = 500.0;
	totalTime        = 14.0;
	liveTime         = 14.0;
	lightRange       = 5.0;
	lightColor       = { 0.0, 0.1, 1.5 };
	inheritedVelocityScale = 0.0;

	trailType   = 2;
	trailString = "shield.dts";
	smokeDist   = 20.0;
	soundId = SoundJetHeavy;
};

TargetLaserData railLaser
{
   laserBitmapName   = "laserPulse.bmp";
   damageConversion  = 0.0;
   baseDamageType    = $LaserDamageType;
   detachFromShooter = false;
};

//=============================================================================================
LightningData FlierCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 21.0;
   coneAngle        = 55.0;
   damagePerSec      = 0.2;
   energyDrainPerSec = 0.0;
   segmentDivisions = 6;
   numSegments      = 8;
   beamWidth        = 0.125;

   updateTime   = 100;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

//=============================================================================================
BulletData Flamesz
{
   bulletShapeName    = "tumult_large.dts";
   explosionTag       = flameEXP;
   mass               = 0.05;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.128;
   damageType         = $FlameDamageType;

   explosionRadius  = 30;
   kickBackStrength = 0;

   aimDeflection      = 0.02;
   muzzleVelocity     = 96.0;
   totalTime          = 1;
   inheritedVelocityScale = 1.0;
   isVisible          = True;
};

//=============================================================================================
BulletData FusionBullet
{
   bulletShapeName    = "enbolt.dts";
   explosionTag       = energyExp;

   damageClass        = 1;
   damageValue        = 0.175;
   damageType         = $FusionDamageType;
   explosionRadius  = 5.5;
   aimDeflection      = 0.015;
   muzzleVelocity     = 255.0;
   totalTime          = 4.0;
   liveTime           = 2.0;

   lightRange         = 3.0;
   lightColor         = { 0.25, 0.25, 1.0 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

BulletData FusionMarloweBullet
{
   bulletShapeName    = "enbolt.dts";
   explosionTag       = Exp0;
   damageClass        = 1;
   damageValue        = 0.125;
   damageType         = $FusionDamageType;
   explosionRadius    = 7.5;
   aimDeflection      = 0.015;
   kickBackStrength   = 50.0;
   muzzleVelocity     = 255.0;
   totalTime          = 14.0;
   lightRange         = 3.0;
   lightColor         = { 0.25, 0.25, 1.0 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;
   rotationPeriod = 1;
   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData EcstacyBullet
{
   bulletShapeName    = "rocket.dts";
   explosionTag       = Exp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;
   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.125;
   damageType         = $MissileDamageType;
   explosionRadius  = 7.5;
   kickBackStrength = 50.0;
   aimDeflection      = 0.025;
   muzzleVelocity     = 255.0;
   totalTime          = 17.5;
   inheritedVelocityScale = 1.0;
   isVisible          = True;
   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//=============================================================================================
RocketData Meteor
{
   bulletShapeName  = "mortar.dts";
   explosionTag       = mortarExp;
//   explosionTag     = LargeShockwave;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 180;
   damageType       = $MeteorDamageType;

   explosionRadius  = 30.0;
   kickBackStrength = 150.0;
   muzzleVelocity   = 210.0;
   terminalVelocity = 310.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plasmatrail.dts";
   smokeDist   = 4;

   soundId = SoundJetHeavy;
};

BulletData MeteorSwarm
{
//   bulletShapeName  = "cactus2.dts";
   bulletShapeName  = "shield_large.DTS";
//   bulletShapeName  = "harmor.dts";
//   bulletShapeName  = "sat_big.dts";
//   bulletShapeName  = "shield_medium.dts";
//   bulletShapeName  = "shockwave_large.dts";
   explosionTag       = mortarExp;
   collisionRadius  = 0.0;
   mass             = 20.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 180;
   damageType       = $MeteorDamageType;

   aimDeflection      = 0.035;

   explosionRadius  = 75.0;
   kickBackStrength = 1500.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 310.0;
   acceleration     = 25.0;
   totalTime        = 20.0;
   liveTime         = 21.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   isVisible          = True;
   tracerPercentage   = 1.0;
   tracerLength       = 30;

   rotationPeriod = 5;

   soundId = SoundJetHeavy;
};

//=============================================================================================
LaserData LightningBeam
{
   laserBitmapName   = "paintpulse.bmp"; //warp
//   laserBitmapName   = "repairadd.bmp";
   hitName           = "laserhit.dts";
   //explosionTag     = LargeShockwave;

   //damageConversion  = 0.151;
   damageValue       = 10.0;
   damageclass=0;
   //explosionRadius = 50;
   baseDamageType    = $LightningDamageType;

   beamTime          = 0.25;//0.53;

   lightRange        = 10.0;
   lightColor        = { 0.25, 1.0, 1.0 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;     //SoundLaserHit;
};

BulletData LightningBlast2
{
   bulletShapeName    = "tracer.dts";
	explosionTag = turretExp; 
//   explosionTag       = PlasmaCannonExp;

   damageClass        = 1;
   damageValue        = 10;
   damageType         = $LightningDamageType;
   explosionRadius    = 10.0;

   muzzleVelocity     = 600.0;
   totalTime          = 3.0;
   liveTime           = 2.0;
   lightRange         = 3.0;
   lightColor         = { 1, 1, 0 };
   inheritedVelocityScale = 0.3;
   isVisible          = True;

   soundId = SoundJetLight;
};

BulletData LightningBlast
{
   bulletShapeName    = "tracer.dts";
	explosionTag = turretExp; 
//   explosionTag       = LightningExp;

   damageClass        = 1;
   damageValue        = 0.01;
   damageType         = $EMPDamageType;
   explosionRadius    = 75.0;

   muzzleVelocity     = 600.0;
   totalTime          = 3.0;
   liveTime           = 2.0;
   lightRange         = 3.0;
   lightColor         = { 1, 1, 0 };
   inheritedVelocityScale = 0.3;
   isVisible          = True;

   soundId = SoundJetLight;
};

//=============================================================================================
BulletData TETRifleBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = shockwaveTwo;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 2.51;
   damageType         = $WhisperDamageType;

   muzzleVelocity     = 999.0;
   totalTime          = 2.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//=============================================================================================
RocketData AssaultGrenRckt
{ 
	bulletShapeName = "rocket.dts"; 
	explosionTag = Boltexp1; 
	collisionRadius = 0.0; 
	mass = 2.0; 
	damageClass = 1; 
	damageValue = 1.0; 
	damageType = $CrushDamageType; 
	explosionRadius = 20; 
	kickBackStrength = 200.0; 
	muzzleVelocity = 60.0; 
	terminalVelocity = 85.0; 
	acceleration = 5.0; 
	totalTime = 4.0; 
	liveTime = 4.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.0, 0.0 }; 
	inheritedVelocityScale = 0.5; 
	trailType = 2; 
	trailString = "plasmatrail.dts"; 
	smokeDist = 1.8; 
	soundId = SoundJetHeavy; 
};

RocketData SCAssaultGrenRckt
{ 
	bulletShapeName    = "sensor_small.dts";
//	bulletShapeName = "rocket.dts"; 
	explosionTag = boltexp3; 
	collisionRadius = 0.0; 
	mass = 2.0; 
	damageClass = 1; 
	damageValue = 6.0; 
	damageType = $CrushDamageType; 
	explosionRadius = 30; 
	kickBackStrength = 200.0; 
	muzzleVelocity = 60.0; 
	terminalVelocity = 85.0; 
	acceleration = 5.0; 
	totalTime = 4.0; 
	liveTime = 4.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.0, 0.0 }; 
	inheritedVelocityScale = 0.5; 
	trailType = 2; 
	trailString = "plasmatrail.dts"; 
	smokeDist = 1.8; 
	soundId = SoundJetHeavy; 
};

//=============================================================================================
BulletData AntiAirShot
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = SmokeExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.0125;
   damageType         = $AntiAirDamageType;
   explosionRadius    = 3; 
   kickBackStrength   = 20.0; 

   aimDeflection      = 0.0375;
   muzzleVelocity     = 768.0;
   totalTime          = 2;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

LightningData HWantiairCharge
{
	bitmapName       = "trailTest.bmp";
//	bitmapName       = "lightningNew.bmp";
//	bitmapName       = "plite02.bmp";

	damageType       = $AntiAirDamageType;
	boltLength       = 250.0;
	coneAngle        = 35.0;
	damagePerSec      = 0.1;
	energyDrainPerSec = 75.0;
	segmentDivisions = 4;
	numSegments      = 5;
	beamWidth        = 0.125;//075;

	updateTime   = 120;
	skipPercent  = 0.5;
	displaceBias = 0.15;

	lightRange = 3.0;
	lightColor = { 0.25, 0.25, 0.85 };

	soundId = SoundELFFire;
};

function HWantiairCharge::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
	%damVal = %timeSlice * %damPerSec;
	%enVal  = %timeSlice * %enDrainPerSec;

	GameBase::applyDamage(%target, $AntiAirDamageType, %damVal, %pos, %vec, %mom, %shooterId);

	%energy = GameBase::getEnergy(%target);
	%energy = %energy - %enVal;
	if (%energy < 0) 
	{
		%energy = 0;
	}
	GameBase::setEnergy(%target, %energy);
}

LightningData HWsupdoorCharge
{
//	bitmapName       = "redbrown_tex.bmp";
//	bitmapName       = "glite02.bmp";
//	bitmapName       = "lightningNew.bmp";
	bitmapName       = "ptrail0001.bmp";

	damageType       = $NullDamageType;
	boltLength       = 5.0;
	coneAngle        = 35.0;
	damagePerSec      = 25;
	energyDrainPerSec = 10.0;
	segmentDivisions = 4;
	numSegments      = 5;
	beamWidth        = 0.125;//075;

	updateTime   = 120;
	skipPercent  = 0.5;
	displaceBias = 0.15;

	lightRange = 3.0;
	lightColor = { 0.25, 0.25, 0.85 };

	soundId = SoundELFFire;
};

function HWsupdoorCharge::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
	%damVal = %timeSlice * %damPerSec;
	%enVal  = %timeSlice * %enDrainPerSec;

	GameBase::applyDamage(%target, $NullDamageType, %damVal, %pos, %vec, %mom, %shooterId);

	%energy = GameBase::getEnergy(%target);
	%energy = %energy - %enVal;
	if (%energy < 0) 
	{
		%energy = 0;
	}
	GameBase::setEnergy(%target, %energy);
}

BulletData AAairShot
{        bulletShapeName = "bullet.DTS";
        explosionTag = bulletExp0;
        expRandCycle        = 3;
        mass = 1;
        collisionRadius = 0.0;
        bulletHoleIndex = 0;
        ExplosionRadius = 0;
        damageClass = 0;
        damageValue = 0.12;
        damageType = $BulletDamageType;
//      aimDeflection = 0.005;
        muzzleVelocity = 500.0;
        totalTime = 2;

        inheritedVelocityScale = 0.5;
        liveTime = 2.0;
        isVisible = False;
        tracerPercentage = 0.0;
        tracerLength = 0;
        detachFromShooter = false;
        rotationPeriod = 0;
        lightRange = 0.0;
        lightColor = {1.0, 0.25,0.25};
};

GrenadeData PassiveSmoke
{
   bulletShapeName    = "breath.dts";
   explosionTag       = nullExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 0;
   damageValue        = 0;
   damageType         = false;

   explosionRadius    = 0;
   kickBackStrength   = 0;
   maxLevelFlightDist = 0;
   totalTime          = 0.01;    // special meaning for grenades...
   liveTime           = 0.01;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

GrenadeData SFXSmoke
{
   bulletShapeName    = "breath.dts";
   explosionTag       = smExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 1.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.3;
   damageType         = $NullDamageType;

   explosionRadius    = 0;
   kickBackStrength   = -100.0;
   maxLevelFlightDist = 0;
   totalTime          = 0.01;
   liveTime           = 0.01;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "rsmoke.dts";
};

//=============================================================================================
GrenadeData FireWall
{
	bulletShapeName = "fiery.dts";
	explosionTag = FireWallExp;
	collideWithOwner = false;
	ownerGraceMS = 500;
	collisionRadius = 0.0;
	mass = 0.0;
	elasticity = 0.1;
	damageClass = 1;
	damageValue = 0.1;
	damageType = $FlameDamageType;
	explosionRadius = 30;
	kickBackStrength = 0.0;
	maxLevelFlightDist = 1;
	totalTime = 0.05;
	liveTime = 0.05;
	projSpecialTime = 0.05;
	inheritedVelocityScale = 1.0;
	smokeName = "fiery.dts";
};

GrenadeData FireWallShell
{
	bulletShapeName    = "armorkit.dts";
	explosionTag       = mineExp;
	collideWithOwner   = True;
	ownerGraceMS       = 250;
	collisionRadius    = 0.2;
	mass               = 0.1;
	elasticity         = 0.45;
	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.6;
	damageType 		 = $FlameDamageType;
	explosionRadius    = 30;
	kickBackStrength   = 150.0;
	maxLevelFlightDist = 450;
	totalTime          = 37.0;    // special meaning for grenades...
	liveTime           = 5.0;
	projSpecialTime    = 0.05;
	inheritedVelocityScale = 0.5;
	smokeName              = "plasmatrail.dts";
};

function FireWallShell::onAdd(%this)
{
	FireWallShell::onDeployFWgrenades(%this);
}

function FireWallShell::onDeployFWgrenades(%this)
{
	if (GameBase::isAtRest(%this))
		schedule("DeployFWgrenades(" @ %this @ " , 5);",1.0,%this);
	else
		schedule("FireWallShell::onDeployFWgrenades(" @ %this @ ");",1.0,%this);
}

function DeployFWgrenades(%this, %count)
{
	%obj = newObject("","Mine","FWgrenade1");
	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,-2,true);
	%obj = newObject("","Mine","FWgrenade2");
	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,0,false);
//	%obj = newObject("","Mine","FWgrenade3");
//	addToSet("MissionCleanup", %obj);
//	GameBase::throw(%obj,%this,1,false);
//	%obj = newObject("","Mine","FWgrenade4");
//	addToSet("MissionCleanup", %obj);
//	GameBase::throw(%obj,%this,2,true);
//	%obj = newObject("","Mine","FWgrenade5");
//	addToSet("MissionCleanup", %obj);
//	GameBase::throw(%obj,%this,-1,false);
//    took out 3 of the 5 shells to reduce lag
}

GrenadeData FireWallSingleShell
{
	bulletShapeName    = "armorkit.dts";
	explosionTag       = mineExp;
	collideWithOwner   = True;
	ownerGraceMS       = 250;
	collisionRadius    = 0.2;
	mass               = 0.1;
	elasticity         = 0.45;
	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0.6;
	damageType 		 = $FlameDamageType;
	explosionRadius    = 30;
	kickBackStrength   = 150.0;
	maxLevelFlightDist = 450;
	totalTime          = 37.0;    // special meaning for grenades...
	liveTime           = 5.0;
	projSpecialTime    = 0.05;
	inheritedVelocityScale = 0.5;
	smokeName              = "plasmatrail.dts";
};

function FireWallSingleShell::onAdd(%this)
{
	FireWallSingleShell::onDeployFWgrenade(%this);
}

function FireWallSingleShell::onDeployFWgrenade(%this)
{
	if (GameBase::isAtRest(%this))
		schedule("DeployFWSinglegrenade(" @ %this @ " , 5);",1.0,%this);
	else
		schedule("FireWallSingleShell::onDeployFWgrenade(" @ %this @ ");",1.0,%this);
}

function DeployFWSinglegrenade(%this, %count)
{
	%obj = newObject("","Mine","FWgrenade1");
	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,-2,true);
}

//----------------------------------------------------------------------------

function StartFireWall(%this)
{
	$burnTime[%this] = (floor(getRandom() * 100) + 200);
//	$burnTime[%this] = 300;
	checkFireWall(%this);
}

function checkFireWall(%this)
{
	if($burnTime[%this] > 0)
	{
		$burnTime[%this] -= 1;
		%vel = Item::getVelocity(%this); 
		%trans = "0 0 1 0 0 0 0 0 1 " @ getBoxCenter(%this); 
		Projectile::spawnProjectile("FireWall",%trans,%this,%vel,%this);
		schedule("checkFireWall(" @ %this @ ");",0.1,%this);
      }
	else
	{
		Mine::Detonate(%this);
	}			
}

//=============================================================================================
//goes in baseprojdata.cs
GrenadeData SmokeBomb
{
	bulletShapeName    = "plasammo.dts";
	explosionTag       = MortarExp;
	collideWithOwner   = True;
	ownerGraceMS       = 250;
	collisionRadius    = 0.2;
	mass               = 1.0;
	elasticity         = 0.45;
	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0;
	damageType         = $SmokeDamageType;
	explosionRadius    = 15;
	kickBackStrength   = 1;
	maxLevelFlightDist = 150;
	totalTime          = 30.0;    // special meaning for grenades...
	liveTime           = 2.0;
	projSpecialTime    = 0.05;
	inheritedVelocityScale = 0.5;
	smokeName              = "mortarex.dts";
};

GrenadeData SmokeScreen
{
	bulletShapeName = "plasammo.dts";
	explosionTag = smokefade;
	collideWithOwner = false;
	ownerGraceMS = 500;
	collisionRadius = 0.0;
	mass = 0.0;
	elasticity = 0.1;
	damageClass = 1;
	damageValue = 0;
	damageType = $SmokeDamageType;
	explosionRadius = 15;
	kickBackStrength = 0.0;
	maxLevelFlightDist = 1;
	totalTime = 0.05;
	liveTime = 0.05;
	projSpecialTime = 0.05;
	inheritedVelocityScale = 1.0;
	smokeName = "mortarex.dts";
};

function SmokeBomb::onAdd(%this)
{
	SmokeBomb::onDeploySmokeScreen(%this);
}

function SmokeBomb::onDeploySmokeScreen(%this)
{
	if (GameBase::isAtRest(%this))
		schedule("DeploySmokeScreen(" @ %this @ " , 5);",1.0,%this);
	else
		schedule("SmokeBomb::onDeploySmokeScreen(" @ %this @ ");",1.0,%this);
}

function DeploySmokeScreen(%this, %count)
{
	%obj = newObject("","Mine","SmokeGrenade1");
	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,-2,true);
	%obj = newObject("","Mine","SmokeGrenade2");
	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,0,false);
}

GrenadeData SmokeGren
{
	bulletShapeName    = "plasammo.dts";
	explosionTag       = MortarExp;
	collideWithOwner   = True;
	ownerGraceMS       = 250;
	collisionRadius    = 0.2;
	mass               = 1.0;
	elasticity         = 0.45;
	damageClass        = 1;       // 0 impact, 1, radius
	damageValue        = 0;
	damageType         = $SmokeDamageType;
	explosionRadius    = 15;
	kickBackStrength   = 1;
	maxLevelFlightDist = 150;
	totalTime          = 30.0;    // special meaning for grenades...
	liveTime           = 2.0;
	projSpecialTime    = 0.05;
	inheritedVelocityScale = 0.5;
	smokeName              = "mortarex.dts";
};

function SmokeGren::onAdd(%this)
{
	SmokeGren::onDeploySmokeScreen(%this);
}

function SmokeGren::onDeploySmokeScreen(%this)
{
	if (GameBase::isAtRest(%this))
		schedule("DeploySmokeGren(" @ %this @ " , 5);",1.0,%this);
	else
		schedule("SmokeGren::onDeploySmokeScreen(" @ %this @ ");",1.0,%this);
}

function DeploySmokeGren(%this, %count)
{
	%obj = newObject("","Mine","SmokeGrenade1");
	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,-2,true);
}

function StartSmoke(%this)
{
	$SmokeTime[%this] = (floor(getRandom() * 210) + 100);
//	$SmokeTime[%this] = 300;
	checkSmoke(%this);
}

function checkSmoke(%this)
{
	if($SmokeTime[%this] > 0)
	{
		$SmokeTime[%this] -= 1;
		%vel = Item::getVelocity(%this); 
		%trans = "0 0 1 0 0 0 0 0 1 " @ getBoxCenter(%this); 
		Projectile::spawnProjectile("SmokeScreen",%trans,%this,%vel,%this);
		schedule("checkSmoke(" @ %this @ ");",0.1,%this);
      }
	else
	{
		Mine::Detonate(%this);
	}			
}


