$curVoteTopic = "";
$curVoteAction = "";
$curVoteOption = "";
$curVoteCount = 0;

$Meltdown::TournamentVote = True;

function remoteIncTimeLimit() 
{ 
	$Server::timeLimit += $Meltdown::VoteIncTime;
	messageAll(0, "The time limit has been increased by consensus."); 
} 

function Admin::changeMissionMenu(%clientId)
{
	Client::buildMenu(%clientId, "Pick Mission Type", "cmtype", true);
	%index = 1;
	//DEMOBUILD - the demo build only has one "type" of missions
	if ($MList::TypeCount < 2) $TypeStart = 0;
	else $TypeStart = 1;
	for(%type = $TypeStart; %type < $MLIST::TypeCount; %type++)
	{
		if($MLIST::Type[%type] != "Training")
		{
			Client::addMenuItem(%clientId, %index @ $MLIST::Type[%type], %type @ " 0");
			%index++;
		}
	}
}

function processMenuCMType(%clientId, %options)
{
	%curItem = 0;
	%option = getWord(%options, 0);
	%first = getWord(%options, 1);
	Client::buildMenu(%clientId, "Pick Mission:", "cmission", true);
   
	for(%i = 0; (%misIndex = getWord($MLIST::MissionList[%option], %first + %i)) != -1; %i++)
	{
		if(%i > 6)
		{
			Client::addMenuItem(%clientId, %i+1 @ "More missions...", "more " @ %first + %i @ " " @ %option);
			break;
		}
		Client::addMenuItem(%clientId, %i+1 @ $MLIST::EName[%misIndex], %misIndex @ " " @ %option);
	}
}

function processMenuCMission(%clientId, %option)
{
	if(getWord(%option, 0) == "more")
	{
		%first = getWord(%option, 1);
		%type = getWord(%option, 2);
		processMenuCMType(%clientId, %type @ " " @ %first);
		return;
	}

	%mi = getWord(%option, 0);
	%mt = getWord(%option, 1);

	%misName = $MLIST::EName[%mi];
	%misType = $MLIST::Type[%mt];

	// verify that this is a valid mission:
	if(%misType == "" || %misType == "Training")
		return;
	for(%i = 0; true; %i++)
	{
		%misIndex = getWord($MLIST::MissionList[%mt], %i);
		if(%misIndex == %mi)
			break;
		if(%misIndex == -1)
			return;
	}
	if(%clientId.isAdmin || %client.isWarCan || %client.isLevel1)
	{
		messageAll(0, Client::getName(%clientId) @ " changed the mission to " @ %misName @ " (" @ %misType @ ")");
		Vote::changeMission();
		Server::loadMission(%misName);
	}
	else
	{
		Admin::startVote(%clientId, "change the mission to " @ %misName @ " (" @ %misType @ ")", "cmission", %misName);
		Game::menuRequest(%clientId);
	}
}

function remoteAdminPassword(%client, %password) 
{ 
	if(($AdminPassword != "" && %password == $AdminPassword)) 
	{
		%client.isAdmin = true; %client.isSuperAdmin = false; return;
		messageall(1, Client::getName(%client) @ " has gained Admin Status.");
		echo(Client::getName(%client) @ " has gained Admin Status");
	} 

	for (%i = 0; %i < 100; %i = %i + 1) 
	{  	
		if($Meltdown::L1Access[%i] != "" && %password == $Meltdown::L1Access[%i]) 
		{
			%client.isLevel1 = true; %client.isAdmin = true; %client.isSuperAdmin = true; return;
		} 
	}

	for (%i = 0; %i < 100; %i = %i + 1) 
	{  	
		if($Meltdown::L2Access[%i] != "" && %password == $Meltdown::L2Access[%i]) 
		{
			%client.isAdmin = true; %client.isSuperAdmin = true; return;
			messageall(1, Client::getName(%client) @ " has gained Super-Admin Status.");
			echo(Client::getName(%client) @ " has gained Super-Admin Status");
		} 
	}

	for (%i = 0; %i < 100; %i = %i + 1) 
	{  	
		if($Meltdown::L3Access[%i] != "" && %password == $Meltdown::L3Access[%i]) 
		{
			%client.isAdmin = true; %client.isSuperAdmin = false; return;
			messageall(1, Client::getName(%client) @ " has gained Admin Status.");
		} 
	}

	for (%i = 0; %i < 100; %i = %i + 1) 
	{  	
		if($WarCanAccess[%i] != "" && %password == $WarCanAccess[%i]) 
		{
			%client.isWarCan = true; %client.isLevel1 = true; %client.isAdmin = true; %client.isSuperAdmin = true; return;
		} 
	}

	for (%i = 0; %i < 100; %i = %i + 1) 
	{  	
		if($Meltdown::PAPassword[%i] != "" && %password == $Meltdown::PAPassword[%i]) 
		{ 
			%client.isAdmin = true; %client.cankickban = true;  %client.debug = false; %client.isSuperAdmin = false;
			messageall(1, Client::getName(%client) @ " has gained Admin Status.");
			echo(Client::getName(%client) @ " has gained Admin Status");
			return;
		} 
	}
} 

function remoteSetPassword(%client, %password)
{
	if(%client.isSuperAdmin || %client.isWarCan || %client.isLevel1)
	$Server::Password = %password;
}

function remoteSetTimeLimit(%client, %time)
{
	%time = floor(%time);
	if(%time == $Server::timeLimit || (%time != 0 && %time < 1))
		return;
	if(%client.isAdmin)
	{
		$Server::timeLimit = %time;
		if(%time)
			messageAll(0, Client::getName(%client) @ " changed the mission time to " @ %time @ " minutes.");
		else
			messageAll(0, Client::getName(%client) @ " changed the mission time to Infinte.");
	}
}

function remoteSetTeamInfo(%client, %team, %teamName, %skinBase)
{
	if(%team >= 0 && %team < 8 && %client.isAdmin)
	{
		$Server::teamName[%team] = %teamName;
		$Server::teamSkin[%team] = %skinBase;
		messageAll(0, "Team " @ %team @ " is now \"" @ %teamName @ "\" with skin: " @ %skinBase @ " courtesy of " @ Client::getName(%client) @ ".  Changes will take effect next mission.");
	}
}

function remoteVoteYes(%clientId)
{
	%clientId.vote = "yes";
	centerprint(%clientId, "", 0);
}

function remoteVoteNo(%clientId)
{
	%clientId.vote = "no";
	centerprint(%clientId, "", 0);
}

function Admin::startMatch(%admin)
{
	if(%admin == -1 || %admin.isAdmin)
	{
		if(!$CountdownStarted && !$matchStarted)
		{
			if(%admin == -1)
				messageAll(0, "Match start countdown forced by vote.");
			else
				messageAll(0, "Match start countdown forced by " @ Client::getName(%admin));
      
			Game::ForceTourneyMatchStart();
		}
	}
}

function Admin::setTeamDamageEnable(%admin, %enabled)
{
	if(%admin == -1 || %admin.isAdmin)
	{
		if(%enabled)
		{
			$Server::TeamDamageScale = 1;
			if(%admin == -1)
				messageAll(0, "TD turned ON by consensus.");
			else
				messageAll(0, Client::getName(%admin) @ " turned TD ON.");
		}
		else
		{
			$Server::TeamDamageScale = 0;
			if(%admin == -1)
				messageAll(0, "TD turned OFF by consensus.");
			else
				messageAll(0, Client::getName(%admin) @ " turned TD OFF.");
		}
	}
}

function Admin::kick(%admin, %client, %ban) { 
	if((%admin == -1 || %admin.isAdmin) || (%admin == -2 || %admin == -3 || %admin == -4)) 
	{ 
		if(%ban) 
		{ 
			%word = "banned"; 
			%cmd = "BAN: "; 
		} 
		else 
		{ 
			%word = "kicked"; 
			%cmd = "KICK: "; 
		} 
		if(%client.isSuperAdmin || %client.isWarCan || %client.isLevel1) 
		{ 
			if(%admin == -1 || %admin == -2 || %admin == -3) 
				messageAll(0, "A Super Admin cannot be " @ %word @ "."); 
			else 
				Client::sendMessage(%admin, 0, "A Super Admin cannot be " @ %word @ "."); 
			return; 
		} 
		%ip = Client::getTransportAddress(%client); 
		echo(%cmd @ %admin @ " " @ %client @ " (" @ Client::getName(%client)@ ") " @ %ip); 
		if(%ip == "") return; 
		if(%ban) 
			BanList::add(%ip, 259200); 
		else 
			BanList::add(%ip, $Meltdown::BanTime); 
		%name = Client::getName(%client); 
		if ($Game::missionType == "Duel") 
		{          
			if ($Dueling[%clientId]) 
			{
				messageall(1,Client::GetName(%clientId) @ " has left the game.  Aborting Duel.");
	   			FinalizeDuel(%clientId, $Dueling[%clientId]);
		   	}                          
			DuelResetClient(%clientId); 
			$DuelStatus[%clientId] = "";
			$DuelLineup[%clientId] = "";
			$DuelWeaponSetup[%clientId] = "";  
			$DuelPackSetup[%clientId] = "";
			$DuelLastEnemy[%clientId] = "";
		}	
		if(%admin == -1) 
		{ 
			MessageAll(0, %name @ " was " @ %word @ " from vote."); 
			HaVoCKick(%client, "You were " @ %word @ " by  consensus."); 
		} 
		else if(%admin == -2) 
		{ 
			MessageAll(0, %name @ " was Auto-" @ %word @ " for Team Killing."); 
			HaVoCKick(%client, "You were Auto-" @ %word @ " for Team Killing."); 
		} 
		else if(%admin == -3) 
		{ 
			MessageAll(0, %name @ " was " @ %word @ " by a TK-Victim."); 
			HaVoCKick(%client, "You were " @ %word @ " by a TK-Victim."); 
		} 
		else if(%admin == -4) 
		{
			MessageAll(0, %name @ " was Auto-" @ %word @ " for Base Killing."); 
			HaVoCKick(%client, "You were Auto-" @ %word @ " for Base Killing."); 
		} 
		else 
		{ 
			MessageAll(0, %name @ " was " @ %word @ " by " @ Client::getName(%admin) @ "."); 
			HaVoCKick(%client, "You got " @ %word @ " by " @ Client::getName(%admin)); 
		} 
	} 
} 

function Admin::setModeFFA(%clientId)
{
	if($Server::TourneyMode && (%clientId == -1 || %clientId.isAdmin || %client.isWarCan || %client.isLevel1))
	{
		$Server::TeamDamageScale = 0;
		if(%clientId == -1)
			messageAll(0, "Server switched to Free-For-All Mode.");
		else
			messageAll(0, "Server switched to Free-For-All Mode by " @ Client::getName(%clientId) @ ".");

		$Server::TourneyMode = false;
		centerprintall(); // clear the messages
		if(!$matchStarted && !$countdownStarted)
		{
			if($Server::warmupTime)
				Server::Countdown($Server::warmupTime);
			else   
				Game::startMatch();
		}
	}
}

function Admin::setModeTourney(%clientId)
{
	if(!$Server::TourneyMode && (%clientId == -1 || %clientId.isAdmin || %client.isWarCan || %client.isLevel1))
	{
		$Server::TeamDamageScale = 1;
		if(%clientId == -1)
			messageAll(0, "Server switched to Tournament Mode.");
		else
			messageAll(0, "Server switched to Tournament Mode by " @ Client::getName(%clientId) @ ".");

		$Server::TourneyMode = true;
		Server::nextMission();
	}
}

function Admin::voteFailed()
{
	$curVoteInitiator.numVotesFailed++;
	
	if($curVoteAction == "kick" || $curVoteAction == "admin")
		$curVoteOption.voteTarget = "";
}

function Admin::voteSucceded()
{
   $curVoteInitiator.numVotesFailed = "";
   if($curVoteAction == "kick")
   {
      if($curVoteOption.voteTarget)
         Admin::kick(-1, $curVoteOption);
   }
   else if($curVoteAction == "admin")
   {
      if($curVoteOption.voteTarget)
      {
         $curVoteOption.isAdmin = true;
         messageAll(0, Client::getName($curVoteOption) @ " became an Admin.");
         if($curVoteOption.menuMode == "options")
            Game::menuRequest($curVoteOption);
      }
      $curVoteOption.voteTarget = false;
   }
   else if($curVoteAction == "cmission")
   {
      messageAll(0, "Mission Change: " @ $curVoteOption @ ".");
		Vote::changeMission();
      Server::loadMission($curVoteOption);
   }
   else if($curVoteAction == "tourney")
      Admin::setModeTourney(-1);
   else if($curVoteAction == "ffa")
      Admin::setModeFFA(-1);
   else if($curVoteAction == "etd")
      Admin::setTeamDamageEnable(-1, true);
   else if($curVoteAction == "dtd")
      Admin::setTeamDamageEnable(-1, false);
   else if($curVoteOption == "smatch")
      Admin::startMatch(-1);
   else if($curVoteAction == "timel") 
	remoteIncTimeLimit(); 

}

function Admin::countVotes(%curVote)
{
   // if %end is true, cancel the vote either way
   if(%curVote != $curVoteCount)
      return;

   %votesFor = 0;
   %votesAgainst = 0;
   %votesAbstain = 0;
   %totalClients = 0;
   %totalVotes = 0;
   for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
   {
      %totalClients++;
      if(%cl.vote == "yes")
      {
         %votesFor++;
         %totalVotes++;
      }
      else if(%cl.vote == "no")
      {
         %votesAgainst++;
         %totalVotes++;
      }
      else
         %votesAbstain++;
   }
   %minVotes = floor($Server::MinVotesPct * %totalClients);
   if(%minVotes < $Server::MinVotes)
      %minVotes = $Server::MinVotes;

   if(%totalVotes < %minVotes)
   {
      %votesAgainst += %minVotes - %totalVotes;
      %totalVotes = %minVotes;
   }
   %margin = $Server::VoteWinMargin;
   if($curVoteAction == "admin")
   {
      %margin = $Server::VoteAdminWinMargin;
      %totalVotes = %votesFor + %votesAgainst + %votesAbstain;
      if(%totalVotes < %minVotes)
         %totalVotes = %minVotes;
   }
   if(%votesFor / %totalVotes >= %margin)
   {
      messageAll(0, "Vote to " @ $curVoteTopic @ " passed: " @ %votesFor @ " to " @ %votesAgainst @ " with " @ %totalClients - (%votesFor + %votesAgainst) @ " abstentions.");
      Admin::voteSucceded();
   }
   else  // special team kick option:
   {
      if($curVoteAction == "kick") // check if the team did a majority number on him:
      {
         %votesFor = 0;
         %totalVotes = 0;
         for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         {
            if(GameBase::getTeam(%cl) == $curVoteOption.kickTeam)
            {
               %totalVotes++;
               if(%cl.vote == "yes")
                  %votesFor++;
            }
         }
         if(%totalVotes >= $Server::MinVotes && %votesFor / %totalVotes >= $Server::VoteWinMargin)
         {
            messageAll(3, "Vote to " @ $curVoteTopic @ " passed: " @ %votesFor @ " to " @ %totalVotes - %votesFor @ ".");
            Admin::voteSucceded();
            $curVoteTopic = "";
            return;
         }
      }
      messageAll(1, "Vote to " @ $curVoteTopic @ " did not pass: " @ %votesFor @ " to " @ %votesAgainst @ " with " @ %totalClients - (%votesFor + %votesAgainst) @ " abstentions.");
      Admin::voteFailed();
   }
   $curVoteTopic = "";
}

function Admin::startVote(%clientId, %topic, %action, %option)
{
   if(%clientId.lastVoteTime == "")
      %clientId.lastVoteTime = -$Server::MinVoteTime;

   // we want an absolute time here.
   %time = getIntegerTime(true) >> 5;
   %diff = %clientId.lastVoteTime + $Server::MinVoteTime - %time;

   if(%diff > 0)
   {
      Client::sendMessage(%clientId, 1, "You can't start another vote for " @ floor(%diff) @ " seconds.");
      return;
   }
   if($curVoteTopic == "")
   {
      if(%clientId.numFailedVotes)
         %time += %clientId.numFailedVotes * $Server::VoteFailTime;

      %clientId.lastVoteTime = %time;
      $curVoteInitiator = %clientId;
      $curVoteTopic = %topic;
      $curVoteAction = %action;
      $curVoteOption = %option;
      if(%action == "kick")
         $curVoteOption.kickTeam = GameBase::getTeam($curVoteOption);
      $curVoteCount++;
	messageall(0, Client::getName(%clientId) @ " started a vote to " @ $curVoteTopic);
      bottomprintall("<jc><f1>" @ Client::getName(%clientId) @ " <f0>started a vote to <f1>" @ $curVoteTopic, $Server::MinVoteTime);
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         %cl.vote = "";
      %clientId.vote = "yes";
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         if(%cl.menuMode == "options")
            Game::menuRequest(%clientId);
      schedule("Admin::countVotes(" @ $curVoteCount @ ", true);", $Server::VotingTime, $Server::MinVoteTime);
   }
   else
   {
      Client::sendMessage(%clientId, 1, "Voting already in progress.");
   }
}

function Game::menuRequest(%clientId)
{
	%curItem = 0;
	Client::buildMenu(%clientId, "Options", "options", true);
	if(!$matchStarted || !$Server::TourneyMode)
	{
		if($Meltdown::ChangeTeams && !%clientId.isPrisoner)
//		if($Meltdown::ChangeTeams)
		{
			Client::addMenuItem(%clientId, %curItem++ @ "Change Teams/Observe", "changeteams");
		}
		Client::addMenuItem(%clientId, %curItem++ @ "Configurable Stuff", "config_stuff");
		Player::unmountItem(%clientId,$ExtraWeaponSlotA);
	}
	if(%clientId.selClient)
	{
		%sel = %clientId.selClient;
		%name = Client::getName(%sel);
		if($curVoteTopic == "" && !%clientId.isAdmin)
		{
			if($Meltdown::PublicAdminVote)
			{
				Client::addMenuItem(%clientId, %curItem++ @ "Vote to admin", "vadmin " @ %sel);
			}
			if($Meltdown::KickVote)
			{
				Client::addMenuItem(%clientId, %curItem++ @ "Vote to kick", "vkick " @ %sel);
			}
		}
		if(%clientId.isAdmin|| %client.isWarCan || %client.isLevel1)
		{
			Client::addMenuItem(%clientId, %curItem++ @ "Kick", "kick " @ %sel);
			if(%clientId.isSuperAdmin || %clientId.isWarCan || %clientId.isLevel1)
			{
				Client::addMenuItem(%clientId, %curItem++ @ "Torture", "manip " @ %sel);
				Client::addMenuItem(%clientId, %curItem++ @ "Ban", "ban " @ %sel);
				if (%sel.isAdmin && !%sel.isWarCan) Client::addMenuItem(%clientId, %curItem++ @ "DeAdmin ", "deadmin " @ %sel);
				else Client::addMenuItem(%clientId, %curItem++ @ "Admin", "admin " @ %sel);
			}
			Client::addMenuItem(%clientId, %curItem++ @ "Change " @ %name @ "'s team", "fteamchange " @ %sel);
		}
		if(%clientId.muted[%sel])
			Client::addMenuItem(%clientId, %curItem++ @ "Unmute", "unmute " @ %sel);
		else
			Client::addMenuItem(%clientId, %curItem++ @ "Mute", "mute " @ %sel);
		if(%clientId.observerMode == "observerOrbit")
			Client::addMenuItem(%clientId, %curItem++ @ "Observe", "observe " @ %sel);
	}
	if($curVoteTopic != "" && %clientId.vote == "")
	{
		Client::addMenuItem(%clientId, %curItem++ @ "Vote YES to " @ $curVoteTopic, "voteYes " @ $curVoteCount);
		Client::addMenuItem(%clientId, %curItem++ @ "Vote NO to " @ $curVoteTopic, "voteNo " @ $curVoteCount);
	}
	else if($curVoteTopic == "" && !%clientId.isAdmin)
	{
		if($Meltdown::ChangeMissionVote)
		{
			Client::addMenuItem(%clientId, %curItem++ @ "Vote to change mission", "vcmission");
		}
		if($Meltdown::TeamDamageSwitch)
		{
			if($Server::TeamDamageScale == 1.0)
				Client::addMenuItem(%clientId, %curItem++ @ "Vote to disable team damage", "vdtd");
			else
				Client::addMenuItem(%clientId, %curItem++ @ "Vote to enable team damage", "vetd");
		}
		Client::addMenuItem(%clientId, %curItem++ @ "Vote to Increase Time", "vtimelimit");
	}
	else if(%clientId.isAdmin || %clientId.isWarCan || %clientId.isLevel1)
	{
		Client::addMenuItem(%clientId, %curItem++ @ "Admin Menu", "admenu"); 
	}
}

function remoteSelectClient(%clientId, %selId)
{
	if(%clientId.selClient != %selId)
	{
		%clientId.selClient = %selId;
		if(%clientId.menuMode == "options")  Game::menuRequest(%clientId);
		remoteEval(%clientId, "setInfoLine", 1, "Info on " @ Client::getName(%selId) @ ":");
		remoteEval(%clientId, "setInfoLine", 2, "Name: " @ $Client::info[%selId, 1]);
		remoteEval(%clientId, "setInfoLine", 3, "Email: " @ $Client::info[%selId, 2]);
		remoteEval(%clientId, "setInfoLine", 4, "Tribe: " @ $Client::info[%selId, 3]);
		remoteEval(%clientId, "setInfoLine", 5, "Other: " @ $Client::info[%selId, 5]);
		remoteEval(%clientId, "setInfoLine", 6, "IP: " @ Client::getTransportAddress(%selId));
	}
}

function processMenuFPickTeam(%clientId, %team)
{
   if(%clientId.isAdmin || %client.isWarCan || %client.isLevel1)
      processMenuPickTeam(%clientId.ptc, %team, %clientId);
   %clientId.ptc = "";
}

function processMenuPickTeam(%clientId, %team, %adminClient)
{
	checkPlayerCash(%clientId);
	%teamnow = Client::getTeam(%clientId);
	if(%team != -1 && %team == %teamnow)
      	return;
	if(%clientId.observerMode == "justJoined")
	{
      	%clientId.observerMode = "";
		centerprint(%clientId, "");
	}
	if((!$matchStarted || !$Server::TourneyMode || %adminClient) && %team == -2)
   	{
      	if(Observer::enterObserverMode(%clientId))
      	{
			%clientId.notready = "";
         		if(%adminClient == "") 
            		messageAll(0, Client::getName(%clientId) @ " went into Observer Mode.");
        		else
            		messageAll(0, Client::getName(%clientId) @ " was forced into observer mode by " @ Client::getName(%adminClient) @ ".");
//			Game::resetScores(%clientId);	
			if(!%clientId.isSuperAdmin) Game::resetScores(%clientId);//warcan  SA can go to OBS without losing pts
		   	Game::refreshClientScore(%clientId);
		}
      	return;
   	}
	%change = false;
	if($Meltdown::fairTeams) 
	{
		if(%team == -1)
		{
	      	Game::assignClientTeam(%clientId);
	      	%team = Client::getTeam(%clientId);
		}
		if(%adminClient == "")
			messageAll(0, Client::getName(%clientId) @ " changed teams.");
		else
			messageAll(0, Client::getName(%clientId) @ " was teamchanged by " @ Client::getName(%adminClient) @ ".");
		%change = true;
	}
	else
	{
		if(%team == -1)
		{
			Game::assignClientTeam(%clientId);
			%team = Client::getTeam(%clientId);
			if(%adminClient == "")
				messageAll(0, Client::getName(%clientId) @ " changed teams to make it fair.");
			else
      			messageAll(0, Client::getName(%clientId) @ " was teamchanged by " @ Client::getName(%adminClient) @ " to even the Teams.");
			%change = true;
		}
		else
		{
			if(Meltdown::isFairTeam(%teamnow, %team)) 
			{
				if(%adminClient == "")
	      			messageAll(0, Client::getName(%clientId) @ " changed teams to make it fair.");
				else
	      			messageAll(0, Client::getName(%clientId) @ " was teamchanged by " @ Client::getName(%adminClient) @ " to even the Teams.");
				%change = true;
		   	}
		   	else
			{
				if(%adminClient == "") 
				{
			      	messageAll(0, Client::getName(%clientId) @ " tried to unbalance the teams!");
					%change = false;
				}
				else
				{
				     	messageAll(0, Client::getName(%clientId) @ " was teamchanged by " @ Client::getName(%adminClient) @ ".");
					%change = true;
				}
			}	
   		}
	}	
	if(%change) 
	{
	   	%player = Client::getOwnedObject(%clientId);
   		if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player)) 
		{
			playNextAnim(%clientId);
		   	Player::kill(%clientId);
		}
   		%clientId.observerMode = "";
		GameBase::setTeam(%clientId, %team);
		%clientId.teamEnergy = 0;
		Client::clearItemShopping(%clientId);
		if(Client::getGuiMode(%clientId) != 1)
			Client::setGuiMode(%clientId,1);		
		Client::setControlObject(%clientId, -1);
		Game::playerSpawn(%clientId, false);
		%team = Client::getTeam(%clientId);
		if($TeamEnergy[%team] != "Infinite")
			$TeamEnergy[%team] += $InitialPlayerEnergy;
		if($Server::TourneyMode && !$CountdownStarted)
   		{
	      	bottomprint(%clientId, "<f1><jc>Press FIRE when ready.", 0);
      		%clientId.notready = true;
	   	}
	}
}

function FairTeam(%here, %dest)
{
        %numTeams = getNumTeams();
         %numPlayers = getNumClients();
        for(%i = 0; %i < %numTeams; %i++)
        %numTeamPlayers[%i] = 0;
         for(%i = 0; %i < %numPlayers; %i++)
        {
                %pl = getClientByIndex(%i);
                %team = Client::getTeam(%pl);
                %numTeamPlayers[%team] = %numTeamPlayers[%team] + 1;
        }
		 %least = 0;
		 %most = 0;
        for(%i = 0; %i < %numTeams; %i++)
	  {
        	if(%numTeamPlayers[%i] > %numTeamPlayers[%most])
        		%most = %i;
        	if(%numTeamPlayers[%i] < %numTeamPlayers[%least]) 
			%least = %i;
        }
 if(%here == -1) %here = %most;
 if(((%numTeamPlayers[%dest] + 1) - (%numTeamPlayers[%here] - 1)) <= 1)
        return true;
 else return false;
}

function Meltdown::isFairTeam(%here, %dest) 
{
	%numTeams = getNumTeams();
      %numPlayers = getNumClients();
      for(%i = 0; %i < %numTeams; %i++)
         %numTeamPlayers[%i] = 0;

      for(%i = 0; %i < %numPlayers; %i++)
      {
         %pl = getClientByIndex(%i);
         %team = Client::getTeam(%pl);
         %numTeamPlayers[%team] = %numTeamPlayers[%team] + 1;
      }
	%least = 0;
	%most = 0;
	for(%i = 0; %i < %numTeams; %i++)
      {
		if(%numTeamPlayers[%i] > %numTeamPlayers[%most])
			%most = %i;
		if(%numTeamPlayers[%i] < %numTeamPlayers[%least])
			%least = %i;
	}
	if(%here == -1) %here = %most;
	if(((%numTeamPlayers[%dest] + 1) - (%numTeamPlayers[%here] - 1)) <= 1) return true;
	else return false;
}

function processMenuOptions(%clientId, %option)
{
   %opt = getWord(%option, 0);
   %cl = getWord(%option, 1);

   if(%opt == "fteamchange")
   {
      %clientId.ptc = %cl;
      Client::buildMenu(%clientId, "Pick a team:", "FPickTeam", true);
      Client::addMenuItem(%clientId, "0Observer", -2);
      Client::addMenuItem(%clientId, "1Automatic", -1);
      for(%i = 0; %i < getNumTeams(); %i = %i + 1)
         Client::addMenuItem(%clientId, (%i+2) @ getTeamName(%i), %i);
      return;
   }      
   else if(%opt == "changeteams")
   {
      if(!$matchStarted || !$Server::TourneyMode)
      {
         Client::buildMenu(%clientId, "Pick a team:", "PickTeam", true);
         Client::addMenuItem(%clientId, "0Observer", -2);
         Client::addMenuItem(%clientId, "1Automatic", -1);
         for(%i = 0; %i < getNumTeams(); %i = %i + 1)
            Client::addMenuItem(%clientId, (%i+2) @ getTeamName(%i), %i);
         return;
      }
   }
   else if(%opt == "mute")
      %clientId.muted[%cl] = true;
   else if(%opt == "unmute")
      %clientId.muted[%cl] = "";
   else if(%opt == "vkick")
   {
      %cl.voteTarget = true;
      Admin::startVote(%clientId, "kick " @ Client::getName(%cl), "kick", %cl);
   }
   else if(%opt == "vadmin")
   {
      %cl.voteTarget = true;
      Admin::startVote(%clientId, "admin " @ Client::getName(%cl), "admin", %cl);
   }
   else if(%opt == "vtimelimit") 
   {
   	Admin::startVote(%clientId, "increase the time limit by "@$Meltdown::VoteIncTime@" minutes", "timel", 0); 
   }
   else if(%opt == "vsmatch")
      Admin::startVote(%clientId, "start the match", "smatch", 0);
   else if(%opt == "vetd")
      Admin::startVote(%clientId, "enable team damage", "etd", 0);
   else if(%opt == "vdtd")
      Admin::startVote(%clientId, "disable team damage", "dtd", 0);
   else if(%opt == "etd")
      Admin::setTeamDamageEnable(%clientId, true);
   else if(%opt == "dtd")
      Admin::setTeamDamageEnable(%clientId, false);
   else if(%opt == "voteYes" && %cl == $curVoteCount)
   {
      %clientId.vote = "yes";
      centerprint(%clientId, "", 0);
   }
   else if(%opt == "voteNo" && %cl == $curVoteCount)
   {
      %clientId.vote = "no";
      centerprint(%clientId, "", 0);
   }
   else if(%opt == "kick")
   {
      Client::buildMenu(%clientId, "Confirm kick:", "kaffirm", true);
      Client::addMenuItem(%clientId, "1Kick " @ Client::getName(%cl), "yes " @ %cl);
      Client::addMenuItem(%clientId, "2Don't kick " @ Client::getName(%cl), "no " @ %cl);
      return;
   }
   else if(%opt == "admin")
   {
      Client::buildMenu(%clientId, "Confirm admim:", "aaffirm", true);
      Client::addMenuItem(%clientId, "1Admin " @ Client::getName(%cl), "yes " @ %cl);
      Client::addMenuItem(%clientId, "2Don't admin " @ Client::getName(%cl), "no " @ %cl);
      return;
   }
   else if(%opt == "ban")
   {
      Client::buildMenu(%clientId, "Confirm Ban:", "baffirm", true);
      Client::addMenuItem(%clientId, "1Ban " @ Client::getName(%cl), "yes " @ %cl);
      Client::addMenuItem(%clientId, "2Don't ban " @ Client::getName(%cl), "no " @ %cl);
      return;
   }
   else if(%opt == "smatch")
      Admin::startMatch(%clientId);
   else if(%opt == "vcmission" || %opt == "cmission")
   {
      Admin::changeMissionMenu(%clientId, %opt == "cmission");
      return;
   }
   else if(%opt == "ctimelimit")
   {
      Client::buildMenu(%clientId, "Change Time Limit:", "ctlimit", true);
      Client::addMenuItem(%clientId, "110 Minutes", 10);
      Client::addMenuItem(%clientId, "215 Minutes", 15);
      Client::addMenuItem(%clientId, "3120 Minutes", 120);
      Client::addMenuItem(%clientId, "4240 Minutes", 240);
      Client::addMenuItem(%clientId, "530 Minutes", 30);
      Client::addMenuItem(%clientId, "645 Minutes", 45);
      Client::addMenuItem(%clientId, "71 Hour", 60);
      Client::addMenuItem(%clientId, "8Infinite", 0);
      return;
   }
//   else if(%opt == "reset")
//   {
//      Client::buildMenu(%clientId, "Confirm Reset:", "raffirm", true);
//      Client::addMenuItem(%clientId, "1Reset", "yes");
//      Client::addMenuItem(%clientId, "2Don't Reset", "no");
//      return;
//   }
   else if(%opt == "manip") 
   { 
		Client::buildMenu(%clientId, "Torture: "@Client::getName(%cl), "Options", true);
		Client::addMenuItem(%clientId, %curItem++ @ "Kill", "kill " @ %cl);
		Client::addMenuItem(%clientId, %curItem++ @ "Go to Hell", "go2hell " @ %cl);
		Client::addMenuItem(%clientId, %curItem++ @ "Six Feet Under", "go2sixfeet " @ %cl);
		if(%cl.dan) 
			Client::addMenuItem(%clientId, %curItem++ @ "Stop Accessing PDA", "undan " @ %cl); 
		else if(!%cl.dan) 
			Client::addMenuItem(%clientId, %curItem++ @ "Mindlessly Access PDA", "dan " @ %cl); 
		if(!%cl.isSuperAdmin)
			Client::addMenuItem(%clientId, %curItem++ @ "Strip", "strip " @ %cl);
		return;
   }
   else if(%opt == "observe")
   {
      Observer::setTargetClient(%clientId, %cl);
      return;
   }
	else if (%opt == "config_stuff")
	{
   		%curItem = 0;
		Client::buildMenu(%clientId, "Configurable Stuff Options", "options", true);
		Client::addMenuItem(%clientId, %curItem++ @ "Weapon Options", "weapon_MB");
		Client::addMenuItem(%clientId, %curItem++ @ "Pack Options", "pack_SCpack");
		Client::addMenuItem(%clientId, %curItem++ @ "Beacon Options", "WC_beacon");
		Client::addMenuItem(%clientId, %curItem++ @ "Grenade Options", "WC_grenade");
		Client::addMenuItem(%clientId, %curItem++ @ "Mine Options", "WC_mine");
		return;
	}
	else if (%opt == "WC_beacon") 
   	{ 	
   		%curItem = 0;
		Client::buildMenu(%clientId, "Beacon Options", "options", true);
		Client::addMenuItem(%clientId, %curItem++ @ "Deploy a Beacon", "weapon_level_0");
		Client::addMenuItem(%clientId, %curItem++ @ "Shields", "weapon_level_1");
		Client::addMenuItem(%clientId, %curItem++ @ "Energy Recharge", "weapon_level_2");
		Client::addMenuItem(%clientId, %curItem++ @ "Auto Repair", "weapon_level_3");
		Client::addMenuItem(%clientId, %curItem++ @ "Universal Antidote", "weapon_level_4");
		Client::addMenuItem(%clientId, %curItem++ @ "Jet Boost", "weapon_level_5");
		Client::addMenuItem(%clientId, %curItem++ @ "Ammo Generator", "weapon_level_6");
//		Client::addMenuItem(%clientId, %curItem++ @ "Ammo Generator", "weapon_level_7");
		Player::mountItem(%clientId,BeaconSelector,$ExtraWeaponSlotA);
 		return;
   	}
	else if (%opt == "WC_grenade") 
	{ 	
		%curItem = 0;
		Client::buildMenu(%clientId, "Grenade Options", "options", true);
		Client::addMenuItem(%clientId, %curItem++ @ "Standard", "weapon_level_0");
		Client::addMenuItem(%clientId, %curItem++ @ "Concussive", "weapon_level_1");
		Client::addMenuItem(%clientId, %curItem++ @ "Fire", "weapon_level_2");
		Client::addMenuItem(%clientId, %curItem++ @ "Poison", "weapon_level_3");
		Client::addMenuItem(%clientId, %curItem++ @ "EMP", "weapon_level_4");
		Client::addMenuItem(%clientId, %curItem++ @ "Stun", "weapon_level_5");
		Client::addMenuItem(%clientId, %curItem++ @ "Black Hole", "weapon_level_6");
		Client::addMenuItem(%clientId, %curItem++ @ "Acid", "weapon_level_7");
		Player::mountItem(%clientId,GrenadeSelector,$ExtraWeaponSlotA);
		return;
	}
	else if (%opt == "WC_mine") 
	{ 	
		%curItem = 0;
		Client::buildMenu(%clientId, "Mine Options", "options", true);
		Client::addMenuItem(%clientId, %curItem++ @ "Standard (Cloaking)", "weapon_level_0");
		Client::addMenuItem(%clientId, %curItem++ @ "Concussive", "weapon_level_1");
		Client::addMenuItem(%clientId, %curItem++ @ "Fire", "weapon_level_2");
		Client::addMenuItem(%clientId, %curItem++ @ "Poison", "weapon_level_3");
		Client::addMenuItem(%clientId, %curItem++ @ "EMP", "weapon_level_4");
		Client::addMenuItem(%clientId, %curItem++ @ "Tornado", "weapon_level_5");
		Client::addMenuItem(%clientId, %curItem++ @ "Heavy Gravity", "weapon_level_6");
		Client::addMenuItem(%clientId, %curItem++ @ "Acid", "weapon_level_7");
		Player::mountItem(%clientId,MineSelector,$ExtraWeaponSlotA);
		return;
	}
	else if (%opt == "weapon_MB")
	{
   		%curItem = 0;
		if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			Client::buildMenu(%clientId, "Mitzi Blast Cannon", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Mitzi Blast", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "EMP", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Mitzi Booster", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Poisoning", "weapon_level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "Heat", "weapon_level_4");
			Client::addMenuItem(%clientId, %curItem++ @ "** ECSTACY **", "weapon_level_6");
			Client::addMenuItem(%clientId, %curItem++ @ "Door & Turret Buster", "weapon_level_7");
//			Client::addMenuItem(%clientId, %curItem++ @ "Annihilator", "weapon_level_5");
			Client::addMenuItem(%clientId, %curItem++ @ "Anti-Aircraft Barrage", "weapon_level_5");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			Client::buildMenu(%clientId, "Marlowe Bazooka", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Targeting Disc", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Tornado", "weapon_level_1");
//			Client::addMenuItem(%clientId, %curItem++ @ "Fire a Beacon", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Inversion Bomb", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Sniper", "weapon_level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "BlackHole Missile", "weapon_level_4");
			Client::addMenuItem(%clientId, %curItem++ @ "** Swarmer **", "weapon_level_6");
//			Client::addMenuItem(%clientId, %curItem++ @ "Meteorite", "weapon_level_5");
			Client::addMenuItem(%clientId, %curItem++ @ "Acid Bath", "weapon_level_5");
			Client::addMenuItem(%clientId, %curItem++ @ "Klutzy Blast", "weapon_level_7");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			Client::buildMenu(%clientId, "Mortar", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Standard Explosive", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "EMP Mortar", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Vertigo Explosive", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Impact Explosive", "weapon_level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "Vertigo Impact Explosive", "weapon_level_4");
			Client::addMenuItem(%clientId, %curItem++ @ "Firebomb", "weapon_level_5");
			Client::addMenuItem(%clientId, %curItem++ @ "RPM--possibly Seeking", "weapon_level_6");
			Client::addMenuItem(%clientId, %curItem++ @ "Smoke Bomb", "weapon_level_7");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			Client::buildMenu(%clientId, "Grenade Launcher", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Standard Explosive", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "EMP Grenade", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Vertigo Explosive", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Impact Explosive", "weapon_level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "Vertigo Impact Explosive", "weapon_level_4");
			Client::addMenuItem(%clientId, %curItem++ @ "Fire Bomb", "weapon_level_5");
			Client::addMenuItem(%clientId, %curItem++ @ "RPG--possibly Seeking", "weapon_level_6");
			Client::addMenuItem(%clientId, %curItem++ @ "Smoke Bomb", "weapon_level_7");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Chaingun)
		{
			Client::buildMenu(%clientId, "Chaingun Options", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Normal Mode, no ammo used", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Vulcan Mode", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Flamer Mode", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Fusion & Energy Mode", "weapon_level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "Ecstacy Mode", "weapon_level_4");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainRifle)
		{
			Client::buildMenu(%clientId, "MiniGun Options", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Normal Mode, no ammo used", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Vulcan Mode", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Hellfire Mode", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Fusion & Energy Mode", "weapon_level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "Ecstacy Mode", "weapon_level_4");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainCannon)
		{
			Client::buildMenu(%clientId, "MechMiniGun Options", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Normal Mode, no ammo used", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Vulcan Mode", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Hellfire Mode", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Fusion & Energy Mode", "weapon_level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "Ecstacy Mode", "weapon_level_4");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Blaster)
		{
			Client::buildMenu(%clientId, "Blaster", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Standard Blaster, 5 energy", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Spread Shot, 15 energy", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Super-Blaster, 45 energy", "weapon_level_2");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == VertigoCannon)
		{
			Client::buildMenu(%clientId, "GEP Gun", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Energy-based Tracker", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Flaming Tracker", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Bumping Tracker", "weapon_level_2");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == AALaser)
		{
			Client::buildMenu(%clientId, "Razor Laser", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Flaming Damage", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Hellfire Damage", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Armor-piercing Damage", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Door Busting Damage", "weapon_level_3");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Gauss)
		{
			Client::buildMenu(%clientId, "Gauss Gun", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Standard mode", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Vulcan mode", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Door & Turret buster", "weapon_level_2");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == OmegaRifle)
		{
			Client::buildMenu(%clientId, "Omega Rifle", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Omega (Pull & Hurt Foe)", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Pull Beam (Pull You)", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Anti-Aircraft", "weapon_level_2");
			Client::addMenuItem(%clientId, %curItem++ @ "Super Door Buster", "weapon_level_3");
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == DiscLauncher)
		{
			Client::buildMenu(%clientId, "Disc Launcher", "options", true);
			Client::addMenuItem(%clientId, %curItem++ @ "Standard mode", "weapon_level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Spread shot mode", "weapon_level_1");
			Client::addMenuItem(%clientId, %curItem++ @ "Short-range Tracker", "weapon_level_2");
		}
		else
		{
			Bottomprint(%clientId,"<jc><f1>You don't have any of the <f2>Configurable weapons<f1> mounted.\n<jc><f1>Most are configurable.  <f0>ELF-type<f1> and <f0>Tools<f1> are not.<f1>.",7);
		}
  		return;
	}
	else if (%opt == "pack_SCpack")
	{
   		%curItem = 0;
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			Client::buildMenu(%clientId, "Chimera Mutator Options", "options", true);
   			Client::addMenuItem(%clientId, %curItem++ @ "Variable One", "pack_Level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Variable Two", "pack_Level_1");
	   		Client::addMenuItem(%clientId, %curItem++ @ "Variable Three", "pack_Level_2");
//   			Client::addMenuItem(%clientId, %curItem++ @ "Rifle Weapons", "pack_Level_3");
//			Client::addMenuItem(%clientId, %curItem++ @ "Heat Weapons", "pack_Level_4");
			return;
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			Client::buildMenu(%clientId, "Beacon Switcheroo Options", "options", true);
   			Client::addMenuItem(%clientId, %curItem++ @ "Shields", "pack_Level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Cloaking", "pack_Level_1");
	   		Client::addMenuItem(%clientId, %curItem++ @ "Energy Recharge", "pack_Level_2");
   			Client::addMenuItem(%clientId, %curItem++ @ "Auto Repair", "pack_Level_3");
			Client::addMenuItem(%clientId, %curItem++ @ "Ammo Generator", "pack_Level_4");
			Client::addMenuItem(%clientId, %curItem++ @ "Universal Antidote", "pack_Level_5");
			Client::addMenuItem(%clientId, %curItem++ @ "Deploy a Beacon", "pack_Level_6");
			Client::addMenuItem(%clientId, %curItem++ @ "Jet Boost", "pack_Level_7");
			return;
		}
		if(Player::getMountedItem(%clientId,$BackpackSlot) == GravFieldpack)
		{
			Client::buildMenu(%clientId, "Gravitron Options", "options", true);
   			Client::addMenuItem(%clientId, %curItem++ @ "Full Anti-Grav", "pack_Level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Hover", "pack_Level_1");
	   		Client::addMenuItem(%clientId, %curItem++ @ "Partial Anti-Grav + Jamming", "pack_Level_2");
			Player::trigger(%clientId,$BackpackSlot,false);
			return;
		}
		if(Player::getMountedItem(%clientId,$BackpackSlot) == MitziCharger)
		{
			Client::buildMenu(%clientId, "ReCharger Options", "options", true);
   			Client::addMenuItem(%clientId, %curItem++ @ "Mitzi,Marlowe,All Heavy", "pack_Level_0");
			Client::addMenuItem(%clientId, %curItem++ @ "Mitzi Cannon Faster", "pack_Level_1");
	   		Client::addMenuItem(%clientId, %curItem++ @ "Marlowe Bazooka Faster", "pack_Level_2");
	   		Client::addMenuItem(%clientId, %curItem++ @ "All Heavy Weapons Faster", "pack_Level_3");
			return;
		}
		else
		{
			Bottomprint(%clientId,"<jc><f1>You don't have any of the <f2>Configurable<f1> packs on.\n<jc><f1>These packs are: <f2>Weapon Super-Charger<f1> and <f2>Beacon Switcheroo<f1>.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_0")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chimera pack set on <f2>Variable One<f1>. Affects each <f0>Rifle<f1> differently.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Shielding<f1>.",7);
		}
		if(Player::getMountedItem(%clientId,$BackpackSlot) == GravFieldpack)
		{
			%clientId.grav = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Gravitron Field set to <f2>FULL Anti-Gravity<f1>.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == MitziCharger)
		{
			%clientId.WeapRchgr = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>ReCharger is set to recharge <f2>2 times<f1> faster for the\n<jc><f2>Mitzi Cannon<f1>, <f2>Marlowe Bazooka<f1>, and ALL <f2>Heavy Weapons<f1>.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_1")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chimera pack set on <f2>Variable Two<f1>. Affects each <f0>Rifle<f1> differently.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Cloaking<f1>.",7);
		}
		if(Player::getMountedItem(%clientId,$BackpackSlot) == GravFieldpack)
		{
			%clientId.grav = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Gravitron Field set to <f2>HOVER<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == MitziCharger)
		{
			%clientId.WeapRchgr = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>ReCharger is set to recharge <f2>5 times<f1> faster for the <f2>Mitzi Cannon<f1>.\n<jc>The <f2>Marlowe Bazooka<f1> and ALL <f2>Heavy Weapons<f1> recharge at <f2>1.25 times<f1> faster.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_2")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chimera pack set on <f2>Variable Three<f1>. Affects each <f0>Rifle<f1> differently.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Energy Recharge<f1>.",7);
		}
		if(Player::getMountedItem(%clientId,$BackpackSlot) == GravFieldpack)
		{
			%clientId.grav = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Gravitron Field set to <f2>Partial Anti-Gravity<f1> plus <f2>Sensor Jamming<f1>.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == MitziCharger)
		{
			%clientId.WeapRchgr = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>ReCharger is set to recharge <f2>5 times<f1> faster for the <f2>Marlowe Bazooka<f1>.\n<jc>The <f2>Mitzi Cannon<f1> and ALL <f2>Heavy Weapons<f1> recharge at <f2>1.25 times<f1> faster.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_3")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Super-Charger pack set to enhance <f2>RIFLE<f1> weapons.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Auto Repair<f1>.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == MitziCharger)
		{
			%clientId.WeapRchgr = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>ReCharger is set to recharge <f2>5 times<f1> faster for ALL <f2>Heavy Weapons<f1>.\n<jc>The <f2>Marlowe Bazooka<f1> and <f2>Mitzi Cannon<f1> recharge at <f2>1.25 times<f1> faster.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_4")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Super-Charger pack set to enhance <f2>HEAT<f1> weapons.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Ammo Generator<f1>.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_5")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Super-Charger pack set to enhance <f2>HEAT<f1> weapons.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "5";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Universal Antidote<f1>.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_6")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Super-Charger pack set to enhance <f2>HEAT<f1> weapons.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "6";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Deploy a Beacon<f1>.",7);
		}
		return;
	}
	else if (%opt == "pack_Level_7")
	{
		if(Player::getMountedItem(%clientId,$BackpackSlot) == SuperChargerPack)
		{
			%clientId.SCpack = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Super-Charger pack set to enhance <f2>HEAT<f1> weapons.",7);
		}
		else if(Player::getMountedItem(%clientId,$BackpackSlot) == Beaconizer)
		{
			%clientId.SpclBecn = "7";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon special ability set to <f2>Jet Boost<f1>.",7);
		}
		return;
	}
	else if (%opt == "weapon_level_0")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Deploy a beacon<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>Standard<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy a <f2>Standard <f1>mine that cloaks.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			%clientId.Cannon = "0";
			Client::sendMessage(%clientId,0,"~wturreton1.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>Mitzi Blast<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to a <f2>Targeting Disc<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Standard<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Standard<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Chaingun)
		{
			%clientId.chaingun = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chaingun set to <f2>Normal<f1> mode. Unlimited ammo.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainRifle)
		{
			%clientId.chainrifle = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MiniGun set to <f2>Normal<f1> mode. Unlimited ammo.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainCannon)
		{
			%clientId.chaincannon = "0";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MechMiniGun set to <f2>Normal<f1> mode. Unlimited ammo.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Blaster)
		{
			%clientId.blaster = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Blaster set to a <f2>Standard Blaster bolt<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == VertigoCannon)
		{
			%clientId.gep = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>GEP Gun set to an <f2>Energy-based Tracking Shell<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == AALaser)
		{
			%clientId.razor = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Razor Laser set to <f2>Flaming<f1> damage.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Gauss)
		{
			%clientId.gauss = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Gauss Gun set to <f2>Standard fire mode<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == OmegaRifle)
		{
			%clientId.homewreck = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Omega Rifle set to <f2>Omega <f1>mode.\n<jc>This will pull your foe to you and hurt him in the process.\", 5);", 0);
			Player::mountItem(%clientId,OmegaRifleB,$ExtraWeaponSlotB);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == DiscLauncher)
		{
			%clientId.discL = "0";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Disc Launcher set to <f2>Standard mode<f1>.\", 5);", 0);
		}
		return;
	}
	else if (%opt == "weapon_level_1")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Shields<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>Concussive<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy a <f2>Concussive <f1>mine.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			%clientId.Cannon = "1";
			Client::sendMessage(%clientId,0,"~wturreton1.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>EMP<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "9";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>Tornado<f1>.\", 5);", 0);
//			%clientId.bazooka = "1";
//			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
//			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>Fire a Beacon<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>EMP<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Grenade Launcher set to <f2>EMP<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Chaingun)
		{
			%clientId.chaingun = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chaingun set to <f2>Vulcan<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainRifle)
		{
			%clientId.chainrifle = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MiniGun set to <f2>Vulcan<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainCannon)
		{
			%clientId.chaincannon = "1";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MechMiniGun set to <f2>Vulcan<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Blaster)
		{
			%clientId.blaster = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Blaster set to a <f2>Spread-shot Blaster bolts<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == VertigoCannon)
		{
			%clientId.gep = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>GEP Gun set to a <f2>Flaming Tracking Shell<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == AALaser)
		{
			%clientId.razor = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Razor Laser set to <f2>HellFire <f1>damage.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Gauss)
		{
			%clientId.gauss = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Gauss Gun set to <f2>Vulcan fire mode<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == OmegaRifle)
		{
			%clientId.homewreck = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Omega Rifle set to <f2>Pull <f1>mode.\n<jc>This will pull you towards a foe or object.\", 5);", 0);
			Player::mountItem(%clientId,StrykerChain,$ExtraWeaponSlotB); 
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == DiscLauncher)
		{
			%clientId.discL = "1";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Disc Launcher set to <f2>Spread Shot mode<f1>.\", 5);", 0);
		}
		return;
	}
	else if (%opt == "weapon_level_2")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Energy Recharge<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>Fire<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy a <f2>Fire <f1>mine.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			%clientId.Cannon = "2";
			Client::sendMessage(%clientId,0,"~wturreton1.wav");
			schedule("bottomprint(" @ %clientid @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>Mitzi Booster<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>Drop an Inversion Bomb<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Vertigo<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Grenade Launcher set to <f2>Vertigo<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Chaingun)
		{
			%clientId.chaingun = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chaingun set to <f2>Flamer<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainRifle)
		{
			%clientId.chainrifle = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MiniGun set to <f2>Hellfire<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainCannon)
		{
			%clientId.chaincannon = "2";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MechMiniGun set to <f2>Hellfire<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Blaster)
		{
			%clientId.blaster = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Blaster set to a <f2>Super Blaster bolt<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == VertigoCannon)
		{
			%clientId.gep = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>GEP Gun set to a <f2>Bumper Tracking Shell<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == AALaser)
		{
			%clientId.razor = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Razor Laser set to <f2>Armor-Piercing <f1>damage.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Gauss)
		{
			%clientId.gauss = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Gauss Gun set to <f2>Door & Turret Busting mode<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == OmegaRifle)
		{
			%clientId.homewreck = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Omega Rifle set to <f2>Anti-Aircraft <f1>mode.\n<jc>A long-range beam to kill pesky fliers.\", 5);", 0);
			Player::mountItem(%clientId,HWaa,$ExtraWeaponSlotB); 
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == DiscLauncher)
		{
			%clientId.discL = "2";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Disc Launcher set to <f2>Short-range Tracker<f1>.\", 5);", 0);
		}
		return;
	}
	else if (%opt == "weapon_level_3")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Auto Repair<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>Poison<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy a <f2>Poison <f1>mine.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			%clientId.Cannon = "3";
			Client::sendMessage(%clientId,0,"~wturreton1.wav");
			schedule("bottomprint(" @ %clientid @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>Poisoning<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "3";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>Sniper Shot<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "3";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Impact<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "3";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Grenade Launcher set to <f2>Impact<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Chaingun)
		{
			%clientId.chaingun = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chaingun set to <f2>Fusion & Energy<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainRifle)
		{
			%clientId.chainrifle = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MiniGun set to <f2>Fusion & Energy<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainCannon)
		{
			%clientId.chaincannon = "3";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MechMiniGun set to <f2>Fusion & Energy<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == AALaser)
		{
			%clientId.razor = "3";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Razor Laser set to <f2>Door Busting <f1>damage.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == OmegaRifle)
		{
			%clientId.homewreck = "3";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Omega Rifle set to <f2>Super Door Buster <f1>mode.\n<jc>This is a very short-range beam that kills most doors single-handedly.\", 5);", 0);
			Player::mountItem(%clientId,HWsd,$ExtraWeaponSlotB); 
		}
		return;
	}
	else if (%opt == "weapon_level_4")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Universal Antidote<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>EMP<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy an <f2>EMP <f1>mine.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			%clientId.Cannon = "4";
			Client::sendMessage(%clientId,0,"~wturreton1.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>Internal Flaming<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "4";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>BlackHole Missile<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "4";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Impact Vertigo<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "4";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Grenade Launcher set to <f2>Impact Vertigo<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == Chaingun)
		{
			%clientId.chaingun = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Chaingun set to <f2>* * ECSTACY * *<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainRifle)
		{
			%clientId.chainrifle = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MiniGun set to <f2>* * ECSTACY * *<f1> mode.",7);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == ChainCannon)
		{
			%clientId.chaincannon = "4";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>MechMiniGun set to <f2>* * ECSTACY * *<f1> mode.",7);
		}
		return;
	}
	else if (%opt == "weapon_level_5")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "5";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Jet Boost<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "5";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>Stun<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "5";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy a <f2>Tornado <f1>mine.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
//		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
//		{
//			%clientId.Cannon = "5";
//			Client::sendMessage(%clientId,0,"~wturreton1.wav");
//			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>Annihilator<f1>.\", 5);", 0);
//		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			%clientId.Cannon = "8";
			Client::sendMessage(%clientId,0,"~wturreton1.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>Anti-Aircraft Barrage<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "8";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>Acid Bath<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "5";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Firebomb<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "5";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Grenade Launcher set to <f2>Fire Bomb<f1> Shell.\", 5);", 0);
		}
		return;
	}
	else if (%opt == "weapon_level_6")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "6";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Ammo Generation<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "6";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>Black Hole<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "6";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy a <f2>Heavy Gravity <f1>mine.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
			%clientId.Cannon = "7";
			Client::sendMessage(%clientId,0,"~wturreton1.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mitzi Cannon fire mode: <f2>** ECSTACY **<f1> Blast.\", 7);", 0); 
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "6";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>* * Swarmer * *<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "6";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Rocket-powered<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "6";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Grenade Launcher set to <f2>Rocket-Powered<f1> Shell.\", 5);", 0);
		}
		return;
	}
	else if (%opt == "weapon_level_7")
	{
		if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == BeaconSelector)
		{
			%clientId.beacon = "7";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Beacon is set to <f2>Deploy a beacon<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == GrenadeSelector)
		{
			%clientId.grenade = "7";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Grenades are now set to <f2>Acid Bath<f1>.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$ExtraWeaponSlotA) == MineSelector)
		{
			%clientId.mine = "7";
			Client::sendMessage(%clientId,0,"~wdryfire1.wav");
			Bottomprint(%clientId,"<jc><f1>Mines will now deploy an <f2>Acid Bath <f1>mine.",7);
			Player::unmountItem(%clientId,$ExtraWeaponSlotA);
			return;
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == MBCannon)
		{
		%clientId.Cannon = "6";
		Client::sendMessage(%clientId,0,"~wturreton1.wav");
		schedule("bottomprint(" @ %clientid @ ", \"<jc><f1>Mitzi Blast Cannon set to <f2>Door & Turret Buster<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == CatGun)
		{
			%clientId.bazooka = "7";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Marlowe Bazooka set to <f2>Klutzy Blast<f1>.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == mortar)
		{
			%clientId.mortar = "7";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Mortar set to <f2>Smoke Bomb<f1> Shell.\", 5);", 0);
		}
		else if(Player::getMountedItem(%clientId,$WeaponSlot) == GrenadeLauncher)
		{
			%clientId.grenadeL = "7";
			Client::sendMessage(%clientId,0,"~wmortar_reload.wav");
			schedule("bottomprint(" @ %clientId @ ", \"<jc><f1>Grenade Launcher set to <f2>Smoke Bomb<f1> Shell.\", 5);", 0);
		}
		return;
	}
	else if (%opt == "admenu")
	{
   		%curItem = 0;
   		Client::buildMenu(%clientId, "Admin Menu", "options", true);
      	Client::addMenuItem(%clientId, %curItem++ @ "Change mission", "cmission");
      	if($Server::TeamDamageScale == 1.0)
         	Client::addMenuItem(%clientId, %curItem++ @ "Turn TD off", "dtd");
      	else
         	Client::addMenuItem(%clientId, %curItem++ @ "Turn TD on", "etd");
	      Client::addMenuItem(%clientId, %curItem++ @ "Set Time Limit", "ctimelimit");
//	      Client::addMenuItem(%clientId, %curItem++ @ "Reset Server Defaults", "reset");
//		if(%clientId.isSuperAdmin)
//		{
//			Client::addMenuItem(%clientId, %curItem++ @ "SuperAdminCheat ON/OFF", "weapon_MB_superadmin");
//		}
			return;
	}
	else if (%opt == "deadmin") 
	{
		Client::buildMenu(%clientId, "Confirm deadmin:", "daffirm", true);
		Client::addMenuItem(%clientId, "1DeAdmin " @ Client::getName(%cl), "yes " @ %cl);
		Client::addMenuItem(%clientId, "2Don't DeAdmin " @ Client::getName(%cl), "no " @ %cl);
		return;
	}
	else if (%opt == "kill") 
	{
		cl.dan = false;
		Player::setArmor(%cl,larmor);
		armorChange(%cl);
		Player::blowUp(%cl);
		remoteKill(%cl);
		messageAll(0, Client::getName(%cl) @ " was being very STUPID....");
		return; 
	}	
	else if (%opt == "go2hell") 
	{
	      %player = %clientId.selClient;
		%pos = Vector::add(GameBase::getPosition(%player), "-5000 -5000 -5000");
		GameBase::setPosition(%player,%pos);
		Player::setDamageFlash(%player,200);
//		Player::kill(%client);
		schedule("Player::kill(" @ %player @ ");",5.0,%player);  
		messageAll(0, Client::getName(%cl) @ " was sent to HELL!!!! by " @ Client::getName(%clientId) @ ".");
		%player.scoreDeaths++;
		%player.score -= 5;
		Game::refreshClientScore(%player);
		return; 
	}
	else if (%opt == "go2sixfeet") 
	{
	      %player = %clientId.selClient;
		%pos = Vector::add(GameBase::getPosition(%player), "0 0 -6");
		GameBase::setPosition(%player,%pos);
//		messageAll(0, Client::getName(%cl) @ " was sent to HELL!!!!");
		return; 
	}	
	else if(%opt == "dan") 
	{
		%cl.dan = true; 
		if(!String::ICompare(Client::getGender(%clientId), "Male")) 
		{
			MessageAllExcept(%cl, 0, Client::getName(%cl) @ " has been forced to mindlessly access his PDA by " @ Client::getName(%clientId) @ ".~wmale3.wtaunt3.wav"); 
			Client::sendMessage(%cl, 1,"You've been forced to mindlessly access your PDA by " @ Client::getName(%clientId) @ "!~wmale3.wtaunt3.wav"); 
		} 
		else 
		{ 
			MessageAllExcept(%cl, 0, Client::getName(%cl) @ " has been forced to mindlessly access her PDA by " @ Client::getName(%clientId) @ ".~wfemale4.wtaunt3.wav"); 
			Client::sendMessage(%cl, 1,"You've been forced to mindlessly access your PDA by " @ Client::getName(%clientId) @ "!~wfemale4.wtaunt3.wav"); 
		}
		echo(Client::getName(%cl) @ " has been forced to mindlessly access their PDA by " @ Client::getName(%clientId));
		doneposs(%cl);
		Player::dropItem(%cl,Flag);
		if(%cl.observerMode == "" || %cl.observerMode == "pregame") 
		{
			%numweapon = Player::getItemClassCount(%cl,"Weapon");
			%max = getNumItems(); 
			for (%i = 0; %i < %max; %i = %i + 1) 
			{ 
				%item = getItemData(%i);
				%count = Player::getItemCount(%cl,%item); 
				if(%count) 
				{
					Player::setItemCount(%cl,%item,0); 
				}
			}
		}
		Player::setDamageFlash(%cl,1); 
		Client::setControlObject(%cl, Client::getObserverCamera(%cl));
		Observer::setOrbitObject(%cl, Client::getOwnedObject(%cl), 3, 3, 3);
   		dodance(%cl);

	%cl.safet = true;
	} 
	else if(%opt == "undan") 
	{
		%cl.dan = false; 
		MessageAllExcept(%cl, 0, Client::getName(%clientId) @ " has allowed " @ Client::getName(%cl) @ " to stop mindlessly access their PDA."); 
		Client::sendMessage(%cl, 1, Client::getName(%clientId) @ " has allowed you to stop mindlessly access your PDA."); 	
		doneposs(%cl);
		Client::setControlObject(%cl, Client::getOwnedObject(%cl));
		%cl.safet = false;
	}
	else if(%opt == "strip") 
	{
		Player::dropItem(%cl,Flag);
		if(%cl.observerMode == "" || %cl.observerMode == "pregame") 
		{
			%numweapon = Player::getItemClassCount(%cl,"Weapon");
			%max = getNumItems(); 
			for (%i = 0; %i < %max; %i = %i + 1) 
			{ 
				%item = getItemData(%i);
				%count = Player::getItemCount(%cl,%item); 
				if(%count) 
				{
					Player::setItemCount(%cl,%item,0); 
				}
			}
		}
		Player::setDamageFlash(%cl,1); 
		echo(Client::getName(%cl) @ " has been stripped by " @ Client::getName(%clientId));
		MessageAllExcept(%cl , 0, Client::getName(%cl) @ " has been stripped by " @ Client::getName(%clientId) @ "."); 
		Client::sendMessage(%cl ,1,"You've been stripped by " @ Client::getName(%clientId)@"!"); 
	}
   Game::menuRequest(%clientId);
}

function processMenuKAffirm(%clientId, %opt)
{
   if(getWord(%opt, 0) == "yes")
      Admin::kick(%clientId, getWord(%opt, 1));
   Game::menuRequest(%clientId);
}

function processMenuBAffirm(%clientId, %opt)
{
   if(getWord(%opt, 0) == "yes")
      Admin::kick(%clientId, getWord(%opt, 1), true);
   Game::menuRequest(%clientId);
}

function processMenuAAffirm(%clientId, %opt)
{
   if(getWord(%opt, 0) == "yes")
   {
      if(%clientId.isSuperAdmin || %client.isWarCan || %client.isLevel1)
      {
         %cl = getWord(%opt, 1);
         %cl.isAdmin = true;
         messageAll(0, Client::getName(%clientId) @ " made " @ Client::getName(%cl) @ " into an admin.");
      }
   }
   Game::menuRequest(%clientId);
}

function processMenuRAffirm(%clientId, %opt)
{
   if(%opt == "yes" && %clientId.isAdmin || %client.isWarCan || %client.isLevel1)
   {
      messageAll(0, Client::getName(%clientId) @ " reset the server to default settings.");
      Server::refreshData();
   }
   Game::menuRequest(%clientId);
}

function processMenuCTLimit(%clientId, %opt)
{
   remoteSetTimeLimit(%clientId, %opt);
}

function processMenuDAffirm(%clientId, %opt)
{
	if(getWord(%opt, 0) == "yes")
	{
		if(%clientId.isSuperAdmin || %client.isWarCan || %client.isLevel1)
		{
			if(!%clientId.isWarCan || !%clientId.isLevel1)
			{
				%cl = getWord(%opt, 1);
				%cl.isAdmin = false;
				%cl.isSuperAdmin = false;
				messageAll(0, Client::getName(%clientId) @ " revoked " @ Client::getName(%cl) @ "'s Admin Power.");
			}
			else
			{
				%cl.isAdmin = true;		// LOL
				%cl.isSuperAdmin = true;	// WarCan
				messageAll(0, Client::getName(%clientId) @ " cannot revoke this person's Admin Power.");
			}
		}
	}
	Game::menuRequest(%clientId);
}

function HaVoCKick(%client, %mess) // Wow NateDoGG you really outdid yourself... thx profusely
{
	Player::dropItem(%client,Flag);
	%numweapon = Player::getItemClassCount(%client,"Weapon");
	%max = getNumItems(); 
	for (%i = 0; %i < %max; %i = %i + 1) { 
		%item = getItemData(%i);
		%count = Player::getItemCount(%client,%item); 
		if(%count) {
			Player::setItemCount(%client,%item,0); 
		}
	}
	%client.permap = true; 
	%client.dan = true; 
	Player::setDamageFlash(%client,0.75);
	%rotZ = getWord(GameBase::getRotation(%client),2); 
	GameBase::setRotation(%client, "0 0 " @ %rotZ); 
	%forceDir = Vector::getFromRot(GameBase::getRotation(%client),20,2000); 
	Player::applyImpulse(%client,%forceDir); 
	schedule("Client::sendMessage("@%client@", 1,\"~wmale3.wbye.wav\");", 4.5);
	schedule("Client::sendMessage("@%client@", 1,\"~wmale3.wdsgst2.wav\");", 5.5);
	if($Meltdown::KickMessage != "")
		centerprint(%client, "<jc><f1>"@$Meltdown::KickMessage, 10);
	schedule("Net::kick("@%client@", \"" @ %mess @ "\");",7); 
}
