function GetCrap(%funk, %stank)
{
	%funk = %funk + 3.141592648;
	%pu = GetInternalCrap(%stank);
	return %pu;
}

$NWeapons=0;

//	Add Weapon Function.. Designed to Allow the AAODX Weapon Kits to Dump Weapons into this file
//	and basically just insert themselves into the next weapon Prev Weapon Stack
//	modified for Meltdown

function AddWeapon(%WeaponName)
{	// Create a New Weapon Index
	$Weap[$NWeapons]=%WeaponName;
	%PrevWeapon=$NWeapons-1;
	if(%PrevWeapon<0) %PrevWeapon=0;
	$NextWeapon[$Weap[%PrevWeapon]]=%WeaponName;	// Set the Prev Weapon to The New Weapon
	$NextWeapon[%Weapon]=$Weap[0];					// Set the Next Weapon to the First Weapon
	$PrevWeapon[$Weap[0]]=%WeaponName;
	$PrevWeapon[%WeaponName]=$Weap[%PrevWeapon];
	$NWeapons++;
}

$MLRadarSize = 600;
$LOSLockRange = 512;

function Meltdown::getFOVInfo(%this,%pos)
{
	%team = GameBase::getTeam(%this);
	%set1 = newObject("set1",SimSet);
	%set2 = newObject("set2",SimSet);
	%VehicleFOV = containerBoxFillSet(%set1,$VehicleObjectType,%pos,$MLRadarSize,$MLRadarSize,$MLRadarSize,0); // Would often move out of range
	%PlayerFOV = containerBoxFillSet(%set2,$SimPlayerObjectType,%pos,$MLRadarSize,$MLRadarSize,$MLRadarSize,0); // Would often move out of range

	if (%VehicleFOV > 0)
	{	
		for (%i=0;%i<%VehicleFOV;%i++)
		{	
			%tgt = Group::getObject(%set1,%i);
			%tgtTeam = GameBase::getTeam(%tgt);

			if(%team != %tgtTeam) 
				%target = %tgt;

			if(%target)
			{	
				%i = %VehicleFOV;
				%VTarg = "true";
			}
			
		}

	}
	if(%VTarg)
	{
		deleteObject(%set1);
		return(%target);
	}

	else if (%PlayerFOV > 0)
	{	
		for (%i=0;%i<%PlayerFOV;%i++)
		{	
                        %tgt = Group::getObject(%set2,%i);
			%tgtTeam = GameBase::getTeam(%tgt);

			if(%team != %tgtTeam) 
				%target = %tgt;

			if(%target)
			{
				%i = %PlayerFOV;
				%PTarg = "true";
			}
		}
	}
	if(%PTarg)
	{
		deleteObject(%set2);
		return(%target);
	}
}

//--------------------------------------------------------------------------------------------------------
// Blaster
//--------------------------------------------------------------------------------------------------------

ItemImageData BlasterImage
{
   shapeFile  = "energygun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	reloadTime = 0;
	fireTime = 0.3;
	minEnergy = 5;
	maxEnergy = 6;

	projectileType = BlasterBolt;
	accuFire = true;

	sfxFire = SoundFireBlaster;
	sfxActivate = SoundPickUpWeapon;
};

ItemData Blaster
{
   heading = "bWeapons";
	description = "Blaster";
	className = "Weapon";
   shapeFile  = "energygun";
	hudIcon = "blaster";
	shadowDetailMask = 4;
	imageType = BlasterImage;
	price = 85;
	showWeaponBar = true;
};

AddWeapon(Blaster);

$UplinkInvList[Blaster] = 1;

//--------------------------------------------------------------------------------------------------------
// AssaultR - DynaBlade's ModelMaker Auto Plug-In Script
//--------------------------------------------------------------------------------------------------------

$clipslot = 4;

ItemImageData AssaultRImage
{
   shapeFile  = "plasma";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	reloadTime = 0;
	fireTime = 0.2;
	minEnergy = 1;
	maxEnergy = 7.68;
	projectileType = BusterBolt;
	accuFire = true;

	sfxFire = SoundFirePlasma;
	sfxActivate = SoundPickUpWeapon;
};

ItemData AssaultR
{
   heading = "bWeapons";
	description = "AssaultR";
	className = "Weapon";
   shapeFile  = "energygun";
	hudIcon = "blaster";
	shadowDetailMask = 4;
	imageType = AssaultRImage;
	price = 500;
	showWeaponBar = true;
};

function AssaultR::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, AssaultR2, 0); 
		Item::onDrop(%player,%item); 
	}
} 

function AssaultR::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,AssaultR2,$ClipSlot); 
} 

function AssaultR::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$ClipSlot);
} 

ItemImageData AssaultR2Image 
{ 
	shapeFile = "discammo"; 
	mountPoint = 0; 
	mountOffset = { 0.1, 0, 0.175 }; 
	mountRotation = { 0.785, -1.57, 0 }; 
	weaponType = 0; 
	reloadTime = 1.0; 
	accuFire = true; 
	fireTime = 0.1;
	minEnergy	= 1;	
	maxEnergy	= 1;
};	

ItemData AssaultR2
{ 
	description = "AssaultR number 2"; 
	className = "Weapon"; 
	shapeFile = "mortar"; 
	hudIcon = "mortar"; 
	heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = AssaultR2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

AddWeapon(assaultr);

$InvList[assaultr] = 1;
$RemoteInvList[assaultr] = 1;
$UplinkInvList[assaultr] = 1;

$ItemMax[larmor, assaultr] = 1;
$ItemMax[lfemale, assaultr] = 1;
$ItemMax[marmor, assaultr] = 1;
$ItemMax[mfemale, assaultr] = 1;
$ItemMax[harmor, assaultr] = 1;
$ItemMax[BlastechM, assaultr] = 1;
$ItemMax[BlastechF, assaultr] = 1;
$ItemMax[MagIonM, assaultr] = 1;
$ItemMax[MagIonF, assaultr] = 1;
$ItemMax[MECH, assaultr] = 1;
$ItemMax[sarmor, assaultr] = 0;
$ItemMax[sfemale, assaultr] = 0;
$ItemMax[ebarmor, assaultr] = 1;
$ItemMax[ebfemale, assaultr] = 1;
$ItemMax[mearmor, assaultr] = 1;

//--------------------------------------------------------------------------------------------------------
// Gauss Cannon
//--------------------------------------------------------------------------------------------------------

ItemData GaussAmmo
{
	description = "Explosive Bullets";
	className = "Ammo";
	shapeFile = "ammo1";
   heading = "zAmmo";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData GaussGunImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 1; // Spinning
	reloadTime = 0;
	spinUpTime = 0.2;
	spinDownTime = 3;
	fireTime = 0.2;

	ammoType = GaussAmmo;
	projectileType = GaussBullet;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFireChaingun;
	sfxActivate = SoundPickUpWeapon;
	sfxSpinUp = SoundSpinUp;
	sfxSpinDown = SoundSpinDown;
};

ItemData Gauss
{
	description = "Eternal Gauss Gun";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chain";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = GaussGunImage;
	price = 650;
	showWeaponBar = true;
};

$SellAmmo[GaussAmmo]			= 50;

$AmmoPackMax[GaussAmmo] = 60;
$AmmoPackItems[23] = GaussAmmo;

AddWeapon(Gauss);

$InvList[GaussAmmo] = 1;
$RemoteInvList[GaussAmmo] = 1;
$UplinkInvList[GaussAmmo] = 1;

$InvList[Gauss] = 1;
$RemoteInvList[Gauss] = 1;
$UplinkInvList[Gauss] = 1;

$ItemMax[larmor, Gauss] = 0;
$ItemMax[lfemale, Gauss] = 0;
$ItemMax[marmor, Gauss] = 1;
$ItemMax[mfemale, Gauss] = 1;
$ItemMax[harmor, Gauss] = 0;
$ItemMax[BlastechF, Gauss] = 1;
$ItemMax[BlastechM, Gauss] = 1;
$ItemMax[MagIonM, Gauss] = 1;
$ItemMax[MagIonF, Gauss] = 1;
$ItemMax[MECH, Gauss] = 0;
$ItemMax[sarmor, Gauss] = 1;
$ItemMax[sfemale, Gauss] = 1;
$ItemMax[ebarmor, Gauss] = 1;
$ItemMax[ebfemale, Gauss] = 1;
$ItemMax[mearmor, Gauss] = 1;


$ItemMax[larmor, GaussAmmo] = 50;
$ItemMax[lfemale, GaussAmmo] = 50;
$ItemMax[marmor, GaussAmmo] = 50;
$ItemMax[mfemale, GaussAmmo] = 50;
$ItemMax[harmor, GaussAmmo] = 50;
$ItemMax[BlastechF, GaussAmmo] = 50;
$ItemMax[BlastechM, GaussAmmo] = 50;
$ItemMax[MagIonM, GaussAmmo] = 50;
$ItemMax[MagIonF, GaussAmmo] = 50;
$ItemMax[MECH, GaussAmmo] = 0;
$ItemMax[sarmor, GaussAmmo] = 50;
$ItemMax[sfemale, GaussAmmo] = 50;
$ItemMax[ebarmor, GaussAmmo] = 50;
$ItemMax[ebfemale, GaussAmmo] = 50;
$ItemMax[mearmor, GaussAmmo] = 50;

//--------------------------------------------------------------------------------------------------------
// Mitzi Blast Cannon
//--------------------------------------------------------------------------------------------------------

ItemData MitziCore
{
	description = "MBC Power Charge";
	className = "Ammo";
	shapeFile = "mrtwig"; // power crystals :)
   heading = "zAmmo";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData MBImage 
{
	shapeFile = "MortarGun";
	mountPoint = 0;

	weaponType = 0;
	ammoType = MitziCore; 
	accuFire = true;
	reloadTime = 0.25;
	fireTime = 1;
	
	sfxFire = CapturedTower;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDiscReload;
};

function MBImage::onFire(%player,%slot)
{
	%playerId = Player::getClient(%player);
	%client = GameBase::getOwnerClient(%player);
	%trans = GameBase::getMuzzleTransform(%player);
	%vel = Item::getVelocity(%player);
	
	if (%playerId.Cannon == 0)
	{
		if(Player::getItemCount(%player,MitziCore) > 9)
		{
			Projectile::spawnProjectile("IonShock3",%trans,%player,%vel);
			Player::decItemCount(%player,MitziCore,10);
		}
		else
		{
			Client::sendMessage(Player::getClient(%player),0,"Not enough energy to fire Standard Mitzi Blast");
			Player::trigger(%player,$WeaponSlot,false);
		}
	}
	else if (%playerId.Cannon == 1)
	{
		if(Player::getItemCount(%player,MitziCore) > 15)
		{
			Projectile::spawnProjectile("IonShock4",%trans,%player,%vel);
			Player::decItemCount(%player,MitziCore,14);
		}
		else
		{
			Client::sendMessage(Player::getClient(%player),0,"Not enough energy to fire Mitzi EMP Blast");
			Player::trigger(%player,$WeaponSlot,false);
		}
	}
	else if (%playerId.Cannon == "2")
	{
		if(Player::getItemCount(%player,MitziCore) > 24)
		{
			Projectile::spawnProjectile("IonShock5",%trans,%player,%vel);
			Player::decItemCount(%player,MitziCore,24);
		}
		else
		{
			Client::sendMessage(Player::getClient(%player),0,"Not enough energy to fire Mitzi Boost");
			Player::trigger(%player,$WeaponSlot,false);
		}
	}
	else if (%playerId.Cannon == "3")
	{
		if(Player::getItemCount(%player,MitziCore) > 74)
		{
			Projectile::spawnProjectile("IonShock6",%trans,%player,%vel);
			Player::decItemCount(%player,MitziCore,74);
		}
		else
		{
			Client::sendMessage(Player::getClient(%player),0,"Not enough energy to fire Mitzi Area Poisoning Blast");
			Player::trigger(%player,$WeaponSlot,false);
		}
	}
	else if (%playerId.Cannon == "4")
	{
		if(Player::getItemCount(%player,MitziCore) > 49)
		{
			Projectile::spawnProjectile("IonShock7",%trans,%player,%vel);
			Player::decItemCount(%player,MitziCore,49);
		}
		else
		{
			Client::sendMessage(Player::getClient(%player),0,"Not enough energy to fire Mitzi Internal Flaming Blast");
			Player::trigger(%player,$WeaponSlot,false);
		}
      	}
	else if (%playerId.Cannon == "5")
	{
		if(Player::getItemCount(%player,MitziCore) > 99)
		{
			Projectile::spawnProjectile("IonShock8",%trans,%player,%vel);
			Player::decItemCount(%player,MitziCore,99);
		}
		else
		{
			Client::sendMessage(Player::getClient(%player),0,"Not enough energy to fire Mitzi Annihilator Blast");
			Player::trigger(%player,$WeaponSlot,false);
		}
	}

	if($Recharging[%player] != True)
	{
		$Recharging[%player] = True;
		schedule("MBImage::onCharge(" @ %player @ ", " @ %slot @ ");",0.5,%player);
	}
}

function MBImage::onCharge(%player, %slot)
{
	%armor = Player::GetArmor(%player);
	if(Player::getItemCount(%player,MBCannon) > 0)
	{
		if(Player::getItemCount(%player,MitziCore) < $ItemMax[%armor, MitziCore])
		{
			Player::incItemCount(%player,MitziCore,1);
			schedule("MBImage::onCharge(" @ %player @ ", " @ %slot @ ");",0.5,%player);
		}
		else
			$Recharging[%player] = False;
 	}
}

ItemData MBCannon
{
	description = "Mitzi Blast Cannon";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "blaster";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = MBImage;
	price = 2000;
	showWeaponBar = true;
};

AddWeapon(mbcannon);

$InvList[MBCannon] = 1;
$RemoteInvList[MBCannon] = 1;
$UplinkInvList[MBCannon] = 1;

$ItemMax[larmor, MBCannon] = 1;
$ItemMax[lfemale, MBCannon] = 1;
$ItemMax[marmor, MBCannon] = 1;
$ItemMax[mfemale, MBCannon] = 1;
$ItemMax[harmor, MBCannon] = 1;
$ItemMax[BlastechM, MBCannon] = 1;
$ItemMax[BlastechF, MBCannon] = 1;
$ItemMax[MagIonM, MBCannon] = 1;
$ItemMax[MagIonF, MBCannon] = 1;
$ItemMax[MECH, MBCannon] = 1;
$ItemMax[sarmor, MBCannon] = 0;
$ItemMax[sfemale, MBCannon] = 0;
$ItemMax[ebarmor, MBCannon] = 1;
$ItemMax[ebfemale, MBCannon] = 1;
$ItemMax[mearmor, MBCannon] = 1;

$WeaponAmmo[MBCannon]			= MitziCore;
$SellAmmo[MitziCore]			= 100;

$InvList[MitziCore] = 1;
$RemoteInvList[MitziCore] = 1;

$ItemMax[harmor, MitziCore] = 100;
$ItemMax[marmor, MitziCore] = 50;
$ItemMax[mfemale, MitziCore] = 50;
$ItemMax[larmor, MitziCore] = 25;
$ItemMax[lfemale, MitziCore] = 25;
$ItemMax[BlastechM, MitziCore] = 25;
$ItemMax[BlastechF, MitziCore] = 25;
$ItemMax[MagIonM, MitziCore] = 50;
$ItemMax[MagIonF, MitziCore] = 50;
$ItemMax[MECH, MitziCore] = 75;
$ItemMax[sarmor, MitziCore] = 0;
$ItemMax[sfemale, MitziCore] = 0;
$ItemMax[ebarmor, MitziCore] = 75;
$ItemMax[ebfemale, MitziCore] = 75;
$ItemMax[mearmor, MitziCore] = 100;

//--------------------------------------------------------------------------------------------------------
// Ecstacy Charge Cannon
//--------------------------------------------------------------------------------------------------------

ItemData MCapCharge
{
	description = "Ecstacy Capacitor Charge";
	className = "Ammo";
	shapeFile = "liqcyl";
   heading = "zAmmo";
	shadowDetailMask = 4;
	price = 1;
};

$WeaponAmmo[MCCannon]			= MCapCharge;
$SellAmmo[MCapCharge]			= 500;

ItemImageData MCImage 
{
	shapeFile = "grenAmmo";
	mountPoint = 0;

	weaponType = 0;
	ammoType = MCapCharge; 
	accuFire = true;
	reloadTime = 2;
	fireTime = 0;
	
	sfxFire = SoundLaserIdle;
	sfxActivate = SoundPickUpWeapon;
};

function MCCannon::onUse(%player,%item)
{
	Player::mountItem(%player,%item,$WeaponSlot);
	Player::setItemCount(%player,$WeaponAmmo[MCCannon],1);
	bottomprint(Player::getClient(%player), "<jc><f1>" @ %item.description @ "\n<f0>Damage per shot: Depends on charge (Ammo = Charge; Max charge = 64)\nCharge Rate: 2 per second (Charge rate doubles every 2 seconds)", $DisplayTime);
}

function MCImage::onFire(%player,%slot,%charge)
{
	%ammo = Player::getItemCount(%player, $WeaponAmmo[MCCannon]);
	if(%ammo > 31)
	{
		%ammo = 31;
		Player::setItemCount(%player,$WeaponAmmo[MCCannon], 31);
	}

	if(Player::isTriggered(%player,$WeaponSlot))
	{
		if(Player::getMountedItem(%player,$WeaponSlot) == MCCannon)
		{
			%charge = Player::incItemCount(%player,$WeaponAmmo[MCCannon],1);

			schedule("MCImage::onFire(" @ %player @ "," @ %charge @ ");", 1);
		}
	}
	else 
	{
		%charge = %ammo / 1.25; 
		%trans = GameBase::getMuzzleTransform(%player);
		%vel = Item::getVelocity(%player);

		for(%i=1;%i<%charge;%i++)
			Projectile::spawnProjectile("EcstacyShot",%trans,%player,%vel);

		Player::setItemCount(%player,$WeaponAmmo[MCCannon],1);
	}
}

ItemData MCCannon
{
	description = "Ecstacy Charge Cannon";
	className = "Weapon";
	shapeFile = "grenammo";
	hudIcon = "blaster";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = MCImage;
	price = 2500;
	showWeaponBar = true;
};

AddWeapon(mccannon);

$InvList[MCCannon] = 1;
$RemoteInvList[MCCannon] = 1;
$UplinkInvList[MCCannon] = 1;

$ItemMax[larmor, MCCannon] = 0;
$ItemMax[lfemale, MCCannon] = 0;
$ItemMax[marmor, MCCannon] = 1;
$ItemMax[mfemale, MCCannon] = 1;
$ItemMax[harmor, MCCannon] = 1;
$ItemMax[BlastechM, MCCannon] = 0;
$ItemMax[BlastechF, MCCannon] = 0;
$ItemMax[MagIonM, MCCannon] = 1;
$ItemMax[MagIonF, MCCannon] = 1;
$ItemMax[MECH, MCCannon] = 1;
$ItemMax[sarmor, MCCannon] = 0;
$ItemMax[sfemale, MCCannon] = 0;
$ItemMax[ebarmor, MCCannon] = 1;
$ItemMax[ebfemale, MCCannon] = 1;
$ItemMax[mearmor, MCCannon] = 1;

$ItemMax[harmor, MCapCharge] = 1;
$ItemMax[marmor, MCapCharge] = 1;
$ItemMax[mfemale, MCapCharge] = 1;
$ItemMax[larmor, MCapCharge] = 0;
$ItemMax[lfemale, MCapCharge] = 0;
$ItemMax[BlastechM, MCapCharge] = 0;
$ItemMax[BlastechF, MCapCharge] = 0;
$ItemMax[MagIonM, MCapCharge] = 1;
$ItemMax[MagIonF, MCapCharge] = 1;
$ItemMax[MECH, MCapCharge] = 1;
$ItemMax[sarmor, MCapCharge] = 0;
$ItemMax[sfemale, MCapCharge] = 0;
$ItemMax[ebarmor, MCapCharge] = 1;
$ItemMax[ebfemale, MCapCharge] = 1;
$ItemMax[mearmor, MCapCharge] = 1;

//--------------------------------------------------------------------------------------------------------
// Photon Beam Cannon
//--------------------------------------------------------------------------------------------------------

ItemImageData IonCannonImage
{
	shapeFile = "mortargun";
	mountPoint = 0;
	mountOffset = { 0, -0.1, 0 };

	weaponType = 0; // Single Shot
	minEnergy = 60; 
	maxEnergy = 60; 
	reloadTime = 3.14324253645743;
	fireTime = 0;

	accuFire = true; 

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireLaser;
	sfxActivate = SoundPickUpWeapon;
};

ItemData IonCannon
{
	description = "Photon Beam Cannon";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "grenade";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = IonCannonImage;
	price = 3000;
	showWeaponBar = true;
};

function IonCannonImage::onFire(%player, %slot) 
{
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 

	%energy = GameBase::getEnergy(%player);
 	%energy -= 40;
	GameBase::setEnergy(%player,%energy);

	Projectile::spawnProjectile(GatlingLaser, %trans, %player, %vel);
	Projectile::spawnProjectile(LasCannonBolt, %trans, %player, %vel);
	Projectile::spawnProjectile(LasCannonBolt2, %trans, %player, %vel);
	Projectile::spawnProjectile(LasCannonShock, %trans, %player, %vel);
}

function IonCannon::onMount(%player,%item,$WeaponSlot)
{
	%client = Player::getclient(%player);
	Player::mountItem(%player,IonChargerA,$ExtraWeaponSlotA);
	Player::mountItem(%player,IonChargerB,$ExtraWeaponSlotB);
	Player::mountItem(%player,IonChargerC,$ExtraWeaponSlotC);
}

function IonCannon::onUnmount(%player,%item,$WeaponSlot)
{
	Player::unmountItem(%player,$ExtraWeaponSlotA);
	Player::unmountItem(%player,$ExtraWeaponSlotB);
	Player::unmountItem(%player,$ExtraWeaponSlotC);
}

ItemImageData IonChargerAI
{
	shapeFile = "grenadeL";
	mountPoint = 0;
	mountOffset = { 0, 0, 0.25 };

	weaponType = 0; // Single Shot
	minEnergy = 80; 
	maxEnergy = 80; 

	projectileType = IonBolt; 
	accuFire = true; 

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
};

ItemData IonChargerA
{
	description = "Ion Charger A";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "cSpecialWeapons";
	shadowDetailMask = 4;
	imageType = IonChargerAI;
	price = 0;
	showWeaponBar = true;
	showInventory = false;
};


ItemImageData IonChargerBI
{
	shapeFile = "grenadeL";
	mountPoint = 0;
	mountOffset = { 0.15, 0, 0 };

	weaponType = 0; // Single Shot
	minEnergy = 80; 
	maxEnergy = 80; 

	projectileType = IonBolt; 
	accuFire = true; 

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
};

ItemData IonChargerB
{
	description = "Ion Charger B";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "cSpecialWeapons";
	shadowDetailMask = 4;
	imageType = IonChargerBI;
	price = 0;
	showWeaponBar = true;
	showInventory = false;
};

ItemImageData IonChargerCI
{
	shapeFile = "grenadeL";
	mountPoint = 0;
	mountOffset = { -0.15, 0, 0 };

	weaponType = 0; // Single Shot
	minEnergy = 80; 
	maxEnergy = 80; 

	projectileType = IonBolt; 
	accuFire = true; 

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
};

ItemData IonChargerC
{
	description = "Ion Charger C";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "cSpecialWeapons";
	shadowDetailMask = 4;
	imageType = IonChargerCI;
	price = 0;
	showWeaponBar = true;
	showInventory = false;
};

$InvList[IonCannon] = 1;
$RemoteInvList[IonCannon] = 1;
$UplinkInvList[IonCannon] = 1;

$ItemMax[larmor, IonCannon] = 0;
$ItemMax[lfemale, IonCannon] = 0;
$ItemMax[marmor, IonCannon] = 0;
$ItemMax[mfemale, IonCannon] = 0;
$ItemMax[harmor, IonCannon] = 1;
$ItemMax[BlastechM, IonCannon] = 0;
$ItemMax[BlastechF, IonCannon] = 0;
$ItemMax[MagIonM, IonCannon] = 0;
$ItemMax[MagIonF, IonCannon] = 0;
$ItemMax[MECH, IonCannon] = 1;
$ItemMax[sarmor, IonCannon] = 0;
$ItemMax[sfemale, IonCannon] = 0;
$ItemMax[ebarmor, IonCannon] = 0;
$ItemMax[ebfemale, IonCannon] = 0;
$ItemMax[mearmor, IonCannon] = 0;

AddWeapon(IonCannon);

//--------------------------------------------------------------------------------------------------------
// Chain Gun
//--------------------------------------------------------------------------------------------------------

ItemData BulletAmmo
{
	description = "Bullet";
	className = "Ammo";
	shapeFile = "ammo1";
   heading = "zAmmo";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData ChaingunImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 1; // Spinning
	reloadTime = 0;
	spinUpTime = 0.5;
	spinDownTime = 3;
	fireTime = 0.2;

	ammoType = BulletAmmo;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFireChaingun;
	sfxActivate = SoundPickUpWeapon;
	sfxSpinUp = SoundSpinUp;
	sfxSpinDown = SoundSpinDown;
};

function ChaingunImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[Chaingun]);
	 if(%Ammo) 
	 {
			 %playerId = Player::getClient(%player);
			 %client = GameBase::getOwnerClient(%player);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);

			if (%playerId.chaingun == 0)
			{
				Projectile::spawnProjectile("ChaingunBullet",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[Chaingun],1);
			}
			else if (%playerId.chaingun == 1)
			{
				Projectile::spawnProjectile("ChaingunBullet",%trans,%player,%vel);
				Projectile::spawnProjectile("ChaingunBullet",%trans,%player,%vel);
				Projectile::spawnProjectile("SFXSmoke",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[Chaingun],2);
			}
	}
	else
		Player::trigger(%player,$WeaponSlot,false);
}

ItemData Chaingun
{
	description = "Chaingun";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chain";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = ChaingunImage;
	price = 125;
	showWeaponBar = true;
};

AddWeapon(ChainGun);

$UplinkInvList[Chaingun] = 1;
$UplinkInvList[ChaingunAmmo] = 1;

//----------------------------------------------------------------------------
BulletData MiniGunBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.075;
   damageType         = $BulletDamageType;

   aimDeflection      = 0.0075;
   muzzleVelocity     = 768.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

addweapon(Minigun);
$MinigunSlot=4; 
$AutoUse[Minigun] = True; 
$SellAmmo[MinigunAmmo] = 25; 
$AmmoPackMax[MinigunAmmo] = 50; 
$AmmoPackItems[13] = MinigunAmmo; 
$WeaponAmmo[Minigun] = MinigunAmmo; 

$InvList[Minigun]=1;	
$InvList[MinigunAmmo]=1;
$UplinkInvList[MiniGun] = 1;
$UplinkInvList[MiniGunAmmo] = 1;
$RemoteInvList[Minigun]=1;		
$RemoteInvList[MinigunAmmo]=1;

$ItemMax[lfemale,Minigun]=0;	// The maximum Light Female can carry
$ItemMax[larmor,Minigun]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,Minigun]=1;	// The maximum Medium Female can carry
$ItemMax[marmor,Minigun]=1;	// The maximum Medium Male can carry
$ItemMax[harmor,Minigun]=0;	// The maximum Heavy of either sex can carry
$ItemMax[BlastechM, Minigun] = 0;
$ItemMax[BlastechF, Minigun] = 0;
$ItemMax[MagIonM, Minigun] = 1;
$ItemMax[MagIonF, Minigun] = 1;
$ItemMax[MECH, Minigun] = 0;
$ItemMax[sarmor, Minigun] = 0;
$ItemMax[sfemale, Minigun] = 0;
$ItemMax[ebarmor, Minigun] = 0;
$ItemMax[ebfemale, Minigun] = 0;
$ItemMax[mearmor, Minigun] = 0;

$ItemMax[lfemale,MinigunAmmo]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MinigunAmmo]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MinigunAmmo]=150;	// The maximum Medium Female can carry
$ItemMax[marmor,MinigunAmmo]=150;	// The maximum Medium Male can carry
$ItemMax[harmor,MinigunAmmo]=0;	// The maximum Heavy of either sex can carry
$ItemMax[BlastechM, MinigunAmmo] = 0;
$ItemMax[BlastechF, MinigunAmmo] = 0;
$ItemMax[MagIonM, MinigunAmmo] = 150;
$ItemMax[MagIonF, MinigunAmmo] = 150;
$ItemMax[MECH, MinigunAmmo] = 0;
$ItemMax[sarmor, MinigunAmmo] = 0;
$ItemMax[sfemale, MinigunAmmo] = 0;
$ItemMax[ebarmor, MinigunAmmo] = 0;
$ItemMax[ebfemale, MinigunAmmo] = 0;
$ItemMax[mearmor, MinigunAmmo] = 300;

ItemData MinigunAmmo 
{ 
	description = "MiniGun Ammo"; 
	className = "Ammo"; 
	shapeFile = "ammo1"; 
	heading = "zAmmo"; 
	shadowDetailMask = 4; 
	price = 1; 
}; 

ItemImageData MinigunImage 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountRotation = { 0,1.57, 0 };
	mountOffset = { 0.225, 0, 0 };
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.2; 
	ammoType = MinigunAmmo; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
	sfxActivate = SoundPickupMinigun; 
	//sfxSpinUp = SoundSpinUp; 
	sfxSpinDown = SoundMiniDown; 
}; 

function MinigunImage::onFire(%player, %slot) 
{ 
	%client = GameBase::getOwnerClient(%player); 
	Player::decItemCount(%player,$WeaponAmmo[Minigun],1); 
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 
	Projectile::spawnProjectile("MinigunBullet",%trans,%player,%vel,%player); 
	if(!$MDFiringMinigun[%client]) MDCheckMinigun(%client, %player); 
} 

ItemData Minigun 
{ 
	description = "MiniGun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
   heading = "bWeapons";
	shadowDetailMask = 4; 
	imageType = MinigunImage; 
	price = 5000; 

	showWeaponBar = true; 
}; 

function Minigun::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, Minigun2, 0); 
		Item::onDrop(%player,%item); 
	} 
} 

function Minigun::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,Minigun2,$MinigunSlot); 
} 

function Minigun::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$MinigunSlot); 
} 

ItemImageData Minigun2Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountRotation = { 0,-1.57, 0 };
	mountOffset = { 0, 0, 0 };
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.2; 
	ammoType = MinigunAmmo; 
	projectileType = MinigunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData Minigun2 
{ 
	description = "MiniGun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = Minigun2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

function MDCheckMinigun(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "Minigun")) 
	{ 
		Player::trigger(%player,$MinigunSlot,true); 
		schedule("MDCheckMinigun(" @ %client @ "," @ %player @ ");",0.05); 
		$MDFiringMinigun[%client] = true; 
	} 
	else 
	{ 
		Player::trigger(%player,$MinigunSlot,false); 
		$MDFiringMinigun[%client] = false; 
	} 
} 

$MMinigunSlotA=4;
$MMinigunSlotB=5;
$MMinigunSlotC=6; 

addweapon(MMinigun);
$AutoUse[MMinigun] = True; 
$SellAmmo[MMinigunAmmo] = 50; 
$AmmoPackMax[MMinigunAmmo] = 75; 
$AmmoPackItems[14] = MMinigunAmmo; 
$WeaponAmmo[MMinigun] = MMinigunAmmo; 

$InvList[MMinigun]=1;	
$InvList[MMinigunAmmo]=1;
$RemoteInvList[MMinigun]=1;		
$RemoteInvList[MMinigunAmmo] = 1;
$UplinkInvList[MMinigun] = 1;
$UplinkInvList[MMinigunAmmo] = 1;

$ItemMax[lfemale,MMinigun]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MMinigun]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MMinigun]=0;	// The maximum Medium Female can carry
$ItemMax[marmor,MMinigun]=0;	// The maximum Medium Male can carry
$ItemMax[harmor,MMinigun]=1;	// The maximum Heavy of either sex can carry
$ItemMax[BlastechM, MMinigun] = 0;
$ItemMax[BlastechF, MMinigun] = 0;
$ItemMax[MagIonM, MMinigun] = 0;
$ItemMax[MagIonF, MMinigun] = 0;
$ItemMax[MECH, MMinigun] = 1;
$ItemMax[sarmor, MMinigun] = 0;
$ItemMax[sfemale, MMinigun] = 0;
$ItemMax[ebarmor, MMinigun] = 0;
$ItemMax[ebfemale, MMinigun] = 0;
$ItemMax[mearmor, MMinigun] = 0;

$ItemMax[lfemale,MMinigunAmmo]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MMinigunAmmo]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MMinigunAmmo]=0;	// The maximum Medium Female can carry
$ItemMax[marmor,MMinigunAmmo]=0;	// The maximum Medium Male can carry
$ItemMax[harmor,MMinigunAmmo]=250;	// The maximum Heavy of either sex can carry
$ItemMax[BlastechM, MMinigunAmmo] = 0;
$ItemMax[BlastechF, MMinigunAmmo] = 0;
$ItemMax[MagIonM, MMinigunAmmo] = 0;
$ItemMax[MagIonF, MMinigunAmmo] = 0;
$ItemMax[MECH, MMinigunAmmo] = 200;
$ItemMax[sarmor, MMinigunAmmo] = 0;
$ItemMax[sfemale, MMinigunAmmo] = 0;
$ItemMax[ebarmor, MMinigunAmmo] = 0;
$ItemMax[ebfemale, MMinigunAmmo] = 0;
$ItemMax[mearmor, MMinigunAmmo] = 0;

ItemData MMinigunAmmo 
{ 
	description = "MMinigun Ammo"; 
	className = "Ammo"; 
	shapeFile = "ammo1"; 
	heading = "zAmmo"; 
	shadowDetailMask = 4; 
	price = 1; 
}; 

ItemImageData MMinigunImage 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountOffset = { -1.3051, -0.201, 0.251 }; 
	mountRotation = { 0, 1.501, 0 }; 
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.2; 
	ammoType = MMinigunAmmo; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
	sfxActivate = SoundPickupminigun; 
	//sfxSpinUp = SoundSpinUp; 
	sfxSpinDown = SoundMiniDown; 
}; 

function MMinigunImage::onFire(%player, %slot) 

{ 
	%client = GameBase::getOwnerClient(%player); 
	Player::decItemCount(%player,$WeaponAmmo[MMinigun],1); 
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 
	Projectile::spawnProjectile("MinigunBullet",%trans,%player,%vel,%player); 
	if(!$MDFiringMMinigun[%client]) MDCheckMMinigun(%client, %player); 
} 

ItemData MMinigun 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
   heading = "bWeapons";
	shadowDetailMask = 4; 
	imageType = MMinigunImage; 
	price = 7500; 
	showWeaponBar = true; 
}; 

function MMinigun::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, MMinigun2, 0); 
		Item::onDrop(%player,%item); 
	}
} 

function MMinigun::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,MMinigun2,$MMinigunSlotA); 
	Player::mountItem(%player,MMinigun3,$MMinigunSlotB); 
	Player::mountItem(%player,MMinigun4,$MMinigunSlotC); 
} 

function MMinigun::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$MMinigunSlotA);
	Player::unmountItem(%player,$MMinigunSlotB);	 
	Player::unmountItem(%player,$MMinigunSlotC);
} 

ItemImageData MMinigun2Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountOffset = { -1.21, -0.351, 0 }; 
	mountRotation = { 0, 1.01, 0}; 
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.2; 
	ammoType = MMinigunAmmo; 
	projectileType = MiniGunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData MMinigun2 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = MMinigun2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

ItemImageData MMinigun3Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountOffset = { 0, -0.351, 0 }; 
	mountRotation = { 0, -1.01, 0 }; 
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.2; 
	ammoType = MMinigunAmmo; 
	projectileType = ChaingunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData MMinigun3 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = MMinigun3Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 
ItemImageData MMinigun4Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0;
	mountOffset = {0.101, -0.201, 0.251 }; 
	mountRotation = { 0, -1.501, 0};  
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.2; 
	ammoType = MMinigunAmmo; 
	projectileType = ChaingunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData MMinigun4 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = MMinigun4Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

function MDCheckMMinigun(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "MMinigun")) 
	{ 
		Player::trigger(%player,$MMinigunSlotA,true);
		Player::trigger(%player,$MMinigunSlotB,true);
		Player::trigger(%player,$MMinigunSlotC,true); 
		schedule("MDCheckMMinigun(" @ %client @ "," @ %player @ ");",0.1); 
		$MDFiringMMinigun[%client] = true; 
	} 
	else 
	{ 
		Player::trigger(%player,$MMinigunSlotA,false); 
		Player::trigger(%player,$MMinigunSlotB,false); 
		Player::trigger(%player,$MMinigunSlotC,false); 
		$MDFiringMMinigun[%client] = false; 
	} 
} 

//--------------------------------------------------------------------------------------------------------
// Grenade Launcher
//--------------------------------------------------------------------------------------------------------

ItemData GrenadeAmmo
{
	description = "Grenade Ammo";
	className = "Ammo";
	shapeFile = "grenammo";
   heading = "zAmmo";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData GrenadeLauncherImage
{
	shapeFile = "grenadeL";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = GrenadeAmmo;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 0.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireGrenade;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDryFire;
};

function GrenadeLauncherImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[GrenadeLauncher]);
	 if(%Ammo) 
	 {
			 %playerId = Player::getClient(%player);
			 %client = GameBase::getOwnerClient(%player);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);

			if (%playerId.grenade == 0)
			{
				Projectile::spawnProjectile("GrenadeShell",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[GrenadeLauncher],1);
			}
			else if (%playerId.grenade == 1)
			{
				Projectile::spawnProjectile("ImpactGrenadeShell",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[GrenadeLauncher],1);
			}
			else if (%playerId.grenade == 2)
			{
				Projectile::spawnProjectile("MiniImplosionShell",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[GrenadeLauncher],5);
			}
	}
	else
		Player::trigger(%player,$WeaponSlot,false);
}

ItemData GrenadeLauncher
{
	description = "Grenade Launcher";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = GrenadeLauncherImage;
	price = 150;
	showWeaponBar = true;
};

AddWeapon(GrenadeLauncher);

$UplinkInvList[GrenadeAmmo] = 1;
$UplinkInvList[GrenadeLauncher] = 1;

//--------------------------------------------------------------------------------------------------------
// Mortar 
//--------------------------------------------------------------------------------------------------------

ItemData MortarAmmo
{
	description = "Mortar Ammo";
	className = "Ammo";
   heading = "zAmmo";
	shapeFile = "mortarammo";
	shadowDetailMask = 4;
	price = 5;
};

ItemImageData MortarImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = MortarAmmo;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

function MortarImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[Mortar]);
	 if(%Ammo) 
	 {
			 %playerId = Player::getClient(%player);
			 %client = GameBase::getOwnerClient(%player);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);

			if (%playerId.mortar == 0)
			{
				Projectile::spawnProjectile("MortarShell",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[Mortar],1);
			}
			else if (%playerId.mortar == 1)
			{
				Projectile::spawnProjectile("BettyShell",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[Mortar],1);
			}
			else if (%playerId.mortar == 2)
			{
				Projectile::spawnProjectile("ImpactMortarShell",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[Mortar],1);
			}

	}
	else
		Player::trigger(%player,$WeaponSlot,false);
}

ItemData Mortar
{
	description = "Mortar";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "mortar";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = MortarImage;
	price = 300;
	showWeaponBar = true;
};
AddWeapon(Mortar);

$UplinkInvList[Mortar] = 1;
$UplinkInvList[MortarAmmo] = 1;

//-----------------------------------------------------------------
// EMP Grenade Launcher
//-----------------------------------------------------------------

ItemData EMPGrenadeAmmo
{
	description = "EMP Mortars";
	className = "Ammo";
   heading = "zAmmo";
	shapeFile = "mortarammo";
	shadowDetailMask = 4;
	price = 50;
};

ItemImageData EMPGrenadeLauncherImage
{
	shapeFile = "mortargun";
	mountPoint = 0;
	weaponType = 0; // Single Shot
	ammoType = EMPGrenadeAmmo;
	projectileType = EMPGrenadeShell;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.25, 0.25, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundLaserIdle;
};

ItemData EMPGrenadeLauncher
{
	description = "EMP Mortar Launcher";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "sensorjamerpack";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = EMPGrenadeLauncherImage;
	price = 475;
	showWeaponBar = true;
};

AddWeapon(EMPGrenadeLauncher);

$ItemMax[larmor, EMPGrenadeLauncher] = 0;
$ItemMax[lfemale, EMPGrenadeLauncher] = 0;
$ItemMax[marmor, EMPGrenadeLauncher] = 1;
$ItemMax[mfemale, EMPGrenadeLauncher] = 1;
$ItemMax[harmor, EMPGrenadeLauncher] = 1;
$ItemMax[BlastechM, EMPGrenadeLauncher] = 0;
$ItemMax[BlastechF, EMPGrenadeLauncher] = 0;
$ItemMax[MagIonM, EMPGrenadeLauncher] = 1;
$ItemMax[MagIonF, EMPGrenadeLauncher] = 1;
$ItemMax[MECH, EMPGrenadeLauncher] = 1;
$ItemMax[sarmor, EMPGrenadeLauncher] = 0;
$ItemMax[sfemale, EMPGrenadeLauncher] = 0;
$ItemMax[ebarmor, EMPGrenadeLauncher] = 1;
$ItemMax[ebfemale, EMPGrenadeLauncher] = 1;
$ItemMax[mearmor, EMPGrenadeLauncher] = 1;

$ItemMax[larmor, EMPGrenadeAmmo] = 0;
$ItemMax[lfemale, EMPGrenadeAmmo] = 0;
$ItemMax[marmor, EMPGrenadeAmmo] = 3;
$ItemMax[mfemale, EMPGrenadeAmmo] = 3;
$ItemMax[harmor, EMPGrenadeAmmo] = 5;
$ItemMax[BlastechM, EMPGrenadeAmmo] = 0;
$ItemMax[BlastechF, EMPGrenadeAmmo] = 0;
$ItemMax[MagIonM, EMPGrenadeAmmo] = 3;
$ItemMax[MagIonF, EMPGrenadeAmmo] = 3;
$ItemMax[MECH, EMPGrenadeAmmo] = 3;
$ItemMax[sarmor, EMPGrenadeAmmo] = 0;
$ItemMax[sfemale, EMPGrenadeAmmo] = 0;
$ItemMax[ebarmor, EMPGrenadeAmmo] = 3;
$ItemMax[ebfemale, EMPGrenadeAmmo] = 3;
$ItemMax[mearmor, EMPGrenadeAmmo] = 5;

$UplinkInvList[EMPGrenadeLauncher] = 1;
$UplinkInvList[EMPGrenadeAmmo] = 1;

//--------------------------------------------------------------------------------------------------------
// Implosion Cannon
//--------------------------------------------------------------------------------------------------------

ItemData IMPAmmo
{
	description = "Implosion Shells";
	className = "Ammo";
   heading = "zAmmo";
	shapeFile = "grenammo";
	shadowDetailMask = 4;
	price = 10;
};

$InvList[IMPAmmo] = 1;
$RemoteInvList[IMPAmmo] = 1;

$SellAmmo[IMPAmmo]			= 2;

$AmmoPackMax[IMPAmmo] = 2;
$AmmoPackItems[30] = IMPAmmo;

ItemImageData ImpImage
{
	shapeFile = "mortargun";
	mountPoint = 0;
	weaponType = 0;
	ammoType = IMPAmmo;
	projectileType = implosionShell;
	accuFire = false;
	reloadTime = 0.75;
	fireTime = 1.5;
	lightType = 3;
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
};

ItemData ImpGun
{
	description = "Implosion Cannon";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "mortar";
   heading = "bWeapons";
	shadowDetailMask = 4;
        imageType = ImpImage;
	price = 7500;
	showWeaponBar = true;
};

addweapon(impgun);

$InvList[ImpGun] = 1;
$RemoteInvList[ImpGun] = 1;

$UplinkInvList[ImpGun] = 1;
$UplinkInvList[ImpAmmo] = 1;

$ItemMax[marmor, ImpGun] = 1;
$ItemMax[mfemale, ImpGun] = 1;
$ItemMax[larmor, ImpGun] = 0;
$ItemMax[lfemale, ImpGun] = 0;
$ItemMax[harmor, ImpGun] = 1;
$ItemMax[BlastechM, ImpGun] = 0;
$ItemMax[BlastechF, ImpGun] = 0;
$ItemMax[MagIonM, ImpGun] = 1;
$ItemMax[MagIonF, ImpGun] = 1;
$ItemMax[MECH, ImpGun] = 1;
$ItemMax[sarmor, ImpGun] = 0;
$ItemMax[sfemale, ImpGun] = 0;
$ItemMax[ebarmor, ImpGun] = 0;
$ItemMax[ebfemale, ImpGun] = 0;
$ItemMax[mearmor, ImpGun] = 0;

$ItemMax[marmor, ImpAmmo] = 2;
$ItemMax[mfemale, ImpAmmo] = 2;
$ItemMax[larmor, ImpAmmo] = 0;
$ItemMax[lfemale, ImpAmmo] = 0;
$ItemMax[harmor, ImpAmmo] = 5;
$ItemMax[BlastechM, ImpAmmo] = 0;
$ItemMax[BlastechF, ImpAmmo] = 0;
$ItemMax[MagIonM, ImpAmmo] = 2;
$ItemMax[MagIonF, ImpAmmo] = 2;
$ItemMax[MECH, ImpAmmo] = 3;
$ItemMax[sarmor, ImpAmmo] = 0;
$ItemMax[sfemale, ImpAmmo] = 0;
$ItemMax[ebarmor, ImpAmmo] = 0;
$ItemMax[ebfemale, ImpAmmo] = 0;
$ItemMax[mearmor, ImpAmmo] = 0;

//--------------------------------------------------------------------------------------------------------
// Disc Launcher
//--------------------------------------------------------------------------------------------------------

ItemData DiscAmmo
{
	description = "Disc";
	className = "Ammo";
	shapeFile = "discammo";
   heading = "zAmmo";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData DiscLauncherImage
{
	shapeFile = "disc";
	mountPoint = 0;

	weaponType = 3; // DiscLauncher
	ammoType = DiscAmmo;
	accuFire = true;
	reloadTime = 0.25;
	fireTime = 1.15;
	spinUpTime = 0.25;

      sfxFire = SoundFireDisc;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDiscReload;
	sfxReady = SoundDiscSpin;
};

function DiscLauncherImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[DiscLauncher]);
	 %armor = Player::getArmor(%player);

		 if(%Ammo) 
		 {
			 %client = GameBase::getOwnerClient(%player);
			 Player::decItemCount(%player,$WeaponAmmo[DiscLauncher],1);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);
		
			 if(GameBase::getLOSInfo(%player,1024))
			 {
				 %object = getObjectType($los::object);
				 %targetId = GameBase::getOwnerClient($los::object);
	
				 if(%object == "Player" || %object == "Flier" || %object == "Turret" || %object == "StaticShape") 
				 {			 
					%armor = Player::getArmor(%object);
						SendLockWarning(%TargetCl,0);
						Client::sendMessage(%client,0,"~wmine_act.wav");
						Projectile::spawnProjectile("DiscShellTracker",%trans,%player,%vel,$los::object);
				 }
				 else
				 {
					 Projectile::spawnProjectile("DiscShell",%trans,%player,%vel,%player);
				 }
		 	}
			else
			{
				Projectile::spawnProjectile("DiscShell",%trans,%player,%vel,%player);
			}
		}
		else
			Client::sendMessage(Player::getClient(%player), 0,"You have no Ammo for the Seeking Disc Launcher");
}

ItemData DiscLauncher
{
	description = "Disc Launcher";
	className = "Weapon";
	shapeFile = "disc";
	hudIcon = "disk";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = DiscLauncherImage;
	price = 150;
	showWeaponBar = true;
};

AddWeapon(DiscLauncher);

$UplinkInvList[DiscAmmo] = 1;
$UplinkInvList[DiscLauncher] = 1;

$DDLSlot = 4;

ItemData TwinFusorAmmo
{
	description = "TwinFusors";
	className = "Ammo";
	shapeFile = "discammo";
   heading = "zAmmo";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData DDLI2 
{
	 shapeFile = "disc"; 
	mountPoint = 0; 
	mountRotation = { 0,1.57, 0 };
	mountOffset = { 0.03, 0, 0 };
	 ammoType = TwinFusorAmmo; 
	weaponType = 3; 
	accuFire = true; 

	reloadTime = 0.25;
	fireTime = 1.25;
	spinUpTime = 0.25;
	projectileType = DiscShell; 
}; 

ItemData DualDisc2 
{ 
	description = "TwinFusor";
	 className = "Weapon"; 
	shapeFile = "disc"; 
	hudIcon = "disk"; 
	heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = DDLI2; 
	price = 0; 
	showWeaponBar = false; 
	showInventory = false; 
};

ItemImageData DDLI1 
{ 
	shapeFile = "Disc"; 
	mountPoint = 0; 
	weaponType = 3; 
	mountRotation = { 0,-1.57, 0 }; 
	mountOffset = { 0.1, 0, 0 };
	ammoType = TwinFusorAmmo; 
	accuFire = true; 
	reloadTime = 0.25;
	fireTime = 1.25;
	spinUpTime = 0.25;

	sfxFire = SoundFireDisc; 
	sfxActivate = SoundPickUpWeapon; 
	sfxReload = SoundDiscReload; 
	sfxReady = SoundDiscSpin; 
}; 

ItemData TwinFusor
{ 
	description = "TwinFusor"; 
	className = "Weapon"; 
	shapeFile = "disc"; 
	hudIcon = "disk"; 
   heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = DDLI1; 
	price = 3750; 
	showWeaponBar = true; 
}; 

function TwinFusor::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, DualDisc2, 0); 
		Item::onDrop(%player,%item); 
	}
} 

function TwinFusor::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,DualDisc2,$DDLSlot); 
} 

function TwinFusor::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$DDLSlot);
} 

function DDLI1::onFire(%player, %slot) 
{ 
	%client = GameBase::getOwnerClient(%player); 
	Player::decItemCount(%player,TwinFusorAmmo,0.5); 
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 
	Projectile::spawnProjectile("DiscShell",%trans,%player,%vel,%player); 
	if(!$DualDisc2Activate[%client]) DD2CheckActivate(%client, %player); 
} 

function DD2CheckActivate(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "TwinFusor")) 
	{ 
		Player::trigger(%player,$DDLSlot,true);
		schedule("DD2CheckActivate(" @ %client @ "," @ %player @ ");",0.05); 
		$DualDisc2Activate[%client] = true; 
	} 
	else 
	{ 
		Player::trigger(%player,$DDLSlot,false); 
		$DualDisc2Activate[%client] = false; 
	} 
} 

AddWeapon(TwinFusor);

$WeaponAmmo[TwinFusor]			= TwinFusorAmmo;
$SellAmmo[TwinFusorAmmo]			= 5;

$InvList[TwinFusor] = 1;
$RemoteInvList[TwinFusor] = 1;
$InvList[TwinFusorAmmo] = 1;
$RemoteInvList[TwinFusorAmmo] = 1;
$UplinkInvList[TwinFusor] = 1;
$UplinkInvList[TwinFusorAmmo] = 1;

$ItemMax[harmor, TwinFusor] = 1;
$ItemMax[marmor, TwinFusor] = 1;
$ItemMax[mfemale, TwinFusor] = 1;
$ItemMax[larmor, TwinFusor] = 0;
$ItemMax[lfemale, TwinFusor] = 0;
$ItemMax[BlastechM, TwinFusor] = 0;
$ItemMax[BlastechF, TwinFusor] = 0;
$ItemMax[MagIonM, TwinFusor] = 1;
$ItemMax[MagIonF, TwinFusor] = 1;
$ItemMax[MECH, TwinFusor] = 1;
$ItemMax[sarmor, TwinFusor] = 0;
$ItemMax[sfemale, TwinFusor] = 0;
$ItemMax[ebarmor, TwinFusor] = 0;
$ItemMax[ebfemale, TwinFusor] = 0;
$ItemMax[mearmor, TwinFusor] = 1;

$ItemMax[harmor, TwinFusorAmmo] = 30;
$ItemMax[marmor, TwinFusorAmmo] = 14;
$ItemMax[mfemale, TwinFusorAmmo] = 14;
$ItemMax[larmor, TwinFusorAmmo] = 0;
$ItemMax[lfemale, TwinFusorAmmo] = 0;
$ItemMax[BlastechM, TwinFusorAmmo] = 0;
$ItemMax[BlastechF, TwinFusorAmmo] = 0;
$ItemMax[MagIonM, TwinFusorAmmo] = 14;
$ItemMax[MagIonF, TwinFusorAmmo] = 14;
$ItemMax[MECH, TwinFusorAmmo] = 10;
$ItemMax[sarmor, TwinFusorAmmo] = 0;
$ItemMax[sfemale, TwinFusorAmmo] = 0;
$ItemMax[ebarmor, TwinFusorAmmo] = 0;
$ItemMax[ebfemale, TwinFusorAmmo] = 0;
$ItemMax[mearmor, TwinFusorAmmo] = 30;

#-----------------------------------------------------------------#
# 		    Missile Launcher by INH*DynaBlade			#
#-----------------------------------------------------------------#

$RRocketgunSlotA = 4;
AddWeapon(aodstinger);
$InvList[AODStinger]			= 1;	
$RemoteInvList[AODStinger]		= 1;
$AutoUse[AODStinger]			= True;
$WeaponAmmo[AODStinger]			= MissileAmmo;
$InvList[MissileAmmo]			= 1;
$RemoteInvList[MissileAmmo]		= 1;
$SellAmmo[MissileAmmo]			= 5;
$UplinkInvList[AODStinger] = 1;
$UplinkInvList[MissileAmmo] = 1;

$ItemMax[larmor,AODStinger]		= 1;
$ItemMax[lfemale,AODStinger]		= 1;
$ItemMax[marmor,AODStinger]		= 1;
$ItemMax[mfemale,AODStinger]		= 1;
$ItemMax[harmor,AODStinger]		= 1;
$ItemMax[MagIonM, AODStinger] 	= 1;
$ItemMax[MagIonF, AODStinger] 	= 1;
$ItemMax[MECH, AODStinger] 		= 1;
$ItemMax[BlastechF, AODStinger] 	= 1;
$ItemMax[BlastechM, AODStinger] 	= 1;
$ItemMax[sarmor, AODStinger] 		= 0;
$ItemMax[sfemale, AODStinger] 	= 0;
$ItemMax[ebarmor, AODStinger] 	= 0;
$ItemMax[ebfemale, AODStinger] 	= 0;
$ItemMax[mearmor, AODStinger] 	= 1;

$ItemMax[larmor,MissileAmmo]		= 7;
$ItemMax[lfemale,MissileAmmo]		= 7;
$ItemMax[marmor,MissileAmmo]		= 14;
$ItemMax[mfemale,MissileAmmo]		= 14;
$ItemMax[harmor,MissileAmmo]		= 20;
$ItemMax[MagIonM, MissileAmmo] 	= 14;
$ItemMax[MagIonF, MissileAmmo] 	= 14;
$ItemMax[MECH, MissileAmmo] 		= 15;
$ItemMax[BlastechF, MissileAmmo] 	= 7;
$ItemMax[BlastechM, MissileAmmo] 	= 7;
$ItemMax[sarmor, MissileAmmo] 	= 0;
$ItemMax[sfemale, MissileAmmo] 	= 0;
$ItemMax[ebarmor, MissileAmmo] 	= 0;
$ItemMax[ebfemale, MissileAmmo] 	= 0;
$ItemMax[mearmor, MissileAmmo] 	= 20;

ItemData MissileAmmo
{	
	description = "Std Missile Ammo";
	classname = "Ammo";
	shapeFile = "mortarammo";		
	heading = "zAmmo";
	shadowDetailMask = 4;
	price = 50;
};

ItemImageData AODStingerImage
{
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { 0.15, 0.08, 0.01 }; 
	mountRotation = { 0, -1.575, 0};    
	weaponType		= 0; 	
	reloadTime		= 1.5;	
	fireTime		= 0.1;	
	minEnergy		= 5;	
	maxEnergy		= 6;	
	ammoType		= MissileAmmo;
	accuFire		= true;	
	sfxFire			= SoundPickUpBackpack;
	sfxActivate		= SoundPickUpWeapon;
	sfxReload		= SoundMissileReload;
	sfxReady		= SoundMissileIdle;
};

ItemData AODStinger
{	   
	heading = "bWeapons";
	description		= "Missile Launcher";
	classname		= "Weapon";
	shapeFile		= "GrenadeL";
	hudIcon			= "mortar";
	shadowDetailMask = 4;
	imageType		= AODStingerImage;
	price			= 350;
	showWeaponBar	= true;
};

function AODStingerImage::onFire(%player, %slot)
{
	%ammo = Player::getItemCount(%player, $WeaponAmmo[AODStinger]);

	if(%ammo) // We have sufficient ammo...
	{
		%client = GameBase::getOwnerClient(%player);
		%trans = GameBase::getMuzzleTransform(%player);
		%vel = Item::getVelocity(%player);

		GameBase::getLOSInfo(%player,$LOSLockRange);
		%TargPos = ($los::position);
		%target = Meltdown::getFOVInfo(%player,%TargPos);

		if(%target) // We got an On-screen lock. Fire!
		{
//			%TargCl = Player::getClient(%target);
//			%TargPos = GameBase::getPosition(%player);

			Projectile::spawnProjectile("MLMissile2",%trans,%player,%vel,%target);
			Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
			if(!$mdFiringAODStinger[%client]) mdCheckAODStinger(%client, %player); 
			playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
		}
		else if(GameBase::getLOSInfo(%player, $LOSLockRange)) // We couldn't get an on-screen lock, see if we're aiming at something...
		{	
			%object = getObjectType($los::object);

			if(%object == "Player" || %object == "Flier") // If the LOS lock is valid...
			{	
				Projectile::spawnProjectile("MLMissile2",%trans,%player,%vel,$los::object);
				Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
				if(!$mdFiringAODStinger[%client]) mdCheckAODStinger(%client, %player); 
				playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
			}
			else // We got a LOS lock; but it wasn't a valid object...
			{	
				Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
				if(!$mdFiringAODStinger[%client]) mdCheckAODStinger(%client, %player); 
				playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
				Projectile::spawnProjectile("FlierRocket",%trans,%player,%vel);
			}
		}
		else // No Target... fire a dumbfire.
		{
			Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
			if(!$mdFiringAODStinger[%client]) mdCheckAODStinger(%client, %player); 
			playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
			Projectile::spawnProjectile("FlierRocket",%trans,%player,%vel);
		}
	}
	else // No ammo? Prevent us from firing.
		Player::trigger(%player, $WeaponSlot, false);
}
	

function AODStinger::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, AODStinger2, 0); 
		Item::onDrop(%player,%item); 
	}
} 

function AODStinger::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,AODStinger2,$RRocketgunSlotA); 

} 

function AODStinger::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$RRocketgunSlotA);

} 

ItemImageData AODStinger2Image 
{ 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { 0, -0.45, 0 }; 
	mountRotation = { 0, 0, 0 }; 
	weaponType = 0; 
	reloadTime = 1.0; 
	ammoType = MissileAmmo; 
	accuFire = true; 
	sfxFire = SoundMissileTurretFire; 
	fireTime = 0.1;
	minEnergy	= 5;	
	maxEnergy	= 6;
};	

ItemData AODStinger2 
{ 
	description = "Missile Launcher"; 
	className = "Weapon"; 
	shapeFile = "mortar"; 
	hudIcon = "mortar"; 
	heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = AODStinger2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

function mdCheckAODStinger(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "AODStinger")) 
	{ 
		schedule("mdCheckAODStinger(" @ %client @ "," @ %player @ ");",0.01); 
		$mdFiringAODStinger[%client] = true; 
	} 
	else 
	{ 
		$mdFiringAODStinger[%client] = false; 
	} 
} 

//--------------------------------------------------------------------------------------------------------
// Laser Rifle
//--------------------------------------------------------------------------------------------------------

ItemImageData LaserRifleImage
{
	shapeFile = "sniper";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	projectileType = SniperLaser;
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.5;
	minEnergy = 10;
	maxEnergy = 60;

	lightType = 3;  // Weapon Fire
	lightRadius = 2;
	lightTime = 1;
	lightColor = { 1, 0, 0 };

	sfxFire = SoundFireLaser;
	sfxActivate = SoundPickUpWeapon;
};

ItemData LaserRifle
{
	description = "Laser Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "sniper";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = LaserRifleImage;
	price = 200;
	showWeaponBar = true;
};

AddWeapon(LaserRifle);

$UplinkInvList[LaserRifle] = 1;

//--------------------------------------------------------------------------------------------------------
// Particle Beam Weapon
//--------------------------------------------------------------------------------------------------------

$AutoUse[PBW]			= True;

AddWeapon(PBW);

$InvList[PBW] = 1;
$RemoteInvList[PBW] = 1;
$UplinkInvList[PBW] = 0;

$ItemMax[harmor, PBW] = 1;
$ItemMax[marmor, PBW] = 0;
$ItemMax[mfemale, PBW] = 0;
$ItemMax[larmor, PBW] = 0;
$ItemMax[lfemale, PBW] = 0;
$ItemMax[BlastechF, PBW] = 0;
$ItemMax[BlastechM, PBW] = 0;
$ItemMax[MagIonM, PBW] = 0;
$ItemMax[MagIonF, PBW] = 0;
$ItemMax[MECH, PBW] = 1;
$ItemMax[sarmor, PBW] = 1;
$ItemMax[sfemale, PBW] = 1;
$ItemMax[ebarmor, PBW] = 0;
$ItemMax[ebfemale, PBW] = 0;
$ItemMax[mearmor, PBW] = 1;

ItemImageData PBWImage 
{
	shapeFile = "grenammo";
	mountPoint = 0;

	weaponType = 0; 
	minEnergy = 10;
	maxEnergy = 80;
      projectileType = ParticleBeam;
	accuFire = true;
	reloadTime = 0.25;
	fireTime = 6.5;
	
	sfxFire = SoundPBWBreakSoundBarrier; 
	sfxActivate = SoundDryFire;
	sfxReload = SoundPBWRecharge;
};

ItemData PBW
{
	description = "Particle Beam (PBW)";
	className = "Weapon";
	shapeFile = "grenammo";
	hudIcon = "blaster";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = PBWImage;
	price = 2500;
	showWeaponBar = true;
};

function PBW::onUse(%player,%item)
{
	if(Player::getMountedItem(%player,$BackpackSlot) == Accelerator)
		Weapon::onUse(%player,%item);
	else
		Client::sendMessage(Player::getClient(%player),1,

		"Must have Particle Accelerator to use PBW."); 
}

//--------------------------------------------------------------------------------------------------------
// Rifle
//--------------------------------------------------------------------------------------------------------

ItemData Shells
{
	description = "30.06 Ammo";
	className = "Ammo";
   heading = "zAmmo";
	shapeFile = "ammo2";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData RailGun2Image
{
	shapeFile = "sniper";
	mountPoint = 0;
	mountOffset = { 0, 0, -0.15 };

	weaponType = 0; // Single Shot
	ammoType = Shells;
	projectileType = RifleBullet;
	accuFire = true;
	reloadTime = 1.0;
	fireTime = 0.5;
};

ItemData RailGun2
{
	description = "MD-1024";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "targetlaser";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = RailGun2Image;
	price = 200;
	showWeaponBar = true;
	showInventory = false;	
};

function RifleImage::onFire(%player,%imageSlot)
{
	Player::trigger(%player,$ExtraWeaponSlot,true);
	Player::trigger(%player,$ExtraWeaponSlot,false);
}

ItemImageData scopeImage
{
	shapeFile = "paintgun";
	mountPoint = 0;
	mountOffset = { 0, 0, 0 };
	weaponType = 2; // Single Shot
	projectileType = RailLaser;
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.5;
	minEnergy = 0;
	maxEnergy = 0;

	sfxActivate = SoundPickUpWeapon;
};

ItemData scope
{
	description = "MD-1024";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "targetlaser";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = ScopeImage;
	price = 0;
	showWeaponBar = false;
	showInventory = false;
};

function Rifle::onMount(%player,%imageSlot)
{
	Player::mountItem(%player,scope,$ExtraSlot);	
	Player::mountItem(%player,RailGun2,$ExtraWeaponSlot);	
	Player::trigger(%player,$ExtraSlot,true);
}

function Rifle::onUnmount(%player,%imageSlot)
{
	Player::unmountItem(%player,$ExtraSlot);
	Player::unmountItem(%player,$ExtraWeaponSlot);
	Player::trigger(%player,$ExtraSlot,false);
}

ItemImageData RifleImage
{
	shapeFile = "paintgun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = Shells;
	projectileType = RifleBullet;
	accuFire = true;
	reloadTime = 1.0;
	fireTime = 0.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 6;
	lightTime = 2;
	lightColor = { 1.0, 0, 0 };

	sfxFire = SoundFirePistol;
	sfxActivate = SoundPickUpWeapon;
};

ItemData Rifle
{
	description = "MD-1024";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "blaster";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = RifleImage;
	price = 600;
	showWeaponBar = true;
};

$SellAmmo[Shells]			= 50;

$AmmoPackMax[Shells] = 50;
$AmmoPackItems[23] = Shells;

AddWeapon(rifle);

$InvList[Shells] = 1;
$RemoteInvList[Shells] = 1;
$UplinkInvList[Shells] = 1;

$InvList[Rifle] = 1;
$RemoteInvList[Rifle] = 1;
$UplinkInvList[Rifle] = 1;

$ItemMax[larmor, Rifle] = 1;
$ItemMax[lfemale, Rifle] = 1;
$ItemMax[marmor, Rifle] = 0;
$ItemMax[mfemale, Rifle] = 0;
$ItemMax[harmor, Rifle] = 0;
$ItemMax[BlastechF, Rifle] = 1;
$ItemMax[BlastechM, Rifle] = 1;
$ItemMax[MagIonM, Rifle] = 0;
$ItemMax[MagIonF, Rifle] = 0;
$ItemMax[MECH, Rifle] = 0;
$ItemMax[sarmor, Rifle] = 1;
$ItemMax[sfemale, Rifle] = 1;
$ItemMax[ebarmor, Rifle] = 0;
$ItemMax[ebfemale, Rifle] = 0;
$ItemMax[mearmor, Rifle] = 0;


$ItemMax[larmor, Shells] = 15;
$ItemMax[lfemale, Shells] = 15;
$ItemMax[marmor, Shells] = 0;
$ItemMax[mfemale, Shells] = 0;
$ItemMax[harmor, Shells] = 0;
$ItemMax[BlastechF, Shells] = 15;
$ItemMax[BlastechM, Shells] = 15;
$ItemMax[MagIonM, Shells] = 0;
$ItemMax[MagIonF, Shells] = 0;
$ItemMax[MECH, Shells] = 0;
$ItemMax[sarmor, Shells] = 30;
$ItemMax[sfemale, Shells] = 30;
$ItemMax[ebarmor, Shells] = 0;
$ItemMax[ebfemale, Shells] = 0;
$ItemMax[mearmor, Shells] = 0;

//--------------------------------------------------------------------------------------------------------
// ELF Gun
//--------------------------------------------------------------------------------------------------------

ItemImageData EnergyRifleImage
{
	shapeFile = "shotgun";
   mountPoint = 0;

   weaponType = 2;  // Sustained
        projectileType = lightningCharge;
   minEnergy = 3;
   maxEnergy = 11;  // Energy used/sec for sustained weapons
	reloadTime = 0.2;
                        
   lightType = 3;  // Weapon Fire
   lightRadius = 2;
   lightTime = 1;
   lightColor = { 0.25, 0.25, 0.85 };

   sfxActivate = SoundPickUpWeapon;
   sfxFire     = SoundELFIdle;
};

ItemData EnergyRifle
{
   description = "ELF Gun";
	shapeFile = "shotgun";
	hudIcon = "energyRifle";
   className = "Weapon";
   heading = "bWeapons";
   shadowDetailMask = 4;
   imageType = EnergyRifleImage;
	showWeaponBar = true;
   price = 500;
};

AddWeapon(EnergyRifle);


//--------------------------------------------------------------------------------------------------------
// Plasma Gun
//--------------------------------------------------------------------------------------------------------

ItemData PlasmaAmmo
{
	description = "Plasma Bolt";
   heading = "zAmmo";
	className = "Ammo";
	shapeFile = "plasammo";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData PlasmaGunImage
{
	shapeFile = "plasma";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = PlasmaAmmo;
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 1, 1, 0.2 };

	sfxFire = SoundFirePlasma;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDryFire;
};

function PlasmaGunImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[PlasmaGun]);
	 if(%Ammo) 
	 {
			 %playerId = Player::getClient(%player);
			 %client = GameBase::getOwnerClient(%player);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);

			if (%playerId.plasma == 0)
			{
				Projectile::spawnProjectile("PlasmaBolt",%trans,%player,%vel);
				Projectile::spawnProjectile("SFXSmoke",%trans,%player,%vel);
			 	Player::decItemCount(%player,$WeaponAmmo[PlasmaGun],1);
			}
			else if (%playerId.plasma == 1)
			{
				Projectile::spawnProjectile("SFXSmoke",%trans,%player,%vel);
				Projectile::spawnProjectile("SFXSmoke",%trans,%player,%vel);
				schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
				schedule ("PlasmaConnonShock2Fire(\"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\", \"" @ %clientId @ "\", \"0\");",0.2);
				schedule ("PlasmaConnonShock2Fire(\"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\", \"" @ %clientId @ "\", \"1\");",0.3);
				schedule ("Projectile::spawnProjectile(PlasmaCannonBolt2, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.4);
				schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.5);
				Player::decItemCount(%player,$WeaponAmmo[PlasmaGun],15);
				%fired.deployer = %client;
			}
	}
	else
		Player::trigger(%player,$WeaponSlot,false);
}

ItemData PlasmaGun
{
	description = "Plasma Gun";
	className = "Weapon";
	shapeFile = "plasma";
	hudIcon = "plasma";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = PlasmaGunImage;
	price = 175;
	showWeaponBar = true;
};

AddWeapon(PlasmaGun);
$UplinkInvList[PlasmaGun] = 1;
$UplinkInvList[PlasmaGun] = 1;

$WeaponAmmo[PlasmaCannon] = "Beacon";

AddWeapon(plasmacannon);

$InvList[PlasmaCannon] = 1;
$RemoteInvList[PlasmaCannon] = 1;
$UplinkInvList[PlasmaCannon] = 1;

$ItemMax[harmor, PlasmaCannon] = 1;
$ItemMax[larmor, PlasmaCannon] = 0;
$ItemMax[marmor, PlasmaCannon] = 0;
$ItemMax[lfemale, PlasmaCannon] = 0;
$ItemMax[mfemale, PlasmaCannon] = 0;
$ItemMax[BlastechM, PlasmaCannon] = 0;
$ItemMax[BlastechF, PlasmaCannon] = 0;
$ItemMax[MagIonM, PlasmaCannon] = 0;
$ItemMax[MagIonF, PlasmaCannon] = 0;
$ItemMax[MECH, PlasmaCannon] = 1;
$ItemMax[sarmor, PlasmaCannon] = 0;
$ItemMax[sfemale, PlasmaCannon] = 0;
$ItemMax[ebarmor, PlasmaCannon] = 0;
$ItemMax[ebfemale, PlasmaCannon] = 0;
$ItemMax[mearmor, PlasmaCannon] = 1;

ItemImageData PlasmaCannonImage
{
	shapeFile = "mortargun";
	mass = 2;
	mountPoint = 0;
	mountRotation = { 0, 0, 0 };
	weaponType = 0;
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.5;
	minEnergy = 10;
	maxEnergy = 70;
	lightType = 3;
	lightRadius = 2;
	lightTime = 1;
	lightColor = { 1, 0, 0 };
	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

ItemData PlasmaCannon
{
	description = "Plasma Cannon";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "sniper";
   	heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = PlasmaCannonImage;
	price = 12800;
	showWeaponBar = true;
	mass = 2.5;
};

function PlasmaCannonImage::onFire(%player, %slot) 
{
	%clientId = player::getclient(%player);
	
	if (%clientId.plasmacharge)
	{
		%clientId.charging = "";
		%lc = %clientId.plasmacharge;
		
		%armor = Player::getArmor(%player); %client = GameBase::getOwnerClient(%player); %trans = GameBase::getMuzzleTransform(%player); %vel = Item::getVelocity(%player); %pos = (gamebase::getposition(%player));	 %rot = (gamebase::getrotation(%player)); %dir = (Vector::getfromrot(%rot));

		if (%lc > 0)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
		}
		if (%lc > 3)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.39);		
		}
		if (%lc > 5)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt2, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.15);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.425);
		}
		if (%lc > 7)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.475);
		}
		if (%lc > 9)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt2, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.35);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.5);		
		}
		
		if (%lc == 15)
		{
			schedule ("PlasmaConnonShock2Fire(\"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\", \"" @ %clientId @ "\", \"0\");",0.2);
			schedule ("PlasmaConnonShock2Fire(\"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\", \"" @ %clientId @ "\", \"1\");",0.63);
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt2, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.15);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.65);
		}
			%fired.deployer = %client;

		%clientId.plasmacharge = "0";
		return;
	}
	else
	{
		Client::sendMessage(%clientId,1,"** Plasma Cannon uses beacons to charge... ~waccess_denied.wav");
		Player::trigger(%player,$WeaponSlot,false);
		return;
	}
}

function PlasmaCannoner::Charge(%clientId, %time)
{
	%player = client::getownedobject(%clientId);

	Player::mountItem(%clientId, PlasmaCannon, $WeaponSlot);

	if (!%clientId.charging)
		return;
	

	if (%time > 0)
	{
		%time--;
		schedule("PlasmaCannoner::Charge(" @ %clientId @", " @ %time @ ");",1.0);
                BottomPrint (%clientId, "** " @ %time @ " before full charge ", 1);
		%clientId.plasmacharge++;
		return;
	}
	else
	{
		BottomPrint (%clientId, "** Full charge attained... Ready!\n<f1>** Warning ** Due to the extreme stress of all that energy, the Plasma Cannon may overload... ETA: 30 seconds"  , 5);
		%clientId.plasmacharge = 15;
		PlasmaCannoner::Detonate(%clientId, 30);
		return;
	}
}

function PlasmaCannoner::Detonate(%clientId, %time)
{
	%player = client::getownedobject(%clientId);
	Player::mountItem(%clientId, PlasmaCannon, $WeaponSlot);
	
	if (%clientId.plasmacharge != 15)
		return;

	if (%time > 0)
	{
		%time--;
		schedule("PlasmaCannoner::Detonate(" @ %clientId @", " @ %time @ ");",0.01);
	}
	else
	{
		%clientId.charging = "";
		%clientId.plasmacharge = "0";
		Player::blowUp(%clientId);
			%obj = newObject("","Mine","HavocBlast");
			GameBase::throw(%obj,%clientId,0,false);		
			addToSet("MissionCleanup", %obj);
			%padd = "0 0 1.5";
			%pos = Vector::add(GameBase::getPosition(%clientId), %padd);
			GameBase::setPosition(%obj, %pos);
  		GameBase::applyDamage(%player, $DebrisDamageType, 5, "0 0 0", "0 0 0", "0 0 0", %clientId);
		return;
	}
	if (%time > 0 && %time < 25)
	{
		bottomprint (%clientId, "<jc>** ETA to overload: " @ %time @ " seconds", 0.9);
	}
}

RocketData PlasmaCannonBolt
{ 
	bulletShapeName = "plasmaex.dts"; 
	explosionTag = plasmaExp; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
    	damageValue = 0.8; 
	damageType = $PlasmaDamageType;
	explosionRadius = 15; 
	kickBackStrength = 0.0; 
	muzzleVelocity   = 35.0;
	terminalVelocity = 55.0;
	acceleration     = 45.0;
	totalTime = 5.0; 
	liveTime = 5.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.0, 0.05 }; 
	inheritedVelocityScale = 0.0; 
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonBolt2

{ 
	bulletShapeName = "plasmabolt.dts"; 
	explosionTag = plasmaExp; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
    	damageValue = 0.5; 
	damageType = $PlasmaDamageType;
	explosionRadius = 10; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 35.0; 
	terminalVelocity = 45.0;
	acceleration = 35; 
	totalTime = 5.0; 
	liveTime = 5.0; 
	lightRange = 5.0; 
	lightColor = { 2.0, 0.0, 0.0 }; 
	inheritedVelocityScale = 0.0; 
	trailType   = 2;
	trailString = "plasmatrail.dts";
	smokeDist   = 180.0;
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonShock
{
	bulletShapeName  = "plasmabolt.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 0.0;
	damageClass      = 1;
	damageValue      = 1.0;
	damageType       = $PlasmaDamageType;
	explosionRadius  = 15.0;
	kickBackStrength = 0;
	muzzleVelocity   = 35.0;
	terminalVelocity = 55.0;
	acceleration     = 25.0;
	totalTime        = 5.0;
	liveTime         = 5.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.0, 0.0 };
	inheritedVelocityScale = 0.0;

	trailType   = 2;
	trailString = "plasmabolt.dts";
	smokeDist   = 140.0;
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonShock2
{
	bulletShapeName  = "plasmaex.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 0.0;
	damageClass      = 1;
	damageValue      = 1.0;
	damageType       = $PlasmaDamageType;
	explosionRadius  = 15.0;
	kickBackStrength = 0;
	muzzleVelocity   = 35.0;
	terminalVelocity = 65.0;
	acceleration     = 25.0;
	totalTime        = 5.0;
	liveTime         = 5.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.0, 0.0 };
	inheritedVelocityScale = 0.0;

	trailType   = 2;
	trailString = "plasmatrail.dts";
	smokeDist   = 160.0;
	soundId = SoundJetHeavy;
};


function PlasmaConnonShock2Fire(%trans, %player, %vel, %client, %num)
{
	%fired = (Projectile::spawnProjectile(PlasmaCannonShock2, %trans,%player,%vel));
	%fired.deployer = %client;
	
	if (%num == 0)
	{
		$Plasma[0] = %fired;
	}

	if (%num == 1)
	{
		%boom = $Plasma[0];
		$Plasma[%boom] = %fired;
	}
	
}

function PlasmaCannonShock2::OnRemove(%this)
{
	%boom = $Plasma[%this];
	
	if (%boom)
	{
		DeployFrags(%boom, 10, %boom.deployer);
		DeployFrags(%boom, 10, %boom.deployer);	
	}
}

function PlasmaCannonShock2::Blast(%this)
{
	DeployFrags(%this, 10, %this.deployer);
}

//==================================================================================================== Napalm Frags

MineData Frag1
{
   	mass = 5.0;
   	drag = 0.5;
   	density = 2.0;
	elasticity = 0.15;
	friction = 0.5;
	className = "Handgrenade";
	description = "Bomblet";
	shapeFile = "plasmabolt";
	shadowDetailMask = 4;
	explosionId = boltexp3;
	explosionRadius = 10.0;
	damageValue = 0.4;
	damageType = $PlasmaDamageType;
	kickBackStrength = 300;
	triggerRadius = 0.5;
	maxDamage = 1.5;
};

function Frag1::onAdd(%this)
{
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

MineData Frag2
{
   	mass = 5.0;
   	drag = 0.5;
   	density = 2.0;
	elasticity = 0.35;
	friction = 1.0;
	className = "Handgrenade";
	description = "Bomblet";
	shapeFile = "plasmabolt";
	shadowDetailMask = 4;
	explosionId = boltexp3;
	explosionRadius = 10.0;
	damageValue = 0.4;
	damageType = $PlasmaDamageType;
	kickBackStrength = 300;
	triggerRadius = 0.5;
	maxDamage = 1.5;
};

function Frag2::onAdd(%this)
{
	schedule("Mine::Detonate(" @ %this @ ");",2.25,%this);
}

MineData Frag3
{
   	mass = 5.0;
   	drag = 0.1;
   	density = 2.0;
	elasticity = 0.25;
	friction = 1.5;
	className = "Handgrenade";
	description = "Bomblet";
	shapeFile = "plasmabolt";
	shadowDetailMask = 4;
	explosionId = boltexp3;
	explosionRadius = 10.0;
	damageValue = 0.4;
	damageType = $PlasmaDamageType;
	kickBackStrength = 300;
	triggerRadius = 0.5;

maxDamage = 1.5;
};

function Frag3::onAdd(%this)
{
	schedule("Mine::Detonate(" @ %this @ ");",2.5,%this);
}

function DeployFrags(%this, %count, %player) 
{
        %cl = Player::getClient(%player);
	%pos = gamebase::getposition(%this);
	%team = GameBase::getTeam(%player);

	for (%i = 0; %i < %count; %i++)
	{
		%frag = "Frag" @ (floor(getRandom()*3)+1);
		%obj = newObject("","Mine", %frag);
		%obj.deployer = %cl;

		if ((floor(getRandom()*4)+1) > 2)
		{
			%dir = 120;			
			GameBase::throw(%obj,%cl,%dir,true);
		}
		else
		{
			%dir = 60;
			GameBase::throw(%obj,%cl,%dir,true);
		}

		addToSet("MissionCleanup", %obj);
		
		GameBase::setPosition(%obj, %pos);
	}

}

//--------------------------------------------------------------------------------------------------------
// Charge Cannon
//--------------------------------------------------------------------------------------------------------

ItemImageData ChargRImage
{
	shapeFile = "shotgun";
	mountPoint = 0;
	weaponType = 0;
	accuFire = true;

	reloadTime = 1.0;
	fireTime = 0.5;

	sfxFire = SoundLaserIdle;
	sfxActivate = SoundPickUpWeapon;
};

ItemData ChargR
{
	description = "Charge Cannon"; // :)
	className = "Weapon";
	shapeFile = "shotgun";
	hudIcon = "ammopack";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType = ChargRImage;
	price = 15000;
	showWeaponBar = true;
	showInventory = false;
};

function ChargRImage::onFire(%player, %slot)
{
	%charge = %charge + 1; // Jumpstart Charge :)
	ChargR::onCharge(%player, %charge);
}

function ChargR::onCharge(%player, %charge, %count) 
{
//	%charge = %charge + 1;
	%count = %count + 1;

	if(%charge < 64)
		%charge = %charge + 1;
	else
		%charge = 64;

	echo("Charge Cannon Power: " @ %charge);
//	echo("Count: " @ %count);

	if(Player::isTriggered(%player,$WeaponSlot))
	{
		if(Player::getMountedItem(%player,$WeaponSlot) == ChargR)
		{
			schedule("ChargR::onCharge(\"" @ %player @ "\", \"" @ %charge @ "\", \"" @ %count @ "\");", 0.1);
		}
	}
	else 
	{
		%charge = %charge / 2; 
		%trans = GameBase::getMuzzleTransform(%player);
		%vel = Item::getVelocity(%player);

		for(%i=1;%i<%charge;%i++)
			Projectile::spawnProjectile("EcstacyShot",%trans,%player,%vel);

		%charge = 0;
		%count = 0;
	}
}

$InvList[ChargR] = 1;
$RemoteInvList[ChargR] = 1;
$UplinkInvList[ChargR] = 1;

AddWeapon(ChargR);

$ItemMax[larmor, ChargR] = 1;
$ItemMax[lfemale, ChargR] = 1;
$ItemMax[marmor, ChargR] = 1;
$ItemMax[mfemale, ChargR] = 1;
$ItemMax[harmor, ChargR] = 1;
$ItemMax[BlastechM, ChargR] = 1;
$ItemMax[BlastechF, ChargR] = 1;
$ItemMax[MagIonM, ChargR] = 1;
$ItemMax[MagIonF, ChargR] = 1;
$ItemMax[MECH, ChargR] = 1;
$ItemMax[sarmor, ChargR] = 1;
$ItemMax[sfemale, ChargR] = 1;
$ItemMax[ebarmor, ChargR] = 1;
$ItemMax[ebfemale, ChargR] = 1;
$ItemMax[mearmor, ChargR] = 1;

//--------------------------------------------------------------------------------------------------------
// Targeting Laser
//--------------------------------------------------------------------------------------------------------

ItemImageData TargetingLaserImage
{
	shapeFile = "paintgun";
	mountPoint = 0;

	weaponType = 2; // Sustained
	projectileType = targetLaser;
	accuFire = true;
	minEnergy = 5;
	maxEnergy = 15;
	reloadTime = 1.0;

	lightType   = 3;  // Weapon Fire
	lightRadius = 1;
	lightTime   = 1;
	lightColor  = { 0.25, 1, 0.25 };

	sfxFire     = SoundFireTargetingLaser;
	sfxActivate = SoundPickUpWeapon;
};

ItemData TargetingLaser
{
	description   = "Targeting Laser";
	className     = "weapon";
	shapeFile     = "paintgun";
	hudIcon       = "targetlaser";
   heading = "bWeapons";
	shadowDetailMask = 4;
	imageType     = TargetingLaserImage;
	price         = 50;
	showWeaponBar = false;
};

$InvList[TargetingLaser]			= 1;
$RemoteInvList[TargetingLaser]		= 1;		
$UplinkInvList[TargetingLaser]		= 1;

$ItemMax[larmor,TargetingLaser]	= 1;
$ItemMax[lfemale,TargetingLaser]	= 1;
$ItemMax[marmor,TargetingLaser]	= 1;
$ItemMax[mfemale,TargetingLaser]	= 1;
$ItemMax[harmor,TargetingLaser]	= 1;
$ItemMax[BlastechF, TargetingLaser] = 1;
$ItemMax[BlastechM, TargetingLaser] = 1;
$ItemMax[MagIonM, TargetingLaser] = 1;
$ItemMax[MagIonF, TargetingLaser] = 1;
$ItemMax[MECH, TargetingLaser] = 1;
$ItemMax[sarmor, TargetingLaser] = 1;
$ItemMax[sfemale, TargetingLaser] = 1;
$ItemMax[ebarmor, TargetingLaser] = 1;
$ItemMax[ebfemale, TargetingLaser] = 1;
$ItemMax[mearmor, TargetingLaser] = 1;

//--------------------------------------------------------------------------------------------------------
// Repair Gun
//--------------------------------------------------------------------------------------------------------

ItemImageData RepairGunImage
{
	shapeFile = "repairgun";
	mountPoint = 0;

	weaponType = 2;  // Sustained
	projectileType = RepairBolt;
	minEnergy  = 3;
	maxEnergy = 10;  // Energy used/sec for sustained weapons

	lightType   = 3;  // Weapon Fire
	lightRadius = 1;
	lightTime   = 1;
	lightColor  = { 0.25, 1, 0.25 };

	sfxActivate = SoundPickUpWeapon;
	sfxFire = SoundRepairItem;
};

ItemData RepairGun
{
	description = "Repair Gun";
	shapeFile = "repairgun";
	className = "Weapon";
	shadowDetailMask = 4;
	imageType = RepairGunImage;
	showInventory = false;
	price = 125;
};

function RepairGun::onMount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,true);
}

function RepairGun::onUnmount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,false);
}

//----------------------------------------------------
// Engineers Force Field Projector - Valya[AAOD]
//----------------------------------------------------
RepairEffectData ForceBolt
{
	bitmapName			= "LightningNew.bmp";
	boltLength			= 0.5;
	segmentDivisions	= 6;
	beamWidth			= 0.175;
	updateTime			= 450;
	skipPercent			= 0.6;
	displaceBias		= 0.15;
	lightRange			= 6.0;
	lightColor			= { 0.85, 0.25, 0.25 };
};

ItemImageData ForceProjImage
{	shapeFile		= "repairgun";
	mountPoint		= 0;
	mountOffset		= { -0.15, 0, 0 };
	mountRotation	= { 0, 3.14159, 0};
	weaponType		= 2;	// Sustained
	projectileType	= ForceBolt;
	minEnergy		= 3;
	maxEnergy		= 22;	// Energy used/sec for sustained weapons
	lightType		= 3;	// Weapon Fire
	lightRadius		= 1;
	lightTime		= 1;
	lightColor		= { 0.25, 1, 0.25 };
	sfxActivate		= SoundPickUpWeapon;
	sfxFire		= SoundShieldOn;
};

ItemData AODForceProj
{	
	description		= "Force Field Projector";
	shapeFile		= "repairgun";
	className		= "tool";
	heading			= "bWeapons";
	shadowDetailMask = 4;
	imageType		= ForceProjImage;
	price			= 250;
};

StaticShapeData ForceFieldE
{	shapeFile		= "forcefield_5x5";
	debrisId		= defaultDebrisSmall;
	maxDamage		= 5;
	maxEnergy		= 200;
	visibleToSensor = true;
	isTranslucent	= true;
	description		= "5x5 Force Field";
	shieldShapeName = "shield";
	classname		= "ForceField";
};

function ForceBolt::onAcquire(%this, %player, %target)
{	
	%Vector=GameBase::getMuzzleTransform(%Player);
	%pos=Gamebase::GetPosition(%player);
	%rot=GameBase::GetRotation(%player);
	%rot2=GetWord(%Vector,6)@" "@GetWord(%Vector,7)@" "@GetWord(%Vector,8);
	%newPos=GetLOSOffset(%player,5);
	
	%newitem = newObject("EField",StaticShape,ForceFieldE,true);
	addToSet("MissionCleanup", %newitem);
	GameBase::setTeam(%newitem,%team);
	GameBase::setRotation(%newitem,%rot);
	GameBase::setPosition(%newitem,%Newpos);
	Playsound(ForcefieldOpen,%pos);

	%target=%newitem;
	%player.EField = %newItem;
	%player.repairTarget = %player.EField;
	Player::trigger(%player, $WeaponSlot, true);
}

function ForceBolt::onRelease(%this, %player)
{	
	if($matchStarted) 
	{	deleteobject(%player.Efield);
		%client = Player::getClient(%player);
		Player::trigger(%player, $WeaponSlot, false);
	}
}

function ForceBolt::checkDone(%this, %player)
{	
	%Vector=GameBase::getMuzzleTransform(%Player);
	%pos=Gamebase::GetPosition(%player);
	%rot=GameBase::GetRotation(%player);
	%rot2=GetWord(%Vector,6)@" "@GetWord(%Vector,7)@" "@GetWord(%Vector,8);
	%newPos=GetLOSOffset(%player,4.5);
	GameBase::setRotation(%player.efield,%rot);
	GameBase::setPosition(%player.efield,%Newpos);
}

function GetLOSOffset(%player,%offset)
{	
	%Vector=GameBase::getMuzzleTransform(%Player);
	%pos=Gamebase::GetPosition(%player);
	%rot=GameBase::GetRotation(%player);
	%rot2=GetWord(%Vector,6)@" "@GetWord(%Vector,7)@" "@GetWord(%Vector,8);

	%X1=Getword(%vector,1);
	%Y1=Getword(%vector,2);
	%Z1=Getword(%vector,3);
	
	%X2=Getword(%vector,6);
	%Y2=Getword(%vector,7);
	%Z2=Getword(%vector,8);
	
	%zo1=SIN(%YRot) * %offset;
	%zo2=COS(%XRot) * %offset;
	%l2=COS(%YRot) * %offset;

	// echo(%x1," ",%y1," ",%z1," | ",%x2," ",%y2," ",%z2);
	
	%p1=Vector::getFromRot(%rot,%l2,%zo);
	%NewPos=Vector::Add(%Pos,%p1);
	return(%NewPos);
}

$InvList[AODForceProj] = 1;
$RemoteInvList[AODForceProj] = 1;
$UplinkInvList[AODForceProj] = 1;

$ItemMax[larmor, AODForceProj] = 0;
$ItemMax[lfemale, AODForceProj] = 0;
$ItemMax[marmor, AODForceProj] = 1;
$ItemMax[mfemale, AODForceProj] = 1;
$ItemMax[harmor, AODForceProj] = 1;
$ItemMax[BlastechF, AODForceProj] = 0;
$ItemMax[BlastechM, AODForceProj] = 0;
$ItemMax[MagIonM, AODForceProj] = 0;
$ItemMax[MagIonF, AODForceProj] = 0;
$ItemMax[MECH, AODForceProj] = 1;
$ItemMax[sarmor, AODForceProj] = 0;
$ItemMax[sfemale, AODForceProj] = 0;
$ItemMax[ebarmor, AODForceProj] = 1;
$ItemMax[ebfemale, AODForceProj] = 1;
$ItemMax[mearmor, AODForceProj] = 0;

//-----------------------------------
// Beacon Gun Script - Valya[AAOD]
//-----------------------------------
$InvList[AODBeaconGun]			= 1;
$RemoteInvList[AODBeaconGun]		= 1;
$UplinkInvList[AODBeaconGun]		= 1;		
$AutoUse[AODBeaconGun]			= True;
$WeaponAmmo[AODBeaconGun]		= Beacon;

$ItemMax[larmor,AODBeaconGun]	= 1;
$ItemMax[lfemale,AODBeaconGun]	= 1;
$ItemMax[marmor,AODBeaconGun]	= 0;
$ItemMax[mfemale,AODBeaconGun]	= 0;
$ItemMax[harmor,AODBeaconGun]	= 1;
$ItemMax[BlastechF, AODBeaconGun] = 1;
$ItemMax[BlastechM, AODBeaconGun] = 1;
$ItemMax[MagIonM, AODBeaconGun] = 0;
$ItemMax[MagIonF, AODBeaconGun] = 0;
$ItemMax[MECH, AODBeaconGun] = 1;
$ItemMax[sarmor, AODBeaconGun] = 1;
$ItemMax[sfemale, AODBeaconGun] = 1;
$ItemMax[ebarmor, AODBeaconGun] = 0;
$ItemMax[ebfemale, AODBeaconGun] = 0;
$ItemMax[mearmor, AODBeaconGun] = 1;

ExplosionData AODBeaconGunExp
{	shapeName = "shockwave.dts";	
	soundId=  SoundBeaconExplosion;	
	faceCamera=true;				
	randomSpin = true;		
	hasLight=true;			
	lightRange=9.0;			
	timeZero=0.100;			
	timeOne=0.900;			
	colors[0]={0.5,0.4,0.2};
	colors[1]={1.0,1.0,0.5};
	colors[2]={0.0,1.0,0.0};
	radFactors={0.5,1.0,0.0};
	shiftPosition=False;	
};

RocketData BeaconRocket
{	bulletShapeName		= "sensor_small.dts";
	explosionTag		= AODBeaconGunExp;
	#collideWithOwner	= true;
	#ownerGraceMS		= 750;
	collisionRadius		= 0.0;
	mass				= 1.0;

	damageClass			= 1;    
	damageValue			= 0.10;
	damageType			= $NullDamageType;
	explosionRadius		= 15.0;
	kickBackStrength	= 75.0;
	muzzleVelocity		= 25.0;
	terminalVelocity	= 25.0;
	acceleration		= 1.0;
	totalTime			= 22.0;
	liveTime			= 23.0;
	lightRange			= 5.0;
	lightColor			= { 0.2, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	// rocket specific
	trailType			= 2;                
	trailString			= "rsmoke.dts";
	smokeDist			= 1.5;
	soundId				= SoundJetHeavy;
};

ItemImageData AODBeaconGunImage
{	shapeFile		= "PaintGun";
	mountPoint		= 0;
	mountOffset		= { -0.1, 0, 0 };
	mountRotation	= { 0, -2.75, 0};
	weaponType		= 0;
	reloadTime		= 0.75;
	fireTime		= 1.5;
	minEnergy		= 15;	
	maxEnergy		= 50;	
	ammoType		= Beacon;
	accuFire		= true;
	sfxActivate		= SoundPickUpWeapon;
};

ItemData AODBeaconGun
{	heading				= "bWeapons";
	description			= "Beacon Gun";
	classname			= "Weapon";
	shapeFile			= "PaintGun";
	hudIcon				= "mortar";	
	shadowDetailMask	= 4;
	imageType			= AODBeaconGunImage;	
	price				= 450;				
	showWeaponBar		= true;	
};

function DeployRBeacon(%player)
{	
	%position=$Location;
	%rot=$Rotation;
	%beacon = newObject("Target Beacon", "StaticShape", "DefaultBeacon", true);
	if($traceObj) Echo($Ver,"|Created New Object :",%beacon," Beacon");
	addToSet("MissionCleanup", %beacon);
	GameBase::setTeam(%beacon,GameBase::getTeam(%player));
	GameBase::setRotation(%beacon,%rot);
	GameBase::setPosition(%beacon,%position);
	Gamebase::setMapName(%beacon,"Target Beacon");
	Beacon::onEnabled(%beacon);
}

function AODBeaconGunImage::onFire(%player,%slot)
{	// if($trace) echo( $ver@"|AODBeaconGunImage::onFire");
	%client = GameBase::getOwnerClient(%player);
	%AmmoCount = (Player::getItemCount(%player, $WeaponAmmo[AODBeaconGun]) && Player::getItemCount(%player,Beacon)) ;
	if(%AmmoCount)
	{	%trans = GameBase::getMuzzleTransform(%player);
		%vel = Item::getVelocity(%player);
		if(GameBase::getLOSInfo(%player,250))
		{	%object = getObjectType($los::object);
			if (%object!="Player" && %object !="Flier" && %object !="") // == "SimTerrain" || %object == "InteriorShape" || %object=="StaticShape") 
			{	// Try to stick it straight up or down, otherwise
				// just use the surface normal
				if (Vector::dot($los::normal,"0 0 1") > 0.6) 
				{	%rot = "0 0 0";}
				else 
				{	if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
					{	%rot = "3.14159 0 0";}
					else 
					{	%rot = Vector::getRotation($los::normal);}
				}
				%team = GameBase::getTeam(%player);
				if($TeamItemMax[Beacon] > $TeamItemCount[%team @ Beacon] || $TestCheats) 
				{	%Dist=Vector::getDistance(GameBase::getPosition(%player),$los::position);
					if(%Dist==0)
					{	%tTime=1;}
					else
					{	%tTime=%Dist/25;}

					playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
					Projectile::spawnProjectile("BeaconRocket",%trans,%player,%vel,$los::object);
					playSound(SoundMissileReload, GameBase::getPosition(%player));
					GiveKickBack(%player, 15, 1);
					$Location=$los::position;
					$Rotation=%rot;
					schedule("DeployRBeacon(" @ %player @ " );",%tTime);
					$TeamItemCount[GameBase::getTeam(%beacon) @ "Beacon"]++;
					Player::decItemCount(%player,Beacon);
				}
				else
				Client::sendMessage(%client,0,"Deployable Item limit reached! ~Error_Message.wav");
			}
			else
			Client::sendMessage(%client,0,"** Invalid Target - Unable to attach to Object! ** ~wError_Message.wav");
		}
		else
		Client::sendMessage(%client,0,"** Object Out of Range !! ** ~wError_Message.wav");
	}
	else
	{	if (!Player::getItemCount(%player, $WeaponAmmo[AODBeaconGun]))
	{	Client::sendMessage(%client,0,"** Out of Beacons!! ** ~waccess_denied.wav");}
	else
	{ 	Client::sendMessage(%client,0,"** Out of Beacons!! ** ~waccess_denied.wav");}
	}

}


