//--------------------------------------------------------------------------------------------------------
// Blaster
//--------------------------------------------------------------------------------------------------------

ItemImageData BlasterImage
{
   shapeFile  = "energygun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	reloadTime = 0;
	fireTime = 0.3;
	minEnergy = 5;
	maxEnergy = 6;

	projectileType = BlasterBolt;
	accuFire = true;

	sfxFire = SoundFireBlaster;
	sfxActivate = SoundPickUpWeapon;
};

ItemData Blaster
{
   heading = "bBase Weapons";
	description = "Blaster";
	className = "Weapon";
   shapeFile  = "energygun";
	hudIcon = "blaster";
	shadowDetailMask = 4;
	imageType = BlasterImage;
	price = 85;
	showWeaponBar = true;
};

//=============================================================================================

ItemImageData HyperB1Image 
{ 
	 shapeFile = "energygun"; 
	mountPoint = 0; 
	mountOffset = { -0.65, 0, 0 };
	weaponType = 0;
	minEnergy = 5;
	maxEnergy = 6;
	accuFire = true; 
	reloadTime = 0;
	fireTime = 0.3;
	projectileType = BlasterBolt; 
}; 

ItemData HyperB1
{ 
	description = "Enforcers";
	 className = "Weapon"; 
	shapeFile = "energygun"; 
	hudIcon = "ammopack"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = HyperB1Image; 
	price = 0; 
	showWeaponBar = false; 
	showInventory = false; 
}; 

ItemImageData HyperB2Image 
{
	 shapeFile = "energygun"; 
	mountPoint = 0; 
	weaponType = 0;
	minEnergy = 5;
	maxEnergy = 6;
	accuFire = true; 
	reloadTime = 0;
	fireTime = 0.3;
	projectileType = BlasterBolt; 
}; 

ItemData HyperB2 
{ 
	description = "Enforcers";
	 className = "Weapon"; 
	shapeFile = "energygun"; 
	hudIcon = "ammopack"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = HyperB2Image; 
	price = 0; 
	showWeaponBar = false; 
	showInventory = false; 
};

ItemImageData HyperBImage 
{ 
	shapeFile = "breath"; 
	mountPoint = 3; 
	weaponType = 0; 
	reloadTime = 0;
	minEnergy = 5;
	maxEnergy = 6;
	fireTime = 0.3;
	sfxFire = SoundFireBlaster; 
	sfxActivate = SoundPickUpWeapon; 
}; 

ItemData HyperB
{ 
	description = "Enforcers"; 
	className = "Weapon"; 
	shapeFile = "energygun"; 
	hudIcon = "chain"; 
     heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = HyperBImage; 
	price = 200; 
	showWeaponBar = true;
}; 

function HyperBImage::onFire(%player, %slot) 
{  
	%state1 = Player::getItemState(%player,4);  
	%state2 = Player::getItemState(%player,5);  
	if (%state1 != "Fire" && %state1 != "Reload" && %state2 != "Fire" && %state2 != "Reload") 
	{   
		%client = GameBase::getOwnerClient(%player);   
		if(%client.hd == 0) 
		{    
			%client.hd = 1;    
			Player::trigger(%player,4,true);    
			Player::trigger(%player,4,false);   
		} 
		else 
		{    
			%client.hd = 0;    
			Player::trigger(%player,5,true);    
			Player::trigger(%player,5,false);   
		}  
	} 
} 

function HyperB::onMount(%player,%imageSlot) 
{  
	Player::mountItem(%player,HyperB1,4);  
	Player::mountItem(%player,HyperB2,5); 
} 

function HyperB::onUnmount(%player,%imageSlot) 
{  
	Player::unmountItem(%player,4);  
	Player::unmountItem(%player,5); 
}

$AutoUse[HyperB]			= True;

AddWeapon(HyperB);

$InvList[HyperB] = 1;
$RemoteInvList[HyperB] = 1;

$ItemMax[harmor, HyperB] = 0;
$ItemMax[marmor, HyperB] = 1;
$ItemMax[mfemale, HyperB] = 1;
$ItemMax[larmor, HyperB] = 0;
$ItemMax[lfemale, HyperB] = 0;

ItemData gatlingammo
{
	description = "Quantum Cartridges";
	className = "Ammo";
	shapeFile = "ammo2";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData HChain1Image 
{ 
	 shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountRotation = { 0,1.57, 0 };
	mountOffset = { -1.28, 0, 0 };
	 ammoType = gatlingammo; 
	weaponType = 0; 
	accuFire = true; 
	reloadTime = 0;
	fireTime = 0.25;
	projectileType = SuperBlaster; 
}; 

ItemData HChain1 
{ 
	description = "Heavy Blast Cannon";
	 className = "Weapon"; 
	shapeFile = "mortargun"; 
	hudIcon = "ammopack"; 
	heading = "cEnergy Weapons";
	shadowDetailMask = 4; 
	imageType = HChain1Image; 
	price = 0; 
	showWeaponBar = false; 
	showInventory = false; 
}; 

ItemImageData HChain2Image 
{
	 shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountRotation = { 0,-1.57, 0 };
	mountOffset = { 0, 0, 0 };
	 ammoType = gatlingammo; 
	weaponType = 0; 
	accuFire = true; 
	reloadTime = 0;
	fireTime = 0.25;
	projectileType = SuperBlaster; 
}; 

ItemData HChain2 
{ 
	description = "Heavy Blast Cannon";
	 className = "Weapon"; 
	shapeFile = "mortargun"; 
	hudIcon = "ammopack"; 
	heading = "cEnergy Weapons";
	shadowDetailMask = 4; 
	imageType = HChain2Image; 
	price = 0; 
	showWeaponBar = false; 
	showInventory = false; 
};

ItemImageData HChaingunImage 
{ 
	shapeFile = "breath"; 
	mountPoint = 3; 
	weaponType = 0; 
	ammoType = gatlingammo; 
	reloadTime = 0;
	fireTime = 0.5;
	sfxFire = SoundPlasmaTurretFire; 
	sfxActivate = SoundPickUpWeapon; 
}; 

ItemData HChaingun
{ 
	description = "Heavy Blast Cannon"; 
	className = "Weapon"; 
	shapeFile = "sniper"; 
	hudIcon = "chain"; 
     heading = "bWeapons"; 
	shadowDetailMask = 4; 
	imageType = HChaingunImage; 
	price = 5000; 
	showWeaponBar = true;
}; 

function HChaingunImage::onFire(%player, %slot) 
{  
	%state1 = Player::getItemState(%player,4);  
	%state2 = Player::getItemState(%player,5);  
	if (%state1 != "Fire" && %state1 != "Reload" && %state2 != "Fire" && %state2 != "Reload") 
	{   
		%client = GameBase::getOwnerClient(%player);   
		Player::decItemCount(%player, "gatlingammo", 0.5);   
		%num = Player::getItemCount(%player, "gatlingammo");   
		if(%client.hd == 0) 
		{    
			%client.hd = 1;    
			if(%num == 1)     
			Player::setItemCount(%player, "gatlingammo", 0);    
			else     
			Player::setItemCount(%player, "gatlingammo", %num);    
			Player::trigger(%player,4,true);    
			Player::trigger(%player,4,false);   
		} 
		else 
		{    
			%client.hd = 0;    
			if(%num == 1)     
			Player::setItemCount(%player, "gatlingammo", 0);    
			else     
			Player::setItemCount(%player, "gatlingammo", %num);    
			Player::trigger(%player,5,true);    
			Player::trigger(%player,5,false);   
		}  
	} 
} 

function HChaingun::onMount(%player,%imageSlot) 
{  
	%num = Player::getItemCount(%player, "gatlingammo");  
	Player::setItemCount(%player, "gatlingammo", %num);  
	Player::mountItem(%player,HChain1,4);  
	Player::mountItem(%player,HChain2,5); 
} 

function HChaingun::onUnmount(%player,%imageSlot) 
{  
	Player::unmountItem(%player,4);  
	Player::unmountItem(%player,5); 
}

$AutoUse[HChaingun]			= True;

AddWeapon(hchaingun);

$WeaponAmmo[HChaingun]			= gatlingammo;
$SellAmmo[gatlingammo]			= 300;
$AmmoPackMax[gatlingammo]		= 400;

$InvList[HChaingun] = 1;
$RemoteInvList[HChaingun] = 1;

$InvList[gatlingammo] = 1;
$RemoteInvList[gatlingammo] = 1;

$ItemMax[harmor, HChaingun] = 1;
$ItemMax[marmor, HChaingun] = 0;
$ItemMax[mfemale, HChaingun] = 0;
$ItemMax[larmor, HChaingun] = 0;
$ItemMax[lfemale, HChaingun] = 0;

$ItemMax[harmor, gatlingammo] = 300;
$ItemMax[marmor, gatlingammo] = 0;
$ItemMax[mfemale, gatlingammo] = 0;
$ItemMax[larmor, gatlingammo] = 0;
$ItemMax[lfemale, gatlingammo] = 0;

//=========================================================================
AddWeapon(ptcannon);

ItemImageData PTCImage 
{
	shapeFile = "shotgun";
	mountPoint = 0;

	weaponType = 0; 
	minEnergy = 5;
	maxEnergy = 15;
      projectileType = PTCBolt;
	accuFire = true;
	reloadTime = 0.5;
	fireTime = 0;
	
	sfxFire = SoundPlasmaTurretFire;
	sfxActivate = SoundPickUpWeapon;
};

ItemData PTCannon
{
	description = "Plasma Cannon";
	className = "Weapon";
	shapeFile = "shotgun";
	hudIcon = "blaster";
   heading = "bBase Weapons";
	shadowDetailMask = 4;
	imageType = PTCImage;
	price = 800;
	showWeaponBar = true;
};

$InvList[PTCannon] = 1;
$RemoteInvList[PTCannon] = 1;

$ItemMax[larmor, PTCannon] = 0;
$ItemMax[lfemale, PTCannon] = 0;
$ItemMax[marmor, PTCannon] = 1;
$ItemMax[mfemale, PTCannon] = 1;
$ItemMax[harmor, PTCannon] = 1;

//=========================================================================

ItemImageData MBImage 
{
	shapeFile = "MortarGun";
	mountPoint = 0;

	weaponType = 0; 
	minEnergy = 10;
	maxEnergy = 50;
	accuFire = true;
	reloadTime = 0.25;
	fireTime = 1;
	
	sfxFire = CapturedTower;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDiscReload;
};

function MBImage::onFire(%player, %slot) 
{
	 %playerId = Player::getClient(%player);
			 %client = GameBase::getOwnerClient(%player);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);
			
			#Standard Function: Mitzi Blast Modes

			if (%playerId.Cannon == 0)
			{
				Projectile::spawnProjectile("IonShock3",%trans,%player,%vel);
			}
			else if (%playerId.Cannon == 1)
			{
				Projectile::spawnProjectile("IonShock4",%trans,%player,%vel);
			}
			else if (%playerId.Cannon == "2")
			{
				Projectile::spawnProjectile("IonShock5",%trans,%player,%vel);
			}
			else if (%playerId.Cannon == "3")
			{
				Projectile::spawnProjectile("IonShock6",%trans,%player,%vel);
			}
			else if (%playerId.Cannon == "4")
			{
				Projectile::spawnProjectile("IonShock7",%trans,%player,%vel);
			}

			#Advanced function 1: Mitzi Blast: Force

			else if (%playerId.MBlastForce == "0")
			{
				Projectile::spawnProjectile("MBlast0",%trans,%player,%vel);
			}
			else if (%playerId.MBlastForce == "1")
			{
				Projectile::spawnProjectile("MBlast64",%trans,%player,%vel);
			}
			else if (%playerId.MBlastForce == "2")
			{
				Projectile::spawnProjectile("MBlast128",%trans,%player,%vel);
			}
			else if (%playerId.MBlastForce == "3")
			{
				Projectile::spawnProjectile("MBlast255",%trans,%player,%vel);
			}
			else if (%playerId.MBlastForce == "4")
			{
				Projectile::spawnProjectile("MBlast512",%trans,%player,%vel);
			}
			else if (%playerId.MBlastForce == "5")
			{
				Projectile::spawnProjectile("MBlast768",%trans,%player,%vel);
			}
			else if (%playerId.MBlastForce == "6")
			{
				Projectile::spawnProjectile("MBlast1024",%trans,%player,%vel);
			}
			#Advanced function 2: Mitzi Boost: Force

			else if (%playerId.MBoostForce == "0")
			{
				Projectile::spawnProjectile("MBoost0",%trans,%player,%vel);
			}
			else if (%playerId.MBoostForce == "1")
			{
				Projectile::spawnProjectile("MBoost64",%trans,%player,%vel);
			}
			else if (%playerId.MBoostForce == "2")
			{
				Projectile::spawnProjectile("MBoost128",%trans,%player,%vel);
			}
			else if (%playerId.MBoostForce == "3")
			{
				Projectile::spawnProjectile("MBoost255",%trans,%player,%vel);
			}
			else if (%playerId.MBoostForce == "4")
			{
				Projectile::spawnProjectile("MBoost512",%trans,%player,%vel);
			}
			else if (%playerId.MBoostForce == "5")
			{
				Projectile::spawnProjectile("MBoost768",%trans,%player,%vel);
			}
			else if (%playerId.MBoostForce == "6")
			{
				Projectile::spawnProjectile("MBoost1024",%trans,%player,%vel);
			}

}

ItemData MBCannon
{
	description = "Mitzi Blast Cannon";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "blaster";
   heading = "eCannons";
	shadowDetailMask = 4;
	imageType = MBImage;
	price = 2000;
	showWeaponBar = true;
};

AddWeapon(mbcannon);

$InvList[MBCannon] = 1;
$RemoteInvList[MBCannon] = 1;

$ItemMax[larmor, MBCannon] = 0;
$ItemMax[lfemale, MBCannon] = 0;
$ItemMax[marmor, MBCannon] = 0;
$ItemMax[mfemale, MBCannon] = 0;
$ItemMax[harmor, MBCannon] = 1;

//--------------------------------------------------------------------------------------------------------
// Fusion Cannon
//--------------------------------------------------------------------------------------------------------

ItemImageData FCBS
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 1; // Spinning
	reloadTime = 0;
	spinUpTime = 0.5;
	spinDownTime = 3;
	fireTime = 1.5;

	projectileType = ChargedFusionBolt;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFCBSFire;
	sfxActivate = SoundPickUpWeapon;
	sfxSpinUp = ForceFieldOpen;
	sfxSpinDown = ForceFieldClose;
};

ItemData FusionCannon
{
	description = "Fusion Cannon";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "chain";
   heading = "eCannons";
	shadowDetailMask = 4;
	imageType = FCBS;
	price = 5000;
	showWeaponBar = true;
};

AddWeapon(fusioncannon);

$InvList[FusionCannon] = 1;
$RemoteInvList[FusionCannon] = 1;

$ItemMax[harmor, FusionCannon] = 1;
$ItemMax[marmor, FusionCannon] = 0;
$ItemMax[mfemale, FusionCannon] = 0;
$ItemMax[larmor, FusionCannon] = 0;
$ItemMax[lfemale, FusionCannon] = 0;

//--------------------------------------------------------------------------------------------------------
// Chain Gun
//--------------------------------------------------------------------------------------------------------

ItemData BulletAmmo
{
	description = "Bullet";
	className = "Ammo";
	shapeFile = "ammo1";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData ChaingunImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 1; // Spinning
	reloadTime = 0;
	spinUpTime = 0.5;
	spinDownTime = 3;
	fireTime = 0.2;

	ammoType = BulletAmmo;
	projectileType = ChaingunBullet;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFireChaingun;
	sfxActivate = SoundPickUpWeapon;
	sfxSpinUp = SoundSpinUp;
	sfxSpinDown = SoundSpinDown;
};

ItemData Chaingun
{
	description = "Chaingun";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chain";
   heading = "bBase Weapons";
	shadowDetailMask = 4;
	imageType = ChaingunImage;
	price = 125;
	showWeaponBar = true;
};

//--------------------------------------------------------------------------------------------------------
// Gatling Blaster
//--------------------------------------------------------------------------------------------------------

ItemImageData GatlingBlasterImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 0;
	reloadTime = 0;
	fireTime = 0.1;
	minEnergy = 10;
	maxEnergy = 1;
	projectileType = GatlingBlasterBolt;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFireBlaster;
	sfxActivate = SoundDryFire;
};

ItemData GatB
{
	description = "Gatling Blaster";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chaingun";
   heading = "bBase Weapons";
	shadowDetailMask = 4;
	imageType = GatlingBlasterImage;
	price = 500;
	showWeaponBar = true;
};

AddWeapon(gatb);

$InvList[GatB] = 1;
$RemoteInvList[GatB] = 1;

$ItemMax[larmor, GatB] = 0;
$ItemMax[lfemale, GatB] = 0;
$ItemMax[marmor, GatB] = 1;
$ItemMax[mfemale, GatB] = 1;
$ItemMax[harmor, GatB] = 1;

//--------------------------------------------------------------------------------------------------------
// Plasma Chaingun
//--------------------------------------------------------------------------------------------------------

ItemImageData ChainsmaGunImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 1; // Spinning
	minEnergy = 20;
	maxEnergy = 10;
	reloadTime = 0;
	spinUpTime = 0.75;
	spinDownTime = 4;
	fireTime = 0.2;


	projectileType = Plasmabolt2;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFirePlasma2;
	sfxActivate = SoundPickUpWeapon;
	sfxSpinUp = SoundSpinUp;
	sfxSpinDown = SoundSpinDown;
};

ItemData ChainsmaGun
{
	description = "Plasma Chaingun";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chain";
   heading = "bBase Weapons";
	shadowDetailMask = 4;
	imageType = ChainsmaGunImage;
	price = 600;
	showWeaponBar = true;
};

AddWeapon(ChainsmaGun);

$InvList[ChainsmaGun] = 1;
$RemoteInvList[ChainsmaGun] = 1;

$ItemMax[larmor, ChainsmaGun] = 0;
$ItemMax[lfemale, ChainsmaGun] = 0;
$ItemMax[marmor, ChainsmaGun] = 1;
$ItemMax[mfemale, ChainsmaGun] = 1;
$ItemMax[harmor, ChainsmaGun] = 1;

//--------------------------------------------------------------------------------------------------------
// Gauss Cannon
//--------------------------------------------------------------------------------------------------------

ItemData GaussAmmo
{
	description = "Explosive Bullets";
	className = "Ammo";
	shapeFile = "ammo1";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData GaussGunImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 1; // Spinning
	reloadTime = 0.4;
	spinUpTime = 0.2;
	spinDownTime = 3;
	fireTime = 0.2;

	ammoType = GaussAmmo;
	projectileType = GaussBullet;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFireChaingun;
	sfxActivate = SoundPickUpWeapon;
	sfxSpinUp = SoundSpinUp;
	sfxSpinDown = SoundSpinDown;
};

ItemData Gauss
{
	description = "Eternal Gauss Cannon";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chain";
   heading = "eCannons";
	shadowDetailMask = 4;
	imageType = GaussGunImage;
	price = 950;
	showWeaponBar = true;
};

AddWeapon(Gauss);

$SellAmmo[GaussAmmo]			= 75;
$AmmoPackMax[GaussAmmo]		= 10;

$InvList[Gauss] = 1;
$RemoteInvList[Gauss] = 1;

$InvList[GaussAmmo] = 1;
$RemoteInvList[GaussAmmo] = 1;

$ItemMax[larmor, Gauss] = 0;
$ItemMax[lfemale, Gauss] = 0;
$ItemMax[marmor, Gauss] = 1;
$ItemMax[mfemale, Gauss] = 1;
$ItemMax[harmor, Gauss] = 1;

$ItemMax[larmor, GaussAmmo] = 0;
$ItemMax[lfemale, GaussAmmo] = 0;
$ItemMax[marmor, GaussAmmo] = 75;
$ItemMax[mfemale, GaussAmmo] = 75;
$ItemMax[harmor, GaussAmmo] = 75;

//--------------------------------------------------------------------------------------------------------
// Laser Gatling Gun
//--------------------------------------------------------------------------------------------------------

ItemImageData LaserGatlingImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 0; // Spinning
	minEnergy = 0.5;
	maxEnergy = 0.5;
	projectileType = GatlingLaser;
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.075;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 1, 1, 0.2 };

	sfxFire = SoundFireLaser; 
	sfxActivate = SoundPickUpWeapon;
};

ItemData LaserGatling
{
	description = "Laser Gatling Gun";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chaingun";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = LaserGatlingImage;
	price = 700;
	showWeaponBar = true;
};

AddWeapon(LaserGatling);

$InvList[LaserGatling] = 1;
$RemoteInvList[LaserGatling] = 1;

$ItemMax[larmor, LaserGatling] = 0;
$ItemMax[lfemale, LaserGatling] = 0;
$ItemMax[marmor, LaserGatling] = 1;
$ItemMax[mfemale, LaserGatling] = 1;
$ItemMax[harmor, LaserGatling] = 1;

//--------------------------------------------------------------------------------------------------------
// AlienLaser
//--------------------------------------------------------------------------------------------------------

ItemImageData AlienLaserImage
{
      shapeFile  = "sniper";
	mountPoint = 0;
      mountRotation = { 0, 360.0, 0 };
      weaponType = 0; // Single Shot
	projectileType = AlienRay;
	reloadTime = 0.8;
	fireTime = 0.1;
	minEnergy = 25;
	maxEnergy = 25;
      accuFire = true;
      sfxFire = SoundFireLaser;
	sfxActivate = SoundPickUpWeapon;
};

ItemData AlienLaser
{
      description = "Alien Laser Rifle";
	className = "Weapon";
   shapeFile  = "sniper";
	hudIcon = "blaster";
   heading = "cEnergy Weapons";
      shadowDetailMask = 4;
	imageType = AlienLaserImage;
	price = 750;
	showWeaponBar = true;
};

AddWeapon(AlienLaser);

$InvList[AlienLaser] = 1;
$RemoteInvList[AlienLaser] = 1;

$ItemMax[larmor, AlienLaser] = 1;
$ItemMax[lfemale, AlienLaser] = 1;
$ItemMax[marmor, AlienLaser] = 1;
$ItemMax[mfemale, AlienLaser] = 1;
$ItemMax[harmor, AlienLaser] = 0;

//--------------------------------------------------------------------------------------------------------
// Atomic Disruptor
//--------------------------------------------------------------------------------------------------------

ItemImageData WaveGunImage 
{
  shapeFile = "shotgun";
  mountPoint = 0;
  weaponType = 0;
  minEnergy = 40;
  maxEnergy = 45;
  projectileType = Shock;
  accuFire = true;
  fireTime = 0.9;
  sfxFire = SoundTeleport2;
  sfxActivate = SoundPickUpWeapon;
};

ItemData WaveGun 
{
  description = "Atomic Disruptor";
  className = "Weapon";
  shapeFile = "shotgun";
  hudIcon = "disk";
  heading = "cEnergy Weapons";
  shadowDetailMask = 4;
  imageType = WaveGunImage;
  price = 250;
  showWeaponBar = true;
};

AddWeapon(WaveGun );

$InvList[WaveGun ] = 1;
$RemoteInvList[WaveGun ] = 1;

$ItemMax[larmor, WaveGun ] = 1;
$ItemMax[lfemale, WaveGun ] = 1;
$ItemMax[marmor, WaveGun ] = 1;
$ItemMax[mfemale, WaveGun ] = 1;
$ItemMax[harmor, WaveGun ] = 1;

//--------------------------------------------------------------------------------------------------------
// HyperLaser
//--------------------------------------------------------------------------------------------------------

ItemImageData HyperLaserImage
{
  shapefile = "chaingun";
  mountRotation = { 0.0, 160.0, 0.0 };
  mountpoint = 0;
  weaponType = 0;
  projectileType = HyperLaserBeam;
  accuFire = true;
  minEnergy = 1;
  maxEnergy = 5;
  reloadTime = 0.001;
  lightType = 3;
  lightRadius = 1;
  lightTime = 1;
  lightColor = {1, 0, 0 };
  sfxFire = SoundGeneratorPower;
  sfxActivate = SoundPickUpWeapon;
};

ItemData HyperLaser
{
  description = "ChainGun-Laser";
  className = "Weapon";
  shapeFile = "chaingun";
  hudIcon = "sniper";
  heading = "cEnergy Weapons";
  shadowDetailMask = 4;
  imageType = HyperLaserImage;
  price = 300;
  showWeaponBar = true;
};

AddWeapon(HyperLaser);

$InvList[HyperLaser] = 1;
$RemoteInvList[HyperLaser] = 1;

$ItemMax[larmor, HyperLaser] = 1;
$ItemMax[lfemale, HyperLaser] = 1;
$ItemMax[marmor, HyperLaser] = 1;
$ItemMax[mfemale, HyperLaser] = 1;
$ItemMax[harmor, HyperLaser] = 0;

//--------------------------------------------------------------------------------------------------------
// AutoCannon (ATC)
//--------------------------------------------------------------------------------------------------------

ItemData ATCAmmo
{
	description = "Cannon Shells";
	className = "Ammo";
	shapeFile = "ammo1";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData ATCImage
{
	shapeFile = "chaingun";
	mountPoint = 0;

	weaponType = 1; // Spinning
	reloadTime = 0.3;
	spinUpTime = 1.0;
	spinDownTime = 6;
	fireTime = 0.2;

	ammoType = ATCAmmo;
	projectileType = MiniMissile;
	accuFire = false;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1 };

	sfxFire = SoundFireChaingun;
	sfxActivate = SoundPickUpWeapon;
	sfxSpinUp = SoundSpinUp;
	sfxSpinDown = SoundSpinDown;
};

ItemData ATC
{
	description = "Auto-Cannon";
	className = "Weapon";
	shapeFile = "chaingun";
	hudIcon = "chain";
      heading = "eCannons";
	shadowDetailMask = 4;
	imageType = ATCImage;
	price = 1500;
	showWeaponBar = true;
};

AddWeapon(ATC);

$SellAmmo[ATCAmmo]			= 40;
$AmmoPackMax[ATCAmmo]		= 50;

$InvList[ATC] = 1;
$RemoteInvList[ATC] = 1;

$InvList[ATCAmmo] = 1;
$RemoteInvList[ATCAmmo] = 1;

$ItemMax[larmor, ATC] = 0;
$ItemMax[lfemale, ATC] = 0;
$ItemMax[marmor, ATC] = 1;
$ItemMax[mfemale, ATC] = 1;
$ItemMax[harmor, ATC] = 1;

$ItemMax[larmor, ATCAmmo] = 0;
$ItemMax[lfemale, ATCAmmo] = 0;
$ItemMax[marmor, ATCAmmo] = 40;
$ItemMax[mfemale, ATCAmmo] = 40;
$ItemMax[harmor, ATCAmmo] = 50;


//----------------------------------------------------------------------------
BulletData MiniGunBullet
{
   bulletShapeName  = "bullet.dts";
	explosionTag     = bulletExp0;
	collisionRadius  = 0.0;
	mass             = 2.0;
	damageClass      = 0;
	damageValue      = 0.22;
	damageType       = $SniperDamageType;
	explosionRadius  = 0.1;
	kickBackStrength = 600.0;
	muzzleVelocity   = 5500.0;
	terminalVelocity = 5500.0;
	acceleration     = 500.0;
	totalTime        = 10.0;
	liveTime         = 11.0;
	lightRange       = 10.0;
	lightColor       = { 0.25, 0.25, 1 };
	inheritedVelocityScale = 1.0;
	soundId = SoundJetHeavy;

};

//--------------------------------------
RocketData Raygun_ray
{
   bulletShapeName = "tracer.dts";
   explosionTag    = rocketExp;

   collisionRadius = 0.0;
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.075;
   damageType         = $BulletDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 150.0;

   muzzleVelocity   = 768.0;
   terminalVelocity = 768.0;
   acceleration     = 0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   trailType   = 1;
   trailLength = 0;
   trailWidth  = 0;

   soundId = SoundJetHeavy;
};

addweapon(Minigun);
$MinigunSlot=4; 
$AutoUse[Minigun] = True; 
$SellAmmo[MinigunAmmo] = 100; 
$AmmoPackMax[MinigunAmmo] = 200; 
$AmmoPackItems[10] = MinigunAmmo; 
$WeaponAmmo[Minigun] = MinigunAmmo; 

$InvList[Minigun]=1;	
$InvList[MinigunAmmo]=1;
$RemoteInvList[Minigun]=1;		// Some weapons are not available from remote inventory units
$RemoteInvList[MinigunAmmo]=1;

$ItemMax[lfemale,Minigun]=0;	// The maximum Light Female can carry
$ItemMax[larmor,Minigun]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,Minigun]=1;	// The maximum Medium Female can carry
$ItemMax[marmor,Minigun]=1;	// The maximum Medium Male can carry
$ItemMax[harmor,Minigun]=0;	// The maximum Heavy of either sex can carry

$ItemMax[lfemale,MinigunAmmo]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MinigunAmmo]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MinigunAmmo]=100;	// The maximum Medium Female can carry
$ItemMax[marmor,MinigunAmmo]=100;	// The maximum Medium Male can carry
$ItemMax[harmor,MinigunAmmo]=150;	// The maximum Heavy of either sex can carry

ItemData MinigunAmmo 
{ 
	description = "MiniGun Ammo"; 
	className = "Ammo"; 
	shapeFile = "ammo1"; 
	heading = "xAmmunition"; 
	shadowDetailMask = 4; 
	price = 1; 
}; 

ItemImageData MinigunImage 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountRotation = { 0,1.57, 0 };
	mountOffset = { 0.225, 0, 0 };
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.1; 
	ammoType = MinigunAmmo; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
	sfxActivate = SoundPickupMinigun; 
	//sfxSpinUp = SoundSpinUp; 
	sfxSpinDown = SoundMiniDown; 
}; 

function MinigunImage::onFire(%player, %slot) 
{ 
	%client = GameBase::getOwnerClient(%player); 
	Player::decItemCount(%player,$WeaponAmmo[Minigun],1); 
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 
	Projectile::spawnProjectile("MinigunBullet",%trans,%player,%vel,%player); 
	if(!$MDFiringMinigun[%client]) MDCheckMinigun(%client, %player); 
} 

ItemData Minigun 
{ 
	description = "MiniGun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = MinigunImage; 
	price = 5000; 
	showWeaponBar = true; 
}; 

function Minigun::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, Minigun2, 0); 
		Item::onDrop(%player,%item); 
	} 
} 

function Minigun::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,Minigun2,$MinigunSlot); 
} 

function Minigun::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$MinigunSlot); 
} 

ItemImageData Minigun2Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountRotation = { 0,-1.57, 0 };
	mountOffset = { 0, 0, 0 };
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.1; 
	ammoType = MinigunAmmo; 
	projectileType = MinigunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData Minigun2 
{ 
	description = "MiniGun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = Minigun2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

function MDCheckMinigun(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "Minigun")) 
	{ 
		Player::trigger(%player,$MinigunSlot,true); 
		schedule("MDCheckMinigun(" @ %client @ "," @ %player @ ");",0.05); 
		$MDFiringMinigun[%client] = true; 
	} 
	else 
	{ 
		Player::trigger(%player,$MinigunSlot,false); 
		$MDFiringMinigun[%client] = false; 
	} 
} 

$MMinigunSlotA=4;
$MMinigunSlotB=5;
$MMinigunSlotC=6; 

addweapon(MMinigun);
$AutoUse[MMinigun] = True; 
$SellAmmo[MMinigunAmmo] = 300; 
$AmmoPackMax[MMinigunAmmo] = 400; 
$AmmoPackItems[15] = MMinigunAmmo; 
$WeaponAmmo[MMinigun] = MMinigunAmmo; 

$InvList[MMinigun]=1;	
$InvList[MMinigunAmmo]=1;
//$RemoteInvList[Minigun]=1;		// Some weapons are not available from remote inventory units
$RemoteInvList[MMinigunAmmo]=1;

$ItemMax[lfemale,MMinigun]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MMinigun]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MMinigun]=0;	// The maximum Medium Female can carry
$ItemMax[marmor,MMinigun]=0;	// The maximum Medium Male can carry
$ItemMax[harmor,MMinigun]=1;	// The maximum Heavy of either sex can carry


$ItemMax[lfemale,MMinigunAmmo]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MMinigunAmmo]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MMinigunAmmo]=0;	// The maximum Medium Female can carry
$ItemMax[marmor,MMinigunAmmo]=0;	// The maximum Medium Male can carry
$ItemMax[harmor,MMinigunAmmo]=300;	// The maximum Heavy of either sex can carry

ItemData MMinigunAmmo 
{ 
	description = "MMinigun Ammo"; 
	className = "Ammo"; 
	shapeFile = "ammo1"; 
	heading = "xAmmunition"; 
	shadowDetailMask = 4; 
	price = 1; 
}; 

ItemImageData MMinigunImage 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountOffset = { -1.3051, -0.201, 0.251 }; 
	mountRotation = { 0, 1.501, 0 }; 
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.1; 
	ammoType = MMinigunAmmo; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
	sfxActivate = SoundPickupminigun; 
	//sfxSpinUp = SoundSpinUp; 
	sfxSpinDown = SoundMiniDown; 
}; 

function MMinigunImage::onFire(%player, %slot) 
{ 
	%client = GameBase::getOwnerClient(%player); 
	Player::decItemCount(%player,$WeaponAmmo[MMinigun],1); 
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 
	Projectile::spawnProjectile("MinigunBullet",%trans,%player,%vel,%player); 
	if(!$MDFiringMMinigun[%client]) MDCheckMMinigun(%client, %player); 
} 

ItemData MMinigun 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = MMinigunImage; 
	price = 7500; 
	showWeaponBar = true; 
}; 

function MMinigun::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, MMinigun2, 0); 
		Item::onDrop(%player,%item); 
	}
} 

function MMinigun::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,MMinigun2,$MMinigunSlotA); 
	Player::mountItem(%player,MMinigun3,$MMinigunSlotB); 
	Player::mountItem(%player,MMinigun4,$MMinigunSlotC); 
} 

function MMinigun::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$MMinigunSlotA);
	Player::unmountItem(%player,$MMinigunSlotB);	 
	Player::unmountItem(%player,$MMinigunSlotC);
} 

ItemImageData MMinigun2Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountOffset = { -1.21, -0.351, 0 }; 
	mountRotation = { 0, 1.01, 0}; 
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.1; 
	ammoType = MMinigunAmmo; 
	projectileType = MiniGunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData MMinigun2 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bBase Weapons"; 
	shadowDetailMask = 4; 
	imageType = MMinigun2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

ItemImageData MMinigun3Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0; 
	mountOffset = { 0, -0.351, 0 }; 
	mountRotation = { 0, -1.01, 0 }; 
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.1; 
	ammoType = MMinigunAmmo; 
	projectileType = ChaingunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData MMinigun3 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bBase Weapons"; 
	shadowDetailMask = 4; 
	imageType = MMinigun3Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 
ItemImageData MMinigun4Image 
{ 
	shapeFile = "chaingun"; 
	mountPoint = 0;
	mountOffset = {0.101, -0.201, 0.251 }; 
	mountRotation = { 0, -1.501, 0};  
	weaponType = 1; 
	reloadTime = 0; 
	spinUpTime = 0.1; 
	spinDownTime = 0.1; 
	fireTime = 0.1; 
	ammoType = MMinigunAmmo; 
	projectileType = ChaingunBullet; 
	accuFire = true; 
	lightType = 3; 
	lightRadius = 3; 
	lightTime = 1; 
	lightColor = { 0.6, 1, 1 }; 
	sfxFire = SoundFireChaingun; 
}; 

ItemData MMinigun4 
{ 
	description = "MECHMinigun"; 
	className = "Weapon"; 
	shapeFile = "chaingun"; 
	hudIcon = "chain"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = MMinigun4Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

function MDCheckMMinigun(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "MMinigun")) 
	{ 
		Player::trigger(%player,$MMinigunSlotA,true);
		Player::trigger(%player,$MMinigunSlotB,true);
		Player::trigger(%player,$MMinigunSlotC,true); 
		schedule("MDCheckMMinigun(" @ %client @ "," @ %player @ ");",0.1); 
		$MDFiringMMinigun[%client] = true; 
	} 
	else 
	{ 
		Player::trigger(%player,$MMinigunSlotA,false); 
		Player::trigger(%player,$MMinigunSlotB,false); 
		Player::trigger(%player,$MMinigunSlotC,false); 
		$MDFiringMMinigun[%client] = false; 
	} 
} 

//--------------------------------------------------------------------------------------------------------
// Grenade Launcher
//--------------------------------------------------------------------------------------------------------

ItemData GrenadeAmmo
{
	description = "Grenade Ammo";
	className = "Ammo";
	shapeFile = "grenammo";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData GrenadeLauncherImage
{
	shapeFile = "grenadeL";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = GrenadeAmmo;
	projectileType = GrenadeShell;
	accuFire = false;
	reloadTime = 0.4;
	fireTime = 0.3;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireGrenade;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDryFire;
};

ItemData GrenadeLauncher
{
	description = "Grenade Launcher";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = GrenadeLauncherImage;
	price = 150;
	showWeaponBar = true;
};

//--------------------------------------------------------------------------------------------------------
// Mortar 
//--------------------------------------------------------------------------------------------------------

ItemData MortarAmmo
{
	description = "Mortar Ammo";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "mortarammo";
	shadowDetailMask = 4;
	price = 5;
};

ItemImageData MortarImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = MortarAmmo;
	projectileType = MortarShell;
	accuFire = false;
	reloadTime = 0.3;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

ItemData Mortar
{
	description = "Mortar";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "mortar";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = MortarImage;
	price = 300;
	showWeaponBar = true;
};

//--------------------------------------------------------------------------------------------------------
// Impact-Explosive Mortar 
//--------------------------------------------------------------------------------------------------------

$AutoUse[ImpactMortar]			= True;

AddWeapon(ImpactMortar);

$WeaponAmmo[ImpactMortar]			= ImpactAmmo;
$SellAmmo[ImpactAmmo]			= 20;
$AmmoPackMax[ImpactAmmo]		= 30;

$InvList[ImpactMortar] = 1;
$RemoteInvList[ImpactMortar] = 1;

$InvList[ImpactAmmo] = 1;
$RemoteInvList[ImpactAmmo] = 1;

$ItemMax[harmor, ImpactMortar] = 1;
$ItemMax[harmor, ImpactAmmo] = 20;
$ItemMax[larmor, ImpactMortar] = 0;
$ItemMax[larmor, ImpactAmmo] = 0;
$ItemMax[marmor, ImpactMortar] = 0;
$ItemMax[marmor, ImpactAmmo] = 0;
$ItemMax[lfemale, ImpactMortar] = 0;
$ItemMax[lfemale, ImpactAmmo] = 0;
$ItemMax[mfemale, ImpactMortar] = 0;
$ItemMax[mfemale, ImpactAmmo] = 0;

ItemData ImpactAmmo
{
	description = "IE Mortar Ammo";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "mortarammo";
	shadowDetailMask = 4;
	price = 5;
};

ItemImageData IMortarImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = ImpactAmmo;
	projectileType = ImpactMortarShell;
	accuFire = false;
	reloadTime = 0.3;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

ItemData ImpactMortar
{
	description = "Impact Mortar";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "mortar";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = IMortarImage;
	price = 350;
	showWeaponBar = true;
};

//--------------------------------------------------------------------------------------------------------
// Rubbery Mortar 
//--------------------------------------------------------------------------------------------------------

$AutoUse[RubberMortar]			= True;

AddWeapon(RubberMortar);

$WeaponAmmo[RubberMortar]			= ImpactAmmo;
$SellAmmo[RubberAmmo]			= 15;
$AmmoPackMax[RubberAmmo]		= 60;

$InvList[RubberMortar] = 1;
$RemoteInvList[RubberMortar] = 1;

$InvList[RubberAmmo] = 1;
$RemoteInvList[RubberAmmo] = 1;

$ItemMax[harmor, RubberMortar] = 1;
$ItemMax[harmor, RubberAmmo] = 15;
$ItemMax[larmor, RubberMortar] = 0;
$ItemMax[larmor, RubberAmmo] = 0;
$ItemMax[marmor, RubberMortar] = 0;
$ItemMax[marmor, RubberAmmo] = 0;
$ItemMax[lfemale, RubberMortar] = 0;
$ItemMax[lfemale, RubberAmmo] = 0;
$ItemMax[mfemale, RubberMortar] = 0;
$ItemMax[mfemale, RubberAmmo] = 0;

ItemData RubberAmmo
{
	description = "R Mortar Ammo";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "mortarammo";
	shadowDetailMask = 4;
	price = 5;
};

ItemImageData RMortarImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = RubberAmmo;
	projectileType = RubberMortarShell;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

ItemData RubberMortar
{
	description = "Rubbery Mortar";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "mortar";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = RMortarImage;
	price = 375;
	showWeaponBar = true;
};

//----------------------------------------------------------------------------
// EMP Grenade Launcher
//----------------------------------------------------------------------------

ItemData EMPGrenadeAmmo
{
	description = "EMP Mortars";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "mortarammo";
	shadowDetailMask = 4;
	price = 50;
};

ItemImageData EMPGrenadeLauncherImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = EMPGrenadeAmmo;
	projectileType = EMPGrenadeShell;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.25, 0.25, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundLaserIdle;
};

ItemData EMPGrenadeLauncher
{
	description = "EMP Mortar Launcher";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "sensorjamerpack";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = EMPGrenadeLauncherImage;
	price = 475;
	showWeaponBar = true;
};

AddWeapon(EMPGrenadeLauncher);

//--------------------------------------------------------------------------------------------------------
// Mine Launcher
//--------------------------------------------------------------------------------------------------------

ItemData MultiMineAmmo
{
	description = "Spawning Mines";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "mortarammo";
	shadowDetailMask = 4;
	price = 5;
};

ItemImageData MineLauncherImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	projectileType = Deploybox;
	accuFire = true;
	ammoType = MultiMineAmmo;
	reloadTime = 0.5;
	fireTime = 1.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 1, 1, 0.2 };

	sfxFire = SoundFireMortar; 
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundLaserIdle;
};

ItemData MineLauncher
{
	description = "Mine Launcher";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "plasma";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = MineLauncherImage;
	price = 1200;
	showWeaponBar = true;
};

AddWeapon(minelauncher);

$AutoUse[MineLauncher]			= True;

$WeaponAmmo[MineLauncher]			= MultiMineAmmo;
$SellAmmo[MultiMineAmmo]			= 50;
$AmmoPackMax[MultiMineAmmo]		= 60;

$InvList[MineLauncher] = 1;
$RemoteInvList[MineLauncher] = 1;

$InvList[MultiMineAmmo] = 1;
$RemoteInvList[MultiMineAmmo] = 1;

$ItemMax[harmor, MineLauncher] = 1;
$ItemMax[harmor, MultiMineAmmo] = 50;
$ItemMax[larmor, MineLauncher] = 0;
$ItemMax[larmor, MultiMineAmmo] = 0;
$ItemMax[marmor, MineLauncher] = 1;
$ItemMax[marmor, MultiMineAmmo] = 1;
$ItemMax[lfemale, MineLauncher] = 0;
$ItemMax[lfemale, MultiMineAmmo] = 0;
$ItemMax[mfemale, MineLauncher] = 20;
$ItemMax[mfemale, MultiMineAmmo] = 20;

//--------------------------------------------------------------------------------------------------------
// SpreadFire
//--------------------------------------------------------------------------------------------------------

ItemImageData ImpImage

{
	shapeFile = "mortargun";
	mountPoint = 0;
	mountOffset = { 0.0, 0.0, -0.2 };
	mountRotation = { 0, 0, 0 };	
	weaponType = 0;
	minEnergy = 25;
	maxEnergy = 25;
	projectileType = ImplosionShell;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 1.5;
	lightType = 3;
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
};

ItemData ImpGun
{
	description = "SpreadFire";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "mortar";
    heading = "cEnergy Weapons";
	shadowDetailMask = 4;
        imageType = ImpImage;
	price = 7500;
	showWeaponBar = true;
};

addweapon(impgun);

$InvList[ImpGun] = 1;
$RemoteInvList[ImpGun] = 1;

$ItemMax[marmor, ImpGun] = 1;
$ItemMax[mfemale, ImpGun] = 1;
$ItemMax[larmor, ImpGun] = 0;
$ItemMax[lfemale, ImpGun] = 0;
$ItemMax[harmor, ImpGun] = 0;

//--------------------------------------------------------------------------------------------------------
// Starburst
//--------------------------------------------------------------------------------------------------------

ItemImageData Imp2Image

{
	shapeFile = "mortargun";
	mountPoint = 0;
	mountOffset = { 0.0, 0.0, -0.2 };
	mountRotation = { 0, 0, 0 };	
	weaponType = 0;
	minEnergy = 50;
	maxEnergy = 50;
	projectileType = ImplosionShell2;
	accuFire = false;
	reloadTime = 0.75;
	fireTime = 1.5;
	lightType = 3;
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
};

ItemData ImpGun2
{
	description = "Starburst";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "mortar";
    heading = "fLaunchers";
	shadowDetailMask = 4;
        imageType = Imp2Image;
	price = 15200;
	showWeaponBar = true;
};

addweapon(impgun2);

$InvList[ImpGun2] = 1;
$RemoteInvList[ImpGun2] = 1;

$ItemMax[marmor, ImpGun2] = 1;
$ItemMax[mfemale, ImpGun2] = 1;
$ItemMax[larmor, ImpGun2] = 0;
$ItemMax[lfemale, ImpGun2] = 0;
$ItemMax[harmor, ImpGun2] = 1;

//--------------------------------------------------------------------------------------------------------
// Baby-Nuke Launcher
//--------------------------------------------------------------------------------------------------------

ItemImageData BaybNookImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	projectileType = ClusterBomb;
	accuFire = true;
//	ammoType = BabyNukeAmmo;
	reloadTime = 0.4;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 1, 1, 0.2 };

	sfxFire = SoundFireMortar; 
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

ItemData BabyNukeMortar
{
	description = "Baby Nuke Launcher";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "plasma";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = BayBNookImage;
	price = 32000;
	showWeaponBar = true;
};

$AutoUse[BabyNukeMortar]			= True;

AddWeapon(babynukemortar);

$InvList[BabyNukeMortar] = 1;
$RemoteInvList[BabyNukeMortar] = 1;

$ItemMax[harmor, BabyNukeMortar] = 1;
$ItemMax[larmor, BabyNukeMortar] = 0;
$ItemMax[lfemale, BabyNukeMortar] = 0;
$ItemMax[marmor, BabyNukeMortar] = 0;
$ItemMax[mfemale, BabyNukeMortar] = 0;

//--------------------------------------------------------------------------------------------------------
// Disc Launcher
//--------------------------------------------------------------------------------------------------------

ItemData DiscAmmo
{
	description = "Disc";
	className = "Ammo";
	shapeFile = "discammo";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData DiscLauncherImage
{
	shapeFile = "disc";
	mountPoint = 0;

	weaponType = 3; // DiscLauncher
	ammoType = DiscAmmo;
	accuFire = true;
	reloadTime = 0.4;
	fireTime = 0.4;
	spinUpTime = 0.25;

      sfxFire = SoundFireDisc;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDiscReload;
	sfxReady = SoundDiscSpin;
};

function DiscLauncherImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[DiscLauncher]);
	 %armor = Player::getArmor(%player);

		 if(%Ammo) 
		 {
			 %client = GameBase::getOwnerClient(%player);
			 Player::decItemCount(%player,$WeaponAmmo[DiscLauncher],1);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);
		
			 if(GameBase::getLOSInfo(%player,1024))
			 {
				 %object = getObjectType($los::object);
				 %targetId = GameBase::getOwnerClient($los::object);
	
				 if(%object == "Player" || %object == "Flier" || %object == "Turret" || %object == "StaticShape") 
				 {			 
					%armor = Player::getArmor(%object);
						SendLockWarning(%TargetCl,0);
						Client::sendMessage(%client,0,"~wmine_act.wav");
						Projectile::spawnProjectile("DiscShellTracker",%trans,%player,%vel,$los::object);
				 }
				 else
				 {
					 Projectile::spawnProjectile("DiscShell",%trans,%player,%vel,%player);
				 }
		 	}
			else
			{
				Projectile::spawnProjectile("DiscShell",%trans,%player,%vel,%player);
			}
		}
		else
			Client::sendMessage(Player::getClient(%player), 0,"You have no Ammo for the Seeking Disc Launcher");
}

ItemData DiscLauncher
{
	description = "Flaming Disk";
	className = "Weapon";
	shapeFile = "disc";
	hudIcon = "disk";
   heading = "bBase Weapons";
	shadowDetailMask = 4;
	imageType = DiscLauncherImage;
	price = 150;
	showWeaponBar = true;
};

//==============================================================================================
$AutoUse[HDiscLauncher]			= True;

AddWeapon(hdisclauncher);

$WeaponAmmo[HDiscLauncher]			= DualDiscs;
$SellAmmo[DualDiscs]			= 20;
$AmmoPackMax[DualDiscs]		= 30;

$InvList[HDiscLauncher] = 1;
$RemoteInvList[HDiscLauncher] = 1;

$InvList[DualDiscs] = 1;
$RemoteInvList[DualDiscs] = 1;

$ItemMax[harmor, HDiscLauncher] = 1;
$ItemMax[marmor, HDiscLauncher] = 1;
$ItemMax[mfemale, HDiscLauncher] = 1;
$ItemMax[larmor, HDiscLauncher] = 0;
$ItemMax[lfemale, HDiscLauncher] = 0;

$ItemMax[harmor, DualDiscs] = 30;
$ItemMax[marmor, DualDiscs] = 20;
$ItemMax[mfemale, DualDiscs] = 20;
$ItemMax[larmor, DualDiscs] = 0;
$ItemMax[lfemale, DualDiscs] = 0;

ItemData DualDiscs
{
	description = "Dual Discs";
	className = "Ammo";
	shapeFile = "discammo";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData HDisc1Image 
{ 
	shapeFile = "disc"; 
	mountPoint = 0; 
	mountRotation = { 0,-1.57, 0 }; 
	mountOffset = { 0.1, 0, 0 };
	ammoType = DualDiscs; 
	weaponType = 3; 
	accuFire = true; 
	reloadTime = 0.6;
	fireTime = 0.5;
	spinUpTime = 0.25;
      projectileType = DiscShell;
}; 

ItemData HDisc1 
{ 
	description = "Flaming DualDiscs";
	 className = "Weapon"; 
	shapeFile = "disc"; 
	hudIcon = "disk"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = HDisc1Image; 
	price = 0; 
	showWeaponBar = false; 
	showInventory = false; 
}; 

ItemImageData HDisc2Image 
{
	 shapeFile = "disc"; 
	mountPoint = 0; 
	mountRotation = { 0,1.57, 0 };
	mountOffset = { 0.03, 0, 0 };
	 ammoType = DualDiscs; 
	weaponType = 3; 
	accuFire = true; 

	reloadTime = 0.5;
	fireTime = 0.5;
	spinUpTime = 0.25;
	projectileType = DiscShell; 

}; 

ItemData HDisc2 
{ 
	description = "Flaming DualDiscs";
	 className = "Weapon"; 
	shapeFile = "disc"; 
	hudIcon = "disk"; 
	heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = HDisc2Image; 
	price = 0; 
	showWeaponBar = false; 
	showInventory = false; 
};

ItemImageData HDiscLauncherImage 
{ 
	shapeFile = "breath"; 
	mountPoint = 3; 
	weaponType = 3; 
	ammoType = DualDiscs; 
	accuFire = true; 
	reloadTime = 0.5;
	fireTime = 0.5;
	spinUpTime = 0.25;
      sfxFire = SoundFireDisc; 
	sfxActivate = SoundPickUpWeapon; 
	sfxReload = SoundDiscReload; 
	sfxReady = SoundDiscSpin; 
}; 

ItemData HDiscLauncher 
{ 
	description = "Flaming DualDiscs"; 
	className = "Weapon"; 
	shapeFile = "disc"; 
	hudIcon = "disk"; 
     heading = "bBase Weapons";
	shadowDetailMask = 4; 
	imageType = HDiscLauncherImage; 
	price = 2500; 
	showWeaponBar = true; 
}; 

function HDiscLauncherImage::onFire(%player, %slot) 
{  
	%state1 = Player::getItemState(%player,6);  
	%state2 = Player::getItemState(%player,7);  
	if (%state1 != "Fire" && %state1 != "Reload" && %state2 != "Fire" && %state2 != "Reload") 
	{   
		%client = GameBase::getOwnerClient(%player);   
		Player::decItemCount(%player, "DualDiscs", 0.5);   
		%num = Player::getItemCount(%player, "DualDiscs");   
		if(%client.hd == 0) 
		{    
			%client.hd = 1;    
			if(%num == 1)     
			Player::setItemCount(%player, "DualDiscs", 0);    
			else     
			Player::setItemCount(%player, "DualDiscs", %num);    
			Player::trigger(%player,6,true);    
			Player::trigger(%player,6,false);   
		} 
		else 
		{    
			%client.hd = 0;    
			if(%num == 1)     
			Player::setItemCount(%player, "DualDiscs", 0);    
			else     
			Player::setItemCount(%player, "DualDiscs", %num);    
			Player::trigger(%player,7,true);    
			Player::trigger(%player,7,false);   
		}  
	} 
} 

function HDiscLauncher::onMount(%player,%imageSlot) 
{  
	%num = Player::getItemCount(%player, "DualDiscs");  
	Player::setItemCount(%player, "DualDiscs", %num);  
	Player::mountItem(%player,HDisc1,6);  
	Player::mountItem(%player,HDisc2,7); 
} 

function HDiscLauncher::onUnmount(%player,%imageSlot) 
{  
	Player::unmountItem(%player,6);  
	Player::unmountItem(%player,7); 
}

//---------------------------------------
// Missile Launcher Script by Valya[AAOD]
//---------------------------------------

AddWeapon(aodstinger);
$InvList[AODStinger]			= 1;	
$RemoteInvList[AODStinger]		= 1;
$AutoUse[AODStinger]			= True;
$WeaponAmmo[AODStinger]			= MissileAmmo;
$InvList[MissileAmmo]			= 1;
$RemoteInvList[MissileAmmo]		= 1;
$SellAmmo[MissileAmmo]			= 5;

$ItemMax[larmor,AODStinger]		= 1;
$ItemMax[lfemale,AODStinger]	= 1;
$ItemMax[marmor,AODStinger]		= 1;
$ItemMax[mfemale,AODStinger]	= 1;
$ItemMax[harmor,AODStinger]		= 1;

$ItemMax[larmor,MissileAmmo]	=50;
$ItemMax[lfemale,MissileAmmo]	=50;
$ItemMax[marmor,MissileAmmo]	=100;
$ItemMax[mfemale,MissileAmmo]	=100;
$ItemMax[harmor,MissileAmmo]	=150;

ExplosionData AODStingerExp
{	shapeName = "shockwave.DTS";
	soundId=  RocketExplosion;	
	faceCamera=true;			
	randomSpin = true;			
	hasLight=true;				
	lightRange=8.0;				
	timeZero=0.100;				
	timeOne=0.900;				
	colors[0]={0.0,0.0,0.0};	
	colors[1]={1.0,1.0,0.5};	
	colors[2]={0.0,1.0,0.0};	
	radFactors={0.0,1.0,0.0};	
	shiftPosition=False;		
};

SeekingMissileData AAODM1
{	bulletShapeName  = "Rocket.dts";
	explosionTag     = AODStingerExp;
	collisionRadius  = 0.0;
	mass             = 0.5;
	damageClass      = 1;       
	damageValue      = 0.65;
	damageType       = $MissileDamageType;
	explosionRadius  = 8.5;
	kickBackStrength = 125.0;
	muzzleVelocity   = 50.0;
	terminalVelocity = 100.0;
	acceleration     = 1.0;
	totalTime        = 8.0;
	liveTime         = 9.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	// Missile specific
	trailType		= 2;      
	trailString		= "mortartrail.dts";
	smokeDist		= 2;
	soundId			= SoundJetHeavy;
	seekingTurningRadius    = 2.5;
};

SeekingMissileData AAODM2
{	bulletShapeName  = "Rocket.dts";
	explosionTag     = AODStingerExp;
	collisionRadius  = 0.0;
	mass             = 1.0;
	damageClass      = 1;       
	damageValue      = 0.50;
	damageType       = $MissileDamageType;
	explosionRadius  = 7.5;
	kickBackStrength = 175.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 350.0;
	acceleration     = 5.0;
	totalTime        = 6.0;
	liveTime         = 7.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	// Missile specific
	trailType		= 2;                
	trailString		= "rsmoke.dts";
	smokeDist		= 20;
	soundId			= SoundJetHeavy;
};

RocketData AAODRocket
{	bulletShapeName  = "rocket.dts";
	explosionTag     = AODStingerExp;
	collisionRadius  = 0.0;
	mass             = 2.0;
	damageClass      = 1;
	damageValue      = 0.65;
	damageType       = $MissileDamageType;
	explosionRadius  = 9.5;
	kickBackStrength = 175.0;
	muzzleVelocity   = 150.0;
	terminalVelocity = 160.0;
	acceleration     = 5.0;
	totalTime        = 6.0;
	liveTime         = 7.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	// rocket specific
	trailType   = 2;                
	trailString = "rsmoke.dts";
	smokeDist   = 20;
	soundId = SoundJetHeavy;
};


ItemData MissileAmmo
{	description = "Std Missile Ammo";
	classname = "Ammo";
	shapeFile = "mortarammo";		
	heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 50;
};

//***************************************************
// Item Image Definitions
//***************************************************

ItemImageData AODStingerImage
{	shapeFile		= "grenadeL";
	mountPoint		= 0;		
	mountOffset		= { -0.1, 0, 0 };
	mountRotation	= { 0, -2.00, 0};
	weaponType		= 0; 	
	reloadTime		= 1.5;	
	fireTime		= 0.1;	
	minEnergy		= 5;	
	maxEnergy		= 6;	
	ammoType		= MissileAmmo;
	accuFire		= true;	
	sfxFire			= SoundPickUpBackpack;
	sfxActivate		= SoundPickUpWeapon;
	sfxReload		= SoundMissileReload;
	sfxReady		= SoundMissileIdle;
};

ItemData AODStinger
{	heading = "fLaunchers";
	description		= "Missile Launcher";
	classname		= "Weapon";
	shapeFile		= "GrenadeL";
	hudIcon			= "mortar";
	shadowDetailMask = 4;
	imageType		= AODStingerImage;
	price			= 350;
	showWeaponBar	= true;
};

function AODStingerImage::onFire(%player,%slot)
{	
	%AmmoCount = Player::getItemCount(%player, $WeaponAmmo[AODStinger]);
	if(%AmmoCount)
	{	
		%client = GameBase::getOwnerClient(%player);
		%trans = GameBase::getMuzzleTransform(%player);
		%vel = Item::getVelocity(%player);
		%pack=Player::getMountedItem(%player,$BackpackSlot);
		if (%pack=="TargPack") 
		{	
			GameBase::getLOSInfo(%player,1024);
			%tpos=($los::position);
			%target=AquireTarget(%player,0,%tpos);
			if(%target)
			{	
				%targetcl=Player::GetClient(%target);	 
				%jam=CheckTargetJamming(%target);
				if(%jam==1)
				{	
					Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
					playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
					Projectile::spawnProjectile("AAODRocket",%trans,%player,%vel,$los::object);
					GiveKickBack(%player, 125, 1);
				}
				else if(%jam==2)
				{	
					%tpos=GameBase::getPosition(%player);
					%target=AquireTarget(%player,2,%tpos);
					if(%target)
					{	
						Projectile::spawnProjectile("AAODM1",%trans,%player,%vel,%target);
						Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
						%name = Client::getName(%target);
						SendLockWarning(%TargetCl,2);
						Client::sendMessage(%client,0,"** UNKNOWN!! Lock Aquired - " @ %name @ "~wmine_act.wav");
						playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
						GiveKickBack(%player, 125, 1);
					}
				}
				else
				{	
					Projectile::spawnProjectile("AAODM1",%trans,%player,%vel,%target);
					Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
					%name = Client::getName(%target);
					SendLockWarning(%TargetCl,1);
					Client::sendMessage(%client,0,"** Image Lock Aquired - " @ %name @ "~wmine_act.wav");
					playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
					GiveKickBack(%player, 125, 1);
				}
			}
			else
			{	
				Client::sendMessage(%client,0,"** No Image Lock (Alternate Scan Engaged)- " @ %name @ "~wmine_act.wav");
				%tpos=GameBase::getPosition(%player);
				%target=AquireTarget(%player,1,%tpos);
				if(%target)
				{	
					%TargetCl=Player::GetClient(%target);	 
					%jam=CheckTargetJamming(%target);
					if(%jam==1)
					{	
						Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
						playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
						Projectile::spawnProjectile("AAODRocket",%trans,%player,%vel,$los::object);
						GiveKickBack(%player, 125, 1);
					}
					else if(%jam==2)
					{	
						%tpos=GameBase::getPosition(%player);
						%target=AquireTarget(%player,2,%tpos);
						if(%target)
						{	
							Projectile::spawnProjectile("AAODM1",%trans,%player,%vel,%target);
							Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
							%name = Client::getName(%target);
							SendLockWarning(%TargetCl,2);
							Client::sendMessage(%client,0,"** UNKNOWN!! Lock Aquired - " @ %name @ "~wmine_act.wav");
							playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
							GiveKickBack(%player, 125, 1);
						}
					}
					else
					{	
						Projectile::spawnProjectile("AAODM1",%trans,%player,%vel,%target);
						Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
						%name = Client::getName(%target);
						SendLockWarning(%TargetCl,2);
						Client::sendMessage(%client,0,"** Sensor Lock Aquired - " @ %name @ "~wmine_act.wav");
						playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
						GiveKickBack(%player, 125, 1);
					}
				}
				else
				{	
					Client::sendMessage(%client,0,"** NO Valid Target Firing Unprogrammed Missile ** " @ %name @ "~wmine_act.wav");
					Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
					playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
					Projectile::spawnProjectile("AAODRocket",%trans,%player,%vel,$los::object);
					GiveKickBack(%player, 125, 1);
				}
			}
			
		}
		else
		{		
			if(GameBase::getLOSInfo(%player,1024))
			{	
				%object = getObjectType($los::object);
				%targetId = GameBase::getOwnerClient($los::object);
				if(%object == "Player" || %object == "Flier")
				{	
					Projectile::spawnProjectile("AAODM2",%trans,%player,%vel,$los::object);
					Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
					%name = Client::getName(%targetId);
					SendLockWarning(%targetId,0);
					Client::sendMessage(%client,0,"** LOS Lock Aquired - " @ %name @ "~wmine_act.wav");
					playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
					GiveKickBack(%player, 125, 1);
				}
				else
				{	
					Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
					playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
					Projectile::spawnProjectile("AAODRocket",%trans,%player,%vel,$los::object);
					GiveKickBack(%player, 125, 1);
				}
			}
			else
			{	
				Player::decItemCount(%player,$WeaponAmmo[AODStinger],1);
				playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
				Projectile::spawnProjectile("AAODRocket",%trans,%player,%vel,$los::object);
				GiveKickBack(%player, 125, 1);
			}
		}
	}
	else
		Client::sendMessage(%client,0,"** Out of Ammo!! ** ~waccess_denied.wav");
}

//*****************************
// End of Missile Launcher Def
//*****************************

//--------------------------------------------------------------------------------------------------------
// Rocket Propelled Grenade (RPG)
//--------------------------------------------------------------------------------------------------------

ItemImageData RPGImage
{
	shapeFile = "grenadeL";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = GrenadeAmmo;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 0.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundMissileTurretFire;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDryFire;
};

function RPGImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[GrenadeLauncher]);
	 %armor = Player::getArmor(%player);

		 if(%Ammo) 
		 {
			 %client = GameBase::getOwnerClient(%player);
			 Player::decItemCount(%player,$WeaponAmmo[GrenadeLauncher],1);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);
		
			 if(GameBase::getLOSInfo(%player,1024))
			 {
				 %object = getObjectType($los::object);
				 %targetId = GameBase::getOwnerClient($los::object);
	
				 if(%object == "Player" || %object == "Flier" || %object == "Turret" || %object == "StaticShape") 
				 {			 
					 %object = getObjectType($los::object);
					 %targetId = GameBase::getOwnerClient($los::object);
					%armor = Player::getArmor(%object);
					%name = Client::getName(%targetId);
					SendLockWarning(%targetId,0);
					if(%name ="")
						%name=getObjectType($los::object);
					Client::sendMessage(%client,0,"~wmine_act.wav");
					Projectile::spawnProjectile("SeekingRPG",%trans,%player,%vel,$los::object);
				 }
				 else
				 {
					 Projectile::spawnProjectile("RPG",%trans,%player,%vel,%player);
				 }
		 	}
			else
			{
				Projectile::spawnProjectile("RPG",%trans,%player,%vel,%player);
			}
		}
		else
			Client::sendMessage(Player::getClient(%player), 0,"You have no Ammo for the RPG");
	} //=== End standard missile fire.


ItemData RPGLauncher
{
	description = "RPG";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = RPGImage;
	price = 400;
	showWeaponBar = true;
};

$AutoUse[RPGLauncher]			= True;

AddWeapon(rpglauncher);

$InvList[RPGLauncher] = 1;
$RemoteInvList[RPGLauncher] = 1;

$ItemMax[larmor, RPGLauncher] = 1;
$ItemMax[lfemale, RPGLauncher] = 1;
$ItemMax[marmor, RPGLauncher] = 1;
$ItemMax[mfemale, RPGLauncher] = 1;
$ItemMax[harmor, RPGLauncher] = 1;

$MrpgSlotA=4;
$MrpgSlotB=5;
$MrpgSlotC=6; 

$AutoUse[MrpgLauncher] = True; 
$SellAmmo[MrpgAmmo] = 100; 
$AmmoPackMax[MrpgAmmo] = 150; 
$AmmoPackItems[15] = MrpgAmmo; 
$WeaponAmmo[MrpgLuancher] = MrpgAmmo; 

$InvList[MrpgLauncher]=1;	
$InvList[MrpgAmmo]=1;
$RemoteInvList[MrpgAmmo]=1;

$ItemMax[lfemale,MrpgLauncher]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MrpgLauncher]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MrpgLauncher]=0;	// The maximum Medium Female can carry
$ItemMax[marmor,MrpgLauncher]=0;	// The maximum Medium Male can carry
$ItemMax[harmor,MrpgLauncher]=1;	// The maximum Heavy of either sex can carry

$ItemMax[lfemale,MrpgAmmo]=0;	// The maximum Light Female can carry
$ItemMax[larmor,MrpgAmmo]=0;	// The maximum Light Male can carry
$ItemMax[mfemale,MrpgAmmo]=0;	// The maximum Medium Female can carry
$ItemMax[marmor,MrpgAmmo]=0;	// The maximum Medium Male can carry
$ItemMax[harmor,MrpgAmmo]=100;	// The maximum Heavy of either sex can carry

ItemData MrpgAmmo 
{ 
	description = "RPGs"; 
	className = "Ammo"; 
	shapeFile = "ammo1"; 
	heading = "xAmmunition"; 
	shadowDetailMask = 4; 
	price = 1; 
}; 

ItemImageData MrpgLauncherImage 
{ 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { -1.305, -0.20, 0.25 }; 
	mountRotation = { 0, 1.50, 0 }; 
	weaponType = 0; 
	reloadTime = 3.5; 
	fireTime = 0.2;
	minEnergy	= 5;	
	maxEnergy	= 6;
	ammoType = MrpgAmmo; 
	accuFire = true; 
	sfxFire = SoundMissileTurretFire; 
	sfxActivate = SoundPickupminigun; 
	sfxReload = SoundSpinUp; 
	sfxReady = SoundMiniDown; 
}; 

function MrpgLauncherImage::onFire(%player, %slot) 
{ 
	%client = GameBase::getOwnerClient(%player); 
	Player::decItemCount(%player,Mrpgammo,1); 
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 
	Projectile::spawnProjectile("RPG",%trans,%player,%vel,%player); 
	if(!$MDFiringMrpgLauncher[%client]) MDCheckMrpgLauncher(%client, %player); 
} 

addweapon(mrpgLauncher);

ItemData MrpgLauncher 
{ 
	description = "MECHRPG"; 
	className = "Weapon"; 
	shapeFile = "grenadeL"; 
	mountOffset = { -1.1, 0.02, 0.4 }; 
	mountRotation = { 0, -1.1, 0}; 
	hudIcon = "chain"; 
	heading = "fLaunchers"; 
	shadowDetailMask = 4; 
	imageType = MrpgLauncherImage; 
	price = 550; 
	showWeaponBar = true; 
}; 

function MrpgLauncher::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, MrpgLauncher2, 0); 
		Item::onDrop(%player,%item); 
	}
} 

function MrpgLauncher::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,MrpgLauncher2,$MrpgSlotA); 
	Player::mountItem(%player,MrpgLauncher3,$MrpgSlotB); 
	Player::mountItem(%player,MrpgLauncher4,$MrpgSlotC); 
} 

function MrpgLauncher::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$MrpgSlotA);
	Player::unmountItem(%player,$MrpgSlotB);	 
	Player::unmountItem(%player,$MrpgSlotC);
} 

ItemImageData MrpgLauncher2Image 
{ 
	ammoType = MrpgAmmo; 
	projectileType = RPG; 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { -1.2, -0.35, 0 }; 
	mountRotation = { 0, 1.0, 0}; 
	weaponType = 0; 
	reloadTime = 2.8; 
	accuFire = false; 
	sfxFire = SoundMissileTurretFire; 
}; 

ItemData MrpgLauncher2 
{ 
	description = "MECHRPG"; 
	className = "Weapon"; 
	shapeFile = "grenadeL"; 
	hudIcon = "chain"; 
	heading = "fLaunchers"; 
	shadowDetailMask = 4; 
	imageType = MrpgLauncher2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

ItemImageData MrpgLauncher3Image 
{ 
	ammoType = MrpgAmmo; 
	projectileType = RPG; 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { 0, -0.35, 0 }; 
	mountRotation = { 0, -1.0, 0 }; 
	weaponType = 0; 
	reloadTime = 2.8; 
	accuFire = false; 
	sfxFire = SoundMissileTurretFire; 
}; 

ItemData MrpgLauncher3 
{ 
	description = "MECHRPG"; 
	className = "Weapon"; 
	shapeFile = "grenadeL"; 
	hudIcon = "chain"; 
	heading = "fLaunchers"; 
	shadowDetailMask = 4; 
	imageType = MrpgLauncher3Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
};
 
ItemImageData MrpgLauncher4Image 
{ 
	ammoType = MrpgAmmo; 
	projectileType = RPG; 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = {0.10, -0.20, 0.25 }; 
	mountRotation = { 0, -1.50, 0}; 
	weaponType = 0; 
	reloadTime = 2.8; 
	accuFire = false; 
	sfxFire = SoundMissileTurretFire; 
	fireTime = 0.1;
}; 

ItemData MrpgLauncher4 
{ 
	description = "MECHRPG"; 
	className = "Weapon"; 
	shapeFile = "grenadeL"; 
	hudIcon = "chain"; 
	heading = "fLaunchers";
	shadowDetailMask = 4; 
	imageType = MrpgLauncher4Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

function MDCheckMrpgLauncher(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "MrpgLauncher")) 
	{ 
		Player::trigger(%player,$MrpgSlotA,true);
		Player::trigger(%player,$MrpgSlotB,true);
		Player::trigger(%player,$MrpgSlotC,true); 
		schedule("MDCheckMrpgLauncher(" @ %client @ "," @ %player @ ");",0.1); 
		$MDFiringMrpgLauncher[%client] = true; 
	} 
	else 
	{ 
		Player::trigger(%player,$MrpgSlotA,false); 
		Player::trigger(%player,$MrpgSlotB,false); 
		Player::trigger(%player,$MrpgSlotC,false); 
		$MDFiringMrpgLauncher[%client] = false; 
	} 
} 
//--------------------------------------------------------------------------------------------------------
// Rocket Propelled Mortar (RPM)
//--------------------------------------------------------------------------------------------------------

ItemData RPMAmmo
{
	description = "RPM Ammo";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	price = 5;
};

ItemImageData RPMImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = MortarAmmo;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

function RPMImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[Mortar]);
	 %armor = Player::getArmor(%player);

		 if(%Ammo) 
		 {
			 %client = GameBase::getOwnerClient(%player);
			 Player::decItemCount(%player,$WeaponAmmo[Mortar],1);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);
		
			 if(GameBase::getLOSInfo(%player,1024))
			 {
				 %object = getObjectType($los::object);
				 %targetId = GameBase::getOwnerClient($los::object);
	
				 if(%object == "Player" || %object == "Flier" || %object == "Turret" || %object == "StaticShape")
				 {			 
					 %object = getObjectType($los::object);
					 %targetId = GameBase::getOwnerClient($los::object);
					%armor = Player::getArmor(%object);
					%name = Client::getName(%targetid);
					Client::sendMessage(%client,0,"~wmine_act.wav");
					Projectile::spawnProjectile("SeekingRPM",%trans,%player,%vel,$los::object);
				 }
				 else
				 {
					 Projectile::spawnProjectile("RPM",%trans,%player,%vel,%player);
				 }
		 	}
			else
			{
				Projectile::spawnProjectile("RPM",%trans,%player,%vel,%player);
			}
		}
		else
			Client::sendMessage(Player::getClient(%player), 0,"You have no Ammo for the RPM");
	} //=== End standard missile fire.

ItemData RPMLauncher
{
	description = "RPM";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "grenade";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = RPMImage; 
	price = 800;
	showWeaponBar = true;
};

$AutoUse[RPMLauncher]			= True;

AddWeapon(rpmlauncher);

$InvList[RPMLauncher] = 1;
$RemoteInvList[RPMLauncher] = 1;

$ItemMax[larmor, RPMLauncher] = 0;
$ItemMax[lfemale, RPMLauncher] = 0;
$ItemMax[marmor, RPMLauncher] = 0;
$ItemMax[mfemale, RPMLauncher] = 0;
$ItemMax[harmor, RPMLauncher] = 1;

//--------------------------------------------------------------------------------------------------------
// Rocket Propelled ElectroMagneticPulse (RPEMP)
//--------------------------------------------------------------------------------------------------------

ItemData RPEMPAmmo
{
	description = "RPEMP Ammo";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "mortar";
	shadowDetailMask = 4;
	price = 5;
};

ItemImageData RPEMPImage
{
	shapeFile = "mortargun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = EMPGrenadeAmmo;
	accuFire = false;
	reloadTime = 0.5;
	fireTime = 2.0;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundLaserIdle;
};

function RPEMPImage::onFire(%player, %slot) 
{
	 %Ammo = Player::getItemCount(%player, $WeaponAmmo[EMPGrenadeLauncher]);
	 %armor = Player::getArmor(%player);

		 if(%Ammo) 
		 {
			 %client = GameBase::getOwnerClient(%player);
			 Player::decItemCount(%player,$WeaponAmmo[EMPGrenadeLauncher],1);
			 %trans = GameBase::getMuzzleTransform(%player);
		     %vel = Item::getVelocity(%player);
		
			 if(GameBase::getLOSInfo(%player,1024))
			 {
				 %object = getObjectType($los::object);
				 %targetId = GameBase::getOwnerClient($los::object);
	
				 if(%object == "Player" || %object == "Flier" || %object == "Turret" || %object == "StaticShape")
				 {			 
					 %object = getObjectType($los::object);
					 %targetId = GameBase::getOwnerClient($los::object);
					%armor = Player::getArmor(%object);
					%name = Client::getName(%targetid);	
					Client::sendMessage(%client,0,"~wmine_act.wav");
					Projectile::spawnProjectile("SeekingRPEMP",%trans,%player,%vel,$los::object);
				 }
				 else
				 {
					 Projectile::spawnProjectile("RPEMP",%trans,%player,%vel,%player);
				 }
		 	}
			else
			{
				Projectile::spawnProjectile("RPEMP",%trans,%player,%vel,%player);
			}
		}
		else
			Client::sendMessage(Player::getClient(%player), 0,"You have no Ammo for the RPM");
	} //=== End standard missile fire.

ItemData RPEMPLauncher
{
	description = "RPEMP";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "grenade";
   heading = "fLaunchers";
	shadowDetailMask = 4;
	imageType = RPEMPImage; 
	price = 1600;
	showWeaponBar = true;
};

$AutoUse[RPEMPLauncher]			= True;

AddWeapon(rpemplauncher);

$InvList[RPEMPLauncher] = 1;
$RemoteInvList[RPEMPLauncher] = 1;

$ItemMax[larmor, RPEMPLauncher] = 0;
$ItemMax[lfemale, RPEMPLauncher] = 0;
$ItemMax[marmor, RPEMPLauncher] = 0;
$ItemMax[mfemale, RPEMPLauncher] = 0;
$ItemMax[harmor, RPEMPLauncher] = 1;


//=============================================================================================\\

$MRocketgunSlotA=4;
$MRocketgunSlotB=5;
$MRocketgunSlotC=6; 

addweapon(MECHRocketLauncher);
$InvList[MECHRocketLauncher]			= 1;	
$RemoteInvList[MECHRocketLauncher]		= 1;
$AutoUse[MECHRocketLauncher]			= True;
$WeaponAmmo[MECHRocketLauncher]			= MissileAmmo;
$AmmoPackMax[MissileAmmo] 		= 250; 
$AmmoPackItems[17] = MissileAmmo; 
$ItemMax[larmor,MECHRocketLauncher]		= 0;
$ItemMax[lfemale,MECHRocketLauncher]		= 0;
$ItemMax[marmor,MECHRocketLauncher]		= 0;
$ItemMax[mfemale,MECHRocketLauncher]		= 0;
$ItemMax[harmor,MECHRocketLauncher]		= 1;

ItemImageData MECHRocketLauncherImage 
{ 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { -1.345, 0.08, 0.004 }; 
	mountRotation = { 0, 1.575, 0 }; 
	weaponType = 0; 
	reloadTime = 0.3; 
	fireTime = 0.1;
	minEnergy	= 5;	
	maxEnergy	= 6;
	ammoType = MissileAmmo; 
	accuFire = true; 
	sfxFire = SoundMissileTurretFire; 
	sfxActivate = SoundPickupminigun; 
	sfxReload = SoundSpinUp; 
	sfxReady = SoundMiniDown; 
}; 

//-----------------
//  Begin MECHRocketLauncher Fire Function
//-----------------

                     
function MECHRocketLauncherImage::onFire(%player, %slot) 
{ 
	%client = GameBase::getOwnerClient(%player); 
	Player::decItemCount(%player,$WeaponAmmo[MECHRocketLauncher],1); 
	%trans = GameBase::getMuzzleTransform(%player); 
	%vel = Item::getVelocity(%player); 
	Projectile::spawnProjectile("AAODRocket",%trans,%player,%vel,%player); 
	if(!$MDFiringMECHRocketLauncher[%client]) MDCheckMECHRocketLauncher(%client, %player); 
} 

ItemData MECHRocketLauncher 
{ 
	description = "MECHRocketgun"; 
	className = "Weapon"; 
	shapeFile = "mortargun"; 
	mountOffset = { -1.345, 0.08, 0.004 }; 
	mountRotation = { 0, 1.575, 0 }; 
	hudIcon = "mortar"; 
	heading = "fLaunchers";
	shadowDetailMask = 4; 
	imageType = MECHRocketLauncherImage; 
	price = 2500; 
	showWeaponBar = true; 
}; 

function MECHRocketLauncher::onDrop(%player,%item) 
{ 
	%state = Player::getItemState(%player,$WeaponSlot); 
	if (%state != "Fire" && %state != "Reload") 
	{ 
		Player::setItemCount(%player, MECHRocketLauncher2, 0); 
		Item::onDrop(%player,%item); 
	}
} 

function MECHRocketLauncher::onMount(%player,%imageSlot) 
{ 
	Player::mountItem(%player,MECHRocketLauncher2,$MRocketgunSlotA); 
	Player::mountItem(%player,MECHRocketLauncher3,$MRocketgunSlotB); 
	Player::mountItem(%player,MECHRocketLauncher4,$MRocketgunSlotC); 
} 

function MECHRocketLauncher::onUnmount(%player,%imageSlot) 
{ 
	Player::unmountItem(%player,$MRocketgunSlotA);
	Player::unmountItem(%player,$MRocketgunSlotB);	 
	Player::unmountItem(%player,$MRocketgunSlotC);
} 

ItemImageData MECHRocketLauncher2Image 
{ 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { -1.2, -0.45, 0 }; 
	mountRotation = { 0, 0, 0}; 
	weaponType = 0; 
	reloadTime = 1.0; 
	ammoType = MissileAmmo; 
	accuFire = true; 
	sfxFire = SoundMissileTurretFire; 
	fireTime = 0.1;
	minEnergy	= 5;	
	maxEnergy	= 6;
};	

ItemData MECHRocketLauncher2 
{ 
	description = "MECHRocketgun"; 
	className = "Weapon"; 
	shapeFile = "mortar"; 
	hudIcon = "mortar"; 
	heading = "fLaunchers";
	shadowDetailMask = 4; 
	imageType = MECHRocketLauncher2Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 
ItemImageData MECHRocketLauncher3Image 
{ 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { 0, -0.45, 0 }; 
	mountRotation = { 0, 0, 0 }; 
	weaponType = 0; 
	reloadTime = 1.0; 
	ammoType = MissileAmmo; 
	accuFire = true; 
	sfxFire = SoundMissileTurretFire; 
	fireTime = 0.1;
	minEnergy	= 5;	
	maxEnergy	= 6;
}; 

ItemData MECHRocketLauncher3 
{ 
	description = "MECHRocketgun"; 
	className = "Weapon"; 
	shapeFile = "mortargun"; 
	hudIcon = "mortar"; 
	heading = "fLaunchers";
	shadowDetailMask = 4; 
	imageType = MECHRocketLauncher3Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 
ItemImageData MECHRocketLauncher4Image 
{ 
	shapeFile = "mortargun"; 
	mountPoint = 0; 
	mountOffset = { 0.15, 0.08, 0.01 }; 
	mountRotation = { 0, -1.575, 0}; 
	weaponType = 0; 
	reloadTime = 1.0; 
	ammoType = MissileAmmo; 
	projectileType = AAODRocket; 
	accuFire = true; 
	sfxFire = SoundMissileTurretFire; 
	fireTime = 0.1;
	minEnergy	= 5;	
	maxEnergy	= 6;
}; 

ItemData MECHRocketLauncher4 
{ 
	description = "MECHRocketgun"; 
	className = "Weapon"; 
	shapeFile = "mortargun"; 
	hudIcon = "mortar"; 
	heading = "fLaunchers";
	shadowDetailMask = 4; 
	imageType = MECHRocketLauncher4Image; 
	price = 0; 
	showWeaponBar = true; 
	showInventory = false; 
}; 

function MDCheckMECHRocketLauncher(%client, %player) 
{ 
	if(Player::isTriggered(%player,$WeaponSlot) && (Player::getMountedItem(%player,$WeaponSlot) == "MECHRocketLauncher")) 
	{ 
		//Player::trigger(%player,$MRocketgunSlotA,true);
		//Player::trigger(%player,$MRocketgunSlotB,true);
		Player::trigger(%player,$MRocketgunSlotC,true);
		schedule("MDCheckMECHRocketLauncher(" @ %client @ "," @ %player @ ");",0.1); 
		$MDFiringMECHRocketLauncher[%client] = true; 
	} 
	else 
	{ 
		//Player::trigger(%player,$MRocketgunSlotA,false); 
		//Player::trigger(%player,$MRocketgunSlotB,false); 
		Player::trigger(%player,$MRocketgunSlotC,false); 
		$MDFiringMECHRocketLauncher[%client] = false; 
	} 
} 




//--------------------------------------------------------------------------------------------------------
// Laser Rifle
//--------------------------------------------------------------------------------------------------------

ItemImageData LaserRifleImage
{
	shapeFile = "sniper";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	projectileType = SniperLaser;
	accuFire = true;
	reloadTime = 0.3;
	fireTime = 0.5;
	minEnergy = 10;
	maxEnergy = 60;

	lightType = 3;  // Weapon Fire
	lightRadius = 2;
	lightTime = 1;
	lightColor = { 1, 0, 0 };

	sfxFire = SoundFireLaser;
	sfxActivate = SoundPickUpWeapon;
};

ItemData LaserRifle
{
	description = "Laser Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "sniper";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = LaserRifleImage;
	price = 900;
	showWeaponBar = true;
};

//--------------------------------------------------------------------------------------------------------
// Maser Rifle
//--------------------------------------------------------------------------------------------------------

ItemImageData MaserI
{
	shapeFile = "sniper";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	projectileType = SniperMaser;
	accuFire = true;
	reloadTime = 0.2;
	fireTime = 0.5;
	minEnergy = 40;
	maxEnergy = 80;

	lightType = 3;  // Weapon Fire
	lightRadius = 2;
	lightTime = 1;
	lightColor = { 1, 0, 0 };

	sfxFire = SoundFirePistol;
	sfxActivate = SoundPickUpWeapon;
};

ItemData MaserRifle
{
	description = "Maser Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "sniper";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = MaserI;
	price = 1250;
	showWeaponBar = true;
};

$AutoUse[MaserRifle]			= True;

AddWeapon(MaserRifle);

$InvList[MaserRifle] = 1;
$RemoteInvList[MaserRifle] = 1;

$ItemMax[harmor, MaserRifle] = 1;
$ItemMax[marmor, MaserRifle] = 1;
$ItemMax[mfemale, MaserRifle] = 1;
$ItemMax[larmor, MaserRifle] = 0;
$ItemMax[lfemale, MaserRifle] = 0;

//--------------------------------------------------------------------------------------------------------
// Particle Beam Weapon
//--------------------------------------------------------------------------------------------------------

$AutoUse[PBW]			= True;

AddWeapon(PBW);

$InvList[PBW] = 1;
$RemoteInvList[PBW] = 1;

$ItemMax[harmor, PBW] = 1;
$ItemMax[marmor, PBW] = 1;
$ItemMax[mfemale, PBW] = 1;
$ItemMax[larmor, PBW] = 0;
$ItemMax[lfemale, PBW] = 0;

ItemImageData PBWImage 
{
	shapeFile = "grenammo";
	mountPoint = 0;

	weaponType = 0; 
	minEnergy = 10;
	maxEnergy = 80;
      projectileType = ParticleBeam;
	accuFire = true;
	reloadTime = 0.2;
	fireTime = 6.5;
	
	sfxFire = SoundPBWBreakSoundBarrier; 
	sfxActivate = SoundDryFire;
	sfxReload = SoundPBWRecharge;
};

ItemData PBW
{
	description = "Particle Beam (PBW)";
	className = "Weapon";
	shapeFile = "grenammo";
	hudIcon = "blaster";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = PBWImage;
	price = 2500;
	showWeaponBar = true;
};

function PBW::onUse(%player,%item)
{
	if(Player::getMountedItem(%player,$BackpackSlot) == Accelerator)
		Weapon::onUse(%player,%item);
	else
		Client::sendMessage(Player::getClient(%player),1,
			"Must have Particle Accelerator to use PBW."); 
}

//--------------------------------------------------------------------------------------------------------
// Poison Dart Rifle
//--------------------------------------------------------------------------------------------------------

ItemData Darts
{
	description = "Poison Darts";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "ammo1";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData DartGunImage
{
	shapeFile = "sniper";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = Darts;
	projectileType = PoisonDart;
	accuFire = true;
	reloadTime = 0.5;
	fireTime = 0;

	lightType = 3;  // Weapon Fire
	lightRadius = 6;
	lightTime = 2;
	lightColor = { 1.0, 0, 0 };

	sfxFire = SoundFirePistol;
	sfxActivate = SoundPickUpWeapon;
	
};

ItemData DartGun
{
	description = "Poison Dart Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "blaster";
  heading = "dRifles";
	shadowDetailMask = 4;
	imageType = DartGunImage;
	price = 300;
	showWeaponBar = true;
};

$SellAmmo[Darts]			= 30;
$AmmoPackMax[Darts]		= 50;

AddWeapon(dartgun);

$InvList[DartGun] = 1;
$RemoteInvList[DartGun] = 1;

$InvList[Darts] = 1;
$RemoteInvList[Darts] = 1;

$ItemMax[larmor, DartGun] = 1;
$ItemMax[lfemale, DartGun] = 1;
$ItemMax[marmor, DartGun] = 1;
$ItemMax[mfemale, DartGun] = 1;
$ItemMax[harmor, DartGun] = 0;

$ItemMax[larmor, Darts] = 30;
$ItemMax[lfemale, Darts] = 30;
$ItemMax[marmor, Darts] = 30;
$ItemMax[mfemale, Darts] = 30;
$ItemMax[harmor, Darts] = 0;

ItemData Shells
{
	description = "Shells";
	className = "Ammo";
    heading = "xAmmunition";
	shapeFile = "ammo1";
	shadowDetailMask = 4;
	price = 1;
};
//=======================================

ItemData ARAmmo
{
	description = "Assault Bullets";
   heading = "xAmmunition";
	className = "Ammo";
	shapeFile = "ammo1";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData ARImage
{
	shapeFile = "sniper";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = ARAmmo;
	projectileType = AssaultBullet;
	accuFire = true;
	reloadTime = 0.01;
	fireTime = 0.2;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 1, 1, 0.2 };

	sfxFire = debrisSmallExplosion;
	sfxActivate = SoundJetLight;
	sfxReload = SoundJetLight;
};

ItemData AR
{
	description = "Assault Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "chain";
   heading = "dRifles";
	shadowDetailMask = 4;
	imageType = ARImage;
	price = 1300;
	showWeaponBar = true;
};
$SellAmmo[ARAmmo]			= 125;
$AmmoPackMax[ARAmmo]		= 10;

AddWeapon(AR);

$InvList[ARAmmo] = 1;
$RemoteInvList[ARAmmo] = 1;

$InvList[AR] = 1;
$RemoteInvList[AR] = 1;

$ItemMax[larmor, AR] = 0;
$ItemMax[lfemale, AR] = 0;
$ItemMax[marmor, AR] = 1;
$ItemMax[mfemale, AR] = 1;
$ItemMax[harmor, AR] = 1;

$ItemMax[larmor, ARAmmo] = 0;
$ItemMax[lfemale, ARAmmo] = 0;
$ItemMax[marmor, ARAmmo] = 100;
$ItemMax[mfemale, ARAmmo] = 100;
$ItemMax[harmor, ARAmmo] = 125;

//--------------------------------------------------------------------------------------------------------
// 80mm Railgun
//--------------------------------------------------------------------------------------------------------

ItemData RailAmmo 
{
  description = "Railgun Bolt";
  className = "Ammo";
  heading = "xAmmunition";
  shapeFile = "ammo1";
  shadowDetailMask = 4;
  price = 5;
};

ItemImageData RailgunImage 
{
  shapeFile = "sniper";
  mountPoint = 0;
  weaponType = 0;
  ammoType = RailAmmo;
  projectileType = RailRound;
  accuFire = true;
  reloadTime = 0.5;
  fireTime = 0.1;
  lightType = 3;
  lightRadius = 6;
  lightTime = 2;
  lightColor = { 1.0, 0, 0 };
  sfxFire = SoundMissileTurretFire;
  sfxActivate = SoundPickUpWeapon;
  sfxSpinUp = SoundSpinUp;
  sfxSpinDown = SoundSpinDown;
};

ItemData Railgun 
{
  description = "80MM Demon Rifle";
  className = "Weapon";
  shapeFile = "sniper";
  hudIcon = "targetlaser";
  heading = "dRifles";
  shadowDetailMask = 4;
  imageType = RailgunImage;
  price = 1500;
  showWeaponBar = true;
};
    
$SellAmmo[RailAmmo]			= 30;
$AmmoPackMax[RailAmmo]		= 10;

AddWeapon(Railgun);

$InvList[RailAmmo] = 1;
$RemoteInvList[RailAmmo] = 1;

$InvList[Railgun] = 1;
$RemoteInvList[Railgun] = 1;

$ItemMax[larmor, Railgun] = 0;
$ItemMax[lfemale, Railgun] = 0;
$ItemMax[marmor, Railgun] = 1;
$ItemMax[mfemale, Railgun] = 1;
$ItemMax[harmor, Railgun] = 1;

$ItemMax[larmor, RailAmmo] = 0;
$ItemMax[lfemale, RailAmmo] = 0;
$ItemMax[marmor, RailAmmo] = 30;
$ItemMax[mfemale, RailAmmo] = 30;
$ItemMax[harmor, RailAmmo] = 20;

//--------------------------------------------------------------------------------------------------------
// 60mm Sniper Rifle
//--------------------------------------------------------------------------------------------------------

ItemImageData RifleImage
{
	shapeFile = "sniper";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = Shells;
	projectileType = RifleBullet;
	accuFire = true;
	reloadTime = 0.5;
	fireTime = 0.1;
      lightType = 3;
      lightRadius = 6;
      lightTime = 2;
      lightColor = { 1.0, 0, 0 };
      sfxFire = SoundMissileTurretFire;
      sfxActivate = SoundPickUpWeapon;
      sfxSpinUp = SoundSpinUp;
      sfxSpinDown = SoundSpinDown;


};

ItemData Rifle
{
	description = "60MM Hell Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "blaster";
      heading = "dRifles";
	shadowDetailMask = 4;
	imageType = RifleImage;
	price = 1400;
	showWeaponBar = true;
};

$SellAmmo[Shells]			= 40;
$AmmoPackMax[Shells]		= 10;

AddWeapon(rifle);

$InvList[Shells] = 1;
$RemoteInvList[Shells] = 1;

$InvList[Rifle] = 1;
$RemoteInvList[Rifle] = 1;

$ItemMax[larmor, Rifle] = 0;
$ItemMax[lfemale, Rifle] = 0;
$ItemMax[marmor, Rifle] = 1;
$ItemMax[mfemale, Rifle] = 1;
$ItemMax[harmor, Rifle] = 0;

$ItemMax[larmor, Shells] = 40;
$ItemMax[lfemale, Shells] = 40;
$ItemMax[marmor, Shells] = 40;
$ItemMax[mfemale, Shells] = 40;
$ItemMax[harmor, Shells] = 0;


//--------------------------------------------------------------------------------------------------------
// 40mm Sniper Rifle
//--------------------------------------------------------------------------------------------------------

ItemData Bolts
{
	description = "Mass Driver Bolts";
	className = "Ammo";
   heading = "xAmmunition";
	shapeFile = "ammo1";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData MassDriverImage
{
	shapeFile = "sniper";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = Bolts;
	projectileType = RifleBullet;
	accuFire = true;
	reloadTime = 0.5;
	fireTime = 0.1;
      lightType = 3;
      lightRadius = 6;
      lightTime = 2;
      lightColor = { 1.0, 0, 0 };
      sfxFire = SoundMissileTurretFire;
      sfxActivate = SoundPickUpWeapon;
      sfxSpinUp = SoundSpinUp;
      sfxSpinDown = SoundSpinDown;


};

ItemData MassDriver
{
	description = "40MM Hell Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "blaster";
  heading = "dRifles";
	shadowDetailMask = 4;
	imageType = MassDriverImage;
	price = 1300;
	showWeaponBar = true;
};

$SellAmmo[Bolts]			= 40;
$AmmoPackMax[Bolts]		= 10;

$InvList[MassDriver] = 1;
$RemoteInvList[MassDriver] = 1;

AddWeapon(massdriver);

$InvList[Bolts] = 1;
$RemoteInvList[Bolts] = 1;

$ItemMax[larmor, MassDriver] = 1;
$ItemMax[lfemale, MassDriver] = 1;
$ItemMax[marmor, MassDriver] = 1;
$ItemMax[mfemale, MassDriver] = 1;
$ItemMax[harmor, MassDriver] = 0;

$ItemMax[larmor, Bolts] = 40;
$ItemMax[lfemale, Bolts] = 40;
$ItemMax[marmor, Bolts] = 40;
$ItemMax[mfemale, Bolts] = 40;
$ItemMax[harmor, Bolts] = 0;

//--------------------------------------------------------------------------------------------------------
// 20mm Sniper Rifle
//--------------------------------------------------------------------------------------------------------

ItemData SniperAmmo 
{
  description = "Sniper Bullet";
  className = "Ammo";
  heading = "xAmmunition";
  shapeFile = "ammo1";
  shadowDetailMask = 4;
  price = 5;
};

ItemImageData SniperRifleImage 
{
  shapeFile = "sniper";
  mountPoint = 0;
  weaponType = 0;
  ammoType = SniperAmmo;
  projectileType = SniperRound;
  accuFire = true;
  reloadTime = 0.5;
  fireTime = 0.1;
  lightType = 3;
  lightRadius = 6;
  lightTime = 2;
  lightColor = { 1.0, 0, 0 };
  sfxFire = SoundMissileTurretFire;
  sfxActivate = SoundPickUpWeapon;
  sfxSpinUp = SoundSpinUp;
  sfxSpinDown = SoundSpinDown;

};

ItemData SniperRifle 
{
  description = "20MM Hell Rifle";
  className = "Weapon";
  shapeFile = "sniper";
  hudIcon = "targetlaser";
  heading = "dRifles";

  shadowDetailMask = 4;
  imageType = SniperRifleImage;
  price = 975;
  showWeaponBar = true;
};

$SellAmmo[SniperAmmo]			= 50;
$AmmoPackMax[SniperAmmo]		= 10;

$InvList[SniperRifle] = 1;
$RemoteInvList[SniperRifle] = 1;

AddWeapon(SniperRifle);

$InvList[SniperAmmo] = 1;
$RemoteInvList[SniperAmmo] = 1;

$ItemMax[larmor, SniperRifle] = 1;
$ItemMax[lfemale, SniperRifle] = 1;
$ItemMax[marmor, SniperRifle] = 0;
$ItemMax[mfemale, SniperRifle] = 0;
$ItemMax[harmor, SniperRifle] = 0;

$ItemMax[larmor, SniperAmmo] = 50;
$ItemMax[lfemale, SniperAmmo] = 50;
$ItemMax[marmor, SniperAmmo] = 0;
$ItemMax[mfemale, SniperAmmo] = 0;
$ItemMax[harmor, SniperAmmo] = 0;

//--------------------------------------------------------------------------------------------------------
// AAOD SniperX
//--------------------------------------------------------------------------------------------------------

ItemData SXAmmo
{
	description = "HP Shots";
	className = "Ammo";
   heading = "zAmmo";
	shapeFile = "magcargo";
	shadowDetailMask = 4;
	price = 1;
};

ItemImageData SXImage 
{
	shapeFile = "sniper";
	mountPoint = 0;
	mountRotation = { 0,-1.57, 0 };

	weaponType = 0; 
      projectileType = sniperXBullet;
	ammoType = SXAmmo;
	accuFire = true;
	fireTime = 1.5;
	reloadTime = 0;
	sfxFire = SoundFireSniperX;
	sfxActivate = SoundPickUpWeapon;
};

ItemData AAODSniperX
{
	description = "HP Sniper Rifle";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "chain";
   heading = "dRifles";
	shadowDetailMask = 4;
	imageType = SXImage;
	price = 4500;
	showWeaponBar = true;
};

$InvList[AAODSniperX] = 1;
$RemoteInvList[AAODSniperX] = 1;
$InvList[SXAmmo] = 1;
$RemoteInvList[SXAmmo] = 1;

AddWeapon(aaodsniperx);

$ItemMax[larmor, AAODSniperX] = 1;
$ItemMax[lfemale, AAODSniperX] = 1;
$ItemMax[marmor, AAODSniperX] = 1;
$ItemMax[mfemale, AAODSniperX] = 1;
$ItemMax[harmor, AAODSniperX] = 0;

$ItemMax[larmor, SXAmmo] = 30;
$ItemMax[lfemale, SXAmmo] = 30;
$ItemMax[marmor, SXAmmo] = 40;
$ItemMax[mfemale, SXAmmo] = 40;
$ItemMax[harmor, SXAmmo] = 0;

//--------------------------------------------------------------------------------------------------------
// ELF Gun
//--------------------------------------------------------------------------------------------------------

ItemImageData EnergyRifleImage
{
	shapeFile = "shotgun";
   mountPoint = 0;

   weaponType = 2;  // Sustained
	projectileType = lightningCharge;
   minEnergy = 3;
   maxEnergy = 11;  // Energy used/sec for sustained weapons
	reloadTime = 0.2;
                        
   lightType = 3;  // Weapon Fire
   lightRadius = 2;
   lightTime = 1;
   lightColor = { 0.25, 0.25, 0.85 };

   sfxActivate = SoundPickUpWeapon;
   sfxFire     = SoundELFIdle;
};

ItemData EnergyRifle
{
   description = "ELF Gun";
	shapeFile = "shotgun";
	hudIcon = "energyRifle";
   className = "Tool";
   heading = "cEnergy Weapons";
   shadowDetailMask = 4;
   imageType = EnergyRifleImage;
	showWeaponBar = true;
   price = 500;
};



//--------------------------------------------------------------------------------------------------------
// AAOD SniperX
//--------------------------------------------------------------------------------------------------------

ItemImageData SBI
{
	shapeFile = "sniper";
	bulletShapeName  = "bullet.dts";
   explosionTag     = bulletExp0;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 0;
   damageValue      = 0.75;
   damageType       = $BulletDamageType;

   explosionRadius  = 0.1;
   kickBackStrength = 600.0;
   muzzleVelocity   = 2000.0;
   terminalVelocity = 2000.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 10.0;
   lightColor       = { 0.25, 0.25, 1 };
   inheritedVelocityScale = 1.0;

   trailType   = 1;         
   trailLength = 3000;
   trailWidth  = 0.6;
  
   soundId = SoundJetHeavy;

};

ItemData BlastaRifle
{
	description = "Sonic Blasta Pack";
	className = "Weapon";
	shapeFile = "sniper";
	hudIcon = "chain";
   heading = "dRifles";
	shadowDetailMask = 4;
	imageType = SBI;
	price = 0;
	showWeaponBar = true;
};

function RepairGun::onMount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,true);
}

function RepairGun::onUnmount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,false);
}

//=============================================================================================

ItemImageData ReassemblerImage
{
	shapeFile = "repairgun";
	mountPoint = 0;

	weaponType = 2; // Sustained
	projectileType = reassemblerBolt;
	accuFire = true;
	minEnergy = 2;
	maxEnergy = 5;
	reloadTime = 0;

	lightType   = 3;  // Weapon Fire
	lightRadius = 1;
	lightTime   = 1;
	lightColor  = { 0.25, 1, 0.25 };

	sfxFire     = SoundRepairItem;
	sfxActivate = SoundPickUpWeapon;
};

ItemData Reassembler
{
	description   = "Reassembler";
	className     = "Tool";
	shapeFile     = "repairgun";
	hudIcon       = "targetlaser";
   heading = "gMiscellany";
	shadowDetailMask = 4;
	imageType     = ReassemblerImage;
	price         = 100;
	showWeaponBar = false;
};

$AutoUse[Reassembler]			= True;

AddWeapon(reassembler);

$InvList[Reassembler] = 1;
$RemoteInvList[Reassembler] = 1;

$ItemMax[larmor, Reassembler] = 1;
$ItemMax[lfemale, Reassembler] = 1;
$ItemMax[marmor, Reassembler] = 1;
$ItemMax[mfemale, Reassembler] = 1;
$ItemMax[harmor, Reassembler] = 1;

//--------------------------------------------------------------------------------------------------------
// Repair Gun
//--------------------------------------------------------------------------------------------------------

ItemImageData RepairGunImage
{
	shapeFile = "repairgun";
	mountPoint = 0;

	weaponType = 2;  // Sustained
	projectileType = RepairBolt;
	minEnergy  = 3;
	maxEnergy = 10;  // Energy used/sec for sustained weapons

	lightType   = 3;  // Weapon Fire
	lightRadius = 1;
	lightTime   = 1;
	lightColor  = { 0.25, 1, 0.25 };

	sfxActivate = SoundPickUpWeapon;
	sfxFire = SoundRepairItem;
};

ItemData RepairGun
{
	description = "Repair Gun";
	shapeFile = "repairgun";
	className = "Weapon";
	shadowDetailMask = 4;
	imageType = RepairGunImage;
	showInventory = false;
	price = 125;
};

function RepairGun::onMount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,true);
}

function RepairGun::onUnmount(%player,%imageSlot)
{
	Player::trigger(%player,$BackpackSlot,false);
}

//--------------------------------------------------------------------------------------------------------
// Swarmer
//--------------------------------------------------------------------------------------------------------

ItemData SwarmerAmmo
{
	description = "Swarmer Rack";
	className = "Ammo";
	shapeFile = "mortarammo";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 4;
};

ItemImageData SwarmerImage
{
	shapeFile = "mortargun";
	mountPoint = 0;
	mountOffset = { 0, -0.1, 0 };

	weaponType = 0; // Single Shot
	ammoType = SwarmerAmmo;
	accuFire = false;
	reloadTime = 2.0;
	fireTime = 1.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };

	sfxFire = SoundFireSeeking;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
};

ItemData Swarmer
{
	description = "Swarmer";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "grenade";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = SwarmerImage;
	price = 16384;
	showWeaponBar = true;
};

AddWeapon(Swarmer);

function Swarmer::onMount(%player,%item,$WeaponSlot)
{
	%client = Player::getclient(%player);
	Player::mountItem(%player,ExtraSwarmerA,$ExtraWeaponSlotA);
	Player::mountItem(%player,ExtraSwarmerB,$ExtraWeaponSlotB);
	Player::mountItem(%player,ExtraSwarmerC,$ExtraWeaponSlotC);
}

function Swarmer::onUnmount(%player,%item,$WeaponSlot)
{
	Player::unmountItem(%player,$ExtraWeaponSlotA);
	Player::unmountItem(%player,$ExtraWeaponSlotB);
	Player::unmountItem(%player,$ExtraWeaponSlotC);
}

function SwarmerImage::onFire(%player,%slot)
{
	%rawCharge = Player::getItemCount(%player,SwarmerAmmo);
	%charge = %rawCharge *= 0.2;
	if(%charge > 0)
	{
		for(%i=1; %i<%charge; %i++)
		{
			%trans = GameBase::getMuzzleTransform(%player);
			%vel = Item::getVelocity(%player);
			Projectile::spawnProjectile("SwarmerRocket",%trans,%player,%vel);
		}
		Player::setItemCount(%player,SwarmerAmmo,0);
		if($SwarmerRecharging[%player] != True)
		{
			$SwarmerRecharging[%player] = True;
			%guntype = Swarmer;
			schedule("RechargeAmmo(" @ %player @ ", " @ %guntype @ ");",0.25,%player);
		}
	}
		else Client::sendMessage(Player::getClient(%player),0,"Swarmer is out of energy.");
}


ItemImageData SwarmerImageA
{
	shapeFile = "grenadeL";
	mountPoint = 0;
	mountOffset = { 0, 0, 0.25 };

	weaponType = 0; // Single Shot
	ammoType = SwarmerAmmo;
	accuFire = false;
	reloadTime = 2.5;
	fireTime = 1.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
};

ItemData ExtraSwarmerA
{
	description = "Swarmer";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = SwarmerImageA;
	price = 0;
	showWeaponBar = true;
	showInventory = false;
};


ItemImageData SwarmerImageB
{
	shapeFile = "grenadeL";
	mountPoint = 0;
	mountOffset = { 0.15, 0, 0 };

	weaponType = 0; // Single Shot
	ammoType = SwarmerAmmo;
	accuFire = false;
	reloadTime = 2.5;
	fireTime = 1.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
};

ItemData ExtraSwarmerB
{
	description = "Swarmer";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = SwarmerImageB;
	price = 0;
	showWeaponBar = true;
	showInventory = false;
};


ItemImageData SwarmerImageC
{
	shapeFile = "grenadeL";
	mountPoint = 0;
	mountOffset = { -0.15, 0, 0 };

	weaponType = 0; // Single Shot
	ammoType = SwarmerAmmo;
	accuFire = false;
	reloadTime = 2.5;
	fireTime = 1.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 0.6, 1, 1.0 };
};

ItemData ExtraSwarmerC
{
	description = "Swarmer";
	className = "Weapon";
	shapeFile = "grenadeL";
	hudIcon = "grenade";
   heading = "cEnergy Weapons";
	shadowDetailMask = 4;
	imageType = SwarmerImageC;
	price = 0;
	showWeaponBar = true;
	showInventory = false;
};


function RechargeAmmo(%player,%gunType)
{
	%armor = Player::GetArmor(%player);
	if(%gunType == Swarmer && (Player::getItemCount(%player,Swarmer) > 0))
	{
		if(Player::getItemCount(%player,SwarmerAmmo) < $ItemMax[%armor,SwarmerAmmo])
		{
			Player::incItemCount(%player,SwarmerAmmo,1);
			schedule("RechargeAmmo(" @ %player @ ", " @ %gunType @ ");",0.5,%player);
		}
		else
			$SwarmerRecharging[%player] = False;
	}
	else if(%gunType == PlasmaGun (Player::getItemCount(%player,PlasmaGun) > 0))
{
	if(Player::getItemCount(%player,PlasmaAmmo) < $ItemMax[%armor,PlasmaAmmo])
	{
		Player::incItemCount(%player,PlasmaAmmo,1);
		schedule("RechargeAmmo(" @ %player @ ", " @ %gunType @ ");",1,%player);
	}
	else
		$PlasmaGunRecharging[%player] = False;
}
}

function THResuply(%player)
{
	Station::itemsToResupply(%player);
	schedule("THResuply(" @ %player @ ");",0.5,%this);
}

$SellAmmo[SwarmerAmmo] = 50;
$AmmoPackMax[SwarmerAmmo] = 75;
$AmmoPackItems[9] = SwarmerAmmo;
$WeaponAmmo[Swarmer] = SwarmerAmmo;

$InvList[Swarmer] = 1;
$RemoteInvList[Swarmer] = 1;
$InvList[SwarmerAmmo] = 1;
$RemoteInvList[SwarmerAmmo] = 1;

$ItemMax[harmor, Swarmer] = 1;
$ItemMax[larmor, Swarmer] = 0;
$ItemMax[marmor, Swarmer] = 1;
$ItemMax[lfemale, Swarmer] = 0;
$ItemMax[mfemale, Swarmer] = 1;

$ItemMax[harmor, SwarmerAmmo] = 100;
$ItemMax[larmor, SwarmerAmmo] = 0;
$ItemMax[marmor, SwarmerAmmo] = 50;
$ItemMax[lfemale, SwarmerAmmo] = 0;
$ItemMax[mfemale, SwarmerAmmo] = 50;

//--------------------------------------------------------------------------------------------------------
// Shotgun
//--------------------------------------------------------------------------------------------------------

ItemImageData ShotgunImage
{
	shapeFile = "shotgun";
    mountPoint = 0;

	ammoType = Shells;
	weaponType = 0; // Single Shot
	reloadTime = 0.1;
	fireTime = 1.1;
                        
	accuFire = false;

	 lightType = 3;
	 lightRadius = 3;
	 lightTime = 1;
	 lightColor = { 1.0, 0.7, 0.5 };

	sfxActivate = SoundPickUpWeapon;
	sfxFire     = SoundFirePistol;
	sfxReload   = SoundMortarReload;
   
};

ItemData Shotgun
{
    description = "Shotgun";
	shapeFile = "shotgun";
	hudIcon = "blaster";
    className = "Weapon";
    heading = "bBase Weapons";
    shadowDetailMask = 4;
    imageType = ShotgunImage;
	showWeaponBar = true;
    price = 1000;
};

$WeaponAmmo[Shotgun] = Shells;

AddWeapon(shotgun);

function ShotgunImage::onFire(%player, %slot) 
{
 %AmmoCount = Player::getItemCount(%player, $WeaponAmmo[Shotgun]);
	 if(%AmmoCount) 
	 {
		 %client = GameBase::getOwnerClient(%player);
		 Player::decItemCount(%player,$WeaponAmmo[Shotgun],1);
		 %trans = GameBase::getMuzzleTransform(%player);
	     %vel = Item::getVelocity(%player);
	
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);
			Projectile::spawnProjectile("ShotgunBullet",%trans,%player,%vel);

}
	else
		Client::sendMessage(Player::getClient(%player), 0,"Out Of Shotgun Shells");

}

$InvList[Shotgun] = 1;
$RemoteInvList[Shotgun] = 1;

$ItemMax[larmor, Shotgun] = 1;
$ItemMax[lfemale, Shotgun] = 1;
$ItemMax[marmor, Shotgun] = 1;
$ItemMax[mfemale, Shotgun] = 1;
$ItemMax[harmor, Shotgun] = 1;

//--------------------------------------------------------------------------------------------------------
// Plasma Gun
//--------------------------------------------------------------------------------------------------------

ItemData PlasmaAmmo
{
	description = "Plasma Bolt";
   heading = "xAmmunition";
	className = "Ammo";
	shapeFile = "plasammo";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData PlasmaGunImage
{
	shapeFile = "plasma";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	ammoType = PlasmaAmmo;
	projectileType = PlasmaBolt;
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.5;

	lightType = 3;  // Weapon Fire
	lightRadius = 3;
	lightTime = 1;
	lightColor = { 1, 1, 0.2 };

	sfxFire = SoundFirePlasma;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundDryFire;
};

ItemData PlasmaGun
{
	description = "Plasma Gun";
	className = "Weapon";
	shapeFile = "plasma";
	hudIcon = "plasma";
   heading = "bBase Weapons";
	shadowDetailMask = 4;
	imageType = PlasmaGunImage;
	price = 175;
	showWeaponBar = true;
};

$WeaponAmmo[PlasmaCannon] = "";

AddWeapon(plasmacannon);

$InvList[PlasmaCannon] = 1;
$RemoteInvList[PlasmaCannon] = 1;

$ItemMax[harmor, PlasmaCannon] = 1;
$ItemMax[larmor, PlasmaCannon] = 0;
$ItemMax[marmor, PlasmaCannon] = 0;
$ItemMax[lfemale, PlasmaCannon] = 0;
$ItemMax[mfemale, PlasmaCannon] = 0;

ItemImageData PlasmaCannonImage
{
	shapeFile = "mortargun";
	mass = 1;
	mountPoint = 0;
	mountRotation = { 0, 0, 0 };
	weaponType = 0;
	accuFire = true;
	reloadTime = 0.1;
	fireTime = 0.5;
	minEnergy = 10;
	maxEnergy = 70;
	lightType = 3;
	lightRadius = 2;
	lightTime = 1;
	lightColor = { 1, 0, 0 };
	sfxFire = SoundFireMortar;
	sfxActivate = SoundPickUpWeapon;
	sfxReload = SoundMortarReload;
	sfxReady = SoundMortarIdle;
};

ItemData PlasmaCannon
{
	description = "Gundam Super Plasma";
	className = "Weapon";
	shapeFile = "mortargun";
	hudIcon = "sniper";
   	heading = "eCannons";
	shadowDetailMask = 4;
	imageType = PlasmaCannonImage;
	price = 12800;
	showWeaponBar = true;
	mass = 1.0;
};

function PlasmaCannonImage::onFire(%player, %slot) 
{
	%clientId = player::getclient(%player);
	
	if (%clientId.plasmacharge)
	{
		%clientId.charging = "";
		%lc = %clientId.plasmacharge;
		
		%armor = Player::getArmor(%player); %client = GameBase::getOwnerClient(%player); %trans = GameBase::getMuzzleTransform(%player); %vel = Item::getVelocity(%player); %pos = (gamebase::getposition(%player));	 %rot = (gamebase::getrotation(%player)); %dir = (Vector::getfromrot(%rot));

		if (%lc > 0)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
		}
		if (%lc > 3)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.39);		
		}
		if (%lc > 5)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt2, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.15);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.425);
		}
		if (%lc > 7)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.475);
		}
		if (%lc > 9)
		{
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt2, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.35);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.5);		
		}
		
		if (%lc == 15)
		{
			schedule ("PlasmaConnonShock2Fire(\"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\", \"" @ %clientId @ "\", \"0\");",0.2);
			schedule ("PlasmaConnonShock2Fire(\"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\", \"" @ %clientId @ "\", \"1\");",0.63);
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.1);
			schedule ("Projectile::spawnProjectile(PlasmaCannonBolt2, \"" @ %trans@ "\",\"" @ %player @ "\",\"" @ %vel @ "\");",0.15);
			schedule ("Projectile::spawnProjectile(PlasmaCannonShock, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.65);
		}
			%fired.deployer = %client;

		%clientId.plasmacharge = "0";
		return;
	}
	else
	{
		Client::sendMessage(%clientId,1,"** Gundam Super Plasma uses beacons to charge... ~waccess_denied.wav");
		return;
	}
}

function PlasmaCannoner::Charge(%clientId, %time)
{
	%player = client::getownedobject(%clientId);

	Player::mountItem(%clientId, PlasmaCannon, $WeaponSlot);

	if (!%clientId.charging)
		return;
	
	if (%time > 0)
	{
		%time--;
		schedule("PlasmaCannoner::Charge(" @ %clientId @", " @ %time @ ");",1.0);
                BottomPrint (%clientId, "** Gundam Super Plasma CPU: " @ %time @ " before full charge ", 5);
		%clientId.plasmacharge++;
		return;
	}
	else
	{
		BottomPrint (%clientId, "** Gundam Super Plasma CPU: Full charge attained... Ready!\n<f1>** Warning ** Due to the extreme stress of all that energy, the Gundam Plasma Cannon may overload... ETA: 30 seconds"  , 5);
		%clientId.plasmacharge = 15;
		PlasmaCannoner::Detonate(%clientId, 30);
		return;
	}
}

function PlasmaCannoner::Detonate(%clientId, %time)
{
	%player = client::getownedobject(%clientId);
	Player::mountItem(%clientId, PlasmaCannon, $WeaponSlot);
	
	if (%clientId.plasmacharge != 15)
		return;

	if (%time > 0)
	{
		%time--;
		schedule("PlasmaCannoner::Detonate(" @ %clientId @", " @ %time @ ");",1.0);
	}
	else
	{
		%clientId.charging = "";
		%clientId.plasmacharge = "0";
		Player::blowUp(%clientId);
			%obj = newObject("","Mine","HavocBlast");
			GameBase::throw(%obj,%clientId,0,false);		
			addToSet("MissionCleanup", %obj);
			%padd = "0 0 1.5";
			%pos = Vector::add(GameBase::getPosition(%clientId), %padd);
			GameBase::setPosition(%obj, %pos);
  		GameBase::applyDamage(%player, $PlasmaDamageType, 5, "0 0 0", "0 0 0", "0 0 0", %clientId);
		return;
	}
	if (%time > 0 && %time < 25)
	{
		bottomprint (%clientId, "<jc>** Gundam Super Plasma CPU: ETA to overload: " @ %time @ " seconds");
	}
}

RocketData PlasmaCannonBolt
{ 
	bulletShapeName = "plasmaex.dts"; 
	explosionTag = plasmaExp; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
    	damageValue = 1.8; 
	damageType = $PlasmaDamageType;
	explosionRadius = 15; 
	kickBackStrength = 0.0; 
	muzzleVelocity   = 205.0;
	terminalVelocity = 265.0;
	acceleration     = 45.0;
	totalTime = 5.0; 
	liveTime = 5.0; 
	lightRange = 5.0; 
	lightColor = { 1.0, 0.0, 0.05 }; 
	inheritedVelocityScale = 0.0; 
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonBolt2
{ 
	bulletShapeName = "plasmabolt.dts"; 
	explosionTag = plasmaExp; 
	collisionRadius = 0.0;
	mass = 0.0; 
	damageClass = 1;
    	damageValue = 1.5; 
	damageType = $PlasmaDamageType;
	explosionRadius = 10; 
	kickBackStrength = 0.0; 
	muzzleVelocity = 135.0; 
	terminalVelocity = 145.0;
	acceleration = 35; 
	totalTime = 5.0; 
	liveTime = 5.0; 
	lightRange = 5.0; 
	lightColor = { 2.0, 0.0, 0.0 }; 
	inheritedVelocityScale = 0.0; 
	trailType   = 2;
	trailString = "plasmatrail.dts";
	smokeDist   = 180.0;
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonShock
{
	bulletShapeName  = "plasmabolt.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 0.0;
	damageClass      = 1;
	damageValue      = 1.9;
	damageType       = $PlasmaDamageType;
	explosionRadius  = 15.0;
	kickBackStrength = 0;
	muzzleVelocity   = 135.0;
	terminalVelocity = 155.0;
	acceleration     = 25.0;
	totalTime        = 5.0;
	liveTime         = 5.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.0, 0.0 };
	inheritedVelocityScale = 0.0;

	trailType   = 2;
	trailString = "plasmabolt.dts";
	smokeDist   = 140.0;
	soundId = SoundJetHeavy;
};

RocketData PlasmaCannonShock2
{
	bulletShapeName  = "plasmaex.dts";
	explosionTag     = grenadeExp;
	collisionRadius  = 0.0;
	mass             = 0.0;
	damageClass      = 1;
	damageValue      = 1.0;
	damageType       = $PlasmaDamageType;
	explosionRadius  = 15.0;
	kickBackStrength = 0;
	muzzleVelocity   = 35.0;
	terminalVelocity = 65.0;
	acceleration     = 25.0;
	totalTime        = 5.0;
	liveTime         = 5.0;
	lightRange       = 5.0;
	lightColor       = { 1.0, 0.0, 0.0 };
	inheritedVelocityScale = 0.0;

	trailType   = 2;
	trailString = "plasmatrail.dts";
	smokeDist   = 160.0;
	soundId = SoundJetHeavy;
};


function PlasmaConnonShock2Fire(%trans, %player, %vel, %client, %num)
{
	%fired = (Projectile::spawnProjectile(PlasmaCannonShock2, %trans,%player,%vel));
	%fired.deployer = %client;

	if (%num == 0)
	{
		$Plasma[0] = %fired;
	}
	if (%num == 1)
	{
		%boom = $Plasma[0];
		$Plasma[%boom] = %fired;
	}
	
}

function PlasmaCannonShock2::OnRemove(%this)
{
	%boom = $Plasma[%this];
	
	if (%boom)
	{
		DeployFrags(%boom, 10, %boom.deployer);
		DeployFrags(%boom, 10, %boom.deployer);	
	}
}

function PlasmaCannonShock2::Blast(%this)
{
	DeployFrags(%this, 10, %this.deployer);
}

//==================================================================================================== Napalm Frags

MineData Frag1
{
   	mass = 5.0;
   	drag = 0.5;
   	density = 2.0;
	elasticity = 0.15;
	friction = 0.5;
	className = "Handgrenade";
	description = "Bomblet";
	shapeFile = "plasmabolt";
	shadowDetailMask = 4;
	explosionId = boltexp3;
	explosionRadius = 10.0;
	damageValue = 0.4;
	damageType = $PlasmaDamageType;
	kickBackStrength = 300;
	triggerRadius = 0.5;
	maxDamage = 1.5;
};

function Frag1::onAdd(%this)
{
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

MineData Frag2
{
   	mass = 5.0;
   	drag = 0.5;
   	density = 2.0;
	elasticity = 0.35;
	friction = 1.0;
	className = "Handgrenade";
	description = "Bomblet";
	shapeFile = "plasmabolt";
	shadowDetailMask = 4;
	explosionId = boltexp3;
	explosionRadius = 10.0;
	damageValue = 0.4;
	damageType = $PlasmaDamageType;
	kickBackStrength = 300;
	triggerRadius = 0.5;
	maxDamage = 1.5;
};

function Frag2::onAdd(%this)
{
	schedule("Mine::Detonate(" @ %this @ ");",2.25,%this);
}

MineData Frag3
{
   	mass = 5.0;
   	drag = 0.1;
   	density = 2.0;
	elasticity = 0.25;
	friction = 1.5;
	className = "Handgrenade";
	description = "Bomblet";
	shapeFile = "plasmabolt";
	shadowDetailMask = 4;
	explosionId = boltexp3;
	explosionRadius = 10.0;
	damageValue = 0.4;
	damageType = $PlasmaDamageType;
	kickBackStrength = 300;
	triggerRadius = 0.5;
	maxDamage = 1.5;
};

function Frag3::onAdd(%this)
{
	schedule("Mine::Detonate(" @ %this @ ");",2.5,%this);
}

function DeployFrags(%this, %count, %player) 
{
        %cl = Player::getClient(%player);
	%pos = gamebase::getposition(%this);
	%team = GameBase::getTeam(%player);

	for (%i = 0; %i < %count; %i++)
	{
		%frag = "Frag" @ (floor(getRandom()*3)+1);
		%obj = newObject("","Mine", %frag);
		%obj.deployer = %cl;

		if ((floor(getRandom()*4)+1) > 2)
		{
			%dir = 120;			
			GameBase::throw(%obj,%cl,%dir,true);
		}
		else
		{
			%dir = 60;
			GameBase::throw(%obj,%cl,%dir,true);
		}

		addToSet("MissionCleanup", %obj);
		
		GameBase::setPosition(%obj, %pos);
	}

}

//--------------------------------------------------------------------------------------------------------
// Flamer
//--------------------------------------------------------------------------------------------------------

ItemData Gasoline
{
	description = "Gasoline fo da flama";
   heading = "xAmmunition";
	className = "Ammo";
	shapeFile = "plasammo";
	shadowDetailMask = 4;
	price = 2;
};

ItemImageData FlamerI
{
	shapeFile = "shotgun";
    mountPoint = 0;

	ammoType = Gasoline;
	weaponType = 0; // Single Shot
	reloadTime = 0;
	fireTime = 0.1;
                        
	accuFire = false;

	 lightType = 3;
	 lightRadius = 3;
	 lightTime = 1;
	 lightColor = { 1.0, 0.7, 0.5 };

	sfxActivate = SoundPickUpWeapon;
	sfxFire     = SoundFireFlamer;
   
};

ItemData Flamer
{
    description = "Flamer";
	shapeFile = "shotgun";
	hudIcon = "blaster";
    className = "Weapon";
    heading = "bBase Weapons";
    shadowDetailMask = 4;
    imageType = FlamerI;
	showWeaponBar = true;
    price = 2500;
};

$WeaponAmmo[Flamer] = Gasoline;

AddWeapon(Flamer);

function FlamerI::onFire(%player, %slot) 
{
 %AmmoCount = Player::getItemCount(%player, $WeaponAmmo[Flamer]);
	 if(%AmmoCount) 
	 {
		 %client = GameBase::getOwnerClient(%player);
		 Player::decItemCount(%player,$WeaponAmmo[Flamer],1);
		 %trans = GameBase::getMuzzleTransform(%player);
	     %vel = Item::getVelocity(%player);

			Projectile::spawnProjectile("Flamesz",%trans,%player,%vel);
			Projectile::spawnProjectile("smoke",%trans,%player); 

}
	else
		Client::sendMessage(Player::getClient(%player), 0,"Out Of Gasoline");

}

$InvList[Flamer] = 1;
$RemoteInvList[Flamer] = 1;

$InvList[Gasoline] = 1;
$RemoteInvList[Gasoline] = 1;

$ItemMax[larmor, Flamer] = 1;
$ItemMax[lfemale, Flamer] = 1;
$ItemMax[marmor, Flamer] = 1;
$ItemMax[mfemale, Flamer] = 1;
$ItemMax[harmor, Flamer] = 1;

$ItemMax[larmor, Gasoline] = 150;
$ItemMax[lfemale, Gasoline] = 150;
$ItemMax[marmor, Gasoline] = 300;
$ItemMax[mfemale, Gasoline] = 300;
$ItemMax[harmor, Gasoline] = 500;

//-----------------------------------
// Beacon Gun Script
//-----------------------------------
$InvList[AODBeaconGun]			= 1;
$RemoteInvList[AODBeaconGun]	= 1;		
$AutoUse[AODBeaconGun]			= True;
$WeaponAmmo[AODBeaconGun]		= BeaconAmmo;
$InvList[BeaconAmmo]			= 1;	
$RemoteInvList[BeaconAmmo]		= 1;
$SellAmmo[BeaconAmmo]			= 5;
AddWeapon(AODBeaconGun);

$ItemMax[larmor,AODBeaconGun]	= 1;
$ItemMax[lfemale,AODBeaconGun]	= 1;
$ItemMax[marmor,AODBeaconGun]	= 1;
$ItemMax[mfemale,AODBeaconGun]	= 1;
$ItemMax[harmor,AODBeaconGun]	= 1;

$ItemMax[larmor,BeaconAmmo]		=5;
$ItemMax[lfemale,BeaconAmmo]	=5;
$ItemMax[marmor,BeaconAmmo]		=8;
$ItemMax[mfemale,BeaconAmmo]	=8;
$ItemMax[harmor,BeaconAmmo]		=10;


ExplosionData AODBeaconGunExp
{	shapeName = "shockwave.dts";	
	soundId=  SoundBeaconExplosion;	
	faceCamera=true;				
	randomSpin = true;		
	hasLight=true;			
	lightRange=9.0;			
	timeZero=0.100;			
	timeOne=0.900;			
	colors[0]={0.5,0.4,0.2};
	colors[1]={1.0,1.0,0.5};
	colors[2]={0.0,1.0,0.0};
	radFactors={0.5,1.0,0.0};
	shiftPosition=False;	
};

RocketData BeaconRocket
{	bulletShapeName		= "sensor_small.dts";
	explosionTag		= AODBeaconGunExp;
	#collideWithOwner	= true;
	#ownerGraceMS		= 750;
	collisionRadius		= 0.0;
	mass				= 1.0;
	damageClass			= 1;    
	damageValue			= 0.10;
	damageType			= $NullDamageType;
	explosionRadius		= 15.0;
	kickBackStrength	= 75.0;
	muzzleVelocity		= 25.0;
	terminalVelocity	= 25.0;
	acceleration		= 1.0;
	totalTime			= 22.0;
	liveTime			= 23.0;
	lightRange			= 5.0;
	lightColor			= { 0.2, 0.7, 0.5 };
	inheritedVelocityScale = 0.5;
	// rocket specific
	trailType			= 2;                
	trailString			= "rsmoke.dts";
	smokeDist			= 1.5;
	soundId				= SoundJetHeavy;
};

// Secondary Item Definitions... Ammo containers etc.

ItemData BeaconAmmo
{	description		= "Beacon Ammo";
	classname		= "Ammo";
	shapeFile		= "sensor_small";		
	heading			= "xAmmunition";
	shadowDetailMask = 4;
	price			= 50;
};
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
//  Tractor Device (TractorDevice)
//  By Alazane,
//    see Contrib.txt
//
//  For installation information, see Install.txt
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

LightningData TractorBeam
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 200.0; // 120
   coneAngle        = 35.0;
   damagePerSec      = 0.0;
   energyDrainPerSec = 0.0;
   segmentDivisions = 5;
   numSegments      = 2;
   beamWidth        = 0.5;//0.125//075;

   updateTime   = 120;
   skipPercent  = 0.25;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.85, 0.85, 0.15 };

   soundId = SoundELFFire;
};

$TractorPower = 10;

function TractorBeam::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId) 
{
  %obj1 = %target;
  %obj2 = %shooterId;

   // Get object's mass  
  if (getObjectType(%obj1) == "Player") 
    %obj1mass = Player::getArmor(%obj1).mass;
  else
    %obj1mass = 10000;

  %obj2mass = Player::getArmor(%obj2).mass;

   // 
  %vec = Vector::Normalize(Vector::Sub(GameBase::getPosition(%obj1), GameBase::getPosition(%obj2)));

  if (getObjectType(%obj1) == "Player")
  {
    %mul = $TractorPower - ($TractorPower * %obj1mass) / (%obj1mass + %obj2mass);
    %nvec = (getWord(%vec, 0) * %mul * -1) @ " " @
            (getWord(%vec, 1) * %mul * -1) @ " " @
            (getWord(%vec, 2) * %mul * -1);
    //Player::applyImpulse(%obj1, %nvec);
    Item::setVelocity(%obj1, %nvec);
  }

   // obj2 is always a player
  %mul = $TractorPower - ($TractorPower * %obj2mass) / (%obj1mass + %obj2mass);
  %nvec = (getWord(%vec, 0) * %mul) @ " " @
          (getWord(%vec, 1) * %mul) @ " " @
          (getWord(%vec, 2) * %mul);
  //Player::applyImpulse(%obj2, %nvec);
  Item::setVelocity(%obj2, %nvec);
}

ItemImageData TractorDeviceImage
{
   shapeFile = "mortargun";
   mountPoint = 0;

   weaponType = 2;  // Sustained
   projectileType = TractorBeam;
   minEnergy = 12;
   maxEnergy = 12;  // Energy used/sec for sustained weapons
   reloadTime = 0.2;
			
   lightType = 3;  // Weapon Fire
   lightRadius = 2;
   lightTime = 1;
   lightColor = { 0.85, 0.85, 0.15 };

   sfxActivate = SoundPickUpWeapon;
   sfxFire     = SoundELFIdle;
};

ItemData TractorDevice
{
  className = "Tool";
  description = "Energy Grappling Hook";
  heading = "cEnergy Weapons";
  hudIcon = "energyRifle";
  imageType = TractorDeviceImage;
  price = 125;
  shadowDetailMask = 4;
  shapeFile = "mortargun";
  showWeaponBar = true;
};

$AutoUse[TractorDevice]			= True;

AddWeapon(TractorDevice);

$InvList[TractorDevice] = 1;
$RemoteInvList[TractorDevice] = 1;

$ItemMax[larmor, TractorDevice] = 0;
$ItemMax[lfemale, TractorDevice] = 0;
$ItemMax[marmor, TractorDevice] = 1;
$ItemMax[mfemale, TractorDevice] = 1;
$ItemMax[harmor, TractorDevice] = 1;

//----------------------------------------------------------------------------

ItemImageData FLImage
{
	shapeFile = "Paintgun";
	mountPoint = 0;

	weaponType = 0; // Single Shot
	projectileType = FlashBeam;
	accuFire = true;
	reloadTime = 0.00001;
	fireTime = 0.00001;
	minEnergy = 0.00001;
	maxEnergy = 0.00002;

	lightType = 3;  // Weapon Fire
	lightRadius = 2;
	lightTime = 1;
	lightColor = { 0, 0, 0 };

	sfxActivate = SoundPickUpWeapon;
};

ItemData FL
{
	description = "Flashlight";
	className = "Tool";
	shapeFile = "paintGun";
	hudIcon = "sniper";
   heading = "gMiscellany";
	shadowDetailMask = 4;
	imageType = FLImage;
	price = 200;
	showWeaponBar = true;
};

$AutoUse[FL]			= True;

AddWeapon(FL);

$InvList[FL] = 1;
$RemoteInvList[FL] = 1;

$ItemMax[larmor, FL] = 0;
$ItemMax[lfemale, FL] = 0;
$ItemMax[marmor, FL] = 1;
$ItemMax[mfemale, FL] = 1;
$ItemMax[harmor, FL] = 0;

//***************************************************
// Item Image Definitions
//***************************************************

ItemImageData AODBeaconGunImage
{	shapeFile		= "PaintGun";
	mountPoint		= 0;
	mountOffset		= { -0.1, 0, 0 };
	mountRotation	= { 0, -2.75, 0};
	weaponType		= 0;
	reloadTime		= 0.75;
	fireTime		= 1.5;
	minEnergy		= 15;	
	maxEnergy		= 50;	
//	projectileType	= Unknown;
	ammoType		= BeaconAmmo;
	accuFire		= true;
	sfxActivate		= SoundPickUpWeapon;
};

ItemData AODBeaconGun
{	heading = "gMiscellany";
	description			= "Beacon Gun";
	classname			= "Tool";
	shapeFile			= "PaintGun";
	hudIcon				= "mortar";	
	shadowDetailMask	= 4;
	imageType			= AODBeaconGunImage;	
	price				= 450;				
	showWeaponBar		= true;	
};

function DeployRBeacon(%player)
{	// if($trace) echo( $ver@"|DeployRbeacon  ");
	%position=$Location;
	%rot=$Rotation;
	%beacon = newObject("Target Beacon", "StaticShape", "DefaultBeacon", true);
	if($traceObj) Echo($Ver,"|Created New Object :",%beacon," Beacon");
	addToSet("MissionCleanup", %beacon);
	GameBase::setTeam(%beacon,GameBase::getTeam(%player));
	GameBase::setRotation(%beacon,%rot);
	GameBase::setPosition(%beacon,%position);
	Gamebase::setMapName(%beacon,"Target Beacon");
	Beacon::onEnabled(%beacon);
}

function AODBeaconGunImage::onFire(%player,%slot)
{	// if($trace) echo( $ver@"|AODBeaconGunImage::onFire");
	%client = GameBase::getOwnerClient(%player);
	%AmmoCount = (Player::getItemCount(%player, $WeaponAmmo[AODBeaconGun]) && Player::getItemCount(%player,Beacon)) ;
	if(%AmmoCount)
	{	%trans = GameBase::getMuzzleTransform(%player);
		%vel = Item::getVelocity(%player);
		if(GameBase::getLOSInfo(%player,250))
		{	%object = getObjectType($los::object);
			if (%object!="Player" && %object !="Flier" && %object !="") // == "SimTerrain" || %object == "InteriorShape" || %object=="StaticShape") 
			{	// Try to stick it straight up or down, otherwise
				// just use the surface normal
				if (Vector::dot($los::normal,"0 0 1") > 0.6) 
				{	%rot = "0 0 0";}
				else 
				{	if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
					{	%rot = "3.14159 0 0";}
					else 
					{	%rot = Vector::getRotation($los::normal);}
				}
				%team = GameBase::getTeam(%player);
				if($TeamItemMax[Beacon] > $TeamItemCount[%team @ Beacon] || $TestCheats) 
				{	%Dist=Vector::getDistance(GameBase::getPosition(%player),$los::position);
					if(%Dist==0)
					{	%tTime=1;}
					else
					{	%tTime=%Dist/25;}

					playSound(SoundMissileTurretFire, GameBase::getPosition(%player));
					Projectile::spawnProjectile("BeaconRocket",%trans,%player,%vel,$los::object);
					playSound(SoundMissileReload, GameBase::getPosition(%player));
					GiveKickBack(%player, 15, 1);
					$Location=$los::position;
					$Rotation=%rot;
					schedule("DeployRBeacon(" @ %player @ " );",%tTime);
					$TeamItemCount[GameBase::getTeam(%beacon) @ "Beacon"]++;
					Player::decItemCount(%player,Beacon);
				}
				else
				Client::sendMessage(%client,0,"Deployable Item limit reached! ~Error_Message.wav");
			}
			else
			Client::sendMessage(%client,0,"** Invalid Target - Unable to attach to Object! ** ~wError_Message.wav");
		}
		else
		Client::sendMessage(%client,0,"** Object Out of Range !! ** ~wError_Message.wav");
	}
	else
	{	if (!Player::getItemCount(%player, $WeaponAmmo[AODBeaconGun]))
	{	Client::sendMessage(%client,0,"** Out of BeaconAmmo!! ** ~waccess_denied.wav");}
	else
	{ 	Client::sendMessage(%client,0,"** Out of Beacons!! ** ~waccess_denied.wav");}
	}

}

