$PlayerAnim::Crouching = 25;
$PlayerAnim::DieChest = 26;
$PlayerAnim::DieHead = 27;
$PlayerAnim::DieGrabBack = 28;
$PlayerAnim::DieRightSide = 29;
$PlayerAnim::DieLeftSide = 30;
$PlayerAnim::DieLegLeft = 31;
$PlayerAnim::DieLegRight = 32;
$PlayerAnim::DieBlownBack = 33;
$PlayerAnim::DieSpin = 34;
$PlayerAnim::DieForward = 35;
$PlayerAnim::DieForwardKneel = 36;
$PlayerAnim::DieBack = 37;

$PlayerAnim::Celebration1 = 43;
$PlayerAnim::Celebration2 = 44;
$PlayerAnim::Celebration3 = 45;
$PlayerAnim::Taunt1 = 46;
$PlayerAnim::Taunt1 = 47;
$PlayerAnim::Taunt1 = 47;
$PlayerAnim::Stand = 49;
$PlayerAnim::Wave = 50;
$PlayerAnim::OverHere = 38;
$PlayerAnim::Salute = 42;

//----------------------------------------------------------------------------
$CorpseTimeoutValue = 22;
//----------------------------------------------------------------------------

// Player & Armor data block callbacks

function Player::onAdd(%this)
{
	GameBase::setRechargeRate(%this,8);
}

function Player::onRemove(%this)
{
	// Drop anything left at the players pos
	for (%i = 0; %i < 8; %i = %i + 1) {
		%type = Player::getMountedItem(%this,%i);
		if (%type != -1) {
			// Note: Player::dropItem ius not called here.
			%item = newObject("","Item",%type,1,false);
         schedule("Item::Pop(" @ %item @ ");", $ItemPopTime, %item);

         addToSet("MissionCleanup", %item);
			GameBase::setPosition(%item,GameBase::getPosition(%this));
		}
	}
}

function Player::onNoAmmo(%player,%imageSlot,%itemType)
{
	//echo("No ammo for weapon ",%itemType.description," slot(",%imageSlot,")");
}

function Player::onKilled(%this)
{
	%cl = GameBase::getOwnerClient(%this);
	%cl.dead = 1;
	if($AutoRespawn > 0)
		schedule("Game::autoRespawn(" @ %cl @ ");",$AutoRespawn,%cl);
	if(%this.outArea==1)	
		leaveMissionAreaDamage(%cl);
	Player::setDamageFlash(%this,0.75);
	for (%i = 0; %i < 8; %i = %i + 1) {
		%type = Player::getMountedItem(%this,%i);
		if (%type != -1) {
			if (%i != $WeaponSlot || !Player::isTriggered(%this,%i) || getRandom() > "0.2") 
				Player::dropItem(%this,%type);
		}
	}

   if(%cl != -1)
   {
		if(%this.vehicle != "")	{
			if(%this.driver != "") {
				%this.driver = "";
        	 	Client::setControlObject(Player::getClient(%this), %this);
        	 	Player::setMountObject(%this, -1, 0);
			}
			else {
				%this.vehicle.Seat[%this.vehicleSlot-2] = "";
				%this.vehicleSlot = "";
			}
			%this.vehicle = "";		
		}
      schedule("GameBase::startFadeOut(" @ %this @ ");", $CorpseTimeoutValue, %this);
      Client::setOwnedObject(%cl, -1);
      Client::setControlObject(%cl, Client::getObserverCamera(%cl));
      Observer::setOrbitObject(%cl, %this, 5, 5, 5);
      schedule("deleteObject(" @ %this @ ");", $CorpseTimeoutValue + 2.5, %this);
      %cl.observerMode = "dead";
      %cl.dieTime = getSimTime();
   }
}

function Player::onDamage(%this,%type,%value,%pos,%vec,%mom,%vertPos,%quadrant,%object)
{
      %damagedClient = Player::getClient(%this);
      %shooterClient = %object;

		Player::applyImpulse(%this,%mom);
		if($teamplay && %damagedClient != %shooterClient && Client::getTeam(%damagedClient) == Client::getTeam(%shooterClient) ) {
			if (%shooterClient != -1) {
				%curTime = getSimTime();
			   if ((%curTime - %this.DamageTime > 3.5 || %this.LastHarm != %shooterClient) && %damagedClient != %shooterClient && $Server::TeamDamageScale > 0) {
					if(%type != $MineDamageType) {
						Client::sendMessage(%shooterClient,0,"You hurt " @ Client::getName(%damagedClient) @ " (teammate)");
						Client::sendMessage(%damagedClient,0,"You were shot by " @ Client::getName(%shooterClient) @ " (teammate)");
					}
					else {
						Client::sendMessage(%shooterClient,0,"You hurt " @ Client::getName(%damagedClient) @ " (teammate) with your mine!");
						Client::sendMessage(%damagedClient,0,"You stepped on " @ Client::getName(%shooterClient) @ "'s mine");
					}
					%this.LastHarm = %shooterClient;
					%this.DamageStamp = %curTime;
				}
			}
			%friendFire = $Server::TeamDamageScale;
		}
		else if(%type == $ImpactDamageType && Client::getTeam(%object.clLastMount) == Client::getTeam(%damagedClient)) 
			%friendFire = $Server::TeamDamageScale;
		else  
			%friendFire = 1.0;	

		%shooterObj = Client::getControlObject(%shooterClient);

		if ((Player::isAIControlled(%damagedClient) == True)	&&			//===== Determines if player is A.I. (by EMO1313, added by Werewolf)
			(%damagedClient != %shooterClient))	
		{

if ($Spoonbot::BotJetting[%damagedClient] != 1)
  AI::JetSimulation(%damagedClient, 0);

			$BotThink::ForcedOfftrack[%damagedClient] = true;


			%objecttype = getObjectType(%shooterObj);
			
			if(%object == 0) // Fix. Find nearest enemy AI within range of 150
			{
				%aiId = %damagedClient;
				%maxdist = 500;

				%nearestdist = 999999;
				%nearestid = 0;
				%myTeam = Client::getTeam(%aiId);
				%BotPosistion = GameBase::getPosition(%aiId);

				for(%x = 0; %x < $AttackerIndexCount; %x++)
				{

					%nearestnominateid = $AttackerIndexIds[%x];
					%nearestnominatepos = GameBase::getPosition($AttackerIndexIds[%x]);
					%nearestnominatedist = Vector::getDistance(%BotPosistion,%nearestnominatepos);
					%nearestnominateteam = Client::getTeam(%nearestnominateid);
					%nearestnominatename = Client::getName(%nearestnominateid);

					// Note: following if statement breaks AI type standard - direct coding!

					if	((%aiId != %nearestnominateid) &&
						 ( %nearestnominatedist < %nearestdist) &&
						 (%nearestnominateteam != %myTeam))
					{

						%nearestid = %nearestnominateid;
						%nearestdist = %nearestnominatedist;
					}
				}

				if(%nearestdist <= %maxdist)
				{

  					BotFuncs::AddAttacker(%aiId,%nearestid,1024,1);
					//BotThink::Think(%aiId, False);
				}
			}
			else if (getObjectType(%shooterObj) == "Player")				// Is the shooting client a player?
			{

				 %shooterpos = GameBase::getPosition(%shooterClient);			//===== Gets Shooters Location & Other Varibles
				 %worldLoc = WaypointToWorld ( %shooterpos );
				 %aiTeam = Client::GetTeam(%damagedClient);
				 %aiName = Client::GetName(%damagedClient);
				 %aiId = %damagedclient;
			 
				 %shooterTeam = Client::GetTeam(%shooterClient);
	
				 if(%aiTeam != %shooterTeam)
				 {

  					BotFuncs::AddAttacker(%aiId,%shooterClient,150,1);

					//BotThink::Think(%aiId, False);

				 }

			 }
		}

		if (!Player::isDead(%this)) {
			%armor = Player::getArmor(%this);
			//More damage applyed to head shots
			if(%vertPos == "head" && %type == $LaserDamageType || %type == $SniperXDamageType) {
				if(%armor == "harmor") { 
					if(%quadrant == "middle_back" || %quadrant == "middle_front" || %quadrant == "middle_middle") {
						%value += (%value * 0.6);
					}
				}
				else {
					%value += (%value * 0.3);
				}
			}
			//If Shield Pack is on
			if (%type != -1 && %this.shieldStrength) {
				%energy = GameBase::getEnergy(%this);
				%strength = %this.shieldStrength;
				if (%type == $ShrapnelDamageType || %type == $MortarDamageType)
					%strength *= 0.75;
				// Added Code to Modify Damage From Magnetic Damage - *IX*Savage1
				if (%type == $PBWDamageType || %type == $HeatDamageType || %type == $LaserDamageType || %type == $MBDamageType)
					%value = 0.0128;
				if (%type == $MineDamageType || %type == $ImpactDamageType || %type == $LandingDamageType)
					%value = 0.0001;
				%absorb = %energy * %strength;
				if (%value < %absorb) {
					GameBase::setEnergy(%this,%energy - ((%value / %strength)*%friendFire));
					%thisPos = getBoxCenter(%this);
					%offsetZ =((getWord(%pos,2))-(getWord(%thisPos,2)));
					GameBase::activateShield(%this,%vec,%offsetZ);
					%value = 0;
				}
				else {
					GameBase::setEnergy(%this,0);
					%value = %value - %absorb;
				}
			}
			if(%type == $EMPDamageType)
				EMPStart(%damagedClient, %this);
			else if ((%armor == "gundam") && (!%this.shieldStrength))
			{
				Gundam_emergencyshield(%damagedClient, %this);
			}
			else if (%type == $MethaneDamageType) 
			{
				%armor = Player::getArmor(%this);
					Poisoned(%damagedClient, %this);
			}
			else if (%type == $ImpactDamageType)
			{
				%armor = Player::getArmor(%this);
					Player::BlowUp(%this);
			}
//}\\   <===== How did this happen?
			else if ((%type == $PlasmaDamageType) || (%type == $HeatDamageType)) 
			{
				%rnd = floor(getRandom() * 10);
				if(%rnd > 7)
				{
					%armor = Player::getArmor(%this);
						BurnTheFlesh(%damagedClient, %this);
				}
			}
			else if (%type == $MBHeatDamageType) 
			{
					%armor = Player::getArmor(%this);
						BurnTheFlesh(%damagedClient, %this);
			}
		else if (%type == $StasisDamageType)
		{
			if(%damagedclient.inStasis>0)
			{	%damagedclient.inStasis++;
				%loss = GameBase::getEnergy(%this)*$StasisEnergyDrain;
				GameBase::setEnergy(%this,(%energy-%loss));
			}
			else
			{	%armor=Player::getArmor(%damagedClient);
				%narmor=%barmor@S;
				Player::setArmor(%damagedclient,%narmor);
				schedule("resetArmor("@%damagedclient@","@%armor@");",5,%damagedclient);
				%damagedClient.inStasis=1;
				%loss = GameBase::getEnergy(%this)*$StasisEnergyDrain;
				GameBase::setEnergy(%this,(%energy-%loss));
				%player=Client::getOwnedObject(%client);
				GameBase::setRechargeRate(%player,0);
			}
		}
  			if (%value) {
				// Added Sniper Shooting Weapon out of Hand - *IX*Savage1
				%armor = Player::getArmor(%this);
				%hitdamageval = 0.05;
				if(%armor == "harmor")
					%hittolerance = 0.25;
				else
					%hittolerance = 0.41;

				%weaponType = Player::getMountedItem(%this,$WeaponSlot);
				if ((%vertPos == "torso") && (%quadrant == "front_right") && (%type == $LaserDamageType) && (%value > %hittolerance) && (%weaponType != -1 && %weaponType != "RepairGun"))
				{
					Player::dropItem(%this,%weaponType);
	       		   	%dlevel = GameBase::getDamageLevel(%this) + %hitdamageval;
					messageall(0, Client::getName(%shooterClient) @ " sniped the " @ %weaponType @ " out of " @ Client::getName(%damagedClient) @ "'s Hand!");
				}
				else
				{
					%value = $DamageScale[%armor, %type] * %value * %friendFire;
		        	   	%dlevel = GameBase::getDamageLevel(%this) + %value;
				}
            		%spillOver = %dlevel - %armor.maxDamage;
				GameBase::setDamageLevel(%this,%dlevel);
				%flash = Player::getDamageFlash(%this) + %value * 2;
				if (%flash > 0.75) 
					%flash = 0.75;
				Player::setDamageFlash(%this,%flash);
				//If player not dead then play a random hurt sound
				if(!Player::isDead(%this)) { 
					if(%damagedClient.lastDamage < getSimTime()) {
						%sound = radnomItems(3,injure1,injure2,injure3);
						playVoice(%damagedClient,%sound);
						%damagedClient.lastdamage = getSimTime() + 1.5;
					}
				}
				else 
				{
           	if((%spillOver > 0.5 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType || %type == $MissileDamageType)) || %type == $PBWDamageType || %type == $LaserDamageType)
					{
						Player::trigger(%this, $WeaponSlot, false);
						%weaponType = Player::getMountedItem(%this,$WeaponSlot);
						if(%weaponType != -1)
							Player::dropItem(%this,%weaponType);
						if (%type == $EnergyDamageType) 
							playSound(ShockExplosion,GameBase::getPosition(%this));
					   	Player::blowUp(%this);
					}
					else
					{
						if ((%value > 0.40 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType || %type == $MissileDamageType )) || (Player::getLastContactCount(%this) > 6) ) {
					  		if(%quadrant == "front_left" || %quadrant == "front_right") 
								%curDie = $PlayerAnim::DieBlownBack;
							else
								%curDie = $PlayerAnim::DieForward;
						}
						else if( Player::isCrouching(%this) ) 
							%curDie = $PlayerAnim::Crouching;							
						else if(%vertPos=="head") {
							if(%quadrant == "front_left" ||	%quadrant == "front_right"	) 
								%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieBack);
						  	else 
								%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieForward);
						}
						else if (%vertPos == "torso") {
							if(%quadrant == "front_left" ) 
								%curDie = radnomItems(3, $PlayerAnim::DieLeftSide, $PlayerAnim::DieChest, $PlayerAnim::DieForwardKneel);
							else if(%quadrant == "front_right") 
								%curDie = radnomItems(3, $PlayerAnim::DieChest, $PlayerAnim::DieRightSide, $PlayerAnim::DieSpin);
							else if(%quadrant == "back_left" ) 
								%curDie = radnomItems(4, $PlayerAnim::DieLeftSide, $PlayerAnim::DieGrabBack, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
							else if(%quadrant == "back_right") 
								%curDie = radnomItems(4, $PlayerAnim::DieGrabBack, $PlayerAnim::DieRightSide, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
						}
						else if (%vertPos == "legs") {
							if(%quadrant == "front_left" ||	%quadrant == "back_left") 
								%curDie = $PlayerAnim::DieLegLeft;
							if(%quadrant == "front_right" ||	%quadrant == "back_right") 
								%curDie = $PlayerAnim::DieLegRight;
						}
						Player::setAnimation(%this, %curDie);
					}
					if(%type == $ImpactDamageType && %object.clLastMount != "")  
						%shooterClient = %object.clLastMount;
					Client::onKilled(%damagedClient,%shooterClient, %type);
				}
			}
		}
}


function radnomItems(%num, %an0, %an1, %an2, %an3, %an4, %an5, %an6)
{
	return %an[floor(getRandom() * (%num - 0.01))];
}

function Player::onCollision(%this,%object)
{
	%Player1 = Player::getClient(%this);
	%Player2 = Player::getClient(%object);
	%aiId = Player::getClient(%this);
	%aiName = Client::GetName(%aiId);
	%aiTeam = Client::GetTeam(%this);	 
	%objTeam = Client::GetTeam(%object);

	if ((Player::isAIControlled(%Player1) == "true") &&
		(Player::isAIControlled(%Player2) != "true") &&
		 (BotTypes::IsMedic(%aiName) == 1))
	{
		%repairRate = 0.1;
		%damage = GameBase::getDamageLevel(%object);
		%difference = %damage - %repairRate;
		if (%difference < 0.0)	//If repair by 10 percent would result in exceeding 100 percent, just repair the missing few percent
			{
				%repairRate = %damage;
			}
		%newDamage = %damage - %repairRate;

		if (%objTeam == %aiTeam)			//Only repair friendly stuff.
			GameBase::setDamageLevel(%object, %newDamage);
	}
	if (Player::isAIControlled(%Player1) == "true"
			&& Player::isAIControlled(%Player2) == "true")
	{
		if(BotTypes::IsMedic(%aiName) == 1)
		{
			if (%aiTeam == %objTeam)
			{
			}
		}

		%targLoc = GameBase::getPosition(Client::getOwnedObject(%object));
		%aiLoc = GameBase::getPosition(Client::getOwnedObject(%this));
		%aiRotation = GameBase::GetRotation(Client::getOwnedObject(%this)); 
}
else
{

	if (Player::isDead(%this)) {
		if (getObjectType(%object) == "Player") {
			// Transfer all our items to the player
			%sound = false;
			%max = getNumItems();
			for (%i = 0; %i < %max; %i = %i + 1) {
				%count = Player::getItemCount(%this,%i);
				if (%count) {
					%delta = Item::giveItem(%object,getItemData(%i),%count);
					if (%delta > 0) {
						Player::decItemCount(%this,%i,%delta);
						%sound = true;
					}
				}
			}
			if (%sound) {
				// Play pickup if we gave him anything
				playSound(SoundPickupItem,GameBase::getPosition(%this));
			}
		}
	}
  }
}

function Player::getHeatFactor(%this)
{
	%client = Player::getClient(%this);
//	if (Client::getControlObject(%client) != %this)

  if (Player::isAIControlled(%this))		//If it's a bot and it's jetting, then by all means DESTROY HIM!!! ;-) Werewolf
  {
        if ($Spoonbot::BotJettingHeat[%client] == 1)
	{
		return 1.0;
	}
  }


  if ((Client::getControlObject(%client) != %this) && (!Player::isAIControlled(%this))) //Werewolf
	{
	 return 1.0;
	}


   %time = getIntegerTime(true) >> 5;
   %lastTime = Player::lastJetTime(%this) >> 10;

   if ((%lastTime + 1.5) < %time) {
      return 0.0;
   } else {
      %diff = %time - %lastTime;
      %heat = 1.0 - (%diff / 1.5);
      return %heat;
   }
}

function Player::jump(%this,%mom)
{
   %cl = GameBase::getControlClient(%this);
   if(%cl != -1)
   {
      %vehicle = Player::getMountObject (%this);
		%this.lastMount = %vehicle;
		%this.newMountTime = getSimTime() + 3.0;
		Player::setMountObject(%this, %vehicle, 0);
		Player::setMountObject(%this, -1, 0);
		Player::applyImpulse(%pl,%mom);
		playSound (GameBase::getDataName(%this).dismountSound, GameBase::getPosition(%this));
   }
}


//----------------------------------------------------------------------------

function remoteKill(%client)
{
   if(!$matchStarted)
      return;

   %player = Client::getOwnedObject(%client);
   if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player))
   {
		playNextAnim(%client);
	   Player::kill(%client);
	   Client::onKilled(%client,%client);
   }
}

$animNumber = 25;	 
function playNextAnim(%client)
{
	if($animNumber > 36) 
		$animNumber = 25;		
	Player::setAnimation(%client,$animNumber++);
}
function Client::takeControl(%clientId, %objectId)
{
   // remote control
   if(%objectId == -1)
   {
      //echo("objectId = " @ %objectId);
      return;
   }
   if(GameBase::getTeam(%objectId) != Client::getTeam(%clientId))
   {
      //echo(GameBase::getTeam(%objectId) @ " " @ Client::getTeam(%clientId));
      return;
   }
   if(GameBase::getControlClient(%objectId) != -1)
   {
      echo("Ctrl Client = " @ GameBase::getControlClient(%objectId));
      return;
   }
	%name = GameBase::getDataName(%objectId);
        if(
	%name != CameraTurret && 
	%name != DeployableTurret && 
	%name != Gunboy && 
	%name != SniperTurret &&  
	%name != DeployableTurret && 
	%name != AntiTurret && 
	%name != ArtilleryTurret &&
	%name != VELCROTurret &&  
	%name != GROGTurret && 
	%name != DeployableLaser && 
	%name != FusionTurret && 
	%name != IonTurret && 
	%name != Turret2 && 
	%name != Turret3 && 
	%name != DisruptorTurret && 
	%name != ELFTurret && 
	%name != SPlasTurret && 
	%name != ElectroTurret && 
	%name != PulseTurret && 
	%name != CannonTurret &&
	%name != DiscTurret &&  
      %name != FlamerTurret &&
      %name != RealObeliskOfLight &&
      %name != LaserTurret &&
      %name != DeployableELF &&
      %name != DeployableRocket &&
      %name != DeployableSentry &&
      %name != MortarTurret &&
      %name != AATurret &&
      %name != FluxTurret
)
{
	   if(!GameBase::isPowered(%objectId)) 
		{
	      return;
		}
   }
	if (Player::getMountedItem(%clientId,$BackpackSlot) != AODCmdPack) 
	{	if(!(Client::getOwnedObject(%clientId)).CommandTag && GameBase::getDataName(%objectId) != CameraTurret && !$TestCheats) 
		{	Client::SendMessage(%clientId,0,"Go get a Turret Control pack!");			
			return;
		}
	}

   if(GameBase::getDamageState(%objectId) == "Enabled") {
   	Client::setControlObject(%clientId, %objectId);
   	Client::setGuiMode(%clientId, $GuiModePlay);
	}
}


function remoteCmdrMountObject(%clientId, %objectIdx)
{
   Client::takeControl(%clientId, getObjectByTargetIndex(%objectIdx));
}

function checkControlUnmount(%clientId)
{
   %ownedObject = Client::getOwnedObject(%clientId);
   %ctrlObject = Client::getControlObject(%clientId);
   if(%ownedObject != %ctrlObject)
   {
      if(%ownedObject == -1 || %ctrlObject == -1)
         return;
      if(getObjectType(%ownedObject) == "Player" && Player::getMountObject(%ownedObject) == %ctrlObject)
         return;
      Client::setControlObject(%clientId, %ownedObject);
   }
}

//----------------------------------------------------------------------------
// New EMP Effect for Player - Mega Man 1024
//----------------------------------------------------------------------------
function EMPStart(%clientId, %player, %shooter, %type) 
{ 
	%weapon = Player::getMountedItem(%player,$WeaponSlot); 
	if(($WeaponAmmo[%weapon] == "")) Player::unmountItem(%player,$WeaponSlot); 

	if (%player.EMPEffect != "true") 
		{
			Client::sendMessage(%clientId,1,"You were hit with an EMP-- electrical malfunction detected~waaodsfx53.wav"); 
			GameBase::setRechargeRate(%player,0);
			%player.EMPEffect = "true";
			$empTime[%clientId] = 100;
		} else
		{
			$empTime[%clientId] += 50;
		}
	DrainZAP(%clientId, %player); 
} 

function BackupEMP(%clientId, %player)
{
	Client::sendMessage(%clientId,1,"You were hit with an EMP-- electrical malfunction detected~waaodsfx53.wav");
	if($empTime[%clientId] == 0)
	{
		GameBase::setEnergy(%player,0);
		GameBase::setRechargeRate(%player,0);
		$empTime[%clientId] = 10;
		BackupEMPWorking(%clientId, %player);
	}
	else
		$empTime[%clientId] = 10;
}

function BackupEMPWorking(%clientId, %player)
{
	if($empTime[%clientId] > 0)
	{
		$empTime[%clientId] -= 2;  
		schedule("BackupEMPWorking(" @ %clientId @ ", " @ %player @ ");",2,%player);
      }
	else
	{
		Client::sendMessage(%clientId,1,"Electrical system now functioning properly.~waaodsfx52.wav");
		GameBase::setRechargeRate(%player,8);
	}			
}

function DrainZAP(%clientId, %player) 
{
	if($empTime[%clientId] > 0) 
		{ 
			%energy = GameBase::getEnergy(%player);
		 	%energy -= 2;
			if (%energy <= 10) {
		      	%energy = 0;
				%damlevel = GameBase::getDamageLevel(%player);
				%damlevel += 0.003;
				Player::setDamageFlash(%player,0.75);  
				GameBase::setDamageLevel(%player,%damlevel);
			if(Player::isDead(%player))
			{
				messageall(0, Client::getName(%clientId) @ " died from an EMP blast.");
				%clientId.scoreDeaths++;
      			%clientId.score--;
				Game::refreshClientScore(%clientId);
				$empTime[%clientId] = 0;
			}

//				playSound(SoundEMPulseEffect,GameBase::getPosition(%player));
			   }
		      GameBase::setEnergy(%player, %energy);
			$empTime[%clientId] -= 1; 
			schedule("DrainZAP(" @ %clientId @ ", " @ %player @ ");",0.1,%player); } 
		else 
		{ 
			if (%player.EMPEffect == "true") 
			{
				GameBase::setRechargeRate(%player,8);
				if(!Player::isDead(%clientId)) Client::sendMessage(%clientId,1,"Electrical system now functioning properly.~waaodsfx52.wav"); 
				%player.EMPEffect = "false";
				$empTime[%clientId] = 0;
			}
		}
} 


function Poisoned(%clientId, %player)
{
	Client::sendMessage(%clientId,1, "You are infected.");
	if($poisonTime[%clientId] == 0)
	{
		
                Player::setDamageFlash(%player,2);
		$poisonTime[%clientId] = 15;
		checkPlayerBlind(%clientId, %player);
	}
	else
		$poisonTime[%clientId] = 15;
}


function checkPlayerBlind(%clientId, %player)
{
	
	if($poisonTime[%clientId] > 0)
	{
		$poisonTime[%clientId] -= 5;  
		%drrate = GameBase::getDamageLevel(%player) + 0.215;
			if  (!Player::isDead(%player)) 
			{
				GameBase::setDamageLevel(%player, %drrate);  
				Player::setDamageFlash(%player,1);  
				if  (Player::isDead(%player))
				{
					messageall(0, Client::getName(%clientId) @ " died from a poison injection.");
					%clientId.scoreDeaths++;
		      		%clientId.score--;
					Game::refreshClientScore(%clientId);
					$poisonTime[%clientId] = 0;
				}

		}
		else
		{
		
		$poisonTime[%clientId] = 0;
		}
		

		schedule("checkPlayerBlind(" @ %clientId @ ", " @ %player @ ");",3,%player);
      }
	else
	{
		Client::sendMessage(%clientId,1,"The poison subsides.");		
	}			

		
}

function Gundam_EmergencyShield(%clientId, %player)
{
	GameBase::playSound(%player,ForceFieldOpen,0);
	%armor = Player::getArmor(%player);

	if(%armor == "gharmor")
		%player.shieldStrength = 0.032;
	if(%armor == "harmor")
		%player.shieldStrength = 0.024;
	else 	if(%armor == "larmor" || %armor == "lfemale")
		%player.shieldStrength = 0.012;

	if($shieldTime[%clientId] == 100)
	{
		$shieldTime[%clientId] = 5;
		checkPlayerShield(%clientId, %player);
	}
	else
		$shieldTime[%clientId] = 100;
}


function checkPlayerShield(%clientId, %player)
{
	%armor = Player::getArmor(%player);
	if($shieldTime[%clientId] > 0)
	{
		$shieldTime[%clientId] -= 1;  

		if  ((!Player::isDead(%player)) && (%armor == "gundam" || %armor == "larmor" || %armor == "larmor"))
		{
			if  (Player::isDead(%player))
			{
				$shieldTime[%clientId] = 0;
			}
		}
		else
		{
			$shieldTime[%clientId] = 0;
		}

		schedule("checkPlayerShield(" @ %clientId @ ", " @ %player @ ");",0.1,%player);
    	}
	else
	{
		%player.shieldStrength = 0;
		GameBase::playSound(%player,ForceFieldClose,0);	
	}			

		
}

//============================================================================= Flamer Burn

function BurnTheFlesh(%clientId, %player)
{
	Client::sendMessage(%clientId,1,"You're on fire!");
	if($burnTime[%clientId] == 0)
	{
		
		Player::setDamageFlash(%player,0.25);
		$burnTime[%clientId] = 64;
		checkPlayerBurn(%clientId, %player);
	}
	else
		$burnTime[%clientId] = 64;
}


function checkPlayerBurn(%clientId, %player)
{
	
if($burnTime[%clientId] > 0)
	{
		$burnTime[%clientId] -= 2;  
		%drrate = GameBase::getDamageLevel(%player) + 0.01;
		if(!Player::isDead(%player)) 
		{
		GameBase::setDamageLevel(%player, %drrate);  
		Player::setDamageFlash(%player,0.25);  
			if(Player::isDead(%player))
			{
				messageall(0, Client::getName(%clientId) @ " was burned to death.");
				%clientId.scoreDeaths++;
      			%clientId.score--;
				Game::refreshClientScore(%clientId);
				$burnTime[%clientId] = 0;
			}

		}
		else
		{
			$burnTime[%clientId] = 0;
		}
		

		schedule("checkPlayerBurn(" @ %clientId @ ", " @ %player @ ");",0.1,%player);
      }
	else
	{
		Client::sendMessage(%clientId,1,"Your internal extinguishers put out the fire.");
		
	}			

		
}

//============================================================================= Flag Shot Off

function DoTheFlagDrop(%player, %shooterId) 
{
   %playerTeam = GameBase::getTeam(%player);
   %flag = %player.carryFlag;
   %flagTeam = GameBase::getTeam(%flag);
   %playerClient = Player::getClient(%player);
   %dropClientName = Client::getName(%playerClient);
   %shooterName = Client::getName(%shooterId);

   if(%flagTeam == -1)
   {
      MessageAllExcept(%playerClient, 1, %shooterName @ " sniped " @ %flag.objectiveName @ " off of " @ %dropClientName @ "'s back!");
      Client::sendMessage(%playerClient, 1, %shooterName @ " sniped " @ %flag.objectiveName @ " off of your back!");
   }
   else
   {
		MessageAllExcept(%playerClient, 0, %shooterName @ " sniped the " @ getTeamName(%flagTeam) @ " flag off of " @ %dropClientName @ "'s back!");
        Client::sendMessage(%playerClient, 0, %shooterName @ " sniped the " @ getTeamName(%flagTeam) @ " flag off of your back!");
        TeamMessages(1, %flagTeam, "Your flag was dropped in the field.", -2, "", "The " @ getTeamName(%flagTeam) @ " flag was dropped in the field.");
   }
   GameBase::throw(%flag, %player, -15, false);
   Item::hide(%flag, false);
   Player::setItemCount(%player, "Flag", 0);
   %flag.carrier = -1;
   %player.carryFlag = "";
   Flag::clearWaypoint(%playerClient, false);

	schedule("Flag::checkReturn(" @ %flag @ ", " @ %flag.pickupSequence @ ");", $flagReturnTime);
	%flag.dropFade = 1;
	ObjectiveMission::ObjectiveChanged(%flag);
}
