//************************************
// 	AODShieldNode Backpack Script
//************************************
$InvList[AODShieldNode]	= 1;
$RemoteInvList[AODShieldNode]	= 1;
$TeamItemMax[AODShieldNode]	= 320;

$ItemMax[larmor, AODShieldNode]		= 1;
$ItemMax[lfemale, AODShieldNode]	= 1;
$ItemMax[marmor, AODShieldNode]		= 1;
$ItemMax[mfemale, AODShieldNode]	= 1;
$ItemMax[harmor, AODShieldNode]		= 1;

ItemImageData AODShieldNodeImage 
{	shapeFile = "sensor_jammer";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData AODShieldNode 
{	description = "Remote Shield Node";
	shapeFile = "sensor_jammer";
	classname = "Backpack";
	heading =  "jDeployables";
	imageType = AODShieldNodeImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 750;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

StaticShapeData RemoteShieldNode 
{	description		= "Shield Node";
	shapeFile		= "sensor_jammer";
	classname		= "ShieldNode";
	debrisId		= flashDebrisSmall;
	sfxAmbient		= SoundGeneratorPower;
	maxDamage		= 2.5;
	mapIcon			= "M_generator";
	damageSkinData	= "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId		= flashExpMedium;
	visibleToSensor = true;
	mapFilter		= 4;
	maxEnergy		= 50;
};

function AODShieldNode::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	Player::mountItem(%player,%item,$BackpackSlot);	}
	else 
	{	
		Player::deployItem(%player,%item);
	}
}

function AODShieldNode::onDeploy(%player,%item,%pos)
{	if (AODShieldNode::deployShape(%player,%item)) 
	{}
}

function AODShieldNode::deployShape(%player,%item)
{	
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{	if (GameBase::getLOSInfo(%player,5)) 
		{	%obj = getObjectType($los::object);
			if($trace) echo( $ver@"|Object Type = ",%obj);
			if ((%obj == "SimTerrain" || %obj == "InteriorShape") || (%obj == "Turret" || %obj =="sensor") || (%obj == "Obstruction" || %obj =="Statue") || (%obj == "Hologram" || %obj =="LargeForceField") || ( %obj == "StaticShape"))
			{	%set = newObject("set",SimSet);
				%tnum = containerBoxFillSet(%set,$StaticObjectType,$los::position,2,2,2,0);
				%num = GetNumObjects(%set,0,%tnum);
				if(%num==1) 
				{		%boostObj=Group::getObject(%set,0);
						if (%boostObj.shieldNode)
						{	Client::sendMessage(%client,0,"DANGER!!! Shield Node Feedback!!~wError_message.wav");
							%pos1=GameBase::getPosition(%BoostObj.shieldNode);
							%pos2=GameBase::getPosition(%client);
							%vec=vector::sub(%pos1,%pos2);
							Player::onDamage(%client,$EnergyDamageType,1.5,%pos,%vec,"","head","front_left",%node);
							return false;
						}
						else
						{	deleteObject(%set);
							%prot = GameBase::getRotation(%player);
							%zRot = getWord(%prot,2);
							if (Vector::dot($los::normal,"0 0 1") > 0.6) 
							{	%rot = "0 0 " @ %zRot;}
							else
							{	if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
								{	%rot = "3.14159 0 " @ %zRot;}
								else
								{	%rot = Vector::getRotation($los::normal);}
							}
							%node = newObject("RemoteShieldNode","StaticShape",RemoteShieldNode,true);
							if($traceObj) Echo($Ver,"|Created New Object :",%newitem," | Remote Shield Node");
							echo("Shield Node Created (Node #",%node,") ");
							%team=GameBase::getTeam(%player);
							GameBase::setTeam(%node,%team);
							GameBase::setPosition(%node,$los::position);
							GameBase::setRotation(%node,%rot);
							Gamebase::setMapName(%node,"ShieldNode#" @ $totalNumNodes++ @ " " @ Client::getName(%client));
							Gamebase::StartFadein(%node);
							addToSet("MissionCleanup", %node);
							Client::setOwnedObject(%client, %node); 
							Client::setOwnedObject(%client, %player);
							GameBase::setActive(%node,true);
							playSound(SoundCreateItem,$los::position);
							%boostObj.shieldNode=%node;
							%node.isGuarding=%boostObj;
							if(!$NodeSet[%team])
							{	if($trace) echo( $ver@"|Creating a Node Set for Team ",%team);
								$NodeSet[%team] = newObject("ShieldNodes",SimSet);
								addToSet("MissionCleanup", $NodeSet[%team]);
							}
							addToSet($NodeSet[%team],%node);
							%name=GameBase::GetDataName(%boostObj);
							if (!$ShieldGenOn[%team])
								Client::sendMessage(%client,0,"Shield Generator is destroyed or not deployed!!");
							Client::sendMessage(%client,0,"Remote Shield Node deployed - Shield activated on: "@%name);
							$TeamItemCount[GameBase::getTeam(%player) @ "AODShieldNode"]++;
							echo("MSG: ",$User[%client]," deployed a Remote Shield Node on ",%name);
							return true;						
						}
				}
				else 
				{	deleteObject(%set);
					if (%num>1)
					{	Client::sendMessage(%client,0,"Too Many Items in area - unable to obtain single interface");}
					else if (%num==0)
					{	Client::sendMessage(%client,0,"Nothing to interface to.\n Node Must be placed close to an object which will have its shield boosted.~Werror_message.wav");}
				}
				
			}
			else Client::sendMessage(%client,0,"Can only deploy on terrain/buildings or objects");
		}
		else Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	return false;
}


function RemoteShieldNode::onEndSequence(%this)
{	echo("Node on End sequence");
	if(%this.position==1)	
		GameBase::playSequence(%this,0,"power");
}

function RemoteShieldNode::onDestroyed(%this)
{	if($trace) echo( $ver@"|Remote Shield Node::On destroyed");
	%team=GameBase::getTeam(%this);
	$TeamItemCount[%team @ "AODShieldNode"]--;
	$totalNumNodes--;
	for(%i=0;%i<=Group::objectCount($NodeSet[%team]);%i++)
	{	%node=Group::GetObject($NodeSet[%team],%i);
		if(%node==%this)
		{	removeFromSet($NodeSet[%team], %i);
		}
	}
	%boostObj				= %this.isGuarding;
	%this.isGuarding		="";
	%boostObj.shieldNode	="";
						
	if ($ShieldGen[%team])
	{	if($trace) echo( $ver@"|Shield Gen Exists applying Node Feedback Damage");
		%pos1=GameBase::getPosition(%this);
		%pos2=GameBase::getPosition($ShieldGen[%team]);
		%vec=vector::sub(%pos1,%pos2);
		%damageLevel = GameBase::getDamageLevel($ShieldGen[%team]);
		NewStaticShapeDamage($ShieldGen[%team],%this,%damageLevel,0.35);
	}
}

function RemoteShieldNode::onDisabled(%this)
{	if($trace) echo( $ver@"|Remote Shield Node on Disabled");
	GameBase::setRechargeRate(%this,0);
	Gamebase::setEnergy(%this,0);
	%this.Position=0;
	GameBase::stopSequence(%this,0);
	GameBase::setSequenceDirection(%this,1,0);
	GameBase::playSequence(%this,1,"deploy");
	%this.shieldStrength = 0;
	
}

function RemoteShieldNode::onActivate(%this)
{	%team=GameBase::getTeam(%this);
	%this.shieldStrength = 0.03; //had 2
	if($ShieldGen[%team])
	{	if($ShieldGenOn[%team])
		{	GameBase::setActive(%this,true);
			%this.Position=1;
			GameBase::setSequenceDirection(%this,1,1);
			GameBase::playSequence(%this,1,"deploy");
			GameBase::setRechargeRate(%this,15);
			GameBase::playSequence(%this,1); 
		}
		else
			if($trace) echo($Ver,"| Shield Generator is Off!");

	}
	else
		if($trace) echo( $ver@"|Shield Generator Does Not Exist for This Team");
	
}

function RemoteShieldNode::onEnabled(%this)
{	RemoteShieldNode::onActivate(%this);
}

function RemoteShieldNode::onDeActivate(%this)
{	RemoteShieldNode::onDisabled(%this);
}

function RemoteShieldNode::packUp(%this, %pos, %client, %player)
{	if($trace) echo( $ver@"|Pack up Remote shield node");
	%name = Client::getName(%client);
	%team = Client::getTeam(%client);
	%pack=Player::getMountedItem(%player,$BackpackSlot);
	if($trace) echo( $ver@"|Player is wearing Pack Item :",%pack);
	if(%pack== -1)	// Must Have No Pack on....
	{	if($trace) echo( $ver@"|Shield Node Pickup Routine");
		if(!GameBase::getDamageLevel(%this))				// Node is Damaged
		{	if (!$ShieldGenOn[%team])
			{	Client::sendMessage(%client,0,"Shield Generator is destroyed or not deployed!!/nUnable to self-repair node..");
				return;
			}
			else
				Client::sendMessage(%client,0,"Shield Generator active\nRunning node self-repair.");
		}
		for(%i=0;%i<=Group::objectCount($NodeSet[%team]);%i++)
		{	%node=Group::GetObject($NodeSet[%team],%i);
			if(%node==%this)
			{	removeFromSet($NodeSet[%team], %i);
			}
		}
		%boostObj				=%this.isGuarding;
		%BoostObj.shieldNode	="";
		%this.isGuarding		="";
		%pos=vector::add(Gamebase::getPosition(%this),"0 0 0.5");
		%player.isDeploying = true;
		%player.deployPosition = %pos;
		GameBase::startFadeOut(%this);
		schedule("deleteObject(" @ %this @ ");",1.75,%this);			
		schedule("PlaceItemPack(" @ %player @ ",AODShieldNode,\"" @ %pos @ "\");",2,%player);
		RemoteShieldNode::onDisabled(%this);
		echo("MSG: ",%client," Packed up a remote Shield Node");
	}
	else
		Client::sendMessage(%client,0,"Unable to Pack up Node.. You are wearing a Pack!~wError_message.wav");
}

ItemImageData CNodeImage
{
        shapeFile = "sensor_small";
        mountPoint = 2;
        mountOffset = { 0, -0.12, -0.1 };
        mountRotation = { 0, 0, 0 };
        mass = 2.5;
        firstPerson = false;
};

ItemData CNode
{
        description = "Remote Cloaking Node";
        shapeFile = "sensor_small";
        className = "Backpack";
        heading = "jDeployables";
        imageType = CNodeImage;
        shadowDetailMask = 4;
        mass = 2.0;
        elasticity = 0.2;
        price = 1200;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function CNode::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function CNode::onDeploy(%player,%item,%pos)
{
        if (CNode::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}


function CNode::deployShape(%player,%item)
{
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,3)) {
                        %obj = getObjectType($los::object);
                        %data = GameBase::getDataName($los::object);
                        if ((%obj == "StaticShape" || %obj == "Turret" || %obj == "Sensor") && %data != "BlastDoorShape" && %data != "BlastFloorShape" && %data != "doorfivebyfiveForceFieldShape" && %data != "doorthreebyfourForceFieldShape" && %data != "doorfourbyeightForceFieldShape" && %data != "TowerSwitch") {
                                    %prot = GameBase::getRotation(%player);
                                %zRot = getWord(%prot,2);
                                if (Vector::dot($los::normal,"0 0 1") > 0.6) {
                                        %rot = "0 0 " @ %zRot;
                                } else {
                                        if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
                                                %rot = "3.14159 0 " @ %zRot;
                                        } else {
                                                %rot = Vector::getRotation($los::normal);
                                        }
                                }
                                %turret = newObject("","Sensor",CloakingNode,true);
                    addToSet("MissionCleanup", %turret);
                                GameBase::setTeam(%turret,GameBase::getTeam(%player));
                                GameBase::setPosition(%turret,$los::position);
                                GameBase::setRotation(%turret,%rot);
                                Gamebase::setMapName(%turret,"Cloaking Node");
                                Client::sendMessage(%client,0,"Cloaking Node deployed");
                                playSound(SoundPickupBackpack,$los::position);
                                $TeamItemCount[GameBase::getTeam(%player) @ "Hider"]++;
                                echo("MSG: ",%client," ",Client::getName(%client)," deployed a Cloaking Node");
                                GameBase::startFadeOut($los::object);
                                schedule("GameBase::startFadeOut("@%turret@");", 6, $los::object);
                                schedule("Item::hide("@%turret@", true);", 6, $los::object);
                                %turret.cloaked = $los::object;
                                return true;
                        } else {
                                Client::sendMessage(%client,0,"Cannot cloak this object");
                        }
                } else {
                        Client::sendMessage(%client,0,"Deploy position out of range");
                }
        } else {                                                                                                                                                                Client::sendMessage(%client,0,"Deployable item limit reached for " @ %item.description @ "s");
        }
        return false;
}

$InvList[CNode]        			   = 1;
$RemoteInvList[CNode]        		   = 0;
$TeamItemMax[CNode]        		   = 24;

$ItemMax[larmor, CNode]             = 1;
$ItemMax[lfemale, CNode]        	= 1;
$ItemMax[marmor, CNode]             = 1;
$ItemMax[mfemale, CNode]        	= 1;
$ItemMax[harmor, CNode]             = 1;

//------------------------------------
// ******* Power Node   *******
// -----------------------------------
$InvList[AODPowerNode]			= 1;
$RemoteInvList[AODPowerNode]		= 1;

$ItemMax[larmor, AODPowerNode]		= 1;
$ItemMax[marmor, AODPowerNode]		= 1;
$ItemMax[harmor, AODPowerNode]		= 1;
$ItemMax[lfemale, AODPowerNode]		= 1;
$ItemMax[mfemale, AODPowerNode]		= 1;

$TeamItemMax[AODPowerNode] = 50;

ItemImageData AODPowerNodeImage 
{	shapeFile		= "sensor_small";
	mountPoint		= 2;
	mountOffset		= { 0, -0.15, 0 };
	mountRotation	= {-1.570796327, 0 , 0};
	mass			= 1;
	firstPerson		= false;
};


ItemData AODPowerNode
{	description		= "Remote Power Node";
	shapeFile		= "sensor_small";
	classname		= "Backpack";
	heading =  "jDeployables";
	imageType		= AODPowerNodeImage;
	shadowDetailMask = 4;
	elasticity		= 0.2;
	price			= 750;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

StaticShapeData PowerNode 
{	description		= "Remote Power Node";
	shapeFile		= "sensor_small";
	classname		= "pGen";
	debrisId		= flashDebrisSmall;
	maxDamage		= 8;
	mapIcon			= "M_generator";
	damageSkinData	= "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId		= flashExpMedium;
	visibleToSensor = true;
	mapFilter		= 4;
	sequenceSound[0] = { "power", SoundSatNode };
};

function AODPowerNode::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {	Player::mountItem(%player,%item,$BackpackSlot);}
    else
	{	Player::deployItem(%player,%item);}
}

function AODPowerNode::onDeploy(%player,%item,%pos)
{	if (AODPowerNode::deployShape(%player,%item))
	{}
}

function AODPowerNode::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	%pNode=(DeployStuff(%player,%item,PowerNode,2,4,4,2,true,2,15));
	if(%pNode)
	{	%team=GameBase::getTeam(%pNode);
		if(!$PowerSatSet[%team])
		{	$PowerSatSet[%team]=newobject("set",SimSet);
			addtoSet("missionCleanup",$PowerSatSet[%team]);
		}
		addtoSet($PowerSatSet[%team],%pNode);
		PowerNode::onEnabled(%pNode);
		return (true);
	}
		
}

function PowerNode::onDestroyed(%this)
{	if($tracePwr) echo($ver,"|PowerNode::onDestroyed");
	%team=GameBase::GetTeam(%this);
	PowerNode::onDisabled(%this);
	DisconnectGenerator(%this);
	StaticShape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 3, 0.55, 0.30, 250, 170); 
	removeFromSet($PowerSatSet[%team],%this);
	$TeamItemCount[%team @ AODPowerNode]--;

}

function PowerNode::onEnabled(%this)
{	if($tracePwr) echo($ver,"|PowerNode::onEnabled");
	%team=GameBase::getTeam(%this);
	if(GameBase::getDamageState($PowerSat[%team])=="Enabled")
	{	if(GameBase::isPowered($PowerSat[%team]))
		{	GameBase::setActive(%this,true);
			GameBase::playSequence(%this,0,"power");
			GameBase::generatePower(%this, true);
			GameBase::isPowerGenerator(%this);
		}
	}
}

function PowerNode::onDisabled(%this)
{	if($tracePwr) echo($ver,"|PowerNode::onDisabled");
	GameBase::stopSequence(%this,0);
 	GameBase::generatePower(%this, false);
}


function PowerNode::packUp(%this, %pos, %client, %player)
{	if($trace) echo( $ver@"|PowerNode::Packup");
	if(%this.isBusy)
		return;
	PowerNode::onDisabled(%this);
	%time=DisconnectGenerator(%this)+1;
	schedule("PackNode("@%this@","@%client@","@%player@");",%time);
}

function PackNode(%this,%client,%player)
{	if(PackUpStuff(%this,%client,%player,"","Power Node",true,AODPowerNode)==false)
	{	PowerNode::onEnabled(%this);
		ConnectGenerator(%this);
	}
}

//----------------------------------------------------------------------------

ItemImageData PulseSensorPackImage
{
	shapeFile = "radar_small";
	mountPoint = 2;
	mountOffset = { 0, 0, 0.1 };
	mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData PulseSensorPack
{
	description = "Pulse Sensor";
	shapeFile = "radar_small";
	className = "Backpack";
   heading =  "jDeployables";
	imageType = PulseSensorPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 125;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function PulseSensorPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function PulseSensorPack::onDeploy(%player,%item,%pos)
{
	if (Item::deployShape(%player,"Pulse Sensor",DeployablePulseSensor,%item)) {
		Player::decItemCount(%player,%item);
		$TeamItemCount[GameBase::getTeam(%player) @ "PulseSensorPack"]++;
	}
}

ItemImageData DeployableSensorJamPackImage
{
	shapeFile = "sensor_jammer";
 	mountPoint = 2;
  	mountOffset = { 0, 0.03, 0.1 };
  	mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData DeployableSensorJammerPack
{
	description = "Sensor Jammer";
  	shapeFile = "sensor_jammer";
  	className = "Backpack";
   heading =  "jDeployables";
	imageType = DeployableSensorJamPackImage;
  	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
  	price = 225;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DeployableSensorJammerPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function DeployableSensorJammerPack::onDeploy(%player,%item,%pos)
{
	if (Item::deployShape(%player,"Sensor Jammer",DeployableSensorJammer,%item)) {
		Player::decItemCount(%player,%item);
		$TeamItemCount[GameBase::getTeam(%player) @ "DeployableSensorJammerPack"]++;
	}
}

ItemImageData MotionSensorPackImage
{
	shapeFile = "sensor_small";
	mountPoint = 2;
	mountOffset = { 0, 0, 0.1 };
	mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData MotionSensorPack
{
	description = "Motion Sensor";
	shapeFile = "sensor_small";
	className = "Backpack";
   heading =  "jDeployables";
	imageType = MotionSensorPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 125;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function MotionSensorPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function MotionSensorPack::onDeploy(%player,%item,%pos)
{
	if (MotionSensorPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
		$TeamItemCount[GameBase::getTeam(%player) @ "MotionSensorPack"]++;
	}
}

function MotionSensorPack::deployShape(%player,%item)
{
 	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
				%prot = GameBase::getRotation(%player);
				%zRot = getWord(%prot,2);
				if (Vector::dot($los::normal,"0 0 1") > 0.6) {
					%rot = "0 0 " @ %zRot;
				}
				else {
					if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
						%rot = "3.14159 0 " @ %zRot;
					}
					else {
						%rot = Vector::getRotation($los::normal);
					}
				}
				if(checkDeployArea(%client,$los::position)) {
					%mSensor = newObject("","Sensor",DeployableMotionSensor,true);
	   	      addToSet("MissionCleanup", %mSensor);
					GameBase::setTeam(%mSensor,GameBase::getTeam(%player));
					GameBase::setRotation(%mSensor,%rot);
					GameBase::setPosition(%mSensor,$los::position);
					Gamebase::setMapName(%mSensor,"Motion Sensor");
					Client::sendMessage(%client,0,"Motion Sensor deployed");
					playSound(SoundPickupBackpack,$los::position);
					echo("MSG: ",%client," deployed a Motion Sensor");
					return true;
				}
			}
			else {
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
			}
		}
		else {
			Client::sendMessage(%client,0,"Deploy position out of range");		
		}
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	
	return false;
}

ItemImageData CameraPackImage
{
	shapeFile = "camera";
	mountPoint = 2;
	mountOffset = { 0, -0.1, -0.06 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData CameraPack
{
	description = "Camera";
	shapeFile = "camera";
	className = "Backpack";
   heading =  "jDeployables";
	imageType = CameraPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 100;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function CameraPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function CameraPack::onDeploy(%player,%item,%pos)
{
	if (CameraPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function CameraPack::deployShape(%player,%item)
{
 	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
				%prot = GameBase::getRotation(%player);
				%zRot = getWord(%prot,2);
				if (Vector::dot($los::normal,"0 0 1") > 0.6) {
					%rot = "0 0 " @ %zRot;
				}
				else {
					if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
						%rot = "3.14159 0 " @ %zRot;
					}
					else {
						%rot = Vector::getRotation($los::normal);
					}
				}
				if(checkDeployArea(%client,$los::position)) {
					%camera = newObject("Camera","Turret",CameraTurret,true);
	   	      addToSet("MissionCleanup", %camera);
					GameBase::setTeam(%camera,GameBase::getTeam(%player));
					GameBase::setRotation(%camera,%rot);
					GameBase::setPosition(%camera,$los::position);
					Gamebase::setMapName(%camera,"Camera#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
					Client::sendMessage(%client,0,"Camera deployed");
					playSound(SoundPickupBackpack,$los::position);
					$TeamItemCount[GameBase::getTeam(%camera) @ "CameraPack"]++;
					echo("MSG: ",%client," deployed a Camera");
					return true;
				}
			}
			else {
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
			}
		}
		else {
			Client::sendMessage(%client,0,"Deploy position out of range");		
		}
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	
	return false;
}

ItemImageData DeployableInvPackImage
{
	shapeFile = "invent_remote";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData DeployableInvPack
{
	description = "Inventory Station";
	shapeFile = "invent_remote";
	className = "Backpack";
   heading =  "jDeployables";
	shadowDetailMask = 4	;
	imageType = DeployableInvPackImage;
	mass = 1.0;
	elasticity = 0.2;
	price = $RemoteInvEnergy + 200;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function DeployableInvPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function DeployableInvPack::onDeploy(%player,%item,%pos)
{
	if (DeployableInvPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}	

function DeployableInvPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
				if (Vector::dot($los::normal,"0 0 1") > 0.7) {
					if(checkDeployArea(%client,$los::position)) {
						%inv = newObject("ammounit_remote","StaticShape","DeployableInvStation",true);
 	 		         addToSet("MissionCleanup", %inv);
						%rot = GameBase::getRotation(%player); 
						GameBase::setTeam(%inv,GameBase::getTeam(%player));
						GameBase::setPosition(%inv,$los::position);
						GameBase::setRotation(%inv,%rot);
						Gamebase::setMapName(%inv,%name);
						Client::sendMessage(%client,0,"Inventory Station deployed");
						playSound(SoundPickupBackpack,$los::position);
						$TeamItemCount[GameBase::getTeam(%inv) @ "DeployableInvPack"]++;
						echo("MSG: ",%client," deployed an Inventory Station");
						return true;
					}
				}
				else {
					Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
				}
			}
			else {
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
			}
		}
		else {
			Client::sendMessage(%client,0,"Deploy position out of range");
		}
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	return false;
}

ItemImageData DeployableAmmoPackImage
{
	shapeFile = "ammounit_remote";
	mountPoint = 2;
	mountOffset = { 0, -0.1, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData DeployableAmmoPack
{
	description = "Ammo Station";
	shapeFile = "ammounit_remote";
	className = "Backpack";
   heading =  "jDeployables";
	shadowDetailMask = 4;
	imageType = DeployableAmmoPackImage;
	mass = 1.0;
	elasticity = 0.2;
	price = $RemoteAmmoEnergy;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function DeployableAmmoPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function DeployableAmmoPack::onDeploy(%player,%item,%pos)
{
	if (DeployableAmmoPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}	

function DeployableAmmoPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
				if (Vector::dot($los::normal,"0 0 1") > 0.7) {
					if(checkDeployArea(%client,$los::position)) {
						%inv = newObject("ammounit_remote","StaticShape","DeployableAmmoStation",true);
	         	   addToSet("MissionCleanup", %inv);
						%rot = GameBase::getRotation(%player); 
						GameBase::setTeam(%inv,GameBase::getTeam(%player));
						GameBase::setPosition(%inv,$los::position);
						GameBase::setRotation(%inv,%rot);
						Gamebase::setMapName(%inv,%name);
						Client::sendMessage(%client,0,"Ammo Station deployed");
						playSound(SoundPickupBackpack,$los::position);
						$TeamItemCount[GameBase::getTeam(%inv) @ "DeployableAmmoPack"]++;
						echo("MSG: ",%client," deployed an Ammo Station");
						return true;
					}
				}
				else 
					Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	return false;
}

$TeamItemCount[0 @ dummy] = 0;
$TeamItemCount[1 @ dummy] = 0;
$TeamItemCount[2 @ dummy] = 0;
$TeamItemCount[3 @ dummy] = 0;

$TeamItemMax[dummy] = 500;

$TeamItemCount[0 @ dummypack] = 0;
$TeamItemCount[1 @ dummypack] = 0;
$TeamItemCount[2 @ dummypack] = 0;
$TeamItemCount[3 @ dummypack] = 0;

$TeamItemMax[dummypack] = 10;

$ItemMax[harmor, dummypack] = 1;
$ItemMax[marmor, dummypack] = 1;
$ItemMax[mfemale, dummypack] = 1;
$ItemMax[larmor, dummypack] = 1;
$ItemMax[lfemale, dummypack] = 1;

$InvList[dummypack] = 1;
$RemoteInvList[dummypack] = 1;

ItemImageData DummyPackImage
{
        shapeFile = "armorpack";
        mountPoint = 2;
        mountOffset = { 0, -0.03, 0 };
        mass = 1.0;
        firstPerson = false;
};

ItemData DummyPack
{
        description = "Decoy Creator";
        shapeFile = "larmor";
        className = "Backpack";
        heading =  "jDeployables";
        imageType = DummyPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 900;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function DummyPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function DummyPack::onDeploy(%player,%item,%pos)
{
        if (DummyPack::deployShape(%player,%item)) {
       }
}

function DummyPack::deployShape(%player,%item)
{
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ "dummy"] < $TeamItemMax["dummy"]) {
                if (GameBase::getLOSInfo(%player,3)) {
                        %obj = getObjectType($los::object);

                                    %set = newObject("set",SimSet);
                                %num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$ForceFieldBoxMinLength,$ForceFieldBoxMinWidth,$ForceFieldBoxMinHeight,0);
                                %num = CountObjects(%set,"Hologram",%num);
                                deleteObject(%set);

                                        if (Vector::dot($los::normal,"0 0 1") > 0.7) {
                                                if(checkDeployArea(%client,$los::position)) {
                                                        %rot = GameBase::getRotation(%player);
                                                        %rnd = floor(getRandom() * 10);
                                                        if(%rnd > 6)

                                                           %fField = newObject("","StaticShape",Dummyl,true);
                                                        else
                                                                if((%rnd > 2) && (%rnd < 7))


                                                           %fField = newObject("","StaticShape",Dummym,true);
                                                        else


                                                           %fField = newObject("","StaticShape",Dummyh,true);

                                                        addToSet("MissionCleanup", %fField);
                                                        GameBase::setTeam(%fField,GameBase::getTeam(%player));
                                                        GameBase::setPosition(%fField,$los::position);
                                                        GameBase::setRotation(%fField,%rot);
                                                        Client::sendMessage(%client,0,"Hologram Deployed");
                                                        echo("MSG: ",%client," deployed a Hologram");
                                                        GameBase::startFadeIn(%fField);
                                                        playSound(Hologram,$los::position);


                                                        $TeamItemCount[GameBase::getTeam(%player) @ "dummy"]++;
                                                        return true;
                                                }
                                        }
                                        else
                                                Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
                                        }
                else
                        Client::sendMessage(%client,0,"Deploy position out of range");
        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}



$InvList[treepack] = 1;
$RemoteInvList[treepack] = 1;

$TeamItemCount[0 @ treepack] = 0;
$TeamItemCount[1 @ treepack] = 0;
$TeamItemCount[2 @ treepack] = 0;
$TeamItemCount[3 @ treepack] = 0;

$TeamItemMax[treepack] = 30;

$ItemMax[harmor, treepack] = 1;
$ItemMax[marmor, treepack] = 1;
$ItemMax[mfemale, treepack] = 1;
$ItemMax[larmor, treepack] = 0;
$ItemMax[lfemale, treepack] = 0;

ItemImageData TreePackImage
{
	shapeFile = "ammopack";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1;
	firstPerson = false;
};

ItemData TreePack
{
	description = "Tree Planter";
	shapeFile = "ammopack";
	className = "Backpack";
   heading =  "jDeployables";
	imageType = TreePackImage;
	shadowDetailMask = 4;
	mass = 1;
	elasticity = 0.1;
	price = 50;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function TreePack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function TreePack::onDeploy(%player,%item,%pos)
{
	if (TreePack::deployShape(%player,%item))
	{
		//Player::decItemCount(%player,%item); //thus infinite trees to plant
	}
}

function TreePack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item])
	{
		if (GameBase::getLOSInfo(%player,3))
		{
			%obj = getObjectType($los::object);
			if (%obj != "InteriorShape")
			{
					if(checkDeployArea(%client,$los::position))
					{
						%rot = GameBase::getRotation(%player);
						%tree = newObject("Tree","StaticShape",Tree,true);
                 				addToSet("MissionCleanup", %tree);
						GameBase::setTeam(%tree,GameBase::getTeam(%player));
						GameBase::setPosition(%tree,$los::position);
						GameBase::setRotation(%tree,%rot);
						Gamebase::setMapName(%tree,"Tree " @ Client::getName(%client));
						Client::sendMessage(%client,0,"Tree Planted");
						playSound(SoundPickupBackpack,$los::position);
						$TeamItemCount[GameBase::getTeam(%player) @ "TreePack"]++;
						echo("MSG: ",%client," planted a seed");
						//	Remote turrets - kill points to player that deploy them
						// Client::setOwnedObject(%client, %tree); 
						// Client::setOwnedObject(%client, %player);
						return true;
					}
			}
			else 
				Client::sendMessage(%client,0,"Cannot deploy in buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description);

	return false;
}

//************************************
// 	AODDefender Backpack Script
// 	(Defender Defense Turret)
//************************************

$InvList[AODDefender]			= 1;
$RemoteInvList[AODDefender]		= 1;
$TeamItemMax[AODDefender]		= 24;

$ItemMax[larmor, AODDefender]	= 1;
$ItemMax[lfemale, AODDefender]	= 1;
$ItemMax[marmor, AODDefender]	= 1;
$ItemMax[mfemale, AODDefender]	= 1;
$ItemMax[harmor, AODDefender]	= 1;

ItemImageData AODDefenderImage 
{	shapeFile	= "CAMERA";
	mountPoint	= 2;
	mass		= 2.0;
	firstPerson = false;
};

ItemData AODDefender 
{	description			= "Defender Designator";
	shapeFile			= "CAMERA";
	classname			= "Backpack";
	heading =  "pTurrets";
	imageType			= AODDefenderImage;
	shadowDetailMask	= 4;
	mass				= 3.0;
	elasticity			= 0.2;
	price				= 325;
	hudIcon				= "deployable";
	showWeaponBar		= true;
	hiliteOnActive		= true;
};

TurretData DefenderTurret 
{	classname			= "SensorNet";
	shapeFile			= "CAMERA";
	projectileType		= designatorX;
	maxDamage			= 0.75;
	maxEnergy			= 100;
	minGunEnergy		= 0.1;
	maxGunEnergy		= 1;
	sequenceSound[0]	= {"deploy", SoundActivateMotionSensor};
	reloadDelay			= 1;
	speed				= 4.5;
	speedModifier		= 1.5;
	range				= 200;
	visibleToSensor		= true;
	shadowDetailMask	= 4;
	dopplerVelocity		= 0;
	castLOS				= true;
	supression			= false;
	mapFilter			= 2;
	mapIcon				= "M_turret";
	debrisId			= flashDebrisSmall;
	shieldShapeName		= "shield";
	fireSound			= SoundFireDefender;
	activationSound		= SoundRemoteTurretOn;
	deactivateSound		= SoundRemoteTurretOff;
	explosionId			= flashExpMedium;
	description			= "Defender Turret";
	damageSkinData		= "objectDamageSkins";
	pinger				= false;
	lightColor			= { 0.75, 0.75, 0.85 };
};


function AODDefender::onUse(%player,%item)
{	%client = Player::getClient(%player);
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	Player::mountItem(%player,%item,$BackpackSlot);}
	else 
	{	Player::deployItem(%player,%item); }
}

function AODDefender::onDeploy(%player,%item,%pos)
{	if (AODDefender::deployShape(%player,%item)) 
	{	Player::decItemCount(%player,%item);}
}

function AODDefender::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	DeployStuff(%player,%item,DefenderTurret,1,4,1,1,true,false,0);
}

function DefenderTurret::packUp(%this, %pos, %client, %player)
{	%armor		= "";
	%desc		= "Defender Designator";
	%nopack		= false;			// does not have to have no pack on
	%pName	= AODDefender;

	PackUpStuff(%this,%client, %player,%armor,%desc,%nopack,%pName);
}

function DefenderTurret::onAdd(%this)
{	schedule("DefenderTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,10);
	%this.shieldStrength = 0.025;
	if (GameBase::getMapName(%this) == "") 
	{	GameBase::setMapName (%this, "Defender Turret");}
}

function DefenderTurret::deploy(%this)
{	GameBase::playSequence(%this,1,"deploy");
}

function DefenderTurret::onEndSequence(%this,%thread)
{	GameBase::setActive(%this,true);
}

function DefenderTurret::onDestroyed(%this)
{	Turret::onDestroyed(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "AODDefender"]--;
}

function DefenderTurret::onPower(%this,%power,%generator)
{}

function DefenderTurret::onEnabled(%this)
{	GameBase::setRechargeRate(%this,10);
	GameBase::setActive(%this,true);
}

//----------------------------------------------------------------------------
$InvList[TurretPack]			= 1;
$RemoteInvList[TurretPack]		= 1;
$TeamItemMax[TurretPack]		= 2;

$ItemMax[larmor, TurretPack]	= 0;
$ItemMax[lfemale, TurretPack]	= 0;
$ItemMax[marmor, TurretPack]	= 1;
$ItemMax[mfemale, TurretPack]	= 1;
$ItemMax[harmor, TurretPack]	= 1;
																			
ItemImageData TurretPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1;
	firstPerson = false;
};

ItemData TurretPack
{
	description = "Laser Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading =  "pTurrets";
	imageType = TurretPackImage;
	shadowDetailMask = 4;
	mass = 1;
	elasticity = 0.2;
	price = 350;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function TurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function TurretPack::onDeploy(%player,%item,%pos)
{
	if (TurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function CountObjects(%set,%name,%num) 
{
	%count = 0;
	for(%i=0;%i<%num;%i++) {
		%obj=Group::getObject(%set,%i);
		if(GameBase::getDataName(Group::getObject(%set,%i)) == %name) 
			%count++;
	}
	return %count;
}

function TurretPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
	    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMaxLength,$TurretBoxMaxWidth,$TurretBoxMaxHeight,0);
				%num = CountObjects(%set,"DeployableSentry",%num) + CountObjects(%set,"DeployableTurret",%num) + CountObjects(%set,"DeployableRocket",%num);

				deleteObject(%set);
				if($MaxNumTurretsInBox > %num) {
		    		%set = newObject("set",SimSet);
					%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMinLength,$TurretBoxMinWidth,$TurretBoxMinHeight,0);
					%num = CountObjects(%set,"DeployableSentry",%num) + CountObjects(%set,"DeployableTurret",%num) + CountObjects(%set,"DeployableRocket",%num);
					deleteObject(%set);
					if(0 == %num) {
						if (Vector::dot($los::normal,"0 0 1") > 0.7) {
							if(checkDeployArea(%client,$los::position)) {
								%rot = GameBase::getRotation(%player); 
								%turret = newObject("remoteTurret","Turret",DeployableTurret,true);
	                     addToSet("MissionCleanup", %turret);
								GameBase::setTeam(%turret,GameBase::getTeam(%player));
								GameBase::setPosition(%turret,$los::position);
								GameBase::setRotation(%turret,%rot);
								Gamebase::setMapName(%turret,"RMT Turret#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
								Client::sendMessage(%client,0,"Remote Turret deployed");
								playSound(SoundPickupBackpack,$los::position);
								$TeamItemCount[GameBase::getTeam(%player) @ "TurretPack"]++;
								echo("MSG: ",%client," deployed a Remote Turret");
						      Client::setOwnedObject(%client, %turret);
						      Client::setOwnedObject(%client, %player);
								return true;
							}
						}
						else 
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					} 
					else
						Client::sendMessage(%client,0,"Frequency Overload - Too close to other remote turrets");
				}
			   else 
					Client::sendMessage(%client,0,"Interference from other remote turrets in the area");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

//****************************************************
// AAOD Mod Deployable Kit
//************************************
// 	AODGrogPack Backpack Script
//	GROGTurret Script
// 	(Deployable Chaingun Turret)
// 	GrogShot

$InvList[AODGrogPack]			= 1;
$RemoteInvList[AODGrogPack]		= 1;
$TeamItemMax[AODGrogPack]		= 10;

$ItemMax[larmor, AODGrogPack]	= 0;
$ItemMax[lfemale, AODGrogPack]	= 0;
$ItemMax[marmor, AODGrogPack]	= 1;
$ItemMax[mfemale, AODGrogPack]	= 1;
$ItemMax[harmor, AODGrogPack]	= 1;

BulletData GrogShot
{	bulletShapeName = "bullet.DTS";
	explosionTag = bulletExp0;	
	expRandCycle	= 3;		
	mass = 1;				
	collisionRadius = 0.0;		
	bulletHoleIndex = 0;		
	ExplosionRadius = 0;		
	damageClass = 0;			
	damageValue = 0.12;			
	damageType = $ChaingunDamageType;
	aimDeflection = 0.005;		
	muzzleVelocity = 500.0;		
	totalTime = 0.5;			
	inheritedVelocityScale = 0.5;
	liveTime = 2.0;			
	isVisible = False;		
	tracerPercentage = 0.0;	
	tracerLength = 0;		
	detachFromShooter = false;		
	rotationPeriod = 0;			
	lightRange = 0.0;			
	lightColor = {1.0, 0.25,0.25};
};

ItemImageData AODGrogPackImage 
{	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1;
	firstPerson = false;
};

ItemData AODGrogPack 
{	description		= "Chaingun Turret";
	shapeFile		= "remoteturret";
	classname		= "Backpack";
	heading =  "pTurrets";
	imageType		= AODGrogPackImage;
	shadowDetailMask = 4;
	mass			= 3.0;
	elasticity		= 0.2;
	price			= 650;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive	= true;	
};

TurretData GROGTurret 
{ 	classname		= "Turret";
	shapeFile		= "remoteturret";
	projectileType	= GrogShot;
	maxDamage		= 1.15;
	maxEnergy		= 50;
	minGunEnergy	= 5;
	maxGunEnergy	= 5;
	sequenceSound[0]= {"deploy", SoundActivateMotionSensor};
	reloadDelay		= 0.25;
	speed			= 6.0;
	speedModifier	= 1.5;
	range			= 40;
	visibleToSensor = true;
	shadowDetailMask= 4;
	dopplerVelocity = 0;
	castLOS			= true;
	supression		= false;
	mapFilter		= 2;
	mapIcon			= "M_turret";
	debrisId		= flashDebrisMedium;
	shieldShapeName = "shield";
	fireSound		= SoundGrogFire;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId		= flashExpMedium;
	description		= "Chaingun Turret";
	damageSkinData	= "objectDamageSkins";
	pinger			= false;
};

function AODGrogPack::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	Player::mountItem(%player,%item,$BackpackSlot);	}
	else 
	{	Player::deployItem(%player,%item); }
}

function AODGrogPack::onDeploy(%player,%item,%pos)
{	if (AODGrogPack::deployShape(%player,%item)) 
	{	Player::decItemCount(%player,%item);}
}

function AODGrogPack::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PackName,PowerReq,PRange)
	DeployStuff(%player,%item,GROGTurret,1,3,1,0,true,false,0);
}


function GROGTurret::onAdd(%this)
{	schedule("GROGTurret::deploy(" @ %this @ ");",1,%this);
}

function GROGTurret::deploy(%this)
{	GameBase::playSequence(%this,1,"deploy");
}

function GROGTurret::onEndSequence(%this,%thread)
{	GameBase::setActive(%this,true);
}

function GROGTurret::onDestroyed(%this)
{	Turret::onDestroyed(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "AODGrogPack"]--;
}

function GROGTurret::onPower(%this,%power,%generator)
{
}

function GROGTurret::onEnabled(%this)
{	GameBase::setRechargeRate(%this,15);
	GameBase::setActive(%this,true);
	%this.shieldStrength = 0.0085;
}

function GROGTurret::packUp(%this, %pos, %client, %player)
{	%armor		= "m h";
	%desc		= "Chaingun turret";
	%nopack		= false;			// does not have to have no pack on
	%pName	= AODGrogPack;

	PackUpStuff(%this,%client, %player,%armor,%desc,%nopack,%pName);
}


//****************************************************
// AAOD Mod Deployable Kit
//************************************
// 	AODVelcroPack Backpack Script
//	VELCROTurret Script

$InvList[AODVelcroPack]			= 1;
$RemoteInvList[AODVelcroPack]		= 1;
$TeamItemMax[AODVelcroPack]		= 10;

$ItemMax[larmor, AODVelcroPack]	= 0;
$ItemMax[lfemale, AODVelcroPack]	= 0;
$ItemMax[marmor, AODVelcroPack]	= 1;
$ItemMax[mfemale, AODVelcroPack]	= 1;
$ItemMax[harmor, AODVelcroPack]	= 1;

ExplosionData velcroExp
{
   shapeName = "enex.dts";
   soundId   = energyExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 3.0;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.75, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.75, 1.0 };
   colors[2]  = { 0.5, 1.0,  0.5 };
   radFactors = { 1.0, 1.0,  1.0 };

   shiftPosition = True;
};

BulletData VelcroProjectile
{
   bulletShapeName  = "mortartrail.dts";
   explosionTag     = velcroExp;
   mass             = 0.05;
   damageClass      = 0;       // 0 impact, 1, radius
   damageValue      = 0.25;
   damageType       = $EnergyDamageType;
   muzzleVelocity   = 60.0;
   totalTime        = 4.0;
   liveTime         = 4.0;
   isVisible        = True;
   rotationPeriod	= 0.15;
};


ItemImageData AODVelcroPackImage 
{	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData AODVelcroPack 
{	description = "Velcro Turret";
	shapeFile = "remoteturret";
	classname = "Backpack";
	heading =  "pTurrets";
	imageType = AODVelcroPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 750;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

TurretData VELCROTurret 
{
 	classname		= "Turret";
	shapeFile		= "remoteturret";
	projectileType	= VelcroProjectile;
	maxDamage		= 0.70;
	maxEnergy		= 90;
	minGunEnergy	= 7.5;
	maxGunEnergy	= 15;
	sequenceSound[0] = {"deploy", SoundActivateMotionSensor};
	reloadDelay		= 0.75;
	speed			= 4.0;
	speedModifier	= 1.5;
	range			= 75;
	visibleToSensor = true;
	shadowDetailMask = 4;
	dopplerVelocity = 0;
	castLOS			= true;
	supression		= false;
	mapFilter		= 2;
	mapIcon			= "M_turret";
	debrisId		= flashDebrisMedium;
	shieldShapeName = "shield";
	fireSound		= SoundRemoteTurretFire;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId		= flashExpMedium;
	description		= "Velcro Turret";
	damageSkinData	= "objectDamageSkins";
	pinger			= false;
};


function AODVelcroPack::onUse(%player,%item)
{
 if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
{
Player::mountItem(%player,%item,$BackpackSlot);
}
else 
{
Player::deployItem(%player,%item);
 }
}

function AODVelcroPack::onDeploy(%player,%item,%pos)
{	if (AODVelcroPack::deployShape(%player,%item)) 
		Player::decItemCount(%player,%item);
}

function AODVelcroPack::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PackName,PowerReq,PRange)
	DeployStuff(%player,%item,VELCROTurret,1,4,1,1,true,false,0);
}


function VELCROTurret::onAdd(%this)
{	schedule("VELCROTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,10);
	%this.shieldStrength = 0.010;
	if (GameBase::getMapName(%this) == "") 
		GameBase::setMapName (%this, "Velcro Turret");
}

function VELCROTurret::deploy(%this)
{	GameBase::playSequence(%this,1,"deploy");
}

function VELCROTurret::onEndSequence(%this,%thread)
{	GameBase::setActive(%this,true);
}

function VELCROTurret::onDestroyed(%this)
{	Turret::onDestroyed(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "AODVelcroPack"]--;
}

function VELCROTurret::onPower(%this,%power,%generator)
{
}

function VELCROTurret::onEnabled(%this)
{	GameBase::setRechargeRate(%this,10);
	GameBase::setActive(%this,true);
}

function VELCROTurret::packUp(%this, %pos, %client, %player)
{	%armor		= "";
	%desc		= "Velcro turret";
	%nopack		= false;			// does not have to have no pack on
	%pName		= AODVelcroPack;

	PackUpStuff(%this,%client, %player,%armor,%desc,%nopack,%pName);
}

//----------------------------------------------------------------------------
// Flux Turret
//----------------------------------------------------------------------------
																			
ItemImageData FluxPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1;
	firstPerson = false;
};

ItemData FluxPack
{
	description = "EMP Blast Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading =  "pTurrets";
	imageType = FluxPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 1000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function FluxPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function FluxPack::onDeploy(%player,%item,%pos)
{
	if (FluxPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function FluxPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
	    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMaxLength,$TurretBoxMaxWidth,$TurretBoxMaxHeight,0);
				%num = CountObjects(%set,"DeployableSentry",%num) + CountObjects(%set,"DeployableTurret",%num) + CountObjects(%set,"DeployableRocket",%num);

				deleteObject(%set);
				if($MaxNumTurretsInBox > %num) {
		    		%set = newObject("set",SimSet);
					%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMinLength,$TurretBoxMinWidth,$TurretBoxMinHeight,0);
					%num = CountObjects(%set,"DeployableSentry",%num) + CountObjects(%set,"DeployableTurret",%num) + CountObjects(%set,"DeployableRocket",%num);
					deleteObject(%set);
					if(0 == %num) {
						if (Vector::dot($los::normal,"0 0 1") > 0.7) {
							if(checkDeployArea(%client,$los::position)) {
								%rot = GameBase::getRotation(%player); 
								%turret = newObject("remoteTurret","Turret",Fluxturret,true);
	                     addToSet("MissionCleanup", %turret);
								GameBase::setTeam(%turret,GameBase::getTeam(%player));
								GameBase::setPosition(%turret,$los::position);
								GameBase::setRotation(%turret,%rot);
								Gamebase::setMapName(%turret,"EMP Blast Turret#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
								Client::sendMessage(%client,0,"EMP Blast Turret deployed");
								playSound(SoundPickupBackpack,$los::position);
								$TeamItemCount[GameBase::getTeam(%player) @ "FluxPack"]++;
								echo("MSG: ",%client," deployed a Turret");
						      Client::setOwnedObject(%client, %turret);
						      Client::setOwnedObject(%client, %player);
								return true;
							}
						}
						else 
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					} 
					else
						Client::sendMessage(%client,0,"Frequency Overload - Too close to other remote turrets");
				}
			   else 
					Client::sendMessage(%client,0,"Interference from other remote turrets in the area");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

TurretData Fluxturret
{
	maxDamage = 0.75;
	maxEnergy = 60;
	minGunEnergy = 15;
	maxGunEnergy = 15;
	range = 150;
	gunRange = 300;
	visibleToSensor = true;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisLarge;
	className = "Turret";
	shapeFile = "remoteturret";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = SeekingRPEMP;
	reloadDelay = 1.5;
	fireSound = SoundMissileTurretFire;
	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
   targetableFovRatio = 0.5;
	explosionId = LargeShockwave;
	description = "EMP Blast Turret";
};

function FluxTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
      return "True";
   else
      return "False";
}

function Fluxturret::onAdd(%this)
{
	schedule("Fluxturret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,5);
	%this.shieldStrength = 0.01;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "EMP Blast Turret");
	}
}

function Fluxturret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function Fluxturret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function Fluxturret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "FluxPack"]--;
}

// Override base class just in case.
function Fluxturret::onPower(%this,%power,%generator) {}
function Fluxturret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,5);
	GameBase::setActive(%this,true);
}	

$InvList[FluxPack] = 1;
$RemoteInvList[FluxPack] = 1;

$TeamItemMax[FluxPack] = 2;

	$TeamItemCount[0 @ FluxPack] = 0;
	$TeamItemCount[1 @ FluxPack] = 0;
	$TeamItemCount[2 @ FluxPack] = 0;
	$TeamItemCount[3 @ FluxPack] = 0;

$ItemMax[marmor, FluxPack] = 1;
$ItemMax[mfemale, FluxPack] = 1;
$ItemMax[larmor, FluxPack] = 0;
$ItemMax[lfemale, FluxPack] = 0;
$ItemMax[harmor, FluxPack] = 0;


//----------------------------------------------------------------------------
// Ion Turret
//----------------------------------------------------------------------------

ItemImageData DisruptorTurretPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1;
	firstPerson = false;
};

ItemData DisruptorTurretPack
{
	description = "Ion Shockwave Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading =  "pTurrets";
	imageType = DisruptorTurretPackImage;
	shadowDetailMask = 4;
	mass = 1;
	elasticity = 0.2;
	price = 2000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DisruptorTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function DisruptorTurretPack::onDeploy(%player,%item,%pos)
{
	if (DisruptorTurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function DisruptorTurretPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
	    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMaxLength,$TurretBoxMaxWidth,$TurretBoxMaxHeight,0);
				%num = CountObjects(%set,"DisruptorTurret",%num);
				deleteObject(%set);
				if($MaxNumTurretsInBox > %num) {
		    		%set = newObject("set",SimSet);
					%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMinLength,$TurretBoxMinWidth,$TurretBoxMinHeight,0);
					%num = CountObjects(%set,"DisruptorTurret",%num);
					deleteObject(%set);
					if(0 == %num) {
						if (Vector::dot($los::normal,"0 0 1") > 0.7) {
							if(checkDeployArea(%client,$los::position)) {
								%rot = GameBase::getRotation(%player); 
								%turret = newObject("","Turret",DisruptorTurret,true);
	                     addToSet("MissionCleanup", %turret);
								GameBase::setTeam(%turret,GameBase::getTeam(%player));
								GameBase::setPosition(%turret,$los::position);
								GameBase::setRotation(%turret,%rot);
								Gamebase::setMapName(%turret,"Ion Shock Turret#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
								Client::sendMessage(%client,0,"Ion Shockwave Turret deployed");
								playSound(SoundPickupBackpack,$los::position);
								$TeamItemCount[GameBase::getTeam(%player) @ "DisruptorTurretPack"]++;
								echo("MSG: ",%client," deployed a Remote Turret");
								//	Remote turrets - kill points to player that deploy them
								Client::setOwnedObject(%client, %turret); 
								Client::setOwnedObject(%client, %player);
								return true;
							}
						}
						else 
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					} 
					else
						Client::sendMessage(%client,0,"Frequency Overload - Too close to other remote turrets");
				}
			   else 
					Client::sendMessage(%client,0,"Interference from other remote turrets in the area");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

TurretData DisruptorTurret
{
	maxDamage = 1.0;
	maxEnergy = 200;
	minGunEnergy = 25;
	maxGunEnergy = 25;
	reloadDelay = 1;
	fireSound = SoundPlasmaTurretFire;
	activationSound = SoundMortarTurretOn;
	deactivateSound = SoundMortarTurretOff;
	whirSound = SoundMortarTurretTurn;
	range = 150;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "mortar_turret";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = IonShock;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Ion Shockwave Turret";
};

function DisruptorTurret::onAdd(%this)
{
	schedule("DisruptorTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,15);
	%this.shieldStrength = 0.006;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Ion Turret");
	}
}

function DisruptorTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DisruptorTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DisruptorTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "DisruptorTurretPack"]--;
}

// Override base class just in case.
function DisruptorTurret::onPower(%this,%power,%generator) {}
function DisruptorTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,15);
	GameBase::setActive(%this,true);
}	

$InvList[DisruptorTurretPack] = 1;
$RemoteInvList[DisruptorTurretPack] = 1;

$TeamItemMax[DisruptorTurretPack] = 10;

	$TeamItemCount[0 @ DisruptorTurretPack] = 0;
	$TeamItemCount[1 @ DisruptorTurretPack] = 0;
	$TeamItemCount[2 @ DisruptorTurretPack] = 0;
	$TeamItemCount[3 @ DisruptorTurretPack] = 0;

$ItemMax[marmor, DisruptorTurretPack] = 1;
$ItemMax[mfemale, DisruptorTurretPack] = 1;
$ItemMax[larmor, DisruptorTurretPack] = 0;
$ItemMax[lfemale, DisruptorTurretPack] = 0;
$ItemMax[harmor, DisruptorTurretPack] = 0;

//----------------------------------------------------------------------------
// Mitzi Blast Turret
//----------------------------------------------------------------------------

ItemImageData IonTurretPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1;
	firstPerson = false;
};

ItemData IonTurretPack
{
	description = "Mitzi Blast Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading =  "pTurrets";
	imageType = IonTurretPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 3000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function IonTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function IonTurretPack::onDeploy(%player,%item,%pos)
{
	if (IonTurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function IonTurretPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
	    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMaxLength,$TurretBoxMaxWidth,$TurretBoxMaxHeight,0);
				%num = CountObjects(%set,"IonTurret",%num);
				deleteObject(%set);
				if($MaxNumTurretsInBox > %num) {
		    		%set = newObject("set",SimSet);
					%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMinLength,$TurretBoxMinWidth,$TurretBoxMinHeight,0);
					%num = CountObjects(%set,"IonTurret",%num);
					deleteObject(%set);
					if(0 == %num) {
						if (Vector::dot($los::normal,"0 0 1") > 0.7) {
							if(checkDeployArea(%client,$los::position)) {
								%rot = GameBase::getRotation(%player); 
								%turret = newObject("","Turret",IonTurret,true);
	                     addToSet("MissionCleanup", %turret);
								GameBase::setTeam(%turret,GameBase::getTeam(%player));
								GameBase::setPosition(%turret,$los::position);
								GameBase::setRotation(%turret,%rot);
								Gamebase::setMapName(%turret,"MB Turret#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
								Client::sendMessage(%client,0,"Mitzi Blast Turret deployed");
								playSound(SoundPickupBackpack,$los::position);
								$TeamItemCount[GameBase::getTeam(%player) @ "IonTurretPack"]++;
								echo("MSG: ",%client," deployed a Remote Turret");
								//	Remote turrets - kill points to player that deploy them
								Client::setOwnedObject(%client, %turret); 
								Client::setOwnedObject(%client, %player);
								return true;
							}
						}
						else 
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					} 
					else
						Client::sendMessage(%client,0,"Frequency Overload - Too close to other remote turrets");
				}
			   else 
					Client::sendMessage(%client,0,"Interference from other remote turrets in the area");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

TurretData IonTurret
{
	maxDamage = 1.0;
	maxEnergy = 300;
	minGunEnergy = 25;
	maxGunEnergy = 25;
	reloadDelay = 2;
	fireSound = capturedTower;
	activationSound = SoundMortarTurretOn;
	deactivateSound = SoundMortarTurretOff;
	whirSound = SoundMortarTurretTurn;
	range = 150;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "mortar_turret";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = IonShock3;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Mitzi Blast Turret";
};

function IonTurret::onAdd(%this)
{
	schedule("IonTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,15);
	%this.shieldStrength = 0.006;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Mitzi Blast Turret");
	}
}

function IonTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function IonTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function IonTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "IonTurretPack"]--;
}

// Override base class just in case.
function IonTurret::onPower(%this,%power,%generator) {}
function IonTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,15);
	GameBase::setActive(%this,true);
}	

$InvList[IonTurretPack] = 1;
$RemoteInvList[IonTurretPack] = 1;

$TeamItemMax[IonTurretPack] = 12;

	$TeamItemCount[0 @ IonTurretPack] = 0;
	$TeamItemCount[1 @ IonTurretPack] = 0;
	$TeamItemCount[2 @ IonTurretPack] = 0;
	$TeamItemCount[3 @ IonTurretPack] = 0;

$ItemMax[marmor, IonTurretPack] = 1;
$ItemMax[mfemale, IonTurretPack] = 1;
$ItemMax[larmor, IonTurretPack] = 0;
$ItemMax[lfemale, IonTurretPack] = 0;
$ItemMax[harmor, IonTurretPack] = 0;

//----------------------------------------------------------------------------
// Pulse Turret
//----------------------------------------------------------------------------

ItemImageData PulseTurretPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 0.5;
	firstPerson = false;
};

ItemData PulseTurretPack
{
	description = "Pulse Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading =  "pTurrets";
	imageType = PulseTurretPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.2;
	price = 950;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function PulseTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function PulseTurretPack::onDeploy(%player,%item,%pos)
{
	if (PulseTurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function PulseTurretPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
	    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMaxLength,$TurretBoxMaxWidth,$TurretBoxMaxHeight,0);
				%num = CountObjects(%set,"PulseTurret",%num);
				deleteObject(%set);
				if($MaxNumTurretsInBox > %num) {
		    		%set = newObject("set",SimSet);
					%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMinLength,$TurretBoxMinWidth,$TurretBoxMinHeight,0);
					%num = CountObjects(%set,"PulseTurret",%num);
					deleteObject(%set);
					if(0 == %num) {
						if (Vector::dot($los::normal,"0 0 1") > 0.7) {
							if(checkDeployArea(%client,$los::position)) {
								%rot = GameBase::getRotation(%player); 
								%turret = newObject("","Turret",PulseTurret,true);
	                     addToSet("MissionCleanup", %turret);
								GameBase::setTeam(%turret,GameBase::getTeam(%player));
								GameBase::setPosition(%turret,$los::position);
								GameBase::setRotation(%turret,%rot);
								Gamebase::setMapName(%turret,"PulseTurret#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
								Client::sendMessage(%client,0,"Pulse Turret deployed");
								playSound(SoundPickupBackpack,$los::position);
								$TeamItemCount[GameBase::getTeam(%player) @ "PulseTurretPack"]++;
								echo("MSG: ",%client," deployed a Remote Turret");
								//	Remote turrets - kill points to player that deploy them
								Client::setOwnedObject(%client, %turret); 
								Client::setOwnedObject(%client, %player);
								return true;
							}
						}
						else 
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					} 
					else
						Client::sendMessage(%client,0,"Frequency Overload - Too close to other remote turrets");
				}
			   else 
					Client::sendMessage(%client,0,"Interference from other remote turrets in the area");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

TurretData PulseTurret
{
	maxDamage = 1.0;
	maxEnergy = 150;
	minGunEnergy = 45;
	maxGunEnergy = 5;
	reloadDelay = 0.5;
	fireSound = SoundFireBlaster;
	activationSound = SoundPlasmaTurretOn;
	deactivateSound = SoundPlasmaTurretOff;
	whirSound = SoundPlasmaTurretTurn;
	range = 200;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "hellfiregun";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = pulseBolt;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Pulse Turret";
};

function PulseTurret::onAdd(%this)
{
	schedule("PulseTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,15);
	%this.shieldStrength = 0.006;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Pulse Turret");
	}
}

function PulseTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function PulseTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function PulseTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "PulseTurretPack"]--;
}

// Override base class just in case.
function PulseTurret::onPower(%this,%power,%generator) {}
function PulseTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,15);
	GameBase::setActive(%this,true);
}

$InvList[PulseTurretPack] = 1;
$RemoteInvList[PulseTurretPack] = 1;

$TeamItemMax[PulseTurretPack] = 10;

	$TeamItemCount[0 @ PulseTurretPack] = 0;
	$TeamItemCount[1 @ PulseTurretPack] = 0;
	$TeamItemCount[2 @ PulseTurretPack] = 0;
	$TeamItemCount[3 @ PulseTurretPack] = 0;

$ItemMax[marmor, PulseTurretPack] = 1;
$ItemMax[mfemale, PulseTurretPack] = 1;
$ItemMax[larmor, PulseTurretPack] = 0;
$ItemMax[lfemale, PulseTurretPack] = 0;
$ItemMax[harmor, PulseTurretPack] = 0;

//----------------------------------------------------------------------------
// Disc Turret
//----------------------------------------------------------------------------

ItemImageData DiscPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 0.5;
	firstPerson = false;
};

ItemData DiscTurretPack
{
	description = "Disc Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading =  "pTurrets";
	imageType = DiscPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.2;
	price = 700;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DiscTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function DiscTurretPack::onDeploy(%player,%item,%pos)
{
	if (DiscTurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function DiscTurretPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
	    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMaxLength,$TurretBoxMaxWidth,$TurretBoxMaxHeight,0);
				%num = CountObjects(%set,"DiscTurret",%num);
				deleteObject(%set);
				if($MaxNumTurretsInBox > %num) {
		    		%set = newObject("set",SimSet);
					%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMinLength,$TurretBoxMinWidth,$TurretBoxMinHeight,0);
					%num = CountObjects(%set,"DiscTurret",%num);
					deleteObject(%set);
					if(0 == %num) {
						if (Vector::dot($los::normal,"0 0 1") > 0.7) {
							if(checkDeployArea(%client,$los::position)) {
								%rot = GameBase::getRotation(%player); 
								%turret = newObject("","Turret",DiscTurret,true);
	                     addToSet("MissionCleanup", %turret);
								GameBase::setTeam(%turret,GameBase::getTeam(%player));
								GameBase::setPosition(%turret,$los::position);
								GameBase::setRotation(%turret,%rot);
								Gamebase::setMapName(%turret,"Disc Turret#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
								Client::sendMessage(%client,0,"Disc Turret deployed");
								playSound(SoundPickupBackpack,$los::position);
								$TeamItemCount[GameBase::getTeam(%player) @ "DiscTurretPack"]++;
								echo("MSG: ",%client," deployed a Remote Turret");
								//	Remote turrets - kill points to player that deploy them
								Client::setOwnedObject(%client, %turret); 
								Client::setOwnedObject(%client, %player);
								return true;
							}
						}
						else 
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					} 
					else
						Client::sendMessage(%client,0,"Frequency Overload - Too close to other remote turrets");
				}
			   else 
					Client::sendMessage(%client,0,"Interference from other remote turrets in the area");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

TurretData DiscTurret
{
	maxDamage = 1.0;
	maxEnergy = 100;
	minGunEnergy = 45;
	maxGunEnergy = 5;
	reloadDelay = 0.5;
	fireSound = SoundFireDisc;
	activationSound = SoundPlasmaTurretOn;
	deactivateSound = SoundPlasmaTurretOff;
	whirSound = SoundPlasmaTurretTurn;
	range = 100;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "chainturret";
	shieldShapeName = "shield_medium";
	speed = 1.0;
	speedModifier = 2.0;
	projectileType = TurretDiscShell;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Disc Turret";
};

function DiscTurret::onAdd(%this)
{
	schedule("DiscTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,8);
	%this.shieldStrength = 0.006;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Disc Turret");
	}
}

function DiscTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DiscTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DiscTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "DiscTurretPack"]--;
}

// Override base class just in case.
function DiscTurret::onPower(%this,%power,%generator) {}
function DiscTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,8);
	GameBase::setActive(%this,true);
}

$InvList[DiscTurretPack] = 1;
$RemoteInvList[DiscTurretPack] = 1;

$TeamItemMax[DiscTurretPack] = 12;

	$TeamItemCount[0 @ DiscTurretPack] = 0;
	$TeamItemCount[1 @ DiscTurretPack] = 0;
	$TeamItemCount[2 @ DiscTurretPack] = 0;
	$TeamItemCount[3 @ DiscTurretPack] = 0;

$ItemMax[marmor, DiscTurretPack] = 1;
$ItemMax[mfemale, DiscTurretPack] = 1;
$ItemMax[larmor, DiscTurretPack] = 0;
$ItemMax[lfemale, DiscTurretPack] = 0;
$ItemMax[harmor, DiscTurretPack] = 0;

//----------------------------------------------------------------------------
// PBW Turret
//----------------------------------------------------------------------------

ItemImageData ElectroTurretPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1.5;
	firstPerson = false;
};

ItemData ElectroTurretPack
{
	description = "PBW Turret";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading =  "pTurrets";
	imageType = ElectroTurretPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.2;
	price = 10000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function ElectroTurretPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function ElectroTurretPack::onDeploy(%player,%item,%pos)
{
	if (ElectroTurretPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function ElectroTurretPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape") {
	    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMaxLength,$TurretBoxMaxWidth,$TurretBoxMaxHeight,0);
				%num = CountObjects(%set,"AntiTurret",%num);
				deleteObject(%set);
				if($MaxNumTurretsInBox > %num) {
		    		%set = newObject("set",SimSet);
					%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$TurretBoxMinLength,$TurretBoxMinWidth,$TurretBoxMinHeight,0);
					%num = CountObjects(%set,"ElectroTurret",%num);
					deleteObject(%set);
					if(0 == %num) {
						if (Vector::dot($los::normal,"0 0 1") > 0.7) {
							if(checkDeployArea(%client,$los::position)) {
								%rot = GameBase::getRotation(%player); 
								%turret = newObject("","Turret",AntiTurret,true);
	                     addToSet("MissionCleanup", %turret);
								GameBase::setTeam(%turret,GameBase::getTeam(%player));
								GameBase::setPosition(%turret,$los::position);
								GameBase::setRotation(%turret,%rot);
								Gamebase::setMapName(%turret,"PBW Turret#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
								Client::sendMessage(%client,0,"PBW Turret (manual control) deployed");
								playSound(SoundPickupBackpack,$los::position);
								$TeamItemCount[GameBase::getTeam(%player) @ "ElectroTurretPack"]++;
								echo("MSG: ",%client," deployed a Remote Turret");
								//	Remote turrets - kill points to player that deploy them
								Client::setOwnedObject(%client, %turret); 
								Client::setOwnedObject(%client, %player);
								return true;
							}
						}
						else 
							Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
					} 
					else
						Client::sendMessage(%client,0,"Frequency Overload - Too close to other remote turrets");
				}
			   else 
					Client::sendMessage(%client,0,"Interference from other remote turrets in the area");
			}
			else 
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

TurretData AntiTurret
{
	maxDamage = 1.0;
	maxEnergy = 320;
	minGunEnergy = 160;
	maxGunEnergy = 160;
	reloadDelay = 1.5;
	fireSound = SoundPBWBreakSoundBarrier;
	activationSound = SoundPlasmaTurretOn;
	deactivateSound = SoundPlasmaTurretOff;
	whirSound = SoundPlasmaTurretTurn;
	range = 200;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "hellfiregun";
	shieldShapeName = "shield_medium";
	speed = 3.0;
	speedModifier = 2.0;
	projectileType = ParticleBeam;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "PBW Turret";
};

function AntiTurret::onAdd(%this)
{
	schedule("AntiTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,15);
	%this.shieldStrength = 0;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "PBW Turret");
	}
}

function AntiTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function AntiTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function AntiTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "ElectroTurretPack"]--;
}

// Override base class just in case.
function AntiTurret::onPower(%this,%power,%generator) {}
function AntiTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,15);
	GameBase::setActive(%this,true);
}

$InvList[ElectroTurretPack] = 1;
$RemoteInvList[ElectroTurretPack] = 1;

$TeamItemMax[ElectroTurretPack] = 12;

	$TeamItemCount[0 @ ElectroTurretPack] = 0;
	$TeamItemCount[1 @ ElectroTurretPack] = 0;
	$TeamItemCount[2 @ ElectroTurretPack] = 0;
	$TeamItemCount[3 @ ElectroTurretPack] = 0;

$ItemMax[marmor, ElectroTurretPack] = 1;
$ItemMax[mfemale, ElectroTurretPack] = 1;
$ItemMax[larmor, ElectroTurretPack] = 0;
$ItemMax[lfemale, ElectroTurretPack] = 0;
$ItemMax[harmor, ElectroTurretPack] = 0;

//---------------------------------
// 	AODArtilleryPack Backpack Script
//---------------------------------
$InvList[AODArtilleryPack]		= 1;
$RemoteInvList[AODArtilleryPack]	= 0;
$TeamItemMax[AODArtilleryPack]		= 10;

$ItemMax[larmor, AODArtilleryPack]		= 0;
$ItemMax[lfemale, AODArtilleryPack]	= 0;
$ItemMax[marmor, AODArtilleryPack]		= 1;
$ItemMax[mfemale, AODArtilleryPack]	= 1;
$ItemMax[harmor, AODArtilleryPack]		= 1;

ExplosionData ArtilleryExp
{	shapeName		= "Tumult_large.dts";
	soundId			=  SoundArtilleryExplosion;
	faceCamera		= true;				
	randomSpin		= false;			
	hasLight			= true;			
	lightRange		= 15.0;			
	timeZero			= 0.0;			
	timeOne			= 0.500;			
	colors[0]		= {0.5,0.4,0.2};
	colors[1]		= {0.5,0.7,0.5};
	colors[2]		= {0.0,1.0,0.0};
	radFactors		= {0.5,1.0,0.0};
	shiftPosition	= False;			
};


GrenadeData ArtilleryShell
{	bulletShapeName			= "mortar.dts";
	explosionTag			= ArtilleryExp;
	collideWithOwner		= True;
	ownerGraceMS			= 250;
	collisionRadius			= 0.3;
	mass					= 15.0;
	elasticity				= 0.0001;
	damageClass				= 1;     
	damageValue				= 1.50;	
	damageType				= $MortarDamageType;	
	explosionRadius			= 35;			
	kickBackStrength		= 450.0;		
	maxLevelFlightDist		= 650;		
	totalTime				= 30.0;
	liveTime				= 0.25;
	projSpecialTime			= 0.01;
	inheritedVelocityScale	= 0.5;
	smokeName				= "smoke.dts";
	soundId					= SoundArtilleryShot;
};



ItemImageData AODArtilleryPackImage 
{	shapeFile		= "magcargo";
	mountPoint		= 2;
	mountOffset		= { 0, -0.65, -0.4 };
	mountRotation	= { 0, 0, 0 };
	mass				= 3.0;
	firstPerson		= false;
};

ItemData AODArtilleryPack 
{	description		= "Artillery Turret";
	shapeFile		= "Mortar_Turret";
	classname		= "Backpack";
	heading =  "pTurrets";
	imageType		= AODArtilleryPackImage;
	shadowDetailMask = 4;
	mass			= 3.0;
	elasticity		= 0.2;
	price			= 9500;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive = true;
};

TurretData ArtilleryTurret 
{	classname		= "Turret";
	shapeFile		= "Mortar_Turret";
	projectileType	= ArtilleryShell;
	maxDamage		= 1.5;
	maxEnergy		= 100;
	minGunEnergy	= 25;
	maxGunEnergy	= 30;
	sequenceSound[0]= {"deploy", SoundActivateMotionSensor};
	reloadDelay		= 1.0;
	speed			= 6.0;
	speedModifier	= 1.5;
	range			= 0;
	visibleToSensor = true;
	shadowDetailMask= 4;
	dopplerVelocity = 0;
	castLOS			= true;
	supression		= false;
	mapFilter		= 2;
	mapIcon			= "M_turret";
	debrisId		= flashDebrisLarge;
	shieldShapeName = "shield";
	fireSound		= SoundArtilleryFire;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId		= flashExpMedium;
	description		= "Artillery Turret";
	damageSkinData	= "objectDamageSkins";
	pinger			= false;
};


function AODArtilleryPack::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item) 
	{	Player::mountItem(%player,%item,$BackpackSlot);}
	else 
	{	Player::deployItem(%player,%item);}
}

function AODArtilleryPack::onDeploy(%player,%item,%pos)
{	if (AODArtilleryPack::deployShape(%player,%item)) 
	{	Player::decItemCount(%player,%item);}
}

function AODArtilleryPack::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete,PowerReq,PRange)
	DeployStuff(%player,%item,ArtilleryTurret,1,5,1,0,true,true,100);
}

function ArtilleryTurret::onDestroyed(%this)
{	ArtilleryTurret::onDisabled(%this);
	if(%this.isMarked)
	{	// Object is Marked as a target...Unmark it when it is Unmounted
		// if($trace) Echo("Object is ",%ctrlObject," has an attached enemy target beacon");
		deleteObject(%this.isMarked);
		%this.isMarked=false;
	}
	
	Turret::onDestroyed(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "AODArtilleryPack"]--;
}

function ArtilleryTurret::packUp(%this, %pos, %client, %player)
{	%armor		= "h";
	%desc		= "Artillery turret";
	%nopack		= true;			// does not have to have no pack on
	%pName	= AODArtilleryPack;

	PackUpStuff(%this,%client, %player,%armor,%desc,%nopack,%pName);
}

function ArtilleryTurret::onEnabled(%this)
{	if(GameBase::isPowered(%this))
	{	GameBase::setRechargeRate(%this,15);
		%this.shieldStrength = 0.005;
		GameBase::setActive(%this,true);
	}
}

function ArtilleryTurret::onDisabled(%this)
{	GameBase::setRechargeRate(%this,0);
	%this.shieldStrength = 0.0;
	GameBase::setActive(%this,false);
}

function ArtilleryTurret::onPower(%this,%power,%gen)
{	if(%power)
		ArtilleryTurret::onEnabled(%this);
	else
		ArtilleryTurret::onDisabled(%this);
}

//--------------------------------------------------------------------------------------------------------
// Teleport Pads - Shane Hyde
//--------------------------------------------------------------------------------------------------------

$TeamItemMax[TeleportPack] = 2;
$TeamItemMax[DeployableTeleport] = 2;

$InvList[TeleportPack] = 1;
$RemoteInvList[TeleportPack] = 1;

$ItemMax[marmor, TeleportPack] = 1;
$ItemMax[mfemale, TeleportPack] = 1;
$ItemMax[larmor, TeleportPack] = 0;
$ItemMax[lfemale, TeleportPack] = 0;
$ItemMax[harmor, TeleportPack] = 1;


ItemImageData TeleportPackImage
{
        shapeFile = "mineammo";
        mountPoint = 2;
        mountOffset = { 0, 0, 0.1 };
        mountRotation = { 1.57, 0, 0 };
        firstPerson = false;
};

ItemData TeleportPack
{
        description = "Teleport Pad";
        shapeFile = "mineammo";
        className = "Backpack";
    heading                        = "jDeployables";
        imageType = TeleportPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 3200;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function TeleportPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function TeleportPack::onDeploy(%player,%item,%pos)
{
        if (teleportPack::deployShape(%player,"Teleport Pad",DeployableTeleport,%item)) {
                Player::decItemCount(%player,%item);
                $TeamItemCount[GameBase::getTeam(%player) @ "DeployableTeleport"]++;
        }
}

function CreateteleportSimSet()
{
    %teleset = nameToID("MissionCleanup/Teleports");
        if(%teleset == -1)
        {
                newObject("Teleports",SimSet);
                addToSet("MissionCleanup","Teleports");
        }
}

function TeleportPack::deployShape(%player,%name,%shape,%item)
{
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ "DeployableTeleport"] < $TeamItemMax[DeployableTeleport]) {
                if (GameBase::getLOSInfo(%player,3)) {
                        // GetLOSInfo sets the following globals:
                        //         los::position
                        //         los::normal
                        //         los::object
                        %obj = getObjectType($los::object);
                        if (%obj == "SimTerrain" || %obj == "InteriorShape") {
                                if (Vector::dot($los::normal,"0 0 1") > 0.7) {
                                        if(checkDeployArea(%client,$los::position)) {
                                                %sensor = newObject("Teleport Pad","StaticShape",%shape,true);
                                                CreateteleportSimSet();
				                        addToSet("MissionCleanup/Teleports", %sensor);
                        			      addToSet("MissionCleanup", %sensor);
                                                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                                                %pos = Vector::add($los::position,"0 0 -0.4");
                                                GameBase::setPosition(%sensor,%pos);
                                                Gamebase::setMapName(%sensor,%name);
                                                Client::sendMessage(%client,0,%item.description @ " deployed");
                                                %sensor.disabled = false;
                                                playSound(SoundPickupBackpack,$los::position);

                                                %beam = newObject("","StaticShape",ElectricalBeamBig,true);
								addToSet("MissionCleanup", %beam);
                                                GameBase::setTeam(%beam,GameBase::getTeam(%player));
                                                GameBase::setPosition(%beam,%pos);
								GameBase::startFadeIn(%beam);
                                                %sensor.beam1 = %beam;

                                                %topsensor = newObject("","Sensor",DeployablePulseSensor,true);
                        			      addToSet("MissionCleanup", %topsensor);
				                        addToSet("MissionCleanup/Teleports", %topsensor);
                                                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                                                %pos = Vector::add($los::position,"0 0 4.4");
                                                GameBase::setPosition(%topsensor,%pos);
                                                Gamebase::setMapName(%topsensor,%name);
                                                %sensor.topPad = %topsensor;
                                                return true;
                                        }
                                }
                                else
                                        Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
                        }
                        else
                                Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
                }
                else
                        Client::sendMessage(%client,0,"Deploy position out of range");
        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %name @ "s");
        return false;
}

StaticShapeData DeployableTeleport 
{ 
	className = "DeployableTeleport"; 
	damageSkinData = "objectDamageSkins"; 
	shapeFile = "mineammo"; 
	maxDamage = 3; 
	maxEnergy = 200; 
	mapFilter = 2; 
	visibleToSensor = true; 
	explosionId = mortarExp; 
	debrisId = flashDebrisLarge; 
	lightRadius = 12.0; 
	lightType = 2; 
	lightColor = {1.0,0.2,0.2}; 
};

StaticShapeData TopPad 
{ 
	className = "DeployableTeleport"; 
	damageSkinData = "objectDamageSkins"; 
	shapeFile = "mineammo"; 
	maxDamage = 19.9; 
	maxEnergy = 200; 
	mapFilter = 2; 
	visibleToSensor = true; 
	explosionId = largeShockwave; 
	debrisId = flashDebrisLarge; 
	lightRadius = 12.0; 
	lightType = 2; 
	lightColor = {1.0,0.2,0.2}; 
   description = "Teleport Pad";
};

function RemoveBeam(%b) 
{ 
	deleteObject(%b); 
} 

function DeployableTeleport::onDestroyed(%this) 
{ 
	schedule("RemoveBeam("@%this.beam1@");",0.5); 
	schedule("RemoveBeam("@%this.topPad@");",0.5);
	$TeamItemCount[GameBase::getTeam(%this) @ "DeployableTeleport"]--; 
	%teleset = nameToID("MissionCleanup/Teleports"); 
	for(%i = 0; (%o = Group::getObject(%teleset, %i)) != -1; %i++) 
	{ 
		if(GameBase::getTeam(%o) == GameBase::getTeam(%this) && %o != %this) 
		{ 
			GameBase::applyDamage(%o,$DebrisDamageType,25,GameBase::getPosition(%o),"0 0 0","0 0 0",%this); 
			return; 
		} 
	} 
}

function DeployableTeleport::onCollision(%this, %obj) 
{ 
	if($Collided == true)
		return;

	if(getObjectType(%obj) != "Player") 
		return; 

	if(Player::isDead(%obj)) 
		return; 

	%c = Player::getClient(%obj); 
	%playerTeam = GameBase::getTeam(%obj); 
	%teleTeam = GameBase::getTeam(%this); 

	if(%teleTeam != %playerTeam) 
	{ 
		Client::SendMessage(%c,1,"Warning! Wrong team!~werror_message.wav"); 
		return; 
	} 

	if(%this.disabled == true) 
	{ 
		Client::SendMessage(%c,3,"Teleporter is recharging."); 
		return; 
	} 

	%teleset = nameToID("MissionCleanup/Teleports"); 

	for(%i = 0; (%o = Group::getObject(%teleset, %i)) != -1; %i++) 
	{ 
            if(GameBase::getTeam(%o) == %playerteam && %o != %this) 
		{
			%camera = Client::getObserverCamera(%c);
			%t1pos = Vector::add(GameBase::getPosition(%this),"0 0 1");
			$Collided = true;

			GameBase::setPosition(%obj,%t1pos);
			Client::setControlObject(%c, %camera);
			Observer::setOrbitObject(%c, %this, 3, 3, 3);
			GameBase::startFadeOut(%obj);

			schedule("doTeleport("@%obj@","@%this@","@%o@");",2.5,%obj);
		}
	}
}

function DeployableTeleport::Reenable(%this) 
{
	GameBase::startFadeIn(%this.beam1);
	%this.disabled = false; 
	GameBase::playSound(%this,ForceFieldClose,0);
} 

function doTeleport(%player,%tele1,%tele2)
{
	%client = Player::getClient(%player);
	%tele1.Disabled = true; 
	%tele2.Disabled = true; 
	
	%t2pos = Vector::add(GameBase::getPosition(%tele2),"0 0 1");
	GameBase::startFadeOut(%tele1.beam1);
	GameBase::startFadeOut(%tele2.beam1);
	GameBase::playSound(%tele1,enterdimension,0); 
	GameBase::playSound(%tele2,enterdimension,0); 
	GameBase::SetPosition(%player,%t2pos);
	GameBase::startFadeIn(%player);
	Observer::setOrbitObject(%client, %tele2, 3, 3, 3);

	schedule("DeployableTeleport::Reenable("@%tele1@");",5); 
	schedule("DeployableTeleport::Reenable("@%tele2@");",5); 
	schedule("finishTeleport("@%player@");",2.5);

	return; 
}

function finishTeleport(%player)
{
	%client = Player::getClient(%player);
	$Collided = false;

	Client::setControlObject(%client, %player);
}

//***********************************
// AAOD Mobile Inventory Pack
//***********************************

$InvList[AODMobileInv]        = 1;
$RemoteInvList[AODMobileInv] = 0;
$TeamItemMax[AODMobileInv]        = 2;

$ItemMax[larmor, AODMobileInv]        = 0;
$ItemMax[lfemale, AODMobileInv]        = 0;
$ItemMax[marmor, AODMobileInv]        = 1;
$ItemMax[mfemale, AODMobileInv]        = 1;
$ItemMax[harmor, AODMobileInv]        = 1;

ItemImageData AODMobileInvImage
{        shapeFile        = "MagCargo";
        mountPoint        = 2;
        mountOffset = { 0, -0.65, -0.4 };
        firstPerson = false;
};

ItemData AODMobileInv
{        description                = "Mobile Inventory Stn";
        shapeFile                = "inventory_sta";
        classname                = "Backpack";
        heading                        = "jDeployables";
        imageType                = AODMobileInvImage;
        shadowDetailMask = 4;
        elasticity                = 0.2;
        price                        = 5000;
        hudIcon                        = "deployable";
        showWeaponBar        = true;
        hiliteOnActive        = true;
};

StaticShapeData MobileInvent
{  description                = "Mobile Supply Unit";
        shapeFile                = "inventory_sta";
        classname                = "station";
        visibleToSensor = true;
        sequenceSound[0] = { "activate", SoundActivateInventoryStation };
        sequenceSound[1] = { "power", SoundInventoryStationPower };
        sequenceSound[2] = { "use", SoundUseInventoryStation };
        maxDamage                = 1.5;
        debrisId                = flashDebrisLarge;
        mapFilter                = 4;
        mapIcon                        = "M_station";
        damageSkinData        = "objectDamageSkins";
        shadowDetailMask = 16;
        triggerRadius        = 1.5;
        explosionId                = flashExpLarge;
        shieldShapeName = "shield";

};


function AODMobileInv::onUse(%player,%item)
{        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {        Player::mountItem(%player,%item,$BackpackSlot);}
    else
        {        Player::deployItem(%player,%item);}
}

function AODMobileInv::onDeploy(%player,%item,%pos)
{        if (AODMobileInv::deployShape(%player,%item))
        {        Player::decItemCount(%player,%item);

        }
}

function AODMobileInv::deployShape(%player,%item)
{        //        Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
        DeployStuff(%player,%item,MobileInvent,1,5,0,0,true,1,200);

}


function MobileInvent::onEndSequence(%this,%thread)
{
        if (Station::onEndSequence(%this,%thread))
                InventoryStation::onResupply(%this,"InvList");
}

//-------------------------------
// ******* Mobile Generator *****
//-------------------------------
$TeamItemMax[AODMobileGen]		= 2;
$InvList[AODMobileGen]		= 1;
$RemoteInvList[AODMobileGen]	= 1;

$ItemMax[larmor, AODMobileGen]		= 0;
$ItemMax[lfemale, AODMobileGen]		= 0;
$ItemMax[marmor, AODMobileGen]	= 1;
$ItemMax[mfemale, AODMobileGen]	= 1;
$ItemMax[harmor, AODMobileGen]		= 1;

ItemImageData AODMobileGenImage 
{	shapeFile	= "generator_p";
	mountPoint	= 2;
	mountOffset = { 0, -0.65, -0.4 };
	mas			= 5.0;
	firstPerson = false;
};


ItemData AODMobileGen
{	description		= "Mobile Generator";
	shapeFile		= "generator_p";
	classname		= "Backpack";
	heading			= "jDeployables";
	imageType		= AODMobileGenImage;
	shadowDetailMask = 4;
	mass			= 4.5;
	elasticity		= 0.2;
	price			= 2500;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

StaticShapeData MobileGen 
{	description		= "Generator Booster";
	shapeFile		= "generator_p";
	classname		= "pGen";
	debrisId		= flashDebrisSmall;
	sfxAmbient		= SoundGeneratorPower;
	maxDamage		= 1.8;
	mapIcon			= "M_generator";
	damageSkinData	= "objectDamageSkins";
	shadowDetailMask = 16;
	explosionId		= flashExpMedium;
	visibleToSensor = true;
	mapFilter		= 4;
	shieldShapeName = "shield";
		
};


function AODMobileGen::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {	Player::mountItem(%player,%item,$BackpackSlot);}
    else
	{	Player::deployItem(%player,%item);}
}

function AODMobileGen::onDeploy(%player,%item,%pos)
{	if (AODMobileGen::deployShape(%player,%item))
	{	Player::decItemCount(%player,%item);
		
	}
}

function AODMobileGen::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	DeployStuff(%player,%item,MobileGen,1,5,0,0,false,2,350);
	
}

function MobileGen::onAdd(%this)
{}

function MobileGen::onDestroyed(%this)
{	if($trace) echo($ver,"| MobileGen::onDestroyed");
	MobileGen::onDisabled(%this);
	StaticShape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 3, 0.55, 0.30, 250, 170); 
}

function MobileGen::onEnabled(%this)
{	if($trace) echo($ver,"| MobileGen::onEnabled ",%this);
	GameBase::setActive(%this,true);
	GameBase::playSequence(%this,0,"power");
	GameBase::generatePower(%this, true);
	GameBase::isPowerGenerator(%this);
}

function MobileGen::onDisabled(%this)
{	if($trace) echo($ver,"| MobileGen::onDisabled ",%this);
	GameBase::stopSequence(%this,0);
 	GameBase::generatePower(%this, false);
}

//---------------------------------
// ******* Shield Generator *******
//---------------------------------
//  	Shield Power Functions
// --------------------------------
$InvList[AODShieldGen]		= 1;
$RemoteInvList[AODShieldGen]	= 0;
$TeamItemMax[AODShieldGen]		= 1;

$ItemMax[larmor, AODShieldGen]		= 0;
$ItemMax[lfemale, AODShieldGen]	= 0;
$ItemMax[marmor, AODShieldGen]		= 1;
$ItemMax[mfemale, AODShieldGen]	= 1;
$ItemMax[harmor, AODShieldGen]		= 1;

ItemImageData AODShieldGenImage 
{	shapeFile		= "MagCargo";
	mountPoint		= 2;
	mountOffset		= { 0, -0.65, -0.4 };
	mountRotation	= { 0, 0, 0 };
	mass			= 5.0;
	firstPerson		= false;
};


ItemData AODShieldGen
{	description		= "Shield Generator";
	shapeFile		= "generator";
	classname		= "Backpack";
	heading			= "jDeployables";
	imageType		= AODShieldGenImage;
	shadowDetailMask = 4;
	elasticity		= 0.2;
	price			= 1500;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

StaticShapeData ShieldGen 
{	description			= "Shield Generator";
	shapeFile			= "generator";
	classname			= "ShieldGen";
	debrisId			= flashDebrisLarge;
	maxDamage			= 1.8;
	mapIcon				= "M_generator";
	damageSkinData		= "objectDamageSkins";
	shadowDetailMask	= 16;
	explosionId			= LargeShockWave;
	visibleToSensor		= true;
	mapFilter			= 4;
	shieldShapeName		= "shield";
	sequenceSound[0] = { "enable", SoundFabGenStart };
	sequenceSound[1] = { "power", SoundShieldGenerator };
};


function AODShieldGen::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {	Player::mountItem(%player,%item,$BackpackSlot);}
    else
	{	Player::deployItem(%player,%item);}
}

function AODShieldGen::onDeploy(%player,%item,%pos)
{	if (AODShieldGen::deployShape(%player,%item))
	{	Player::decItemCount(%player,%item);
		
	}
}

function AODShieldGen::deployShape(%player,%item)
{	//	Deploy ( Player, item, shape, placement, Max Dist, Categorys, Surfaces, Delete, PowerReq,PRange)
	%gen=DeployStuff(%player,%item,ShieldGen,1,5,0,0,false,1,196);
	if(%gen)
	{	%team=GameBase::getTeam(%player);
		$ShieldGen[%team]=%gen;
		$ShieldGenOn[%team]=true;
		if($trace) echo( $ver@"|NodeSet for this team is ",$NodeSet[%team]);
		if(!$NodeSet[%team])
		{	if($trace) echo( $ver@"|Creating a Node Set for Team ",%team);
			$NodeSet[%team] = newObject("ShieldNodes",SimSet);
			addToSet("MissionCleanup", $NodeSet[%team]);
		}

	}
}

function ShieldGen::onAdd(%this)
{}

function ShieldGen::onEnabled(%this)
{	if($trace) echo( $ver@"|Shield Gen OnEnabled");
	%team=GameBase::getTeam(%this);
	if(%this.destroyed==true)
	{	// Was destroyed but is no longer - Has been repaired
		%this.destroyed=false;
	}
	if(GameBase::isPowered(%this))
	{	GameBase::playSequence(%this,0,"power");
		if (%team!=-1)
		{	$ShieldGenOn[%team]=true;
			ActivateNodes(true,%team);
		}
	}
}

function ShieldGen::onDestroyed(%this)
{	if($trace) echo( $ver@"|ShieldGen::onDestroyed");
	%team=GameBase::getTeam(%this);
	if($ShieldGenOn[%team])
		ShieldGen::onDisabled(%this);

	$ShieldGen[%team]=false;
	StaticShape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 8.5, 0.10, 55, 23, 3, 1.5, 1.0, 250, 170); 
}

function ShieldGen::onDisabled(%this)
{	if($trace) echo( $ver@"|ShieldGen::onDisabled");
	%team=GameBase::getTeam(%this);
	GameBase::stopSequence(%this,0);
 	$ShieldGenOn[%team]=false;
	ActivateNodes(false,%team);
}

function ShieldGen::onPower(%this, %state, %generator)
{	if($trace) echo($ver,"|ShieldGen::onPower this|state|generator ",%this,%state,%generator);
	if(%state)
		ShieldGen::OnEnabled(%this);
	else
		ShieldGen::OnDisabled(%this);
}

function ActivateNodes(%status,%team)
{	if($trace) echo( $ver@"|Activate Shield Nodes for Team ",%team);
	%num=$TeamItemCount[%team @ AODShieldNode];
	if (%num>0)
	{	for(%i=0;%i<%num;%i++)
		{	%node=Group::GetObject($NodeSet[%team],%i);
			if($trace) echo( $ver@"|Node ID is:",%node);
			if (%status==true)
			{	if($trace) echo( $ver@"|Activating Node :",%i);
				if($trace) echo( $ver@"|Node ID = ",%node);
				RemoteShieldNode::onActivate(%node);}
			else
			{	if($trace) echo( $ver@"|DeActivating Node :",%i);
				if($trace) echo( $ver@"|Node ID = ",%node);
				RemoteShieldNode::onDeActivate(%node);}
		}
	}
	else
		if($trace) echo( $ver@"|No Nodes to Activate");
}

$TeamItemMax[EpodV] = 1024;

//------------------------------------
// ******* Portable Launch Pad *******
// -----------------------------------
$InvList[AccelPPack]			= 1;
$RemoteInvList[AccelPPack]		= 1;

$ItemMax[larmor, AccelPPack]	= 1;
$ItemMax[marmor, AccelPPack]	= 1;
$ItemMax[harmor, AccelPPack]	= 1;
$ItemMax[lfemale, AccelPPack]	= 1;
$ItemMax[mfemale, AccelPPack]	= 1;

$TeamItemMax[AccelPPack] = 12;

$TeamItemCount[0 @ AccelPPack] = 0;
$TeamItemCount[1 @ AccelPPack] = 0;
$TeamItemCount[2 @ AccelPPack] = 0;
$TeamItemCount[3 @ AccelPPack] = 0;

StaticShapeData AccelPadPack
{
className = "AccelPadPack";
damageSkinData = "objectDamageSkins";
shapeFile = "elevator_6x6_octagon";
maxDamage = 3.33333;
maxEnergy = 200;
mapFilter = 2;
visibleToSensor = true;
explosionId = debrisExpLarge;
debrisId = flashDebrisLarge;
lightRadius = 12.0;
lightType=2;
lightColor = {1.0,0.2,0.2};
side = "single";
isTranslucent = false;
};
function AccelPadPack::Destruct(%this)
{
AccelPadPack::doDamage(%this);
}
function AccelPadPack::doDamage(%this) {
}
function AccelPadPack::onDestroyed(%this)
{
AccelPadPack::doDamage(%this);
$TeamItemCount[GameBase::getTeam(%this) @ "AccelPadPack"]--;
}
function AccelPadPack::onCollision(%this,%obj)
{
if(getObjectType(%obj) != "Player") {return;}
if(Player::isDead(%obj)) {return;}
%c = Player::getClient(%obj);
%pteam = GameBase::getTeam(%obj);
%oteam = GameBase::getTeam(%this);
%diffZ=getWord(GameBase::getPosition(%obj),2)-getWord(GameBase::getPosition(%this),2);
%tpos=GameBase::getPosition(%this);
%opos=GameBase::getPosition(%obj);
%tstartX=getWord(%tpos,0);
%tstartY=getWord(%tpos,1);
%tstartZ=getWord(%tpos,2);
%ostartX=getWord(%opos,0);
%ostartY=getWord(%opos,1);
%ostartZ=getWord(%opos,2);
%diffX=%ostartX-%tstartX;
%diffY=%ostartY-%tstartY;
%diffZ=%ostartZ-%tstartZ;
if(%pteam==%oteam) {
if(%obj.deployStandby!=1) {
if(%diffZ>0.950) {
%obj.deployStandby=1;
%msg="<f1>Jump Pad CPU: <f0>Face the direction you want to go, then jump or use your jets to thrust.  You may walk off the platform to avoid being thrusted.";
remoteEval(%c, "BP", %msg, 0);
AccelPadPack::CheckPlayer(%this,%obj);
}
} else if(%diffZ<0.950) {
remoteEval(%c, "CP", "", 0);
%obj.deployStandby=0;
}
}
return;
}
function AccelPadPack::CheckPlayer(%this,%obj) {
%tpos=GameBase::getPosition(%this);
%opos=GameBase::getPosition(%obj);
%tstartX=getWord(%tpos,0);
%tstartY=getWord(%tpos,1);
%tstartZ=getWord(%tpos,2);
%ostartX=getWord(%opos,0);
%ostartY=getWord(%opos,1);
%ostartZ=getWord(%opos,2);
%diffX=%ostartX-%tstartX;
%diffY=%ostartY-%tstartY;
%diffZ=%ostartZ-%tstartZ-0.92;
%deploy=0;
%recall=1;
if(%diffZ>0.5) %deploy=1;
if(%diffZ<0) %deploy=-1;
%client=Player::getClient(%obj);
if(%deploy>0) {
%armor=GameBase::getDataName(%obj);
%mass=%armor.mass;
%rot=GameBase::getRotation(%obj);
%len=50;
%zlen=50;
%rnd=floor(getrandom()*30);
if(%rnd>24 && %rnd<29) {
playSound(debrisMediumExplosion,%tpos);
%len+=15;
%zlen+=20;
} else if(%rnd>28) {
playSound(debrisLargeExplosion,%tpos);
%len+=200;
%zlen+=220;
} else {
playSound(debrisSmallExplosion,%tpos);
}
%vec=Vector::getFromRot(%rot,%len*%mass,%zlen*%mass);
Player::applyImpulse(%obj,%vec);
schedule(%obj@".deployStandby=0;",0.1);
%recall=0;
} else if(%deploy<0) {
%recall=0;
%obj.deployStandby=0;
}
if(%recall) {
schedule("AccelPadPack::CheckPlayer("@%this@","@%obj@");",0.05);
} else {
remoteEval(%client, "CP", "", 0);
}
}
ItemImageData AccelPPackImage
{
shapeFile = "shieldpack";
mountPoint = 2;
firstPerson = false;
};
ItemData AccelPPack
{
description = "Accel Pad";
shapeFile = "elevator_6x6_octagon";
className = "Backpack";
heading =  "jDeployables";
imageType = AccelPPackImage;
shadowDetailMask = 4;
mass = 2.0;
elasticity = 0.2;
price = 950;
hudIcon = "deployable";
showWeaponBar = true;
hiliteOnActive = true;
};
function AccelPPack::onUse(%player,%item)
{
if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
Player::mountItem(%player,%item,$BackpackSlot);
}
else {
Player::deployItem(%player,%item);
}
}
function AccelPPack::onDeploy(%player,%item,%pos)
{
if (AccelPPack::deployShape(%player,"AccelPad",AccelPadPack,%item)) {
Player::decItemCount(%player,%item);
$TeamItemCount[GameBase::getTeam(%player) @ "AccelPPack"]++;
}
}
function CreateAccelPadSimSet()
{
%teleset = nameToID("MissionCleanup/AccelPadPack");
if(%teleset == -1)
{
newObject("AccelPadPack",SimSet);
addToSet("MissionCleanup","AccelPadPack");
}
}
function AccelPPack::deployShape(%player,%name,%shape,%item)
{
%client = Player::getClient(%player);
if($TeamItemCount[GameBase::getTeam(%player) @ "AccelPPack"] < $TeamItemMax[AccelPPack]) {
if (GameBase::getLOSInfo(%player,3)) {
%obj = getObjectType($los::object);
if (Vector::dot($los::normal,"0 0 1") > 0.7) {
%sensor = newObject("AccelPadPack","StaticShape",%shape,true);
CreateAccelPadSimSet();
addToSet("MissionCleanup/AccelPadPack", %sensor);
addToSet("MissionCleanup", %sensor);
GameBase::setTeam(%sensor,GameBase::getTeam(%player));
%pos = Vector::add($los::position,"0 0 -0.25");
GameBase::setPosition(%player,Vector::add(%pos,"0 0 1"));
GameBase::setPosition(%sensor,%pos);
%Rot=GameBase::getRotation(%player);
%Rot=Vector::add(%Rot,"0 0 3.14159");
GameBase::setRotation(%sensor,%rot);
GameBase::setPosition(%sensor,%pos);
Gamebase::setMapName(%sensor,"Accel Pad");
Client::sendMessage(%client,0,%item.description @ " deployed");
echo("MSG: ",%client," deployed an Accelerator Pad ");
%sensor.disabled = false;
%sensor.activated=false;
GameBase::startFadeIn(%sensor);
playSound(SoundPickupBackpack,$los::position);
GameBase::startfadein(%sensor);
return true;
}
else
Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
}
else {
Client::sendMessage(%client,0,"Deploy position out of range");
}
}
else
Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %name @ "s");
return false;
}

//===============================================================================================
// Force field doors Blast Door
//===============================================================================================

ItemImageData doorthreebyfourForceFieldPackImage
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.0;
        firstPerson = false;
};

ItemData doorthreebyfourForceFieldPack
{
        description = "3x4 Forcefield";
        shapeFile = "AmmoPack";
        className = "Backpack";
        heading = "nBarriers";
        imageType = doorthreebyfourForceFieldPackImage;
        shadowDetailMask = 4;
        mass = 1.5;
        elasticity = 0.2;
        price = 250;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function doorthreebyfourForceFieldPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function doorthreebyfourForceFieldPack::onDeploy(%player,%item,%pos)
{
        if (doorthreebyfourForceFieldPack::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}

function doorthreebyfourForceFieldPack::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,3)) {

                        %obj = getObjectType($los::object);
                                %rot = GameBase::getRotation(%player);

                                        %camera = newObject("doorthreebyfourForceFieldPack","StaticShape",doorthreebyfourForceFieldShape,true);
                                        addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
                                        GameBase::setRotation(%camera,%rot);
                                        GameBase::setPosition(%camera,$los::position);
                                        Gamebase::setMapName(%camera,"3x4 Force Field Door#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
                                        Client::sendMessage(%client,0,"3x4 Force Field Door deployed");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%camera) @ "doorthreebyfourForceFieldPack"]++;
                                        echo("MSG: ",%client," deployed a 3x4 Force Field Door ");
                                        return true;

                        }
                       else {
                                Client::sendMessage(%client,0,"Cannot deploy here.");
                        }

        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}

StaticShapeData doorthreebyfourForceFieldShape
{
className = "LargeForceField";
damageSkinData = "objectDamageSkins";
shapeFile = "forcefield_3x4";
maxDamage = 56.25;
maxEnergy = 200;
mapFilter = 2;
visibleToSensor = true;
explosionId = mortarExp;
debrisId = flashDebrisLarge;
lightRadius = 12.0;
lightType=2;
lightColor = {1.0,0.2,0.2};
side = "single";
isTranslucent = true;
description = "3x4 Field Door";
};
function doorthreebyfourForceFieldShape::Destruct(%this)
{
doorthreebyfourForceFieldShape::doDamage(%this);
}
function doorthreebyfourForceFieldShape::doDamage(%this) {
calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}
function doorthreebyfourForceFieldShape::onDestroyed(%this)
{
doorthreebyfourForceFieldShape::doDamage(%this);
$TeamItemCount[GameBase::getTeam(%this) @ "LargeForceField"]--;
}
function doorthreebyfourForceFieldShape::onCollision(%this,%obj)
{
if(getObjectType(%obj)!="Player" || Player::isDead(%obj)) {
return;
}
%c = Player::getClient(%obj);
%playerTeam = GameBase::getTeam(%obj);
%fieldTeam = GameBase::getTeam(%this);
if(%fieldTeam != %playerTeam)
{
return;
}
doorthreebyfourForceFieldShape::openDoor(%this);
return;
}
function doorthreebyfourForceFieldShape::openDoor(%this) {

GameBase::startfadeout(%this);

%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 6");
GameBase::setPosition(%this,%pos);
schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
schedule("doorthreebyfourForceFieldShape::closeDoor("@%this@");",4);
}
function doorthreebyfourForceFieldShape::closeDoor(%this) {
%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 -6");
GameBase::setPosition(%this,%pos);
GameBase::startfadein(%this);
schedule("GameBase::playSound("@%this@",ForceFieldClose,0);",0.15);

}

function doorthreebyfourForceFieldShape::openDoor(%this) {

GameBase::startfadeout(%this);

%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 6");
GameBase::setPosition(%this,%pos);
schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
schedule("doorthreebyfourForceFieldShape::closeDoor("@%this@");",4);
}

$TeamItemMax[doorthreebyfourForceFieldPack] = 1024;

$InvList[doorthreebyfourForceFieldPack] = 1;
$RemoteInvList[doorthreebyfourForceFieldPack] = 1;

	$TeamItemCount[0 @ doorthreebyfourForceFieldPack] = 0;
	$TeamItemCount[1 @ doorthreebyfourForceFieldPack] = 0;
	$TeamItemCount[2 @ doorthreebyfourForceFieldPack] = 0;
	$TeamItemCount[3 @ doorthreebyfourForceFieldPack] = 0;

$ItemMax[marmor, doorthreebyfourForceFieldPack] = 1;
$ItemMax[mfemale, doorthreebyfourForceFieldPack] = 1;
$ItemMax[larmor, doorthreebyfourForceFieldPack] = 0;
$ItemMax[lfemale, doorthreebyfourForceFieldPack] = 0;
$ItemMax[harmor, doorthreebyfourForceFieldPack] = 0;

//=============================================================================================

ItemImageData doorfivebyfiveForceFieldPackImage
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.5;
        firstPerson = false;
};

ItemData doorfivebyfiveForceFieldPack
{
        description = "5x5 Forcefield";
        shapeFile = "AmmoPack";
        className = "Backpack";
        heading = "nBarriers";
        imageType = doorfivebyfiveForceFieldPackImage;
        shadowDetailMask = 4;
        mass = 1.5;
        elasticity = 0.2;
        price = 500;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function doorfivebyfiveForceFieldPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function doorfivebyfiveForceFieldPack::onDeploy(%player,%item,%pos)
{
        if (doorfivebyfiveForceFieldPack::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}

function doorfivebyfiveForceFieldPack::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,3)) {

                        %obj = getObjectType($los::object);
                                %rot = GameBase::getRotation(%player);

                                        %camera = newObject("doorfivebyfiveForceFieldPack","StaticShape",doorfivebyfiveForceFieldShape,true);
                                        addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
                                        GameBase::setRotation(%camera,%rot);
                                        GameBase::setPosition(%camera,$los::position);
                                        Gamebase::setMapName(%camera,"5x5 Force Field Door#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
                                        Client::sendMessage(%client,0,"5x5 Force Field Door deployed");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%camera) @ "doorfivebyfiveForceFieldPack"]++;
                                        echo("MSG: ",%client," deployed a 5x5 Force Field Door ");
                                        return true;

                        }
                       else {
                                Client::sendMessage(%client,0,"Cannot deploy here.");
                        }

        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}

StaticShapeData doorfivebyfiveForceFieldShape
{
className = "LargeForceField";
damageSkinData = "objectDamageSkins";
shapeFile = "forcefield_5x5";
maxDamage = 40.5;
maxEnergy = 200;
mapFilter = 2;
visibleToSensor = true;
explosionId = mortarExp;
debrisId = flashDebrisLarge;
lightRadius = 12.0;
lightType=2;
lightColor = {1.0,0.2,0.2};
side = "single";
isTranslucent = true;
description = "5x5 Field Door";
};
function doorfivebyfiveForceFieldShape::Destruct(%this)
{
doorfivebyfiveForceFieldShape::doDamage(%this);
}
function doorfivebyfiveForceFieldShape::doDamage(%this) {
calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}
function doorfivebyfiveForceFieldShape::onDestroyed(%this)
{
doorfivebyfiveForceFieldShape::doDamage(%this);
$TeamItemCount[GameBase::getTeam(%this) @ "LargeForceField"]--;
}
function doorfivebyfiveForceFieldShape::onCollision(%this,%obj)
{
if(getObjectType(%obj)!="Player" || Player::isDead(%obj)) {
return;
}
%c = Player::getClient(%obj);
%playerTeam = GameBase::getTeam(%obj);
%fieldTeam = GameBase::getTeam(%this);
if(%fieldTeam != %playerTeam)
{
return;
}
doorfivebyfiveForceFieldShape::openDoor(%this);
return;
}
function doorfivebyfiveForceFieldShape::openDoor(%this) {

GameBase::startfadeout(%this);

%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 6");
GameBase::setPosition(%this,%pos);
schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
schedule("doorfivebyfiveForceFieldShape::closeDoor("@%this@");",4);
}
function doorfivebyfiveForceFieldShape::closeDoor(%this) {
%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 -6");
GameBase::setPosition(%this,%pos);
GameBase::startfadein(%this);
schedule("GameBase::playSound("@%this@",ForceFieldClose,0);",0.15);

}

function doorfivebyfiveForceFieldShape::openDoor(%this) {

GameBase::startfadeout(%this);

%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 6");
GameBase::setPosition(%this,%pos);
schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
schedule("doorfivebyfiveForceFieldShape::closeDoor("@%this@");",4);
}

$TeamItemMax[doorfivebyfiveForceFieldPack] = 1024;

$InvList[doorfivebyfiveForceFieldPack] = 1;
$RemoteInvList[doorfivebyfiveForceFieldPack] = 1;

	$TeamItemCount[0 @ doorfivebyfiveForceFieldPack] = 0;
	$TeamItemCount[1 @ doorfivebyfiveForceFieldPack] = 0;
	$TeamItemCount[2 @ doorfivebyfiveForceFieldPack] = 0;
	$TeamItemCount[3 @ doorfivebyfiveForceFieldPack] = 0;

$ItemMax[marmor, doorfivebyfiveForceFieldPack] = 1;
$ItemMax[mfemale, doorfivebyfiveForceFieldPack] = 1;
$ItemMax[larmor, doorfivebyfiveForceFieldPack] = 0;
$ItemMax[lfemale, doorfivebyfiveForceFieldPack] = 0;
$ItemMax[harmor, doorfivebyfiveForceFieldPack] = 0;

//=============================================================================================

ItemImageData doorfourbyeightForceFieldPackImage
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.5;
        firstPerson = false;
};

ItemData doorfourbyeightForceFieldPack
{
        description = "4x8 Forcefield";
        shapeFile = "AmmoPack";
        className = "Backpack";
          heading = "nBarriers";
        imageType = doorfourbyeightForceFieldPackImage;
        shadowDetailMask = 4;
        mass = 1.5;
        elasticity = 0.2;
        price = 1000;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function doorfourbyeightForceFieldPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function doorfourbyeightForceFieldPack::onDeploy(%player,%item,%pos)
{
        if (doorfourbyeightForceFieldPack::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}

function doorfourbyeightForceFieldPack::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,3)) {

                        %obj = getObjectType($los::object);
                                %rot = GameBase::getRotation(%player);

                                        %camera = newObject("doorfourbyeightForceFieldPack","StaticShape",doorfourbyeightForceFieldShape,true);
                                        addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
                                        GameBase::setRotation(%camera,%rot);
                                        GameBase::setPosition(%camera,$los::position);
                                        Gamebase::setMapName(%camera,"4x8 Force Field Door#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
                                        Client::sendMessage(%client,0,"4x8 Force Field Door deployed");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%camera) @ "doorfourbyeightForceFieldPack"]++;
                                        echo("MSG: ",%client," deployed a 4x8 Force Field Door ");
                                        return true;

                        }
                       else {
                                Client::sendMessage(%client,0,"Cannot deploy here.");
                        }

        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}

StaticShapeData doorfourbyeightForceFieldShape
{
className = "LargeForceField";
damageSkinData = "objectDamageSkins";
shapeFile = "forcefield_4x8";
maxDamage = 75.0;
maxEnergy = 200;
mapFilter = 2;
visibleToSensor = true;
explosionId = mortarExp;
debrisId = flashDebrisLarge;
lightRadius = 12.0;
lightType=2;
lightColor = {1.0,0.2,0.2};
side = "single";
isTranslucent = true;
description = "4x8 Field Door";
};
function doorfourbyeightForceFieldShape::Destruct(%this)
{
doorfourbyeightForceFieldShape::doDamage(%this);
}
function doorfourbyeightForceFieldShape::doDamage(%this) {
calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}
function doorfourbyeightForceFieldShape::onDestroyed(%this)
{
doorfourbyeightForceFieldShape::doDamage(%this);
$TeamItemCount[GameBase::getTeam(%this) @ "LargeForceField"]--;
}
function doorfourbyeightForceFieldShape::onCollision(%this,%obj)
{
if(getObjectType(%obj)!="Player" || Player::isDead(%obj)) {
return;
}
%c = Player::getClient(%obj);
%playerTeam = GameBase::getTeam(%obj);
%fieldTeam = GameBase::getTeam(%this);
if(%fieldTeam != %playerTeam)
{
return;
}
doorfourbyeightForceFieldShape::openDoor(%this);
return;
}
function doorfourbyeightForceFieldShape::openDoor(%this) {

GameBase::startfadeout(%this);

%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 6");
GameBase::setPosition(%this,%pos);
schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
schedule("doorfourbyeightForceFieldShape::closeDoor("@%this@");",4);
}
function doorfourbyeightForceFieldShape::closeDoor(%this) {
%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 -6");
GameBase::setPosition(%this,%pos);
GameBase::startfadein(%this);
schedule("GameBase::playSound("@%this@",ForceFieldClose,0);",0.15);

}

function doorfourbyeightForceFieldShape::openDoor(%this) {

GameBase::startfadeout(%this);

%pos=GameBase::getPosition(%this);
%pos=Vector::add(%pos,"0 0 6");
GameBase::setPosition(%this,%pos);
schedule("GameBase::playSound("@%this@",ForceFieldOpen,0);",0.15);
schedule("doorfourbyeightForceFieldShape::closeDoor("@%this@");",4);
}

$TeamItemMax[doorfourbyeightForceFieldPack] = 1024;

$InvList[doorfourbyeightForceFieldPack] = 1;
$RemoteInvList[doorfourbyeightForceFieldPack] = 1;

	$TeamItemCount[0 @ doorfourbyeightForceFieldPack] = 0;
	$TeamItemCount[1 @ doorfourbyeightForceFieldPack] = 0;
	$TeamItemCount[2 @ doorfourbyeightForceFieldPack] = 0;
	$TeamItemCount[3 @ doorfourbyeightForceFieldPack] = 0;

$ItemMax[marmor, doorfourbyeightForceFieldPack] = 1;
$ItemMax[mfemale, doorfourbyeightForceFieldPack] = 1;
$ItemMax[larmor, doorfourbyeightForceFieldPack] = 0;
$ItemMax[lfemale, doorfourbyeightForceFieldPack] = 0;
$ItemMax[harmor, doorfourbyeightForceFieldPack] = 0;

//=============================================================================================

ItemImageData BlastDoorI
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mass = 1.5;
        firstPerson = false;
};

ItemData BlastDoor
{
        description = "Blast Door";
        shapeFile = "AmmoPack";
        className = "Backpack";
          heading = "nBarriers";
        imageType = BlastDoorI;
        shadowDetailMask = 4;
        mass = 1.5;
        elasticity = 0.2;
        price = 2000;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function BlastDoor::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function BlastDoor::onDeploy(%player,%item,%pos)
{
        if (BlastDoor::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}

function BlastDoor::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,3)) {

                        %obj = getObjectType($los::object);
                                %rot = GameBase::getRotation(%player);

                                        %camera = newObject("BlastDoor","StaticShape",BlastDoorShape,true);
                                        addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
                                        GameBase::setRotation(%camera,%rot);
                                        GameBase::setPosition(%camera,$los::position);
                                        Gamebase::setMapName(%camera,"BlastDoor #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
                                        Client::sendMessage(%client,0,"Blast Door deployed");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%camera) @ "doorfourbyeightForceFieldPack"]++;
                                        echo("MSG: ",%client," deployed a 4x8 Force Field Door ");
                                        return true;

                        }
                       else {
                                Client::sendMessage(%client,0,"Cannot deploy here.");
                        }

        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}

StaticShapeData BlastDoorShape
{
	className = "Blast Door";
	damageSkinData = "objectDamageSkins";
	shapeFile = "Newdoor5";
	maxDamage = 57.5;
	maxEnergy = 200;
	mapFilter = 2;
	visibleToSensor = true;
	explosionId = mortarExp;
	debrisId = flashDebrisLarge;
	lightRadius = 12.0;
	lightType=2;
	lightColor = {1.0,0.2,0.2};
	side = "single";
	isTranslucent = true;
	description = "Blast Door";
};

function BlastDoorShape::Destruct(%this)
{
	BlastDoorShape::doDamage(%this);
}

function BlastDoorShape::doDamage(%this) 
{
	calcRadiusDamage(%this, $DebrisDamageType, 5, 0.5, 25, 15, 4, 0.4, 0.1, 250, 100);
}

function BlastDoorShape::onDestroyed(%this)
{
	BlastDoorShape::doDamage(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "LargeForceField"]--;
}

function BlastDoorShape::onCollision(%this,%obj)
{
	if(getObjectType(%obj)!="Player" || Player::isDead(%obj)) 
	{
		return;
	}

	%c = Player::getClient(%obj);
	%playerTeam = GameBase::getTeam(%obj);
	%fieldTeam = GameBase::getTeam(%this);

	if(%fieldTeam != %playerTeam)
	{
		return;
	}

	BlastDoorShape::openDoor(%this);
	return;
}

function BlastDoorShape::openDoor(%this) 
{
	schedule("GameBase::playSound("@%this@",BlastDoorOpen,0);",0.15);
	GameBase::startfadeout(%this);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 8");
	GameBase::setPosition(%this,%pos);
	schedule("BlastDoorShape::closeDoor("@%this@");",4);
}

function BlastDoorShape::closeDoor(%this) 
{
	schedule("GameBase::playSound("@%this@",BlastDoorClose,0);",0.15);
	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 -8");
	GameBase::setPosition(%this,%pos);
	GameBase::startfadein(%this);
}

function BlastDoorShape::openDoor(%this) 
{
	schedule("GameBase::playSound("@%this@",BlastDoorOpen,0);",0.15);
	GameBase::startfadeout(%this);

	%pos=GameBase::getPosition(%this);
	%pos=Vector::add(%pos,"0 0 8");
	GameBase::setPosition(%this,%pos);
	schedule("BlastDoorShape::closeDoor("@%this@");",4);
}

$TeamItemMax[BlastDoor] = 1024;

$InvList[BlastDoor] = 1;
$RemoteInvList[BlastDoor] = 1;

	$TeamItemCount[0 @ BlastDoor] = 0;
	$TeamItemCount[1 @ BlastDoor] = 0;
	$TeamItemCount[2 @ BlastDoor] = 0;
	$TeamItemCount[3 @ BlastDoor] = 0;

$ItemMax[marmor, BlastDoor] = 1;
$ItemMax[mfemale, BlastDoor] = 1;
$ItemMax[larmor, BlastDoor] = 0;
$ItemMax[lfemale, BlastDoor] = 0;
$ItemMax[harmor, BlastDoor] = 0;

//***********************************
// AAOD Mobile Bunker Pack
//***********************************
$InvList[AODBunker]		= 1;
$RemoteInvList[AODBunker]		= 1;
$TeamItemMax[AODBunker]		= 8;


$ItemMax[larmor, AODBunker]		= 0;
$ItemMax[lfemale, AODBunker]		= 0;
$ItemMax[marmor, AODBunker]		= 1;
$ItemMax[mfemale, AODBunker]		= 1;
$ItemMax[harmor, AODBunker]		= 1;

ItemImageData AODBunkerImage 
{	shapeFile = "MagCargo";
	mountPoint = 2;
	mountOffset = { 0, -0.65, -0.4 };
	mass = 1.0;
	firstPerson = false;
};


ItemData AODBunker
{	description		= "Mobile Bunker";
	shapeFile		= "MagCargo";
	classname		= "Backpack";
	heading = "nBarriers";
	imageType		= AODBunkerImage;
	shadowDetailMask = 4;
	mass			= 4.5;
	elasticity		= 0.2;
	price			= 1200;
	hudIcon			= "deployable";
	showWeaponBar	= true;
	hiliteOnActive	= true;
};

function AODBunker::Help(%client)
{	%msg=HelpTitle("Portable Bunker: No Power Requirements");
	%msg=AddHelpLine(%msg,"Must be deployed on relative flat terrain.");
	%msg=AddHelpLine(%msg,"Provides a durable defendable shelter.");
	%msg=AddHelpLine(%msg,"of 5 walls in a u shape");
	%msg=AddHelpLine(%msg,"Excellent for establishing forward bases.");
	topPrint(%client,%Msg,8);
	Client::sendMessage(%client,0,"~wAAODSFX18.wav");
}
StaticShapeData MobileBunker 
{	className		= "AAODDep";
	shapeFile		= "NewDoor5";
	debrisId		= defaultDebrisSmall;
	maxDamage		= 85.5;
	visibleToSensor = true;
	isTranslucent	= true;
	description		= "Mobile Bunker Wall";
	shieldShapeName = "shield";
};


function AODBunker::onUse(%player,%item)
{	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    {	Player::mountItem(%player,%item,$BackpackSlot);}
    else
	{	Player::deployItem(%player,%item);}
}

function AODBunker::onDeploy(%player,%item,%pos)
{	if (AODBunker::deployShape(%player,%item))
	{	Player::decItemCount(%player,%item);}
}

function AODBunker::deployShape(%player,%item)
{	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) 
	{	if (GameBase::getLOSInfo(%player,5)) 
		{	%obj = getObjectType($los::object);
			if (%obj == "SimTerrain") 
			{	%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,20,15,15,0);
				deleteObject(%set);
				if(0 == %num) 
				{	if (Vector::dot($los::normal,"0 0 1") > 0.7) 
					{		%rot = GameBase::getRotation(%player);
							%team=GameBase::getteam(%player);
							// 1st Wall
							%CurrPos=$los::position;
							%NewVector="0 0 -0.5";
							%NewPos=Vector::add(%CurrPos,%NewVector);
							%wall = newObject("Bunker","StaticShape",MobileBunker,false);
							addToSet("MissionCleanup", %wall);
							GameBase::setTeam(%wall,GameBase::getTeam(%player));
							GameBase::setPosition(%wall,%NewPos);
							GameBase::setRotation(%wall,%rot);
							Gamebase::setMapName(%wall,"Mobile Bunker");
							GameBase::startFadeIn(%wall);
							$TeamBunker[0 @ %Team]=%wall;
							Client::setOwnedObject(%client, %wall); 
							Client::setOwnedObject(%client, %player); 
							
														
							// 2nd Wall
							%ang=Getword(Vector::add(%rot,"0 0 -0.375245789"),2);
							%x=COS(%ang)*9.2;
							%ang=Getword(Vector::add(%rot,"0 0 -0.375245789"),2);
							%y=SIN(%ang)*9.2;
							%NewVector=%x@" "@%y@" -0.5";
							%NewPos=Vector::add(%CurrPos,%NewVector);
							%ang=Vector::add(%rot,"0 0 -0.785398163");
							%wall = newObject("Bunker","StaticShape",MobileBunker,false);
							addToSet("MissionCleanup", %wall);
							GameBase::setTeam(%wall,GameBase::getTeam(%player));
							GameBase::setPosition(%wall,%NewPos);
							GameBase::setRotation(%wall,%ang);
							Gamebase::setMapName(%wall,"Mobile Bunker");
							GameBase::startFadeIn(%wall);
							$TeamBunker[1 @ %Team]=%wall;
							Client::setOwnedObject(%client, %wall); 
							Client::setOwnedObject(%client, %player); 
														
							//3rd Wall
							%ang=Getword(Vector::add(%rot,"0 0 0.375245789"),2);
							%x=COS(%ang)*-9.2;
							%ang=Getword(Vector::add(%rot,"0 0 0.375245789"),2);
							%y=SIN(%ang)*-9.2;
							%NewVector=""@%x@" "@%y@" -0.5";
							%NewPos=Vector::add(%CurrPos,%NewVector);
							%ang=Vector::add(%rot,"0 0 0.785398163");
							%wall = newObject("Bunker","StaticShape",MobileBunker,false);
							addToSet("MissionCleanup", %wall);
							GameBase::setTeam(%wall,GameBase::getTeam(%player));
							GameBase::setPosition(%wall,%NewPos);
							GameBase::setRotation(%wall,%ang);
							Gamebase::setMapName(%wall,"Mobile Bunker");
							GameBase::startFadeIn(%wall);
							$TeamBunker[2 @ %Team]=%wall;
							Client::setOwnedObject(%client, %wall); 
							Client::setOwnedObject(%client, %player); 

							//4th Wall
							%ang=Getword(Vector::add(%rot,"0 0 -0.785398163"),2);
							%x=COS(%ang)*16.8;
							%ang=Getword(Vector::add(%rot,"0 0 -0.785398163"),2);
							%y=SIN(%ang)*16.8;
							%NewVector=""@%x@" "@%y@" -0.5";
							%NewPos=Vector::add(%CurrPos,%NewVector);
							%ang=Vector::add(%rot,"0 0 -1.570796327");
							%wall = newObject("Bunker","StaticShape",MobileBunker,false);
							addToSet("MissionCleanup", %wall);
							GameBase::setTeam(%wall,GameBase::getTeam(%player));
							GameBase::setPosition(%wall,%NewPos);
							GameBase::setRotation(%wall,%ang);
							Gamebase::setMapName(%wall,"Mobile Bunker");
							GameBase::startFadeIn(%wall);
							$TeamBunker[3 @ %Team]=%wall;
							playSound(SoundBunkerDeploy,$los::position);
							Client::setOwnedObject(%client, %wall); 
							Client::setOwnedObject(%client, %player); 

							// 5th Wall
							%ang=Getword(Vector::add(%rot,"0 0 0.785398163"),2);
							%x=COS(%ang)*-16.8;
							%ang=Getword(Vector::add(%rot,"0 0 0.785398163"),2);
							%y=SIN(%ang)*-16.8;
							%NewVector=%x@" "@%y@" -0.5";
							%NewPos=Vector::add(%CurrPos,%NewVector);
							%ang=Vector::add(%rot,"0 0 1.570796327");
							%wall = newObject("Bunker","StaticShape",MobileBunker,false);
							addToSet("MissionCleanup", %wall);
							GameBase::setTeam(%wall,GameBase::getTeam(%player));
							GameBase::setPosition(%wall,%NewPos);
							GameBase::setRotation(%wall,%ang);
							Gamebase::setMapName(%wall,"Mobile Bunker");
							GameBase::startFadeIn(%wall);
							$TeamBunker[4 @ %Team]=%wall;
							Client::setOwnedObject(%client, %wall); 
							Client::setOwnedObject(%client, %player); 

							$TeamItemCount[GameBase::getTeam(%player) @ "AODBunker"]++;
							echo("INF: ",$User[%client]," deployed a Mobile Bunker");
							return true;
					}
					else Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
				}
				else Client::sendMessage(%client,0,"Some other Item in the Way!!");
			}
			else Client::sendMessage(%client,0,"Can only deploy Outside on terrain");
		}
		else Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	return false;
}


function MobileBunker::onDestroyed(%this)
{	// StaticShape::onDestroyed(%this);
	// $TeamItemCount[GameBase::getTeam(%this) @ "AODBunker"]--;
}

function MobileBunker::packUp(%this, %pos, %client, %player)
{	if($trace) echo( $ver@"|Packup Mobile Bunker");
	%name = Client::getName(%client);
	%team = Client::getTeam(%client);
	// Must be Wearing Heavy Armor
	%armor = Player::getArmor(%client);
	%arm=String::getSubStr(%armor, 0, 1);
	if (%arm!="h")
	{	Client::sendMessage(%client,0,"Must be in Heavy Armour to Pack Up Mobile Bunker ~wError_Message.wav");
		return;
	}
	
	%pos=vector::add(Gamebase::getPosition(%this),"0 0 0.5");

	// Must Have No Pack on....
	%isDamaged=false;
	for(%i=0;%i<3;%i++)
	{	%wall=$TeamBunker[%i @ %team];
		if(GameBase::getDamageLevel(%wall)) 
			%isDamaged=true;
	}
	if (!%isDamaged)
	{	// Pack up Bunker
		%player.isDeploying = true;
		%player.deployPosition = %pos;
		playSound(SoundBunkerDeploy,%pos);
		for (%i=0;%i<5;%i++)
		{	%wall=$TeamBunker[%i @ %team];
			GameBase::startFadeOut(%wall);
			schedule("deleteObject(" @ %wall @ ");",0.5,%wall);						
		}
		
		schedule("PlaceItemPack(" @ %player @ ",AODBunker," @ %pos @ ");",2,%player);
		Client::sendMessage(%client,0,"Packing Up Mobile Bunker ~wDoor2.wav");
	}
	else
		Client::sendMessage(%client,0,"Unable to Pack up Bunker.. One or more Walls are Damaged!~wError_message.wav");
	
}

//=====================================

$InvList[C4Pack] = 1;
$RemoteInvList[C4Pack] = 1;

$TeamItemMax[C4Pack] = 100000;

$TeamItemCount[0 @ C4Pack] = 0;
$TeamItemCount[1 @ C4Pack] = 0;
$TeamItemCount[2 @ C4Pack] = 0;
$TeamItemCount[3 @ C4Pack] = 0;

$ItemMax[harmor, C4Pack] = 0;
$ItemMax[marmor, C4Pack] = 1;
$ItemMax[mfemale, C4Pack] = 1;
$ItemMax[larmor, C4Pack] = 1;
$ItemMax[lfemale, C4Pack] = 1;

ItemImageData C4PackImage
{
	shapeFile = "grenammo";
	mountPoint = 2;
	mountOffset = { 0, -0.5, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.5;
	firstPerson = false;

};

ItemData C4Pack
{
	description = "C-4 Pack";
	shapeFile = "grenammo";
	className = "Backpack";
   heading = "iBackpacks";
	imageType = C4packImage;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function C4Pack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function C4Pack::onUnmount(%player,%item)
{
	deleteObject(%item);
	
}

function C4Pack::onDeploy(%player,%item,%pos)
{
	if (C4Pack::deployShape(%player,%item)) {
//		Player::decItemCount(%player,%item);
	}
}

function C4Pack::deployShape(%player,%item)
{
//	Player::unmountItem(%player,$BackpackSlot);	
		
			%obj = newObject("C-4","Mine","C4");
		 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,3 * %client.throwStrength,false);
	bottomprint(Player::getClient(%player), "<jc>C-4 pack will explode in <f2>15 seconds", 5);
}

ItemImageData BlastPackImage
{
	shapeFile = "magcargo";
	mountPoint = 2;
	mountOffset = { 0, -0.5, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.5;
	firstPerson = false;

};

ItemData TNTPack
{
	description = "Blast Pack";
	shapeFile = "magcargo";
	className = "Backpack";
   heading = "iBackpacks";
	imageType = BlastPackImage;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 1000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function TNTPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function TNTPack::onUnmount(%player,%item)
{
	deleteObject(%item);
	
}

function TNTPack::onDeploy(%player,%item,%pos)
{
	if (TNTPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function TNTPack::deployShape(%player,%item)
{
	Player::unmountItem(%player,$BackpackSlot);	
		
			%obj = newObject("Deployable Mortar","Mine","TNT");
		 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,3 * %client.throwStrength,false);
	bottomprint(Player::getClient(%player), "<jc>Blast pack will explode in <f2>15 seconds", 5);
}


$InvList[TNTPack] = 1;
$RemoteInvList[TNTPack] = 1;

$TeamItemMax[TNTPack] = 100000;

$TeamItemCount[0 @ TNTPack] = 0;
$TeamItemCount[1 @ TNTPack] = 0;
$TeamItemCount[2 @ TNTPack] = 0;
$TeamItemCount[3 @ TNTPack] = 0;

$ItemMax[harmor, TNTPack] = 1;
$ItemMax[marmor, TNTPack] = 1;
$ItemMax[mfemale, TNTPack] = 1;
$ItemMax[larmor, TNTPack] = 0;
$ItemMax[lfemale, TNTPack] = 0;

//==============================================================

ItemImageData BNukePackImage
{
	shapeFile = "generator_p";
	mountPoint = 2;
	mountOffset = { 0, -0.5, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.5;
	firstPerson = false;

};

ItemData BNukePack
{
	description = "Baby Nuke Pack";
	shapeFile = "generator_p";
	className = "Backpack";
   heading = "iBackpacks";
	imageType = BNukePackImage;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 2500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function BNukePack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function BNukePack::onUnmount(%player,%item)
{
	deleteObject(%item);
	
}

function BNukePack::onDeploy(%player,%item,%pos)
{
	if (BNukePack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function BNukePack::deployShape(%player,%item)
{
	Player::unmountItem(%player,$BackpackSlot);	
		
			%obj = newObject("Deployable Baby Nuke","Mine","BombX");
		 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,3 * %client.throwStrength,false);
	bottomprint(Player::getClient(%player), "<jc>Baby Nuke pack will explode in <f2>30 seconds", 5);
}

$InvList[BNukePack] = 1;
$RemoteInvList[BNukePack] = 1;

$TeamItemMax[BNukePack] = 900000;

$TeamItemCount[0 @ BNukePack] = 0;
$TeamItemCount[1 @ BNukePack] = 0;
$TeamItemCount[2 @ BNukePack] = 0;
$TeamItemCount[3 @ BNukePack] = 0;

$ItemMax[harmor, BNukePack] = 1;
$ItemMax[marmor, BNukePack] = 1;
$ItemMax[mfemale, BNukePack] = 1;
$ItemMax[larmor, BNukePack] = 0;
$ItemMax[lfemale, BNukePack] = 0;

//=======================================================================================

ItemImageData NukePackImage
{
	shapeFile = "generator";
	mountPoint = 2;
	mountOffset = { 0, -0.5, -0.3 };
	mountRotation = { 0, 0, 0 };
	mass = 1.5;
	firstPerson = false;

};

ItemData NukePack
{
	description = "Nuke Pack";
	shapeFile = "generator";
	className = "Backpack";
   heading = "iBackpacks";
	imageType = NukePackImage;
	shadowDetailMask = 4;
	mass = 1.5;
	elasticity = 0.2;
	price = 5000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function NukePack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function NukePack::onUnmount(%player,%item)
{
	deleteObject(%item);
}

function NukePack::onDeploy(%player,%item,%pos)
{
	if (NukePack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

function NukePack::deployShape(%player,%item)
{
	Player::unmountItem(%player,$BackpackSlot);	
		
			%obj = newObject("Deployable Nuke","Mine","BombZ");
		 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,3 * %client.throwStrength,false);
	bottomprint(Player::getClient(%player), "<jc>Nuke pack will explode in <f2>1 Minute", 5);
}

$InvList[NukePack] = 1;
$RemoteInvList[NukePack] = 1;

$TeamItemMax[NukePack] = 900000;

$TeamItemCount[0 @ NukePack] = 0;
$TeamItemCount[1 @ NukePack] = 0;
$TeamItemCount[2 @ NukePack] = 0;
$TeamItemCount[3 @ NukePack] = 0;

$ItemMax[harmor, NukePack] = 1;
$ItemMax[marmor, NukePack] = 0;
$ItemMax[mfemale, NukePack] = 0;
$ItemMax[larmor, NukePack] = 0;
$ItemMax[lfemale, NukePack] = 0;

//===================================
$TeamItemMax[MiniBase] = 2;

ItemImageData MiniBaseImage
{
        shapeFile = "ammounit_remote";
        mountPoint = 2;
        mountOffset = { 0, 0, 0 };
        mountRotation = { 0, 0, 0 };
        firstPerson = false;
};

ItemData MiniBase
{
	description = "Air Base";
	shapeFile = "ammounit_remote";
	className = "Backpack";
	heading =  "jDeployables";
	imageType = MiniBaseImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 10000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

StaticShapeData MiniBaseGenerator
{
   description = "Power Source";
   shapeFile = "generator_p";
        className = "Generator";
        debrisId = flashDebrisSmall;
        sfxAmbient = SoundGeneratorPower;
        maxDamage = 1.0;
        mapIcon = "M_generator";
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 16;
        explosionId = flashExpMedium;
        visibleToSensor = true;
        mapFilter = 4;
};

function MiniBase::Destruct(%this)
{
                %obj = newObject("","Mine","armorCoreExp");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 -2";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
                %obj = newObject("","Mine","armorExp");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 0";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
                %obj = newObject("","Mine","armorExp");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 2";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
                %obj = newObject("","Mine","armorExp");
                addToSet("MissionCleanup", %obj);
                %padd = "0 0 4";
                %pos = Vector::add(GameBase::getPosition(%this), %padd);
                GameBase::setPosition(%obj, %pos);
	return;
}

function MiniBaseGenerator::onDestroyed(%this)
{
	StaticShape::onDestroyed(%this);
	MiniBase::Destruct(%this);
	$TeamItemCount[GameBase::getTeam(%this) @ "MiniBase"]--;
}

StaticShapeData BasePlatform
{
        shapeFile = "elevator16x16_octo";
        debrisId = defaultDebrisLarge;
        maxDamage = 15.0;
        damageSkinData = "objectDamageSkins";
        shadowDetailMask = 16;
        explosionId = debrisExpLarge;
        visibleToSensor = true;
        mapFilter = 4;
        description = "Air Base";
};

function BasePlatform::onDestroyed(%this)
{
	StaticShape::onDestroyed(%this);
	MiniBase::Destruct(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 30, 1000, 250, 30, 25, 1000, 999, 250, 100);
}

function MiniBase::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function MiniBase::onDeploy(%player,%item,%pos)
{
        if (MiniBase::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);
        }
}

function MiniBase::deployshape(%player,%item)
{
	GameBase::getLOSInfo(%player,3);
      %client = Player::getClient(%player);
      %playerPos = GameBase::getPosition(%player);

      if($TeamItemCount[GameBase::getTeam(%player) @ "MiniBase"] >= $TeamItemMax[MiniBase])
      { 
		Client::sendMessage(%client,0,"Too many Mini-Bases"); 
		return false; 
	}

      %obj = getObjectType($los::object);
      %set = newObject("MiniBase",SimSet);
      %num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$ForceFieldBoxMinLength,$ForceFieldBoxMinWidth,$ForceFieldBoxMinHeight,0);
      %num = CountObjects(%set,"MiniBase",%num);
      deleteObject(%set);

      %objDevice = newObject("groundBase","Staticshape",MiniBaseGenerator,true);
      %objDevice.objSide1 = newObject("groundBase1","Staticshape",BasePlatform,true);
      %objDevice.objSide2 = newObject("groundBase2","Staticshape",BasePlatform,true);
      %objDevice.objSide3 = newObject("groundBase3","Staticshape",BasePlatform,true);
      %objDevice.objSide4 = newObject("groundBase4","Sensor",PulseSensor,true);
      %objDevice.objSide5 = newObject("groundBase5","StaticShape",BasePlatform,true);
      %objDevice.objSide6 = newObject("groundBase6","StaticShape",AmmoStation,true);
      %objDevice.objSide7 = newObject("groundBase7","StaticShape",InventoryStation,true);
      %objDevice.objSide8 = newObject("groundBase8","StaticShape",VehicleStation,true);
      %objDevice.objSide9 = newObject("groundBase9","StaticShape",VehiclePad,true);

      %objDevice.objSide1.objParent = %objDevice;
      %objDevice.objSide2.objParent = %objDevice;
      %objDevice.objSide3.objParent = %objDevice;
      %objDevice.objSide4.objParent = %objDevice;
      %objDevice.objSide5.objParent = %objDevice;
      %objDevice.objSide6.objParent = %objDevice;
      %objDevice.objSide7.objParent = %objDevice;
      %objDevice.objSide8.objParent = %objDevice;
      %objDevice.objSide9.objParent = %objDevice;

      addToSet(MissionCleanup, %objDevice);
      addToSet(MissionCleanup, %objDevice.objSide1);
      addToSet(MissionCleanup, %objDevice.objSide2);
      addToSet(MissionCleanup, %objDevice.objSide3);
      addToSet(MissionCleanup, %objDevice.objSide4);
      addToSet(MissionCleanup, %objDevice.objSide5);
      addToSet(MissionCleanup, %objDevice.objSide6);
      addToSet(MissionCleanup, %objDevice.objSide7);
      addToSet(MissionCleanup, %objDevice.objSide8);
      addToSet(MissionCleanup, %objDevice.objSide9);

// The Building <(8)>

      %pos = Vector::add(GameBase::getPosition(%player), "7.5 0 22");
      %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
      GameBase::setRotation(%objDevice.objSide5,%rot);
      GameBase::setPosition(%objDevice.objSide5,%pos);
      GameBase::setTeam(%objDevice,GameBase::getTeam(%player));

      %pos = Vector::add(GameBase::getPosition(%player), "-7.5 0 22");
      %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
      GameBase::setRotation(%objDevice.objSide1,%rot);
      GameBase::setPosition(%objDevice.objSide1,%pos);
      GameBase::setTeam(%objDevice.objSide1,GameBase::getTeam(%player));

      %pos = Vector::add(GameBase::getPosition(%player), "0 7 15");
      %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
      GameBase::setRotation(%objDevice.objSide2,%rot);
      GameBase::setPosition(%objDevice.objSide2,%pos);
      GameBase::setTeam(%objDevice.objSide2,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "0 -7 15");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
       GameBase::setRotation(%objDevice.objSide3,%rot);
       GameBase::setPosition(%objDevice.objSide3,%pos);
       GameBase::setTeam(%objDevice.objSide3,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "0 0 22.50");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 0");
       GameBase::setRotation(%objDevice.objSide4,%rot);
       GameBase::setPosition(%objDevice.objSide4,%pos);
       GameBase::setTeam(%objDevice.objSide4,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "0 0 15.40");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice,%rot);
       GameBase::setPosition(%objDevice,%pos);
       GameBase::setTeam(%objDevice.objSide5,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "-1 7 15.40");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 -4.71339");
       GameBase::setRotation(%objDevice.objSide6,%rot);
       GameBase::setPosition(%objDevice.objSide6,%pos);
       GameBase::setTeam(%objDevice.objSide6,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "1 -7 15.40");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice.objSide7,%rot);
       GameBase::setPosition(%objDevice.objSide7,%pos);
       GameBase::setTeam(%objDevice.objSide7,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "-7 1 22.50");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice.objSide8,%rot);
       GameBase::setPosition(%objDevice.objSide8,%pos);
       GameBase::setTeam(%objDevice.objSide8,GameBase::getTeam(%player));

       %pos = Vector::add(GameBase::getPosition(%player), "7 -1 22.50");
       %rot = Vector::add(GameBase::getRotation(%player), "0 0 4.71339");
       GameBase::setRotation(%objDevice.objSide9,%rot);
       GameBase::setPosition(%objDevice.objSide9,%pos);
       GameBase::setTeam(%objDevice.objSide9,GameBase::getTeam(%player));
       Gamebase::setMapName(%inv,"Mini-Base " @  Client::getName(%client));

       playSound(SoundPickupBackpack,$los::position);
       $TeamItemCount[GameBase::getTeam(%player) @ "MiniBase"]++;
       Client::sendMessage(%client,0,"Mini-Base Deployed.");
       echo("MSG: ",%client," deployed a Mini-Base");
       return true;
}

$InvList[MiniBase] = 1;
$RemoteInvList[MiniBase] = 1;

$ItemMax[harmor, MiniBase] = 1;
$ItemMax[marmor, MiniBase] = 1;
$ItemMax[mfemale, MiniBase] = 1;
$ItemMax[larmor, MiniBase] = 0;
$ItemMax[lfemale, MiniBase] = 0;



$InvList[jailpack] = 1;
$RemoteInvList[jailpack] = 1;

$TeamItemCount[0 @ jailpack] = 0;
$TeamItemCount[1 @ jailpack] = 0;
$TeamItemCount[2 @ jailpack] = 0;
$TeamItemCount[3 @ jailpack] = 0;

$TeamItemMax[jailpack] = 5;

$ItemMax[harmor, jailpack] = 1;
$ItemMax[marmor, jailpack] = 1;
$ItemMax[mfemale, jailpack] = 1;
$ItemMax[larmor, jailpack] = 0;
$ItemMax[lfemale, jailpack] = 0;

ItemImageData jailpackImage
{
        shapeFile = "ammopack";
        mountPoint = 2;
        mountOffset = { 0, 0, 0 };
        mountRotation = { 0, 0, 0 };
        firstPerson = false;
};
ItemData jailpack
{
description = "Jail";
shapeFile = "shieldpack";
className = "Backpack";
heading =  "jDeployables";
imageType = jailpackImage;
shadowDetailMask = 4;
mass = 1.0;
elasticity = 0.2;
price = 9000;
hudIcon = "deployable";
showWeaponBar = true;
hiliteOnActive = true;
};

function jailpack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item)
        {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else
        {
                Player::deployItem(%player,%item);
        }
}

function jailpack::onDeploy(%player,%item,%pos)
{
        if (jailpack::deployShape(%player,%item))
        {
                Player::decItemCount(%player,%item);

        }
}
function CreatejailportSimSet()
{
    %teleset = nameToID("MissionCleanup/jailports");
        if(%teleset == -1)
        {
                newObject("jailports",SimSet);
                addToSet("MissionCleanup","jailports");
        }
}

function jailpack::deployshape(%player,%item)
{
        GameBase::getLOSInfo(%player,3);
        %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ "jailpack"] >= $TeamItemMax[jailpack])
        {
        Client::sendMessage(%client,0,"Can Not Deploy Jail Cell Already In Place");
        return false;
         }
                %playerPos = GameBase::getPosition(%player);
                %flag = $teamFlag[GameBase::getTeam(%player)];
                %flagpos = gamebase::getPosition(%flag);

                if(Vector::getDistance(%flagpos, %playerpos) < 150)
                {
                 Client::sendMessage(%client,0,"You are too close to your flag, Must be further from flag to deploy.");
                 return ;
                }
                %obj = getObjectType($los::object);

                %set = newObject("Jail",SimSet);
                %num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$ForceFieldBoxMinLength,$ForceFieldBoxMinWidth,$ForceFieldBoxMinHeight,0);
                %num = CountObjects(%set,"Jail",%num);



                %objDevice =   newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide1 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide2 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide3 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide4 = newObject("Jail","Staticshape",LLargeForceField,true);
                %objDevice.objSide5 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide6 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide7 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide8 = newObject("Jail","StaticShape",JailSwitchOpen,true);
                %objDevice.objSide9 = newObject("Jail","StaticShape",LLargeForceField,true);
                %objDevice.objSide10 = newObject("Jail","StaticShape",JailSwitchClose,true);


                %objDevice.objSide1.objParent = %objDevice;
                %objDevice.objSide2.objParent = %objDevice;
                %objDevice.objSide3.objParent = %objDevice;
                %objDevice.objSide4.objParent = %objDevice;
                %objDevice.objSide5.objParent = %objDevice;
                %objDevice.objSide6.objParent = %objDevice;
                %objDevice.objSide7.objParent = %objDevice;
                %objDevice.objSide8.objParent = %objDevice;
                %objDevice.objSide9.objParent = %objDevice;
                %objDevice.objSide10.objParent = %objDevice;




                 addToSet(MissionCleanup, %objDevice);

                 addToSet(MissionCleanup, %objDevice.objSide1);
                 addToSet(MissionCleanup, %objDevice.objSide2);
                 addToSet(MissionCleanup, %objDevice.objSide3);
                 addToSet(MissionCleanup, %objDevice.objSide4);
                 addToSet(MissionCleanup, %objDevice.objSide5);
                 addToSet(MissionCleanup, %objDevice.objSide6);
                 addToSet(MissionCleanup, %objDevice.objSide7);
                 addToSet(MissionCleanup, %objDevice.objSide8);
                 addToSet(MissionCleanup, %objDevice.objSide9);
                 addToSet(MissionCleanup, %objDevice.objSide10);

                %pos = Vector::add(GameBase::getPosition(%player), "0 1 80");
                GameBase::setRotation(%objDevice.objSide1,"0 0 0");
                GameBase::setPosition(%objDevice.objSide1,%pos);
                GameBase::setTeam(%objDevice.objSide1,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "-5.5 6.5 80");
                GameBase::setRotation(%objDevice.objSide2,"0 0 4.71339");
                GameBase::setPosition(%objDevice.objSide2,%pos);
                GameBase::setTeam(%objDevice.objSide2,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "5.5 6.5 80");
                GameBase::setRotation(%objDevice.objSide3,"0 0 4.71339");
                GameBase::setPosition(%objDevice.objSide3,%pos);
                GameBase::setTeam(%objDevice.objSide3,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "0 12.5 86");
                 GameBase::setRotation(%objDevice.objSide4,"-4.71339 0 0");
                 GameBase::setPosition(%objDevice.objSide4,%pos);
                 GameBase::setTeam(%objDevice.objSide4,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "0 .5 86");
                 GameBase::setRotation(%objDevice,"4.71339 0 0");
                 GameBase::setPosition(%objDevice,%pos);
                 GameBase::setTeam(%objDevice,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "0 12.5 80");
                GameBase::setRotation(%objDevice.objSide6,"-4.71339 0 0");
                GameBase::setPosition(%objDevice.objSide6,%pos);
                GameBase::setTeam(%objDevice.objSide6,GameBase::getTeam(%player));

                %pos = Vector::add(GameBase::getPosition(%player), "0 .5 80");
                 GameBase::setRotation(%objDevice.objSide7,"4.71339 0 0");
                 GameBase::setPosition(%objDevice.objSide7,%pos);
                 GameBase::setTeam(%objDevice.objSide7,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "-5 13 80.00");
                 GameBase::setRotation(%objDevice.objSide8,"0 0 0");
                 GameBase::setPosition(%objDevice.objSide8,%pos);
                 GameBase::setTeam(%objDevice.objSide8,GameBase::getTeam(%player));

                 %pos = Vector::add(GameBase::getPosition(%player), "0 18 80");
                 GameBase::setRotation(%objDevice.objSide9,"-4.71339 0 0");
                 GameBase::setPosition(%objDevice.objSide9,%pos);
                 GameBase::setTeam(%objDevice.objSide9,GameBase::getTeam(%player));


                 %pos = Vector::add(GameBase::getPosition(%player), "5 13 80.00");
                 GameBase::setRotation(%objDevice.objSide10,"0 0 0");
                 GameBase::setPosition(%objDevice.objSide10,%pos);
                 GameBase::setTeam(%objDevice.objSide10,GameBase::getTeam(%player));


                playSound(SoundPickupBackpack,$los::position);

               newObject("jaildoor",SimSet);
                addToSet("MissionCleanup","jaildoor");
                %sensor = newObject("jaildoor","StaticShape",jLargeForceField,true);

                                                addToSet("MissionCleanup/jaildoor", %sensor);
                                                addToSet("MissionCleanup", %sensor);
                                                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                                                %pos = Vector::add(GameBase::getPosition(%player), "0 12 80");
                                                GameBase::setPosition(%sensor,%pos);
                                                GameBase::setRotation(%sensor,"0 0 0");
                                                %sensor.disabled = false;
                                                playSound(SoundPickupBackpack,$los::position);



                                        %sensor = newObject("Teleport Pad","StaticShape","jailStand",true);
                                                CreatejailportSimSet();
                                                addToSet("MissionCleanup/jailports", %sensor);
                                                addToSet("MissionCleanup", %sensor);
                                                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                                                 %pos = Vector::add(GameBase::getPosition(%player), "0 3 81");
                                                GameBase::setPosition(%sensor,%pos);
                                                Gamebase::setMapName(%sensor,%name);


                                                %sensor.disabled = false;
                                                playSound(SoundPickupBackpack,$los::position);

                                                %beam = newObject("","StaticShape",ElectricalBeamBig,true);
                                                addToSet("MissionCleanup", %beam);
                                                GameBase::setTeam(%beam,GameBase::getTeam(%player));
                                                GameBase::setPosition(%beam,%pos);
                                                %sensor.beam1 = %beam;
                                                playSound(SoundPickupBackpack,$los::position);


                                                newObject("releasepad",SimSet);
                                                CreatereleasepadSimSet();
                                                addToSet("MissionCleanup/releasepad", %sensor);
                                                addToSet("MissionCleanup", %sensor);
                                                %sensor = newObject("releasepad","StaticShape","jailStandTop",true);

                                                addToSet("MissionCleanup/releasepad", %sensor);
                                                GameBase::setTeam(%sensor,GameBase::getTeam(%player));
                                                %pos = Vector::add(GameBase::getPosition(%player), "0 3 86.30");

                                                GameBase::setPosition(%sensor,%pos);
                                                Gamebase::setMapName(%sensor,%name);


                                                %sensor.disabled = false;


                                                $TeamItemCount[GameBase::getTeam(%sensor) @ "jailpack"]++;
                                                echo("MSG: ",%client," deployed a Jail Cell");
                                                Client::sendMessage(%client,0,%item.description @ " deployed 250' Up");
                return true;
               }
function CreatereleasepadSimSet()
{
%teleset = nameToID("MissionCleanup/releasepad");
if(%teleset == -1)
{
newObject("releasepad",SimSet);
addToSet("MissionCleanup","releasepad");
}
}


$InvList[jailcappack] = 1;
$RemoteInvList[jailcappack] = 1;

$TeamItemCount[0 @ jailcappack] = 0;
$TeamItemCount[1 @ jailcappack] = 0;
$TeamItemCount[2 @ jailcappack] = 0;
$TeamItemCount[3 @ jailcappack] = 0;

$TeamItemMax[jailcappack] = 100000;

$ItemMax[harmor, jailcappack] = 0;
$ItemMax[marmor, jailcappack] = 1;
$ItemMax[mfemale, jailcappack] = 1;
$ItemMax[larmor, jailcappack] = 1;
$ItemMax[lfemale, jailcappack] = 1;

ItemImageData JailCapPackImage
{
        shapeFile = "AmmoPack";
        mountPoint = 2;
        mountOffset = { 0, -0.5, -0.3 };
        mass = 1.5;
        firstPerson = false;
};

ItemData JailCapPack
{
        description = "Jail Capture Pad";
        shapeFile = "AmmoPack";
        className = "Backpack";
        heading =  "jDeployables";
        imageType = JailCapPackImage;
        shadowDetailMask = 4;
        mass = 1.0;
        elasticity = 0.2;
        price = 500;
        hudIcon = "deployable";
        showWeaponBar = true;
        hiliteOnActive = true;
};

function JailCapPack::onUse(%player,%item)
{
        if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
                Player::mountItem(%player,%item,$BackpackSlot);
        }
        else {
                Player::deployItem(%player,%item);
        }
}

function JailCapPack::onDeploy(%player,%item,%pos)
{
        if (JailCapPack::deployShape(%player,%item)) {
                Player::decItemCount(%player,%item);
        }
}
function JailCapPack::deployShape(%player,%item)
{
         %client = Player::getClient(%player);
        if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
                if (GameBase::getLOSInfo(%player,3)) {

                        %obj = getObjectType($los::object);

                         %playerPos = GameBase::getPosition(%player);
                         %flag = $teamFlag[GameBase::getTeam(%player)];
                         %flagpos = gamebase::getPosition(%flag);

                         if(Vector::getDistance(%flagpos, %playerpos) < 10)
                          {
                          Client::sendMessage(%client,0,"You are too close to your flag, Must be further from flag to deploy.");
                          return;
                          }


                                %prot = GameBase::getRotation(%player);
                                %zRot = getWord(%prot,2);
                                %rot =  "1.57079 0 " @ %zRot;
                                %padd = "0 0 0";
                                %pos = Vector::add($los::position,%padd);

                                        %camera = newObject("","StaticShape","jailpad",true);
                                        addToSet("MissionCleanup", %camera);
                                        GameBase::setTeam(%camera,GameBase::getTeam(%player));
                                        GameBase::setRotation(%camera,"0 0 0");
                                        GameBase::setPosition(%camera,%pos);
                                        Gamebase::setMapName(%camera,"JailPad " @ $totalNumCameras++ @ " " @ Client::getName(%client));
                                        Client::sendMessage(%client,0,"Jail Pad Deployed");
                                        playSound(SoundPickupBackpack,$los::position);
                                        $TeamItemCount[GameBase::getTeam(%player) @ "JailCapPack"]++;
                                        echo("MSG: ",%client," deployed a Jail Pad");
                                        return true;

                        }
                       else {
                                Client::sendMessage(%client,0,"Cannot deploy here.");
                        }

        }
        else
                 Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

        return false;
}

$TeamItemMax[HPCPack] = 5; 
{
$TeamItemCount[0 @ HPCPack] = 0;
$TeamItemCount[1 @ HPCPack] = 0;
$TeamItemCount[2 @ HPCPack] = 0;
$TeamItemCount[3 @ HPCPack] = 0;

$InvList[HPCPack] = 1;
$RemoteInvList[HPCPack] = 1;

$ItemMax[larmor, HPCPack] = 0;
$ItemMax[lfemale, HPCPack] = 0;
$ItemMax[marmor, HPCPack] = 1;
$ItemMax[mfemale, HPCPack] = 1;
$ItemMax[harmor, HPCPack] = 1;

ItemImageData HPCPackImage
{
	shapeFile = "generator_p";
	mountPoint = 2;
	mountOffset = { 0, 0, 0 };
	mountRotation = { 0, 0, 0 };
	mass = 0.25;
	firstPerson = false;
};

ItemData HPCPack
{
	
};

function HPCPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function HPCPack::onDeploy(%player,%item,%pos)
{
	if (HPCPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}	

function HPCPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
		    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$ForceFieldBoxMinLength,$ForceFieldBoxMinWidth,$ForceFieldBoxMinHeight,0);
				%num = CountObjects(%set,"wall",%num);
				deleteObject(%set);
							%rot = GameBase::getRotation(%player);
							# All of this deploys, but it doesn't work (except for the Diamond Sword Drop Ship)
							
							%wall = newObject("Diamond Sword Drop Ship", "InteriorShape", "gdsdrop.dis");
							addToSet("MissionCleanup", %wall);
							GameBase::setTeam(%fField,GameBase::getTeam(%player));
							GameBase::setPosition(%wall,$los::position);
							GameBase::setRotation(%wall,%rot);
							Gamebase::setMapName(%wall,"Diamond Sword Dropship");

							%wall2 = newObject("Internal Generator", "StaticShape", "Generator");
							%genroom = "10.0328 5.33114 0.000196456";
							addToSet("MissionCleanup", %wall2);
							GameBase::setTeam(%fField,GameBase::getTeam(%player));
							GameBase::setPosition(%wall2,%genroom); //"10.0328 5.33114 0.000196456");
							GameBase::setRotation(%wall2,%rot);
							Gamebase::setMapName(%wall2,"Internal Generator");

							%wall3 = newObject("Inventory Station", "StaticShape", "InventoryStation");
							addToSet("MissionCleanup", %wall3);
							GameBase::setTeam(%fField,GameBase::getTeam(%player));
							GameBase::setPosition(%wall3, "10.0328 5.33114 0.000196456");
							GameBase::setRotation(%wall3,%rot);
							Gamebase::setMapName(%wall3,"Inventory Station");

							%wall4 = newObject("Ammo Station", "StaticShape", "AmmoStation");
							addToSet("MissionCleanup", %wall4);
							GameBase::setTeam(%fField,GameBase::getTeam(%player));
							GameBase::setPosition(%wall4, "10.0328 -5.33114 0.000196456");
							GameBase::setRotation(%wall4,%rot);
							Gamebase::setMapName(%wall4,"Ammo Station");


							Client::sendMessage(%client,0,"Dropship Deployed");
							playSound(SoundPickupBackpack,$los::position);
							$TeamItemCount[GameBase::getTeam(%player) @ "HPCPack"]++;
							return true;

							}		
			else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

//=========================================================================

$TeamItemMax[HPCPack2] = 5; 

$TeamItemCount[0 @ HPCPack2] = 0;
$TeamItemCount[1 @ HPCPack2] = 0;
$TeamItemCount[2 @ HPCPack2] = 0;
$TeamItemCount[3 @ HPCPack2] = 0;

$InvList[HPCPack2] = 1;
$RemoteInvList[HPCPack2] = 1;

$ItemMax[larmor, HPCPack2] = 0;
$ItemMax[lfemale, HPCPack2] = 0;
$ItemMax[marmor, HPCPack2] = 1;
$ItemMax[mfemale, HPCPack2] = 1;
$ItemMax[harmor, HPCPack2] = 1;

ItemImageData HPCPack2Image
{
	shapeFile = "generator_p";
	mountPoint = 2;
	mountOffset = { 0, 0, 0 };
	mountRotation = { 0, 0, 0 };
	mass = 0.25;
	firstPerson = false;
};

ItemData HPCPack2
{
	
};

function HPCPack2::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function HPCPack2::onDeploy(%player,%item,%pos)
{
	if (HPCPack2::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}	

function HPCPack2::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,3)) {
			%obj = getObjectType($los::object);
		//	if (%obj == "SimTerrain" || %obj == "InteriorShape") {
		    		%set = newObject("set",SimSet);
				%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,$ForceFieldBoxMinLength,$ForceFieldBoxMinWidth,$ForceFieldBoxMinHeight,0);
				%num = CountObjects(%set,"wall",%num);
				deleteObject(%set);
				//if(0 == %num) {
				//	if (Vector::dot($los::normal,"0 0 1") > 0.7) {
						//if(checkDeployArea(%client,$los::position)) {
							%rot = GameBase::getRotation(%player);
							%wall = newObject("wall", "InteriorShape", "gswdrop.dis");
						//	%obj2 = getObjectType{%wall);
					//		Client::sendMessage(%client,0,"The Deployable Wall is a" @ %obj2  @ " !");

							addToSet("MissionCleanup", %wall);
							GameBase::setTeam(%fField,GameBase::getTeam(%player));
							GameBase::setPosition(%wall,$los::position);
							GameBase::setRotation(%wall,%rot);
							Gamebase::setMapName(%wall,"Starwolf Dropship");
							Client::sendMessage(%client,0,"Dropship Deployed");
							GameBase::startFadeIn(%wall);
							playSound(SoundPickupBackpack,$los::position);
						//	playSound(ForceFieldOpen,$los::position);
							$TeamItemCount[GameBase::getTeam(%player) @ "HPCPack"]++;
							return true;
						//}
				//	}
				//	else 
				//		Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
			//	} 
			//	else
			//		Client::sendMessage(%client,0,"Frequency Overload - Too close to other Force Fields");
		//	}
		//	else 
		//		Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
	}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

$InvList[obeliskpack] = 1;
$RemoteInvList[obeliskpack] = 1;

$TeamItemCount[0 @ obeliskpack] = 0;
$TeamItemCount[1 @ obeliskpack] = 0;
$TeamItemCount[2 @ obeliskpack] = 0;
$TeamItemCount[3 @ obeliskpack] = 0;

$TeamItemMax[obeliskpack] = 12;

$ItemMax[harmor, obeliskpack] = 0;
$ItemMax[marmor, obeliskpack] = 1;
$ItemMax[mfemale, obeliskpack] = 1;
$ItemMax[larmor, obeliskpack] = 0;
$ItemMax[lfemale, obeliskpack] = 0;

$InvList[obeliskPowerPack] = 1;
$RemoteInvList[obeliskPowerPack] = 1;

$TeamItemCount[0 @ obeliskPowerPack] = 0;
$TeamItemCount[1 @ obeliskPowerPack] = 0;
$TeamItemCount[2 @ obeliskPowerPack] = 0;
$TeamItemCount[3 @ obeliskPowerPack] = 0;

$TeamItemMax[obeliskPowerPack] = 2;

$ItemMax[harmor, obeliskPowerPack] = 0;
$ItemMax[marmor, obeliskPowerPack] = 1;
$ItemMax[mfemale, obeliskPowerPack] = 1;
$ItemMax[larmor, obeliskPowerPack] = 0;
$ItemMax[lfemale, obeliskPowerPack] = 0;

ItemImageData ObeliskPackImage
{
	shapeFile = "remoteturret";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -0.1 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData ObeliskPack
{
	description = "Obelisk of Light";
	shapeFile = "remoteturret";
	className = "Backpack";
   heading = "pTurrets";
	imageType = ObeliskPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 1350;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function ObeliskPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function ObeliskPack::onDeploy(%player,%item,%pos)
{
	if (ObeliskPack::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function ObeliskPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item])
	{
		if (GameBase::getLOSInfo(%player,3))
		{
			%Set = newObject("set",SimSet); 
			%Mask = $StaticObjectType; 
			%num =containerBoxFillSet(%Set, %Mask, $los::position, 70, 70, 50,0);
			for(%i; %i < %num; %i++)
			{
				%gen = Group::getObject(%Set, %i);
				if(%gen.obeliskpower && %gen.obelisk == "")
				{
					%powered = true;
					break;
				}
			}
			deleteObject(%Set);
			if(%powered)
			{
				%obj = getObjectType($los::object);
				if (%obj != "InteriorShape")
				{
					if (Vector::dot($los::normal,"0 0 1") > 0.7)
					{
						if(checkDeployArea(%client,$los::position))
						{
							%rot = GameBase::getRotation(%player); 

							%turret2 = newObject("ObeliskBarrel","Turret",RealObeliskOfLight,true);
	                 				addToSet("MissionCleanup", %turret2);
							GameBase::setTeam(%turret2,GameBase::getTeam(%player));
							GameBase::setPosition(%turret2,Vector::add($los::position, "0 0 11.5"));
							GameBase::setRotation(%turret2,%rot);

							%turret = newObject("Obelisk","StaticShape",ObeliskOfLight,true);
      	           				addToSet("MissionCleanup", %turret);
							GameBase::setTeam(%turret,GameBase::getTeam(%player));
							GameBase::setPosition(%turret,$los::position);
							GameBase::setRotation(%turret,%rot);

							%turret.realGun = %turret2; //referencing variables
							%turret.gen = %gen;
							%gen.obelisk = %turret2;

							Gamebase::setMapName(%turret,"Obelisk of Light " @ Client::getName(%client));
							Client::sendMessage(%client,0,"Obelisk of Light deployed");
							playSound(SoundPickupBackpack,$los::position);
							$TeamItemCount[GameBase::getTeam(%player) @ "ObeliskPack"]++;
							echo("MSG: ",%client," deployed an Obelisk of Light. Turret is:" @ %turret @ " and Turret2 is: " @ %turret2);
							//	Remote turrets - kill points to player that deploy them
							// Client::setOwnedObject(%client, %turret); 
							// Client::setOwnedObject(%client, %player);
							if(Player::getMountedItem(%player, $BackpackSlot) == SCVPack)
								GameBase::setDamageLevel(%turret, 0.7 * ObeliskOfLight.maxDamage);

							return true;
						}
					}
					else 
						Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
				}
				else 
					Client::sendMessage(%client,0,"Cannot deploy in buildings");
			}
			else
				Client::sendMessage(%client, 0, "Must be within range of an Obelisk Power Source");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

ItemImageData ObeliskPowerPackImage
{
	shapeFile = "generator_p";
	mountPoint = 2;
	mountOffset = { 0, -0.12, -1.0 };
	mountRotation = { 0, 0, 0 };
	mass = 1.0;
	firstPerson = false;
};

ItemData ObeliskPowerPack
{
	description = "Obelisk Power Source";
	shapeFile = "generator_p";
	className = "Backpack";
   heading =  "jDeployables";
	imageType = ObeliskPowerPackImage;
	shadowDetailMask = 4;
	mass = 1.0;
	elasticity = 0.2;
	price = 1000;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function ObeliskPowerPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function ObeliskPowerPack::onDeploy(%player,%item,%pos)
{
	if (ObeliskPowerPack::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function ObeliskPowerPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item])
	{
		if (GameBase::getLOSInfo(%player,3))
		{
			%obj = getObjectType($los::object);
			if (%obj != "InteriorShape")
			{
				if (Vector::dot($los::normal,"0 0 1") > 0.7)
				{
					if(checkDeployArea(%client,$los::position))
					{
						%rot = GameBase::getRotation(%player); 

						%generator = newObject("ObeliskPower","StaticShape",ObeliskPower,true);
                 				addToSet("MissionCleanup", %generator );
						GameBase::setTeam(%generator ,GameBase::getTeam(%player));
						GameBase::setPosition(%generator,$los::position);
						GameBase::setRotation(%generator,%rot);

						%generator.obeliskpower = true;

						Gamebase::setMapName(%turret,"Obelisk Power Source " @ Client::getName(%client));
						Client::sendMessage(%client,0,"Obelisk Power Source deployed");
						playSound(SoundPickupBackpack,$los::position);
						$TeamItemCount[GameBase::getTeam(%player) @ "ObeliskPowerPack"]++;
						echo("MSG: ",%client," deployed an Obelisk Power Source");
						//	Remote turrets - kill points to player that deploy them
						// Client::setOwnedObject(%client, %generator); 
						// Client::setOwnedObject(%client, %player);
						return true;
					}
				}
				else 
					Client::sendMessage(%client,0,"Can only deploy on flat surfaces");
			}
			else 
				Client::sendMessage(%client,0,"Cannot deploy in buildings");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

	return false;
}

//========================================================================================

