//=============================================================================================
# Damage Types
          
$ImpactDamageType		  = -1;
$LandingDamageType	  =  0;
$BulletDamageType      =  1;
$EnergyDamageType      =  2;
$PlasmaDamageType      =  3;
$ExplosionDamageType   =  4;
$ShrapnelDamageType    =  5;
$LaserDamageType       =  6;
$MortarDamageType      =  7;
$BlasterDamageType     =  8;
$ElectricityDamageType =  9;
$CrushDamageType       = 10;
$DebrisDamageType      = 11;
$MissileDamageType     = 12;
$MineDamageType        = 13;
$EMPDamageType         = 14;
$SniperDamageType         = 15;
$MethaneDamageType         = 16;
$ShotgunDamageType         = 17;
$MassDamageType         = 18;
$PBWDamageType         = 19;
$GaussDamageType         = 20;
$VulcanDamageType         = 21;
$VertigoDamageType         = 22;
$MBDamageType         = 23;
$FusionDamageType		= 24;
$FlameDamageType         = 25;
$FlierBombDamageType         = 26;
$PulseDamageType         = 27;
$MBHeatDamageType         = 28;
$NullDamageType         = 29;

//--------------------------------------
BulletData AssaultBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.20;
   damageType         = $BulletDamageType;

   aimDeflection      = 0.002;
   muzzleVelocity     = 425.0;
   totalTime          = 2.0;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//--------------------------------------
BulletData ChaingunBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.11;
   damageType         = $BulletDamageType;

   aimDeflection      = 0.005;
   muzzleVelocity     = 425.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//--------------------------------------
BulletData FireBullet
{
   bulletShapeName    = "tracer.dts";
   explosionTag       = noExp;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.11;
   damageType         = $ImpactDamageType;

   aimDeflection      = 0.005;
   muzzleVelocity     = 4425.0;
   totalTime          = 5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 0;
   tracerLength       = 0.001;
};

LaserData FireLaser
{
   laserBitmapName   = "reddish_wall.bmp"; 
   hitName           = "plasmaex.dts";

   damageConversion  = 0.025;
   baseDamageType    = $FlameDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = explosion4;
};

//--------------------------------------
BulletData VulcanBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.10;
   damageType         = $VulcanDamageType;

   aimDeflection      = 0.0025;
   muzzleVelocity     = 1425.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//--------------------------------------
BulletData Flamesz
{
   bulletShapeName    = "tumult_large.dts";
   explosionTag       = flameEXP;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.1;
   damageType         = $FlameDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 50.0;

   aimDeflection      = 0.01;
   muzzleVelocity     = 96.0;
   totalTime          = 1;
   inheritedVelocityScale = 1.0;
   isVisible          = True;
};

BulletData ShotgunBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = SmokeExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.1;
   damageType         = $ShotgunDamageType;

   aimDeflection      = 0.0157;
   muzzleVelocity     = 512.0;
   totalTime          = 3;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData RifleBullet
{
   bulletShapeName  = "bullet.dts";
   explosionTag     = bulletExp0;
   collisionRadius  = 0.0;
   mass             = 0.05;

   damageClass      = 0;
   damageValue      = 0.59;
   damageType       = $SniperDamageType;

   explosionRadius = 0.1;
   kickBackStrength = 600.0;
   muzzleVelocity = 4000.0;
   terminalVelocity = 4000.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 10.0;
   lightColor       = { 0.25, 0.25, 1 };
   inheritedVelocityScale = 1.0;

   trailType   = 1;         
   trailLength = 3000;
   trailWidth  = 0.6;
  
   soundId = SoundJetHeavy;
};

BulletData MassBullet
{
 bulletShapeName  = "bullet.dts";
   explosionTag     = bulletExp0;
   collisionRadius  = 0.0;
   mass             = 0.05;

   damageClass      = 0;
   damageValue      = 0.49;
   damageType       = $SniperDamageType;

   explosionRadius = 0.1;
   kickBackStrength = 600.0;
   muzzleVelocity = 4000.0;
   terminalVelocity = 4000.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 10.0;
   lightColor       = { 0.25, 0.25, 1 };
   inheritedVelocityScale = 1.0;

   trailType   = 1;         
   trailLength = 3000;
   trailWidth  = 0.6;
  
   soundId = SoundJetHeavy;
};

RocketData SniperRound 
{
  bulletShapeName  = "bullet.dts";
   explosionTag     = bulletExp0;
   collisionRadius  = 0.0;
   mass             = 0.05;

   damageClass      = 0;
   damageValue      = 0.39;
   damageType       = $SniperDamageType;

   explosionRadius = 0.1;
   kickBackStrength = 600.0;
   muzzleVelocity = 4000.0;
   terminalVelocity = 4000.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 10.0;
   lightColor       = { 0.25, 0.25, 1 };
   inheritedVelocityScale = 1.0;

   trailType   = 1;         
   trailLength = 3000;
   trailWidth  = 0.6;
  
   soundId = SoundJetHeavy;
};

RocketData RailRound 
{
  bulletShapeName  = "bullet.dts";
   explosionTag     = bulletExp0;
   collisionRadius  = 0.0;
   mass             = 0.05;

   damageClass      = 0;
   damageValue      = 0.79;
   damageType       = $SniperDamageType;

   explosionRadius = 0.1;
   kickBackStrength = 600.0;
   muzzleVelocity = 4000.0;
   terminalVelocity = 4000.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 10.0;
   lightColor       = { 0.25, 0.25, 1 };
   inheritedVelocityScale = 1.0;

   trailType   = 1;         
   trailLength = 3000;
   trailWidth  = 0.6;
  
   soundId = SoundJetHeavy;
};

BulletData PoisonDart
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.07;
   damageType         = $MethaneDamageType;

   muzzleVelocity     = 1425.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

//--------------------------------------
BulletData FusionBolt
{
   bulletShapeName    = "fusionbolt.dts";
   explosionTag       = turretExp;
   mass               = 0.05;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.25;
   damageType         = $EnergyDamageType;

   muzzleVelocity     = 50.0;
   totalTime          = 6.0;
   liveTime           = 4.0;
   isVisible          = True;

   rotationPeriod = 1.5;
};

RocketData Shock 
{
  bulletShapeName = "shotgunex.dts";
  explosionTag = LargeShockwave;
  collisionRadius = 0.0;
  mass = 2.0;
  damageClass = 1;
  damageValue = 0.15;
  damageType = $IonDamageType;
  explosionRadius = 55.0;
  kickBackStrength = 350.0;
  muzzleVelocity = 50.0;
  terminalVelocity = 80.0;
  acceleration = 5.0;
  totalTime = 6.0;
  liveTime = 4.0;
  lightRange = 5.0;
  lightColor = { 1.0, 0.7, 0.5 };
  inheritedVelocityScale = 0.5;
  soundId = SoundJetHeavy;
};

//--------------------------------------
BulletData Sonicblast
{
   bulletShapeName    = "paint.dts";
   explosionTag       = turretExp;
   mass               = 0.05;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.2;
   damageType         = $DisruptorDamageType;

   muzzleVelocity     = 999.0;
   totalTime          = 6.0;
   liveTime           = 4.0;
   isVisible          = True;

   rotationPeriod = 0.5;
};

//--------------------------------------
BulletData PTCBolt
{
   bulletShapeName    = "fusionbolt.dts";
   explosionTag       = turretExp;
   mass               = 0.05;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.25;
   damageType         = $EnergyDamageType;

   muzzleVelocity     = 100.0;
   totalTime          = 8.0;
   liveTime           = 6.0;
   isVisible          = True;

   rotationPeriod = 1.5;
};

BulletData PTCBolt2
{
   bulletShapeName    = "fusionbolt.dts";
   explosionTag       = turretExp;
   mass               = 0.05;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.25;
   damageType         = $EnergyDamageType;

   muzzleVelocity     = 255.0;
   totalTime          = 8.0;
   liveTime           = 6.0;
   isVisible          = True;

   rotationPeriod = 1.5;
};

//--------------------------------------
BulletData MiniFusionBolt
{
   bulletShapeName    = "enbolt.dts";
   explosionTag       = energyExp;

   damageClass        = 0;
   damageValue        = 0.1;
   damageType         = $EnergyDamageType;

   muzzleVelocity     = 80.0;
   totalTime          = 4.0;
   liveTime           = 2.0;

   lightRange         = 3.0;
   lightColor         = { 0.25, 0.25, 1.0 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

//--------------------------------------
BulletData BlasterBolt
{
   bulletShapeName    = "shotgunbolt.dts";
   explosionTag       = blasterExp;

   damageClass        = 0;
   damageValue        = 0.9;
   damageType         = $BlasterDamageType;

   muzzleVelocity     = 200.0;
   totalTime          = 2.0;
   liveTime           = 1.125;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

//--------------------------------------
BulletData PlasmaBolt
{
   bulletShapeName    = "plasmabolt.dts";
   explosionTag       = plasmaExp;

   damageClass        = 1;
   damageValue        = 0.45;
   damageType         = $PlasmaDamageType;
   explosionRadius    = 4.0;

   muzzleVelocity     = 55.0;
   totalTime          = 3.0;
   liveTime           = 2.0;
   lightRange         = 3.0;
   lightColor         = { 1, 1, 0 };
   inheritedVelocityScale = 0.3;
   isVisible          = True;

   soundId = SoundJetLight;
};

//--------------------------------------
//--------------------------------------
RocketData DiscShell
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;

   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $ExplosionDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 250.0;

   muzzleVelocity   = 175.0;
   terminalVelocity = 195.0;
   acceleration     = 15.0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

      // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plastrail.dts";
   smokeDist   = 1.8;

   soundId = SoundDiscSpin;
};

SeekingMissileData DiscShellTracker 
{
bulletShapeName = "discb.dts";
explosionTag = rocketExp;
collisionRadius = 0.0;
mass = 2.0;
damageClass = 1;
damageValue = 0.6;
damageType = $ExplosionDamageType;
explosionRadius = 7.5;
kickBackStrength = 200.0;
muzzleVelocity = 80.0;
terminalVelocity = 500.0;
acceleration = 10.0;
totalTime = 20.0;
liveTime = 21.0;
lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

      // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plastrail.dts";
   smokeDist   = 1.8;

   soundId = SoundDiscSpin;
};


//--------------------------------------
GrenadeData Smoke2
{
   bulletShapeName    = "rsmoke.dts";
   explosionTag       = smokefade;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.002;
   mass               = -0.25;
   elasticity         = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0;
   damageType         = $NullDamageType;

   kickBackStrength   = 0.0;
   maxLevelFlightDist = 150;
   totalTime          = 1.0;    // special meaning for grenades...
   liveTime           = 0.75;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "rsmoke.dts";
};

//--------------------------------------
GrenadeData Smoke
{
   bulletShapeName    = "rsmoke.dts";
   explosionTag       = smokefade;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.002;
   mass               = -1;
   elasticity         = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0;
   damageType         = $NullDamageType;

   kickBackStrength   = 0.0;
   maxLevelFlightDist = 0;
   totalTime          = 1.0;    // special meaning for grenades...
   liveTime           = 0.75;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "rsmoke.dts";
};

//--------------------------------------
GrenadeData GrenadeShell
{
   bulletShapeName    = "grenade.dts";
   explosionTag       = grenadeExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.4;
   damageType         = $ShrapnelDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 150;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 1.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

//--------------------------------------

RocketData RPG
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = grenadeExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.4;
   damageType       = $ShrapnelDamageType;

   explosionRadius  = 15;
   kickBackStrength = 150.0;
   muzzleVelocity   = 200.0;
   terminalVelocity = 300.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 6;

   soundId = SoundJetHeavy;
};

SeekingMissileData SeekingRPG
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = grenadeExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.4;
   damageType       = $ShrapnelDamageType;

   explosionRadius  = 15;
   kickBackStrength = 150.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   seekingTurningRadius    = 9;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 1.5;
   smokeDist         = 6;

   soundId = SoundJetHeavy;
};

//--------------------------------------
GrenadeData MortarShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.9;
   damageType         = $MortarDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 2.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

GrenadeData ImpactMortarShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.9;
   damageType         = $MortarDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 0.001;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

GrenadeData RubberMortarShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.75;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.0;
   damageType         = $MortarDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 6.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

//--------------------------------------
// EMP Mortar  - *IX*Savage1
//--------------------------------------

GrenadeData EMPGrenadeShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = PulseExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.1;
   damageType         = $EMPDamageType;

   explosionRadius    = 40;
   kickBackStrength   = -50.0;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.25;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;
   smokeName              = "fusionbolt.dts";
   soundId = SoundELFFire;
};

RocketData RPM
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = mortarExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 1.5;
   damageType       = $MortarDamageType;

   explosionRadius  = 20;
   kickBackStrength = 250.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 6;

   soundId = SoundJetHeavy;
};

SeekingMissileData SeekingRPM
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = mortarExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 1.0;
   damageType       = $MortarDamageType;

   explosionRadius  = 20;
   kickBackStrength = 250.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   seekingTurningRadius    = 9;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 1.5;
   smokeDist         = 6;

   soundId = SoundJetHeavy;
};

RocketData RPEMP
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = PulseExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.1;
   damageType       = $EMPDamageType;

   explosionRadius  = 40;
   kickBackStrength = -50.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 6;

   soundId = SoundJetHeavy;
};

SeekingMissileData SeekingRPEMP
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = PulseExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.1;
   damageType       = $EMPDamageType;

   explosionRadius  = 40;
   kickBackStrength = -50.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   seekingTurningRadius    = 9;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 1.5;
   smokeDist         = 6;

   soundId = SoundJetHeavy;
};

//--------------------------------------
GrenadeData MortarTurretShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   collideWithOwner   = True;
   ownerGraceMS       = 400;
   collisionRadius    = 1.0;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.32;
   damageType         = $MortarDamageType;

   explosionRadius    = 30.0;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 400;
   totalTime          = 1000.0;
   liveTime           = 2.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
};

//--------------------------------------
RocketData FlierRocket
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = rocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MissileDamageType;

   explosionRadius  = 9.5;
   kickBackStrength = 250.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

RocketData StdRocket
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = boltexp5;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MissileDamageType;

   explosionRadius  = 9.5;
   kickBackStrength = 250.0;
   muzzleVelocity   = 150.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

RocketData SuperBlaster
{
   bulletShapeName = "rocket.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;
   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $ExplosionDamageType;
   explosionRadius  = 15;
   kickBackStrength = 80;
   muzzleVelocity   = 200.0;
   terminalVelocity = 1000.0;
   acceleration     = 150.0;
   totalTime        = 8.5;
   liveTime         = 18.0;
   lightRange       = 5.0;
   lightColor       = { 0.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.75;

   trailType   = 1;
   trailLength = 35;
   trailWidth  = 0.40;
   soundId = SoundJetHeavy;
};

RocketData DisruptorBeam
{
   bulletShapeName  = "paint.dts";
   explosionTag     = boltexp2;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $EnergyDamageType;

   explosionRadius  = 7;
   kickBackStrength = 50.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "paint.dts";
   smokeDist   = 15.7;

   soundId = SoundJetHeavy;
};

//--------------------------------------
SeekingMissileData TurretMissile
{
   bulletShapeName = "rocket.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MissileDamageType;
   explosionRadius  = 9.5;
   kickBackStrength = 175.0;

   muzzleVelocity    = 72.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 9;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 1.5;
   smokeDist         = 1.75;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

RocketData Culex
{
   bulletShapeName  = "mortar.dts";
   explosionTag     = boltexp5;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MissileDamageType;

   explosionRadius  = 9.5;
   kickBackStrength = 250.0;
   muzzleVelocity   = 128.0;
   terminalVelocity = 132.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

SeekingMissileData Culexx
{
   bulletShapeName = "mortar.dts";
   explosionTag    = boltexp5;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MissileDamageType;
   explosionRadius  = 9.5;
   kickBackStrength = 175.0;

   muzzleVelocity    = 128.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 9;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 1.5;
   smokeDist         = 1.75;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

function SeekingMissile::updateTargetPercentage(%target)
{
   return GameBase::virtual(%target, "getHeatFactor");
}

//-------------------------------------- 
// These are kinda oddball dat's
// the lasers really don't fit into
// the typical projectile catagories...
//--------------------------------------

LaserData sniperLaser
{
   laserBitmapName   = "laserpulse.bmp"; //warp
   hitName           = "laserhit.dts";

   damageConversion  = 0.025;
   baseDamageType    = $LaserDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;
};

LaserData DesignatorX
{
   laserBitmapName   = "paintpulse.bmp"; 
   hitName           = "paint.dts";

   damageConversion  = 0.0;
   baseDamageType    = $NullDamageType;

   beamTime          = 5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = true;
   hitSoundId        = explosion3;
};

LaserData VertigoBeam2
{
   laserBitmapName   = "paintpulse.bmp"; 
   hitName           = "paint.dts";

   damageConversion  = 0.1;
   baseDamageType    = $VertigoDamageType;

   beamTime          = 5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = explosion3;
};

LaserData sniperMaser
{
   laserBitmapName   = "forcefield1.bmp";
   hitName           = "laserhit.dts";

   damageConversion  = 0.028;
   baseDamageType    = $LaserDamageType;

   beamTime          = 0.5;

   lightRange        = 4.0;
   lightColor        = { 0.25, 0.25, 0.85 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;

};

LaserData AlienRay
{
   laserBitmapName   = "warp.bmp";
   hitName           = "laserhit.dts";
   damageConversion  = 0.029;
   baseDamageType    = $LaserDamageType;
   beamTime          = 0.5;
   lightRange        = 1.0;
   lightColor        = { 0.0, 1.25, 1.25 };
   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;
};

LaserData HyperLaserBeam
{
  laserBitmapName = "paintpulse.bmp";
  firePosition = { 0.0, 0.0, 1.0 };
  hitName = "laserhit.dts";
  damageConversion = 0.02;
  baseDamageType = $LaserDamageType;
  beamTime = 0.2;
  lightRange = 4.0;
  lightColor = { 1.0, 0.25, 0.25 } ;
  detachFromShooter = false;
};

LaserData SonicDistortion
{
   laserBitmapName   = "paintpulse.bmp"; 	
   hitName           = "enex.dts";

   damageConversion  = 0.02;
   damageClass      = 1;
   explosionRadius  = 5;
   baseDamageType    = $LandingDamageType;

   beamTime          = 1;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = bigexplosion2;
};

LaserData Maser
{
   laserBitmapName   = "forcefield1.bmp";
   hitName           = "laserhit.dts";

   damageConversion  = 0.029;
   baseDamageType    = $LaserDamageType;

   beamTime          = 0.5;

   lightRange        = 4.0;
   lightColor        = { 0.25, 0.25, 0.85 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;

};

LaserData MaserH
{
   laserBitmapName   = "paintpulse.bmp";
   hitName           = "paint.dts";

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.019;
   damageType       = $FlameDamageType;
   explosionRadius  = 5;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = explosion4;
};

LaserData ParticleBeam
{
   laserBitmapName   = "warp.bmp"; 
   hitName           = "shockwave_large.dts";

   damageConversion  = 0.048;
   baseDamageType    = $PBWDamageType;

   beamTime          = 1;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundFlierCrash;
};

TargetLaserData targetLaser
{
   laserBitmapName   = "paintPulse.bmp";

   damageConversion  = 0.0;
   baseDamageType    = 0;

   lightRange        = 2.0;
   lightColor        = { 0.25, 1.0, 0.25 };

   detachFromShooter = false;
};

LightningData lightningCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 50.0;
   coneAngle        = 35.0;
   damagePerSec      = 0.25;
   energyDrainPerSec = 100.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.125;//075;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

RepairEffectData RepairBolt
{
   bitmapName       = "repairadd.bmp";
   boltLength       = 50.0;
   segmentDivisions = 4;
   beamWidth        = 0.125;

   updateTime   = 350;
   skipPercent  = 0.6;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.85, 0.25, 0.25 };
};

function RepairBolt::onAcquire(%this, %player, %target)
{
	%Tp=Gamebase::getTeam(%player);
	%Tt=GameBase::getTeam(%target);
	%client = Player::getClient(%player);

	if (%Tp!=%Tt && %Tt!=-1)
	{	Client::sendMessage(%client, 0, "REPAIR PACK OVERLOAD!! : This Repair pack is NOT Compatable with this Equipment!!~wError_Message.wav");
		%player.Overloaded=true;
		%Pos=GameBase::getPosition(%player);
		playsound(ForceFieldFeedback,%pos);
		return;
	}

	%client = Player::getClient(%player);

	if (%target == %player) {
	   %player.repairTarget = -1;
		if (GameBase::getDamageLevel(%player) != 0) {
			%player.repairRate = 0.05;
			%player.repairTarget = %player;
			Client::sendMessage(%client, 0, "AutoRepair On");
		}
		else {
			Client::sendMessage(%client,0,"Nothing in range");
			Player::trigger(%player, $WeaponSlot, false);
			return;
		}
	}
	else {
      %player.repairTarget = %target;
		%player.repairRate   = 0.1;
		if (getObjectType(%player.repairTarget) == "Player") {
			%rclient = Player::getClient(%player.repairTarget);
			%name = Client::getName(%rclient);
		}
		else { 
			%name = GameBase::getMapName(%target);
			if(%name == "") {
				%name = (GameBase::getDataName(%player.repairTarget)).description;
			}
		}
		if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
			Client::sendMessage(%client,0,%name @ " is not damaged");
			Player::trigger(%player,$WeaponSlot,false);
			%player.repairTarget = -1;
			return;
		}
		if (getObjectType(%player.repairTarget) == "Player") {
			Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
		}
		Client::sendMessage(%client,0,"Repairing " @ %name);
	}
	%rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
	GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function RepairBolt::onRelease(%this, %player)
{
if(%player.overloaded==true)
	{	// Drop & Delete Pack....
		if($matchStarted) 
		{	Player::trigger(%player, $WeaponSlot, false);
			%item=Player::getMountedItem(%player,$BackpackSlot);
			%mounted = Player::getMountedItem(%player,$WeaponSlot);
			if (%mounted == RepairGun) 
			{	Player::unmountItem(%player,$WeaponSlot);
			}
			else 
			{	// Remount the existing weapon to make sure the RepairGun
				// is not on the delayed mount "stack".
				Player::mountItem(%player,%mounted,$WeaponSlot);
			}

			Player::decItemCount(%player,%item,1);
			
			// Create a Grenade that looks like a repair pack...
			
			%obj = newObject("","Mine","pocketnuke1");
			addToSet("MissionCleanup", %obj);
			// Drop It.. & Detonate in .2 Second...
			GameBase::throw(%obj,%player,0.5,false);
		}
		return;
	}

	%object = %player.repairTarget;
	if (%object != -1) {
		%client = Player::getClient(%player);
		if (%object == %player) {
			Client::sendMessage(%client,0,"AutoRepair Off");
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Client::sendMessage(%client,0,"Repair Done");
			}
			else {
				Client::sendMessage(%client,0,"Repair Stopped");
			}
		}
		%rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;
      
		GameBase::setAutoRepairRate(%object,%rate);
	}
}

function RepairBolt::checkDone(%this, %player)
{
	if (Player::isTriggered(%player,$WeaponSlot) && 
       Player::getMountedItem(%player,$WeaponSlot) == RepairGun &&
		 %player.repairTarget != -1) {
		%object = %player.repairTarget;
		if (%object == %player) {
			if (GameBase::getDamageLevel(%player) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
	}
}

//--------------------------------------
BulletData GaussBullet
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp3;
   mass               = 0.05;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.35;
   damageType         = $GaussDamageType;

   explosionRadius    = 7.5;
   aimDeflection      = 0.005;
   muzzleVelocity     = 725.0;
   totalTime          = 10.5;
   inheritedVelocityScale = 1.0;
   isVisible          = False;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData MortarTurretBullet
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = mortarExp;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.1;
   damageType         = $CTurretDamageType;

   aimDeflection      = 0.006;
   muzzleVelocity     = 425.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;
   isVisible          =true;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData Flame
{
   bulletShapeName    = "tumult_small.dts";
   explosionTag       = flameExp;

   damageClass        = 1;
   damageValue        = 0.1;
   damageType         = $FlameDamageType;
   explosionRadius    = 7;
   aimDeflection      = 0.01;

   muzzleVelocity     = 100.0;
   totalTime          = 5.0;
   liveTime           = 4.125;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

//   rotationPeriod = 1;
};

//--------------------------------------
BulletData StraightFlame
{
   bulletShapeName    = "tumult_small.dts";
   explosionTag       = flameExp;

   damageClass        = 1;
   damageValue        = 0.1;
   damageType         = $FlameDamageType;
   explosionRadius    = 7;
   aimDeflection      = 0.01;

   muzzleVelocity     = 100.0;
   totalTime          = 5.0;
   liveTime           = 4.125;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

//   rotationPeriod = 1;
};

//--------------------------------------
BulletData CannonFlame
{
   bulletShapeName    = "tumult_small.dts";
   explosionTag       = boltexp5;

   damageClass        = 1;
   damageValue        = 0.2;
   damageType         = $FlameDamageType;
   explosionRadius    = 15;

   muzzleVelocity     = 100.0;
   totalTime          = 5.0;
   liveTime           = 4.125;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

};

//--------------------------------------
BulletData Ice
{
   bulletShapeName    = "fusionbolt.dts";
   explosionTag       = fliceExp;

   damageClass        = 1;
   damageValue        = 0.2;
   damageType         = $IceDamageType;
   explosionRadius    = 5;
   aimDeflection      = 0.01;

   muzzleVelocity     = 75.0;
   totalTime          = 5.0;
   liveTime           = 4.125;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

};

BulletData GatlingBlasterBolt
{
   bulletShapeName    = "shotgunbolt.dts";
   explosionTag       = blasterExp;

   damageClass        = 1;
   damageValue        = 0.1;
   damageType         = $BlasterDamageType;

   muzzleVelocity     = 700.0;
   explosionRadius    = 2.5;
   totalTime          = 10.0;
   liveTime           = 8.255;
   aimDeflection      = 0.0075;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

RocketData IonShock
{
   bulletShapeName  = "fusionbolt.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.99;
   damageType       = $ElectricityDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 3.14;

   soundId = SoundELFIdle;
};

RocketData VertigoBeam
{
   bulletShapeName  = "laserhit.dts";
   explosionTag     = VertigoExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $VertigoDamageType;

   explosionRadius  = 8;
   kickBackStrength = 0.0;
   muzzleVelocity   = 85.0;
   terminalVelocity = 255.0;
   acceleration     = 15.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "laserhit.dts";
   smokeDist   = 3.14;

   soundId = SoundELFIdle;
};

RocketData VertigoBeambig
{
   bulletShapeName  = "plasmabolt.dts";
   explosionTag     = VertigoExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.4;
   damageType       = $VertigoDamageType;

   explosionRadius  = 8;
   kickBackStrength = 64.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plasmabolt.dts";
   smokeDist   = 3.14;

   soundId = SoundELFIdle;
};

RocketData IonShok
{
   bulletShapeName  = "fusionbolt.dts";
   explosionTag     = boltExp6;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.09;
   damageType       = $ElectricityDamageType;

   explosionRadius  = 16;
   kickBackStrength = 12.0;
   muzzleVelocity   = 512.0;
   terminalVelocity = 768.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 3.14;

   soundId = SoundELFIdle;
};

RocketData IonShockx
{
   bulletShapeName  = "fusionex.dts";
   explosionTag     = boltexp3;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.6;
   damageType       = $ElectricityDamageType;

   explosionRadius  = 16;
   kickBackStrength = 12.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionex.dts";
   smokeDist   = 3.14;

   soundId = SoundELFIdle;
};

RocketData IonShockz
{
   bulletShapeName  = "enex.dts";
   explosionTag     = boltexp4;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.6;
   damageType       = $ElectricityDamageType;

   explosionRadius  = 16;
   kickBackStrength = 12.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "enex.dts";
   smokeDist   = 3.14;

   soundId = SoundELFIdle;
};

RocketData InoShock6
{
   bulletShapeName  = "shield_medium.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.79;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shockwave_large.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData IonShock3
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 1;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData IonShock4
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $EMPDamageType;

   explosionRadius  = 16;
   kickBackStrength = 64.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "paint.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData IonShock5
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData IonShock6
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $MethaneDamageType;

   explosionRadius  = 16;
   kickBackStrength = 0.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "smoke.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData IonShock7
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.01;
   damageType       = $MBHeatDamageType;

   explosionRadius  = 16;
   kickBackStrength = 32.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plasmatrail.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

BulletData MiniMissile
{
   bulletShapeName    = "rocket.dts";
   explosionTag       = Exp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.255;
   damageType         = $MissileDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 50.0;

   aimDeflection      = 0.005;
   muzzleVelocity     = 255.0;
   totalTime          = 17.5;
   inheritedVelocityScale = 1.0;
   isVisible          = True;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

BulletData EcstacyShot
{
   bulletShapeName    = "rocket.dts";
   explosionTag       = Exp0;
   expRandCycle       = 3;
   mass               = 0.05;
   bulletHoleIndex    = 0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.255;
   damageType         = $MissileDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 50.0;

   aimDeflection      = 0.025;
   muzzleVelocity     = 255.0;
   totalTime          = 17.5;
   inheritedVelocityScale = 1.0;
   isVisible          = True;

   tracerPercentage   = 1.0;
   tracerLength       = 30;
};

RocketData flierLaser
{
   bulletShapeName  = "fusionbolt.dts";
   explosionTag     = shockwave;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.095;
   damageType       = $FusionDamageType;

   explosionRadius  = 12.5;
   kickBackStrength = 150.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "hflame.dts";
   smokeDist   = 3.141592654;

   soundId = SoundJetHeavy;
};

LaserData GatlingLaser
{
   laserBitmapName   = "paintpulse.bmp";
   hitName           = "paint.dts";

   damageConversion  = 0.039;
   baseDamageType    = $LaserDamageType;

   beamTime          = 0.5;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;
};

function SuperRBolt::onAcquire(%this, %player, %target)
{
	%client = Player::getClient(%player);

	if (%target == %player) {
	   %player.repairTarget = -1;
		if (GameBase::getDamageLevel(%player) != 0) {
			%player.repairRate = 0.8;
			%player.repairTarget = %player;
			Client::sendMessage(%client, 0, "AutoRepair On");
		}
		else {
			Client::sendMessage(%client,0,"Nothing in range");
			Player::trigger(%player, $WeaponSlot, false);
			return;
		}
	}
	else {
      %player.repairTarget = %target;
		%player.repairRate   = 0.6;
		if (getObjectType(%player.repairTarget) == "Player") {
			%rclient = Player::getClient(%player.repairTarget);
			%name = Client::getName(%rclient);
		}
		else { 
			%name = GameBase::getMapName(%target);
			if(%name == "") {
				%name = (GameBase::getDataName(%player.repairTarget)).description;
			}
		}
		if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
			Client::sendMessage(%client,0,%name @ " isn't damaged");
			Player::trigger(%player,$WeaponSlot,false);
			%player.repairTarget = -1;
			return;
		}
		if (getObjectType(%player.repairTarget) == "Player") {
			Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
		}
		Client::sendMessage(%client,0,"Repairing " @ %name);
	}
	%rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
	GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function SuperRBolt::onRelease(%this, %player)
{
	%object = %player.repairTarget;
	if (%object != -1) {
		%client = Player::getClient(%player);
		if (%object == %player) {
			Client::sendMessage(%client,0,"AutoRepair Off");
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Client::sendMessage(%client,0,"Repair Done");
			}
			else {
				Client::sendMessage(%client,0,"Repair Stopped");
			}
		}
		%rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;
      
		GameBase::setAutoRepairRate(%object,%rate);
	}
}

function SuperRBolt::checkDone(%this, %player)
{
	if (Player::isTriggered(%player,$WeaponSlot) && 
       Player::getMountedItem(%player,$WeaponSlot) == AODSuperRGun &&
		 %player.repairTarget != -1) {
		%object = %player.repairTarget;
		if (%object == %player) {
			if (GameBase::getDamageLevel(%player) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
	}
}

//====================================================================Gunboy

GrenadeData Deploybox
{
   bulletShapeName    = "smoke.dts";
   explosionTag       = BExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0;
   damageType         = $NullDamageType;

   explosionRadius    = 1;
   kickBackStrength   = 1.0;
   maxLevelFlightDist = 128;
   totalTime          = 5.0;    // special meaning for grenades...
   liveTime           = 4.1;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

	smokeName              = "smoke.dts";
};

function Deploybox::onAdd(%this)
{
	schedule("DeployGunboy(" @ %this @ ");",4.0,%this);
}

function DeployMines(%this)
{
		%obj = newObject("","Mine","AntipersonelMine");
		GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "5 5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "5 -5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "-5 5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "-5 -5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "0 5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "5 0 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "-5 0 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
			GameBase::setTeam (%obj,GameBase::getTeam (%player));
		addToSet("MissionCleanup", %obj);
		%padd = "0 -5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

}

GrenadeData Deploybox2
{
   bulletShapeName    = "mine.dts";
   explosionTag       = BExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 25.0;
   elasticity         = 0.001;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0;
   damageType         = $NullDamageType;

   explosionRadius    = 1;
   kickBackStrength   = 1.0;
   maxLevelFlightDist = 128;
   totalTime          = 5.0;    // special meaning for grenades...
   liveTime           = 4.1;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

	smokeName              = "smoke.dts";
};

function Deploybox2::onAdd(%this)
{
	schedule("DeployGunboy(" @ %this @ ");",4.0,%this);
}

function DeployGunboy(%this)
{
		%obj = newObject("","Mine","AntipersonelMine");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
		addToSet("MissionCleanup", %obj);
		%padd = "5 0 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
		addToSet("MissionCleanup", %obj);
		%padd = "-5 0 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
		addToSet("MissionCleanup", %obj);
		%padd = "0 -5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","AntipersonelMine");
		addToSet("MissionCleanup", %obj);
		%padd = "0 5 0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

}

GrenadeData ClusterBomb         //Modified by: MegaMan
{
   bulletShapeName    = "Shockwave_Large.dts";
   explosionTag       = LargeShockwave;
   collideWithOwner   = True;
   ownerGraceMS       = 500;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.4;

   damageClass        = 10;       // 0 impact, 1, radius
   damageValue        = 1;
   damageType         = $FlierBombDamageType;

   explosionRadius    = 60.0;
   kickBackStrength   = 100.0;
   maxLevelFlightDist = 350;
   totalTime          = 50.0;
   liveTime           = 6.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "paint.dts";
};

function ClusterBomb::onAdd(%this)
{
	schedule("BombSpread(" @ %this @ ");",5.1,%this);
}

function bombspread(%this)
{
		%obj = newObject("","Mine","bomba");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 5.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombb");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 15.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombc");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 25";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombd");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 25";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombe");
		addToSet("MissionCleanup", %obj);
		%padd = "10.0 0 25";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombe");
		addToSet("MissionCleanup", %obj);
		%padd = "-10.0 0 25";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombe");
		addToSet("MissionCleanup", %obj);
		%padd = "0 10. 25";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombe");
		addToSet("MissionCleanup", %obj);
		%padd = "0 -10.0 25";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombe");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 35";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","bombf");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 15";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

}

//----------------------------------------------------------
GrenadeData AtomicBomb         //added by Werewolf   Modified by: Bhall
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = LargeShockwave;
   collideWithOwner   = True;
   ownerGraceMS       = 5000;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 20;
   damageType         = $FlierBombDamageType;

   explosionRadius    = 50.0;
   kickBackStrength   = 1000.0;
   maxLevelFlightDist = 350;
   totalTime          = 50.0;
   liveTime           = 8.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "mortartrail.dts";
//   smokeName              = "rsmoke.dts";
};

function AtomicBomb::onAdd(%this)
{
	schedule("NuclearExplosion(" @ %this @ ");",4.9,%this);
}

function NuclearExplosion(%this)
{
		%obj = newObject("","Mine","NBase");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 5.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing1");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 5.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing2");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 10.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing3");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 15.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing4");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 20.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing5");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 25.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud1");
		addToSet("MissionCleanup", %obj);
		%padd = "15.0 0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud2");
		addToSet("MissionCleanup", %obj);
		%padd = "-15.0 0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud3");
		addToSet("MissionCleanup", %obj);
		%padd = "0 15.0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud4");
		addToSet("MissionCleanup", %obj);
		%padd = "0 -15.0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud5");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 60.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);
}

//----------------------------------------------------------

GrenadeData SpiritBomb         //Mega Man 1024
{
   bulletShapeName    = "shockwave_large.dts";
   explosionTag       = LargeShockwave;
   collideWithOwner   = True;
   ownerGraceMS       = 5000;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 20;
   damageType         = $FlierBombDamageType;

   explosionRadius    = 100.0;
   kickBackStrength   = 1000.0;
   maxLevelFlightDist = 350;
   totalTime          = 50.0;
   liveTime           = 6.5;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "shockwave_large.dts";
};

function AtomicBomb::onAdd(%this)
{
	schedule("NuclearExplosion(" @ %this @ ");",4.9,%this);
}

function NuclearExplosion(%this)
{
		%obj = newObject("","Mine","NBase");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 5.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing1");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 5.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing2");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 10.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing3");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 15.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing4");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 20.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NRing5");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 25.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud1");
		addToSet("MissionCleanup", %obj);
		%padd = "15.0 0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud2");
		addToSet("MissionCleanup", %obj);
		%padd = "-15.0 0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud3");
		addToSet("MissionCleanup", %obj);
		%padd = "0 15.0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud4");
		addToSet("MissionCleanup", %obj);
		%padd = "0 -15.0 40.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud1");
		addToSet("MissionCleanup", %obj);
		%padd = "15.0 0 55.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud2");
		addToSet("MissionCleanup", %obj);
		%padd = "-15.0 0 55.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud3");
		addToSet("MissionCleanup", %obj);
		%padd = "0 15.0 55.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud4");
		addToSet("MissionCleanup", %obj);
		%padd = "0 -15.0 55.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud5");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 70.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

		%obj = newObject("","Mine","NCloud6");
		addToSet("MissionCleanup", %obj);
		%padd = "0 0 75.0";
		%pos = Vector::add(GameBase::getPosition(%this), %padd);
		GameBase::setPosition(%obj, %pos);

}

LaserData ObeliskBeam
{
   laserBitmapName   = "laserPulse.bmp";
   hitName           = "laserhit.dts";

   damageConversion  = 0.025;
   damageType    = $LaserDamageType;

   beamTime          = 0.5;
   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;
};

RocketData FusionBall
{
   bulletShapeName  = "plasmaex.dts";
   explosionTag     = LargeShockwave;
   collisionRadius  = 0.0;
   mass             = 0.5;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.75;
   damageType       = $FusionDamageType;

   explosionRadius  = 12.8;
   kickBackStrength = 475.0;
   muzzleVelocity   = 768.0;
   terminalVelocity = 1024.0;
   acceleration     = 32.0;
   totalTime        = 10.0;
   liveTime         = 11.0;

   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

//--------------------------------------
BulletData SwarmerRocket
{
   bulletShapeName    = "rocket.dts";
   explosionTag       = flashExpLarge;

   damageClass        = 1;
   damageValue        = 0.25;
   damageType         = $PlasmaDamageType;
   explosionRadius    = 6.0;
   aimDeflection      = 0.015;

   muzzleVelocity     = 155.0;
   totalTime          = 3.0;
   liveTime           = 2.0;
   lightRange         = 3.0;
   lightColor         = { 1, 1, 0 };
   inheritedVelocityScale = 0.3;
   isVisible          = True;

   soundId = SoundJetLight;
};

RocketData NukeTurret
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = rocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 75;
   damageType       = $MissileDamageType;

   explosionRadius  = 9.5;
   kickBackStrength = 500.0;

   muzzleVelocity   = 90.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

LaserData WatchdogLaser
{
   laserBitmapName   = "paintPulse.bmp";
   hitName           = "laserhit.dts";

   damageConversion  = 0.001; //0.010;
   baseDamageType    = $LaserDamageType;

   beamTime          = 0.8;//0.53;

   lightRange        = 10.0;
   lightColor        = { 0.25, 1.0, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;
};

RocketData TurretDiscShell
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;

   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.75;
   damageType       = $ExplosionDamageType;

   explosionRadius  = 7.5;
   kickBackStrength = 150.0;

   muzzleVelocity   = 75.0;
   terminalVelocity = 100.0;
   acceleration     = 15.0;

   totalTime        = 6.5;
   liveTime         = 8.0;

   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 1;
   trailLength = 100;
   trailWidth  = 0.3;

   soundId = SoundDiscSpin;
};

//--------------------------------------
SeekingMissileData SwarmRocketSeeking
{
   bulletShapeName = "rocket.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.33;
   damageType       = $MissileDamageType;
   explosionRadius  = 9.5;
   kickBackStrength = 25.0;

   muzzleVelocity    = 85.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 9;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 1.5;
   smokeDist         = 1.75;

   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };

   inheritedVelocityScale = 0.5;

   soundId = SoundJetHeavy;
};

BulletData SwarmRocketMiss
{
   bulletShapeName = "rocket.dts";
   explosionTag    = rocketExp;
   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.6;
   damageType       = $MissileDamageType;
   explosionRadius  = 9.5;
   kickBackStrength = 15.0;

   aimDeflection    = 0.006;
   muzzleVelocity   = 65.0;
   totalTime        = 6.0;
   liveTime         = 6.0;

   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

RocketData ChargedFusionBolt
{
   bulletShapeName  = "fusionbolt.dts";
   explosionTag     = rocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.85;
   damageType       = $FusionDamageType;

   explosionRadius  = 12.5;
   kickBackStrength = 150.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "hflame.dts";
   smokeDist   = 3.141592654;

   soundId = SoundJetHeavy;
};

RocketData fluxbolt
{
   bulletShapeName  = "plasma.dts";
   explosionTag     = rocketExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 75;
   damageType       = $ElectricityDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plasma.dts";
   smokeDist   = 3.14;

   soundId = SoundELFIdle;
};

//--------------------------------------
BulletData DisruptorBolt
{
   bulletShapeName    = "paint.dts";
   explosionTag       = disexp;

   damageClass        = 1;
   damageValue        = 0.55;
   damageType         = $DisruptorDamageType;
   explosionRadius    = 2.5;

   muzzleVelocity     = 150.0;
   totalTime          = 10.0;
   liveTime           = 7;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

//--------------------------------------
BulletData BusterBolt
{
   bulletShapeName    = "paint.dts";
   explosionTag       = disexp;

   damageClass        = 1;
   damageValue        = 0.5;
   damageType         = $DisruptorDamageType;
   explosionRadius    = 5;

   muzzleVelocity     = 300.0;
   totalTime          = 10.0;
   liveTime           = 7;

   lightRange         = 3.0;
   lightColor         = { 1.0, 0.25, 0.25 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

LaserData aaLaser
{
   laserBitmapName   = "lightningNew.bmp";
   hitName           = "tumult_small.dts";

   damageConversion  = 0.012;
   baseDamageType    = $SniperDamageType;

   beamTime          = 0.75;

   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundFlierCrash;
};

RocketData AntiMatterBolt
{
   bulletShapeName  = "shockwave_large.dts";
   explosionTag     = LargeShockwave;
   collisionRadius  = 0.0;
   mass             = 0.5;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 3.14;
   damageType       = $ImpactDamageType;

   explosionRadius  = 64;
   kickBackStrength = 512.0;
   muzzleVelocity   = 32.0;
   terminalVelocity = 128.0;
   acceleration     = 32.0;
   totalTime        = 10.0;
   liveTime         = 9.0;

   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   trailType   = 2;                // smoke trail
   trailString = "smoke.dts";
   smokeDist   = 3.1415926; // Pi

   soundId = SoundJetHeavy;
};

BulletData sniperXBullet
{        bulletShapeName = "smoke.dts";
        explosionTag        = SniperXExp;
        mass                        = 2.0;
        collisionRadius = 0.0;
        ExplosionRadius = 7.5;
        damageClass                = 1;
        damageValue                = 1.32;
        damageType                = $SniperXDamageType;
        muzzleVelocity        = 999;
        totalTime                = 9;
        liveTime                = 9;
        inheritedVelocityScale = 0.5;
        isVisible                = true;
        soundId                        = soundjetHeavy;
        rotationPeriod        = 0;
        lightRange                = 1.0;
        lightColor                = {1.0, 0.25,0.25};
};

BulletData flier2bullet
{	bulletShapeName = "Bullet.DTS";
	explosionTag = bulletExp0;
	expRandCycle	= 3;
	mass = 1.75;
	bulletHoleIndex = 0;
	ExplosionRadius = 3;
	damageClass = 0;
	damageValue = 0.10;
	damageType = $BulletDamageType;
	aimDeflection = 0.006;
	muzzleVelocity = 550.0;
	totalTime = 0.30;
	inheritedVelocityScale = 0.75;
	isVisible = False;
	tracerPercentage = 0.5;
	tracerLength = 10;
	detachFromShooter = false;
	rotationPeriod = 0;
	lightRange = 0.0;
	lightColor = {1.0, 0.25,0.25};
};

RocketData FlameLarge
{
   bulletShapeName  = "plasmabolt.dts";
   explosionTag     = fireExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.05;
   damageType       = $FlameDamageType;

   explosionRadius  = 3.0;
   kickBackStrength = 10.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;
   totalTime        = 3.0;
   liveTime         = 4.0;
   lightRange         = 10.0;
   lightColor         = { 1, 1, 0 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plasmabolt.dts";
   smokeDist   = 1.0;

   soundId = SoundJetHeavy;
};

GrenadeData ImplosionShell
{
   bulletShapeName    = "armorkit.dts";

  explosionTag       = mineExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 0.1;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.6;
   damageType         = $ShrapnelDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 450;
   totalTime          = 37.0;    // special meaning for grenades...
   liveTime           = 5.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "plasmatrail.dts";
};
function ImplosionShell::onAdd(%this)
{
	schedule("DeployISHandgrenades(" @ %this @ " , 5);",1.0,%this);
}

function DeployISHandgrenades(%this, %count) 
{
	if(%count && %this)
	{
		%obj = newObject("","Mine","MDHandgrenade1");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-5,true);
		%obj = newObject("","Mine","MDHandgrenade2");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-7.5,false);
		%obj = newObject("","Mine","MDHandgrenade3");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,5,false);
		%obj = newObject("","Mine","MDHandgrenade4");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,7.5,true);
		%obj = newObject("","Mine","MDHandgrenade5");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-1,false);

		%count = 2;
	}
}

GrenadeData ImplosionShellx
{
   bulletShapeName    = "armorkit.dts";

  explosionTag       = mineExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 0.1;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.6;
   damageType         = $ShrapnelDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 450;
   totalTime          = 37.0;    // special meaning for grenades...
   liveTime           = 5.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "plasmatrail.dts";
};

function ImplosionShellx::onAdd(%this)
{
	schedule("DeployISHandgrenadeses(" @ %this @ " , 5);",1.0,%this);
}

function DeployISHandgrenadeses(%this, %count) 
{
	if(%count && %this)
	{
		%obj = newObject("","Mine","MDHandgrenade1");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-5,true);
		%obj = newObject("","Mine","MDHandgrenade2");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-7.5,false);
		%obj = newObject("","Mine","MDHandgrenade3");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,5,false);
		%obj = newObject("","Mine","MDHandgrenade4");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,7.5,true);
		%obj = newObject("","Mine","MEHandgrenade5");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-1,false);
		%obj = newObject("","Mine","MEHandgrenade1");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-5,true);
		%obj = newObject("","Mine","MEHandgrenade2");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-7.5,false);
		%obj = newObject("","Mine","MEHandgrenade3");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,5,false);
		%obj = newObject("","Mine","MEHandgrenade4");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,7.5,true);
		%obj = newObject("","Mine","MEHandgrenade5");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-1,false);
		%obj = newObject("","Mine","MHandgrenade1");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-5,true);
		%obj = newObject("","Mine","MHandgrenade2");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-7.5,false);
		%obj = newObject("","Mine","MHandgrenade3");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,5,false);
		%obj = newObject("","Mine","MHandgrenade4");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,7.5,true);
		%obj = newObject("","Mine","MHandgrenade5");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-1,false);

		%count = 2;
	}
}

GrenadeData ImplosionShell2
{
   bulletShapeName    = "shockwave_large.dts";

  explosionTag       = grenadeExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 0.1;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.0;
   damageType         = $MortarDamageType;

   explosionRadius    = 20;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 450;
   totalTime          = 37.0;    // special meaning for grenades...
   liveTime           = 5.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "plasmatrail.dts";
};

function ImplosionShell2::onAdd(%this)
{
	schedule("DeployGBHandgrenades(" @ %this @ " , 5);",1.0,%this);
}

function DeployGBHandgrenades(%this, %count) 
{
	if(%count && %this)
	{
		%obj = newObject("","Mine","MHandgrenade1");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-5,true);
		%obj = newObject("","Mine","MHandgrenade2");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-7.5,false);
		%obj = newObject("","Mine","MHandgrenade3");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,5,false);
		%obj = newObject("","Mine","MHandgrenade4");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,7.5,true);
		%obj = newObject("","Mine","MHandgrenade5");
		addToSet("MissionCleanup", %obj);
		GameBase::throw(%obj,%this,-1,false);
		%count = 2;
	}
}

BulletData PulseBolt
{
   bulletShapeName    = "enex.dts";
   explosionTag       = turretExp;
   mass               = 0.05;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.3;
   damageType         = $PulseDamageType;

   explosionRadius    = 2.5;
   muzzleVelocity     = 375.0;
   totalTime          = 10.0;
   liveTime           = 9.9;
   isVisible          = True;

   rotationPeriod = 15;
};

LightningData turretCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 40.0;
   coneAngle        = 35.0;
   damagePerSec      = 0.06;
   energyDrainPerSec = 60.0;
   segmentDivisions = 4;
   numSegments      = 5;
   beamWidth        = 0.125;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

function Lightning::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
   %damVal = %timeSlice * %damPerSec;
   %enVal  = %timeSlice * %enDrainPerSec;

// Added Hack to Make Magnetic Damage Engage - *IX*Savage1 
   if(%damPerSec > 0.06) 
   	GameBase::applyDamage(%target, $MagneticDamageType, %damVal, %pos, %vec, %mom, %shooterId);
   else
   	GameBase::applyDamage(%target, $ElectricityDamageType, %damVal, %pos, %vec, %mom, %shooterId);

   %energy = GameBase::getEnergy(%target);
   %energy = %energy - %enVal;
   if (%energy < 0) {
      %energy = 0;
   }
   GameBase::setEnergy(%target, %energy);
}

RepairEffectData reassemblerBolt
{
   bitmapName       = "repairadd.bmp";
   boltLength       = 50.0;
   segmentDivisions = 4;
   beamWidth        = 0.125;

   updateTime   = 150;
   skipPercent  = 0.6;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.85, 0.25, 0.25 };
};

function reassemblerBolt::onAcquire(%this, %player, %target)
{
	%client = Player::getClient(%player);

	if (%target == %player) {
	   %player.repairTarget = -1;
		if (GameBase::getDamageLevel(%player) != 0) {
			%player.repairRate = 0.2;
			%player.repairTarget = %player;
			Client::sendMessage(%client, 0, "AutoRepair On");
		}
		else {
			Client::sendMessage(%client,0,"Nothing in range");
			Player::trigger(%player, $WeaponSlot, false);
			return;
		}
	}
	else {
      %player.repairTarget = %target;
		%player.repairRate   = 0.15;
		if (getObjectType(%player.repairTarget) == "Player") {
			%rclient = Player::getClient(%player.repairTarget);
			%name = Client::getName(%rclient);
		}
		else { 
			%name = GameBase::getMapName(%target);
			if(%name == "") {
				%name = (GameBase::getDataName(%player.repairTarget)).description;
			}
		}
		if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
			Client::sendMessage(%client,0,%name @ " isn't damaged");
			Player::trigger(%player,$WeaponSlot,false);
			%player.repairTarget = -1;
			return;
		}
		if (getObjectType(%player.repairTarget) == "Player") {
			Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
		}
		Client::sendMessage(%client,0,"Repairing " @ %name);
	}
	%rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
	GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function reassemblerBolt::onRelease(%this, %player)
{
	%object = %player.repairTarget;
	if (%object != -1) {
		%client = Player::getClient(%player);
		if (%object == %player) {
			Client::sendMessage(%client,0,"AutoRepair Off");
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Client::sendMessage(%client,0,"Repair Done");
			}
			else {
				Client::sendMessage(%client,0,"Repair Stopped");
			}
		}
		%rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;
      
		GameBase::setAutoRepairRate(%object,%rate);
	}
}

function reassemblerBolt::checkDone(%this, %player)
{
	if (Player::isTriggered(%player,$WeaponSlot) && 
       Player::getMountedItem(%player,$WeaponSlot) == reassembler &&
		 %player.repairTarget != -1) {
		%object = %player.repairTarget;
		if (%object == %player) {
			if (GameBase::getDamageLevel(%player) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
	}
}

function SuperRBolt::onAcquire(%this, %player, %target)
{
	%client = Player::getClient(%player);

	if (%target == %player) {
	   %player.repairTarget = -1;
		if (GameBase::getDamageLevel(%player) != 0) {
			%player.repairRate = 0.6;
			%player.repairTarget = %player;
			Client::sendMessage(%client, 0, "AutoRepair On");
		}
		else {
			Client::sendMessage(%client,0,"Nothing in range");
			Player::trigger(%player, $WeaponSlot, false);
			return;
		}
	}
	else {
      %player.repairTarget = %target;
		%player.repairRate   = 0.4;
		if (getObjectType(%player.repairTarget) == "Player") {
			%rclient = Player::getClient(%player.repairTarget);
			%name = Client::getName(%rclient);
		}
		else { 
			%name = GameBase::getMapName(%target);
			if(%name == "") {
				%name = (GameBase::getDataName(%player.repairTarget)).description;
			}
		}
		if (GameBase::getDamageLevel(%player.repairTarget) == 0) {
			Client::sendMessage(%client,0,%name @ " isn't damaged");
			Player::trigger(%player,$WeaponSlot,false);
			%player.repairTarget = -1;
			return;
		}
		if (getObjectType(%player.repairTarget) == "Player") {
			Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
		}
		Client::sendMessage(%client,0,"Repairing " @ %name);
	}
	%rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
	GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function SuperRBolt::onRelease(%this, %player)
{
	%object = %player.repairTarget;
	if (%object != -1) {
		%client = Player::getClient(%player);
		if (%object == %player) {
			Client::sendMessage(%client,0,"AutoRepair Off");
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Client::sendMessage(%client,0,"Repair Done");
			}
			else {
				Client::sendMessage(%client,0,"Repair Stopped");
			}
		}
		%rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;
      
		GameBase::setAutoRepairRate(%object,%rate);
	}
}

function SuperRBolt::checkDone(%this, %player)
{
	if (Player::isTriggered(%player,$WeaponSlot) && 
       Player::getMountedItem(%player,$WeaponSlot) == AODSuperRGun &&
		 %player.repairTarget != -1) {
		%object = %player.repairTarget;
		if (%object == %player) {
			if (GameBase::getDamageLevel(%player) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
		else {
			if (GameBase::getDamageLevel(%object) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
	}
}

RocketData HeavyRocke
{
   bulletShapeName  = "rocket.dts";
   explosionTag     = boltexp5;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MissileDamageType;

   explosionRadius  = 9.5;
   kickBackStrength = 250.0;
   muzzleVelocity   = 150.0;
   terminalVelocity = 200.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "smoke.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

GrenadeData TeleportShock 
{ 
	bulletShapeName = "breath.dts";
 	explosionTag = TeleportExp;
 	collideWithOwner = false;
 	ownerGraceMS = 500;
 	collisionRadius = 0.0;
 	mass = 0.0;
 	elasticity = 0.1;
 	damageClass = 0;
 	damageValue = 0.01;
 	damageType = $NullDamageType;
 	explosionRadius = 10;
 	kickBackStrength = 0.0;
 	maxLevelFlightDist = 1;
 	totalTime = 0.05;
 	liveTime = 0.05;
 	projSpecialTime = 0.05;
 	inheritedVelocityScale = 1.0;
 	smokeName = "breath.dts";
 };

BulletData PlasmaBolt2
{
   bulletShapeName    = "plasmabolt.dts";
   explosionTag       = plasmaExp;

   damageClass        = 1;
   damageValue        = 0.5;
   damageType         = $PlasmaDamageType;
   explosionRadius    = 4.0;

   muzzleVelocity     = 96.0;
   totalTime          = 3.0;
   liveTime           = 2.0;
   lightRange         = 3.0;
   lightColor         = { 1, 1, 0 };
   inheritedVelocityScale = 0.3;
   isVisible          = True;

   soundId = SoundJetLight;
};

#Mitzi Blast Definitions
#Forces


RocketData MBoost0 //aka Fake Shot
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 0.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBoost64
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 64.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBoost128
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 128.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBoost255
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 255.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBoost512
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBoost768
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 768.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBoost1024 // aka Super Shot (whoa)
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 16;
   kickBackStrength = 1024.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "shotgunex.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBlast0
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 0.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBlast64
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 64.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBlast128
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 128.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBlast255
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 255.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBlast512
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 512.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBlast768
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 768.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MBlast1024
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.5;
   damageType       = $MBDamageType;

   explosionRadius  = 16;
   kickBackStrength = 1024.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 115.0;
   acceleration     = 5.0;
   totalTime        = 10.0;
   liveTime         = 11.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};

RocketData MNull0
{
   bulletShapeName  = "shield_large.dts";
   explosionTag     = ionExp;
   collisionRadius  = 0.0;
   mass             = 0.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $NullDamageType;

   explosionRadius  = 0;
   kickBackStrength = 0.0;
   muzzleVelocity   = 0.0;
   terminalVelocity = 0.0;
   acceleration     = 0.0;
   totalTime        = 10.0;
   liveTime         = 10.0;
   lightRange       = 5.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "fusionbolt.dts";
   smokeDist   = 15;

   soundId = SoundELFIdle;
};
LaserData FlashBeam
{
   laserBitmapName   = "smoke01.bmp";
   hitName           = Undefined;
   damageConversion  = 0;
   baseDamageType    = 0;

   beamTime          = 0.5;

   lightRange        = 12.0;
   lightColor        = { 1, 1, 1 };

   detachFromShooter = false;
   hitSoundId        = Undefined;
};
