// --	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	------
// ClanMatch.cs  						|*|w00|*|Grey '02 
//
//	This file Contains the Code for the Clan Match Initiator
// 
//	Credits: [GL]VRWarper
// ----------------------------------------------------------------------------

function ClanMatch::LoadMatch()
{
	echo("Loading Clan Match");
	MessageAll(1, $AdminBotName@": Clan Match Mode Commencing. . . ~wmine_act.wav");
	MessageAll(1, $AdminBotName@": "@$Clan[1]@" vs. "@$Clan[2]);
	MessageAll(1, $AdminBotName@": "@$Clan[TeamNum]@" members per team. ~wmine_act.wav");
	schedule("ClanMatch::DeAssignTeams();", 2); 
}

function ClanMatch::CheckVariables(%clientId)
{
	if($Clan[1] == "-1")
		Client::SendMessage(%clientId, 1, $AdminBotName@": You must select a Clan Tag for the match.");
	else if($Clan[1] != "-1" && $Clan[2] == "-1")
		Client::SendMessage(%clientId, 1, $AdminBotName@": You must select another Clan Tag for the match.");
	else if($Clan[1] != "-1" && $Clan[2] != "-1" && $Clan[TeamNum] == "-1")
		Client::SendMessage(%clientId, 1, $AdminBotName@": You must select the number of players per Clan.");
	else if($Clan[1] != "-1" && $Clan[2] != "-1" && $Clan[TeamNum] != "-1")
	{
		MessageAll(1, $adminbotname@": Clan Match Has Been Called. Loading Code...");
		$ClanMatch[Started] = true;
		%TeamLimit = $Clan[TeamNum] * 3;
		ClanMatch::ChangeServerSettings(%TeamLimit);
	}
}

function ClanMatch::ChangeServerSettings(%TeamLimit)
{
	ClanMatch::SaveCurrentSettings();

	$Server::MaxPlayers = %TeamLimit;
	$Server::teamName[0] = $Clan[1];
	$Server::teamName[1] = $Clan[2];
	server::storedata();
	%mis = "BlastSide";
	schedule("Server::LoadMission("@%mis@");", 5);
}

function ClanMatch::SaveCurrentSettings()
{
	$ClanMatch::PrevMaxPlayers = $Server::MaxPlayers;
	$ClanMatch::TeamNameB4ClanMatch[0] = $Server::teamName[0];
	$ClanMatch::TeamNameB4ClanMatch[1] = $Server::teamName[1];
	$ClanMatch::OriginalMission = $missionName;
	MessageAll(1, $adminbotname@": Current Server Settings Saved. ~wmine_act.wav");
}

function ClanMatch::ReloadSettings()
{
	$Clan[Score1] = 0;
	$Clan[Score2] = 0;
	$ClanMatch[Started] = false;
	$Server::teamName[0] = $ClanMatch::TeamNameB4ClanMatch[0];
	$Server::teamName[1] = $ClanMatch::TeamNameB4ClanMatch[1];
	$Server::MaxPlayers = $ClanMatch::PrevMaxPlayers;
	MessageAll(1, $adminbotname@": Server Settings Reloaded. Executing load sequence... ~wmine_act.wav");
	schedule("Server::LoadMission("@$ClanMatch::OriginalMission@");", 5);
}
	
function ClanMatch::EnterObs(%client)
{
	if(!$matchStarted)
      	return;
	
	Client::SendMessage(%client, 3, $adminbotname@": Forcing You Into Observer Mode.");
		
   	%player = Client::getOwnedObject(%client);

   	if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player))
   	{
		playNextAnim(%client);
	   	Player::kill(%client);
   	}

	Observer::enterObserverMode(%client);
}

function ClanMatch::DeAssignTeams()
{
	MessageAll(1, $AdminBotName@": De-Assigning All Team Members... ~wmine_act.wav");

	for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
	{
		ClanMatch::EnterObs(%cl);
	}

	schedule("ClanMatch::ReAssignTeams();", 2);
}

function ClanMatch::ReAssignTeams()
{
	MessageAll(1, $AdminBotName@": Re-Assigning All Team Members... ~wmine_act.wav");

	for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
	{
		ClanMatch::AssignPlayerByTeam(%cl);
	}
}

function ClanMatch::AssignPlayerByTeam(%playerId)
{
	%name = Client::getName(%playerId);
   
	ClanMatch::CheckNumberInTeam(%playerId);

	if((String::findSubStr(%name, $Clan[1]) != "-1"))
	{	
		if($ClanMatchNumTeamPlayers[0] < $Clan[TeamNum])
			ClanMatch::ChangeSpawn(%playerId, 0, false);
		else
			ClanMatch::EnterObs(%playerId);
	}
	else if((String::findSubStr(%name, $Clan[2]) != "-1"))
	{
		if($ClanMatchNumTeamPlayers[1] < $Clan[TeamNum])
			ClanMatch::ChangeSpawn(%playerId, 1, false);
		else
			ClanMatch::EnterObs(%playerId);
	}
	else if((String::findSubStr(%name, $Clan[1]) != "-1"))
	{
		if($ClanMatchNumTeamPlayers[0] >= $Clan[TeamNum])
			ClanMatch::EnterObs(%playerId);
	}
	else if((String::findSubStr(%name, $Clan[2]) != "-1"))
	{
		if($ClanMatchNumTeamPlayers[1] >= $Clan[TeamNum])
			ClanMatch::EnterObs(%playerId);
	}
	else 
		schedule("SHKickClient(" @ %playerId @ ");",0.5,%playerId);
}
			
function ClanMatch::ChangeSpawn(%clientId, %team, %eventeams)
{
	if(%team == -1)
	{
		Game::resetScores(%clientId);	
		Game::refreshClientScore(%clientId);
		return;
	}

	%player = Client::getOwnedObject(%clientId);

	if(%player != -1 && getObjectType(%player) == "Player" && !Player::isDead(%player)) 
	{
		playNextAnim(%clientId);
		Player::kill(%clientId);
	}
	
	GameBase::setTeam(%clientId, %team);		
	Client::setControlObject(%clientId, -1);
	Game::playerSpawn(%clientId, false);

	if(%eventeams == "true")
		ClanMatch::SortTeams();
	
}

function ClanMatch::BuildObjectives()
{
	$Clan[Mission1] = "";
	$Clan[Mission2] = "";
	$Clan[Mission3] = "";

	if($missionComplete) 
   	{
		saveall();
           
		for(%i = -1; %i < getNumTeams(); %i++)
            {
			objective::displayBitmap(%i,0);
			if($Clan[Score1] > $Clan[Score2])
			{
				if($Clan[Score1] == 1)
					Team::setObjective(%i, 1, "<F5>           Your team won the Clan-Match with " @ $Clan[Score1] @ " point!");
				else
					   Team::setObjective(%i, 1, "<F5>           Your team won the Clan-Match with " @ $Clan[Score1] @ " points!");
			}
			else if($Clan[Score1] < $Clan[Score2])
			{
				if($Clan[Score1] == 1)
					Team::setObjective(%i, 1, "<F5>           Your team won the Clan-Match with " @ $Clan[Score2] @ " point!");
				else
					Team::setObjective(%i, 1, "<F5>           Your team won the Clan-Match with " @ $Clan[Score2] @ " points!");
			}
			else if($Clan[Score1] == $Clan[Score2])
			{
				if($Clan[Score1] == 1)
					Team::setObjective(%i, 1, "<F5>           The Clan-Match ended in a tie. Each team had " @ $Clan[Score1] @ " point!");
				else
					   Team::setObjective(%i, 1, "<F5>           The Clan-Match ended in a tie. Each team had " @ $Clan[Score1] @ " points!");
			}
		}

		Team::setObjective(%i, 2, " ");
						
		%linenum = 11;
		%numClients = getNumClients();
		for(%k = 0 ; %k < %numClients; %k++) 
		{	
			%clientList[%k] = getClientByIndex(%k);
			%doIt = 1;
			while(%doIt == 1) 
			{
				%doIt = "";								
				for(%k= 0 ; %k < %numClients; %k++) 
				{
					if((%clientList[%k]).score < (%clientList[%k+1]).score) 
					{
						   %hold = %clientList[%k];
						   %clientList[%k] = %clientList[%k+1];
						   %clientList[%k+1] = %hold;
						   %doIt = 1;
					}
			  	}
			 }

			%c = 0;
			Team::setObjective(%i, %lineNum++, "<L36>Score\t\tKills\t\tDeaths\t\tRatio\t\t");					 
			while(%c < %numClients) 
			{
				(%clientList[%c]).ratio = getEfficiencyRatio(%clientList[%c]);			
				Team::setObjective(%i, %lineNum++, "<L2><f2>"@(%c + 1) @ ". " @ Client::getName(%clientList[%c]) @ "<L36><f0>" @ (%clientList[%c]).score @ "\t\t\t\t" @ (%clientList[%c]).ScoreKills @ "\t\t\t" @ (%clientList[%c]).ScoreDeaths @ "\t\t\t\t" @ (%clientList[%c]).ratio @ "%\t\t\t");
				%lastRatio = (%clientList[%index]).score;
				%c++;
			}  
		}  
    }
    else
    {
        	for(%i = -1; %i < getNumTeams(); %i++)
        	{
			objective::displayBitmap(%i,0);
		  	Team::setObjective(%i, 1,"<f5>Mission Completion:");
		    	Team::setObjective(%i, 2,"<f1>   - " @ $teamScoreLimit @ " points needed to win the mission.");
		}
    }
	
    	if(!$Server::timeLimit)
       	%str = "<f1>   - No time limit on the game.";
    	else if($timeLimitReached)
       	%str = "<f1>   - Time limit reached.";
   	else
		if($missionComplete)
    		{
    	   		%time = getSimTime() - $missionStartTime;
    	   		%minutes = Time::getMinutes(%time);
    	   		%seconds = Time::getSeconds(%time);

    	   		if(%minutes < 10)
    	      		%minutes = "0" @ %minutes;
    	   		if(%seconds < 10)
    	     			%seconds = "0" @ %seconds;
    	   
			%str = "<f1>   - Total match time: " @ %minutes @ ":" @ %seconds;
    		}
    		else
    	    		%str = "<f1>   - Time remaining: " @ floor($Server::timeLimit - (getSimTime() - $missionStartTime) / 60) @ " minutes.";
    	
	for(%i = -1; %i < getNumTeams(); %i++)
      {
	  	Team::setObjective(%i, 3, " ");
  		Team::setObjective(%i, 4, "<f5>Mission Information:");
		Team::setObjective(%i, 5, "<f1>   - Mission Name: " @ $missionName); 
            Team::setObjective(%i, 6, %str);
	}	
}

function ClanMatch::CheckTeamSelector(%clientId)
{
	%name = Client::getName(%clientId);
	for(%i = 1; %i < 3; %i++)
	{
		if((String::findSubStr(%name, $Clan[%i]) != "-1"))
		{
			%clientId.isclanmember = true;
			if(%count == "" || %count == "0")
				%count = 1;
			else 
				%count++;
			if(%count == "1")
			{
				echo($AdminBotName@": Member of "@$Clan[%i]@" team has connected. Assigning team...");
				MessageAll(1, $AdminBotName@": Member of "@$Clan[%i]@" team has connected. Assigning team... ~wmine_act.wav");
			}
		}			
	}
	if(!clientId.isclanmember)
			ClanMatch::KickNonMember(%clientId);
}

function ClanMatch::KickNonMember(%clientId)
{
	if(%sayit == "" || %sayit == "0")
		%sayit = 1;
	else
		%sayit++;

	if(%sayit == "1" && !%clientId.isclanmember)
	{
		MessageAll(1, $AdminBotName@": Client has connected whom is not in match. Kicking. . .");
		schedule("SHKickClient(" @ %clientid @ ");",0.5,%clientid);
	}
}
