; ZLib v1.6
.nolist
	.org	$0000

#include	"joeti83.inc"

#define	data	cmdshad+38	; 2 bytes of data
.list

	.dw	beep	; beep 0
	.dw	sprite	; draw a sprite 1
	.dw	rand	; random number 2
	.dw	getbit	; get the bit for a pixel 3
	.dw	detect	; detect a program in the vat 4
	.dw	error
	.dw	decomp	; decompress level data 6
	.dw	error
	.dw	error
	.dw	error
	.dw	error
	.dw	error
	.dw	getpix	; find a pixel C
	.dw	hiscr	; check for/set high score D
	.dw	error
	.dw	version

;---------= Make a sound =---------
; c=frequency, b=duration
beep:	di
	ld	e,$D0
beepl1:	ld	a,c
beepl2:	dec	a
	jr	nz,beepl2
	ld	a,e
	xor	%00000011
	ld	e,a
	out	(0),a
	djnz	beepl1
	ei
error:	ret

;---------= XOR a sprite =---------
; b=size of sprite
; l=yc
; a=xc
; ix holds pointer
sprite:	ld	e,l
	ld	h,$00
	ld	d,h
	add	hl,de
	add	hl,de
	add	hl,hl
	add	hl,hl
	ld	e,a
	and	$07
	ld	c,a
	srl	e
	srl	e
	srl	e
	add	hl,de
	ld	de,gbuf
	add	hl,de
sl1:	ld	d,(ix)
	ld	e,$00
	ld	a,c
	or	a
	jr	z,sl3
sl2:	srl	d
	rr	e
	dec	a
	jr	nz,sl2
sl3:	ld	a,(hl)
	xor	d
	ld	(hl),a
	inc	hl
	ld	a,(hl)
	xor	e
	ld	(hl),a
	ld	de,$0B
	add	hl,de
	inc	ix
	djnz	sl1
	ret

;---------= Random number generator =---------
; input b=upper bound
; ouput a=answer 0<=a<b
; all registers are preserved except: af and bc
rand:	push	hl
	push	de
	ld	hl,(data)
	ld	a,r
	ld	d,a
	ld	e,(hl)
	add	hl,de
	add	a,l
	xor	h
	ld	(data),hl
	ld	hl,0
	ld	e,a
	ld	d,h
randl:	add	hl,de
	djnz	randl
	ld	a,h
	pop	de
	pop	hl
nomore:	ret

;---------= Get location of a pixel =---------
; input:	e=y coordinate
;		a=x coordinate
; output:	a holds data for pixel (e.g. %00100000)
;		hl->byte where pixel is on the gbuf
getpix:	ld	d,$00
	ld	h,d
	ld	l,e
	add	hl,de
	add	hl,de
	add	hl,hl
	add	hl,hl
	ld	de,gbuf
	add	hl,de

;---------= Get the bit for a pixel =---------
; input:	a - x coordinate
;		hl - start location	; includes gbuf
; returns:	a - holds bit
;		hl - location + x coordinate/8
;		b=0
;		c=a/8
getbit:	ld	b,$00
	ld	c,a
	and	%00000111
	srl	c
	srl	c
	srl	c
	add	hl,bc
	ld	b,a
	inc	b
	ld	a,%00000001
gblp:	rrca
	djnz	gblp
	ret

;---------= Detect Program =---------
; input:
;	hl=place to start looking
;	ix->first line of data (0 terminated)
; output:
;	de=place stopped + 1
;	hl->program data (after the string)
;	z=0 if found, z=1 if not found.
;	most registers are messed up
detect:
chgwlp:	push	hl		; in case a program is found
	ld	a,(hl)		; 	but no good.
	and	%00011111
	dec	a	; 1
	jr	z,list
	cp	$0D-1	; D
	jr	z,list
	sub	4	; 5
	jr	z,list
	dec	a	; 6
	jr	z,cwchck
	pop	hl
	ret
cwchck:	dec	hl		; move to ptr (skip var type)
	ld	b,(hl)
	dec	hl
	push	hl
	ld	h,(hl)
	ld	l,b	; now we are at the program
	inc	hl	; skip file length
	inc	hl
	push	ix
	pop	de
ckprog:	ld	a,(de)
	cp	(hl)
	jr	nz,nogood
	inc	de
	inc	hl
	ld	a,(de)
	or	a
	jr	nz,ckprog
	ex	de,hl
	pop	hl	; back at the fat
	dec	hl
	ld	b,(hl)
	inc	b
snamel:	dec	hl
	djnz	snamel
	ex	de,hl
	pop	af
	xor	a
	ret
nogood:	pop	hl
list:	pop	hl
	dec	hl
	dec	hl
	dec	hl
	ld	b,(hl)
	inc	b
lnamel:	dec	hl
	djnz	lnamel
	jr	chgwlp

;---------= Decompress =---------
; input:
;	hl->compressed data
;	de->place to load data
;	b=length of compressed data
;	c=compression factor (1, 3, or 15)
; output:
;	level is decompressed
;	hl->next byte of compressed data
decomp:	di
decompLoop:
	push	bc
	ld	a,(hl)
	ex	af,af'
	ld	a,c
	ld	b,8
	cp	1
	jr	z,dcmp1
	ld	b,4
	cp	3
	jr	z,dcmp1
	ld	b,2
dcmp1:	push	bc
	ld	a,c
	ld	b,1
	cp	1
	jr	z,dcmp2
	inc	b
	cp	3
	jr	z,dcmp2
	ld	b,4
dcmp2:	ex	af,af'
dcmp3:	rlca
	djnz	dcmp3
	ld	b,a
	ex	af,af'
	ld	a,b
	and	c
	ld	(de),a
	inc	de
	pop	bc
	djnz	dcmp1
	inc	hl
	pop	bc
	djnz	decompLoop
	ret

;---------= High Score =---------
; Input: de=previous high score
;	hl=current score
; Output: hl=high score
;	z=1 (a=0) if new high score, z=0 (a=1) if not
; Registers destroyed: af, de, hl
hiscr:	push	hl
	xor	a
	sbc	hl,de
	pop	hl
	jr	z,nnhs
	jr	nc,nhs
nnhs:	ex	de,hl
	inc	a
	ret
nhs:	or	a
	ret

;---------= Get Version =---------
;Input: nothing
;Output: h=major,l=minor
version:
	ld	hl,1*256+6
	ret

.end
END