; Trig v1.0 by Joe Wingbermuehle
; 08-18-1998

	.nolist
	#include	"joeti83.inc"
	.list
	.org	$0000

; APD Buffer memory map:
; $8265 - $8281 (28 bytes)				\
; $8282 - $83FF (381 bytes, main routine storage)	 \ 768 bytes total
; $8400 - $8501 (257 bytes, table storage)		 /
; $8502 - $8565 (99 bytes)				/


;-----> Load/Start the interrupt
loaderStart:
	im	1		; make sure no other int is running
	call	clrscr
	ld	hl,messages+$9327
	push	hl
	call	puts
	pop	de		; check if the interrupt is running
	ld	hl,messages+$8282-loaderEnd
	ld	b,9
compareLoop:
	ld	a,(de)
	cp	(hl)
	jr	nz,notRunning
	inc	hl
	inc	de
	djnz	compareLoop
	ld	(messages+$8282-loaderEnd),a	; disable it if it is
	ld	hl,11*256+2
	ld	(currow),hl
	ld	hl,intoff+$9327
	jp	puts
notRunning:
	ld	hl,intstart+$9327	; load the interrupt routine
	ld	de,$8282
	ld	bc,intend-intstart
	ldir
	ld	b,1			; load the interrupt table (points to the routine)
	ld	hl,$8400
	ld	a,h
	ld	(hl),$82
	ld	d,h
	ld	e,b
	ldir
	ld	i,a		; point to the interrupt table
	im	2		; start up the interrupt
	ret		; return to TI-OS
loaderEnd:

intstart:
; this will run at $8282
	di			; disable interrupts to prevent overlapping calls
	ex	af,af'		; preserve registers using the shadow registers
	exx
	ld	a,($800A)	; check if an APD is supposed to happen
	dec	a
	jr	nz,noShutDown	; disable routine before APD
	im	1
	jr	exit
noShutDown:
	ld	hl,degree+$8282-loaderEnd	; load sprite (degree/radian)
	bit	2,(iy+0)
	jr	nz,deg
	ld	hl,radian+$8282-loaderEnd
deg:	ld	a,$20+11			; set LCD coordinates
	out	($10),a
	call	delay+$8282-loaderEnd
	ld	b,4
	ld	a,$80+60
	out	($10),a
sprdw:	call	delay+$8282-loaderEnd		; write the sprite
	ld	a,(hl)
	out	($11),a
	inc	hl
	djnz	sprdw
exit:	jp	$003A	; run normal interrupts, but skip shadow
			; register exchanges

delay:	push	hl	; short delay to give the LCD time to update
	inc	hl
	dec	hl
	pop	hl
	ret

;-----> Sprites
degree:	.db	%01100011
	.db	%01010100
	.db	%01010101
	.db	%01100011
radian:	.db	%01110110
	.db	%01010101
	.db	%01100101
	.db	%01010110

messages:
	.db	"Trig v1.0"
intend:
	.db	" by Joe"
	.db	" Wingbermuehle  "
	.db	"  Status: ON",0
intOff:	.db	"FF",0

.end
END