//      HOME-MADE TIMING ROUTINES



#define TIMER_CONTROL 0x43
#define TIMER_COUNTER 0x42
#define       PORT_PB 0x61

#include <dos.h>

unsigned char klokref;

void start_timer(void)                           {
  unsigned char p;
  //  ****** Set Speaker Timer ******
  //
  //    Latch present counter value   0 0
  //            Read-write LSB only   0 1
  //            Read-write MSB only   1 0
  //        Read-write LSB then MSB   1 1
  //                                  | |
  //                                  | | 0 0 0  mode 0
  //                                  | | 0 0 1  mode 1
  //                                  | | 0 1 0  mode 2
  //                                  | | 0 1 1  mode 3 (decrement & repeat)
  //                                  | | 1 0 0  mode 4
  //                                  | | 1 0 1  mode 5
  //                disk chan 0   0 0 | | | | |
  //(memory refresh DMA) chan 1   0 1 | | | | | 0 binary
  //           (speaker) chan 2   1 0 | | | | | 1 BCD
  //                              | | | | | | | |
outportb(TIMER_CONTROL,0xB6);//   1 0 1 1 0 1 1 0

outportb(TIMER_COUNTER,0xFF);//  counter value lo
outportb(TIMER_COUNTER,0x0F);//  counter value hi

  // ****** Start timer but do not turn speaker on  ******
  //
  //
  //                                         Send channel 2 output to speaker
  //                                               |
  //                                               | Activate channel 2 clock
  //                                               | |
  p = (inportb(PORT_PB) & 0xFC) | 1;// X X X X X X 0 1
  outport(PORT_PB,p);                             	}


void stop_timer(void)                              {
  unsigned char p;

//   Stop timer and turn speaker off
  p = inportb(PORT_PB) & 0xfc;//       X X X X X X 0 0
  outportb(PORT_PB,p);                             }


//  delay routine (skipbits sets delay exponentially)
int wate(unsigned char skipbits)                                     {
unsigned char klok, klor ,klo;

//discard the number of least significant bits being ignored.
klor = klokref >> skipbits;

  klok = inportb(TIMER_COUNTER);
  klo  = (klok >> skipbits);
  klok = inportb(TIMER_COUNTER);
  klo  = (klok >> skipbits);

if(klo != klor) {klokref = klok; return 1;}

do                                    {
  klok = inportb(TIMER_COUNTER);
  klo  = (klok >> skipbits);
  klok = inportb(TIMER_COUNTER);
  klo  = (klok >> skipbits);               } while(klo == klor);

// when the high order bits change...
klokref = klok;                       // save clock value
return 0;                                                    }


// set speaker on or off
void speaker(int flag)                             {
  int p;

  p = inportb(PORT_PB);                 // preserve the other bit settings.
  if (flag) p |= 3; else p &= 0xfd;
  outport(PORT_PB,p);                              }

