//        DAQ-BOARD DRIVERS


#include "iohost.h"
#include <dos.h>
#include <conio.h>
#include <graphics.h>
#include <process.h>
#include <stdio.h>

#define          DAC0 0x03
#define          DAC1 0x40
#define          DAC2 0x01
#define          DAC3 0x02
#define          DAC4 0x00
#define           ADC 0x82
#define     LOGIC_OUT 0x83
#define        VACANT 0XC3


void init_graphics(int gmode)                                       {

  int i, gdriver = 9, errorcode;

  /* initialize graphics mode */
  initgraph(&gdriver, &gmode, "");

  /* read result of initialization */
  errorcode = graphresult();

  if (errorcode != grOk)  /* an error occurred */              {
	 printf("Graphics error: %s\n", grapherrormsg(errorcode));
	 printf("Press any key to halt:");
	 getch();
	 exit(1);             /* return with error code */         }

// Set palette to 256 shades of grey
  for (i=0;i<64;i++)                     {
	 setrgbpalette(i<<2,i,i,i);
	 setrgbpalette((i<<2)+1,i,i+1,i);
	 setrgbpalette((i<<2)+2,i+1,i,i+1);
	 setrgbpalette((i<<2)+3,i+1,i+1,i);  }
  i=62;
  setrgbpalette(252,i,i,i);
  setrgbpalette(253,i,i+1,i);
  setrgbpalette(254,i+1,i,i+1);
  setrgbpalette(255,i+1,i+1,i);                               }


void init_centron(void)                                                  {
  //                     _________
  //                     select_in (data strobe A0)
  //                         |
  //              IRQ enable | init (data strobe A1)
  //                       | | | ________
  //             direction | | | autofeed (chip address strobe)
  //                     | | | | | ______
  //            reserved | | | | | strobe (bus extension strobe)
  //                 | | | | | | | |
  // CONTROL BITS    X X 1 0 0 1 1 1
  outportb(CONTROL_PORT, 0x27); /* Input mode, control lines inactive */ }


void write_byte(char chip_addr, char setting)                  {
  outportb(CONTROL_PORT, 0X27);        // read strobe off
  outportb(DATA_PORT, chip_addr);      // set chip address
  outportb(CONTROL_PORT, 0x07);        // output mode
  outportb(CONTROL_PORT, 0X05);        // strobe the address
  outportb(CONTROL_PORT, 0X07);
  outportb(DATA_PORT, setting);        // set the data
  outportb(CONTROL_PORT, 0X0F);        // strobe the data (input register)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0X03);        // strobe the data (output register)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);        /* input mode */        }


void prepare_byte(char chip_addr, char setting)                {
  outportb(CONTROL_PORT, 0X27);        // read strobe off
  outportb(DATA_PORT, chip_addr);      // set chip address
  outportb(CONTROL_PORT, 0x07);        // output mode
  outportb(CONTROL_PORT, 0X05);        // strobe the address
  outportb(CONTROL_PORT, 0X07);
  outportb(DATA_PORT, setting);        // set the data
  outportb(CONTROL_PORT, 0X0F);        // strobe the data (input register)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);        /* input mode */        }


void apply(void)                                               {
  outportb(CONTROL_PORT, 0x07);        // output mode
  outportb(DATA_PORT, DAC0);           // set chip address
  outportb(CONTROL_PORT, 0X05);        // strobe the address
//  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0X03);        // strobe the data (output register)
//  outportb(CONTROL_PORT, 0X07);
  outportb(DATA_PORT, DAC1);           // set chip address
  outportb(CONTROL_PORT, 0X05);        // strobe the address
//  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0X03);        // strobe the data (output register)
//  outportb(CONTROL_PORT, 0X07);
  outportb(DATA_PORT, DAC2);           // set chip address
  outportb(CONTROL_PORT, 0X05);        // strobe the address
//  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0X03);        // strobe the data (output register)
//  outportb(CONTROL_PORT, 0X07);
  outportb(DATA_PORT, DAC3);           // set chip address
  outportb(CONTROL_PORT, 0X05);        // strobe the address
//  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0X03);        // strobe the data (output register)
//  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);        /* input mode */        }


void write_word(char chip_addr, int setting)                   {
  outportb(CONTROL_PORT, 0X27);        // read strobe off
  outportb(DATA_PORT, setting&0xFF);   // prepare lo byte
  outportb(CONTROL_PORT, 0x07);        // output mode
  outportb(CONTROL_PORT, 0X06);        // bus extension strobe
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);        // input mode
  outportb(DATA_PORT, chip_addr);      // prepare output chip address
  outportb(CONTROL_PORT, 0x07);        // output mode
  outportb(CONTROL_PORT, 0X05);        // strobe the address
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);        // input mode
  outportb(DATA_PORT, setting>>8);     // prepare hi byte
  outportb(CONTROL_PORT, 0x07);        // output mode
  outportb(CONTROL_PORT, 0X0F);        // strobe the data (input register)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0X03);        // strobe the data (output register)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);        /* input mode */         }


void flash_leds(void)                     {
  write_byte(LOGIC_OUT,0x00); delay(200);
  write_byte(LOGIC_OUT,0x02); delay(200);
  write_byte(LOGIC_OUT,0x01); delay(200);
  write_byte(LOGIC_OUT,0x40); delay(200);
  write_byte(LOGIC_OUT,0x80); delay(200);
  write_byte(LOGIC_OUT,0x00); delay(200); }


void select_IO(char chip_addr)                                {
  outportb(CONTROL_PORT, 0X27);     // read strobe off
  outportb(DATA_PORT, chip_addr);   // set IO chip address
  outportb(CONTROL_PORT, 0x07);     // output mode
  outportb(CONTROL_PORT, 0X05);     // strobe address (ADC starts conversion)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);     /* input mode */          }


signed char pick_hibyte(void)                   {
  signed char sample;
  //                     _________
  //                     select_in (data strobe A0)
  //                         |
  //              IRQ enable | init (data strobe A1)
  //                       | | | ________
  //             direction | | | autofeed (chip address strobe)
  //                     | | | | | ______
  //            reserved | | | | | strobe (bus extension strobe)
  //                 | | | | | | | |
  // CONTROL BITS    X X 1 0 0 1 1 1
  outportb(CONTROL_PORT, 0X27);  // read strobe off (starts next conversion)
  outportb(CONTROL_PORT, 0X2F);   // read strobe on

  while(!inportb(STATUS_PORT)&0x08);//wait for conversion  start (lo)
  while( inportb(STATUS_PORT)&0x08);//wait for conversion finish (hi)

  sample=inportb(DATA_PORT);     // input hi byte
  return(sample);                               }


int pick_word(void)                   {
  int sample;

  outportb(CONTROL_PORT, 0X27);  // read strobe off (starts next conversion)
  outportb(CONTROL_PORT, 0X2F);  // read strobe on

  while(!inportb(STATUS_PORT)&0x08);//wait for conversion  start (lo)
  while( inportb(STATUS_PORT)&0x08);//wait for conversion finish (hi)

  sample=inportb(DATA_PORT);     // input hi byte
  outportb(CONTROL_PORT, 0X2B);  // pull BYTE line low
  sample<<=8;                    // add-in lo byte
  sample+=inportb(DATA_PORT);
  //  outportb(CONTROL_PORT, 0X2F);  // set BYTE line high
  return(sample);                       }


signed char sample_hibyte(void)                   {
  signed char sample;

  outportb(CONTROL_PORT, 0X27);     // read strobe off
  outportb(DATA_PORT, ADC);         // set IO chip address
  outportb(CONTROL_PORT, 0x07);     // output mode
  outportb(CONTROL_PORT, 0X05);     // strobe address (ADC starts conversion)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);     // input mode

  outportb(CONTROL_PORT, 0X2F);  // read strobe on

  while(!inportb(STATUS_PORT)&0x08);//wait for conversion  start (lo)
  while( inportb(STATUS_PORT)&0x08);//wait for conversion finish (hi)

  sample=inportb(DATA_PORT);     // input hi byte

/* PROTECT THE OUTPUTS:
   Put ADC in  high impedance state...
   ...in case the next CENTRONICS operation is "Output Mode"
*/ outportb(CONTROL_PORT, 0X27); // read strobe off (starts extra conversion)

  return(sample);                                  }


int sample_word(void)                   {
  int sample;

  outportb(CONTROL_PORT, 0X27);     // read strobe off
  outportb(DATA_PORT, ADC);         // set IO chip address
  outportb(CONTROL_PORT, 0x07);     // output mode
  outportb(CONTROL_PORT, 0X05);     // strobe address (ADC starts conversion)
  outportb(CONTROL_PORT, 0X07);
  outportb(CONTROL_PORT, 0x27);     // input mode

  outportb(CONTROL_PORT, 0X2F);  // read strobe on

  while(!inportb(STATUS_PORT)&0x08);//wait for conversion  start (lo)
  while( inportb(STATUS_PORT)&0x08);//wait for conversion finish (hi)

  sample=inportb(DATA_PORT);     // input hi byte
  outportb(CONTROL_PORT, 0X2B);  // pull BYTE line low
  sample<<=8;                    // add-in lo byte
  sample+=inportb(DATA_PORT);
  //  outportb(CONTROL_PORT, 0X2F);  // set BYTE line high

/* PROTECT THE OUTPUTS:
   Put ADC in  high impedance state...
   ...in case the next CENTRONICS operation is "Output Mode"
*/ outportb(CONTROL_PORT, 0X27); // read strobe off (starts extra conversion)

  return(sample);                       }
