
//  SURFACE RENDERING ROUTINE


#include <graphics.h>
#include <math.h>
#include <conio.h>


signed char z[200][200];

void plus(float *u,float *v,float *w)       {
int i;
for (i=0;i<3;i++) w[i] = u[i] + v[i]; }

void minus(float *u,float *v,float *w)       {
int i;
for (i=0;i<3;i++) w[i] = u[i] - v[i]; }

float scalar_product(float *u,float *v)       {
return(u[0]*v[0]+u[1]*v[1]+u[2]*v[2]);  }

float mod(float *u)                     {
return(sqrt(scalar_product(u,u)));  }

void vector_product(float *u,float *v,float *w)    {
w[0] = u[1]*v[2]-u[2]*v[1];
w[1] = u[2]*v[0]-u[0]*v[2];
w[2] = u[0]*v[1]-u[1]*v[0];                   }

void scalar_mul(float s,float *u,float *w)    {
int i;
for (i=0;i<3;i++) w[i] = s*u[i];        }

void scalar_div(float s,float *u,float *w)    {
int i;
for (i=0;i<3;i++) w[i] = u[i]/s;        }


void render(int tilt) {
	int i,j,  w,x,y,sheen,triangle[8];
	float s,a[3],b[3],c[3],u[3],v[3],perp[3],unit_perp[3],light[3]={0,0,255};
	float smooth[4][4];

	setviewport(340,0,639,455,0);
	clearviewport();

	// surface plot
	for (i=0;i<193;i+=2) {
	  for (j=0;j<197;j++) {

		 //copy area being processed into high-res buffer
		 for (y=0;y<4;y++)               {
			for (x=0;x<4;x++)           {
			  smooth[y][x]=z[i+(y*2)][j+x]; } }

		 //get the vertices of a surface triangle, top of row
		 w=7; //weighting given to point itself.
		 a[0] = j  ;  a[1] = i  ;
		 a[2]=( smooth[0][0] + smooth[0][1] + smooth[0][2]
		 + smooth[1][0]+w*smooth[1][1] + smooth[1][2]
		 + smooth[2][0] + smooth[2][1] + smooth[2][2])/(8+w);

		 b[0] = j+1;  b[1] = i  ;
		 b[2]=( smooth[0][1] + smooth[0][2] + smooth[0][3]
		 + smooth[1][1]+w*smooth[1][2] + smooth[1][3]
		 + smooth[2][1] + smooth[2][2] + smooth[2][3])/(8+w);

		 c[0] = j+1;  c[1] = i+2;
		 c[2]=( smooth[1][1] + smooth[1][2] + smooth[1][3]
		 + smooth[2][1]+w*smooth[2][2] + smooth[2][3]
		 + smooth[3][1] + smooth[3][2] + smooth[3][3])/(8+w);

		 //get the vectors representing two sides
		 minus(b,a,u);
		 minus(c,a,v);

		 //get the perpendicular with unit magnitude.
		 vector_product(u,v,perp);
		 s = mod(perp);
		 scalar_div(s,perp,unit_perp);
		 sheen=scalar_product(unit_perp,light);

//       putpixel(j+100,100-z[i][j]+i/4,z[i][j]*4);

       //draw triangle
		 triangle[0] = a[0]+40; triangle[1] = 172-a[2]+tilt*i/2;
		 triangle[2] = b[0]+40; triangle[3] = 172-b[2]+tilt*i/2;
		 triangle[4] = c[0]+40; triangle[5] = 172-c[2]+tilt*(i+1)/2;
		 triangle[6] = a[0]+40; triangle[7] = 172-a[2]+tilt*i/2;

		 setcolor(sheen);
		 setlinestyle(0,0xFFFF,1);
		 setfillstyle(1,sheen);
		 fillpoly(4,triangle);

		 //get the vertices of the corresponding bottom triangle
		 b[0] = j  ;  b[1] = i+2;
		 b[2]=( smooth[1][0] + smooth[1][1] + smooth[1][2]
		 + smooth[2][0]+w*smooth[2][1] + smooth[2][2]
		 + smooth[3][0] + smooth[3][1] + smooth[3][2])/(8+w);

		 //get the vectors representing two sides
		 minus(b,a,u);
		 minus(c,a,v);

		 //get the perpendicular with unit magnitude.
		 vector_product(v,u,perp);
		 s = mod(perp);
		 scalar_div(s,perp,unit_perp);
		 sheen=scalar_product(unit_perp,light);

//       putpixel(j+100,100-z[i][j]+i/4,z[i][j]*4);

		 //draw triangle
		 triangle[0] = a[0]+40; triangle[1] = 172-a[2]+tilt*i/2;
		 triangle[2] = b[0]+40; triangle[3] = 172-b[2]+tilt*(i+1)/2;
		 triangle[4] = c[0]+40; triangle[5] = 172-c[2]+tilt*(i+1)/2;
		 triangle[6] = a[0]+40; triangle[7] = 172-a[2]+tilt*i/2;

		 setcolor(sheen);
		 setlinestyle(0,0xFFFF,1);
		 setfillstyle(1,sheen);
		 fillpoly(4,triangle);

		 if(i==192) { setcolor(80*!(j&1));
	 line(b[0]+40,173-b[2]+tilt*(i+1)/2,b[0]+40,420); }
			       }   }

setviewport(0,0,319,255,0);

}

